package cn.com.duiba.nezha.alg.example.util;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.example.constant.ProjectConstant;
import cn.com.duiba.nezha.alg.example.util.conf.JedisPoolConf;
import cn.com.duiba.nezha.alg.model.DeepModel;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class StdCoderSaveBo {
    static Logger logger = LoggerFactory.getLogger(StdCoderSaveBo.class);


    public static JedisUtil nzJedisUtil = new JedisUtil(JedisPoolConf.jedisConfig);


    public static JedisUtil actJedisUtil = new JedisUtil(JedisPoolConf.actJedisConfig);

    public static JedisUtil dpaActJedisUtil = new JedisUtil(JedisPoolConf.dpaActJedisConfig);

    public static JedisUtil materialJedisUtil = new JedisUtil(JedisPoolConf.materialJedisConfig);

    public static JedisUtil adxJedisUtil = new JedisUtil(JedisPoolConf.adxJedisConfig);


    public static JedisUtil getJedisUtil(String redisUtil) {
        JedisUtil ret = null;


        //其他
        if (redisUtil.equals("default")) {
            ret = nzJedisUtil;
        }

        //活动
        if (redisUtil.equals("activity")) {
            ret = actJedisUtil;
        }
        //素材
        if (redisUtil.equals("slot_material")) {
            ret = materialJedisUtil;
        }
        if (redisUtil.equals("adx")) {
            ret = adxJedisUtil;
        }

        // apa活动
        if (redisUtil.equals("dpa_activity")) {
            ret = dpaActJedisUtil;
        }

        if (ret == null) {
            logger.error("getJedisUtil error with type ="+redisUtil);
        }
        return ret;
    }


    /**
     * @param modelCoderId
     * @param model
     * @return
     */
    public static void saveModelByKeyToJedis(String redisUtil, String modelCoderId, DeepModel model, String key) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelCoderId, model)) {
            System.out.println("saveModelByKeyToJedis empty,modelCoderId=" + modelCoderId);
            return;
        }
        try {
            JedisUtil jedis = getJedisUtil(redisUtil);

            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(model);
            jedis.setex(key, value, ProjectConstant.WEEK_1_EXPIRE);
            updateTime(key, jedis);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * @param key
     * @return
     */
    public static DeepModel getCoderByKeyFromJedis(String redisUtil, String key) {
        DeepModel ret = null;

        if (AssertUtil.isAnyEmpty(key)) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + key);
            return ret;
        }
        try {

            JedisUtil jedis = getJedisUtil(redisUtil);

            System.out.println("read model with key=" + key);
            // 保存
            String ret1 = jedis.get(key);
            // 解压
            if (ret1 != null) {
                ret = JSON.parseObject(ret1, DeepModel.class);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }


    public static void updateTime(String modelKey, JedisUtil jedisUtil) {
        String updateTimeKey = modelKey + "_update_time";
        String updateTime = LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS);
        jedisUtil.setex(updateTimeKey, updateTime, ProjectConstant.WEEK_1_EXPIRE);
    }

}
