package cn.com.duiba.nezha.alg.example.example.stat;

import cn.com.duiba.nezha.alg.alg.vo.ee.AdControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ee.AdExploreModel;
import cn.com.duiba.nezha.alg.alg.vo.ee.AppGroupDo;
import cn.com.duiba.nezha.alg.common.util.DateUtil;
import cn.com.duiba.nezha.alg.example.constant.ProjectConstant;
import cn.com.duiba.nezha.alg.example.util.StatSyncBo;
import cn.com.duiba.nezha.alg.example.util.conf.JedisPoolConf;
import com.alibaba.fastjson.JSON;

import java.util.HashMap;
import java.util.Map;

public class eeTest {

    public static void main(String[] args) {


        save();
        read();

    }

    public static void save() {
        Map<Long, AdExploreModel> adExploreModelMap = getAdEEModelMap();

        for (Map.Entry<Long, AdExploreModel> entry : adExploreModelMap.entrySet()) {
            Long advertId = entry.getKey();
            AdExploreModel adExploreModel = entry.getValue();
            System.out.println("save:" + JSON.toJSONString(adExploreModel));

            String key = StatSyncBo.getAdExploreModelKey(advertId);
            StatSyncBo.saveAdExploreModelToRedis(adExploreModel, key, ProjectConstant.DAY_1_EXPIRE);
        }


        String appKey = StatSyncBo.getAppGroupKey();

        AppGroupDo appGroupDo = getAppGroupDo();

        System.out.println("save:" + JSON.toJSONString(appGroupDo));

        StatSyncBo.saveAppGroupDoToRedis(appGroupDo, appKey, ProjectConstant.DAY_1_EXPIRE);


    }

    public static void read() {


        Map<Long, AdExploreModel> adExploreModelMap = getAdEEModelMap();

        for (Map.Entry<Long, AdExploreModel> entry : adExploreModelMap.entrySet()) {
            Long advertId = entry.getKey();
            String key = StatSyncBo.getAdExploreModelKey(advertId);

            AdExploreModel adExploreModel = StatSyncBo.readAdExploreModelFromRedis(key);
            System.out.println("read:" + JSON.toJSONString(adExploreModel));
        }


        String appKey = StatSyncBo.getAppGroupKey();

        AppGroupDo appGroupDo = StatSyncBo.readAppGroupDoFromRedis(appKey);

        System.out.println("read:" + JSON.toJSONString(appGroupDo));


    }


    public static Map<Long, AdExploreModel> getAdEEModelMap() {

        Map<Long, AdExploreModel> ret = new HashMap<>();

        AdExploreModel d1 = new AdExploreModel();
        d1.setAdvertId(10L);
        d1.setIsHighQualityAd(true);
        //d1.setIsJiCheng(false);
        d1.setJcRatio(1.0);
        AdControlParams a1 = new AdControlParams();
        a1.setIsEE(true);
        a1.setEeFactor(1.2);
        a1.setIsQiliang(true);
        d1.setAdEEParams(a1);

        d1.setUpdateTime(DateUtil.getCurrentTime());

        AdExploreModel d2 = new AdExploreModel();
        d2.setAdvertId(11L);
        //d2.setIsHighQualityAd(true);
        d2.setIsJiCheng(false);
        d2.setJcRatio(0.1);
        AdControlParams a2 = new AdControlParams();
        a2.setIsEE(true);
        a2.setEeFactor(1.3);
        a2.setIsQiliang(true);
        d2.setAdEEParams(a2);

        d2.setUpdateTime(DateUtil.getCurrentTime());

        AdExploreModel d3 = new AdExploreModel();
        d3.setAdvertId(12L);
        // d3.setIsHighQualityAd(true);
        d3.setIsJiCheng(true);
        //d3.setJcRatio(1.);
        AdControlParams a3 = new AdControlParams();
        //a3.setIsEE();
        a3.setEeFactor(1.5);
        a3.setIsQiliang(true);
        a3.setQlFactor(1.1);
        d3.setAdEEParams(a3);
        d3.setUpdateTime(DateUtil.getCurrentTime());

        ret.put(10L, d1);
        ret.put(11L, d2);
        ret.put(12L, d3);

        return ret;
    }

    public static AppGroupDo getAppGroupDo() {
        AppGroupDo appGroupDo = new AppGroupDo();

        Map<Long, String> map = new HashMap<>();
        map.put(1L, "a_1");
        map.put(2L, "a_2");
        map.put(3L, "a_3");

        appGroupDo.setAppGroupMap(map);
        appGroupDo.setUpdateTime(DateUtil.getCurrentTime());
        return appGroupDo;
    }
}
