package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.example.util.StdModelSave;
import cn.com.duiba.nezha.alg.model.ESMM;
import cn.com.duiba.nezha.alg.model.FFM;
import cn.com.duiba.nezha.alg.model.FM;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.enums.MutModelType;
import cn.com.duiba.nezha.alg.model.enums.PredictResultType;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import com.alibaba.fastjson.JSON;

import java.util.*;

public class ModelPredictTest {

    public static List<String> modelKeyList = Arrays.asList(
//            "mid_fm_ctr_v501",
//            "mid_fm_ctr_v502",
//            "mid_fm_ctr_v603",
////
////            "mid_fm_cvr_v501",
////            "mid_fm_cvr_v502",
//            "mid_fm_cvr_v603",
////
////            "mid_fm_ctr_v610",
////            "mid_fm_ctr_v611",
////            "mid_fm_ctr_v612",
////            "mid_fm_ctr_v614",
////            "mid_fm_cvr_v610",
////            "mid_fm_cvr_v611",
////            "mid_fm_cvr_v612", // count
////            "mid_fm_cvr_v614", //
////
////
//            "mid_fm_ctr_v003",
//            "mid_fm_ctr_v006",
//            "mid_fm_cvr_v003",
//            "mid_fm_cvr_v006",
////
            "mid_ftrl_fm_bcvr_v007"
//
//
//            "mid_ftrl_fm_ctr_v002",
//            "mid_ftrl_fm_ctr_v003",
//            "mid_ftrl_fm_ctr_v004",
//            "mid_ftrl_fm_ctr_v006",
//            "mid_ftrl_fm_ctr_v007",
////            "mid_ftrl_fm_ctr_v008",
//            "mid_ftrl_fm_ctr_v009",
//            "mid_ftrl_fm_ctr_v010",
//            "mid_ftrl_fm_ctr_v011",
////            "mid_ftrl_fm_ctr_v501",
////            "mid_ftrl_fm_ctr_v502",
//            "mid_ftrl_fm_ctr_v611",
//            "mid_ftrl_fm_ctr_v612",
//
//            "mid_ftrl_fm_cvr_v002",
//            "mid_ftrl_fm_cvr_v003",
//            "mid_ftrl_fm_cvr_v004",
//            "mid_ftrl_fm_cvr_v006",
//            "mid_ftrl_fm_cvr_v007",
////            "mid_ftrl_fm_cvr_v008",
//            "mid_ftrl_fm_cvr_v009",
//
//            "mid_ftrl_fm_cvr_v010",
//            "mid_ftrl_fm_cvr_v011",
//            "mid_ftrl_fm_cvr_v012",
////            "mid_ftrl_fm_cvr_v501",
////            "mid_ftrl_fm_cvr_v502",
//            "mid_ftrl_fm_cvr_v611",
//            "mid_ftrl_fm_cvr_v612"


    );

    public static List<String> modelKeyList2 = Arrays.asList(


//            "mid_ftrl_ffm_ctr_v001",
//            "mid_ftrl_ffm_ctr_v002",
//            "mid_ftrl_ffm_ctr_v003",
//            "mid_ftrl_ffm_ctr_v004",
            "mid_ftrl_ffm_bcvr_v004"
//            "mid_ftrl_ffm_cvr_v002",
//            "mid_ftrl_ffm_cvr_v003",
//            "mid_ftrl_ffm_cvr_v004"


    );


    public static String feature = "{\"orderId\":\"taw-188284042240239\",\"f608001\":\"0\",\"f113001\":\"04.01.0001\",\"f9913\":\"6\",\"f508002\":\"R9km\",\"f806001\":\"13\",\"f508001\":\"OPPO\",\"f806002\":\"11\",\"f806003\":\"9\",\"f806004\":\"7\",\"f603002\":\"1\",\"f603001\":\"1\",\"f110001\":\"1\",\"f502001\":\"6\",\"f502002\":\"4\",\"f611001\":\"1\",\"f505001\":\"1700-2699\",\"f606002\":\"0\",\"f606001\":\"-1\",\"f201001\":\"28867\",\"f102001\":\"02.01.0008\",\"f609001\":\"0\",\"f804004\":\"7\",\"f804003\":\"8\",\"f804002\":\"12\",\"f9930\":\"-1\",\"f804001\":\"12\",\"f9931\":\"-1\",\"f301001\":\"1034\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f108001\":\"203809\",\"advertId\":\"38454\",\"f807002\":\"11\",\"f807001\":\"12\",\"f507001\":\"2\",\"f807004\":\"7\",\"f807003\":\"9\",\"f9927\":\"-1\",\"f810001\":\"null\",\"f9928\":\"-1\",\"f810002\":\"null\",\"f9929\":\"-1\",\"f306001\":\"2\",\"f604002\":\"1\",\"f604001\":\"1\",\"f501001\":\"Android\",\"f610001\":\"0\",\"f206001\":\"262\",\"f504001\":\"OPPO R9km\",\"f601001\":\"1\",\"f601002\":\"1\",\"f303001\":\"2000\",\"f607001\":\"0\",\"f406001\":\"0\",\"f206002\":\"260\",\"f403004\":\"0\",\"f805001\":\"12\",\"f805002\":\"12\",\"f805003\":\"9\",\"f805004\":\"7\",\"f602001\":\"1\",\"f205002\":\"39\",\"f205001\":\"22\",\"f404003\":\"workother\",\"f106001\":\"10031\",\"f8807\":\"1\",\"f8803\":\"1\",\"f605001\":\"-1\",\"f605002\":\"0\",\"f101001\":\"38454\",\"f503001\":\"41\",\"time\":\"20181122065021\",\"f302001\":\"1034\",\"f602002\":\"1\"}";

    public static Map<String, String> featureIdxMap = (Map) JSON.parseObject(feature);


    public static void main(String[] args) {
        try {

            test2();
//            test1();
//            test4();

        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public static void test1() {

        List<String> printList = new ArrayList<>();

        for (String key : modelKeyList) {

            try {



                FM model = StdModelSave.getModelByKeyFromJedis(key);
                System.out.println(JSON.toJSONString(model));
                Double ret = model.predict(featureIdxMap);
                printList.add("model=" + key + ".predict = " + ret + ",model.UpdateTime = " + model.getUpdateTime() + ",model_ps = " + model.getModelId());


////
//                FM model = StdModelSave.getModelByKeyFromMD(key);
                StdModelSave.saveModelByKeyToJedis("mid_ftrl_ffm_bcvr_v004",model);



            } catch (Exception e) {
                e.printStackTrace();
            }

        }


        printList.forEach(line -> System.out.println(line));
    }


    public static void test2() throws Exception {


        List<String> printList = new ArrayList<>();

        for (String key : modelKeyList2) {

            try {

                FFM model = StdModelSave.getModelByKeyFromJedisFFM(key);
                Double ret = model.predict(featureIdxMap);
                printList.add("model=" + key + ".predict = " + ret + ",model.UpdateTime = " + model.getUpdateTime() + ",model_ps = " + model.getModelId());


                StdModelSave.saveModelByKeyToJedisFFM("mid_ftrl_ffm_cvr_v004",model);
            } catch (Exception e) {
                e.printStackTrace();
            }

        }


        printList.forEach(line -> System.out.println(line));

    }


    public static void test3() throws Exception {


        List<String> printList = new ArrayList<>();


        try {

            IModel ctrModel = StdModelSave.getModelByKeyFromMD("mid_ftrl_fm_ctr_v004");
            IModel cvrModel = StdModelSave.getModelByKeyFromMD("mid_ftrl_fm_cvr_v004");


            TFServingClient tfServingClient = new TFServingClient("10.50.201.91", 9000, "esmm-001", null);


            ESMM model = new ESMM(ctrModel, cvrModel, null, tfServingClient, tfServingClient, MutModelType.DEEP_ESMM);

            Map<String, Map<String, String>> map = new HashMap<>();
            map.put("1", featureIdxMap);

            Map<PredictResultType, Map<String, Double>> ret = model.predictCTRsAndCVRsWithTF(map);

            System.out.println(JSON.toJSONString(ret));


        } catch (Exception e) {
            e.printStackTrace();
        }


    }

    public static void test4() throws Exception {


        List<String> printList = new ArrayList<>();


        try {

            IModel ctrModel = StdModelSave.getModelByKeyFromMD("mid_ftrl_fm_ctr_v007");
            IModel cvrModel = StdModelSave.getModelByKeyFromMD("mid_ftrl_fm_cvr_v007");


            TFServingClient tfServingClient = new TFServingClient("10.50.201.91", 9000, "esmm-001", null);


            ESMM model = new ESMM(ctrModel, cvrModel, null, null, null, MutModelType.NORMAL);

            Map<String, Map<String, String>> map = new HashMap<>();

            for (int i = 0; i < 10; i++) {
                map.put("A"+i, featureIdxMap);
            }


            Map<PredictResultType, Map<String, Double>> ret = model.predictCTRsAndCVRsWithTF(map);

            System.out.println(JSON.toJSONString(ret));
            System.out.println("ctr.size = "+ret.get(PredictResultType.CTR).size());
            System.out.println("cvr.size = "+ret.get(PredictResultType.CVR).size());


        } catch (Exception e) {
            e.printStackTrace();
        }


    }

}
