package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import com.alibaba.fastjson.JSON;
import sun.nio.cs.ext.MacHebrew;

import javax.xml.bind.util.JAXBSource;
import java.util.*;
import java.util.stream.Collectors;

public class ADXShuntVolumeExample {


    public static double multipleRatio = 0.2;

    public static void main(String[] args) {

        List<Long> ideaList = Arrays.asList(101L, 102L, 103L);

        Map<Long, Double> weightMap = new HashMap<>();
        weightMap.put(101L, 0.6);
        weightMap.put(102L, 0.2);
        weightMap.put(103L, 0.2);


        for (int i = 0; i < 10; i++) {

            Map<Long, Long> ideaReqCntMap = new HashMap<>();


            for (int j = 0; j < 10000; j++) {
                List<Long> validIdeaList = getValidIdea(ideaList, ideaReqCntMap);


                Long idea = rand(validIdeaList, weightMap);

                ideaReqCntMap.put(idea, ideaReqCntMap.getOrDefault(idea, 0L) + 1L);
            }

            System.out.println("i=" + i + ",ideaReqCntMap=" + JSON.toJSONString(ideaReqCntMap));
        }
    }


    public static List<Long> getValidIdea(List<Long> ideas, Map<Long, Long> ideaReqCntMap) {

//        Long curIdea = rand2(ideas, ideaReqCntMap);
//        return ideas.stream().filter(x -> !(x.equals(curIdea) && Math.random() < multipleRatio)).collect(Collectors.toList());
//

        List<Long> ret = ideas;

        if (AssertUtil.isAnyEmpty(ideas, ideaReqCntMap)) {
            return ret;
        }

        double weightSum = 0.0;

        for (int i = 0; i < ideas.size(); i++) {
            weightSum += ideaReqCntMap.getOrDefault(ideas.get(i), 1L);
        }


        ret = new ArrayList<>();
        for (int i = 0; i < ideas.size(); i++) {

            double weightTmp = ideaReqCntMap.getOrDefault(ideas.get(i), 1L);

            if (Math.random() <= (weightTmp / weightSum) && Math.random() <= 0.8) {
                continue;
            }
            ret.add(ideas.get(i));
        }
        return ret;

    }


    public static Long rand(List<Long> ideas, Map<Long, Double> weightMap) {

        Long ret = null;

        if (AssertUtil.isAnyEmpty(ideas, weightMap)) {
            return ret;
        }

        double weightSum = 0.0;

        for (int i = 0; i < ideas.size(); i++) {
            weightSum += weightMap.getOrDefault(ideas.get(i), 0.0000001);
        }

        double rand = Math.random() * weightSum;

        double weightSumTmp = 0.0;
        for (int i = 0; i < ideas.size(); i++) {
            weightSumTmp += weightMap.getOrDefault(ideas.get(i), 0.0000001);
            if (rand <= weightSumTmp) {
                ret = ideas.get(i);
                break;
            }
        }
        return ret;
    }


    public static Long rand2(List<Long> ideas, Map<Long, Long> weightMap) {
        Map<Long, Double> map = new HashMap<>();

        weightMap.forEach((k, v) -> map.put(k, v + 0.0));

        return rand(ideas, map);
    }
}