package cn.com.duiba.nezha.alg.example.util.conf;


import cn.com.duiba.nezha.alg.example.constant.ProjectConstant;
import redis.clients.jedis.JedisPoolConfig;

/**
 * Created by pc on 2016/11/18.
 */
public class JedisPoolConf {


    public static JedisPoolConfig poolConfig;

    public static JedisConfig jedisConfig;

    public static JedisConfig actJedisConfig;

    static {
        try {
            initJedisPoolConfig();
            initJedisConfig();
            initActJedisConfig();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private static void initJedisPoolConfig() {
        poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(ProjectConstant.MAX_IDLE);
        poolConfig.setMinIdle(ProjectConstant.MIN_IDLE);
        poolConfig.setMaxTotal(ProjectConstant.MAX_TOTAL);
        poolConfig.setMaxWaitMillis(ProjectConstant.MAX_WAIT_MILLIS);
        poolConfig.setTestOnBorrow(ProjectConstant.TEST_ON_BORROW);
        poolConfig.setTestOnReturn(ProjectConstant.TEST_ON_RETURN);
    }

    private static void initJedisConfig() throws Exception {

        String ip = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getProperty(ProjectConstant.REDIS_IP);
        String passWord = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getProperty(ProjectConstant.REDIS_PW);
        int port = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getInt(ProjectConstant.REDIS_PORT, ProjectConstant.REDIS_PORT_DEAFULT);

        jedisConfig = new JedisConfig();
        jedisConfig.setIp(ip);
        jedisConfig.setPassWord(passWord);
        jedisConfig.setPort(port);

    }

    private static void initActJedisConfig() throws Exception {

        String ip = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getProperty(ProjectConstant.REDIS_ACT_IP);
        String passWord = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getProperty(ProjectConstant.REDIS_ACT_PW);
        int port = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getInt(ProjectConstant.REDIS_ACT_PORT, ProjectConstant.REDIS_PORT_DEAFULT);

        actJedisConfig = new JedisConfig();
        actJedisConfig.setIp(ip);
        actJedisConfig.setPassWord(passWord);
        actJedisConfig.setPort(port);

    }

}
