package cn.com.duiba.nezha.alg.example.example.intercept;

import cn.com.duiba.nezha.alg.alg.intercept.ActInterceptRcmdAlg;
import cn.com.duiba.nezha.alg.alg.vo.intercept.ActInterceptRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.intercept.InterceptRcmdRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.intercept.PreSelectActInterceptDo;
import cn.com.duiba.nezha.alg.alg.vo.intercept.PreSelectPlugInterceptDo;
import cn.com.duiba.nezha.alg.example.util.StdCoderModelSaveBo;
import cn.com.duiba.nezha.alg.feature.vo.ActInterceptFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.ActInterceptStatDo;
import cn.com.duiba.nezha.alg.feature.vo.PlugInterceptStatDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSON;
import org.junit.Test;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InterceptDQNRcmderTest {

    @Test
    public void rcmd() {


        //1 编码器获取 缓存
        CODER coderModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("act_intercept_coder_dqn_v001", "act");

        System.out.println(coderModel.getFeatureBaseType());
        //2 TF本地模型获取  缓存
        LocalTFModel ltfModel = new LocalTFModel();
        try {
            ltfModel.loadModel("/Users/lwj/Desktop/model3/");


            List<PreSelectActInterceptDo> preSelectActTitleDoList = new ArrayList<>();

            String pStr1 = "{\"activityId\":7326,\"dt\":\"2020-03-23\",\"score\":10,\"rank\":1,\"slotId\":279179}";
            PreSelectActInterceptDo p1 = JSON.parseObject(pStr1, PreSelectActInterceptDo.class);
            preSelectActTitleDoList.add(p1);

            String pStr2 = "{\"activityId\":7289,\"dt\":\"2020-03-23\",\"score\":9,\"rank\":2,\"slotId\":279179}";
            PreSelectActInterceptDo p2 = JSON.parseObject(pStr2, PreSelectActInterceptDo.class);
            preSelectActTitleDoList.add(p2);

            String pStr3 = "{\"activityId\":7000,\"dt\":\"2020-03-22\",\"score\":10,\"rank\":1,\"slotId\":279179}";
            PreSelectActInterceptDo p3 = JSON.parseObject(pStr3, PreSelectActInterceptDo.class);
            preSelectActTitleDoList.add(p3);


            //4 获取非创意特征（同点击率预估模型）


            //5 获取资源位创意推荐统计对象（算法1，入参）

            Map<Long, ActInterceptStatDo> actInterceptStatDoMap = new HashMap<>();
            //6 预估

            String featureStr = "{\"activityPage\":17918,\"appId\":52250,\"areaCode\":3301,\"dsm2A\":1,\"slotId\":279179}";

            ActInterceptFeatureDo actTitleFeatureDo = JSON.parseObject(featureStr, ActInterceptFeatureDo.class);

//            coderModel = null;
//            System.out.println("coder="+JSON.toJSONString(coderModel));

            Map<Long, Map<String, Long>> retMap = new HashMap<>();

            List<Long> actInterceptDoList = new ArrayList<>();
            actInterceptDoList.add(7326L);
            actInterceptDoList.add(7289L);


            List<PreSelectPlugInterceptDo> preSelectPlugDoList = new ArrayList<>();

            String ppStr1 = "{\"plugId\":326,\"dt\":\"2020-03-23\",\"score\":11,\"rank\":1,\"slotId\":279179}";
            PreSelectPlugInterceptDo pp1 = JSON.parseObject(ppStr1, PreSelectPlugInterceptDo.class);
            preSelectPlugDoList.add(pp1);

            String ppStr2 = "{\"plugId\":289,\"dt\":\"2020-03-23\",\"score\":10,\"rank\":2,\"slotId\":279179}";
            PreSelectPlugInterceptDo pp2 = JSON.parseObject(ppStr2, PreSelectPlugInterceptDo.class);
            preSelectPlugDoList.add(pp2);

            String ppStr3 = "{\"plugId\":000,\"dt\":\"2020-03-22\",\"score\":11,\"rank\":1,\"slotId\":279179}";
            PreSelectPlugInterceptDo pp3 = JSON.parseObject(ppStr3, PreSelectPlugInterceptDo.class);
            preSelectPlugDoList.add(pp3);


            //4 获取非创意特征（同点击率预估模型）


            //5 获取资源位创意推荐统计对象（算法1，入参）

            Map<Long, PlugInterceptStatDo> plugInterceptStatDoMap = new HashMap<>();
//   coderModel = null;
//            System.out.println("coder="+JSON.toJSONString(coderModel));

            System.out.println(LocalDateTime.now());

            List<Long> plugInterceptDoList = new ArrayList<>();
            plugInterceptDoList.add(326L);
            plugInterceptDoList.add(289L);

            InterceptRcmdRequestDo interceptRcmdRequestDo = new InterceptRcmdRequestDo();

            interceptRcmdRequestDo.setCoderModel(coderModel);
            interceptRcmdRequestDo.setLtfModel(ltfModel);
            interceptRcmdRequestDo.setActInterceptDoList(actInterceptDoList);
            interceptRcmdRequestDo.setPreSelectActInterceptDoList(preSelectActTitleDoList);
            interceptRcmdRequestDo.setActInterceptStatDoMap(actInterceptStatDoMap);
            interceptRcmdRequestDo.setActInterceptFeatureDo(actTitleFeatureDo);


            //返回拦截 插件
            interceptRcmdRequestDo.setPlugCoderModel(coderModel);
            interceptRcmdRequestDo.setPlugLtfModel(ltfModel);
            interceptRcmdRequestDo.setPlugInterceptDoList(plugInterceptDoList);
            interceptRcmdRequestDo.setPreSelectPlugInterceptDoList(preSelectPlugDoList);
            interceptRcmdRequestDo.setPlugInterceptStatDoMap(plugInterceptStatDoMap);
            interceptRcmdRequestDo.setPlugInterceptFeatureDo(actTitleFeatureDo);

            int j = 0;
            for (int i = 0; i < 1000; i++) {
                ActInterceptRcmdDo ret1 = ActInterceptRcmdAlg.rcmd(interceptRcmdRequestDo);

//                System.out.println("ret="+JSON.toJSONString(ret1));
                if (ret1 != null) {
                    if (!retMap.containsKey(ret1.getInterceptContentType())) {
                        retMap.put(ret1.getInterceptContentType(), new HashMap<>());
                    }

                    retMap.get(ret1.getInterceptContentType()).put(ret1.getKey(), retMap.get(ret1.getInterceptContentType()).getOrDefault(ret1.getKey(), 0L) + 1);
                } else {

                    j++;
                }
            }

            System.out.println("retMap=" + JSON.toJSONString(retMap));
            System.out.println("j=" +j);
            System.out.println(LocalDateTime.now());

        } catch (Exception e) {
            e.printStackTrace();
            System.out.println(e);

        }
    }
}
