package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.alg.recall.params.TupleParam;
import cn.com.duiba.nezha.alg.alg.recallcompare.param.FilterParam;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.example.constant.ProjectConstant;
import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.conf.JedisPoolConf;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;


public class ParamSaver {

    public static JedisUtil jedisUtil = new JedisUtil(JedisPoolConf.jedisConfig);

    public static void saveRecallParamByKeyToJedis(String modelKey,
                                                   Map<String,TupleParam> param, JedisUtil ju) {
        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, param)) {
            System.out.println("save empty,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = modelKey;

            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(param);

            ju.setex(key, value, ProjectConstant.YEAR_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String,TupleParam> getRecallParamByKeyFromJedis(String modelKey, JedisUtil ju) {
        Map<String,TupleParam> ret = new HashMap<>();

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("get empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = modelKey;
            System.out.println("read model with key=" + key);
            // 保存
            String ret1 = ju.get(key);
            JSONObject jsonObject = JSON.parseObject(ret1);

            jsonObject.forEach((k, v) -> ret.put(k, JSON.parseObject(v.toString(), TupleParam.class)));

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

    public static void saveFilterParamByKeyToJedis(String modelKey, FilterParam param, JedisUtil ju) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, param)) {
            System.out.println("save empty,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = modelKey;

            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(param);

            ju.setex(key, value, ProjectConstant.YEAR_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FilterParam getFilterParamByKeyFromJedis(String modelKey, JedisUtil ju) {
        FilterParam ret = null;

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("get empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = modelKey;
            System.out.println("read model with key=" + key);
            // 保存
            String ret1 = ju.get(key);
            ret = JSON.parseObject(ret1, FilterParam.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

    public static void main(String[] args) {
        Map<String,TupleParam> paramMap=new HashMap<String,TupleParam>();
        TupleParam tupleParamA=new TupleParam();
        tupleParamA.getFilterParam().setVectorActiveTrade(Arrays.asList("16"));
        tupleParamA.getFilterParam().setVectorActiveReleaseTarget(Arrays.asList(3));
        tupleParamA.getCombineParam().setRecallNumMap(ImmutableMap.of(2,4));
        paramMap.put("expA",tupleParamA);

        TupleParam tupleParamB=new TupleParam();
        tupleParamB.getFilterParam().setVectorActiveTrade(Arrays.asList("15"));
        tupleParamB.getFilterParam().setVectorActiveReleaseTarget(Arrays.asList(3));
        tupleParamB.getCombineParam().setRecallNumMap(ImmutableMap.of(2,4));
        paramMap.put("expB",tupleParamB);

        TupleParam tupleParamC=new TupleParam();
        tupleParamC.getFilterParam().setVectorActiveTrade(Arrays.asList("15","16","21","9"));
        tupleParamC.getFilterParam().setVectorActiveReleaseTarget(Arrays.asList(3));
        tupleParamC.getCombineParam().setRecallNumMap(ImmutableMap.of(2,6));

        paramMap.put("expC",tupleParamC);
        saveRecallParamByKeyToJedis("NZ_K86_recall_params",paramMap,jedisUtil);

        System.out.println(JSONObject.toJSONString(paramMap));

        Map<String,TupleParam> paramMapB=new HashMap<String,TupleParam>();
        paramMapB=getRecallParamByKeyFromJedis("NZ_K86_recall_params",jedisUtil);
        System.out.println(paramMapB);
    }
}
