/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.example.util;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.example.util.JedisPoolUtil;
import cn.com.duiba.nezha.alg.example.util.conf.JedisConfig;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;

public class JedisUtil {
    private JedisConfig jedisConfig;

    public JedisUtil(JedisConfig jedisConfig) {
        this.jedisConfig = jedisConfig;
    }

    public Jedis getJedis() {
        Jedis jedis = null;
        try {
            jedis = JedisPoolUtil.getInstance().getJedis(this.jedisConfig);
        }
        catch (Exception e) {
            System.out.println("redis error " + e);
        }
        return jedis;
    }

    public void remove(String ... keys) {
        try {
            for (String key : keys) {
                this.remove(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        Jedis jedis = this.getJedis();
        boolean isBroken = false;
        try {
            if (this.exists(key)) {
                jedis.del(key);
            }
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String key) {
        boolean ret = false;
        Jedis jedis = this.getJedis();
        boolean isBroken = false;
        try {
            ret = jedis.exists(key);
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String key) {
        String result = null;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            result = jedis.get(key);
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        String result = null;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            result = jedis.get(key);
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(String key, Class clazz) {
        Object result = null;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            Object value = this.getObject(key);
            result = JSON.parseObject((String)((String)value), (Class)clazz);
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setObject(String key, Object value) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            jedis.set(key, JSON.toJSONString((Object)value));
            result = true;
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(String key, String value) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            jedis.set(key, value);
            result = true;
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setexObject(String key, Object value, int seconds) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            jedis.setex(key, seconds, JSON.toJSONString((Object)value));
            result = true;
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setex(String key, String value, int seconds) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            jedis.setex(key, seconds, value);
            result = true;
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    public <T> List<T> getList(String key, Class clazz) {
        List result = null;
        try {
            Object value = this.getObject(key);
            result = JSON.parseArray((String)((String)value), (Class)clazz);
        }
        catch (Exception e) {
            System.out.println("redis error " + e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setexList(String key, Object list, int seconds) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            String value = JSON.toJSONString((Object)list);
            jedis.setex(key, seconds, value);
            result = true;
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean multiSetexT(Map<String, T> kvMap, int seconds) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        Pipeline p = jedis.pipelined();
        try {
            if (AssertUtil.isNotEmpty(kvMap)) {
                int index = 0;
                for (Map.Entry<String, T> entry : kvMap.entrySet()) {
                    String key = entry.getKey();
                    T value = entry.getValue();
                    String jsonValue = JSON.toJSONString(value);
                    if (!AssertUtil.isAllNotEmpty((Object[])new Object[]{key, jsonValue})) continue;
                    p.set(key, jsonValue);
                    p.expire(key, seconds);
                    if (++index % 1000 != 0) continue;
                    p.sync();
                }
                p.sync();
                result = true;
            }
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean multiSetex(Map<String, String> kvMap, int seconds) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        Pipeline p = jedis.pipelined();
        try {
            if (AssertUtil.isNotEmpty(kvMap)) {
                int index = 0;
                for (Map.Entry<String, String> entry : kvMap.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (!AssertUtil.isAllNotEmpty((Object[])new Object[]{key, value})) continue;
                    p.set(key, value);
                    p.expire(key, seconds);
                    if (++index % 1000 != 0) continue;
                    p.sync();
                }
                p.sync();
                result = true;
            }
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hmSet(String key, Map<String, String> map) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            if (map != null) {
                jedis.hmset(key, map);
                result = true;
            }
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hSetex(String key, String field, String value) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            jedis.hset(key, field, value);
            result = true;
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> hgetAll(String key) {
        HashMap<String, String> ret = new HashMap();
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            ret = jedis.hgetAll(key);
        }
        catch (Exception e) {
            isBroken = true;
            e.printStackTrace();
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean expire(String key, int seconds) {
        boolean result = false;
        boolean isBroken = false;
        Jedis jedis = this.getJedis();
        try {
            jedis.expire(key, seconds);
            result = true;
        }
        catch (Exception e) {
            isBroken = true;
            e.printStackTrace();
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hmsetexPipelined(Map<String, Map<String, String>> keyMapList, int seconds) {
        Jedis jedis = this.getJedis();
        boolean isBroken = false;
        try {
            Pipeline p = jedis.pipelined();
            if (keyMapList != null) {
                int index = 0;
                for (Map.Entry<String, Map<String, String>> entry : keyMapList.entrySet()) {
                    String key = entry.getKey();
                    Map<String, String> value = entry.getValue();
                    if (value == null) continue;
                    p.hmset(key, value);
                    p.expire(key, seconds);
                    if (++index % 1000 != 0) continue;
                    p.sync();
                }
                p.sync();
            }
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hsetexPipelined(Map<String, String> keyMapList, int seconds) {
        Jedis jedis = this.getJedis();
        boolean isBroken = false;
        try {
            Pipeline p = jedis.pipelined();
            if (keyMapList != null) {
                for (Map.Entry<String, String> entry : keyMapList.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (value == null) continue;
                    p.setex(key, seconds, value);
                }
            }
            p.sync();
        }
        catch (Exception e) {
            isBroken = true;
            System.out.println("redis error " + e);
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
    }

    public void returnResource(Jedis jedis, boolean isBroken) {
        try {
            if (null == jedis) {
                return;
            }
            jedis.close();
        }
        catch (Exception e) {
            System.out.println("redis error " + e);
        }
    }
}

