/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.DateUtil;
import cn.com.duiba.nezha.alg.example.util.StdCoderModelSaveBo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.ESMM;
import cn.com.duiba.nezha.alg.model.FM;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ModelReadTest {
    public static void main(String[] args) {
        try {
            System.gc();
            long total = Runtime.getRuntime().totalMemory();
            long m1 = Runtime.getRuntime().freeMemory();
            System.out.println("before:" + (total - m1));
            CODER ctrModel = StdCoderModelSaveBo.getADXModelCoderByKeyFromJedis("adx_coder_dqn_v001");
            String value = JSON.toJSONString((Object)ctrModel.getUpdateTime());
            System.out.println("ctrModel=" + JSON.toJSONString((Object)ctrModel.getUpdateTime()));
            CODER ctrModel2 = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("act_resplug_coder_dqn_v001", StdCoderModelSaveBo.actJedisUtil);
            System.out.println("ctrModel2=" + JSON.toJSONString((Object)ctrModel2.getUpdateTime()));
            long total1 = Runtime.getRuntime().totalMemory();
            long m2 = Runtime.getRuntime().freeMemory();
            System.out.println("after:" + (total1 - m2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void test3(ESMM model) throws Exception {
        ExecutorService executorService = Executors.newFixedThreadPool(30);
        for (int i = 0; i < 4; ++i) {
            RunnableThread thread = new RunnableThread(model);
            Thread.sleep(10L);
            executorService.execute(thread);
        }
        executorService.shutdown();
    }

    public static void testESMM(ESMM model) throws Exception {
        String featureStr = "{\"f604001\":\"1\",\"f501001\":\"Android\",\"f608001\":\"1\",\"f113001\":\"40104,04.01.0001\",\"f610001\":\"0\",\"f9913\":\"20\",\"f508002\":\"A59s\",\"f806001\":\"15\",\"f508001\":\"OPPO\",\"f9914\":\"com.android.bluetooth,com.android.browser,com.android.calculator2,com.android.calendar,com.android.captiveportallogin,com.android.certinstaller,com.android.contacts,com.android.defcontainer,com.android.documentsui,com.android.dreams.basic,com.android.externalstorage,com.android.htmlviewer,com.android.inputdevices,com.android.keychain,com.android.location.fused,com.android.managedprovisioning,com.android.mms,com.android.mms.service,com.android.onetimeinitializer,com.android.packageinstaller,com.android.pacprocessor,com.android.phone,com.android.printspooler,com.android.providers.applications,com.android.providers.calendar,com.android.providers.contacts,com.android.providers.downloads,com.android.providers.media,com.android.providers.settings,com.android.providers.telephony,com.android.providers.userdictionary,com.android.proxyhandler,com.android.server.telecom,com.android.settings,com.android.sharedstoragebackup,com.android.shell,com.android.stk,com.android.systemui,com.android.vendors.bridge.softsim,com.android.vpndialogs,com.android.wallpaper.livepicker,com.android.wallpapercropper,com.mediatek,com.mediatek.atci.service,com.mediatek.connectivity,com.mediatek.engineermode,com.mediatek.fwk.plugin,com.mediatek.gba,com.mediatek.hetcomm,com.mediatek.lbs.em2.ui,com.mediatek.mtklogger,com.mediatek.nlpservice,com.mediatek.providers.drm,com.mediatek.ygps,com.redteamobile.virtual.softsim,com.rzwifi.password,com.svox.pico,com.tencent.mm,org.simalliance.openmobileapi.service,se.dirac.acs\",\"f806002\":\"12\",\"f9915\":\"\\\\N,28,1,62,5,19,23,17,60,37,65,40,4,47,21,68,52\",\"f206001\":\"262\",\"f104001\":\"null\",\"f504001\":\"OPPO A59s\",\"f601001\":\"2\",\"f303001\":\"6\",\"f9912\":\"2063\",\"f603001\":\"1\",\"f110001\":\"1\",\"f607001\":\"0\",\"f502001\":\"11\",\"f502002\":\"4\",\"f611001\":\"2\",\"f206002\":\"260\",\"f403004\":\"0\",\"f9902\":\"android,com.amap.android.location,com.android.bluetooth,com.android.browser,com.android.calculator2,com.android.calendar,com.android.captiveportallogin,com.android.certinstaller,com.android.contacts,com.android.defcontainer,com.android.dlna.service,com.android.documentsui,com.android.dreams.basic,com.android.dreams.phototable,com.android.externalstorage,com.android.htmlviewer,com.android.incallui,com.android.inputdevices,com.android.keychain,com.android.keyguard,com.android.location.fused,com.android.managedprovisioning,com.android.mms,com.android.mms.service,com.android.onetimeinitializer,com.android.packageinstaller,com.android.pacprocessor,com.android.phone,com.android.printspooler,com.android.providers.applications,com.android.providers.calendar,com.android.providers.contacts,com.android.providers.downloads,com.android.providers.media,com.android.providers.settings,com.android.providers.telephony,com.android.providers.userdictionary,com.android.proxyhandler,com.android.server.telecom,com.android.settings,com.android.sharedstoragebackup,com.android.shell,com.android.stk,com.android.systemui,com.android.utk,com.android.vendors.bridge.softsim,com.android.vpndialogs,com.android.wallpaper.livepicker,com.android.wallpapercropper,com.cgshi.fruit1,com.cleanmaster.sdk,com.color.uiengine,com.coloros.activation,com.coloros.alarmclock,com.coloros.appmanager,com.coloros.backup.composer.app,com.coloros.backuprestore,com.coloros.backuprestore.remoteservice,com.coloros.blacklist,com.coloros.bootreg,com.coloros.cloud,com.coloros.compass,com.coloros.exserviceui,com.coloros.feedback,com.coloros.filemanager,com.coloros.findmyphone,com.coloros.fingerprint,com.coloros.flashlight,com.coloros.gallery3d,com.coloros.gesture,com.coloros.keyguard.notification,com.coloros.leather,com.coloros.mcs,com.coloros.newsimdetect,com.coloros.notificationmanager,com.coloros.operationmanual,com.coloros.oppoguardelf,com.coloros.oppomorningsystem,com.coloros.oppomultiapp,com.coloros.phonenoareainquire,com.coloros.photoeffects,com.coloros.pictorial,com.coloros.preventmode,com.coloros.providers.downloads.ui,com.coloros.recents,com.coloros.safe.service.framework,com.coloros.safecenter,com.coloros.sau,com.coloros.screenshot,com.coloros.simsettings,com.coloros.soundrecorder,com.coloros.speechassist,com.coloros.speechassist.engine,com.coloros.usbselection,com.coloros.video,com.coloros.wallpapers,com.coloros.weather,com.coloros.weather.service,com.coloros.widget.smallweather,com.coloros.wirelesssettings,com.criticallog,com.dropboxchmod,com.gnss.power,com.google.android.webview,com.hdkino.browser,com.iflytek.speechcloud,com.mediatek,com.mediatek.atci.service,com.mediatek.connectivity,com.mediatek.engineermode,com.mediatek.fwk.plugin,com.mediatek.gba,com.mediatek.hetcomm,com.mediatek.lbs.em2.ui,com.mediatek.miravision.ui,com.mediatek.mtklogger,com.mediatek.nlpservice,com.mediatek.providers.drm,com.mediatek.ygps,com.mobiletools.systemhelper,com.nearme.atlas,com.nearme.gamecenter,com.nearme.romupdate,com.nearme.statistics.rom,com.nearme.sync,com.nearme.themespace,com.nearme.themespacelib,com.oppo.autotest,com.oppo.bluetooth.pbapclient,com.oppo.c2u,com.oppo.camera,com.oppo.camera.doubleexposure,com.oppo.camera.facebeauty,com.oppo.camera.fastvideomode,com.oppo.camera.filter,com.oppo.camera.gif,com.oppo.camera.panorama,com.oppo.camera.professional,com.oppo.camera.superzoom,com.oppo.ctautoregist,com.oppo.dirac,com.oppo.engineeringmode.specialtest,com.oppo.engineermode,com.oppo.factorygps,com.oppo.fingerprints.fingerprintsensortest,com.oppo.fingerprints.service,com.oppo.gestureservice,com.oppo.launcher,com.oppo.market,com.oppo.music,com.oppo.ota,com.oppo.quicksearchbox,com.oppo.reader,com.oppo.resmonitor,com.oppo.sdcardservice,com.oppo.usagedump,com.oppo.usercenter,com.oppo.webview,com.redteamobile.roaming,com.redteamobile.virtual.softsim,com.rzwifi.password,com.sohu.inputmethod.sogouoem,com.svox.pico,com.ted.number,com.tencent.mm,com.ziipin.softkeyboard,com.zy.org.megabucks.by,oppo,org.simalliance.openmobileapi.eseterminal,org.simalliance.openmobileapi.service,org.simalliance.openmobileapi.uicc1terminal,org.simalliance.openmobileapi.uicc2terminal,se.dirac.acs\",\"f805001\":\"14\",\"f805002\":\"12\",\"f505001\":\"1700-2699\",\"f9906\":\"10,\\\\N,22,32,16,31\",\"f9907\":\"1004,\\\\N,2208,3205,1601,2203,2202,3106\",\"f9908\":\"1\",\"f602001\":\"2\",\"f606001\":\"-1\",\"f205002\":\"55\",\"f205001\":\"27\",\"f201001\":\"21054\",\"f102001\":\"20806,02.15.0008\",\"f106001\":\"5102\",\"f609001\":\"0\",\"f804002\":\"12\",\"f804001\":\"14\",\"f301001\":\"1579\",\"f605001\":\"1\",\"f108001\":\"3408\",\"f807002\":\"12\",\"f101001\":\"38944\",\"f807001\":\"14\",\"f507001\":\"3\",\"f503001\":\"6532\",\"f302001\":\"1579\",\"f306001\":\"2\"}";
        JSONObject featureIdxMap = JSON.parseObject((String)featureStr);
        HashMap<Long, Long> retMap = new HashMap<Long, Long>();
        int times = 1000;
        System.out.println("start " + DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));
        long tStart = System.currentTimeMillis();
        for (int j = 0; j < times; ++j) {
            HashMap<String, JSONObject> req = new HashMap<String, JSONObject>();
            for (int i = 0; i < 100; ++i) {
                req.put("a" + i, featureIdxMap);
            }
            long tStart_2 = System.currentTimeMillis();
            Map ret1 = model.predictCTRsAndCVRsWithTF(req);
            long tEnd_2 = System.currentTimeMillis();
            Long diff_2 = tEnd_2 - tStart_2;
            retMap.put(diff_2, retMap.getOrDefault(diff_2, 0L) + 1L);
        }
        long tEnd = System.currentTimeMillis();
        System.out.println("end " + DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));
        System.out.println("diff=" + (tEnd - tStart) / (long)times);
        System.out.println("retMap=" + JSON.toJSONString(retMap));
    }

    public static void test(IModel m) throws Exception {
        String featureStr = "{\"f604001\":\"1\",\"f501001\":\"Android\",\"f608001\":\"1\",\"f113001\":\"40104,04.01.0001\",\"f610001\":\"0\",\"f9913\":\"20\",\"f508002\":\"A59s\",\"f806001\":\"15\",\"f508001\":\"OPPO\",\"f9914\":\"com.android.bluetooth,com.android.browser,com.android.calculator2,com.android.calendar,com.android.captiveportallogin,com.android.certinstaller,com.android.contacts,com.android.defcontainer,com.android.documentsui,com.android.dreams.basic,com.android.externalstorage,com.android.htmlviewer,com.android.inputdevices,com.android.keychain,com.android.location.fused,com.android.managedprovisioning,com.android.mms,com.android.mms.service,com.android.onetimeinitializer,com.android.packageinstaller,com.android.pacprocessor,com.android.phone,com.android.printspooler,com.android.providers.applications,com.android.providers.calendar,com.android.providers.contacts,com.android.providers.downloads,com.android.providers.media,com.android.providers.settings,com.android.providers.telephony,com.android.providers.userdictionary,com.android.proxyhandler,com.android.server.telecom,com.android.settings,com.android.sharedstoragebackup,com.android.shell,com.android.stk,com.android.systemui,com.android.vendors.bridge.softsim,com.android.vpndialogs,com.android.wallpaper.livepicker,com.android.wallpapercropper,com.mediatek,com.mediatek.atci.service,com.mediatek.connectivity,com.mediatek.engineermode,com.mediatek.fwk.plugin,com.mediatek.gba,com.mediatek.hetcomm,com.mediatek.lbs.em2.ui,com.mediatek.mtklogger,com.mediatek.nlpservice,com.mediatek.providers.drm,com.mediatek.ygps,com.redteamobile.virtual.softsim,com.rzwifi.password,com.svox.pico,com.tencent.mm,org.simalliance.openmobileapi.service,se.dirac.acs\",\"f806002\":\"12\",\"f9915\":\"\\\\N,28,1,62,5,19,23,17,60,37,65,40,4,47,21,68,52\",\"f206001\":\"262\",\"f104001\":\"null\",\"f504001\":\"OPPO A59s\",\"f601001\":\"2\",\"f303001\":\"6\",\"f9912\":\"2063\",\"f603001\":\"1\",\"f110001\":\"1\",\"f607001\":\"0\",\"f502001\":\"11\",\"f502002\":\"4\",\"f611001\":\"2\",\"f206002\":\"260\",\"f403004\":\"0\",\"f9902\":\"android,com.amap.android.location,com.android.bluetooth,com.android.browser,com.android.calculator2,com.android.calendar,com.android.captiveportallogin,com.android.certinstaller,com.android.contacts,com.android.defcontainer,com.android.dlna.service,com.android.documentsui,com.android.dreams.basic,com.android.dreams.phototable,com.android.externalstorage,com.android.htmlviewer,com.android.incallui,com.android.inputdevices,com.android.keychain,com.android.keyguard,com.android.location.fused,com.android.managedprovisioning,com.android.mms,com.android.mms.service,com.android.onetimeinitializer,com.android.packageinstaller,com.android.pacprocessor,com.android.phone,com.android.printspooler,com.android.providers.applications,com.android.providers.calendar,com.android.providers.contacts,com.android.providers.downloads,com.android.providers.media,com.android.providers.settings,com.android.providers.telephony,com.android.providers.userdictionary,com.android.proxyhandler,com.android.server.telecom,com.android.settings,com.android.sharedstoragebackup,com.android.shell,com.android.stk,com.android.systemui,com.android.utk,com.android.vendors.bridge.softsim,com.android.vpndialogs,com.android.wallpaper.livepicker,com.android.wallpapercropper,com.cgshi.fruit1,com.cleanmaster.sdk,com.color.uiengine,com.coloros.activation,com.coloros.alarmclock,com.coloros.appmanager,com.coloros.backup.composer.app,com.coloros.backuprestore,com.coloros.backuprestore.remoteservice,com.coloros.blacklist,com.coloros.bootreg,com.coloros.cloud,com.coloros.compass,com.coloros.exserviceui,com.coloros.feedback,com.coloros.filemanager,com.coloros.findmyphone,com.coloros.fingerprint,com.coloros.flashlight,com.coloros.gallery3d,com.coloros.gesture,com.coloros.keyguard.notification,com.coloros.leather,com.coloros.mcs,com.coloros.newsimdetect,com.coloros.notificationmanager,com.coloros.operationmanual,com.coloros.oppoguardelf,com.coloros.oppomorningsystem,com.coloros.oppomultiapp,com.coloros.phonenoareainquire,com.coloros.photoeffects,com.coloros.pictorial,com.coloros.preventmode,com.coloros.providers.downloads.ui,com.coloros.recents,com.coloros.safe.service.framework,com.coloros.safecenter,com.coloros.sau,com.coloros.screenshot,com.coloros.simsettings,com.coloros.soundrecorder,com.coloros.speechassist,com.coloros.speechassist.engine,com.coloros.usbselection,com.coloros.video,com.coloros.wallpapers,com.coloros.weather,com.coloros.weather.service,com.coloros.widget.smallweather,com.coloros.wirelesssettings,com.criticallog,com.dropboxchmod,com.gnss.power,com.google.android.webview,com.hdkino.browser,com.iflytek.speechcloud,com.mediatek,com.mediatek.atci.service,com.mediatek.connectivity,com.mediatek.engineermode,com.mediatek.fwk.plugin,com.mediatek.gba,com.mediatek.hetcomm,com.mediatek.lbs.em2.ui,com.mediatek.miravision.ui,com.mediatek.mtklogger,com.mediatek.nlpservice,com.mediatek.providers.drm,com.mediatek.ygps,com.mobiletools.systemhelper,com.nearme.atlas,com.nearme.gamecenter,com.nearme.romupdate,com.nearme.statistics.rom,com.nearme.sync,com.nearme.themespace,com.nearme.themespacelib,com.oppo.autotest,com.oppo.bluetooth.pbapclient,com.oppo.c2u,com.oppo.camera,com.oppo.camera.doubleexposure,com.oppo.camera.facebeauty,com.oppo.camera.fastvideomode,com.oppo.camera.filter,com.oppo.camera.gif,com.oppo.camera.panorama,com.oppo.camera.professional,com.oppo.camera.superzoom,com.oppo.ctautoregist,com.oppo.dirac,com.oppo.engineeringmode.specialtest,com.oppo.engineermode,com.oppo.factorygps,com.oppo.fingerprints.fingerprintsensortest,com.oppo.fingerprints.service,com.oppo.gestureservice,com.oppo.launcher,com.oppo.market,com.oppo.music,com.oppo.ota,com.oppo.quicksearchbox,com.oppo.reader,com.oppo.resmonitor,com.oppo.sdcardservice,com.oppo.usagedump,com.oppo.usercenter,com.oppo.webview,com.redteamobile.roaming,com.redteamobile.virtual.softsim,com.rzwifi.password,com.sohu.inputmethod.sogouoem,com.svox.pico,com.ted.number,com.tencent.mm,com.ziipin.softkeyboard,com.zy.org.megabucks.by,oppo,org.simalliance.openmobileapi.eseterminal,org.simalliance.openmobileapi.service,org.simalliance.openmobileapi.uicc1terminal,org.simalliance.openmobileapi.uicc2terminal,se.dirac.acs\",\"f805001\":\"14\",\"f805002\":\"12\",\"f505001\":\"1700-2699\",\"f9906\":\"10,\\\\N,22,32,16,31\",\"f9907\":\"1004,\\\\N,2208,3205,1601,2203,2202,3106\",\"f9908\":\"1\",\"f602001\":\"2\",\"f606001\":\"-1\",\"f205002\":\"55\",\"f205001\":\"27\",\"f201001\":\"21054\",\"f102001\":\"20806,02.15.0008\",\"f106001\":\"5102\",\"f609001\":\"0\",\"f804002\":\"12\",\"f804001\":\"14\",\"f301001\":\"1579\",\"f605001\":\"1\",\"f108001\":\"3408\",\"f807002\":\"12\",\"f101001\":\"20976\",\"f807001\":\"14\",\"f507001\":\"3\",\"f503001\":\"6532\",\"f302001\":\"1579\",\"f306001\":\"2\"}";
        JSONObject featureIdxMap = JSON.parseObject((String)featureStr);
        TFServingClient tfServingClient = new TFServingClient("10.50.201.72", 9000, "dcn-ctr-002", null);
        HashMap<String, JSONObject> req = new HashMap<String, JSONObject>();
        for (int i = 0; i < 100; ++i) {
            featureIdxMap.put("f108001", "" + i);
            req.put("a" + i, featureIdxMap);
        }
        Map ret = m.predictWithTF(req, null);
        System.out.println("ret=" + JSON.toJSONString((Object)ret));
    }

    public static void test2(FM m) throws Exception {
        String featureStr = "{\"f604001\":\"1\",\"f501001\":\"Android\",\"f608001\":\"1\",\"f113001\":\"40104,04.01.0001\",\"f610001\":\"0\",\"f9913\":\"20\",\"f508002\":\"A59s\",\"f806001\":\"15\",\"f508001\":\"OPPO\",\"f9914\":\"com.android.bluetooth,com.android.browser,com.android.calculator2,com.android.calendar,com.android.captiveportallogin,com.android.certinstaller,com.android.contacts,com.android.defcontainer,com.android.documentsui,com.android.dreams.basic,com.android.externalstorage,com.android.htmlviewer,com.android.inputdevices,com.android.keychain,com.android.location.fused,com.android.managedprovisioning,com.android.mms,com.android.mms.service,com.android.onetimeinitializer,com.android.packageinstaller,com.android.pacprocessor,com.android.phone,com.android.printspooler,com.android.providers.applications,com.android.providers.calendar,com.android.providers.contacts,com.android.providers.downloads,com.android.providers.media,com.android.providers.settings,com.android.providers.telephony,com.android.providers.userdictionary,com.android.proxyhandler,com.android.server.telecom,com.android.settings,com.android.sharedstoragebackup,com.android.shell,com.android.stk,com.android.systemui,com.android.vendors.bridge.softsim,com.android.vpndialogs,com.android.wallpaper.livepicker,com.android.wallpapercropper,com.mediatek,com.mediatek.atci.service,com.mediatek.connectivity,com.mediatek.engineermode,com.mediatek.fwk.plugin,com.mediatek.gba,com.mediatek.hetcomm,com.mediatek.lbs.em2.ui,com.mediatek.mtklogger,com.mediatek.nlpservice,com.mediatek.providers.drm,com.mediatek.ygps,com.redteamobile.virtual.softsim,com.rzwifi.password,com.svox.pico,com.tencent.mm,org.simalliance.openmobileapi.service,se.dirac.acs\",\"f806002\":\"12\",\"f9915\":\"\\\\N,28,1,62,5,19,23,17,60,37,65,40,4,47,21,68,52\",\"f206001\":\"262\",\"f104001\":\"null\",\"f504001\":\"OPPO A59s\",\"f601001\":\"2\",\"f303001\":\"6\",\"f9912\":\"2063\",\"f603001\":\"1\",\"f110001\":\"1\",\"f607001\":\"0\",\"f502001\":\"11\",\"f502002\":\"4\",\"f611001\":\"2\",\"f206002\":\"260\",\"f403004\":\"0\",\"f9902\":\"android,com.amap.android.location,com.android.bluetooth,com.android.browser,com.android.calculator2,com.android.calendar,com.android.captiveportallogin,com.android.certinstaller,com.android.contacts,com.android.defcontainer,com.android.dlna.service,com.android.documentsui,com.android.dreams.basic,com.android.dreams.phototable,com.android.externalstorage,com.android.htmlviewer,com.android.incallui,com.android.inputdevices,com.android.keychain,com.android.keyguard,com.android.location.fused,com.android.managedprovisioning,com.android.mms,com.android.mms.service,com.android.onetimeinitializer,com.android.packageinstaller,com.android.pacprocessor,com.android.phone,com.android.printspooler,com.android.providers.applications,com.android.providers.calendar,com.android.providers.contacts,com.android.providers.downloads,com.android.providers.media,com.android.providers.settings,com.android.providers.telephony,com.android.providers.userdictionary,com.android.proxyhandler,com.android.server.telecom,com.android.settings,com.android.sharedstoragebackup,com.android.shell,com.android.stk,com.android.systemui,com.android.utk,com.android.vendors.bridge.softsim,com.android.vpndialogs,com.android.wallpaper.livepicker,com.android.wallpapercropper,com.cgshi.fruit1,com.cleanmaster.sdk,com.color.uiengine,com.coloros.activation,com.coloros.alarmclock,com.coloros.appmanager,com.coloros.backup.composer.app,com.coloros.backuprestore,com.coloros.backuprestore.remoteservice,com.coloros.blacklist,com.coloros.bootreg,com.coloros.cloud,com.coloros.compass,com.coloros.exserviceui,com.coloros.feedback,com.coloros.filemanager,com.coloros.findmyphone,com.coloros.fingerprint,com.coloros.flashlight,com.coloros.gallery3d,com.coloros.gesture,com.coloros.keyguard.notification,com.coloros.leather,com.coloros.mcs,com.coloros.newsimdetect,com.coloros.notificationmanager,com.coloros.operationmanual,com.coloros.oppoguardelf,com.coloros.oppomorningsystem,com.coloros.oppomultiapp,com.coloros.phonenoareainquire,com.coloros.photoeffects,com.coloros.pictorial,com.coloros.preventmode,com.coloros.providers.downloads.ui,com.coloros.recents,com.coloros.safe.service.framework,com.coloros.safecenter,com.coloros.sau,com.coloros.screenshot,com.coloros.simsettings,com.coloros.soundrecorder,com.coloros.speechassist,com.coloros.speechassist.engine,com.coloros.usbselection,com.coloros.video,com.coloros.wallpapers,com.coloros.weather,com.coloros.weather.service,com.coloros.widget.smallweather,com.coloros.wirelesssettings,com.criticallog,com.dropboxchmod,com.gnss.power,com.google.android.webview,com.hdkino.browser,com.iflytek.speechcloud,com.mediatek,com.mediatek.atci.service,com.mediatek.connectivity,com.mediatek.engineermode,com.mediatek.fwk.plugin,com.mediatek.gba,com.mediatek.hetcomm,com.mediatek.lbs.em2.ui,com.mediatek.miravision.ui,com.mediatek.mtklogger,com.mediatek.nlpservice,com.mediatek.providers.drm,com.mediatek.ygps,com.mobiletools.systemhelper,com.nearme.atlas,com.nearme.gamecenter,com.nearme.romupdate,com.nearme.statistics.rom,com.nearme.sync,com.nearme.themespace,com.nearme.themespacelib,com.oppo.autotest,com.oppo.bluetooth.pbapclient,com.oppo.c2u,com.oppo.camera,com.oppo.camera.doubleexposure,com.oppo.camera.facebeauty,com.oppo.camera.fastvideomode,com.oppo.camera.filter,com.oppo.camera.gif,com.oppo.camera.panorama,com.oppo.camera.professional,com.oppo.camera.superzoom,com.oppo.ctautoregist,com.oppo.dirac,com.oppo.engineeringmode.specialtest,com.oppo.engineermode,com.oppo.factorygps,com.oppo.fingerprints.fingerprintsensortest,com.oppo.fingerprints.service,com.oppo.gestureservice,com.oppo.launcher,com.oppo.market,com.oppo.music,com.oppo.ota,com.oppo.quicksearchbox,com.oppo.reader,com.oppo.resmonitor,com.oppo.sdcardservice,com.oppo.usagedump,com.oppo.usercenter,com.oppo.webview,com.redteamobile.roaming,com.redteamobile.virtual.softsim,com.rzwifi.password,com.sohu.inputmethod.sogouoem,com.svox.pico,com.ted.number,com.tencent.mm,com.ziipin.softkeyboard,com.zy.org.megabucks.by,oppo,org.simalliance.openmobileapi.eseterminal,org.simalliance.openmobileapi.service,org.simalliance.openmobileapi.uicc1terminal,org.simalliance.openmobileapi.uicc2terminal,se.dirac.acs\",\"f805001\":\"14\",\"f805002\":\"12\",\"f505001\":\"1700-2699\",\"f9906\":\"10,\\\\N,22,32,16,31\",\"f9907\":\"1004,\\\\N,2208,3205,1601,2203,2202,3106\",\"f9908\":\"1\",\"f602001\":\"2\",\"f606001\":\"-1\",\"f205002\":\"55\",\"f205001\":\"27\",\"f201001\":\"21054\",\"f102001\":\"20806,02.15.0008\",\"f106001\":\"5102\",\"f609001\":\"0\",\"f804002\":\"12\",\"f804001\":\"14\",\"f301001\":\"1579\",\"f605001\":\"1\",\"f108001\":\"3408\",\"f807002\":\"12\",\"f101001\":\"20976\",\"f807001\":\"14\",\"f507001\":\"3\",\"f503001\":\"6532\",\"f302001\":\"1579\",\"f306001\":\"2\"}";
        JSONObject featureIdxMap = JSON.parseObject((String)featureStr);
        featureIdxMap.put("sub_net_id", "10.0");
        double[] ret = m.getParam2((Map)featureIdxMap);
        System.out.println("ret=" + JSON.toJSONString((Object)ret));
    }

    public static void test1(IModel m) throws Exception {
        String featureStr = "{\"f602001\":\"1\",\"f604001\":\"1\",\"f606001\":\"-1\",\"f501001\":\"Android\",\"f608001\":\"0\",\"f113001\":\"40103\",\"f610001\":\"0\",\"cf101201\":\"1565836007\",\"cf101301\":\"156583558\",\"f201001\":\"36007\",\"f102001\":\"22001\",\"f106001\":\"291\",\"f506001\":\"1\",\"f104001\":\"null\",\"f504001\":\"HUAWEINXT-DL00\",\"f609001\":\"0\",\"f601001\":\"1\",\"f301001\":\"3558\",\"f303001\":\"2\",\"f605001\":\"-1\",\"f603001\":\"1\",\"f110001\":\"1\",\"f607001\":\"0\",\"f502001\":\"8\",\"f108001\":\"3964\",\"f502002\":\"0\",\"f611001\":\"1\",\"f403004\":\"0\",\"f101001\":\"15658\",\"f505001\":\"1700-2699\",\"f503001\":\"31\",\"f302001\":\"3558\",\"f306001\":\"2\"}";
        JSONObject featureIdxMap = JSON.parseObject((String)featureStr);
        TFServingClient tfServingClient = new TFServingClient("10.50.201.72", 9000, "dcn-ctr-002", null);
        int times = 100;
        System.out.println("start " + DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));
        long tStart = System.currentTimeMillis();
        for (int j = 0; j < times; ++j) {
            HashMap<String, JSONObject> req2 = new HashMap<String, JSONObject>();
            for (int i = 0; i < 100; ++i) {
                req2.put("a" + i, featureIdxMap);
            }
            Map retTmp = m.predictWithTF(req2, tfServingClient);
            System.out.println(j);
        }
        long tEnd = System.currentTimeMillis();
        System.out.println("end " + DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));
        System.out.println("diff=" + (tEnd - tStart) / (long)times);
    }

    static class RunnableThread
    implements Runnable {
        private ESMM model;

        RunnableThread(ESMM model) {
            this.model = model;
        }

        @Override
        public void run() {
            try {
                ModelReadTest.testESMM(this.model);
                System.out.println("\u901a\u8fc7\u7ebf\u7a0b\u6c60\u65b9\u5f0f\u521b\u5efa\u7684\u7ebf\u7a0b\uff1a" + Thread.currentThread().getName() + " ");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

