package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.alg.plugins.ActPlugInDQNRcmder;
import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInRcmdDo;
import cn.com.duiba.nezha.alg.example.util.StdCoderModelSaveBo;
import cn.com.duiba.nezha.alg.feature.vo.ActFeatureDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSON;
import org.junit.Test;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActPlugInDQNRcmder2Test {

    @Test
    public void feaureParse() {

        ActFeatureDo actFeatureDo = new ActFeatureDo();

        actFeatureDo.setResPlugInId(1L);
        actFeatureDo.setResPlugInIndex(2L);
        actFeatureDo.setAppId(100L);
        actFeatureDo.setAreaCode(3301L);

        System.out.println(JSON.toJSONString(ActPlugInDQNRcmder.feaureParse(actFeatureDo)));

    }

    @Test
    public void rcmd() {


        //1 编码器获取 缓存
        CODER coderModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("act_resplug_coder_dqn_v001", "act");

        //2 TF本地模型获取  缓存
        LocalTFModel ltfModel = new LocalTFModel();
        try {
            ltfModel.loadModel("/Users/lwj/Desktop/model2/");


//            String plugListStr = "[{\"activityPage\":17918,\"dsm2A\":1,\"key\":\"279179_17918_1_2176_2\",\"resPlugInId\":2176,\"resPlugInIndex\":2,\"resPlugInStatDo\":{\"clickPv\":5021,\"convertPv\":336,\"costFee\":24955,\"joinPv\":131,\"launchCnt\":7230,\"resPlugInId\":2176,\"resPlugInIndex\":2,\"slotId\":279179,\"updateTime\":\"2019-12-12 16:04:52\",\"visitPv\":3563},\"slotId\":279179},{\"activityPage\":17918,\"dsm2A\":1,\"key\":\"279179_17918_1_2169_2\",\"resPlugInId\":2169,\"resPlugInIndex\":2,\"resPlugIn\n" +
//                    "StatDo\":{\"clickPv\":4762,\"convertPv\":452,\"costFee\":26343,\"joinPv\":69,\"launchCnt\":7380,\"resPlugInId\":2169,\"resPlugInIndex\":2,\"slotId\":279179,\"updateTime\":\"2019-12-12 16:04:52\",\"visitPv\":3784},\"slotId\":279179},{\"activityPage\":17918,\"dsm2A\":1,\"key\":\"279179_17918_1_2156_0\",\"resPlugInId\":2156,\"resPlugInIndex\":0,\"resPlugInStatDo\":{\"clickPv\":1174,\"convertPv\":111,\"costFee\":7028,\"joinPv\":0,\"launchCnt\":1695,\"resPlugInId\":2156,\"resPlugInIndex\":0,\"slotId\":279179,\"updateTime\":\"2019-12-12 16:03:59\",\"visitPv\":1035},\"slotId\":279179},{\"activityPage\":17918,\"dsm2A\":1,\"key\":\"279179_17918_1_2041_2\",\"resPlugInId\":2041,\"resPlugInIndex\":2,\"resPlugInStatDo\":{\"clickPv\":4557,\"convertPv\":305,\"costFee\":25336,\"joinPv\":162,\"launchCnt\":7188,\"resPlugInId\":2041,\"resPlugInIndex\":2,\"slotId\":279179,\"updateTime\":\"2019-12-12 16:04:52\",\"visitPv\":3664},\"slotId\":279179},{\"activityPage\":17918,\"dsm2A\":1,\"key\":\"279179_17918_1_2041_4\",\"resPlugInId\":2041,\"resPlugInIndex\":4,\"resPlugInStatDo\":{\"clickPv\":4251,\"convertPv\":210,\"costFee\":26860,\"joinPv\":150,\"launchCnt\":5553,\"resPlugInId\":2041,\"resPlugInIndex\":4,\"slotId\":279179,\"updateTime\":\"2019-12-12 16:04:52\",\"visitPv\":3664},\"slotId\":279179},{\"activityPage\":17918,\"dsm2A\":1,\"key\":\"279179_17918_1_null_null\",\"resPlugInStatDo\":{},\"slotId\":279179},{\"activityPage\":16394,\"dsm2A\":1,\"key\":\"300643_16394_1_2140_4\",\"resPlugInId\":2140,\"resPlugInIndex\":4,\"resPlugInStatDo\":{},\"slotId\":300643}]";

            //3 创意特征对象List
//            List<ResPlugInRcmdDo> plugList = JSON.parseArray(plugListStr, ResPlugInRcmdDo.class);
            List<ResPlugInRcmdDo> plugList = new ArrayList<>();

            String pS = "{\"activityPage\":17918,\"dsm2A\":1,\"resPlugInId\":null,\"resPlugInIndex\":null,\"resPlugInStatDo\":{\"clickPv\":77,\"convertPv\":2,\"costFee\":1485,\"joinPv\":424,\"launchCnt\":368,\"slotId\":299410,\"updateTime\":\"2020-01-16 00:00:05\",\"visitPv\":2000}}";
            ResPlugInRcmdDo p = JSON.parseObject(pS, ResPlugInRcmdDo.class);
            plugList.add(p);

//            String pSq = "{\"activityPage\":17918,\"dsm2A\":1,\"resPlugInId\":null,\"resPlugInIndex\":1,\"resPlugInStatDo\":{\"clickPv\":5021,\"convertPv\":336,\"costFee\":24955,\"joinPv\":131,\"launchCnt\":7230,\"resPlugInId\":2176,\"resPlugInIndex\":2,\"slotId\":279179,\"updateTime\":\"2019-12-12 16:04:52\",\"visitPv\":3563},\"slotId\":279179}";
//            ResPlugInRcmdDo pq = JSON.parseObject(pSq, ResPlugInRcmdDo.class);
//            plugList.add(pq);

            String p0S = "{\"activityPage\":17918,\"dsm2A\":1,\"resPlugInId\":2041,\"resPlugInIndex\":0,\"resPlugInStatDo\":{\"clickPv\":97,\"convertPv\":1,\"costFee\":1695,\"joinPv\":941,\"launchCnt\":916,\"resPlugInId\":2041,\"resPlugInIndex\":0,\"slotId\":299410,\"updateTime\":\"2020-01-16 00:00:05\",\"visitPv\":2577}}";
            ResPlugInRcmdDo p0 = JSON.parseObject(p0S, ResPlugInRcmdDo.class);
            plugList.add(p0);

            String p1S = "{\"activityPage\":17918,\"dsm2A\":1,\"mergeRpm\":0.0,\"pRpm\":0.0,\"resPlugInId\":2041,\"resPlugInIndex\":1,\"slotId\":279179,\"resPlugInStatDo\":{\"clickPv\":84,\"convertPv\":1,\"costFee\":1630,\"joinPv\":264,\"launchCnt\":197,\"resPlugInId\":2041,\"resPlugInIndex\":1,\"slotId\":299410,\"updateTime\":\"2020-01-16 00:00:05\",\"visitPv\":2020}}";
            ResPlugInRcmdDo p1 = JSON.parseObject(p1S, ResPlugInRcmdDo.class);
            plugList.add(p1);
            String p2S = "{\"activityPage\":17918,\"dsm2A\":1,\"mergeRpm\":0.0,\"pRpm\":0.0,\"resPlugInId\":2041,\"resPlugInIndex\":2,\"slotId\":279179,\"resPlugInStatDo\":{\"clickPv\":2,\"convertPv\":0,\"costFee\":28,\"joinPv\":42,\"launchCnt\":17,\"resPlugInId\":2041,\"resPlugInIndex\":2,\"slotId\":299410,\"updateTime\":\"2020-01-16 00:00:05\",\"visitPv\":68}}";
            ResPlugInRcmdDo p2 = JSON.parseObject(p2S, ResPlugInRcmdDo.class);
            plugList.add(p2);

            String p3S = "{\"activityPage\":17918,\"dsm2A\":1,\"mergeRpm\":0.0,\"pRpm\":0.0,\"resPlugInId\":2041,\"resPlugInIndex\":3,\"slotId\":279179,\"resPlugInStatDo\":{\"clickPv\":5,\"convertPv\":1,\"costFee\":66,\"joinPv\":44,\"launchCnt\":40,\"resPlugInId\":2041,\"resPlugInIndex\":3,\"slotId\":299410,\"updateTime\":\"2020-01-16 00:00:05\",\"visitPv\":144}}";
            ResPlugInRcmdDo p3 = JSON.parseObject(p3S, ResPlugInRcmdDo.class);
            plugList.add(p3);

            String p4S = "{\"activityPage\":17918,\"dsm2A\":1,\"mergeRpm\":0.0,\"pRpm\":0.0,\"resPlugInId\":2041,\"resPlugInIndex\":4,\"slotId\":279179,\"resPlugInStatDo\":{\"clickPv\":67,\"convertPv\":1,\"costFee\":1145,\"joinPv\":811,\"launchCnt\":782,\"resPlugInId\":2041,\"resPlugInIndex\":4,\"slotId\":299410,\"updateTime\":\"2020-01-16 00:00:05\",\"visitPv\":2002}}";
            ResPlugInRcmdDo p4 = JSON.parseObject(p4S, ResPlugInRcmdDo.class);
            plugList.add(p4);


            String p01S = "{\"activityPage\":17918,\"dsm2A\":1,\"mergeRpm\":0.0,\"pRpm\":0.0,\"resPlugInId\":2043,\"resPlugInIndex\":0,\"slotId\":279179,\"resPlugInStatDo\":null}";
            ResPlugInRcmdDo p01 = JSON.parseObject(p01S, ResPlugInRcmdDo.class);
            plugList.add(p01);

            String p11S = "{\"activityPage\":17918,\"dsm2A\":1,\"mergeRpm\":0.0,\"pRpm\":0.0,\"resPlugInId\":2043,\"resPlugInIndex\":1,\"slotId\":279179}";
            ResPlugInRcmdDo p11= JSON.parseObject(p11S, ResPlugInRcmdDo.class);
            plugList.add(p11);
            String p21S = "{\"activityPage\":17918,\"dsm2A\":1,\"mergeRpm\":0.0,\"pRpm\":0.0,\"resPlugInId\":2043,\"resPlugInIndex\":2,\"slotId\":279179}";
            ResPlugInRcmdDo p21 = JSON.parseObject(p21S, ResPlugInRcmdDo.class);
            plugList.add(p21);

            String p31S = "{\"activityPage\":17918,\"dsm2A\":1,\"mergeRpm\":0.0,\"pRpm\":0.0,\"resPlugInId\":2043,\"resPlugInIndex\":3,\"slotId\":279179}";
            ResPlugInRcmdDo p31 = JSON.parseObject(p31S, ResPlugInRcmdDo.class);
            plugList.add(p31);

            String p41S = "{\"activityPage\":17918,\"dsm2A\":1,\"mergeRpm\":0.0,\"pRpm\":0.0,\"resPlugInId\":2043,\"resPlugInIndex\":4,\"slotId\":279179}";
            ResPlugInRcmdDo p41 = JSON.parseObject(p41S, ResPlugInRcmdDo.class);
            plugList.add(p41);



            //4 获取非创意特征（同点击率预估模型）

            //5 获取资源位创意推荐统计对象（算法1，入参）

            //6 预估

            String featureStr = "{\"activityId\":17918,\"activityPage\":17918,\"appId\":52250,\"areaCode\":3301,\"dsm2A\":1,\"slotId\":279179}";

            ActFeatureDo actFeatureDo = JSON.parseObject(featureStr, ActFeatureDo.class);
            actFeatureDo.setAppId(300L);
            actFeatureDo.setActivityId(30L);

//            coderModel = null;

//            System.out.println("coder="+JSON.toJSONString(coderModel));

            Map<String, Long> retMap = new HashMap<>();

            System.out.println(LocalDateTime.now());


            for (int i = 0; i < 12000; i++) {
                ResPlugInRcmdDo ret1 = ActPlugInDQNRcmder.rcmd2(plugList, actFeatureDo, coderModel, ltfModel);

//                System.out.println("ret="+JSON.toJSONString(ret1));
                if (ret1 != null) {
                    retMap.put(ret1.getKey(), retMap.getOrDefault(ret1.getKey(), 0L) + 1);
                } else {
                    retMap.put(null, retMap.getOrDefault(null, 0L) + 1);
                }
            }

            System.out.println("retMap=" + JSON.toJSONString(retMap));

            System.out.println(LocalDateTime.now());

        } catch (Exception e) {
            e.printStackTrace();
            System.out.println(e);

        }
    }

    @Test
    public void rcmdWithMap() {
    }

    @Test
    public void rcmd2() {
    }
}