/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.example.util;

import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlModel;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.common.util.StringZIP;
import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.conf.JedisPoolConf;
import com.alibaba.fastjson.JSON;

public class StatSyncBo {
    public static JedisUtil jedisUtil = new JedisUtil(JedisPoolConf.jedisConfig);

    public static String getModelKey(String modelId, String groupId) {
        String ret = null;
        if (groupId != null) {
            ret = "NZ_K86_nz_alg_s_m_" + modelId + "_" + groupId;
        }
        if (groupId == null) {
            ret = "NZ_K86_nz_alg_s_m_" + modelId;
        }
        return ret;
    }

    public static void saveModelToRedis(OcpxControlModel ocpxControlModel, String modelId, int ttl) {
        String key = StatSyncBo.getModelKey(modelId, null);
        System.out.println("saveModelToRedis key=" + key);
        try {
            String value = JSON.toJSONString((Object)ocpxControlModel);
            String value2 = StringZIP.zipString((String)value);
            jedisUtil.setex(key, value2, ttl);
            String updateTimeKey = key + "_update_time";
            String updateTime = LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
            jedisUtil.setex(updateTimeKey, updateTime, ttl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static OcpxControlModel readModelFromRedis(String modelId) {
        String key = StatSyncBo.getModelKey(modelId, null);
        OcpxControlModel ret = null;
        System.out.println("readModelFromRedis key=" + key);
        try {
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (OcpxControlModel)JSON.parseObject((String)ret2, OcpxControlModel.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

