/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ADXShuntVolumeExample {
    public static double multipleRatio = 0.2;

    public static void main(String[] args) {
        List<Long> ideaList = Arrays.asList(101L, 102L, 103L);
        HashMap<Long, Double> weightMap = new HashMap<Long, Double>();
        weightMap.put(101L, 0.6);
        weightMap.put(102L, 0.2);
        weightMap.put(103L, 0.2);
        for (int i = 0; i < 10; ++i) {
            HashMap<Long, Long> ideaReqCntMap = new HashMap<Long, Long>();
            for (int j = 0; j < 10000; ++j) {
                List<Long> validIdeaList = ADXShuntVolumeExample.getValidIdea(ideaList, ideaReqCntMap);
                Long idea = ADXShuntVolumeExample.rand(validIdeaList, weightMap);
                ideaReqCntMap.put(idea, ideaReqCntMap.getOrDefault(idea, 0L) + 1L);
            }
            System.out.println("i=" + i + ",ideaReqCntMap=" + JSON.toJSONString(ideaReqCntMap));
        }
    }

    public static List<Long> getValidIdea(List<Long> ideas, Map<Long, Long> ideaReqCntMap) {
        int i;
        List<Long> ret = ideas;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{ideas, ideaReqCntMap})) {
            return ret;
        }
        double weightSum = 0.0;
        for (i = 0; i < ideas.size(); ++i) {
            weightSum += (double)ideaReqCntMap.getOrDefault(ideas.get(i), 1L).longValue();
        }
        ret = new ArrayList<Long>();
        for (i = 0; i < ideas.size(); ++i) {
            double weightTmp = ideaReqCntMap.getOrDefault(ideas.get(i), 1L).longValue();
            if (Math.random() <= weightTmp / weightSum && Math.random() <= 0.8) continue;
            ret.add(ideas.get(i));
        }
        return ret;
    }

    public static Long rand(List<Long> ideas, Map<Long, Double> weightMap) {
        Long ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{ideas, weightMap})) {
            return ret;
        }
        double weightSum = 0.0;
        for (int i = 0; i < ideas.size(); ++i) {
            weightSum += weightMap.getOrDefault(ideas.get(i), 1.0E-7).doubleValue();
        }
        double rand = Math.random() * weightSum;
        double weightSumTmp = 0.0;
        for (int i = 0; i < ideas.size(); ++i) {
            if (!(rand <= (weightSumTmp += weightMap.getOrDefault(ideas.get(i), 1.0E-7).doubleValue()))) continue;
            ret = ideas.get(i);
            break;
        }
        return ret;
    }

    public static Long rand2(List<Long> ideas, Map<Long, Long> weightMap) {
        HashMap<Long, Double> map = new HashMap<Long, Double>();
        weightMap.forEach((k, v) -> map.put((Long)k, (double)v.longValue() + 0.0));
        return ADXShuntVolumeExample.rand(ideas, map);
    }
}

