package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.StdCoderModelSaveBo;
import cn.com.duiba.nezha.alg.example.util.conf.JedisConfig;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import cn.com.duiba.nezha.alg.model.vo.CodeDo;
import com.alibaba.fastjson.JSON;
import org.junit.Test;

import java.util.HashMap;
import java.util.Map;

public class RTBTest {
    public JedisUtil getJudis() {
        JedisConfig jcOnline = new JedisConfig();
        jcOnline.setIp("r-bp1p7jdgwk8c6ybmzk.redis.rds.aliyuncs.com");
        jcOnline.setPassWord("pMuMLAD3g8K63k7qCKzZeZ7");
        jcOnline.setPort(6379);
        JedisUtil juOnline = new JedisUtil(jcOnline);
        return juOnline;
    }


    public DeepModelV2 getCoder(String key) {
        JedisUtil juOnline = getJudis();
        DeepModelV2 codeModel = StdCoderModelSaveBo.getADXDeepModelV2ByKeyFromJedis(key, juOnline);
        System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));

        if(codeModel==null){
            System.out.println("codeModel is null");
        }
        return codeModel;
    }

    public LocalTFModelV2 getTfModel(String path) throws Exception{
        LocalTFModelV2 ltfModel = new LocalTFModelV2();
        ltfModel.loadModel(path);
        return ltfModel;
    }

    public Map<Long, Double>  predict(CODER coder, LocalTFModel tfModel, Map<Long, FeatureMapDo> featureMapDoMap) throws Exception {
        Map<Long, Double> ret = new HashMap<>();
        ret = coder.predictWithLocalTFNew(featureMapDoMap, tfModel);
        return ret;
    }

    public Map<Long, FeatureMapDo> getFeatureMapDo() {
        Map<Long, FeatureMapDo> featureMapDoMap = new HashMap<>();

        String str1 = "{\"f0309\":\"0\",\"f0308\":\"0\",\"f0307\":\"0\",\"f4010050\":\"OPPO\",\"f411004\":\"0\",\"f5020070\":\"0\",\"f6010070\":\"\",\"f3030011\":\"\",\"f309040\":\"0.0\",\"f0302\":\"0\",\"f0301\":\"0\",\"f0306\":\"0\",\"f0305\":\"0\",\"f0304\":\"0\",\"f0303\":\"0\",\"f5010036\":\"0\",\"f5010035\":\"0\",\"f414004\":\"0\",\"f5010034\":\"0\",\"f5010033\":\"0\",\"f6010100\":\"1\",\"f3010010\":\"32504\",\"f5020060\":\"0\",\"f5020101\":\"0\",\"f5020103\":\"0\",\"f309050\":\"0.0\",\"f5020102\":\"0\",\"f5020105\":\"1000\",\"f5020104\":\"1000\",\"f5020106\":\"1000\",\"f4010070\":\"0\",\"f413004\":\"0\",\"f5020090\":\"0\",\"f2010010\":\"1120\",\"f5020010\":\"0\",\"f0320\":\"0\",\"f307040\":\"0.0\",\"f0203\":\"0\",\"f0202\":\"0\",\"f0201\":\"0\",\"f0321\":\"0\",\"f0204\":\"0\",\"f0319\":\"0\",\"f0318\":\"0\",\"f4010060\":\"PECM30\",\"f5020080\":\"0\",\"f1010020\":\"19\",\"f3060017\":\"1\",\"f3060016\":\"1\",\"f307050\":\"0.0\",\"f3060013\":\"1\",\"f5010050\":\"0b7ffb7f288c113507e90abf0f213501\",\"f0313\":\"0\",\"f3060012\":\"4\",\"f0312\":\"0\",\"f3060015\":\"1\",\"f7040050\":\"0\",\"f0311\":\"0\",\"f3060014\":\"17\",\"f0310\":\"0\",\"f0317\":\"0\",\"f0316\":\"0\",\"f3060011\":\"5\",\"f0315\":\"0\",\"f3060010\":\"32504&b37908aa\",\"f0314\":\"0\",\"f4010010\":\"Dalvik/2.1.0 (Linux; U; Android 11; PECM30 Build/RP1A.200720.011)\",\"f7040060\":\"0\",\"f4010091\":\"2\",\"f409004\":\"0\",\"f5020030\":\"0\",\"f1010010\":\"129\",\"f5010060\":\"0\",\"f3020000\":\"0\",\"f5010079\":\"0\",\"f4010121\":\"6\",\"f5010078\":\"0\",\"f5010110\":\"4\",\"f5010077\":\"0\",\"f5030101\":\"129&1000\",\"f5030102\":\"1120&1000\",\"f2010060\":\"8035700\",\"f5030103\":\"32504&1000\",\"f410004\":\"0\",\"f2010062\":\"2701\",\"f2010061\":\"b37908aa\",\"f4010080\":\"1\",\"f5020020\":\"0\",\"f6010020\":\"com.yicong.ants\",\"f5010070\":\"0\",\"f5010076\":\"0\",\"f4010122\":\"7\",\"f5010075\":\"0\",\"f5010074\":\"0\",\"f4010031\":\"83\",\"f4010030\":\"4113\",\"f0408\":\"null\",\"f0407\":\"null\",\"f4010032\":\"3\",\"f0406\":\"null\",\"f7040080\":\"0\",\"f3010144\":\"3\",\"f3010143\":\"7\",\"f3010142\":\"0\",\"f6010010\":\"b37908aa\",\"f3010141\":\"3\",\"f5020050\":\"0\",\"f6010090\":\"80088008880\",\"f0001\":\"6\",\"f3010145\":\"1\",\"f0401\":\"null\",\"f5010082\":\"0\",\"f5010081\":\"0\",\"f0003\":\"1\",\"f5010080\":\"0\",\"f0002\":\"7\",\"f0405\":\"null\",\"f0404\":\"null\",\"f0403\":\"null\",\"f0402\":\"null\",\"f4010020\":\"219.154.177.107\",\"f5010135\":\"\",\"f5010134\":\"\",\"f5010133\":\"\",\"f4010021\":\"DYN\",\"f412004\":\"0\",\"f7040090\":\"0\",\"f5010136\":\"\",\"f5020040\":\"0\",\"f5010090\":\"0\",\"f6060010\":\"1120&b37908aa\",\"f6060011\":\"343\",\"f6060012\":\"83\",\"f6060013\":\"0\",\"f6060014\":\"17\",\"f6060015\":\"1\",\"f5010010\":\"010105\"}";
        Map<String, String> featureIdxMap1 = (Map) JSON.parseObject(str1);

        String str2 = "{\"f101001\":\"69442\"}";
        Map<String, String> featureIdxMap2 = (Map) JSON.parseObject(str2);

        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(featureIdxMap1);
        featureMapDo.setDynamicFeatureMap(featureIdxMap2);
        featureMapDoMap.put(69442l, featureMapDo);
        return featureMapDoMap;

    }

    @Test
    public void test() throws Exception {
        DeepModelV2 coder = getCoder("adx_coder_v004");
        String str1 = "{\"f0309\":\"0\",\"f0308\":\"0\",\"f0307\":\"0\",\"f4010050\":\"OPPO\",\"f411004\":\"0\",\"f5020070\":\"0\",\"f6010070\":\"\",\"f3030011\":\"\",\"f309040\":\"0.0\",\"f0302\":\"0\",\"f0301\":\"0\",\"f0306\":\"0\",\"f0305\":\"0\",\"f0304\":\"0\",\"f0303\":\"0\",\"f5010036\":\"0\",\"f5010035\":\"0\",\"f414004\":\"0\",\"f5010034\":\"0\",\"f5010033\":\"0\",\"f6010100\":\"1\",\"f3010010\":\"32504\",\"f5020060\":\"0\",\"f5020101\":\"0\",\"f5020103\":\"0\",\"f309050\":\"0.0\",\"f5020102\":\"0\",\"f5020105\":\"1000\",\"f5020104\":\"1000\",\"f5020106\":\"1000\",\"f4010070\":\"0\",\"f413004\":\"0\",\"f5020090\":\"0\",\"f2010010\":\"1120\",\"f5020010\":\"0\",\"f0320\":\"0\",\"f307040\":\"0.0\",\"f0203\":\"0\",\"f0202\":\"0\",\"f0201\":\"0\",\"f0321\":\"0\",\"f0204\":\"0\",\"f0319\":\"0\",\"f0318\":\"0\",\"f4010060\":\"PECM30\",\"f5020080\":\"0\",\"f1010020\":\"19\",\"f3060017\":\"1\",\"f3060016\":\"1\",\"f307050\":\"0.0\",\"f3060013\":\"1\",\"f5010050\":\"0b7ffb7f288c113507e90abf0f213501\",\"f0313\":\"0\",\"f3060012\":\"4\",\"f0312\":\"0\",\"f3060015\":\"1\",\"f7040050\":\"0\",\"f0311\":\"0\",\"f3060014\":\"17\",\"f0310\":\"0\",\"f0317\":\"0\",\"f0316\":\"0\",\"f3060011\":\"5\",\"f0315\":\"0\",\"f3060010\":\"32504&b37908aa\",\"f0314\":\"0\",\"f4010010\":\"Dalvik/2.1.0 (Linux; U; Android 11; PECM30 Build/RP1A.200720.011)\",\"f7040060\":\"0\",\"f4010091\":\"2\",\"f409004\":\"0\",\"f5020030\":\"0\",\"f1010010\":\"129\",\"f5010060\":\"0\",\"f3020000\":\"0\",\"f5010079\":\"0\",\"f4010121\":\"6\",\"f5010078\":\"0\",\"f5010110\":\"4\",\"f5010077\":\"0\",\"f5030101\":\"129&1000\",\"f5030102\":\"1120&1000\",\"f2010060\":\"8035700\",\"f5030103\":\"32504&1000\",\"f410004\":\"0\",\"f2010062\":\"2701\",\"f2010061\":\"b37908aa\",\"f4010080\":\"1\",\"f5020020\":\"0\",\"f6010020\":\"com.yicong.ants\",\"f5010070\":\"0\",\"f5010076\":\"0\",\"f4010122\":\"7\",\"f5010075\":\"0\",\"f5010074\":\"0\",\"f4010031\":\"83\",\"f4010030\":\"4113\",\"f0408\":\"null\",\"f0407\":\"null\",\"f4010032\":\"3\",\"f0406\":\"null\",\"f7040080\":\"0\",\"f3010144\":\"3\",\"f3010143\":\"7\",\"f3010142\":\"0\",\"f6010010\":\"b37908aa\",\"f3010141\":\"3\",\"f5020050\":\"0\",\"f6010090\":\"80088008880\",\"f0001\":\"6\",\"f3010145\":\"1\",\"f0401\":\"null\",\"f5010082\":\"0\",\"f5010081\":\"0\",\"f0003\":\"1\",\"f5010080\":\"0\",\"f0002\":\"7\",\"f0405\":\"null\",\"f0404\":\"null\",\"f0403\":\"null\",\"f0402\":\"null\",\"f4010020\":\"219.154.177.107\",\"f5010135\":\"\",\"f5010134\":\"\",\"f5010133\":\"\",\"f4010021\":\"DYN\",\"f412004\":\"0\",\"f7040090\":\"0\",\"f5010136\":\"\",\"f5020040\":\"0\",\"f5010090\":\"0\",\"f6060010\":\"1120&b37908aa\",\"f6060011\":\"343\",\"f6060012\":\"83\",\"f6060013\":\"0\",\"f6060014\":\"17\",\"f6060015\":\"1\",\"f5010010\":\"010105\"}";
        Map<String, String> featureIdxMap1 = (Map) JSON.parseObject(str1);
        CodeDo codeDo=coder.getSampleDense(featureIdxMap1, null);
        System.out.println("codeDo="+JSON.toJSONString(codeDo));

    }
}
