package cn.com.duiba.nezha.alg.example.example.act;

import cn.com.duiba.nezha.alg.alg.activity.ActivityParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlModel;
import cn.com.duiba.nezha.alg.example.util.*;
import cn.com.duiba.nezha.alg.example.util.conf.JedisConfig;
import cn.com.duiba.nezha.alg.example.util.conf.JedisPoolConf;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.*;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSON;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.TimeUnit;

//import jdk.nashorn.internal.ir.debug.ObjectSizeCalculator;

public class LocalModelTest {

    public static Logger logger = LoggerFactory.getLogger(LocalModelTest.class);

    public static JedisUtil testJedis = null;

    public static void main(String[] args) {
        initJedis();
        initDeepModelV2();
        initActivityParams();
    }


    public static void initJedis() {

        JedisConfig jcOffline = new JedisConfig();

        jcOffline.setIp("test.config.dui88.com");
        jcOffline.setPassWord("duiba123");
        jcOffline.setPort(6379);
        testJedis = new JedisUtil(jcOffline);

    }

    public static void initDeepModelV2() {
        String key = "ALG:ACT:CODER:act_coder_v001";

        DeepModelV2 deepModelV2 = new DeepModelV2();
        deepModelV2.setModelId("act_test");


        StdCoderModelSaveBo.saveToJedis(key, deepModelV2, testJedis);

        DeepModelV2 ret = StdCoderModelSaveBo.getFromRedis(key,DeepModelV2.class,testJedis);

        System.out.println("initDeepModelV2,ret="+JSON.toJSONString(ret));

    }

    public static void initActivityParams() {
        String key = "ALG:ACT:DATA:284774";

        ActivityParams activityParams = new ActivityParams();

        activityParams.setSlotId(101L);
        StdCoderModelSaveBo.saveToJedis(key, activityParams, testJedis);
        ActivityParams ret = StdCoderModelSaveBo.getFromRedis(key,ActivityParams.class,testJedis);

        System.out.println("initActivityParams,ret="+JSON.toJSONString(ret));
    }

}
