package cn.com.duiba.nezha.alg.example.example.dpa;

import cn.com.duiba.nezha.alg.example.util.StdCoderModelSaveBo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import com.alibaba.fastjson.JSON;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DPAJOIN000Test {
    public static void main (String[] args) {
        {
            String[] features = {
                    "f240111",
                    "f240110",
                    "f240211",
                    "f240210",
                    "f240310",
                    "f240410",
                    "f240411",
                    "f240311",
                    "f201001",
                    "f240013",
                    "f494012",
                    "f108001",
                    "f494039",
                    "f494049",
                    "f240014",
                    "f412002",
                    "f494029",
                    "f301001",
                    "f242002",
                    "f494011",
                    "f494010",
                    "f242001",
                    "f494019",
                    "f332031",
                    "f332041",
                    "f332021",
                    "f332011",
                    "f412004",
                    "f230013",
                    "f493012",
                    "f411002",
                    "f495011",
                    "f495010",
                    "f214003",
                    "f230001",
                    "f411001",
                    "f493010",
                    "f493011",
                    "f241014",
                    "f231001",
                    "f411004",
                    "f241013",
                    "f212003",
                    "f353011",
                    "f414007",
                    "f414003"
            };
            test01(features);
        }

    }

    public static void test01 (String[] features) {
        BufferedReader br = null;
        try {
            int cnt = 0;
            String line;
            CODER clickCoderModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("deep_fm_e2e_dpa_join_v001", "dpa");
            TFServingClient tfServingClient = new TFServingClient("10.50.203.185", 9000, "deepfm-e2e-dpa-join-v003", null);

            for (String feat : features) {

                Map<Integer, FeatureMapDo> featureMapDoMap = new HashMap<>();
                Map<Integer, Double> labelMap = new HashMap<>();
                br = new BufferedReader(new FileReader("/Users/lijingzhe/Desktop/output_join_v001/output_"
                        + feat));
                line = br.readLine();
                while (line != null) {
                    String[] parts = line.split(";");
                    Map<String, String> staticMap = JSON.parseObject(parts[2], Map.class);
                    FeatureMapDo featureMapDo = new FeatureMapDo();
                    featureMapDo.setStaticFeatureMap(staticMap);
                    featureMapDoMap.put(cnt, featureMapDo);
                    double join = Double.parseDouble(parts[1]);
                    labelMap.put(cnt, join > 0 ? Math.log10(join) : 0);
                    line = br.readLine();
                    cnt += 1;
                }
                br.close();

                double avg_diff = 0.0;
                Map<Integer, Double> clickPRpmMap = clickCoderModel.predictWithTFNew(featureMapDoMap, tfServingClient);

                for (Map.Entry<Integer, Double> pair : clickPRpmMap.entrySet()) {  //只能遍历value
                    if(pair.getValue() > 1){
                        System.out.println("pred: " + pair.getValue() + ", label: " + labelMap.get(pair.getKey()));
                    }
                    avg_diff += Math.abs(pair.getValue() - labelMap.get(pair.getKey()));
                }
                System.out.println("without feature " + feat + " mae: " + (avg_diff / cnt));
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (br != null){
                try {
                    br.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }


}
