package cn.com.duiba.nezha.alg.example.example.dpa;

import cn.com.duiba.nezha.alg.example.util.StdCoderModelSaveBo;
import cn.com.duiba.nezha.alg.feature.vo.*;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import com.alibaba.fastjson.JSON;
import cn.com.duiba.nezha.alg.alg.dpa.ActRcmderTFServing;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DPACOST007Test {
    public static void main (String[] args) {
//        {
//            String[] features = {
//                    "f108001", "f201001",
//
//                    "f212003", "f214003",
//
//                    "f301001",
//
//                    "f332011", "f332021", "f332031", "f332041",
//
//                    "f353011",
//
//                    "f411001", "f411002", "f411004",
//
//                    "f412002", "f412004",
//
//                    "f414003", "f414007",
//
//                    "f415001", "f415002", "f415003",
//
//                    "f451001", "f451002", "f451003", "f451004",
//
//                    "f493013", "f493014", "f493015",
//
//                    "f494013", "f494014", "f494015",
//
//                    "f495013", "f495014", "f495015",
//
//                    "f240001", "f240002", "f240003",
//                    "f240110", "f240210", "f240310", "f240410",
//                    "f240111", "f240211", "f240311", "f240411",
//                    "f240013", "f240014", "f240015",
//
//                    "f241001", "f241002", "f241003",
//                    "f241110", "f241210", "f241310", "f241410",
//                    "f241111", "f241211", "f241311", "f241411",
//                    "f241013", "f241014", "f241015",
//
//                    "f242001", "f242002", "f242003",
//                    "f242110", "f242210", "f242310", "f242410",
//                    "f242111", "f242211", "f242311", "f242411",
//                    "f242013", "f242014", "f242015",
//
//                    "f808001", "f808002"
//            };
//            test01(features);
//        }
//        test05();
//        test06();
//        test07();
//        test08();
        interceptTest01();

    }

    public static void test01 (String[] features) {
        BufferedReader br = null;
        try {
            int cnt = 0;
            String line;
            CODER clickCoderModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("deep_fm_e2e_dpa_cost_v009", "dpa");
            TFServingClient tfServingClient = new TFServingClient("10.50.203.161", 9000, "deepfm-e2e-dpa-cost-v009", null);
            for (String feat : features) {

                Map<Integer, FeatureMapDo> featureMapDoMap = new HashMap<>();
                Map<Integer, Double> labelMap = new HashMap<>();
                br = new BufferedReader(new FileReader("/Users/xingweichen/Desktop/output/output_"
                        + feat));
                line = br.readLine();
                while (line != null) {
                    String[] parts = line.split(";");
                    Map<String, String> staticMap = JSON.parseObject(parts[2], Map.class);
                    FeatureMapDo featureMapDo = new FeatureMapDo();
                    featureMapDo.setStaticFeatureMap(staticMap);
                    featureMapDoMap.put(cnt, featureMapDo);
                    double fee = Double.parseDouble(parts[0]);
                    labelMap.put(cnt, fee > 0 ? Math.log10(fee) : 0);
                    line = br.readLine();
                    cnt += 1;
                }
                br.close();

                double avg_diff = 0.0;
                Map<Integer, Double> clickPRpmMap = clickCoderModel.predictWithTFNew(featureMapDoMap, tfServingClient);
                for (Map.Entry<Integer, Double> pair : clickPRpmMap.entrySet()) {  //只能遍历value
//                    System.out.println("pred: " + pair.getValue() + ", label: " + labelMap.get(pair.getKey()));
                    avg_diff += Math.abs(pair.getValue() - labelMap.get(pair.getKey()));
                }
                System.out.println("without feature " + feat + " mae: " + (avg_diff / cnt));
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (br != null){
                try {
                    br.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }


    public static void test02 () {
        Map<Integer, FeatureMapDo> featureMapDoMap = new HashMap<>();
        Map<Integer, Double> labelMap = new HashMap<>();
        int cnt = 0;
        try {
            BufferedReader br = new BufferedReader(new FileReader("/Users/xingweichen/Desktop/output"));
            try {
                String line = br.readLine();
                while (line != null) {
                    String[] parts = line.split(";");
                    Map<String, String> staticMap = JSON.parseObject(parts[2], Map.class);
                    FeatureMapDo featureMapDo = new FeatureMapDo();
                    featureMapDo.setStaticFeatureMap(staticMap);
                    featureMapDoMap.put(cnt, featureMapDo);
                    double fee = Double.parseDouble(parts[0]);
                    labelMap.put(cnt, fee > 0 ? Math.log10(fee): 0);
                    line = br.readLine();
                    cnt += 1;
                }
            } finally {
                br.close();
            }

            CODER clickCoderModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("deep_fm_e2e_dpa_cost_v007", "dpa");
            TFServingClient tfServingClient = new TFServingClient("10.50.203.159", 9000, "deepfm-e2e-dpa-cost-v007-fix", null);
            Map<Integer, Double> clickPRpmMap = clickCoderModel.predictWithTFNew(featureMapDoMap, tfServingClient);
            for(Map.Entry<Integer, Double> pair : clickPRpmMap.entrySet()){  //只能遍历value
                System.out.println("pred: " + pair.getValue()  + ", label: " + labelMap.get(pair.getKey()));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public static void test03 () {
        Map<Integer, FeatureMapDo> featureMapDoMap = new HashMap<>();
        Map<Integer, Double> labelMap = new HashMap<>();
        int cnt = 0;
        try {
            BufferedReader br = new BufferedReader(new FileReader("/Users/xingweichen/Desktop/output/output_f493014"));
            try {
                String line = br.readLine();
                while (line != null) {
                    String[] parts = line.split(";");
                    Map<String, String> staticMap = JSON.parseObject(parts[2], Map.class);
                    FeatureMapDo featureMapDo = new FeatureMapDo();
                    featureMapDo.setStaticFeatureMap(staticMap);
                    featureMapDoMap.put(cnt, featureMapDo);
                    double fee = Double.parseDouble(parts[0]);
                    labelMap.put(cnt, fee);
                    line = br.readLine();
                    cnt += 1;
                    if (cnt > 10) {break;}
                }
            } finally {
                br.close();
            }

            CODER clickCoderModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("deep_fm_e2e_dpa_cost_v009", "dpa");
            TFServingClient tfServingClient = new TFServingClient("10.50.203.176", 9000, "deepfm-e2e-dpa-cost-v010", null);
            Map<Integer, Double> clickPRpmMap = clickCoderModel.predictWithTFNew(featureMapDoMap, tfServingClient);
            for(Map.Entry<Integer, Double> pair : clickPRpmMap.entrySet()){  //只能遍历value
                System.out.println("pred: " + pair.getValue()  + ", label: " + labelMap.get(pair.getKey()));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public static void test04 () {
        Map<Integer, FeatureMapDo> featureMapDoMap = new HashMap<>();
        Map<Integer, Double> labelMap = new HashMap<>();
        int cnt = 0;
        try {
            BufferedReader br = new BufferedReader(new FileReader("/Users/xingweichen/Desktop/output/output_f493014"));
            try {
                String line = br.readLine();
                while (line != null) {
                    String[] parts = line.split(";");
                    Map<String, String> staticMap = JSON.parseObject(parts[2], Map.class);
                    FeatureMapDo featureMapDo = new FeatureMapDo();
                    featureMapDo.setStaticFeatureMap(staticMap);
                    featureMapDoMap.put(cnt, featureMapDo);
                    double fee = Double.parseDouble(parts[0]);
                    labelMap.put(cnt, fee);
                    line = br.readLine();
                    cnt += 1;
//                    if (cnt > 10) {break;}
                }
            } finally {
                br.close();
            }

            CODER clickCoderModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("deep_fm_e2e_dpa_cost_v010", "dpa");
            TFServingClient tfServingClient = new TFServingClient("10.50.203.180", 9000, "deepfm-e2e-dpa-cost-v010", null);
            Map<Integer, Double> clickPRpmMap = clickCoderModel.predictWithTFNew(featureMapDoMap, tfServingClient);
            for(Map.Entry<Integer, Double> pair : clickPRpmMap.entrySet()){  //只能遍历value
                System.out.println("pred: " + pair.getValue()  + ", label: " + labelMap.get(pair.getKey()));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public static void test05 () {
        Map<Integer, FeatureMapDo> featureMapDoMap = new HashMap<>();
        Map<Integer, Double> labelMap = new HashMap<>();
        int cnt = 0;
        try {
            BufferedReader br = new BufferedReader(new FileReader("/Users/xingweichen/Desktop/output/output_f493014"));
            try {
                String line = br.readLine();
                while (line != null) {
                    String[] parts = line.split(";");
                    Map<String, String> staticMap = JSON.parseObject(parts[2], Map.class);
                    FeatureMapDo featureMapDo = new FeatureMapDo();
                    featureMapDo.setStaticFeatureMap(staticMap);
                    featureMapDoMap.put(cnt, featureMapDo);
                    double fee = Double.parseDouble(parts[0]);
                    labelMap.put(cnt, fee);
                    line = br.readLine();
                    cnt += 1;
//                    if (cnt > 10) {break;}
                }
            } finally {
                br.close();
            }

            CODER clickCoderModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("deep_fm_e2e_dpa_cost_nsdk_v010", "dpa");
            TFServingClient tfServingClient = new TFServingClient("10.50.203.182", 9000, "deepfm-e2e-dpa-cost-nsdk-v010", null);
            Map<Integer, Double> clickPRpmMap = clickCoderModel.predictWithTFNew(featureMapDoMap, tfServingClient);
            for(Map.Entry<Integer, Double> pair : clickPRpmMap.entrySet()){  //只能遍历value
                System.out.println("pred: " + pair.getValue()  + ", label: " + labelMap.get(pair.getKey()));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public static void test06 () {
        Map<Integer, FeatureMapDo> featureMapDoMap = new HashMap<>();
        Map<Integer, Double> labelMap = new HashMap<>();
        int cnt = 0;
        try {
            BufferedReader br = new BufferedReader(new FileReader("/Users/xingweichen/Desktop/output/output_f493014"));
            try {
                String line = br.readLine();
                while (line != null) {
                    String[] parts = line.split(";");
                    Map<String, String> staticMap = JSON.parseObject(parts[2], Map.class);
                    FeatureMapDo featureMapDo = new FeatureMapDo();
                    featureMapDo.setStaticFeatureMap(staticMap);
                    featureMapDoMap.put(cnt, featureMapDo);
                    double fee = Double.parseDouble(parts[0]);
                    labelMap.put(cnt, fee);
                    line = br.readLine();
                    cnt += 1;
//                    if (cnt > 10) {break;}
                }
            } finally {
                br.close();
            }

            CODER clickCoderModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("deep_fm_e2e_dpa_cost_sdk_v010", "dpa");
            TFServingClient tfServingClient = new TFServingClient("10.50.203.181", 9000, "deepfm-e2e-dpa-cost-sdk-v010", null);
            Map<Integer, Double> clickPRpmMap = clickCoderModel.predictWithTFNew(featureMapDoMap, tfServingClient);
            for(Map.Entry<Integer, Double> pair : clickPRpmMap.entrySet()){  //只能遍历value
                System.out.println("pred: " + pair.getValue()  + ", label: " + labelMap.get(pair.getKey()));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public static void test07 () {
        Map<Integer, FeatureMapDo> featureMapDoMap = new HashMap<>();
        Map<Integer, Double> labelMap = new HashMap<>();
        int cnt = 0;
        try {
            BufferedReader br = new BufferedReader(new FileReader("/Users/xingweichen/Desktop/output/output_f493014"));
            try {
                String line = br.readLine();
                while (line != null) {
                    String[] parts = line.split(";");
                    Map<String, String> staticMap = JSON.parseObject(parts[2], Map.class);
                    FeatureMapDo featureMapDo = new FeatureMapDo();
                    featureMapDo.setStaticFeatureMap(staticMap);
                    featureMapDoMap.put(cnt, featureMapDo);
                    double fee = Double.parseDouble(parts[0]);
                    labelMap.put(cnt, fee);
                    line = br.readLine();
                    cnt += 1;
//                    if (cnt > 10) {break;}
                }
            } finally {
                br.close();
            }

            CODER clickCoderModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("deep_fm_e2e_dpa_join_v001", "dpa");
            TFServingClient tfServingClient = new TFServingClient("10.50.203.185", 9000, "deepfm-e2e-dpa-join-v003", null);
            Map<Integer, Double> clickPRpmMap = clickCoderModel.predictWithTFNew(featureMapDoMap, tfServingClient);
            for(Map.Entry<Integer, Double> pair : clickPRpmMap.entrySet()){  //只能遍历value
                System.out.println("pred: " + pair.getValue()  + ", label: " + labelMap.get(pair.getKey()));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public static void test08 () {
        Map<Integer, FeatureMapDo> featureMapDoMap = new HashMap<>();
        Map<Integer, Double> labelMap = new HashMap<>();
        int cnt = 0;
        try {
            BufferedReader br = new BufferedReader(new FileReader("/Users/xingweichen/Desktop/output/output_f493014"));
            try {
                String line = br.readLine();
                while (line != null) {
                    String[] parts = line.split(";");
                    Map<String, String> staticMap = JSON.parseObject(parts[2], Map.class);
                    FeatureMapDo featureMapDo = new FeatureMapDo();
                    featureMapDo.setStaticFeatureMap(staticMap);
                    featureMapDoMap.put(cnt, featureMapDo);
                    double fee = Double.parseDouble(parts[0]);
                    labelMap.put(cnt, fee);
                    line = br.readLine();
                    cnt += 1;
//                    if (cnt > 10) {break;}
                }
            } finally {
                br.close();
            }

            CODER clickCoderModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("deep_fm_e2e_dpa_join_v001", "dpa");
            TFServingClient tfServingClient = new TFServingClient("10.50.203.185", 9000, "deepfm-e2e-dpa-join-v003", null);



            /**
             *             CODER coderModel,
             *             TFServingClient tfServingClient,
             *             List<CandidateActivityDo> activityDos,
             *             DPAActFeatureDo dpa,
             *             SlotActFeature slotActFeature,
             *             UserProfileFeature userProfileFeature,
             *             FeatureDo featureDo,
             *             UserActFeature userActFeature
             */
//            ActRcmderTFServing actRcmderTFServing = new ActRcmderTFServing();
//
//            actRcmderTFServing.recSortWithResortAndMapping(clickCoderModel, tfServingClient,
//            );
            Map<Integer, Double> clickPRpmMap = clickCoderModel.predictWithTFNew(featureMapDoMap, tfServingClient);
            for(Map.Entry<Integer, Double> pair : clickPRpmMap.entrySet()){  //只能遍历value
                System.out.println("pred: " + pair.getValue()  + ", label: " + labelMap.get(pair.getKey()));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void interceptTest01() {
        Map<Integer, FeatureMapDo> featureMapDoMap = new HashMap<>();
        Map<Integer, Double> labelMap = new HashMap<>();
        int cnt = 0;
        try {
            BufferedReader br = new BufferedReader(new FileReader("/Users/lijingzhe/Desktop/00"));
            try {
                String line = br.readLine();
                while (line != null) {
                    System.out.println(line);
                    String[] parts = line.split(";");
                    Map<String, String> staticMap = JSON.parseObject(parts[1], Map.class);
                    FeatureMapDo featureMapDo = new FeatureMapDo();
                    featureMapDo.setStaticFeatureMap(staticMap);
                    featureMapDoMap.put(cnt, featureMapDo);
                    double fee = Double.parseDouble(parts[0]);
                    labelMap.put(cnt, fee);
                    line = br.readLine();
                    cnt += 1;
//                    if (cnt > 10) {break;}
                }
            } finally {
                br.close();
            }

            CODER clickCoderModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("deep_fm_e2e_dpa_intercept_cost_v001", "dpa");
            TFServingClient tfServingClient = new TFServingClient("10.50.253.145", 9000, "deepfm-e2e-dpa-intercept-cost-v001", null);
            Map<Integer, Double> clickPRpmMap = clickCoderModel.predictWithTFNew(featureMapDoMap, tfServingClient);
            for(Map.Entry<Integer, Double> pair : clickPRpmMap.entrySet()){  //只能遍历value
                System.out.println("pred: " + pair.getValue()  + ", label: " + labelMap.get(pair.getKey()));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
