package cn.com.duiba.nezha.alg.example.util;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.StringZIP;
import cn.com.duiba.nezha.alg.example.constant.ProjectConstant;
import cn.com.duiba.nezha.alg.example.constant.PsConstant;
import cn.com.duiba.nezha.alg.example.util.conf.JedisPoolConf;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.FFM;
import cn.com.duiba.nezha.alg.model.FM;
import com.alibaba.fastjson.JSON;

import java.io.*;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StdModelSave {


    public static JedisUtil jedisUtil = new JedisUtil(JedisPoolConf.jedisConfig);

    /**
     * @param modelKey
     * @return
     */
    private static String getLastModelKey(String modelKey) {

        return "nz_last_model_new_" + modelKey + "_";
    }


    /**
     * @param modelKey
     * @return
     */
    private static String getADXModelKey(String modelKey) {

        return "TAE:ALGBID:MODEL:" + modelKey ;
    }
//    /**
//     * @param modelKey
//     * @param model
//     * @return
//     */
//    public static void saveModelByKeyToMD(String modelKey, FM model) {
//
//        if (AssertUtil.isAnyEmpty(modelKey, model)) {
//            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
//            return;
//        }
//        try {
//            // 获取缓存Key
//            String key = getLastModelKey(modelKey);
//            // 保存
//            Map<String, FM> map = new HashMap<>();
//            map.put(key, model);
//            System.out.println("save model with key " + key);
//            MongoUtil.bulkWriteUpdateT(PsConstant.MODEL_TYPE, map, "model update");
//
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//    }


//    /**
//     * @param modelKey
//     * @return
//     */
//    public static FM getModelByKeyFromMD(String modelKey) {
//        FM ret = null;
//
//        if (AssertUtil.isAnyEmpty(modelKey)) {
//            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
//            return ret;
//        }
//        try {
//            // 获取缓存Key
//            String key = getLastModelKey(modelKey);
//            System.out.println("read model with key=" + key);
//            // 保存
//            ret = MongoUtil.findByIdT(PsConstant.MODEL_TYPE, key, FM.class);
//
//
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//
//        return ret;
//    }


//    /**
//     * @param modelKey
//     * @param model
//     * @return
//     */
//    public static void saveModelByKeyToMDFFM(String modelKey, FFM model) {
//
//        if (AssertUtil.isAnyEmpty(modelKey, model)) {
//            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
//            return;
//        }
//        try {
//            // 获取缓存Key
//            String key = getLastModelKey(modelKey);
//            // 保存
//            Map<String, FFM> map = new HashMap<>();
//            map.put(key, model);
//            System.out.println("save model with key " + key);
//            MongoUtil.bulkWriteUpdateT(PsConstant.MODEL_TYPE, map, "model update");
//
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//    }


//    /**
//     * @param modelKey
//     * @return
//     */
//    public static FFM getModelByKeyFromMDFFM(String modelKey) {
//        FFM ret = null;
//
//        if (AssertUtil.isAnyEmpty(modelKey)) {
//            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
//            return ret;
//        }
//        try {
//            // 获取缓存Key
//            String key = getLastModelKey(modelKey);
//            System.out.println("read model with key=" + key);
//            // 保存
//            ret = MongoUtil.findByIdT(PsConstant.MODEL_TYPE, key, FFM.class);
//
//
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//
//        return ret;
//    }

    /**
     * @param modelKey
     * @param model
     * @return
     */
    public static void saveModelByKeyToJedis(String modelKey, FM model) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, model)) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);

            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(model);
            String value2 = StringZIP.zipString(value); //压缩

            jedisUtil.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FM getModelByRedisKeyFromJedis(String redisKey) {
        FM ret = null;

        if (AssertUtil.isAnyEmpty(redisKey)) {
            System.out.println("getModelByRedisKeyFromJedis empty,redisKey=" + redisKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = redisKey;
//            System.out.println("read model with key=" + key);
            // 保存
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString(ret1);// 解压
            // 解压
            ret = JSON.parseObject(ret2, FM.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

    /**
     * @param modelKey
     * @return
     */
    public static FM getModelByKeyFromJedis(String modelKey) {
        FM ret = null;

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);
//            System.out.println("read model with key=" + key);
            // 保存
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString(ret1);// 解压
            // 解压
            ret = JSON.parseObject(ret2, FM.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }


    /**
     */
    public static Map<String, Double> getMapByKeyFromJedis(String key) {
        Map<String, Double> ret = null;

        if (AssertUtil.isAnyEmpty(key)) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + key);
            return ret;
        }
        try {
            // 保存
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString(ret1);// 解压
            // 解压
            ret = JSON.parseObject(ret2,  Map.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }


    public static List<String> getListByKeyFromJedis(String key) {
        List<String> ret = null;

        if (AssertUtil.isAnyEmpty(key)) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + key);
            return ret;
        }
        try {
            // 保存
            String ret1 = jedisUtil.get(key);
            // 解压
            ret = JSON.parseObject(ret1,  List.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }



    /**
     * @param modelKey
     * @param model
     * @return
     */
    public static void saveADXModelByKeyToJedis(String modelKey, FM model) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, model)) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = getADXModelKey(modelKey);

            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(model);
            String value2 = StringZIP.zipString(value); //压缩

            jedisUtil.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * @param modelKey
     * @return
     */
    public static FM getModelByKeyFromJedis(String modelKey, JedisUtil ju) {
        FM ret = null;

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            // 保存
            String ret1 = ju.get(key);
            String ret2 = StringZIP.unzipString(ret1);// 解压
            // 解压
            ret = JSON.parseObject(ret2, FM.class);


//
//            BufferedWriter out = new BufferedWriter(new FileWriter("/Users/lwj/m1.data"));
//            //读取数据
//            //循环取出数据
//            out.write(ret1);
//            out.newLine();
//            //清楚缓存
//            out.flush();
//            out.close();

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }
    public static CODER getCODERModelByKeyFromJedis(String modelKey, JedisUtil ju) {
        CODER ret = null;

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            // 保存
            String ret1 = ju.get(key);
            String ret2 = StringZIP.unzipString(ret1);// 解压
            // 解压
            ret = JSON.parseObject(ret2, CODER.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }
    public static CODER getADXCODERModelByKeyFromJedis(String modelKey, JedisUtil ju) {
        CODER ret = null;

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = getADXModelKey(modelKey);
            System.out.println("read model with key=" + key);
            // 保存
            String ret1 = ju.get(key);
            String ret2 = StringZIP.unzipString(ret1);// 解压
            // 解压
            ret = JSON.parseObject(ret2, CODER.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }
    /**
     * @param modelKey
     * @return
     */
    public static FM getADXModelByKeyFromJedis(String modelKey, JedisUtil ju) {
        FM ret = null;

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = getADXModelKey(modelKey);
            System.out.println("read model with key=" + key);
            // 保存
            String ret1 = ju.get(key);
            String ret2 = StringZIP.unzipString(ret1);// 解压
            // 解压
            ret = JSON.parseObject(ret2, FM.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }



    /**
     * @param modelKey
     * @return
     */
    public static FM getADXModelByKeyFromJedis(String modelKey) {
        FM ret = null;

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = getADXModelKey(modelKey);
            System.out.println("read model with key=" + key);
            // 保存
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString(ret1);// 解压
            // 解压
            ret = JSON.parseObject(ret2, FM.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }


    /**
     * @param modelKey
     * @param model
     * @return
     */
    public static void saveModelByKeyToJedis(String modelKey, FM model, JedisUtil ju) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, model)) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);

            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(model);
            String value2 = StringZIP.zipString(value); //压缩

            ju.setex(key, value2, ProjectConstant.YEAR_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     */
    public static void saveListByKeyToJedis(String key, List<String> map, JedisUtil ju) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(key, map)) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + key);
            return;
        }
        try {
            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(map);

            ju.setex(key, value, ProjectConstant.YEAR_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     *
     */
    public static void saveMapByKeyToJedis(String key, Map<String, Double> map, JedisUtil ju) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(key, map)) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + key);
            return;
        }
        try {
            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(map);
            String value2 = StringZIP.zipString(value); //压缩

            ju.setex(key, value2, ProjectConstant.YEAR_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * @param modelKey
     * @param model
     * @return
     */
    public static void saveADXModelByKeyToJedis(String modelKey, FM model, JedisUtil ju) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, model)) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = getADXModelKey(modelKey);

            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(model);
            String value2 = StringZIP.zipString(value); //压缩

            ju.setex(key, value2, ProjectConstant.YEAR_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public static void saveCODERModelByKeyToJedis(String modelKey, CODER model, JedisUtil ju) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, model)) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);

            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(model);
            String value2 = StringZIP.zipString(value); //压缩

            ju.setex(key, value2, ProjectConstant.YEAR_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveADXCODERModelByKeyToJedis(String modelKey, CODER model, JedisUtil ju) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, model)) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = getADXModelKey(modelKey);

            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(model);
            String value2 = StringZIP.zipString(value); //压缩

            ju.setex(key, value2, ProjectConstant.YEAR_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }



    /**
     * @param modelKey
     * @param model
     * @return
     */
    public static void saveModelByKeyToJedisFFM(String modelKey, FFM model) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, model)) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);

            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(model);
            String value2 = StringZIP.zipString(value); //压缩

            jedisUtil.setex(key, value2, ProjectConstant.YEAR_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * @param modelKey
     * @param model
     * @return
     */
    public static void saveModelByKeyToJedisFFM(String modelKey, FFM model, JedisUtil ju) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, model)) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);

            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(model);
            String value2 = StringZIP.zipString(value); //压缩

            ju.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * @param modelKey
     * @return
     */
    public static FFM getModelByKeyFromJedisFFM(String modelKey) {
        FFM ret = null;

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            // 保存
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString(ret1);// 解压
            // 解压
            ret = JSON.parseObject(ret2, FFM.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

    /**
     * @param modelKey
     * @return
     */
    public static FFM getModelByKeyFromJedisFFM(String modelKey, JedisUtil ju) {
        FFM ret = null;

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            // 保存
            String ret1 = ju.get(key);
            String ret2 = StringZIP.unzipString(ret1);// 解压
            // 解压
            ret = JSON.parseObject(ret2, FFM.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

    /**
     */
    public static void saveDataByKeyToJedis(String modelKey, Map<String, String> model) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, model)) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            // 保存
            System.out.println("save model with key " + modelKey);
            String value = JSON.toJSONString(model);
            String value2 = StringZIP.zipString(value); //压缩

            jedisUtil.setex(modelKey, value2, ProjectConstant.WEEK_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     */
    public static Map<String, String> getDataByKeyToJedis(String modelKey) {

        Map<String, String> ret = null;

        try {
            // 保存
            String ret1 = jedisUtil.get(modelKey);
            String ret2 = StringZIP.unzipString(ret1);// 解压
            // 解压
            ret = JSON.parseObject(ret2, Map.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

}
