/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.example.example.model;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.StdCoderModelSaveBo;
import cn.com.duiba.nezha.alg.example.util.conf.JedisConfig;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import cn.com.duiba.nezha.alg.model.vo.CodeDo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import org.junit.Test;

public class DeepModelV2Test {
    public JedisUtil getJudis() {
        JedisConfig jcOnline = new JedisConfig();
        jcOnline.setIp("r-bp18da0abeaddc94pd.redis.rds.aliyuncs.com");
        jcOnline.setPassWord("hteK73Zxx3ji9LGCy2jBAZDJ6");
        jcOnline.setPort(6366);
        JedisUtil juOnline = new JedisUtil(jcOnline);
        return juOnline;
    }

    public DeepModelV2 getCoder(String key) {
        JedisUtil juOnline = this.getJudis();
        DeepModelV2 codeModel = StdCoderModelSaveBo.getModelByKeyFromJedis(key, juOnline, DeepModelV2.class);
        System.out.println(LocalDateUtil.getCurrentLocalDateTime((String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
        System.out.println("codeModel:" + key + ",codeModel.UpdateTime = " + codeModel.getUpdateTime() + " ,codeModel_ps= " + codeModel.getModelId());
        return codeModel;
    }

    public LocalTFModelV2 getTfModel(String path) throws Exception {
        LocalTFModelV2 ltfModel = new LocalTFModelV2();
        ltfModel.loadModel(path, "202405221040");
        return ltfModel;
    }

    public Map<Long, Double> predict(DeepModelV2 coder, LocalTFModelV2 tfModel, Map<Long, FeatureMapDo> featureMapDoMap) throws Exception {
        HashMap<Long, Double> ret = new HashMap();
        ret = coder.predictWithLocalTFV2(featureMapDoMap, tfModel);
        return ret;
    }

    public Map<Long, FeatureMapDo> getFeatureMapDo() {
        HashMap<Long, FeatureMapDo> featureMapDoMap = new HashMap<Long, FeatureMapDo>();
        String str1 = "{\"ft110003\":\"0\",\"ft110002\":\"0\",\"orderId\":\"taw-11415482669230879\",\"ft400102\":\"15_16\",\"ft400101\":\"15_13\",\"ft100204\":\"rmx2176\",\"ft100203\":\"ANDROID11\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"f8080011\":\"0_12,02.19.0001_12,02.19_12\",\"ft100208\":\"android\",\"ft100207\":\"2020\",\"ft100603\":\"1,2,8,10,21\",\"ft100206\":\"4\",\"ft100602\":\"100907_1,101001_1,101005_1,100601_1,100602_1\",\"ft200201\":\"3\",\"ft100205\":\"realme\",\"ft100601\":\"1006_1,1010_1,1009_1\",\"ft500104\":\"27_3\",\"ft500102\":\"43827_3\",\"ft500103\":\"15_3\",\"ft100209\":\"MOB\",\"ft500101\":\"84571_3\",\"ft110001\":\"0\",\"ft110000\":\"4\",\"ft300101\":\"90446\",\"ft300102\":\"1\",\"ft300103\":\"90446\",\"f110001\":\"0\",\"ft110911\":\"0\",\"ft110910\":\"0\",\"ft110913\":\"1\",\"ft110912\":\"11\",\"ft110914\":\"2\",\"ft110909\":\"-1\",\"ft300904\":\"3\",\"ft300108\":\"628\",\"ft300901\":\"3\",\"ft300902\":\"37\",\"ft300903\":\"3708\",\"ft300104\":\"27\",\"ft300105\":\"267\",\"ft300106\":\"716\",\"ft300107\":\"696\",\"ft110102\":\"0\",\"ft301003\":\"5\",\"advertBackSubTypes\":\"[0,3]\",\"ft110101\":\"0\",\"ft301002\":\"1\",\"ft110103\":\"0\",\"ft301001\":\"12\",\"ft200103\":\"07.09.0127\",\"ft110902\":\"16\",\"ft200104\":\"15\",\"ft110901\":\"32834\",\"ft200105\":\"02.23.0001\",\"ft200106\":\"145952\",\"ft200107\":\"05.03.0001,05.02.0018\",\"ft110906\":\"1\",\"ft200108\":\"-1\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft110907\":\"0\",\"ft400801\":\"13\",\"ft400803\":\"0\",\"ft400802\":\"8\",\"ft200101\":\"84571\",\"ft200102\":\"43827\",\"ft300313\":\"941\",\"ft300201\":\"429637\",\"ft300202\":\"3\",\"ft600204\":\"203971101\",\"ft600203\":\"1000187680\",\"ft600202\":\"213549\",\"advertId\":\"84571\",\"abst\":\"[0,3]\",\"f8080021\":\"0_4,02.19.0001_4,02.19_4\",\"f5090012\":\"15_rmx2176\",\"ft111021\":\"7\",\"ft300204\":\"429637\",\"f306001\":\"2\",\"chargeType\":\"2\",\"f8090011\":\"12\",\"ft100001\":\"12b8bbb9b8a755d41a66f3b6681931e0\",\"ft400302\":\"16\",\"ft400301\":\"12\",\"ft400303\":\"6\",\"ft400702\":\"16\",\"f5070015\":\"43827_\u79fb\u52a8\",\"ft400701\":\"12\",\"f5070016\":\"15_\u79fb\u52a8\",\"ft400703\":\"6\",\"f5090022\":\"15_realme\",\"f8100021\":\"0\",\"f5070011\":\"84571_1\",\"f5070012\":\"4\",\"linkageSubtype\":\"0-,3-23,4-,6-\",\"ft300301\":\"30974\",\"consumerId\":\"33952245615\",\"ft300306\":\"2\",\"f8100011\":\"0\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"ft300304\":\"30974\",\"ft300305\":\"8\",\"ft110302\":\"02.19.0001_7,02.19_7\",\"ft110301\":\"02.19.0001_7,02.19_7\",\"ft110303\":\"02.19.0001_1,02.19_1\",\"ft110702\":\"4\",\"ft110701\":\"12\",\"ft110704\":\"0_4,02.19.0001_4,02.19_4\",\"ft110703\":\"0_12,02.19.0001_12,02.19_12\",\"ft110706\":\"0\",\"ft110705\":\"0\",\"ft400201\":\"13\",\"ft400202\":\"16\",\"ft400601\":\"8\",\"ft100105\":\"030703,030705,030104,030106,030101,030111,031201\",\"ft400603\":\"7\",\"ft400602\":\"16\",\"ft100505\":\"1006,1010,1009\",\"ft100107\":\"010101\",\"ft100106\":\"01020402\",\"ft500203\":\"15_null\",\"ft500204\":\"27_null\",\"ft500201\":\"84571_null\",\"f8807\":\"1\",\"ft500202\":\"43827_null\",\"ft100506\":\"100907,101001,101005,100601,100602\",\"ft900004\":\"4\",\"ft110014\":\"1\",\"ft900003\":\"84571_1\",\"ft110013\":\"0\",\"ft900006\":\"15_\u79fb\u52a8\",\"ft900005\":\"43827_\u79fb\u52a8\",\"ft900008\":\"15_realme\",\"ft900007\":\"15_rmx2176\",\"f8090021\":\"4\",\"time\":\"20221205120458\",\"ft110012\":\"0\",\"ft110011\":\"0\"}";
        String str2 = "{\"ft110003\":\"0\",\"ft110002\":\"4\",\"orderId\":\"taw-11415482332170563\",\"ft200202\":\"23\",\"ft400102\":\"1_15,12_5,3_14,15_18,16_7,17_19,7_2,19_4,9_13,10_18,21_3\",\"ft400101\":\"1_10,12_12,3_13,15_10,16_11,17_14,7_11,19_12,9_10,10_6,21_10\",\"ft100204\":\"spn-al00\",\"ft100203\":\"ANDROID10\",\"ft100202\":\"3\",\"ft100201\":\"1\",\"f8080011\":\"0_12,02.23.0001_12,02.14_12,02.14.0001_12,02.23_12\",\"ft100208\":\"android\",\"ft100207\":\"2019\",\"ft100206\":\"4\",\"ft200201\":\"3\",\"ft100205\":\"huawei\",\"ft500104\":\"27_3\",\"ft500102\":\"44242_3\",\"ft500103\":\"15_3\",\"ft100209\":\"DYN\",\"ft500101\":\"85116_3\",\"ft110001\":\"4\",\"ft300101\":\"89347\",\"ft300102\":\"1\",\"ft300103\":\"89347\",\"f110001\":\"0\",\"ft110911\":\"0\",\"ft110910\":\"1\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"2\",\"ft110909\":\"-1\",\"ft300904\":\"4\",\"ft300108\":\"628\",\"ft300901\":\"1\",\"ft300109\":\"com.delusiandroid.server.ctsbroch\",\"ft300902\":\"14\",\"ft300903\":\"1410\",\"ft300104\":\"27\",\"ft300105\":\"268\",\"ft300106\":\"716\",\"ft300107\":\"671\",\"ft110102\":\"3\",\"ft301003\":\"5\",\"advertBackSubTypes\":\"[0,3]\",\"ft110101\":\"3\",\"ft301002\":\"1\",\"ft110103\":\"0\",\"ft110502\":\"84465_1,84769_1,85107_1,84863_1\",\"ft110501\":\"84769_1,84465_1,85107_1,84863_1\",\"ft301001\":\"12\",\"ft200103\":\"07.09.0137\",\"ft200104\":\"15\",\"ft110901\":\"32769\",\"ft200105\":\"02.23.0001\",\"ft200106\":\"147421\",\"ft110903\":\"07.09.0224\",\"ft200107\":\"05.03.0001,05.02.0018\",\"ft200108\":\"-1\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft400801\":\"14\",\"ft400803\":\"0\",\"ft400802\":\"13\",\"ft200101\":\"85116\",\"ft200102\":\"44242\",\"ft300313\":\"941\",\"ft300201\":\"417669\",\"ft300202\":\"3\",\"advertId\":\"85116\",\"abst\":\"[0,3]\",\"f8080021\":\"0_1,02.23.0001_1,02.14_1,02.14.0001_1,02.23_1\",\"f5090012\":\"15_spn-al00\",\"ft300204\":\"417669\",\"f306001\":\"2\",\"ft110601\":\"84769,84465,85107,84863\",\"ft110602\":\"84769,84465,85107,84863\",\"ft110605\":\"07.09.0237,07.09.0218,07.26.0145,07.09.0224\",\"chargeType\":\"2\",\"ft110604\":\"44883,45124,45012,45220\",\"ft110606\":\"1,15\",\"f8090011\":\"12\",\"ft100001\":\"d69aafad425bf9ca967637084f3a8eaa\",\"ft400302\":\"13\",\"ft400301\":\"15\",\"ft400303\":\"9\",\"ft400702\":\"15\",\"f5070015\":\"44242_\u7535\u4fe1\",\"ft400701\":\"13\",\"f5070016\":\"15_\u7535\u4fe1\",\"ft400703\":\"7\",\"f5090022\":\"15_huawei\",\"ft111011\":\"4\",\"f8100021\":\"1\",\"f5070011\":\"85116_3\",\"f5070012\":\"4\",\"linkageSubtype\":\"0-,3-23,4-,6-\",\"ft300301\":\"32769\",\"consumerId\":\"34253958707\",\"f9110031\":\"84769_85116,84465_85116,85107_85116,84863_85116\",\"ft300306\":\"2\",\"f8100011\":\"12\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"ft300304\":\"32769\",\"ft300305\":\"0\",\"ft300111\":\"1\",\"ft110302\":\"02.23.0001_3,02.14_1,02.14.0001_1,02.23_3\",\"ft110301\":\"02.23.0001_3,02.14_1,02.14.0001_1,02.23_3\",\"ft110303\":\"02.23.0001_0,02.14_0,02.14.0001_0,02.23_0\",\"ft110702\":\"1\",\"ft110701\":\"12\",\"ft300110\":\"1\",\"ft110704\":\"0_1,02.23.0001_1,02.14_1,02.14.0001_1,02.23_1\",\"ft110703\":\"0_12,02.23.0001_12,02.14_12,02.14.0001_12,02.23_12\",\"ft110706\":\"1\",\"ft110705\":\"12\",\"ft400201\":\"10\",\"ft400202\":\"18\",\"ft400601\":\"15\",\"ft400603\":\"9\",\"ft400602\":\"13\",\"ft500203\":\"15_23\",\"ft500204\":\"27_23\",\"ft500201\":\"85116_23\",\"f8807\":\"1\",\"ft500202\":\"44242_23\",\"ft900004\":\"4\",\"ft110014\":\"5\",\"ft900003\":\"85116_3\",\"ft110013\":\"0\",\"ft900006\":\"15_\u7535\u4fe1\",\"ft900005\":\"44242_\u7535\u4fe1\",\"ft900008\":\"15_huawei\",\"ft900007\":\"15_spn-al00\",\"f8090021\":\"1\",\"ft900001\":\"84769_85116,84465_85116,85107_85116,84863_85116\",\"time\":\"20221205120444\",\"ft110012\":\"4\",\"ft110011\":\"4\"}";
        String str3 = "{\"ft110003\":\"0\",\"ft110002\":\"0\",\"orderId\":\"taw-11415482563561023\",\"ft400102\":\"1_15,12_16,15_16,16_3\",\"ft400101\":\"1_8,12_7,15_8,16_9\",\"ft100204\":\"m2104k10ac\",\"ft100203\":\"ANDROID12\",\"ft100202\":\"3\",\"ft100201\":\"1\",\"f8080011\":\"0_1,02.23.0001_0,02.23_1\",\"ft100208\":\"android\",\"ft100207\":\"2021\",\"ft100206\":\"4\",\"ft100602\":\"101505_1,100406_1,100907_1,101001_1,101102_1,101103_1,101303_1,101105_1,100402_1,100601_1,100602_1\",\"ft200201\":\"3\",\"ft100205\":\"redmi\",\"ft100601\":\"1018_1,1006_1,1017_1,1016_1,1004_1,1013_1,1022_1,1011_1,1010_1,1009_1\",\"ft500104\":\"27_3\",\"ft500102\":\"44948_3\",\"ft500103\":\"15_3\",\"ft100209\":\"DYN\",\"ft500101\":\"85026_3\",\"ft110001\":\"0\",\"ft110000\":\"3\",\"ft300101\":\"90820\",\"ft300102\":\"1\",\"ft300103\":\"90820\",\"f110001\":\"0\",\"ft110911\":\"0\",\"ft110910\":\"0\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"1\",\"ft110909\":\"-1\",\"ft300904\":\"3\",\"ft300108\":\"628\",\"ft300901\":\"4\",\"ft300109\":\"com.kuaiyin.player\",\"ft300902\":\"43\",\"ft300903\":\"4302\",\"ft300104\":\"27\",\"ft300105\":\"268\",\"ft300106\":\"690\",\"ft300107\":\"671\",\"ft110102\":\"0\",\"ft301003\":\"5\",\"advertBackSubTypes\":\"[0,3]\",\"ft110101\":\"0\",\"ft301002\":\"1\",\"ft110103\":\"0\",\"ft301001\":\"12\",\"ft200103\":\"07.09.0230\",\"ft110902\":\"15\",\"ft200104\":\"15\",\"ft110901\":\"32343\",\"ft200105\":\"02.23.0001\",\"ft200106\":\"147244\",\"ft200107\":\"05.03.0001,05.02.0018\",\"ft110906\":\"0\",\"ft200108\":\"-1\",\"ft200109\":\"0\",\"ft110908\":\"1\",\"ft400801\":\"13\",\"ft400803\":\"0\",\"ft400802\":\"9\",\"ft200101\":\"85026\",\"ft200102\":\"44948\",\"ft300313\":\"941\",\"ft600201\":\"14794768\",\"ft300201\":\"425385\",\"ft300202\":\"3\",\"ft600204\":\"27677048063\",\"ft600203\":\"2241421171\",\"ft600202\":\"3xdpekef7s6j2nk\",\"advertId\":\"85026\",\"abst\":\"[0,3]\",\"f8080021\":\"0_0,02.23.0001_0,02.23_0\",\"ft600208\":\"2\",\"ft600207\":\"0\",\"ft600206\":\"939\",\"f5090012\":\"15_m2104k10ac\",\"ft111021\":\"4\",\"ft300204\":\"425385\",\"f306001\":\"2\",\"chargeType\":\"2\",\"f8090011\":\"1\",\"ft100001\":\"0cf845735771b1b3f263bea176b8f66c\",\"ft400302\":\"16\",\"ft400301\":\"6\",\"ft400303\":\"10\",\"ft400702\":\"16\",\"f5070015\":\"44948_\u7535\u4fe1\",\"ft400701\":\"9\",\"f5070016\":\"15_\u7535\u4fe1\",\"ft400703\":\"10\",\"f5090022\":\"15_redmi\",\"ft111011\":\"7\",\"f8100021\":\"0\",\"f5070011\":\"85026_3\",\"f5070012\":\"4\",\"linkageSubtype\":\"0-,3-23,4-,6-\",\"ft300301\":\"32825\",\"consumerId\":\"34253321215\",\"ft300306\":\"2\",\"f8100011\":\"0\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"ft300304\":\"32825\",\"ft300305\":\"0\",\"ft300111\":\"4\",\"ft110302\":\"02.23.0001_0,02.23_0\",\"ft110301\":\"02.23.0001_0,02.23_1\",\"ft110303\":\"02.23.0001_0,02.23_0\",\"ft110702\":\"0\",\"ft110701\":\"1\",\"ft300110\":\"4\",\"ft110704\":\"0_0,02.23.0001_0,02.23_0\",\"ft110703\":\"0_1,02.23.0001_0,02.23_1\",\"ft110706\":\"0\",\"ft110705\":\"0\",\"ft400201\":\"8\",\"ft400202\":\"16\",\"ft400601\":\"6\",\"ft100105\":\"030703,030705,030308,03020607,031514,031108,030203,030206,030101,031521,030111,030202,031201,03020604,03020503\",\"ft100501\":\"33002000,34002000,23002000,25002000,41002000,54002000,50002000,28002000,61002000,24002000,39002000,29002000\",\"ft400603\":\"10\",\"ft100103\":\"010501\",\"ft400602\":\"16\",\"ft100505\":\"1018,1006,1017,1016,1004,1013,1022,1011,1010,1009\",\"ft100107\":\"010101\",\"ft100503\":\"34162100,23083100,23022200,50012400,23093700,23092500,23012600,23022300\",\"ft100106\":\"010202\",\"ft100502\":\"33122000,34162000,23082000,23022000,50012000,28292000,23092000,23012000,24012000,34012000,34142000,39062000,23152000,23032000\",\"ft500203\":\"15_null\",\"ft500204\":\"27_null\",\"ft500201\":\"85026_null\",\"f8807\":\"1\",\"ft500202\":\"44948_null\",\"ft100506\":\"101505,100406,100907,101001,101102,101103,101303,101105,100402,100601,100602\",\"ft900004\":\"4\",\"ft110014\":\"2\",\"ft900003\":\"85026_3\",\"ft110013\":\"0\",\"ft900006\":\"15_\u7535\u4fe1\",\"ft900005\":\"44948_\u7535\u4fe1\",\"ft900008\":\"15_redmi\",\"ft900007\":\"15_m2104k10ac\",\"f8090021\":\"0\",\"time\":\"20221205120433\",\"ft110012\":\"0\",\"ft110011\":\"0\"}";
        String str4 = "{\"ft110003\":\"0\",\"ft110002\":\"0\",\"orderId\":\"taw-11428420551390741\",\"ft400102\":\"1_15,12_16,3_18,15_18,4_2,16_9,17_19,19_4,9_13,10_18,21_3\",\"ft400101\":\"1_12,12_13,3_15,15_13,4_13,16_11,17_11,19_12,9_12,10_8,21_8\",\"ft100204\":\"lio-an00\",\"ft100203\":\"ANDROID12\",\"ft100202\":\"4\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2019\",\"ft100206\":\"6\",\"ft200201\":\"3\",\"ft100205\":\"huawei\",\"ft500104\":\"27_3\",\"ft500102\":\"45351_3\",\"ft500103\":\"15_3\",\"ft100209\":\"DYN\",\"ft500101\":\"86054_3\",\"ft110001\":\"0\",\"ft300101\":\"89347\",\"ft300102\":\"1\",\"ft300103\":\"89347\",\"f110001\":\"0\",\"ft110911\":\"0\",\"ft110910\":\"-1\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"0\",\"ft110909\":\"-1\",\"ft300904\":\"4\",\"ft300108\":\"628\",\"ft300901\":\"4\",\"ft300109\":\"com.quliang.smjl\",\"ft300902\":\"41\",\"ft300903\":\"4104\",\"ft300104\":\"27\",\"ft300105\":\"268\",\"ft300106\":\"716\",\"ft300107\":\"671\",\"ft110102\":\"0\",\"ft301003\":\"18\",\"advertBackSubTypes\":\"[0,3]\",\"ft110101\":\"0\",\"ft301002\":\"3\",\"ft110103\":\"0\",\"ft301001\":\"8\",\"ft200103\":\"07.09.0192\",\"ft200104\":\"15\",\"ft200105\":\"02.23.0001\",\"ft200106\":\"149876\",\"ft200107\":\"05.02.0020,05.03.0001\",\"ft200108\":\"-1\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft400801\":\"15\",\"ft400803\":\"5\",\"ft400802\":\"16\",\"ft200101\":\"86054\",\"ft200102\":\"45351\",\"ft300201\":\"417669\",\"ft300202\":\"3\",\"advertId\":\"86054\",\"abst\":\"[0,3]\",\"f5090012\":\"15_lio-an00\",\"ft300204\":\"417669\",\"f306001\":\"2\",\"chargeType\":\"2\",\"ft100001\":\"e23fc3155407fd2b16d56772904b2bdf\",\"ft400302\":\"18\",\"ft400301\":\"16\",\"ft400303\":\"9\",\"ft400702\":\"18\",\"f5070015\":\"45351_\u672a\u77e5\",\"ft400701\":\"12\",\"f5070016\":\"15_\u672a\u77e5\",\"ft400703\":\"6\",\"f5090022\":\"15_huawei\",\"f8100021\":\"0\",\"f5070011\":\"86054_4\",\"f5070012\":\"4\",\"linkageSubtype\":\"0-,3-23,4-,6-\",\"ft300301\":\"33242\",\"consumerId\":\"35112800997\",\"ft300306\":\"2\",\"f8100011\":\"0\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"ft300304\":\"33242\",\"ft300305\":\"0\",\"ft300111\":\"12\",\"ft300110\":\"3\",\"ft110706\":\"0\",\"ft110705\":\"0\",\"ft400201\":\"13\",\"ft400202\":\"18\",\"ft400601\":\"16\",\"ft400603\":\"8\",\"ft400602\":\"18\",\"ft500203\":\"15_null\",\"ft500204\":\"27_null\",\"ft500201\":\"86054_null\",\"f8807\":\"1\",\"ft500202\":\"45351_null\",\"ft900004\":\"4\",\"ft110014\":\"1\",\"ft900003\":\"86054_4\",\"ft110013\":\"0\",\"ft900006\":\"15_\u672a\u77e5\",\"ft900005\":\"45351_\u672a\u77e5\",\"ft900008\":\"15_huawei\",\"ft900007\":\"15_lio-an00\",\"time\":\"20230118085926\",\"ft110012\":\"0\",\"ft110011\":\"0\"}";
        String str5 = "{\"ft110003\":\"0\",\"ft110002\":\"0\",\"orderId\":\"taw-11430978099720721\",\"ft400102\":\"1_12,12_18,3_2,15_16,16_5,17_0,9_2,10_19,21_1\",\"ft400101\":\"1_10,12_12,3_10,15_15,4_8,16_16,17_9,7_9,9_11,10_15,21_14\",\"ft100204\":\"lon-al00\",\"ft100203\":\"ANDROID9\",\"ft100202\":\"3\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"ft100207\":\"2016\",\"ft100206\":\"6\",\"ft200201\":\"3\",\"ft100205\":\"huawei\",\"ft500104\":\"38_3\",\"ft500102\":\"45355_3\",\"ft500103\":\"15_3\",\"ft100209\":\"MOB\",\"ft500101\":\"85921_3\",\"ft110001\":\"0\",\"ft300101\":\"83525\",\"ft300102\":\"1\",\"ft300103\":\"83525\",\"f110001\":\"0\",\"ft110911\":\"0\",\"ft110910\":\"-1\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"0\",\"ft110909\":\"-1\",\"ft300904\":\"1\",\"ft300108\":\"628\",\"ft300901\":\"7\",\"ft300902\":\"61\",\"ft300903\":\"6101\",\"ft300104\":\"38\",\"ft300105\":\"365\",\"ft300106\":\"692\",\"ft300107\":\"673\",\"ft110102\":\"0\",\"ft301003\":\"29\",\"advertBackSubTypes\":\"[0,3]\",\"ft110101\":\"0\",\"ft301002\":\"7\",\"ft110103\":\"0\",\"ft301001\":\"12\",\"ft200103\":\"07.09.0271\",\"ft200104\":\"15\",\"ft200105\":\"02.23.0001\",\"ft200106\":\"149427\",\"ft200107\":\"05.02.0020,05.03.0001\",\"ft200108\":\"98be4804980643905b78f8dfc8d9ee5\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft400801\":\"14\",\"ft400803\":\"4\",\"ft400802\":\"11\",\"ft200101\":\"85921\",\"ft200102\":\"45355\",\"ft300201\":\"387156\",\"ft300202\":\"1\",\"advertId\":\"85921\",\"abst\":\"[0,3]\",\"f5090012\":\"15_lon-al00\",\"ft300204\":\"387156\",\"f306001\":\"2\",\"coder\":\"null;0.020239;202301290434;:0,21,42,48,73,406,1919,21296,23178,23190,23204,23225,23256,23287,23318,23338,23342,23348,23647,33445,34396,34859,36005,39910,40109,44937,45002,45081,65082,65183,65385,67878,70407,70428,72754,75460,75958,75999,76313,76524,76535,76591,76623,76655,77648,77749,127750:0;9,21\",\"chargeType\":\"2\",\"ft100001\":\"2edad4cb97326181a45503658166aa86\",\"ft400302\":\"17\",\"ft400301\":\"17\",\"ft400303\":\"6\",\"ft400702\":\"17\",\"f5070015\":\"45355_\u7535\u4fe1\",\"ft400701\":\"16\",\"f5070016\":\"15_\u7535\u4fe1\",\"ft400703\":\"7\",\"f5090022\":\"15_huawei\",\"ft111011\":\"1\",\"f8100021\":\"0\",\"f5070011\":\"85921_3\",\"f5070012\":\"4\",\"linkageSubtype\":\"0-,3-23,4-,6-\",\"ft300301\":\"33207\",\"consumerId\":\"35319648977\",\"ft300306\":\"2\",\"f8100011\":\"0\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"ft300304\":\"33207\",\"ft300305\":\"12\",\"ft110706\":\"0\",\"ft110705\":\"0\",\"ft400201\":\"15\",\"ft400202\":\"16\",\"ft400601\":\"17\",\"ft400603\":\"6\",\"ft400602\":\"17\",\"ft500203\":\"15_null\",\"ft500204\":\"38_null\",\"ft500201\":\"85921_null\",\"f8807\":\"1\",\"ft500202\":\"45355_null\",\"ft900004\":\"4\",\"ft110014\":\"1\",\"ft900003\":\"85921_3\",\"ft110013\":\"0\",\"ft900006\":\"15_\u7535\u4fe1\",\"ft900005\":\"45355_\u7535\u4fe1\",\"ft900008\":\"15_huawei\",\"ft900007\":\"15_lon-al00\",\"time\":\"20230129124437\",\"ft110012\":\"0\",\"ft110011\":\"0\"}";
        String str8 = "{\"orderId\":\"taw-11442290129270317\",\"ft100204\":\"v2002a\",\"ft100203\":\"ANDROID10\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"fd_1310\":\"16\",\"ft100208\":\"android\",\"fd_1710\":\"16\",\"ft100207\":\"2020\",\"ft100206\":\"4\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.8515154\",\"ft100205\":\"vivo\",\"ft500103\":\"16_3\",\"ft100209\":\"DYN\",\"fd_1318\":\"30_1_16_1,30_2_16_1,180_1_16_1,180_2_16_1\",\"fd_1807_01\":\"4\",\"ft500101\":\"86879_3\",\"ft300101\":\"93332\",\"fd_1810_01\":\"1\",\"fd_1709\":\"16\",\"ft110911\":\"0\",\"ft110910\":\"-1\",\"fd_1208_01\":\"2\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"fd_1709_01\":\"1\",\"ft110914\":\"0\",\"ft110909\":\"-1\",\"ft300904\":\"4\",\"fd_1306\":\"6\",\"ft300901\":\"6\",\"ft300109\":\"com.dz.hmjc\",\"fd_1305\":\"24\",\"ft300902\":\"51\",\"fd_1308\":\"4\",\"ft300903\":\"5117\",\"fd_1307\":\"6\",\"ft300104\":\"27\",\"fd_1707\":\"4\",\"ft300105\":\"268\",\"fd_1708\":\"2\",\"fd_1309\":\"16\",\"ft300106\":\"985\",\"fd_1705\":\"7\",\"ft300107\":\"671\",\"fd_1706\":\"4\",\"ft301003\":\"11\",\"advertBackSubTypes\":\"[3]\",\"ft301002\":\"2\",\"fd_1809_01\":\"1\",\"fd_1209_01\":\"1\",\"ft301001\":\"18\",\"ft200103\":\"07.07.0017\",\"ft200104\":\"16\",\"ft200106\":\"152026\",\"ft200107\":\"05.03.0001,05.02.0001,05.02.0023,05.02.0008\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"fd_1210\":\"16\",\"fd_1308_01\":\"4\",\"fd_1308_02\":\"4\",\"fd_1214\":\"131047,131040,135192\",\"ft200101\":\"86879\",\"ft200102\":\"46016\",\"fd_1602_04\":\"0.0405353\",\"fd_1602_03\":\"0.0798899\",\"ft300201\":\"443894\",\"ft300202\":\"8\",\"fd_1707_01\":\"4\",\"advertId\":\"86879\",\"abst\":\"[3]\",\"fd_1506_08\":\"0.0346128\",\"fd_1506_07\":\"0.1296843\",\"fd_1205\":\"9\",\"fd_1207\":\"4\",\"fd_1710_01\":\"1\",\"fd_1206\":\"4\",\"fd_1209\":\"16\",\"fd_1208\":\"2\",\"fd_1305_01\":\"8\",\"fd_1207_01\":\"4\",\"fd_1708_01\":\"2\",\"chargeType\":\"2\",\"fd_1505_06\":\"0.7973383\",\"linkageSubtype\":\"0-9,0-6,0-8,3-6,3-8,3-9\",\"ft300301\":\"33781\",\"fd_1705_01\":\"6\",\"fd_1210_01\":\"1\",\"consumerId\":\"36068876605\",\"fd_1307_01\":\"6\",\"fd_1501\":\"80238\",\"fd_1502\":\"80238\",\"fd_1505\":\"16\",\"ft300306\":\"2\",\"fd_1506\":\"16\",\"fd_1503\":\"86992\",\"fd_1504\":\"86992\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"16\",\"ft300304\":\"33781\",\"fd_1808_01\":\"2\",\"fd_1508\":\"16\",\"ft300305\":\"1\",\"ft200301\":\"0\",\"fd_1310_01\":\"1\",\"fd_1310_02\":\"1\",\"fd_1810\":\"16\",\"fd_1205_01\":\"6\",\"ft500203\":\"16_null\",\"ft500201\":\"86879_null\",\"f8807\":\"1\",\"fd_1805_01\":\"6\",\"ft110014\":\"1\",\"fd_1808\":\"2\",\"fd_1809\":\"16\",\"fd_1502_04\":\"0.0703416\",\"fd_1001\":\"010101\",\"fd_1003\":\"010502\",\"fd_1309_01\":\"1\",\"fd_1002\":\"010202\",\"fd_1005\":\"135192,17,131047,18,7,131040,10\",\"fd_1007\":\"100802,100102,100202,101502\",\"fd_1502_03\":\"2.185E-4\",\"fd_1006\":\"1008,1015,1002,1001\",\"fd_1601_02\":\"0.5165907\",\"time\":\"20230411183235\",\"fd_1806\":\"4\",\"fd_1807\":\"4\",\"fd_1805\":\"9\"}";
        String str9 = "{\"fd_1108_02\":\"1\",\"orderId\":\"taw-11442290168770454\",\"fd_1108_01\":\"1\",\"ft100204\":\"hebe-bd00\",\"fd_1117_01\":\"1\",\"ft100203\":\"ANDROID11\",\"fd_1011_01\":\"0\",\"ft100202\":\"4\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2021\",\"ft100206\":\"5\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.7598539\",\"ft100205\":\"Hi nova\",\"ft500103\":\"19_0\",\"ft100209\":\"DYN\",\"ft500101\":\"84395_0\",\"fd_1105_01\":\"1\",\"ft300101\":\"87715\",\"ft110911\":\"1\",\"ft110910\":\"1\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"2\",\"ft110909\":\"-1\",\"ft300904\":\"2\",\"ft300901\":\"3\",\"ft300109\":\"com.shuqu.banyan\",\"ft300902\":\"37\",\"ft300903\":\"3706\",\"ft300104\":\"35\",\"ft300105\":\"356\",\"ft300106\":\"981\",\"ft300107\":\"671\",\"ft301003\":\"11\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"2\",\"ft301001\":\"18\",\"ft200103\":\"07.16.0068\",\"ft200104\":\"19\",\"ft110901\":\"33714\",\"ft200106\":\"151564\",\"ft110903\":\"07.19.0043\",\"ft200107\":\"05.02.0020\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft200101\":\"84395\",\"ft200102\":\"44876\",\"fd_1602_04\":\"5.97E-5\",\"fd_1602_03\":\"0.3530676\",\"ft300201\":\"409578\",\"ft300202\":\"11\",\"fd_1107_01\":\"1\",\"advertId\":\"84395\",\"abst\":\"[0]\",\"fd_1506_08\":\"1.782E-4\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.3528329\",\"chargeType\":\"2\",\"fd_1120\":\"33714\",\"fd_1111\":\"20\",\"fd_1110\":\"1681208968\",\"fd_1113\":\"33714\",\"fd_1112\":\"1681208971\",\"fd_1115\":\"750543844110282752\",\"fd_1505_06\":\"0.7112957\",\"fd_1114\":\"750543844110282752\",\"fd_1117\":\"20\",\"fd_1116\":\"1\",\"linkageSubtype\":\"0-8,0-6,2-,3-8,3-6,5-6,5-8,8-\",\"ft300301\":\"33714\",\"consumerId\":\"36123378118\",\"fd_1501\":\"85249\",\"fd_1502\":\"85249\",\"fd_1106\":\"1\",\"fd_1105\":\"1\",\"fd_1505\":\"20\",\"ft300306\":\"2\",\"fd_1108\":\"1\",\"fd_1506\":\"20\",\"fd_1107\":\"1\",\"fd_1503\":\"84395\",\"fd_1504\":\"86915\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"19\",\"ft300304\":\"33714\",\"fd_1508\":\"1\",\"ft300305\":\"12\",\"fd_1106_02\":\"1\",\"ft200301\":\"0\",\"ft500203\":\"19_null\",\"ft500201\":\"84395_null\",\"f8807\":\"1\",\"ft110014\":\"2\",\"fd_1502_04\":\"3.054E-4\",\"fd_1502_03\":\"0.4597924\",\"fd_1601_02\":\"0.7116811\",\"time\":\"20230411183102\"}";
        String str10 = "{\"orderId\":\"taw-11442290343150908\",\"fd_1108_01\":\"0\",\"ft100204\":\"pot-al00a\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID10\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2019\",\"ft100206\":\"3\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.2437592\",\"ft100205\":\"huawei\",\"ft500103\":\"15_3\",\"ft100209\":\"DYN\",\"ft500101\":\"87193_3\",\"fd_1105_01\":\"1\",\"ft300101\":\"90618\",\"ft110911\":\"0\",\"ft110910\":\"-1\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"0\",\"ft110909\":\"-1\",\"ft300904\":\"1\",\"ft300901\":\"3\",\"ft300902\":\"31\",\"ft300903\":\"31\",\"ft300104\":\"33\",\"ft300105\":\"347\",\"ft300106\":\"985\",\"ft300107\":\"671\",\"ft301003\":\"11\",\"advertBackSubTypes\":\"[0,3]\",\"ft301002\":\"2\",\"ft301001\":\"18\",\"ft200103\":\"07.09.0325\",\"ft200104\":\"15\",\"ft200106\":\"152682\",\"ft200107\":\"05.02.0014\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft200101\":\"87193\",\"ft200102\":\"46034\",\"ft300201\":\"424469\",\"ft300202\":\"8\",\"fd_1107_01\":\"0\",\"advertId\":\"87193\",\"abst\":\"[0,3]\",\"fd_1506_08\":\"0.0097035\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.1970214\",\"chargeType\":\"2\",\"fd_1120\":\"33485\",\"fd_1110\":\"1681209313\",\"fd_1505_06\":\"0.3614506\",\"fd_1116\":\"0\",\"linkageSubtype\":\"0-,3-23,4-,6-\",\"ft300301\":\"33485\",\"consumerId\":\"36123414412\",\"fd_1501\":\"85561\",\"fd_1502\":\"85561\",\"fd_1105\":\"1\",\"fd_1505\":\"15\",\"ft300306\":\"2\",\"fd_1506\":\"15\",\"fd_1503\":\"87243\",\"fd_1504\":\"85561\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"15\",\"ft300304\":\"33485\",\"fd_1508\":\"15\",\"ft300305\":\"0\",\"ft200301\":\"0\",\"ft500203\":\"15_null\",\"ft500201\":\"87193_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"fd_1502_04\":\"0.0138889\",\"fd_1001\":\"010101\",\"fd_1003\":\"010502\",\"fd_1002\":\"01020401\",\"fd_1502_03\":\"0.0138889\",\"time\":\"20230411183524\"}";
        String str11 = "{\"fd_1108_02\":\"2\",\"orderId\":\"taw-11442290658580336\",\"fd_1108_01\":\"2\",\"ft100204\":\"wkg-an00\",\"fd_1117_01\":\"1\",\"ft100203\":\"ANDROID10\",\"fd_1011_01\":\"1\",\"ft100202\":\"4\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2020\",\"ft100206\":\"2\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.5386302\",\"ft100205\":\"huawei\",\"ft500103\":\"16_0\",\"ft100209\":\"DYN\",\"ft500101\":\"87264_0\",\"fd_1105_01\":\"1\",\"ft300101\":\"93230\",\"ft110911\":\"1\",\"ft110910\":\"1\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"2\",\"ft110909\":\"-1\",\"ft300904\":\"4\",\"ft300901\":\"1\",\"ft300902\":\"14\",\"ft300903\":\"1408\",\"ft300104\":\"27\",\"ft300105\":\"268\",\"ft300106\":\"986\",\"ft300107\":\"671\",\"ft301003\":\"11\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"2\",\"ft301001\":\"18\",\"ft200103\":\"07.10.0146\",\"ft200104\":\"16\",\"ft110901\":\"33781\",\"ft200106\":\"152867\",\"ft110903\":\"07.10.0146\",\"ft200107\":\"05.02.0020\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft200101\":\"87264\",\"ft200102\":\"45987\",\"ft300201\":\"444877\",\"ft300202\":\"8\",\"fd_1107_01\":\"2\",\"advertId\":\"87264\",\"abst\":\"[0]\",\"fd_1506_08\":\"0.0363228\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.1003092\",\"chargeType\":\"2\",\"fd_1120\":\"33781\",\"fd_1111\":\"16\",\"fd_1110\":\"1681209155\",\"fd_1113\":\"33781\",\"fd_1112\":\"1681209244\",\"fd_1115\":\"750544987095871488\",\"fd_1505_06\":\"0.8011462\",\"fd_1114\":\"750544987095871488\",\"fd_1117\":\"16\",\"fd_1116\":\"1\",\"linkageSubtype\":\"0-9,0-6,0-8,3-6,3-8,3-9\",\"ft300301\":\"33781\",\"consumerId\":\"36123391312\",\"fd_1501\":\"84746\",\"fd_1502\":\"84746\",\"fd_1106\":\"3\",\"fd_1105\":\"1\",\"fd_1505\":\"16\",\"ft300306\":\"2\",\"fd_1108\":\"2\",\"fd_1506\":\"16\",\"fd_1107\":\"2\",\"fd_1503\":\"86992\",\"fd_1504\":\"86992\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"16\",\"ft300304\":\"33781\",\"fd_1508\":\"16\",\"ft300305\":\"1\",\"fd_1106_02\":\"3\",\"ft200301\":\"0\",\"ft500203\":\"16_null\",\"ft500201\":\"87264_null\",\"f8807\":\"1\",\"ft110014\":\"3\",\"fd_1502_04\":\"3.468E-4\",\"fd_1502_03\":\"0.0011557\",\"time\":\"20230411183508\"}";
        String str12 = "{\"orderId\":\"taw-11442290529040157\",\"chargeType\":\"2\",\"ft100204\":\"jsn-al00\",\"ft100203\":\"ANDROID10\",\"fd_1011_01\":\"-1\",\"ft100202\":\"4\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.8102532\",\"ft100207\":\"2018\",\"ft100206\":\"3\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.8548551\",\"ft100205\":\"honor\",\"ft500103\":\"16_0\",\"ft100209\":\"DYN\",\"ft500101\":\"84746_0\",\"linkageSubtype\":\"0-9,0-6,0-8,3-6,3-8,3-9\",\"ft300101\":\"84436\",\"ft300301\":\"33885\",\"ft110911\":\"0\",\"consumerId\":\"36123415709\",\"ft110910\":\"-1\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"0\",\"ft110909\":\"-1\",\"fd_1501\":\"86209\",\"ft300904\":\"1\",\"fd_1502\":\"86209\",\"fd_1505\":\"16\",\"ft300306\":\"2\",\"fd_1506\":\"16\",\"ft300901\":\"3\",\"fd_1503\":\"86157\",\"ft300902\":\"31\",\"fd_1504\":\"86157\",\"ft300903\":\"31\",\"ft300302\":\"1\",\"ft300104\":\"27\",\"ft300303\":\"1\",\"ft300105\":\"268\",\"fd_1507\":\"16\",\"ft300304\":\"33885\",\"ft300106\":\"987\",\"fd_1508\":\"16\",\"ft300305\":\"1\",\"ft300107\":\"671\",\"ft301003\":\"11\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"2\",\"ft6002031\":\"2459670321\",\"ft301001\":\"18\",\"ft200103\":\"07.10.0146\",\"ft200301\":\"0\",\"ft200104\":\"16\",\"ft200106\":\"149822\",\"ft200107\":\"05.03.0013,05.02.0001,05.02.0019\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft200101\":\"84746\",\"ft200102\":\"41435\",\"ft500203\":\"16_null\",\"ft500201\":\"84746_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft600201\":\"16368657\",\"ft300201\":\"439625\",\"ft6002041\":\"29698738238\",\"ft300202\":\"8\",\"advertId\":\"84746\",\"abst\":\"[0]\",\"fd_1502_04\":\"1.973E-4\",\"fd_1506_08\":\"0.0115001\",\"fd_1506_07\":\"0.0443854\",\"fd_1502_03\":\"0.0254438\",\"time\":\"20230411183554\"}";
        String str13 = "{\"orderId\":\"taw-11442290430100022\",\"chargeType\":\"2\",\"ft100204\":\"m2101k9c\",\"ft100203\":\"ANDROID13\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.7012611\",\"ft100207\":\"2021\",\"ft100206\":\"4\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.7416431\",\"ft100205\":\"xiaomi\",\"ft500103\":\"9_0\",\"ft100209\":\"MOB\",\"ft500101\":\"65521_0\",\"linkageSubtype\":\"0-11\",\"ft300101\":\"86650\",\"ft300301\":\"34221\",\"ft600303\":\"0\",\"ft110911\":\"0\",\"ft600302\":\"420592\",\"consumerId\":\"36123408406\",\"ft110910\":\"-1\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"0\",\"ft110909\":\"-1\",\"fd_1501\":\"85629\",\"ft300904\":\"1\",\"fd_1502\":\"85629\",\"fd_1505\":\"1\",\"ft300306\":\"2\",\"fd_1506\":\"1\",\"ft300901\":\"3\",\"fd_1503\":\"85629\",\"ft300902\":\"32\",\"fd_1504\":\"87247\",\"ft600305\":\"4594\",\"ft300903\":\"3201\",\"ft300302\":\"1\",\"ft300104\":\"33\",\"ft300303\":\"1\",\"ft300105\":\"352\",\"fd_1507\":\"1\",\"ft300304\":\"34221\",\"ft300106\":\"979\",\"fd_1508\":\"15\",\"ft300305\":\"12\",\"ft300107\":\"674\",\"ft301003\":\"11\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"2\",\"ft301001\":\"18\",\"ft200103\":\"07.23.0008\",\"ft200301\":\"0\",\"ft200104\":\"9\",\"ft200106\":\"139426\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft200101\":\"65521\",\"ft200102\":\"29932\",\"ft500203\":\"9_null\",\"ft500201\":\"65521_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft300201\":\"420592\",\"ft300202\":\"12\",\"advertId\":\"65521\",\"abst\":\"[0]\",\"fd_1502_04\":\"2.26E-5\",\"fd_1506_08\":\"5.5E-6\",\"fd_1506_07\":\"0.0693929\",\"fd_1502_03\":\"0.0778845\",\"time\":\"20230411183502\"}";
        String str14 = "{\"orderId\":\"taw-11442290524500411\",\"chargeType\":\"2\",\"ft100204\":\"koz-al40\",\"ft100203\":\"ANDROID10\",\"fd_1011_01\":\"-1\",\"ft100202\":\"4\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.7012611\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.7416431\",\"ft100205\":\"honor\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"ft500101\":\"65521_0\",\"linkageSubtype\":\"0-11\",\"ft300101\":\"86650\",\"ft300301\":\"34221\",\"ft600303\":\"0\",\"ft110911\":\"0\",\"ft600302\":\"420592\",\"consumerId\":\"36123408795\",\"ft110910\":\"-1\",\"ft110913\":\"1\",\"ft110912\":\"1\",\"ft110914\":\"0\",\"ft110909\":\"-1\",\"fd_1501\":\"85629\",\"ft300904\":\"2\",\"fd_1502\":\"85629\",\"fd_1505\":\"1\",\"ft300306\":\"2\",\"fd_1506\":\"1\",\"ft300901\":\"5\",\"fd_1503\":\"85629\",\"ft300902\":\"44\",\"fd_1504\":\"87247\",\"ft600305\":\"4594\",\"ft300903\":\"4413\",\"ft300302\":\"1\",\"ft300104\":\"33\",\"ft300303\":\"1\",\"ft300105\":\"352\",\"fd_1507\":\"1\",\"ft300304\":\"34221\",\"ft300106\":\"979\",\"fd_1508\":\"15\",\"ft300305\":\"12\",\"ft300107\":\"674\",\"ft301003\":\"11\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"2\",\"ft301001\":\"18\",\"ft200103\":\"07.23.0008\",\"ft200301\":\"0\",\"ft200104\":\"9\",\"ft200106\":\"139426\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft110908\":\"0\",\"ft200101\":\"65521\",\"ft200102\":\"29932\",\"ft500203\":\"9_null\",\"ft500201\":\"65521_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft300201\":\"420592\",\"ft300202\":\"12\",\"advertId\":\"65521\",\"abst\":\"[0]\",\"fd_1502_04\":\"2.26E-5\",\"fd_1506_08\":\"5.5E-6\",\"fd_1506_07\":\"0.0693929\",\"fd_1502_03\":\"0.0778845\",\"time\":\"20230411183517\"}";
        String str15 = "{\"orderId\":\"taw-11526989472100154\",\"fd_1108_01\":\"0\",\"ft100204\":\"rmx3122\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID11\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2021\",\"ft100206\":\"3\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.9320423\",\"ft100205\":\"realme\",\"ft500103\":\"16_3\",\"ft100209\":\"DYN\",\"fd_1318\":\"180_1_10_1,180_1_15_2\",\"fd_1807_01\":\"1\",\"ft500101\":\"88327_3\",\"fd_1105_01\":\"1\",\"ft300101\":\"92751\",\"fd_1810_01\":\"0\",\"fd_1208_01\":\"1\",\"ft300904\":\"3\",\"fd_1302\":\"0\",\"fd_1301\":\"2\",\"fd_1304\":\"0\",\"fd_1303\":\"0\",\"fd_1306\":\"23\",\"ft300901\":\"3\",\"fd_1305\":\"41\",\"ft300902\":\"34\",\"fd_1308\":\"19\",\"ft300903\":\"3407\",\"fd_1307\":\"21\",\"ft300104\":\"27\",\"ft300105\":\"268\",\"fd_1309\":\"10,15\",\"ft300106\":\"985\",\"ft300107\":\"671\",\"ft301003\":\"11\",\"advertBackSubTypes\":\"[3]\",\"ft301002\":\"2\",\"fd_1809_01\":\"0\",\"fd_1209_01\":\"0\",\"ft301001\":\"1\",\"ft200103\":\"07.07.0066\",\"ft200104\":\"16\",\"ft200105\":\"02.19.0001\",\"ft200106\":\"155967\",\"ft200107\":\"05.03.0001,05.02.0001,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"7\",\"fd_1308_02\":\"10\",\"ft200101\":\"88327\",\"ft200102\":\"46016\",\"ft300201\":\"447055\",\"ft300202\":\"3\",\"fd_1107_01\":\"0\",\"advertId\":\"88327\",\"abst\":\"[3]\",\"fd_1506_08\":\"0.0566103\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.117101\",\"fd_1205\":\"3\",\"fd_1207\":\"1\",\"fd_1206\":\"1\",\"fd_1208\":\"1\",\"fd_1305_01\":\"8\",\"fd_1207_01\":\"1\",\"chargeType\":\"2\",\"fd_1120\":\"32031\",\"fd_1110\":\"1689010649\",\"fd_1505_06\":\"0.9212351\",\"fd_1116\":\"0\",\"linkageSubtype\":\"0-6,0-8,0-23,3-6,3-8,3-23\",\"ft300301\":\"32031\",\"fd_1210_01\":\"0\",\"consumerId\":\"36398758042\",\"fd_1307_01\":\"7\",\"fd_1501\":\"86157\",\"fd_1502\":\"86157\",\"fd_1105\":\"1\",\"fd_1505\":\"16\",\"ft300306\":\"2\",\"fd_1506\":\"16\",\"fd_1503\":\"86157\",\"fd_1504\":\"88327\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"32031\",\"fd_1808_01\":\"1\",\"fd_1508\":\"16\",\"ft300305\":\"1\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"3\",\"ft500203\":\"16_null\",\"ft500201\":\"88327_null\",\"f8807\":\"1\",\"fd_1805_01\":\"3\",\"ft110014\":\"1\",\"fd_1808\":\"1\",\"fd_1502_04\":\"0.391917\",\"fd_1001\":\"010101\",\"fd_1003\":\"010502\",\"fd_1309_01\":\"6\",\"fd_1002\":\"01020401\",\"fd_1005\":\"1,34,14,5,17,18,7,10,21\",\"fd_1007\":\"100604,100802,101002,100102,100202,100301,101502\",\"fd_1502_03\":\"0.0011124\",\"fd_1006\":\"1008,1006,1015,1003,1002,1001,1010\",\"fd_1008\":\"61002000,80282000,46032100,80062100,34002000,24082000,61032500,46032000,24025000,24002000,61032000,80113200,80012200,70002000,39002000,36082000,80052300,10001004,80132202,26002000,36082300,36082500,36002000,46002000,39062000,10001132,10000000,80122300,80302300,24022000\",\"time\":\"20230711013734\",\"fd_1806\":\"1\",\"fd_1807\":\"1\",\"fd_1805\":\"3\"}";
        String str16 = "{\"fd_1108_02\":\"1\",\"orderId\":\"taw-11554548374970439\",\"fd_1108_01\":\"1\",\"backTimeConsume\":\"{\\\"0\\\":1712.19,\\\"3\\\":40.16,\\\"19\\\":4450.55,\\\"10\\\":194973.79}\",\"ft100204\":\"oppo a79\",\"fd_1117_01\":\"1\",\"ft100203\":\"ANDROID7\",\"fd_1011_01\":\"1\",\"ft100202\":\"3\",\"ft100201\":\"1\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.6513555\",\"ft500103\":\"10_3\",\"ft100209\":\"DYN\",\"fd_1318\":\"30_1_10_1,30_1_3_2,180_1_10_1,180_1_3_2\",\"fd_1807_01\":\"11\",\"ft500101\":\"88658_3\",\"fd_1105_01\":\"1\",\"ft300101\":\"92966\",\"fd_1810_01\":\"0\",\"fd_1709\":\"10\",\"fd_1208_01\":\"10\",\"fd_1709_01\":\"9\",\"ft300904\":\"4\",\"fd_1306\":\"687\",\"ft300901\":\"7\",\"fd_1305\":\"1303\",\"ft300902\":\"65\",\"fd_1308\":\"477\",\"ft300903\":\"6505\",\"fd_1307\":\"518\",\"ft300104\":\"33\",\"fd_1707\":\"59\",\"ft300105\":\"347\",\"fd_1708\":\"56\",\"fd_1309\":\"10,3\",\"ft300106\":\"987\",\"fd_1705\":\"75\",\"ft300107\":\"696\",\"fd_1706\":\"63\",\"ft301003\":\"19\",\"advertBackSubTypes\":\"[0,3]\",\"ft301002\":\"3\",\"fd_1809_01\":\"10\",\"fd_1209_01\":\"10\",\"ft301001\":\"7\",\"ft200103\":\"07.10.0375\",\"ft200104\":\"10\",\"ft200105\":\"02.22.0001\",\"ft200106\":\"156962\",\"ft200107\":\"05.03.0001,05.02.0018\",\"ft200109\":\"2\",\"fd_1308_01\":\"12\",\"fd_1308_02\":\"13\",\"fd_1214\":\"5387\",\"ft200101\":\"88658\",\"ft200102\":\"46471\",\"ft300201\":\"450917\",\"ft300202\":\"3\",\"fd_1107_01\":\"1\",\"fd_1707_01\":\"9\",\"advertId\":\"88658\",\"abst\":\"[0,3]\",\"fd_1506_08\":\"0.0091397\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"1.1768043\",\"fd_1205\":\"230\",\"fd_1207\":\"114\",\"fd_1710_01\":\"0\",\"fd_1206\":\"133\",\"fd_1209\":\"10,3\",\"fd_1208\":\"100\",\"fd_1305_01\":\"12\",\"fd_1207_01\":\"10\",\"fd_1708_01\":\"9\",\"chargeType\":\"2\",\"fd_1120\":\"33687\",\"fd_1111\":\"10\",\"fd_1110\":\"1689723789\",\"fd_1113\":\"33687\",\"fd_1112\":\"1689723800\",\"fd_1115\":\"786257600954384384\",\"fd_1505_06\":\"0.6709232\",\"fd_1114\":\"786257600954384384\",\"fd_1117\":\"10\",\"fd_1116\":\"1\",\"linkageSubtype\":\"0-6,3-6\",\"ft300301\":\"33687\",\"fd_1705_01\":\"9\",\"ft6002021\":\"212572\",\"fd_1210_01\":\"0\",\"consumerId\":\"35742273975\",\"fd_1307_01\":\"12\",\"fd_1501\":\"88758\",\"fd_1502\":\"88758\",\"fd_1106\":\"1\",\"fd_1105\":\"1\",\"fd_1505\":\"10\",\"ft300306\":\"2\",\"fd_1108\":\"1\",\"fd_1506\":\"10\",\"fd_1107\":\"1\",\"fd_1503\":\"88758\",\"fd_1504\":\"88758\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"33687\",\"fd_1808_01\":\"11\",\"fd_1508\":\"10\",\"ft300305\":\"2\",\"fd_1106_02\":\"1\",\"ft6002031\":\"1000245089\",\"ft200301\":\"0\",\"ft200302\":\"0\",\"ft200303\":\"0\",\"ft200304\":\"0\",\"ft200305\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"11\",\"ft500203\":\"10_null\",\"ft500201\":\"88658_null\",\"f8807\":\"1\",\"fd_1805_01\":\"12\",\"ft110014\":\"1\",\"ft6002041\":\"206594926\",\"fd_1808\":\"181\",\"fd_1809\":\"10,3\",\"fd_1502_04\":\"0.010929\",\"fd_1001\":\"010101\",\"fd_1003\":\"010502\",\"fd_1309_01\":\"10\",\"fd_1002\":\"01020302\",\"fd_1005\":\"5387\",\"fd_1502_03\":\"0.8349727\",\"time\":\"20230719075017\",\"fd_1806\":\"236\",\"fd_1807\":\"201\",\"fd_1805\":\"380\"}";
        String str17 = "{\"orderId\":\"taw-12248426181580860\",\"chargeType\":\"2\",\"fd_1108_01\":\"0\",\"fd_1120\":\"34235\",\"backTimeConsume\":\"{\\\"0\\\":143.31,\\\"11\\\":225460.25,\\\"15\\\":23244.54,\\\"18\\\":1922.35,\\\"19\\\":143.27,\\\"9\\\":370701.48}\",\"ft100204\":\"iphone\",\"fd_1117_01\":\"0\",\"ft100203\":\"IOS16\",\"fd_1110\":\"1698630020\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"ft100208\":\"ios\",\"fd_1505_06\":\"0.5333645\",\"ft100207\":\"-1\",\"ft100206\":\"6\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.5564797\",\"ft100205\":\"iphone\",\"fd_1116\":\"0\",\"ft500103\":\"9_0\",\"ft100209\":\"MOB\",\"ft500101\":\"89588_0\",\"fd_1105_01\":\"1\",\"linkageSubtype\":\"0-11\",\"ft300101\":\"94078\",\"ft300301\":\"34235\",\"consumerId\":\"37523170140\",\"fd_1501\":\"88903\",\"ft300904\":\"2\",\"fd_1502\":\"88903\",\"fd_1105\":\"1\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"ft300901\":\"3\",\"fd_1503\":\"88903\",\"ft300902\":\"35\",\"fd_1504\":\"87271\",\"ft300903\":\"3505\",\"ft300302\":\"1\",\"ft300104\":\"35\",\"ft300303\":\"1\",\"ft300105\":\"358\",\"fd_1507\":\"9\",\"ft300304\":\"34235\",\"ft300106\":\"981\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"ft300107\":\"674\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"ft300113\":\"1\",\"ft301001\":\"9\",\"ft200103\":\"07.23.0008\",\"ft200301\":\"0\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"159858\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft200101\":\"89588\",\"ft200102\":\"44445\",\"ft500203\":\"9_null\",\"ft500201\":\"89588_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft300201\":\"447720\",\"ft300202\":\"12\",\"fd_1107_01\":\"0\",\"advertId\":\"89588\",\"abst\":\"[0]\",\"fd_1502_04\":\"4.322E-4\",\"fd_1506_08\":\"4.96E-5\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.1063338\",\"fd_1502_03\":\"0.1407376\",\"time\":\"20231030094046\"}";
        String str18 = "{\"orderId\":\"taw-12248432159770336\",\"fd_1108_01\":\"0\",\"backTimeConsume\":\"{\\\"0\\\":143.1,\\\"15\\\":68819.0,\\\"18\\\":739.25,\\\"19\\\":48.99}\",\"ft100204\":\"pgt-an10\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID13\",\"fd_1011_01\":\"1\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.5233088\",\"ft100205\":\"honor\",\"ft500103\":\"9_0\",\"ft100209\":\"MOB\",\"ft500101\":\"89121_0\",\"fd_1105_01\":\"4\",\"ft300101\":\"94078\",\"ft300904\":\"1\",\"ft300901\":\"6\",\"ft300902\":\"50\",\"ft300903\":\"50\",\"ft300104\":\"35\",\"ft300105\":\"358\",\"ft300106\":\"981\",\"ft300107\":\"674\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"ft301001\":\"9\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"158490\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft200101\":\"89121\",\"ft200102\":\"47301\",\"ft300201\":\"447721\",\"ft300202\":\"12\",\"fd_1107_01\":\"1\",\"advertId\":\"89121\",\"abst\":\"[0]\",\"fd_1506_08\":\"3.66E-5\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.0907673\",\"chargeType\":\"2\",\"fd_1120\":\"34235\",\"fd_1111\":\"9\",\"fd_1110\":\"1698629911\",\"fd_1113\":\"34235\",\"fd_1112\":\"1698629941\",\"fd_1505_06\":\"0.529432\",\"fd_1114\":\"823612685972234240\",\"fd_1116\":\"0\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"34235\",\"consumerId\":\"37523166544\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1106\":\"2\",\"fd_1105\":\"4\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1107\":\"1\",\"fd_1503\":\"88903\",\"fd_1504\":\"87271\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"9\",\"ft300304\":\"34235\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"fd_1106_02\":\"2\",\"ft300113\":\"1\",\"ft200301\":\"0\",\"ft500203\":\"9_null\",\"ft500201\":\"89121_null\",\"f8807\":\"1\",\"ft110014\":\"3\",\"fd_1502_04\":\"3.506E-4\",\"fd_1502_03\":\"0.096974\",\"time\":\"20231030094010\"}";
        String str19 = "{\"orderId\":\"taw-12248432162420971\",\"chargeType\":\"2\",\"backTimeConsume\":\"{\\\"0\\\":175.39,\\\"15\\\":2080.0,\\\"19\\\":91.14}\",\"ft100204\":\"brq-an00\",\"ft100203\":\"ANDROID12\",\"fd_1011_01\":\"-1\",\"ft100202\":\"2\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.6145073\",\"ft100207\":\"2020\",\"ft100206\":\"5\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.5580559\",\"ft100205\":\"huawei\",\"ft500103\":\"16_0\",\"ft100209\":\"DYN\",\"ft500101\":\"89960_0\",\"linkageSubtype\":\"0-6,0-8,3-23\",\"ft300101\":\"84799\",\"ft300301\":\"34348\",\"consumerId\":\"37523174347\",\"fd_1501\":\"88903\",\"ft300904\":\"4\",\"fd_1502\":\"88903\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"ft300901\":\"1\",\"fd_1503\":\"88903\",\"ft300902\":\"15\",\"fd_1504\":\"87271\",\"ft300903\":\"1525\",\"ft300302\":\"1\",\"ft300104\":\"33\",\"ft300303\":\"1\",\"ft300105\":\"350\",\"fd_1507\":\"9\",\"ft300304\":\"34348\",\"ft300106\":\"977\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"ft300107\":\"674\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"ft300113\":\"1\",\"ft301001\":\"9\",\"ft200103\":\"07.07.0056\",\"ft200301\":\"0\",\"ft200104\":\"16\",\"ft200105\":\"02.19.0004\",\"ft200106\":\"161100\",\"ft200107\":\"05.02.0022,05.03.0002\",\"ft200109\":\"0\",\"ft200101\":\"89960\",\"ft200102\":\"46889\",\"ft500203\":\"16_null\",\"ft500201\":\"89960_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft300201\":\"423588\",\"ft300202\":\"1\",\"advertId\":\"89960\",\"abst\":\"[0]\",\"fd_1502_04\":\"0.0044777\",\"fd_1506_08\":\"0.0168852\",\"fd_1506_07\":\"0.0285614\",\"fd_1502_03\":\"0.0179105\",\"time\":\"20231030094039\"}";
        String str20 = "{\"orderId\":\"taw-12248429122800242\",\"fd_1108_01\":\"0\",\"backTimeConsume\":\"{\\\"0\\\":52.2,\\\"19\\\":70.24}\",\"ft100204\":\"yal-al50\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID10\",\"fd_1011_01\":\"1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2019\",\"ft100206\":\"4\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.6453901\",\"ft100205\":\"honor\",\"ft500103\":\"16_0\",\"ft100209\":\"DYN\",\"ft500101\":\"90027_0\",\"fd_1105_01\":\"1\",\"ft300101\":\"94981\",\"ft300904\":\"1\",\"ft300901\":\"4\",\"ft300902\":\"41\",\"ft300903\":\"4101\",\"ft300104\":\"33\",\"ft300105\":\"346\",\"ft300106\":\"987\",\"ft300107\":\"671\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"ft301001\":\"9\",\"ft200103\":\"07.10.0146\",\"ft200104\":\"16\",\"ft200105\":\"02.19.0003\",\"ft200106\":\"161274\",\"ft200107\":\"05.03.0001,05.02.0018,05.02.0008\",\"ft200109\":\"0\",\"ft200101\":\"90027\",\"ft200102\":\"41435\",\"ft300313\":\"939\",\"ft300201\":\"452305\",\"ft300202\":\"3\",\"fd_1107_01\":\"1\",\"advertId\":\"90027\",\"abst\":\"[0]\",\"fd_1506_08\":\"0.0054603\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.0147606\",\"chargeType\":\"2\",\"fd_1120\":\"33613\",\"fd_1111\":\"16\",\"fd_1110\":\"1698630098\",\"fd_1113\":\"33613\",\"fd_1112\":\"1698630103\",\"fd_1505_06\":\"0.7611544\",\"fd_1114\":\"823613356939223040\",\"fd_1116\":\"0\",\"linkageSubtype\":\"0-6,0-8,3-23\",\"ft300301\":\"33613\",\"consumerId\":\"37523172594\",\"fd_1501\":\"89552\",\"fd_1502\":\"89552\",\"fd_1106\":\"1\",\"fd_1105\":\"1\",\"fd_1505\":\"16\",\"ft300306\":\"2\",\"fd_1506\":\"16\",\"fd_1107\":\"1\",\"fd_1503\":\"84506\",\"fd_1504\":\"86991\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"16\",\"ft300304\":\"33613\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"fd_1106_02\":\"1\",\"ft300113\":\"2\",\"ft200301\":\"0\",\"ft500203\":\"16_null\",\"ft500201\":\"90027_null\",\"f8807\":\"1\",\"ft110014\":\"2\",\"fd_1502_04\":\"0.009288\",\"fd_1502_03\":\"0.012384\",\"time\":\"20231030094151\"}";
        String str201 = "{\"orderId\":\"taw-12248444884440055\",\"backTimeConsume\":\"{\\\"0\\\":73.65,\\\"3\\\":73.25,\\\"19\\\":46.58}\",\"ft100204\":\"ann-an00\",\"ft100203\":\"ANDROID12\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"fd_1310\":\"16\",\"ft100208\":\"android\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.5167198\",\"ft100205\":\"honor\",\"ft500103\":\"16_3\",\"ft100209\":\"DYN\",\"fd_1318\":\"180_1_10_1,180_1_16_2,180_1_9_3,180_2_16_1\",\"fd_1807_01\":\"5\",\"ft500101\":\"86991_3\",\"ft300101\":\"90800\",\"fd_1810_01\":\"0\",\"fd_1208_01\":\"3\",\"fd_1709_01\":\"0\",\"ft300904\":\"3\",\"fd_1302\":\"0\",\"fd_1301\":\"7\",\"fd_1304\":\"0\",\"fd_1303\":\"0\",\"fd_1306\":\"84\",\"ft300901\":\"3\",\"fd_1305\":\"92\",\"ft300902\":\"32\",\"fd_1308\":\"46\",\"ft300903\":\"3208\",\"fd_1307\":\"71\",\"ft300104\":\"33\",\"fd_1707\":\"5\",\"ft300105\":\"346\",\"fd_1708\":\"3\",\"fd_1309\":\"10,16,9\",\"ft300106\":\"986\",\"fd_1705\":\"3\",\"ft300107\":\"671\",\"fd_1706\":\"5\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0,3]\",\"ft301002\":\"1\",\"fd_1809_01\":\"0\",\"fd_1209_01\":\"0\",\"ft301001\":\"9\",\"ft200103\":\"07.10.0146\",\"ft200104\":\"16\",\"ft200105\":\"02.19.0003\",\"ft200106\":\"152173\",\"ft200107\":\"05.03.0001,05.02.0018\",\"ft200109\":\"0\",\"fd_1308_01\":\"9\",\"fd_1308_02\":\"12\",\"ft200101\":\"86991\",\"ft200102\":\"45859\",\"ft600201\":\"41986354\",\"ft300201\":\"425625\",\"ft300202\":\"3\",\"fd_1707_01\":\"5\",\"advertId\":\"86991\",\"abst\":\"[0,3]\",\"fd_1506_08\":\"0.0143457\",\"fd_1506_07\":\"0.0300451\",\"fd_1205\":\"3\",\"fd_1207\":\"5\",\"fd_1710_01\":\"0\",\"fd_1206\":\"5\",\"fd_1208\":\"3\",\"fd_1305_01\":\"10\",\"fd_1207_01\":\"5\",\"fd_1708_01\":\"3\",\"chargeType\":\"2\",\"fd_1505_06\":\"0.5628742\",\"linkageSubtype\":\"0-6,0-8,3-23\",\"ft300301\":\"34919\",\"fd_1705_01\":\"3\",\"fd_1210_01\":\"0\",\"consumerId\":\"37180886071\",\"fd_1307_01\":\"9\",\"fd_1501\":\"83175\",\"fd_1502\":\"83175\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1503\":\"89986\",\"fd_1504\":\"89778\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"34919\",\"fd_1808_01\":\"3\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"ft300113\":\"4\",\"ft6002031\":\"8425132590\",\"ft200301\":\"0\",\"fd_1310_01\":\"2\",\"fd_1310_02\":\"2\",\"fd_1205_01\":\"3\",\"ft500203\":\"16_null\",\"ft500201\":\"86991_null\",\"f8807\":\"1\",\"fd_1805_01\":\"3\",\"ft110014\":\"1\",\"ft6002041\":\"615946152144\",\"fd_1808\":\"3\",\"fd_1502_04\":\"0.0276612\",\"fd_1001\":\"010101\",\"fd_1003\":\"010502\",\"fd_1309_01\":\"7\",\"fd_1002\":\"01020402\",\"fd_1005\":\"1,3,16,65236,8,63942,10\",\"fd_1007\":\"100802,101002,101005,101502,100502\",\"fd_1502_03\":\"0.0268982\",\"fd_1006\":\"1008,1005,1015,1010\",\"fd_1008\":\"198,201,571\",\"time\":\"20231030094033\",\"fd_1806\":\"5\",\"fd_1807\":\"5\",\"fd_1805\":\"3\"}";
        String str202 = "{\"orderId\":\"taw-12248444889280038\",\"fd_1108_01\":\"0\",\"backTimeConsume\":\"{\\\"0\\\":143.1,\\\"15\\\":68819.0,\\\"18\\\":739.25,\\\"19\\\":48.99}\",\"ft100204\":\"ntn-an20\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID12\",\"fd_1011_01\":\"-1\",\"ft100202\":\"3\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.7099692\",\"ft100205\":\"honor\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"fd_1318\":\"30_1_9_1,180_1_9_1\",\"fd_1807_01\":\"1\",\"ft500101\":\"89121_0\",\"fd_1105_01\":\"1\",\"ft300101\":\"90799\",\"fd_1810_01\":\"0\",\"fd_1709\":\"9\",\"fd_1208_01\":\"1\",\"fd_1709_01\":\"1\",\"ft300904\":\"3\",\"fd_1306\":\"1\",\"ft300901\":\"4\",\"fd_1305\":\"1\",\"ft300902\":\"42\",\"fd_1308\":\"1\",\"ft300903\":\"4210\",\"fd_1307\":\"1\",\"ft300104\":\"33\",\"fd_1707\":\"1\",\"ft300105\":\"346\",\"fd_1708\":\"1\",\"fd_1309\":\"9\",\"ft300106\":\"986\",\"fd_1705\":\"1\",\"ft300107\":\"671\",\"fd_1706\":\"1\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"fd_1809_01\":\"1\",\"fd_1209_01\":\"1\",\"ft301001\":\"9\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"158490\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"1\",\"fd_1308_02\":\"1\",\"ft200101\":\"89121\",\"ft200102\":\"47301\",\"ft600201\":\"41986346\",\"ft300201\":\"427220\",\"ft300202\":\"3\",\"fd_1107_01\":\"0\",\"fd_1707_01\":\"1\",\"advertId\":\"89121\",\"abst\":\"[0]\",\"fd_1506_08\":\"3.33E-5\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.0785993\",\"fd_1205\":\"1\",\"fd_1207\":\"1\",\"fd_1710_01\":\"0\",\"fd_1206\":\"1\",\"fd_1209\":\"9\",\"fd_1208\":\"1\",\"fd_1305_01\":\"1\",\"fd_1207_01\":\"1\",\"fd_1708_01\":\"1\",\"chargeType\":\"2\",\"fd_1120\":\"34919\",\"fd_1110\":\"1698630084\",\"fd_1505_06\":\"0.7139666\",\"fd_1116\":\"0\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"34919\",\"fd_1705_01\":\"1\",\"fd_1210_01\":\"0\",\"consumerId\":\"37523172390\",\"fd_1307_01\":\"1\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1105\":\"1\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1503\":\"89819\",\"fd_1504\":\"88845\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"34919\",\"fd_1808_01\":\"1\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"ft300113\":\"4\",\"ft6002031\":\"8801766618\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"1\",\"ft500203\":\"9_null\",\"ft500201\":\"89121_null\",\"f8807\":\"1\",\"fd_1805_01\":\"1\",\"ft110014\":\"1\",\"ft6002041\":\"656804860877\",\"fd_1808\":\"1\",\"fd_1809\":\"9\",\"fd_1502_04\":\"9.178E-4\",\"fd_1001\":\"010102\",\"fd_1003\":\"010501\",\"fd_1309_01\":\"1\",\"fd_1002\":\"010202\",\"fd_1005\":\"1,16,17,7,8,10,21\",\"fd_1007\":\"100604,100802,101002,100102,100202,101502,100502\",\"fd_1502_03\":\"0.0617926\",\"fd_1006\":\"1008,1006,1005,1015,1002,1001,1010\",\"fd_1008\":\"385,202,378,192,927\",\"time\":\"20231030094127\",\"fd_1806\":\"1\",\"fd_1807\":\"1\",\"fd_1805\":\"1\"}";
        String str21 = "{\"orderId\":\"taw-12248429117690112\",\"chargeType\":\"2\",\"fd_1108_01\":\"0\",\"fd_1120\":\"34348\",\"backTimeConsume\":\"{\\\"0\\\":109.92,\\\"15\\\":24134.0,\\\"18\\\":819.8,\\\"19\\\":85.54}\",\"ft100204\":\"pdkt00\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID12\",\"fd_1110\":\"1698630047\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.6726164\",\"ft100207\":\"2020\",\"ft100206\":\"4\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.6836708\",\"ft100205\":\"oppo\",\"fd_1116\":\"0\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"ft500101\":\"83756_0\",\"fd_1105_01\":\"1\",\"linkageSubtype\":\"0-11\",\"ft300101\":\"84799\",\"ft300301\":\"34348\",\"consumerId\":\"37523174512\",\"fd_1501\":\"88903\",\"ft300904\":\"4\",\"fd_1502\":\"88903\",\"fd_1105\":\"1\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"ft300901\":\"6\",\"fd_1503\":\"88903\",\"ft300902\":\"53\",\"fd_1504\":\"87271\",\"ft300903\":\"5304\",\"ft300302\":\"1\",\"ft300104\":\"33\",\"ft300303\":\"1\",\"ft300105\":\"350\",\"fd_1507\":\"9\",\"ft300304\":\"34348\",\"ft300106\":\"977\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"ft300107\":\"674\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"ft300113\":\"1\",\"ft301001\":\"9\",\"ft200103\":\"07.23.0008\",\"ft200301\":\"0\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"157736\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft200101\":\"83756\",\"ft200102\":\"29932\",\"ft500203\":\"9_null\",\"ft500201\":\"83756_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft300201\":\"423588\",\"ft300202\":\"1\",\"fd_1107_01\":\"0\",\"advertId\":\"83756\",\"abst\":\"[0]\",\"fd_1502_04\":\"2.928E-4\",\"fd_1506_08\":\"1.68E-5\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.1195466\",\"fd_1502_03\":\"0.1250854\",\"time\":\"20231030094051\"}";
        String str22 = "{\"fd_1108_02\":\"1\",\"orderId\":\"taw-12248439791780236\",\"fd_1108_01\":\"1\",\"backTimeConsume\":\"{\\\"0\\\":140.82,\\\"11\\\":240187.89,\\\"15\\\":33015.76,\\\"18\\\":6587.14,\\\"19\\\":47.94,\\\"9\\\":388732.74}\",\"ft100204\":\"pbem00\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID10\",\"fd_1011_01\":\"1\",\"ft100202\":\"3\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2018\",\"ft100206\":\"5\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.7811209\",\"ft100205\":\"oppo\",\"ft500103\":\"9_0\",\"ft100209\":\"IDC\",\"fd_1318\":\"30_1_10_1,180_1_10_1\",\"fd_1807_01\":\"1\",\"ft500101\":\"83175_0\",\"fd_1105_01\":\"1\",\"ft300101\":\"90446\",\"fd_1810_01\":\"0\",\"ft300904\":\"1\",\"fd_1306\":\"1\",\"ft300901\":\"5\",\"fd_1305\":\"1\",\"ft300902\":\"44\",\"fd_1308\":\"1\",\"ft300903\":\"4419\",\"fd_1307\":\"1\",\"ft300104\":\"27\",\"ft300105\":\"267\",\"fd_1309\":\"10\",\"ft300106\":\"987\",\"ft300107\":\"696\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"fd_1809_01\":\"1\",\"ft301001\":\"9\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"153601\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"1\",\"fd_1308_02\":\"1\",\"ft200101\":\"83175\",\"ft200102\":\"44445\",\"ft300201\":\"455690\",\"ft300202\":\"3\",\"fd_1107_01\":\"1\",\"advertId\":\"83175\",\"abst\":\"[0]\",\"fd_1506_08\":\"1.18E-5\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.0773683\",\"fd_1305_01\":\"1\",\"chargeType\":\"2\",\"fd_1120\":\"35249\",\"fd_1111\":\"9\",\"fd_1110\":\"1698629978\",\"fd_1113\":\"35249\",\"fd_1112\":\"1698629988\",\"fd_1115\":\"823612857804472320\",\"fd_1505_06\":\"0.8031188\",\"fd_1114\":\"823612857804472320\",\"fd_1116\":\"1\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"35249\",\"ft6002021\":\"212406\",\"consumerId\":\"37523169516\",\"fd_1307_01\":\"1\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1106\":\"1\",\"fd_1105\":\"1\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1108\":\"1\",\"fd_1506\":\"9\",\"fd_1107\":\"1\",\"fd_1503\":\"89986\",\"fd_1504\":\"86991\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"35249\",\"fd_1808_01\":\"1\",\"fd_1508\":\"10\",\"ft300305\":\"2\",\"fd_1106_02\":\"1\",\"ft300113\":\"4\",\"ft6002031\":\"1000221779\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"ft500203\":\"9_null\",\"ft500201\":\"83175_null\",\"f8807\":\"1\",\"fd_1805_01\":\"1\",\"ft110014\":\"2\",\"ft6002041\":\"207519184\",\"fd_1808\":\"1\",\"fd_1809\":\"10\",\"fd_1502_04\":\"4.64E-5\",\"fd_1001\":\"010102\",\"fd_1003\":\"010501\",\"fd_1309_01\":\"1\",\"fd_1002\":\"01020301\",\"fd_1005\":\"1,65483,2,14,5,17,18,19,10,21\",\"fd_1007\":\"100604,100802,101002,100202,100301,101502\",\"fd_1502_03\":\"0.0729434\",\"fd_1006\":\"1008,1006,1015,1003,1002,1010\",\"fd_1008\":\"452,394\",\"time\":\"20231030094033\",\"fd_1806\":\"1\",\"fd_1807\":\"1\",\"fd_1805\":\"1\"}";
        String str23 = "{\"orderId\":\"taw-12248443452430778\",\"fd_1108_01\":\"0\",\"backTimeConsume\":\"{\\\"0\\\":12.83,\\\"3\\\":71.45,\\\"19\\\":55.67}\",\"ft100204\":\"phj110\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID12\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.7314366\",\"ft100205\":\"oppo\",\"ft500103\":\"10_3\",\"ft100209\":\"DYN\",\"fd_1807_01\":\"6\",\"ft500101\":\"89986_3\",\"fd_1105_01\":\"2\",\"ft300101\":\"90790\",\"fd_1810_01\":\"0\",\"fd_1208_01\":\"0\",\"fd_1709_01\":\"0\",\"ft300904\":\"4\",\"fd_1306\":\"8\",\"ft300901\":\"4\",\"ft300109\":\"com.meijie.qipai.box\",\"fd_1305\":\"42\",\"ft300902\":\"41\",\"fd_1308\":\"1\",\"ft300903\":\"4102\",\"fd_1307\":\"6\",\"ft300104\":\"27\",\"fd_1707\":\"0\",\"ft300105\":\"268\",\"fd_1708\":\"0\",\"ft300106\":\"987\",\"fd_1705\":\"2\",\"ft300107\":\"671\",\"fd_1706\":\"0\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0,3]\",\"ft301002\":\"1\",\"fd_1809_01\":\"0\",\"fd_1209_01\":\"0\",\"ft301001\":\"9\",\"ft200103\":\"07.10.0396\",\"ft200104\":\"10\",\"ft200105\":\"02.22.0001\",\"ft200106\":\"161187\",\"ft200107\":\"05.02.0018\",\"ft200109\":\"0\",\"fd_1308_01\":\"1\",\"fd_1308_02\":\"1\",\"fd_1214\":\"162591\",\"ft200101\":\"89986\",\"ft200102\":\"47025\",\"fd_1602_04\":\"0.0104896\",\"fd_1602_03\":\"0.5244756\",\"ft600201\":\"22551270\",\"ft300201\":\"456687\",\"ft300202\":\"3\",\"fd_1107_01\":\"0\",\"fd_1707_01\":\"0\",\"advertId\":\"89986\",\"abst\":\"[0,3]\",\"fd_1506_08\":\"0.0046423\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.8530495\",\"fd_1205\":\"23\",\"fd_1207\":\"2\",\"fd_1710_01\":\"0\",\"fd_1206\":\"2\",\"fd_1208\":\"0\",\"fd_1305_01\":\"8\",\"fd_1207_01\":\"2\",\"fd_1708_01\":\"0\",\"chargeType\":\"2\",\"fd_1120\":\"34904,35381\",\"fd_1110\":\"1698599957\",\"fd_1505_06\":\"0.7864214\",\"fd_1116\":\"0\",\"linkageSubtype\":\"0-6,3-6,4-6,6-6\",\"ft300301\":\"34904\",\"fd_1705_01\":\"2\",\"ft6002021\":\"3x2rr68a6dj7nhq\",\"fd_1210_01\":\"0\",\"consumerId\":\"37523175178\",\"fd_1307_01\":\"6\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1105\":\"2\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1503\":\"89986\",\"fd_1504\":\"89778\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"34904\",\"fd_1808_01\":\"1\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"ft300113\":\"4\",\"ft6002031\":\"3167143503\",\"ft200301\":\"0\",\"ft200302\":\"0\",\"ft200303\":\"0\",\"ft200304\":\"0\",\"ft200305\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"8\",\"ft500203\":\"10_null\",\"ft500201\":\"89986_null\",\"f8807\":\"1\",\"fd_1805_01\":\"8\",\"ft110014\":\"1\",\"ft6002041\":\"36363219303\",\"fd_1808\":\"1\",\"fd_1502_04\":\"0.0054348\",\"fd_1001\":\"010101\",\"fd_1003\":\"010501\",\"fd_1309_01\":\"0\",\"fd_1002\":\"01020301\",\"fd_1005\":\"1,34,2,16,17,19,8,162591,10,21\",\"fd_1007\":\"100604,100802,101002,100102,100202,101502,100502\",\"fd_1502_03\":\"1.4927537\",\"fd_1006\":\"1008,1006,1005,1015,1002,1001,1010\",\"fd_1008\":\"385,202,378,193\",\"fd_1601_02\":\"0.5827161\",\"time\":\"20231030094142\",\"fd_1806\":\"8\",\"fd_1807\":\"6\",\"fd_1805\":\"42\"}";
        String str24 = "{\"fd_1108_02\":\"2\",\"orderId\":\"taw-12248443449550551\",\"fd_1108_01\":\"2\",\"backTimeConsume\":\"{\\\"0\\\":143.31,\\\"11\\\":225460.25,\\\"15\\\":23244.54,\\\"18\\\":1922.35,\\\"19\\\":143.27,\\\"9\\\":370701.48}\",\"ft100204\":\"cma-an40\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID11\",\"fd_1011_01\":\"0\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.6531748\",\"ft100205\":\"honor\",\"ft500103\":\"9_0\",\"ft100209\":\"MOB\",\"fd_1318\":\"180_1_10_1\",\"fd_1807_01\":\"2\",\"ft500101\":\"89588_0\",\"fd_1105_01\":\"3\",\"ft300101\":\"90800\",\"fd_1810_01\":\"0\",\"ft300904\":\"4\",\"fd_1306\":\"12\",\"ft300901\":\"4\",\"fd_1305\":\"13\",\"ft300902\":\"41\",\"fd_1308\":\"8\",\"ft300903\":\"4102\",\"fd_1307\":\"12\",\"ft300104\":\"33\",\"ft300105\":\"346\",\"fd_1309\":\"10\",\"ft300106\":\"986\",\"ft300107\":\"671\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"fd_1809_01\":\"0\",\"ft301001\":\"9\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"159858\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"6\",\"fd_1308_02\":\"7\",\"ft200101\":\"89588\",\"ft200102\":\"44445\",\"ft600201\":\"41986363\",\"ft300201\":\"425969\",\"ft300202\":\"3\",\"fd_1107_01\":\"2\",\"advertId\":\"89588\",\"abst\":\"[0]\",\"fd_1506_08\":\"3.2E-6\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.0826438\",\"fd_1305_01\":\"7\",\"chargeType\":\"2\",\"fd_1120\":\"35771,34919\",\"fd_1111\":\"16\",\"fd_1110\":\"1698629723\",\"fd_1113\":\"35771\",\"fd_1112\":\"1698629760\",\"fd_1115\":\"823611900265811968\",\"fd_1505_06\":\"0.6600061\",\"fd_1114\":\"823611900265811968\",\"fd_1116\":\"1\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"35771\",\"consumerId\":\"37523157543\",\"fd_1307_01\":\"7\",\"fd_1501\":\"83175\",\"fd_1502\":\"83175\",\"fd_1106\":\"4\",\"fd_1105\":\"3\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1108\":\"2\",\"fd_1506\":\"9\",\"fd_1107\":\"2\",\"fd_1503\":\"89819\",\"fd_1504\":\"89778\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"35771\",\"fd_1808_01\":\"1\",\"fd_1508\":\"16\",\"ft300305\":\"0\",\"fd_1106_02\":\"4\",\"ft300113\":\"4\",\"ft6002031\":\"8493232947\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"ft500203\":\"9_null\",\"ft500201\":\"89588_null\",\"f8807\":\"1\",\"fd_1805_01\":\"1\",\"ft110014\":\"3\",\"ft6002041\":\"623017566881\",\"fd_1808\":\"1\",\"fd_1502_04\":\"3.65E-5\",\"fd_1001\":\"010102\",\"fd_1003\":\"010501\",\"fd_1309_01\":\"6\",\"fd_1002\":\"010202\",\"fd_1005\":\"1,2,7,19,149797,21\",\"fd_1007\":\"100604,101002,100102,100202\",\"fd_1502_03\":\"0.1000949\",\"fd_1006\":\"1006,1002,1001,1010\",\"fd_1008\":\"385,441,202,248,337,91,910,92,192,393,790,571\",\"time\":\"20231030094110\",\"fd_1806\":\"2\",\"fd_1807\":\"2\",\"fd_1805\":\"1\"}";
        String str25 = "{\"orderId\":\"taw-12248439799090477\",\"chargeType\":\"2\",\"backTimeConsume\":\"{\\\"0\\\":133.95,\\\"15\\\":18799.33,\\\"18\\\":751.2,\\\"19\\\":57.08}\",\"ft100204\":\"vie-al10\",\"ft100203\":\"ANDROID8\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.7889513\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.8255697\",\"ft100205\":\"huawei\",\"ft500103\":\"9_0\",\"ft100209\":\"MOB\",\"ft500101\":\"80766_0\",\"linkageSubtype\":\"0-11\",\"ft300101\":\"94776\",\"ft300301\":\"34992\",\"consumerId\":\"37523172829\",\"fd_1501\":\"87682\",\"ft300904\":\"4\",\"fd_1502\":\"87682\",\"fd_1505\":\"16\",\"ft300306\":\"2\",\"fd_1506\":\"16\",\"ft300901\":\"3\",\"fd_1503\":\"80766\",\"ft300902\":\"36\",\"fd_1504\":\"87682\",\"ft300903\":\"3610\",\"ft300302\":\"1\",\"ft300104\":\"40\",\"ft300303\":\"1\",\"ft300105\":\"388\",\"fd_1507\":\"9\",\"ft300304\":\"34992\",\"ft300106\":\"981\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"ft300107\":\"673\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"ft300113\":\"4\",\"ft301001\":\"9\",\"ft200103\":\"07.23.0008\",\"ft200301\":\"0\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"139428\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft200101\":\"80766\",\"ft200102\":\"29932\",\"ft500203\":\"9_null\",\"ft500201\":\"80766_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft300201\":\"447957\",\"ft300202\":\"12\",\"advertId\":\"80766\",\"abst\":\"[0]\",\"fd_1502_04\":\"9.061E-4\",\"fd_1506_08\":\"4.926E-4\",\"fd_1506_07\":\"0.1543261\",\"fd_1502_03\":\"0.1715494\",\"time\":\"20231030094158\"}";
        String str26 = "{\"fd_1108_02\":\"1\",\"orderId\":\"taw-12248444890140085\",\"fd_1108_01\":\"1\",\"backTimeConsume\":\"{\\\"0\\\":63.49,\\\"3\\\":63.72,\\\"10\\\":16983.79}\",\"ft100204\":\"pct-al10\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID10\",\"fd_1011_01\":\"1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2018\",\"ft100206\":\"4\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.7312424\",\"ft100205\":\"honor\",\"ft500103\":\"16_0\",\"ft100209\":\"DYN\",\"fd_1318\":\"30_1_10_1,180_1_10_1\",\"fd_1807_01\":\"6\",\"ft500101\":\"84940_0\",\"fd_1105_01\":\"1\",\"ft300101\":\"90800\",\"fd_1810_01\":\"0\",\"fd_1709\":\"10\",\"fd_1208_01\":\"4\",\"fd_1709_01\":\"5\",\"ft300904\":\"2\",\"fd_1302\":\"1\",\"fd_1301\":\"84\",\"fd_1304\":\"0\",\"fd_1303\":\"1\",\"fd_1306\":\"31\",\"ft300901\":\"3\",\"fd_1305\":\"38\",\"ft300902\":\"37\",\"fd_1308\":\"5\",\"ft300903\":\"3706\",\"fd_1307\":\"27\",\"ft300104\":\"33\",\"fd_1707\":\"5\",\"ft300105\":\"346\",\"fd_1708\":\"4\",\"fd_1309\":\"10\",\"ft300106\":\"986\",\"fd_1705\":\"4\",\"ft300107\":\"671\",\"fd_1706\":\"7\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0,3]\",\"ft301002\":\"1\",\"fd_1809_01\":\"5\",\"fd_1209_01\":\"5\",\"ft301001\":\"9\",\"ft200103\":\"07.10.0146\",\"ft200104\":\"16\",\"ft200105\":\"02.19.0003\",\"ft200106\":\"148491\",\"ft200107\":\"05.03.0012,05.02.0023,05.02.0001,05.02.0019\",\"ft200109\":\"0\",\"fd_1308_01\":\"5\",\"fd_1308_02\":\"5\",\"ft200101\":\"84940\",\"ft200102\":\"44840\",\"ft600201\":\"41986363\",\"ft300201\":\"425969\",\"ft300202\":\"3\",\"fd_1107_01\":\"1\",\"fd_1707_01\":\"5\",\"advertId\":\"84940\",\"abst\":\"[0,3]\",\"fd_1506_08\":\"0.0216025\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.0374175\",\"fd_1205\":\"4\",\"fd_1207\":\"5\",\"fd_1710_01\":\"0\",\"fd_1206\":\"7\",\"fd_1209\":\"10\",\"fd_1208\":\"4\",\"fd_1305_01\":\"8\",\"fd_1207_01\":\"5\",\"fd_1708_01\":\"4\",\"chargeType\":\"2\",\"fd_1120\":\"34919\",\"fd_1111\":\"16\",\"fd_1110\":\"1698630068\",\"fd_1113\":\"34919\",\"fd_1112\":\"1698630077\",\"fd_1115\":\"823613233119166464\",\"fd_1505_06\":\"0.705182\",\"fd_1114\":\"823613233119166464\",\"fd_1116\":\"1\",\"linkageSubtype\":\"0-6,0-8,3-23\",\"ft300301\":\"34919\",\"fd_1705_01\":\"4\",\"fd_1210_01\":\"0\",\"consumerId\":\"37083977813\",\"fd_1307_01\":\"8\",\"fd_1501\":\"83175\",\"fd_1502\":\"83175\",\"fd_1106\":\"1\",\"fd_1105\":\"1\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1108\":\"1\",\"fd_1506\":\"9\",\"fd_1107\":\"1\",\"fd_1503\":\"89819\",\"fd_1504\":\"89778\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"34919\",\"fd_1808_01\":\"4\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"fd_1106_02\":\"1\",\"ft300113\":\"4\",\"ft6002031\":\"8493232947\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"4\",\"ft500203\":\"16_null\",\"ft500201\":\"84940_null\",\"f8807\":\"1\",\"fd_1805_01\":\"4\",\"ft110014\":\"2\",\"ft6002041\":\"623017566881\",\"fd_1808\":\"4\",\"fd_1809\":\"10\",\"fd_1502_04\":\"0.0172985\",\"fd_1001\":\"010102\",\"fd_1003\":\"010502\",\"fd_1309_01\":\"6\",\"fd_1002\":\"01020301\",\"fd_1005\":\"1,34,15,17,148514,10,21\",\"fd_1007\":\"100604,101002,100102,100202,101502\",\"fd_1502_03\":\"0.0172985\",\"fd_1006\":\"1006,1015,1002,1001,1010\",\"fd_1008\":\"89,193,790,571,386,474,771,397,399,202,521,731,711,92,737,528,518,606,508,718\",\"time\":\"20231030094135\",\"fd_1806\":\"9\",\"fd_1807\":\"7\",\"fd_1805\":\"4\"}";
        String str27 = "{\"orderId\":\"taw-12248418284400335\",\"backTimeConsume\":\"{\\\"0\\\":143.31,\\\"11\\\":225460.25,\\\"15\\\":23244.54,\\\"18\\\":1922.35,\\\"19\\\":143.27,\\\"9\\\":370701.48}\",\"ft100204\":\"chl-an00\",\"ft100203\":\"ANDROID11\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.6531748\",\"ft100205\":\"honor\",\"ft500103\":\"9_0\",\"ft100209\":\"MOB\",\"ft500101\":\"89588_0\",\"ft300101\":\"90800\",\"ft300904\":\"1\",\"fd_1306\":\"1\",\"ft300901\":\"3\",\"fd_1305\":\"2\",\"ft300902\":\"33\",\"fd_1308\":\"0\",\"ft300903\":\"3302\",\"fd_1307\":\"0\",\"ft300104\":\"33\",\"ft300105\":\"346\",\"ft300106\":\"986\",\"ft300107\":\"671\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"ft301001\":\"9\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"159858\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"0\",\"fd_1308_02\":\"0\",\"ft200101\":\"89588\",\"ft200102\":\"44445\",\"ft600201\":\"41986363\",\"ft300201\":\"425969\",\"ft300202\":\"3\",\"advertId\":\"89588\",\"abst\":\"[0]\",\"fd_1506_08\":\"3.2E-6\",\"fd_1506_07\":\"0.0826438\",\"fd_1305_01\":\"2\",\"chargeType\":\"2\",\"fd_1505_06\":\"0.6600061\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"35771\",\"consumerId\":\"36999343439\",\"fd_1307_01\":\"0\",\"fd_1501\":\"83175\",\"fd_1502\":\"83175\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1503\":\"89819\",\"fd_1504\":\"89778\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"35771\",\"fd_1508\":\"16\",\"ft300305\":\"0\",\"ft300113\":\"4\",\"ft6002031\":\"8493227869\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"ft500203\":\"9_null\",\"ft500201\":\"89588_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft6002041\":\"623017142215\",\"fd_1502_04\":\"3.65E-5\",\"fd_1001\":\"010102\",\"fd_1003\":\"010502\",\"fd_1309_01\":\"0\",\"fd_1002\":\"01020301\",\"fd_1005\":\"1,34,2,5,17\",\"fd_1007\":\"101002,100102,100202,101502\",\"fd_1502_03\":\"0.1000949\",\"fd_1006\":\"1015,1002,1001,1010\",\"fd_1008\":\"193,393,790,571,561,386,441,397,266,399,202,444,137,446,303,535,91,738,508,927\",\"time\":\"20231030094126\"}";
        String str30 = "{\"orderId\":\"taw-12248418278090672\",\"backTimeConsume\":\"{\\\"0\\\":146.94,\\\"11\\\":143086.69,\\\"13\\\":110.0,\\\"15\\\":15482.39,\\\"18\\\":1909.12,\\\"19\\\":41.78,\\\"9\\\":296680.2}\",\"ft100204\":\"sea-al00\",\"ft100203\":\"ANDROID10\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2019\",\"ft100206\":\"4\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.6204664\",\"ft100205\":\"huawei\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"fd_1318\":\"180_1_10_1\",\"fd_1807_01\":\"6\",\"ft500101\":\"88903_0\",\"ft300101\":\"90618\",\"fd_1810_01\":\"0\",\"fd_1208_01\":\"1\",\"fd_1709_01\":\"0\",\"ft300904\":\"4\",\"fd_1302\":\"0\",\"fd_1301\":\"20\",\"fd_1304\":\"0\",\"fd_1303\":\"0\",\"fd_1306\":\"10\",\"ft300901\":\"1\",\"ft300109\":\"com.huawei.fastapp\",\"fd_1305\":\"12\",\"ft300902\":\"14\",\"fd_1308\":\"3\",\"ft300903\":\"1404\",\"fd_1307\":\"9\",\"ft300104\":\"33\",\"fd_1707\":\"1\",\"ft300105\":\"347\",\"fd_1708\":\"0\",\"fd_1309\":\"10\",\"ft300106\":\"985\",\"fd_1705\":\"2\",\"ft300107\":\"671\",\"fd_1706\":\"1\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"fd_1809_01\":\"0\",\"fd_1209_01\":\"0\",\"ft301001\":\"9\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"161015\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"3\",\"fd_1308_02\":\"3\",\"fd_1214\":\"65576,1622\",\"ft200101\":\"88903\",\"ft200102\":\"47174\",\"fd_1215\":\"100205\",\"fd_1602_04\":\"3.97E-5\",\"fd_1602_03\":\"0.0238332\",\"ft300201\":\"424469\",\"ft300202\":\"8\",\"fd_1707_01\":\"1\",\"advertId\":\"88903\",\"abst\":\"[0]\",\"fd_1506_08\":\"1.47E-5\",\"fd_1506_07\":\"0.0420264\",\"fd_1205\":\"5\",\"fd_1207\":\"2\",\"fd_1710_01\":\"0\",\"fd_1206\":\"2\",\"fd_1208\":\"1\",\"fd_1305_01\":\"7\",\"fd_1207_01\":\"2\",\"fd_1708_01\":\"0\",\"chargeType\":\"2\",\"fd_1505_06\":\"0.5430181\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"35940\",\"fd_1705_01\":\"2\",\"fd_1210_01\":\"0\",\"consumerId\":\"37523167904\",\"fd_1307_01\":\"6\",\"fd_1501\":\"83175\",\"fd_1502\":\"88903\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1503\":\"89986\",\"fd_1504\":\"89778\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"35940\",\"fd_1808_01\":\"2\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"ft300111\":\"12\",\"ft300113\":\"8\",\"ft300110\":\"3\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"5\",\"ft500203\":\"9_null\",\"ft500201\":\"88903_null\",\"f8807\":\"1\",\"fd_1805_01\":\"6\",\"ft110014\":\"1\",\"fd_1808\":\"2\",\"fd_1502_04\":\"3.78E-5\",\"fd_1001\":\"010101\",\"fd_1003\":\"010502\",\"fd_1309_01\":\"1\",\"fd_1002\":\"01020401\",\"fd_1005\":\"1,1622,15,65576,83083,10\",\"fd_1007\":\"101002,101302,101502,100205\",\"fd_1502_03\":\"0.0404817\",\"fd_1006\":\"1015,1002,1013,1010\",\"fd_1008\":\"386\",\"fd_1601_02\":\"0.4985342\",\"time\":\"20231030094012\",\"fd_1806\":\"6\",\"fd_1807\":\"6\",\"fd_1805\":\"8\"}";
        String str31 = "{\"orderId\":\"taw-12248426185470690\",\"chargeType\":\"2\",\"backTimeConsume\":\"{\\\"0\\\":146.94,\\\"11\\\":143086.69,\\\"13\\\":110.0,\\\"15\\\":15482.39,\\\"18\\\":1909.12,\\\"19\\\":41.78,\\\"9\\\":296680.2}\",\"ft100204\":\"pftm20\",\"ft100203\":\"ANDROID13\",\"fd_1011_01\":\"-1\",\"ft100202\":\"3\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.7765863\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.8363263\",\"ft100205\":\"oppo\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"ft500101\":\"88903_0\",\"linkageSubtype\":\"0-11\",\"ft300101\":\"89546\",\"ft300301\":\"35944\",\"consumerId\":\"37523175090\",\"fd_1501\":\"89588\",\"ft300904\":\"2\",\"fd_1502\":\"89588\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"ft300901\":\"3\",\"fd_1503\":\"89588\",\"ft300902\":\"34\",\"ft300903\":\"3401\",\"ft300302\":\"1\",\"ft300104\":\"39\",\"ft300303\":\"1\",\"ft300105\":\"378\",\"fd_1507\":\"9\",\"ft300304\":\"35944\",\"ft300106\":\"986\",\"ft300305\":\"2\",\"ft300107\":\"671\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"ft300113\":\"2\",\"ft301001\":\"9\",\"ft200103\":\"07.23.0008\",\"ft200301\":\"0\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"161015\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft200101\":\"88903\",\"ft200102\":\"47174\",\"ft500203\":\"9_null\",\"ft500201\":\"88903_null\",\"f8807\":\"1\",\"ft300313\":\"939\",\"ft110014\":\"1\",\"ft300201\":\"456922\",\"ft300202\":\"3\",\"advertId\":\"88903\",\"abst\":\"[0]\",\"fd_1506_07\":\"0.0967583\",\"fd_1502_03\":\"0.1003533\",\"time\":\"20231030094129\"}";
        String str32 = "{\"fd_1108_02\":\"3\",\"orderId\":\"taw-12248444890820010\",\"fd_1108_01\":\"3\",\"backTimeConsume\":\"{\\\"0\\\":83.84,\\\"15\\\":1943.83,\\\"18\\\":347.0,\\\"19\\\":136.02}\",\"ft100204\":\"m2006c3lc\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID11\",\"fd_1011_01\":\"1\",\"ft100202\":\"3\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2020\",\"ft100206\":\"6\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.5360825\",\"ft100205\":\"xiaomi\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"fd_1318\":\"30_1_10_1,30_1_16_2,30_1_9_3,30_1_1_4,30_1_21_5,180_1_10_1,180_1_16_2,180_1_9_3,180_1_1_4,180_1_21_5\",\"fd_1807_01\":\"11\",\"ft500101\":\"89815_0\",\"fd_1105_01\":\"4\",\"ft300101\":\"94664\",\"fd_1810_01\":\"0\",\"fd_1709\":\"10,16,9,1,21\",\"fd_1208_01\":\"11\",\"fd_1709_01\":\"8\",\"ft300904\":\"4\",\"fd_1306\":\"228\",\"ft300901\":\"6\",\"fd_1305\":\"270\",\"ft300902\":\"51\",\"fd_1308\":\"197\",\"ft300903\":\"5109\",\"fd_1307\":\"224\",\"ft300104\":\"38\",\"fd_1707\":\"216\",\"ft300105\":\"369\",\"fd_1708\":\"189\",\"fd_1309\":\"10,16,9,1,21\",\"ft300106\":\"985\",\"fd_1705\":\"262\",\"ft300107\":\"671\",\"fd_1706\":\"219\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"fd_1809_01\":\"8\",\"fd_1209_01\":\"8\",\"ft301001\":\"9\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"160674\",\"ft200107\":\"05.03.0002,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"11\",\"fd_1308_02\":\"13\",\"ft200101\":\"89815\",\"ft200102\":\"47663\",\"ft300201\":\"456965\",\"ft300202\":\"3\",\"fd_1107_01\":\"3\",\"fd_1707_01\":\"11\",\"advertId\":\"89815\",\"abst\":\"[0]\",\"fd_1506_08\":\"0.0010707\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.0206996\",\"fd_1205\":\"270\",\"fd_1207\":\"224\",\"fd_1710_01\":\"0\",\"fd_1206\":\"228\",\"fd_1209\":\"10,16,9,1,21\",\"fd_1208\":\"197\",\"fd_1305_01\":\"11\",\"fd_1207_01\":\"11\",\"fd_1708_01\":\"11\",\"chargeType\":\"2\",\"fd_1120\":\"35940,35581\",\"fd_1111\":\"9\",\"fd_1110\":\"1698629571\",\"fd_1113\":\"35940\",\"fd_1112\":\"1698630064\",\"fd_1115\":\"823613174960951296\",\"fd_1505_06\":\"0.7376039\",\"fd_1114\":\"823613174960951296\",\"fd_1116\":\"1\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"35940\",\"fd_1705_01\":\"11\",\"fd_1210_01\":\"0\",\"consumerId\":\"37482273802\",\"fd_1307_01\":\"11\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1106\":\"3\",\"fd_1105\":\"4\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1108\":\"3\",\"fd_1506\":\"9\",\"fd_1107\":\"3\",\"fd_1503\":\"89819\",\"fd_1504\":\"88845\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"35940\",\"fd_1808_01\":\"11\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"fd_1106_02\":\"3\",\"ft300113\":\"4\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"11\",\"ft500203\":\"9_null\",\"ft500201\":\"89815_null\",\"f8807\":\"1\",\"fd_1805_01\":\"11\",\"ft110014\":\"2\",\"fd_1808\":\"197\",\"fd_1809\":\"10,16,9,1,21\",\"fd_1502_04\":\"0.0194806\",\"fd_1001\":\"010102\",\"fd_1003\":\"010502\",\"fd_1309_01\":\"8\",\"fd_1002\":\"010202\",\"fd_1005\":\"2,144112,21\",\"fd_1007\":\"100604,101002\",\"fd_1502_03\":\"0.0389611\",\"fd_1006\":\"1006,1010\",\"fd_1008\":\"386,452,89,201,378,303,558,192,291,518,508,394\",\"time\":\"20231030094142\",\"fd_1806\":\"228\",\"fd_1807\":\"224\",\"fd_1805\":\"270\"}";
        String str33 = "{\"fd_1108_02\":\"1\",\"orderId\":\"taw-12248439786850573\",\"fd_1108_01\":\"1\",\"backTimeConsume\":\"{\\\"0\\\":12.83,\\\"3\\\":71.45,\\\"19\\\":55.67}\",\"ft100204\":\"stk-al00\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID10\",\"fd_1011_01\":\"0\",\"ft100202\":\"4\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2019\",\"ft100206\":\"3\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.5284553\",\"ft100205\":\"huawei\",\"ft500103\":\"10_3\",\"ft100209\":\"DYN\",\"ft500101\":\"89986_3\",\"fd_1105_01\":\"1\",\"ft300101\":\"90115\",\"ft300904\":\"1\",\"ft300901\":\"4\",\"ft300109\":\"com.ss.android.ugc.aweme.lite\",\"ft300902\":\"42\",\"ft300903\":\"4201\",\"ft300104\":\"33\",\"ft300105\":\"346\",\"ft300106\":\"985\",\"ft300107\":\"671\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0,3]\",\"ft301002\":\"1\",\"ft301001\":\"9\",\"ft200103\":\"07.10.0396\",\"ft200104\":\"10\",\"ft200105\":\"02.22.0001\",\"ft200106\":\"161187\",\"ft200107\":\"05.02.0018\",\"ft200109\":\"0\",\"ft200101\":\"89986\",\"ft200102\":\"47025\",\"fd_1602_04\":\"0.0021127\",\"fd_1602_03\":\"0.7539907\",\"ft600201\":\"51069066\",\"ft300201\":\"457082\",\"ft300202\":\"3\",\"fd_1107_01\":\"1\",\"advertId\":\"89986\",\"abst\":\"[0,3]\",\"fd_1506_08\":\"0.0082816\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.8902692\",\"chargeType\":\"2\",\"fd_1120\":\"33758\",\"fd_1111\":\"9\",\"fd_1110\":\"1698613859\",\"fd_1113\":\"33758\",\"fd_1112\":\"1698613870\",\"fd_1115\":\"823545252297105408\",\"fd_1505_06\":\"0.5204327\",\"fd_1114\":\"823545252297105408\",\"fd_1116\":\"1\",\"linkageSubtype\":\"0-6,3-6,4-6,6-6\",\"ft300301\":\"33758\",\"consumerId\":\"37411756605\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1106\":\"1\",\"fd_1105\":\"1\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1108\":\"1\",\"fd_1506\":\"9\",\"fd_1107\":\"1\",\"fd_1503\":\"89986\",\"fd_1504\":\"88985\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"33758\",\"fd_1508\":\"10\",\"ft300305\":\"2\",\"ft300111\":\"7\",\"fd_1106_02\":\"1\",\"ft300113\":\"8\",\"ft6002031\":\"9101924050\",\"ft300110\":\"4\",\"ft200301\":\"0\",\"ft200302\":\"0\",\"ft200303\":\"0\",\"ft200304\":\"0\",\"ft200305\":\"0\",\"ft500203\":\"10_null\",\"ft500201\":\"89986_null\",\"f8807\":\"1\",\"ft110014\":\"2\",\"ft6002041\":\"694491194457\",\"fd_1502_04\":\"0.0122449\",\"fd_1502_03\":\"0.9265307\",\"fd_1601_02\":\"0.5917909\",\"time\":\"20231030093938\"}";
        String str34 = "{\"orderId\":\"taw-12248425555310642\",\"fd_1108_01\":\"0\",\"backTimeConsume\":\"{\\\"0\\\":79.8,\\\"19\\\":88.25}\",\"ft100204\":\"m2007j22c\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID12\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2020\",\"ft100206\":\"3\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.6292683\",\"ft100205\":\"redmi\",\"ft500103\":\"16_0\",\"ft100209\":\"DYN\",\"fd_1318\":\"180_1_10_1\",\"fd_1807_01\":\"2\",\"ft500101\":\"89187_0\",\"fd_1105_01\":\"1\",\"ft300101\":\"84494\",\"fd_1810_01\":\"0\",\"fd_1208_01\":\"2\",\"ft300904\":\"4\",\"fd_1302\":\"0\",\"fd_1301\":\"128\",\"fd_1304\":\"0\",\"fd_1303\":\"0\",\"fd_1306\":\"41\",\"ft300901\":\"6\",\"ft300109\":\"cn.etouch.ecalendar\",\"fd_1305\":\"56\",\"ft300902\":\"52\",\"fd_1308\":\"15\",\"ft300903\":\"5206\",\"fd_1307\":\"28\",\"ft300104\":\"39\",\"ft300105\":\"370\",\"fd_1309\":\"10\",\"ft300106\":\"980\",\"ft300107\":\"671\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"fd_1809_01\":\"0\",\"fd_1209_01\":\"0\",\"ft301001\":\"9\",\"ft200103\":\"07.10.0146\",\"ft200104\":\"16\",\"ft200105\":\"02.19.0003\",\"ft200106\":\"158677\",\"ft200107\":\"05.03.0012,05.02.0001,05.02.0019\",\"ft200109\":\"0\",\"fd_1308_01\":\"7\",\"fd_1308_02\":\"9\",\"ft200101\":\"89187\",\"ft200102\":\"47359\",\"fd_1602_04\":\"0.0079399\",\"fd_1602_03\":\"0.0346467\",\"ft300201\":\"393407\",\"ft300202\":\"2\",\"fd_1107_01\":\"0\",\"advertId\":\"89187\",\"abst\":\"[0]\",\"fd_1506_08\":\"0.008977\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.0239387\",\"fd_1205\":\"2\",\"fd_1207\":\"2\",\"fd_1206\":\"2\",\"fd_1208\":\"2\",\"fd_1305_01\":\"9\",\"fd_1207_01\":\"2\",\"chargeType\":\"2\",\"fd_1120\":\"34387\",\"fd_1110\":\"1698630084\",\"fd_1505_06\":\"0.6865846\",\"fd_1116\":\"0\",\"linkageSubtype\":\"0-6,0-8,3-23\",\"ft300301\":\"34387\",\"fd_1210_01\":\"0\",\"consumerId\":\"37523177090\",\"fd_1307_01\":\"8\",\"fd_1501\":\"83756\",\"fd_1502\":\"83175\",\"fd_1105\":\"1\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1503\":\"83175\",\"fd_1504\":\"86991\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"9\",\"ft300304\":\"34387\",\"fd_1808_01\":\"2\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"ft300111\":\"18\",\"ft300113\":\"4\",\"ft300110\":\"3\",\"ft200301\":\"0\",\"ft200302\":\"0\",\"ft200303\":\"0\",\"ft200304\":\"0\",\"ft200305\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"2\",\"ft500203\":\"16_null\",\"ft500201\":\"89187_null\",\"f8807\":\"1\",\"fd_1805_01\":\"5\",\"ft110014\":\"1\",\"fd_1808\":\"2\",\"fd_1502_04\":\"0.0167598\",\"fd_1001\":\"010101\",\"fd_1003\":\"010501\",\"fd_1309_01\":\"2\",\"fd_1002\":\"01020301\",\"fd_1005\":\"145487,10\",\"fd_1007\":\"101502\",\"fd_1502_03\":\"0.027933\",\"fd_1006\":\"1015\",\"fd_1008\":\"193,391,393,263,385,397,399,202,378,521,148,303,436,528,927\",\"fd_1601_02\":\"0.6467536\",\"time\":\"20231030094132\",\"fd_1806\":\"7\",\"fd_1807\":\"2\",\"fd_1805\":\"5\"}";
        String str35 = "{\"orderId\":\"taw-12248429120110413\",\"chargeType\":\"2\",\"fd_1108_01\":\"0\",\"fd_1120\":\"35860\",\"backTimeConsume\":\"{\\\"0\\\":146.94,\\\"11\\\":143086.69,\\\"13\\\":110.0,\\\"15\\\":15482.39,\\\"18\\\":1909.12,\\\"19\\\":41.78,\\\"9\\\":296680.2}\",\"ft100204\":\"v2123a\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID11\",\"fd_1110\":\"1698630058\",\"fd_1011_01\":\"-1\",\"ft100202\":\"2\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.7620717\",\"ft100207\":\"2021\",\"ft100206\":\"3\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.8237742\",\"ft100205\":\"vivo\",\"fd_1116\":\"0\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"ft500101\":\"88903_0\",\"fd_1105_01\":\"1\",\"linkageSubtype\":\"0-11\",\"ft300101\":\"95668\",\"ft300301\":\"35860\",\"consumerId\":\"37523170717\",\"fd_1501\":\"88903\",\"ft300904\":\"4\",\"fd_1502\":\"88903\",\"fd_1105\":\"1\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"ft300901\":\"3\",\"fd_1503\":\"88903\",\"ft300902\":\"37\",\"fd_1504\":\"88883\",\"ft300903\":\"3709\",\"ft300302\":\"1\",\"ft300104\":\"39\",\"ft300303\":\"1\",\"ft300105\":\"831\",\"fd_1507\":\"9\",\"ft300304\":\"35860\",\"ft300106\":\"981\",\"fd_1508\":\"1\",\"ft300305\":\"12\",\"ft300107\":\"674\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"ft300113\":\"7\",\"ft301001\":\"9\",\"ft200103\":\"07.23.0008\",\"ft200301\":\"0\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"161015\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft200101\":\"88903\",\"ft200102\":\"47174\",\"ft500203\":\"9_null\",\"ft500201\":\"88903_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft300201\":\"456368\",\"ft300202\":\"12\",\"fd_1107_01\":\"0\",\"advertId\":\"88903\",\"abst\":\"[0]\",\"fd_1502_04\":\"3.31E-5\",\"fd_1506_08\":\"8.8E-6\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.1957313\",\"fd_1502_03\":\"0.2280441\",\"time\":\"20231030094119\"}";
        String str36 = "{\"orderId\":\"taw-12375952647540317\",\"chargeType\":\"2\",\"fd_1108_01\":\"0\",\"fd_1120\":\"33613\",\"backTimeConsume\":\"{\\\"3\\\":203.34}\",\"ft100204\":\"ppa-al20\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID10\",\"fd_1110\":\"1700012984\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.7174539\",\"ft100207\":\"2020\",\"ft100206\":\"4\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.778355\",\"ft100205\":\"huawei\",\"fd_1116\":\"0\",\"ft500103\":\"16_3\",\"ft100209\":\"DYN\",\"ft500101\":\"90228_3\",\"fd_1105_01\":\"3\",\"linkageSubtype\":\"0-6,0-8,3-23\",\"ft300101\":\"93245\",\"ft300301\":\"33613\",\"consumerId\":\"37607319869\",\"fd_1501\":\"88254\",\"ft300904\":\"4\",\"fd_1502\":\"88845\",\"fd_1105\":\"3\",\"fd_1505\":\"16\",\"ft300306\":\"2\",\"fd_1506\":\"16\",\"ft300901\":\"2\",\"fd_1503\":\"88845\",\"ft300902\":\"23\",\"fd_1504\":\"88845\",\"ft300903\":\"2311\",\"ft300302\":\"1\",\"ft300104\":\"27\",\"ft300303\":\"1\",\"ft300105\":\"268\",\"fd_1507\":\"16\",\"ft300304\":\"33613\",\"ft300106\":\"985\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"ft300107\":\"671\",\"ft301003\":\"15\",\"advertBackSubTypes\":\"[3]\",\"ft301002\":\"3\",\"ft300113\":\"2\",\"ft301001\":\"11\",\"ft200103\":\"07.07.0034\",\"ft200301\":\"0\",\"ft200104\":\"16\",\"ft200105\":\"02.19.0004\",\"ft200106\":\"161772\",\"ft200107\":\"05.03.0013,05.02.0001,05.02.0013,05.02.0019\",\"ft200109\":\"0\",\"ft200101\":\"90228\",\"ft200102\":\"47337\",\"ft500203\":\"16_null\",\"ft500201\":\"90228_null\",\"f8807\":\"1\",\"ft300313\":\"939\",\"ft110014\":\"1\",\"ft300201\":\"444511\",\"ft300202\":\"8\",\"fd_1107_01\":\"0\",\"advertId\":\"90228\",\"abst\":\"[3]\",\"fd_1502_04\":\"0.0252898\",\"fd_1506_08\":\"0.0129858\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.0327259\",\"fd_1502_03\":\"0.0031613\",\"time\":\"20231115114307\"}";
        String str37 = "{\"orderId\":\"taw-12375965364100986\",\"fd_1108_01\":\"0\",\"backTimeConsume\":\"{\\\"0\\\":147.22,\\\"11\\\":76866.18,\\\"15\\\":10924.88,\\\"18\\\":1110.38,\\\"19\\\":44.77,\\\"9\\\":317521.91}\",\"ft100204\":\"pacm00\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID10\",\"fd_1011_01\":\"-1\",\"ft100202\":\"3\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"ft100207\":\"2018\",\"ft100206\":\"5\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.814769\",\"ft100205\":\"oppo\",\"ft500103\":\"9_0\",\"ft100209\":\"MOB\",\"fd_1318\":\"180_1_10_1\",\"ft500101\":\"88903_0\",\"fd_1105_01\":\"1\",\"ft300101\":\"90446\",\"ft300904\":\"2\",\"fd_1302\":\"0\",\"fd_1301\":\"3\",\"fd_1304\":\"0\",\"fd_1303\":\"0\",\"fd_1306\":\"9\",\"ft300901\":\"1\",\"fd_1305\":\"14\",\"ft300902\":\"13\",\"fd_1308\":\"6\",\"ft300903\":\"1301\",\"fd_1307\":\"7\",\"ft300104\":\"27\",\"ft300105\":\"267\",\"fd_1309\":\"10\",\"ft300106\":\"987\",\"ft300107\":\"696\",\"ft301003\":\"15\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"3\",\"ft301001\":\"11\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"161015\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"6\",\"fd_1308_02\":\"6\",\"ft200101\":\"88903\",\"ft200102\":\"47174\",\"ft300201\":\"455690\",\"ft300202\":\"3\",\"fd_1107_01\":\"0\",\"advertId\":\"88903\",\"abst\":\"[0]\",\"fd_1506_08\":\"1.0E-5\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.094623\",\"fd_1305_01\":\"7\",\"chargeType\":\"2\",\"fd_1120\":\"35249\",\"fd_1110\":\"1700019737\",\"fd_1505_06\":\"0.7988368\",\"fd_1116\":\"0\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"35249\",\"ft6002021\":\"346694\",\"consumerId\":\"37435807706\",\"fd_1307_01\":\"6\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1105\":\"1\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1503\":\"89563\",\"fd_1504\":\"89791\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"35249\",\"fd_1508\":\"10\",\"ft300305\":\"2\",\"ft300113\":\"4\",\"ft6002031\":\"1000221779\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"ft500203\":\"9_null\",\"ft500201\":\"88903_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft6002041\":\"207767823\",\"fd_1502_04\":\"1.66E-5\",\"fd_1001\":\"010101\",\"fd_1003\":\"010502\",\"fd_1309_01\":\"6\",\"fd_1002\":\"01020301\",\"fd_1005\":\"16,17,21,6716\",\"fd_1007\":\"100604,101506,100202,100502\",\"fd_1502_03\":\"0.0981377\",\"fd_1006\":\"1006,1005,1015,1002\",\"fd_1008\":\"193,391,491,386,266,201,399,378,521,444,445,446,82,528,927\",\"time\":\"20231115114223\"}";
        String str38 = "{\"orderId\":\"taw-12375898245420462\",\"fd_1108_01\":\"0\",\"backTimeConsume\":\"{\\\"0\\\":147.22,\\\"11\\\":76866.18,\\\"15\\\":10924.88,\\\"18\\\":1110.38,\\\"19\\\":44.77,\\\"9\\\":317521.91}\",\"ft100204\":\"pfgm00\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID12\",\"fd_1011_01\":\"1\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"ft100207\":\"2021\",\"ft100206\":\"4\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.8070249\",\"ft100205\":\"oppo\",\"ft500103\":\"9_0\",\"ft100209\":\"MOB\",\"fd_1318\":\"30_1_1_1,180_1_10_1,180_1_1_2\",\"fd_1807_01\":\"2\",\"ft500101\":\"88903_0\",\"fd_1105_01\":\"1\",\"ft300101\":\"92966\",\"fd_1810_01\":\"0\",\"ft300904\":\"3\",\"fd_1306\":\"19\",\"ft300901\":\"7\",\"fd_1305\":\"8\",\"ft300902\":\"64\",\"fd_1308\":\"14\",\"ft300903\":\"6401\",\"fd_1307\":\"16\",\"ft300104\":\"33\",\"ft300105\":\"347\",\"fd_1309\":\"10,1\",\"ft300106\":\"987\",\"ft300107\":\"696\",\"ft301003\":\"15\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"3\",\"fd_1809_01\":\"1\",\"ft301001\":\"11\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"161015\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"7\",\"fd_1308_02\":\"9\",\"ft200101\":\"88903\",\"ft200102\":\"47174\",\"ft300201\":\"456973\",\"ft300202\":\"3\",\"fd_1107_01\":\"1\",\"advertId\":\"88903\",\"abst\":\"[0]\",\"fd_1506_08\":\"8.0E-6\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.1019099\",\"fd_1305_01\":\"6\",\"chargeType\":\"2\",\"fd_1120\":\"35249\",\"fd_1111\":\"9\",\"fd_1110\":\"1700019629\",\"fd_1113\":\"35249\",\"fd_1112\":\"1700019638\",\"fd_1505_06\":\"0.7867839\",\"fd_1114\":\"829441473356611584\",\"fd_1116\":\"0\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"35249\",\"ft6002021\":\"513557\",\"consumerId\":\"37607723470\",\"fd_1307_01\":\"7\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1106\":\"1\",\"fd_1105\":\"1\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1107\":\"1\",\"fd_1503\":\"89563\",\"fd_1504\":\"86991\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"35249\",\"fd_1808_01\":\"2\",\"fd_1508\":\"10\",\"ft300305\":\"2\",\"fd_1106_02\":\"1\",\"ft300113\":\"4\",\"ft6002031\":\"1000296710\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"ft500203\":\"9_null\",\"ft500201\":\"88903_null\",\"f8807\":\"1\",\"fd_1805_01\":\"3\",\"ft110014\":\"2\",\"ft6002041\":\"208026851\",\"fd_1808\":\"2\",\"fd_1809\":\"1\",\"fd_1502_04\":\"1.32E-5\",\"fd_1001\":\"010101\",\"fd_1003\":\"010501\",\"fd_1309_01\":\"6\",\"fd_1002\":\"01020301\",\"fd_1005\":\"1,2,14,16,5,17,18,19,8,10,21\",\"fd_1007\":\"100604,100802,101002,100202,100301,101502,100502\",\"fd_1502_03\":\"0.1041802\",\"fd_1006\":\"1008,1006,1005,1015,1003,1002,1010\",\"fd_1008\":\"385,474,266,201,444,521,193,506,391,393,927,571\",\"time\":\"20231115114044\",\"fd_1806\":\"3\",\"fd_1807\":\"2\",\"fd_1805\":\"3\"}";
        String str39 = "{\"orderId\":\"taw-12375933589870619\",\"fd_1108_01\":\"0\",\"backTimeConsume\":\"{\\\"3\\\":333.18}\",\"ft100204\":\"ang-an00\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID12\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2020\",\"ft100206\":\"5\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.6729363\",\"ft100205\":\"huawei\",\"ft500103\":\"16_3\",\"ft100209\":\"DYN\",\"fd_1318\":\"30_1_10_1,180_1_10_1\",\"fd_1807_01\":\"7\",\"ft500101\":\"88254_3\",\"fd_1105_01\":\"1\",\"ft300101\":\"90437\",\"fd_1810_01\":\"0\",\"fd_1709\":\"10\",\"fd_1208_01\":\"6\",\"fd_1709_01\":\"1\",\"ft300904\":\"3\",\"fd_1302\":\"1\",\"fd_1301\":\"6\",\"fd_1304\":\"0\",\"fd_1303\":\"0\",\"fd_1306\":\"33\",\"ft300901\":\"3\",\"fd_1305\":\"66\",\"ft300902\":\"37\",\"fd_1308\":\"20\",\"ft300903\":\"3710\",\"fd_1307\":\"27\",\"ft300104\":\"33\",\"fd_1707\":\"7\",\"ft300105\":\"346\",\"fd_1708\":\"3\",\"fd_1309\":\"10\",\"ft300106\":\"985\",\"fd_1705\":\"21\",\"ft300107\":\"671\",\"fd_1706\":\"11\",\"ft301003\":\"15\",\"advertBackSubTypes\":\"[3]\",\"ft301002\":\"3\",\"fd_1809_01\":\"3\",\"fd_1209_01\":\"2\",\"ft301001\":\"11\",\"ft200103\":\"07.10.0146\",\"ft200104\":\"16\",\"ft200105\":\"02.19.0003\",\"ft200106\":\"157340\",\"ft200107\":\"05.03.0013,05.02.0001,05.02.0008,05.02.0019\",\"ft200109\":\"0\",\"fd_1308_01\":\"7\",\"fd_1308_02\":\"10\",\"fd_1214\":\"57059,1683\",\"ft200101\":\"88254\",\"ft200102\":\"46607\",\"fd_1215\":\"101506,100501\",\"ft300201\":\"457204\",\"ft300202\":\"3\",\"fd_1107_01\":\"0\",\"fd_1707_01\":\"6\",\"advertId\":\"88254\",\"abst\":\"[3]\",\"fd_1506_08\":\"0.0049806\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.0154343\",\"fd_1205\":\"25\",\"fd_1207\":\"13\",\"fd_1710_01\":\"0\",\"fd_1206\":\"17\",\"fd_1209\":\"10\",\"fd_1208\":\"6\",\"fd_1305_01\":\"9\",\"fd_1207_01\":\"7\",\"fd_1708_01\":\"3\",\"chargeType\":\"2\",\"fd_1120\":\"35940\",\"fd_1110\":\"1700019641\",\"fd_1505_06\":\"0.6652186\",\"fd_1116\":\"0\",\"linkageSubtype\":\"0-6,0-8,3-23\",\"ft300301\":\"35940\",\"fd_1705_01\":\"7\",\"fd_1210_01\":\"0\",\"consumerId\":\"37602361963\",\"fd_1307_01\":\"8\",\"fd_1501\":\"89563\",\"fd_1502\":\"89563\",\"fd_1105\":\"1\",\"fd_1505\":\"10\",\"ft300306\":\"2\",\"fd_1506\":\"10\",\"fd_1503\":\"89563\",\"fd_1504\":\"89563\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"35940\",\"fd_1808_01\":\"7\",\"fd_1508\":\"10\",\"ft300305\":\"2\",\"ft300113\":\"4\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"8\",\"ft500203\":\"16_null\",\"ft500201\":\"88254_null\",\"f8807\":\"1\",\"fd_1805_01\":\"8\",\"ft110014\":\"1\",\"fd_1808\":\"11\",\"fd_1809\":\"10\",\"fd_1502_04\":\"0.0072047\",\"fd_1001\":\"010101\",\"fd_1003\":\"010502\",\"fd_1309_01\":\"5\",\"fd_1002\":\"01020301\",\"fd_1005\":\"3,16,17,57059,1683,18,83083,10\",\"fd_1007\":\"100802,101506,100202,101005,101302,100501,101502,100502\",\"fd_1502_03\":\"0.0043228\",\"fd_1006\":\"1008,1005,1015,1002,1013,1010\",\"fd_1008\":\"386,441,343,201,378,999,193,393,508,790,927\",\"time\":\"20231115114046\",\"fd_1806\":\"23\",\"fd_1807\":\"18\",\"fd_1805\":\"42\"}";
        String str40 = "{\"orderId\":\"taw-12375952634870486\",\"backTimeConsume\":\"{\\\"0\\\":147.22,\\\"11\\\":76866.18,\\\"15\\\":10924.88,\\\"18\\\":1110.38,\\\"19\\\":44.77,\\\"9\\\":317521.91}\",\"ft100204\":\"pcam10\",\"ft100203\":\"ANDROID11\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"ft100207\":\"2019\",\"ft100206\":\"3\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.7870864\",\"ft100205\":\"oppo\",\"ft500103\":\"9_0\",\"ft100209\":\"MOB\",\"fd_1318\":\"180_1_10_1\",\"fd_1807_01\":\"0\",\"ft500101\":\"88903_0\",\"ft300101\":\"92966\",\"fd_1810_01\":\"0\",\"fd_1208_01\":\"0\",\"ft300904\":\"2\",\"fd_1302\":\"0\",\"fd_1301\":\"47\",\"fd_1304\":\"0\",\"fd_1303\":\"0\",\"fd_1306\":\"20\",\"ft300901\":\"3\",\"fd_1305\":\"45\",\"ft300902\":\"34\",\"fd_1308\":\"9\",\"ft300903\":\"3401\",\"fd_1307\":\"19\",\"ft300104\":\"33\",\"ft300105\":\"347\",\"fd_1309\":\"10\",\"ft300106\":\"987\",\"ft300107\":\"696\",\"ft301003\":\"15\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"3\",\"fd_1809_01\":\"0\",\"fd_1209_01\":\"0\",\"ft301001\":\"11\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"161015\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"6\",\"fd_1308_02\":\"8\",\"ft200101\":\"88903\",\"ft200102\":\"47174\",\"ft300201\":\"456970\",\"ft300202\":\"3\",\"advertId\":\"88903\",\"abst\":\"[0]\",\"fd_1506_08\":\"4.614E-4\",\"fd_1506_07\":\"0.0627403\",\"fd_1205\":\"1\",\"fd_1207\":\"0\",\"fd_1206\":\"0\",\"fd_1208\":\"0\",\"fd_1305_01\":\"9\",\"fd_1207_01\":\"0\",\"chargeType\":\"2\",\"fd_1505_06\":\"0.7712442\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"35249\",\"ft6002021\":\"213551\",\"fd_1210_01\":\"0\",\"consumerId\":\"37607722470\",\"fd_1307_01\":\"7\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1505\":\"10\",\"ft300306\":\"2\",\"fd_1506\":\"10\",\"fd_1503\":\"89563\",\"fd_1504\":\"89563\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"35249\",\"fd_1808_01\":\"0\",\"fd_1508\":\"10\",\"ft300305\":\"2\",\"ft300113\":\"4\",\"ft6002031\":\"1000296707\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"1\",\"ft500203\":\"9_null\",\"ft500201\":\"88903_null\",\"f8807\":\"1\",\"fd_1805_01\":\"1\",\"ft110014\":\"1\",\"ft6002041\":\"208119318\",\"fd_1808\":\"0\",\"fd_1502_04\":\"6.091E-4\",\"fd_1001\":\"010102\",\"fd_1003\":\"010501\",\"fd_1309_01\":\"6\",\"fd_1002\":\"010202\",\"fd_1005\":\"40928,10\",\"fd_1007\":\"100204,101502\",\"fd_1502_03\":\"0.0653675\",\"fd_1006\":\"1015,1002\",\"fd_1008\":\"385,202,378,192\",\"time\":\"20231115114039\",\"fd_1806\":\"0\",\"fd_1807\":\"0\",\"fd_1805\":\"1\"}";
        String str41 = "{\"fd_1108_02\":\"7\",\"orderId\":\"taw-12415861965810558\",\"fd_1108_01\":\"7\",\"backTimeConsume\":\"{\\\"0\\\":118.51,\\\"11\\\":172399.65,\\\"15\\\":15962.42,\\\"19\\\":103.85,\\\"9\\\":298312.51}\",\"ft100204\":\"pftm20\",\"fd_1117_01\":\"5\",\"ft100203\":\"ANDROID12\",\"fd_1011_01\":\"1\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.7061192\",\"ft100205\":\"oppo\",\"ft500103\":\"9_0\",\"ft100209\":\"MOB\",\"fd_1318\":\"30_1_9_1,30_1_10_2,30_1_4_3,30_1_16_4,180_1_10_1,180_1_9_2,180_1_16_3,180_1_4_4,180_1_1_5\",\"fd_1807_01\":\"8\",\"ft500101\":\"89533_0\",\"fd_1105_01\":\"8\",\"ft300101\":\"95860\",\"fd_1810_01\":\"0\",\"fd_1709\":\"4,16,9,10\",\"fd_1208_01\":\"8\",\"fd_1709_01\":\"4\",\"ft300904\":\"3\",\"fd_1306\":\"90\",\"ft300901\":\"3\",\"ft300109\":\"com.avoid.adequ\",\"fd_1305\":\"83\",\"ft300902\":\"37\",\"fd_1308\":\"82\",\"ft300903\":\"3710\",\"fd_1307\":\"88\",\"ft300104\":\"27\",\"fd_1707\":\"14\",\"ft300105\":\"268\",\"fd_1708\":\"12\",\"fd_1309\":\"10,9,16,4,1\",\"ft300106\":\"987\",\"fd_1705\":\"11\",\"ft300107\":\"671\",\"fd_1706\":\"14\",\"ft301003\":\"21\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"2\",\"fd_1809_01\":\"7\",\"fd_1209_01\":\"6\",\"ft301001\":\"3\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"161019\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"1\",\"fd_1308_01\":\"9\",\"fd_1308_02\":\"13\",\"fd_1214\":\"141759\",\"ft200101\":\"89533\",\"ft200102\":\"47174\",\"fd_1602_04\":\"9.034E-4\",\"fd_1602_03\":\"0.0749775\",\"ft300201\":\"457554\",\"ft300202\":\"3\",\"fd_1107_01\":\"7\",\"fd_1707_01\":\"7\",\"advertId\":\"89533\",\"abst\":\"[0]\",\"fd_1506_08\":\"4.8E-5\",\"fd_1118_01\":\"1\",\"ft200111\":\"2\",\"fd_1506_07\":\"0.0467443\",\"fd_1205\":\"28\",\"fd_1207\":\"34\",\"fd_1710_01\":\"0\",\"fd_1206\":\"34\",\"fd_1209\":\"9,10,4,16\",\"fd_1208\":\"29\",\"fd_1305_01\":\"9\",\"fd_1207_01\":\"8\",\"fd_1708_01\":\"7\",\"chargeType\":\"2\",\"fd_1120\":\"35206,35110,32351\",\"fd_1111\":\"9\",\"fd_1110\":\"1700496787\",\"fd_1113\":\"32351\",\"fd_1112\":\"1700507117\",\"fd_1115\":\"831486109755551744\",\"fd_1505_06\":\"0.7247761\",\"fd_1114\":\"831486109755551744\",\"fd_1117\":\"9,16,10,21\",\"fd_1116\":\"1\",\"fd_1118\":\"16\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"32351\",\"fd_1705_01\":\"7\",\"fd_1210_01\":\"0\",\"consumerId\":\"37634118190\",\"fd_1307_01\":\"9\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1106\":\"19\",\"fd_1105\":\"33\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1108\":\"18\",\"fd_1506\":\"9\",\"fd_1107\":\"19\",\"fd_1503\":\"90174\",\"fd_1504\":\"89920\",\"ft300302\":\"3\",\"ft300303\":\"3\",\"fd_1507\":\"10\",\"ft300304\":\"32351\",\"fd_1808_01\":\"8\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"fd_1106_02\":\"11\",\"ft300113\":\"4\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"8\",\"ft500203\":\"9_null\",\"ft500201\":\"89533_null\",\"f8807\":\"1\",\"fd_1805_01\":\"8\",\"ft110014\":\"11\",\"fd_1808\":\"34\",\"fd_1809\":\"9,10,4,16\",\"fd_1502_04\":\"4.848E-4\",\"fd_1001\":\"010102\",\"fd_1003\":\"010502\",\"fd_1309_01\":\"9\",\"fd_1002\":\"010202\",\"fd_1005\":\"1,16,141759,10\",\"fd_1007\":\"101002,101502,100502\",\"fd_1502_03\":\"0.0323154\",\"fd_1006\":\"1005,1015,1010\",\"fd_1008\":\"192,391,790,263,386,487,399,202,378,248,91,92,528,927\",\"fd_1601_02\":\"0.6213992\",\"time\":\"20231121030720\",\"fd_1806\":\"39\",\"fd_1807\":\"39\",\"fd_1805\":\"32\"}";
        String str42 = "{\"orderId\":\"taw-12415591156240288\",\"ft100204\":\"rmx2117\",\"ft100203\":\"ANDROID12\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2020\",\"ft100206\":\"2\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.7551503\",\"ft100205\":\"realme\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"fd_1318\":\"30_1_10_1,180_1_10_1,180_1_16_2\",\"fd_1807_01\":\"7\",\"ft500101\":\"88903_0\",\"ft300101\":\"95860\",\"fd_1810_01\":\"0\",\"fd_1709\":\"10\",\"fd_1208_01\":\"6\",\"fd_1709_01\":\"3\",\"ft300904\":\"4\",\"fd_1302\":\"0\",\"fd_1301\":\"49\",\"fd_1304\":\"0\",\"fd_1303\":\"0\",\"fd_1306\":\"240\",\"ft300901\":\"6\",\"ft300109\":\"com.zhaoxin.ccyx\",\"fd_1305\":\"229\",\"ft300902\":\"51\",\"fd_1308\":\"160\",\"ft300903\":\"5117\",\"fd_1307\":\"205\",\"ft300104\":\"27\",\"fd_1707\":\"7\",\"ft300105\":\"268\",\"fd_1708\":\"7\",\"fd_1309\":\"10,16\",\"ft300106\":\"987\",\"fd_1705\":\"10\",\"ft300107\":\"671\",\"fd_1706\":\"7\",\"ft301003\":\"21\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"2\",\"fd_1809_01\":\"4\",\"fd_1209_01\":\"4\",\"ft301001\":\"1\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"161015\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"10\",\"fd_1308_02\":\"13\",\"fd_1214\":\"15297,49,164920\",\"ft200101\":\"88903\",\"ft200102\":\"47174\",\"fd_1215\":\"100102,100103\",\"fd_1602_04\":\"1.231E-4\",\"fd_1602_03\":\"0.1068177\",\"ft300201\":\"457553\",\"ft300202\":\"3\",\"fd_1707_01\":\"6\",\"advertId\":\"88903\",\"abst\":\"[0]\",\"fd_1506_08\":\"5.25E-5\",\"ft200111\":\"2\",\"fd_1506_07\":\"0.0571004\",\"fd_1205\":\"11\",\"fd_1207\":\"8\",\"fd_1710_01\":\"0\",\"fd_1206\":\"8\",\"fd_1209\":\"10\",\"fd_1208\":\"8\",\"fd_1305_01\":\"11\",\"fd_1207_01\":\"6\",\"fd_1708_01\":\"6\",\"chargeType\":\"2\",\"fd_1505_06\":\"0.6979915\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"35206\",\"fd_1705_01\":\"6\",\"fd_1210_01\":\"0\",\"consumerId\":\"37617696032\",\"fd_1307_01\":\"11\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1503\":\"90174\",\"fd_1504\":\"89920\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"35206\",\"fd_1808_01\":\"7\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"ft300113\":\"4\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"7\",\"ft500203\":\"9_null\",\"ft500201\":\"88903_null\",\"f8807\":\"1\",\"fd_1805_01\":\"7\",\"ft110014\":\"1\",\"fd_1808\":\"11\",\"fd_1809\":\"10\",\"fd_1502_04\":\"9.47E-5\",\"fd_1001\":\"010101\",\"fd_1003\":\"010502\",\"fd_1309_01\":\"9\",\"fd_1002\":\"01020301\",\"fd_1005\":\"34,163081,49,164920,15297,10,21\",\"fd_1007\":\"100604,100102,100103,101502\",\"fd_1502_03\":\"0.0605669\",\"fd_1006\":\"1006,1015,1001\",\"fd_1008\":\"386,201,378,193\",\"fd_1601_02\":\"0.8099489\",\"time\":\"20231121010238\",\"fd_1806\":\"12\",\"fd_1807\":\"12\",\"fd_1805\":\"17\"}";
        String str43 = "{\"fd_1108_02\":\"7\",\"orderId\":\"taw-12415875448940558\",\"fd_1108_01\":\"7\",\"backTimeConsume\":\"{\\\"0\\\":107.7,\\\"19\\\":587.44}\",\"ft100204\":\"pftm20\",\"fd_1117_01\":\"6\",\"ft100203\":\"ANDROID12\",\"fd_1011_01\":\"1\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.6067416\",\"ft100205\":\"oppo\",\"ft500103\":\"9_0\",\"ft100209\":\"MOB\",\"fd_1318\":\"30_1_9_1,30_1_10_2,30_1_4_3,30_1_16_4,180_1_10_1,180_1_9_2,180_1_16_3,180_1_4_4,180_1_1_5\",\"fd_1807_01\":\"8\",\"ft500101\":\"86209_0\",\"fd_1105_01\":\"8\",\"ft300101\":\"95860\",\"fd_1810_01\":\"0\",\"fd_1709\":\"4,16,9,10\",\"fd_1208_01\":\"8\",\"fd_1709_01\":\"4\",\"ft300904\":\"3\",\"fd_1306\":\"90\",\"ft300901\":\"3\",\"ft300109\":\"com.avoid.adequ\",\"fd_1305\":\"83\",\"ft300902\":\"37\",\"fd_1308\":\"82\",\"ft300903\":\"3710\",\"fd_1307\":\"88\",\"ft300104\":\"27\",\"fd_1707\":\"14\",\"ft300105\":\"268\",\"fd_1708\":\"12\",\"fd_1309\":\"10,9,16,4,1\",\"ft300106\":\"987\",\"fd_1705\":\"11\",\"ft300107\":\"671\",\"fd_1706\":\"14\",\"ft301003\":\"21\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"2\",\"fd_1809_01\":\"7\",\"fd_1209_01\":\"6\",\"ft301001\":\"3\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"150303\",\"ft200107\":\"05.03.0002,05.02.0008\",\"ft200109\":\"1\",\"fd_1308_01\":\"9\",\"fd_1308_02\":\"13\",\"fd_1214\":\"141759\",\"ft200101\":\"86209\",\"ft200102\":\"45689\",\"fd_1602_04\":\"9.034E-4\",\"fd_1602_03\":\"0.0749775\",\"ft300201\":\"457554\",\"ft300202\":\"3\",\"fd_1107_01\":\"7\",\"fd_1707_01\":\"7\",\"advertId\":\"86209\",\"abst\":\"[0]\",\"fd_1506_08\":\"4.8E-5\",\"fd_1118_01\":\"1\",\"ft200111\":\"22\",\"fd_1506_07\":\"0.0467443\",\"fd_1205\":\"28\",\"fd_1207\":\"34\",\"fd_1710_01\":\"0\",\"fd_1206\":\"34\",\"fd_1209\":\"9,10,4,16\",\"fd_1208\":\"29\",\"fd_1305_01\":\"9\",\"fd_1207_01\":\"8\",\"fd_1708_01\":\"7\",\"chargeType\":\"2\",\"fd_1120\":\"35206,35110,32351\",\"fd_1111\":\"9\",\"fd_1110\":\"1700496787\",\"fd_1113\":\"32351\",\"fd_1112\":\"1700507245\",\"fd_1115\":\"831486649822531584\",\"fd_1505_06\":\"0.7247761\",\"fd_1114\":\"831486649822531584\",\"fd_1117\":\"9,16,10,21\",\"fd_1116\":\"1\",\"fd_1118\":\"16\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"32351\",\"fd_1705_01\":\"7\",\"fd_1210_01\":\"0\",\"consumerId\":\"37634118190\",\"fd_1307_01\":\"9\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1106\":\"20\",\"fd_1105\":\"34\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1108\":\"19\",\"fd_1506\":\"9\",\"fd_1107\":\"20\",\"fd_1503\":\"90174\",\"fd_1504\":\"89920\",\"ft300302\":\"3\",\"ft300303\":\"3\",\"fd_1507\":\"10\",\"ft300304\":\"32351\",\"fd_1808_01\":\"8\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"fd_1106_02\":\"11\",\"ft300113\":\"4\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"8\",\"ft500203\":\"9_null\",\"ft500201\":\"86209_null\",\"f8807\":\"1\",\"fd_1805_01\":\"8\",\"ft110014\":\"11\",\"fd_1808\":\"34\",\"fd_1809\":\"9,10,4,16\",\"fd_1502_04\":\"0.0112782\",\"fd_1001\":\"010102\",\"fd_1003\":\"010502\",\"fd_1309_01\":\"9\",\"fd_1002\":\"010202\",\"fd_1005\":\"1,16,141759,10\",\"fd_1007\":\"101002,101502,100502\",\"fd_1502_03\":\"0.0263158\",\"fd_1006\":\"1005,1015,1010\",\"fd_1008\":\"192,391,790,263,386,487,399,202,378,248,91,92,528,927\",\"fd_1601_02\":\"0.6213992\",\"time\":\"20231121030909\",\"fd_1806\":\"39\",\"fd_1807\":\"39\",\"fd_1805\":\"32\"}";
        String str44 = "{\"fd_1108_02\":\"2\",\"orderId\":\"taw-12415715749520558\",\"fd_1108_01\":\"2\",\"ft100204\":\"pftm20\",\"fd_1117_01\":\"2\",\"ft100203\":\"ANDROID12\",\"fd_1011_01\":\"1\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.6067416\",\"ft100205\":\"oppo\",\"ft500103\":\"9_0\",\"ft100209\":\"MOB\",\"fd_1318\":\"30_1_9_1,30_1_10_2,30_1_4_3,30_1_16_4,180_1_10_1,180_1_9_2,180_1_16_3,180_1_4_4,180_1_1_5\",\"fd_1807_01\":\"8\",\"ft500101\":\"86209_0\",\"fd_1105_01\":\"2\",\"ft300101\":\"95860\",\"fd_1810_01\":\"0\",\"fd_1709\":\"4,16,9,10\",\"fd_1208_01\":\"8\",\"fd_1709_01\":\"4\",\"ft300904\":\"3\",\"fd_1306\":\"90\",\"ft300901\":\"3\",\"ft300109\":\"com.avoid.adequ\",\"fd_1305\":\"83\",\"ft300902\":\"37\",\"fd_1308\":\"82\",\"ft300903\":\"3710\",\"fd_1307\":\"88\",\"ft300104\":\"27\",\"fd_1707\":\"14\",\"ft300105\":\"268\",\"fd_1708\":\"12\",\"fd_1309\":\"10,9,16,4,1\",\"ft300106\":\"987\",\"fd_1705\":\"11\",\"ft300107\":\"671\",\"fd_1706\":\"14\",\"ft301003\":\"21\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"2\",\"fd_1809_01\":\"7\",\"fd_1209_01\":\"6\",\"ft301001\":\"2\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"150267\",\"ft200107\":\"05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"9\",\"fd_1308_02\":\"13\",\"fd_1214\":\"141759\",\"ft200101\":\"86209\",\"ft200102\":\"45689\",\"fd_1602_04\":\"9.034E-4\",\"fd_1602_03\":\"0.0749775\",\"ft300201\":\"457554\",\"ft300202\":\"3\",\"fd_1107_01\":\"2\",\"fd_1707_01\":\"7\",\"advertId\":\"86209\",\"abst\":\"[0,19,15]\",\"fd_1506_08\":\"4.8E-5\",\"fd_1118_01\":\"0\",\"ft200111\":\"32\",\"fd_1506_07\":\"0.0467443\",\"fd_1205\":\"28\",\"fd_1207\":\"34\",\"fd_1710_01\":\"0\",\"fd_1206\":\"34\",\"fd_1209\":\"9,10,4,16\",\"fd_1208\":\"29\",\"fd_1305_01\":\"9\",\"fd_1207_01\":\"8\",\"fd_1708_01\":\"7\",\"chargeType\":\"2\",\"fd_1120\":\"35206\",\"fd_1111\":\"9\",\"fd_1110\":\"1700496787\",\"fd_1113\":\"35206\",\"fd_1112\":\"1700503722\",\"fd_1115\":\"831471892763684864\",\"fd_1505_06\":\"0.7247761\",\"fd_1114\":\"831471892763684864\",\"fd_1117\":\"9,10\",\"fd_1116\":\"1\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"35206\",\"fd_1705_01\":\"7\",\"fd_1210_01\":\"0\",\"consumerId\":\"37634118190\",\"fd_1307_01\":\"9\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1106\":\"2\",\"fd_1105\":\"2\",\"fd_1505\":\"9\",\"ft300306\":\"10\",\"fd_1108\":\"2\",\"fd_1506\":\"9\",\"fd_1107\":\"2\",\"fd_1503\":\"90174\",\"fd_1504\":\"89920\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"35206\",\"fd_1808_01\":\"8\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"fd_1106_02\":\"2\",\"ft300113\":\"4\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"8\",\"ft500203\":\"9_null\",\"ft500201\":\"86209_null\",\"f8807\":\"1\",\"fd_1805_01\":\"8\",\"ft110014\":\"3\",\"fd_1808\":\"34\",\"fd_1809\":\"9,10,4,16\",\"fd_1502_04\":\"0.0112782\",\"fd_1001\":\"010102\",\"fd_1003\":\"010502\",\"fd_1309_01\":\"9\",\"fd_1002\":\"010202\",\"fd_1005\":\"1,16,141759,10\",\"fd_1007\":\"101002,101502,100502\",\"fd_1502_03\":\"0.0263158\",\"fd_1006\":\"1005,1015,1010\",\"fd_1008\":\"192,391,790,263,386,487,399,202,378,248,91,92,528,927\",\"fd_1601_02\":\"0.6213992\",\"time\":\"20231121021030\",\"fd_1806\":\"39\",\"fd_1807\":\"39\",\"fd_1805\":\"32\"}";
        String str48 = "{\"orderId\":\"taw-12488823103310010\",\"chargeType\":\"2\",\"fd_1108_01\":\"0\",\"fd_1120\":\"34277\",\"ft100204\":\"rmx3125\",\"fd_1111\":\"16\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID11\",\"fd_1110\":\"1701322442\",\"fd_1011_01\":\"0\",\"ft100202\":\"2\",\"fd_1113\":\"34277\",\"ft100201\":\"3\",\"fd_1112\":\"1701322445\",\"ft100208\":\"android\",\"fd_1115\":\"834905863635914752\",\"fd_1505_06\":\"0.7587263\",\"ft100207\":\"2021\",\"fd_1114\":\"834905863635914752\",\"ft100206\":\"4\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.0\",\"ft100205\":\"realme\",\"fd_1116\":\"1\",\"ft500103\":\"1_3\",\"ft100209\":\"MOB\",\"ft500101\":\"90231_3\",\"fd_1105_01\":\"1\",\"linkageSubtype\":\"0-3,2-6,3-6,3-6,4-6,4-6,4-6,6-6\",\"ft300101\":\"92585\",\"ft300301\":\"34277\",\"consumerId\":\"37680247818\",\"fd_1501\":\"88254\",\"ft300904\":\"3\",\"fd_1502\":\"88254\",\"fd_1106\":\"1\",\"fd_1105\":\"1\",\"fd_1505\":\"16\",\"ft300306\":\"2\",\"fd_1506\":\"16\",\"ft300901\":\"1\",\"fd_1107\":\"1\",\"fd_1503\":\"89986\",\"ft300902\":\"15\",\"fd_1504\":\"88254\",\"ft300903\":\"1501\",\"ft300302\":\"1\",\"ft300104\":\"34\",\"ft300303\":\"1\",\"ft300105\":\"392\",\"fd_1507\":\"10\",\"ft300304\":\"34277\",\"ft300106\":\"981\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"ft300107\":\"674\",\"ft301003\":\"30\",\"ft301002\":\"4\",\"fd_1106_02\":\"1\",\"ft300113\":\"4\",\"ft301001\":\"13\",\"ft200103\":\"07.26.0239\",\"ft200301\":\"0\",\"ft200104\":\"1\",\"ft200302\":\"119\",\"ft200105\":\"02.14.0001\",\"ft200303\":\"0\",\"ft200106\":\"161776\",\"ft200304\":\"0\",\"ft200107\":\"05.02.0001,05.02.0019\",\"ft200305\":\"0\",\"ft200109\":\"0\",\"ft200101\":\"90231\",\"ft200102\":\"47881\",\"ft500203\":\"1_null\",\"ft500201\":\"90231_null\",\"f8807\":\"1\",\"ft110014\":\"2\",\"ft300201\":\"453998\",\"ft300202\":\"8\",\"fd_1107_01\":\"1\",\"advertId\":\"90231\",\"fd_1502_04\":\"0.0\",\"fd_1506_08\":\"0.0010417\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.039137\",\"fd_1502_03\":\"0.0\",\"time\":\"20231130133412\"}";
        String str49 = "{\"orderId\":\"taw-12488735287430595\",\"chargeType\":\"2\",\"fd_1108_01\":\"0\",\"fd_1120\":\"35860\",\"backTimeConsume\":\"{\\\"0\\\":518904.0,\\\"19\\\":429653.0}\",\"ft100204\":\"pcdm10\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID11\",\"fd_1110\":\"1701322047\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.7598668\",\"ft100207\":\"2019\",\"ft100206\":\"4\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.8165356\",\"ft100205\":\"oppo\",\"fd_1116\":\"0\",\"ft500103\":\"1_3\",\"ft100209\":\"DYN\",\"ft500101\":\"90122_3\",\"fd_1105_01\":\"1\",\"linkageSubtype\":\"0-3,2-6,3-6,3-6,4-6,4-6,4-6,6-6\",\"ft300101\":\"95678\",\"ft300301\":\"35860\",\"consumerId\":\"37680220755\",\"fd_1501\":\"88903\",\"ft300904\":\"3\",\"fd_1502\":\"88903\",\"fd_1105\":\"1\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"ft300901\":\"3\",\"fd_1503\":\"88903\",\"ft300902\":\"34\",\"fd_1504\":\"89920\",\"ft300903\":\"3412\",\"ft300302\":\"1\",\"ft300104\":\"39\",\"ft300303\":\"1\",\"ft300105\":\"831\",\"fd_1507\":\"9\",\"ft300304\":\"35860\",\"ft300106\":\"981\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"ft300107\":\"674\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0,3]\",\"ft301002\":\"4\",\"ft300113\":\"7\",\"ft300114\":\"1044\",\"ft301001\":\"13\",\"ft200103\":\"07.26.0234\",\"ft200301\":\"0\",\"ft200104\":\"1\",\"ft200302\":\"119\",\"ft200105\":\"02.14.0001\",\"ft200303\":\"0\",\"ft200106\":\"161534\",\"ft200304\":\"0\",\"ft200107\":\"05.03.0013,05.02.0001,05.02.0019\",\"ft200305\":\"0\",\"ft200109\":\"0\",\"ft200101\":\"90122\",\"ft200102\":\"47761\",\"ft500203\":\"1_null\",\"ft500201\":\"90122_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft300201\":\"456423\",\"ft300202\":\"12\",\"fd_1107_01\":\"0\",\"advertId\":\"90122\",\"abst\":\"[0,3]\",\"fd_1502_04\":\"0.0186516\",\"fd_1506_08\":\"0.0142727\",\"fd_1118_01\":\"0\",\"ft200111\":\"59\",\"fd_1506_07\":\"0.0912151\",\"fd_1502_03\":\"0.2030262\",\"time\":\"20231130132734\"}";
        String str50 = "{\"orderId\":\"taw-12488848556960180\",\"chargeType\":\"2\",\"fd_1108_01\":\"0\",\"fd_1120\":\"36010\",\"backTimeConsume\":\"{\\\"0\\\":180.95,\\\"11\\\":153729.54,\\\"15\\\":14718.22,\\\"19\\\":151.01,\\\"9\\\":291756.19}\",\"ft100204\":\"v1938ct\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID10\",\"fd_1110\":\"1701322879\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.7103523\",\"ft100207\":\"2019\",\"ft100206\":\"5\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.7997449\",\"ft100205\":\"vivo\",\"fd_1116\":\"0\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"ft500101\":\"89533_0\",\"fd_1105_01\":\"1\",\"linkageSubtype\":\"0-11\",\"ft300101\":\"95917\",\"ft300301\":\"36010\",\"consumerId\":\"37680279732\",\"fd_1501\":\"89533\",\"ft300904\":\"3\",\"fd_1502\":\"89533\",\"fd_1105\":\"1\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"ft300901\":\"4\",\"fd_1503\":\"89533\",\"ft300902\":\"41\",\"fd_1504\":\"87025\",\"ft300903\":\"4107\",\"ft300302\":\"1\",\"ft300104\":\"40\",\"ft300303\":\"1\",\"ft300105\":\"388\",\"fd_1507\":\"9\",\"ft300304\":\"36010\",\"ft300106\":\"981\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"ft300107\":\"674\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"4\",\"ft300113\":\"7\",\"ft300114\":\"1044\",\"ft301001\":\"13\",\"ft200103\":\"07.23.0008\",\"ft200301\":\"0\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"161019\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft200101\":\"89533\",\"ft200102\":\"47174\",\"ft500203\":\"9_null\",\"ft500201\":\"89533_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft300201\":\"457866\",\"ft300202\":\"12\",\"fd_1107_01\":\"0\",\"advertId\":\"89533\",\"abst\":\"[0]\",\"fd_1502_04\":\"1.365E-4\",\"fd_1506_08\":\"8.46E-5\",\"fd_1118_01\":\"0\",\"ft200111\":\"2\",\"fd_1506_07\":\"0.2424926\",\"fd_1502_03\":\"0.2915284\",\"time\":\"20231130134127\"}";
        String str51 = "{\"orderId\":\"taw-12488856216460036\",\"chargeType\":\"2\",\"backTimeConsume\":\"{\\\"0\\\":170.11,\\\"11\\\":311936.17,\\\"15\\\":6808.79,\\\"19\\\":55.19,\\\"9\\\":430744.68}\",\"ft100204\":\"v2270a\",\"ft100203\":\"ANDROID13\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.7012047\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.7566251\",\"ft100205\":\"unknown\",\"ft500103\":\"9_0\",\"ft100209\":\"MOB\",\"ft500101\":\"89588_0\",\"linkageSubtype\":\"0-11\",\"ft300101\":\"95851\",\"ft300301\":\"36010\",\"consumerId\":\"37680284708\",\"fd_1501\":\"89533\",\"ft300904\":\"4\",\"fd_1502\":\"89533\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"ft300901\":\"1\",\"fd_1503\":\"89533\",\"ft300902\":\"14\",\"fd_1504\":\"89920\",\"ft300903\":\"1402\",\"ft300302\":\"1\",\"ft300104\":\"40\",\"ft300303\":\"1\",\"ft300105\":\"388\",\"fd_1507\":\"9\",\"ft300304\":\"36010\",\"ft300106\":\"981\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"ft300107\":\"674\",\"ft301003\":\"30\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"4\",\"ft300113\":\"1\",\"ft300114\":\"1044\",\"ft301001\":\"13\",\"ft200103\":\"07.23.0008\",\"ft200301\":\"0\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"159858\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft200101\":\"89588\",\"ft200102\":\"44445\",\"ft500203\":\"9_null\",\"ft500201\":\"89588_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft300201\":\"457500\",\"ft300202\":\"12\",\"advertId\":\"89588\",\"abst\":\"[0]\",\"fd_1502_04\":\"6.09E-5\",\"fd_1506_08\":\"1.65E-5\",\"ft200111\":\"2\",\"fd_1506_07\":\"0.230614\",\"fd_1502_03\":\"0.2839893\",\"time\":\"20231130134249\"}";
        String str52 = "{\"orderId\":\"taw-12492784896380300\",\"chargeType\":\"2\",\"ft100204\":\"ala-an70\",\"ft100203\":\"ANDROID12\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.6689955\",\"ft100207\":\"2021\",\"ft100206\":\"5\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.6881801\",\"ft100205\":\"honor\",\"ft500103\":\"9_0\",\"ft100209\":\"MOB\",\"ft500101\":\"88306_0\",\"linkageSubtype\":\"0-11\",\"ft300101\":\"76090\",\"ft300301\":\"35073\",\"consumerId\":\"37695394092\",\"fd_1501\":\"89533\",\"ft300904\":\"2\",\"fd_1502\":\"89533\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"ft300901\":\"3\",\"fd_1503\":\"89533\",\"ft300902\":\"34\",\"fd_1504\":\"88327\",\"ft300903\":\"3401\",\"ft300302\":\"1\",\"ft300104\":\"39\",\"ft300303\":\"1\",\"ft300105\":\"634\",\"fd_1507\":\"9\",\"ft300304\":\"35073\",\"ft300106\":\"978\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"ft300107\":\"693\",\"ft301003\":\"3\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"7\",\"ft300113\":\"5\",\"ft301001\":\"0\",\"ft200103\":\"07.23.0008\",\"ft200301\":\"0\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"155922\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft200101\":\"88306\",\"ft200102\":\"44445\",\"ft500203\":\"9_null\",\"ft500201\":\"88306_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft300201\":\"421439\",\"ft300202\":\"1\",\"advertId\":\"88306\",\"abst\":\"[0]\",\"fd_1502_04\":\"2.029E-4\",\"fd_1506_08\":\"2.07E-5\",\"ft200111\":\"2\",\"fd_1506_07\":\"0.0744\",\"fd_1502_03\":\"0.0808874\",\"time\":\"20231203000200\"}";
        String str53 = "{\"orderId\":\"taw-12492809137070871\",\"fd_1207_01\":\"6\",\"fd_1708_01\":\"4\",\"chargeType\":\"2\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"fd_1505_06\":\"0.8565245\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.0\",\"ft500103\":\"10_3\",\"ft100209\":\"DYN\",\"ft500101\":\"89491_3\",\"linkageSubtype\":\"0-6,3-6,4-6,6-6\",\"ft300101\":\"95867\",\"ft300301\":\"36084\",\"fd_1705_01\":\"6\",\"fd_1210_01\":\"0\",\"consumerId\":\"37695489895\",\"fd_1208_01\":\"5\",\"fd_1709_01\":\"0\",\"fd_1501\":\"89848\",\"ft300904\":\"1\",\"fd_1502\":\"89848\",\"fd_1505\":\"10\",\"fd_1506\":\"10\",\"ft300901\":\"1\",\"fd_1503\":\"90174\",\"ft300902\":\"12\",\"ft300903\":\"12\",\"ft300104\":\"27\",\"fd_1707\":\"5\",\"ft300105\":\"268\",\"fd_1708\":\"4\",\"fd_1507\":\"10\",\"ft300106\":\"985\",\"fd_1705\":\"8\",\"ft300107\":\"671\",\"fd_1706\":\"5\",\"ft301003\":\"3\",\"advertBackSubTypes\":\"[0,3]\",\"ft301002\":\"7\",\"ft300114\":\"1045\",\"fd_1209_01\":\"0\",\"ft301001\":\"0\",\"ft200103\":\"07.10.0454\",\"ft200301\":\"0\",\"ft200104\":\"10\",\"ft200302\":\"0\",\"ft200105\":\"02.22.0001\",\"ft200303\":\"0\",\"ft200106\":\"159535\",\"ft200304\":\"0\",\"ft200107\":\"05.02.0018\",\"ft200305\":\"0\",\"ft200109\":\"0\",\"fd_1214\":\"49338,169970\",\"ft200101\":\"89491\",\"fd_1205_01\":\"7\",\"ft200102\":\"47488\",\"ft500203\":\"10_null\",\"ft500201\":\"89491_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft300201\":\"458222\",\"ft300202\":\"3\",\"fd_1707_01\":\"5\",\"advertId\":\"89491\",\"abst\":\"[0,3]\",\"fd_1506_07\":\"0.7707318\",\"fd_1205\":\"17\",\"fd_1502_03\":\"0.0\",\"fd_1207\":\"6\",\"fd_1710_01\":\"0\",\"fd_1206\":\"6\",\"fd_1208\":\"5\",\"time\":\"20231203002715\"}";
        String str54 = "{\"orderId\":\"taw-12509025002090682\",\"fd_1108_01\":\"0\",\"ft100204\":\"els-an00\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID12\",\"fd_1011_01\":\"1\",\"ft100202\":\"3\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"ft100207\":\"2020\",\"ft100206\":\"6\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.0\",\"ft100205\":\"huawei\",\"ft500103\":\"10_3\",\"ft100209\":\"MOB\",\"fd_1318\":\"30_1_9_1,180_1_9_1\",\"fd_1807_01\":\"6\",\"ft500101\":\"89699_3\",\"fd_1105_01\":\"6\",\"ft300101\":\"95790\",\"fd_1810_01\":\"0\",\"fd_1208_01\":\"0\",\"fd_1709_01\":\"0\",\"ft300904\":\"2\",\"fd_1306\":\"16\",\"ft300901\":\"3\",\"fd_1305\":\"40\",\"ft300902\":\"36\",\"fd_1308\":\"2\",\"ft300903\":\"3601\",\"fd_1307\":\"11\",\"ft300104\":\"33\",\"fd_1707\":\"5\",\"ft300105\":\"346\",\"fd_1708\":\"0\",\"fd_1309\":\"9\",\"ft300106\":\"987\",\"fd_1705\":\"13\",\"ft300107\":\"671\",\"fd_1706\":\"7\",\"ft301003\":\"14\",\"advertBackSubTypes\":\"[0,3]\",\"ft301002\":\"4\",\"fd_1809_01\":\"1\",\"ft600210\":\"0\",\"fd_1209_01\":\"0\",\"ft301001\":\"18\",\"ft200103\":\"07.10.0454\",\"ft200104\":\"10\",\"ft200105\":\"02.22.0001\",\"ft200106\":\"160187\",\"ft200107\":\"05.03.0001,05.02.0018,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"2\",\"fd_1308_02\":\"2\",\"ft200101\":\"89699\",\"ft200102\":\"47488\",\"ft600201\":\"51575894\",\"ft300201\":\"457767\",\"ft300202\":\"3\",\"fd_1107_01\":\"4\",\"fd_1707_01\":\"5\",\"advertId\":\"89699\",\"abst\":\"[0,3]\",\"fd_1506_08\":\"0.0023475\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.962228\",\"fd_1205\":\"16\",\"ft600209\":\"1501\",\"fd_1207\":\"6\",\"fd_1710_01\":\"0\",\"fd_1206\":\"9\",\"fd_1208\":\"0\",\"fd_1305_01\":\"8\",\"fd_1207_01\":\"6\",\"fd_1708_01\":\"0\",\"chargeType\":\"2\",\"fd_1120\":\"34919,33758\",\"fd_1111\":\"10\",\"fd_1110\":\"1702548782\",\"fd_1113\":\"33758\",\"fd_1112\":\"1702549014\",\"fd_1505_06\":\"0.7231322\",\"fd_1114\":\"840050443956310016\",\"fd_1116\":\"0\",\"linkageSubtype\":\"0-6,3-6,4-6,6-6\",\"ft300301\":\"33758\",\"fd_1705_01\":\"7\",\"fd_1210_01\":\"0\",\"consumerId\":\"37671143082\",\"fd_1307_01\":\"7\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1106\":\"6\",\"fd_1105\":\"6\",\"fd_1505\":\"16\",\"ft300306\":\"2\",\"fd_1506\":\"16\",\"fd_1107\":\"4\",\"fd_1503\":\"89986\",\"fd_1504\":\"89778\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"33758\",\"fd_1808_01\":\"1\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"fd_1106_02\":\"6\",\"ft300113\":\"4\",\"ft300114\":\"1047\",\"ft6002031\":\"9200195318\",\"ft200301\":\"0\",\"ft200302\":\"0\",\"ft200303\":\"0\",\"ft200304\":\"0\",\"ft200305\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"7\",\"ft500203\":\"10_null\",\"ft500201\":\"89699_null\",\"f8807\":\"1\",\"fd_1805_01\":\"8\",\"ft110014\":\"3\",\"ft6002041\":\"705812916267\",\"fd_1808\":\"1\",\"fd_1809\":\"9\",\"fd_1502_04\":\"0.0\",\"fd_1001\":\"010101\",\"fd_1003\":\"010501\",\"fd_1309_01\":\"1\",\"fd_1002\":\"01020301\",\"fd_1005\":\"1,17,18,10,21\",\"fd_1007\":\"100604,100802,101002,100202,101502\",\"fd_1502_03\":\"0.0\",\"fd_1006\":\"1008,1006,1015,1002,1010\",\"fd_1008\":\"385,441,202,378,521,799,193,391,393,184,790,263\",\"time\":\"20231214181819\",\"fd_1806\":\"11\",\"fd_1807\":\"7\",\"fd_1805\":\"31\"}";
        String str55 = "{\"orderId\":\"taw-12509034135720708\",\"backTimeConsume\":\"{\\\"0\\\":8.76,\\\"3\\\":51.93,\\\"19\\\":47.27,\\\"10\\\":20368.75}\",\"ft100204\":\"22021211rc\",\"ft100203\":\"ANDROID13\",\"fd_1011_01\":\"-1\",\"ft100202\":\"3\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.6257909\",\"ft100205\":\"redmi\",\"ft500103\":\"10_3\",\"ft100209\":\"MOB\",\"ft500101\":\"90567_3\",\"ft300101\":\"90800\",\"ft300904\":\"1\",\"fd_1302\":\"0\",\"fd_1301\":\"2\",\"fd_1304\":\"0\",\"fd_1303\":\"0\",\"fd_1306\":\"2\",\"ft300901\":\"3\",\"fd_1305\":\"4\",\"ft300902\":\"32\",\"fd_1308\":\"2\",\"ft300903\":\"3201\",\"fd_1307\":\"2\",\"ft300104\":\"33\",\"ft300105\":\"346\",\"ft300106\":\"986\",\"ft300107\":\"671\",\"ft301003\":\"14\",\"advertBackSubTypes\":\"[0,3]\",\"ft301002\":\"4\",\"ft301001\":\"18\",\"ft200103\":\"07.10.0500\",\"ft200104\":\"10\",\"ft200105\":\"02.22.0001\",\"ft200106\":\"162668\",\"ft200107\":\"05.03.0013,05.02.0018\",\"ft200109\":\"0\",\"fd_1308_01\":\"2\",\"fd_1308_02\":\"2\",\"ft200101\":\"90567\",\"ft200102\":\"47926\",\"ft600201\":\"41986354\",\"ft300201\":\"425625\",\"ft300202\":\"3\",\"advertId\":\"90567\",\"abst\":\"[0,3]\",\"fd_1506_08\":\"0.0035942\",\"fd_1506_07\":\"1.005081\",\"ft600209\":\"545\",\"fd_1305_01\":\"4\",\"chargeType\":\"2\",\"fd_1505_06\":\"0.6551123\",\"linkageSubtype\":\"0-6,3-6,4-6,6-6\",\"ft300301\":\"34919\",\"consumerId\":\"37752384196\",\"fd_1307_01\":\"2\",\"fd_1501\":\"89588\",\"fd_1502\":\"89588\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1503\":\"89588\",\"fd_1504\":\"86991\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"34919\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"ft300113\":\"4\",\"ft300114\":\"1047\",\"ft6002031\":\"8519596851\",\"ft200301\":\"0\",\"ft200302\":\"0\",\"ft200303\":\"0\",\"ft200304\":\"0\",\"ft200305\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"ft500203\":\"10_null\",\"ft500201\":\"90567_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft6002041\":\"625741714973\",\"fd_1502_04\":\"0.0063844\",\"fd_1001\":\"010101\",\"fd_1003\":\"010502\",\"fd_1309_01\":\"0\",\"fd_1002\":\"01020402\",\"fd_1005\":\"22,1,13,2,15,17,18,7,19,10\",\"fd_1007\":\"100802,100803,101001,101002,100102,100202,101502\",\"fd_1502_03\":\"1.5669292\",\"fd_1006\":\"1008,1015,1002,1001,1010\",\"fd_1008\":\"89,491,184,790,386,397,201,399,487,521,522,337,910,91,92,528,518,609,829\",\"time\":\"20231214182452\"}";
        String str56 = "{\"orderId\":\"taw-12512667140290580\",\"backTimeConsume\":\"{\\\"3\\\":353.64,\\\"19\\\":19.79}\",\"ft100204\":\"phs110\",\"ft100203\":\"ANDROID13\",\"fd_1011_01\":\"-1\",\"ft100202\":\"2\",\"ft100201\":\"1\",\"fd_1310\":\"1\",\"ft100208\":\"android\",\"fd_1710\":\"1\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.7166932\",\"ft100205\":\"unknown\",\"ft500103\":\"1_3\",\"ft100209\":\"IDC\",\"fd_1318\":\"30_2_1_1,180_2_1_1\",\"fd_1807_01\":\"1\",\"ft500101\":\"88126_3\",\"ft300101\":\"83174\",\"fd_1810_01\":\"1\",\"fd_1208_01\":\"1\",\"fd_1709_01\":\"0\",\"ft300904\":\"1\",\"fd_1302\":\"0\",\"fd_1301\":\"9\",\"fd_1304\":\"0\",\"fd_1303\":\"0\",\"fd_1306\":\"1\",\"ft300901\":\"5\",\"fd_1305\":\"3\",\"ft300902\":\"44\",\"fd_1308\":\"1\",\"ft300903\":\"4419\",\"fd_1307\":\"1\",\"ft300104\":\"27\",\"fd_1707\":\"1\",\"ft300105\":\"269\",\"fd_1708\":\"1\",\"ft300106\":\"985\",\"fd_1705\":\"2\",\"ft300107\":\"671\",\"fd_1706\":\"1\",\"ft301003\":\"17\",\"advertBackSubTypes\":\"[3]\",\"ft301002\":\"7\",\"fd_1809_01\":\"0\",\"fd_1209_01\":\"0\",\"ft301001\":\"0\",\"ft200103\":\"07.26.0175\",\"ft200104\":\"1\",\"ft200105\":\"02.14.0001\",\"ft200106\":\"160954\",\"ft200107\":\"05.03.0012,05.02.0001,05.02.0019\",\"ft200109\":\"0\",\"fd_1210\":\"1\",\"fd_1308_01\":\"1\",\"fd_1308_02\":\"1\",\"ft200101\":\"88126\",\"ft200102\":\"45643\",\"ft300201\":\"457726\",\"ft300202\":\"3\",\"fd_1707_01\":\"1\",\"advertId\":\"88126\",\"abst\":\"[3]\",\"fd_1506_08\":\"0.0053904\",\"ft200111\":\"50\",\"fd_1506_07\":\"0.0236307\",\"fd_1205\":\"2\",\"fd_1207\":\"1\",\"fd_1710_01\":\"1\",\"fd_1206\":\"1\",\"fd_1208\":\"1\",\"fd_1305_01\":\"3\",\"fd_1207_01\":\"1\",\"fd_1708_01\":\"1\",\"chargeType\":\"2\",\"fd_1505_06\":\"0.760284\",\"linkageSubtype\":\"0-3,2-6,3-6,3-6,4-6,4-6,4-6,6-6\",\"ft300301\":\"35078\",\"fd_1705_01\":\"2\",\"fd_1210_01\":\"1\",\"consumerId\":\"36759719492\",\"fd_1307_01\":\"1\",\"fd_1501\":\"86265\",\"fd_1502\":\"86265\",\"fd_1505\":\"16\",\"ft300306\":\"2\",\"fd_1506\":\"16\",\"fd_1503\":\"89791\",\"fd_1504\":\"89980\",\"fd_1507\":\"10\",\"ft300304\":\"35078\",\"fd_1808_01\":\"1\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"ft300113\":\"4\",\"ft300114\":\"1043\",\"ft200301\":\"0\",\"ft200302\":\"0\",\"ft200303\":\"0\",\"ft200304\":\"0\",\"ft200305\":\"0\",\"fd_1310_01\":\"1\",\"fd_1310_02\":\"1\",\"fd_1810\":\"1\",\"fd_1205_01\":\"2\",\"ft500203\":\"1_null\",\"ft500201\":\"88126_null\",\"f8807\":\"1\",\"fd_1805_01\":\"2\",\"ft110014\":\"1\",\"fd_1808\":\"1\",\"fd_1502_04\":\"0.0073785\",\"fd_1001\":\"010102\",\"fd_1003\":\"010501\",\"fd_1309_01\":\"0\",\"fd_1002\":\"010202\",\"fd_1005\":\"1,34,2,16,17,7,19,8,10,21\",\"fd_1007\":\"100604,100802,101002,100102,100202,101502,100502\",\"fd_1502_03\":\"0.0013021\",\"fd_1006\":\"1008,1006,1005,1015,1002,1001,1010\",\"fd_1008\":\"385,202,378,192,184\",\"time\":\"20231217000519\",\"fd_1806\":\"1\",\"fd_1807\":\"1\",\"fd_1805\":\"2\"}";
        String str57 = "{\"fd_1108_02\":\"2\",\"orderId\":\"taw-12512772995160543\",\"fd_1108_01\":\"2\",\"backTimeConsume\":\"{\\\"0\\\":7.85,\\\"3\\\":52.35,\\\"19\\\":39.45}\",\"ft100204\":\"pemm20\",\"fd_1117_01\":\"2\",\"ft100203\":\"ANDROID13\",\"fd_1011_01\":\"1\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"fd_1310\":\"15\",\"ft100208\":\"android\",\"ft100207\":\"2021\",\"ft100206\":\"3\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.0\",\"ft100205\":\"oppo\",\"ft500103\":\"10_3\",\"ft100209\":\"MOB\",\"fd_1318\":\"180_1_15_1,180_2_15_1\",\"fd_1807_01\":\"4\",\"ft500101\":\"90626_3\",\"fd_1105_01\":\"2\",\"ft300101\":\"90446\",\"fd_1810_01\":\"0\",\"fd_1208_01\":\"1\",\"fd_1709_01\":\"0\",\"ft300904\":\"2\",\"fd_1306\":\"7\",\"ft300901\":\"3\",\"fd_1305\":\"7\",\"ft300902\":\"35\",\"fd_1308\":\"5\",\"ft300903\":\"3501\",\"fd_1307\":\"7\",\"ft300104\":\"27\",\"fd_1707\":\"1\",\"ft300105\":\"267\",\"fd_1708\":\"1\",\"fd_1309\":\"15\",\"ft300106\":\"987\",\"fd_1705\":\"1\",\"ft300107\":\"696\",\"fd_1706\":\"1\",\"ft301003\":\"17\",\"advertBackSubTypes\":\"[0,3]\",\"ft301002\":\"7\",\"fd_1809_01\":\"0\",\"fd_1209_01\":\"0\",\"ft301001\":\"4\",\"ft200103\":\"07.10.0454\",\"ft200104\":\"10\",\"ft200105\":\"02.22.0001\",\"ft200106\":\"162806\",\"ft200107\":\"05.03.0001,05.02.0018,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"5\",\"fd_1308_02\":\"5\",\"ft200101\":\"90626\",\"ft200102\":\"47488\",\"ft300201\":\"456686\",\"ft300202\":\"3\",\"fd_1107_01\":\"2\",\"fd_1707_01\":\"1\",\"advertId\":\"90626\",\"abst\":\"[0,3]\",\"fd_1506_08\":\"0.007123\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"1.2421438\",\"fd_1205\":\"1\",\"fd_1207\":\"1\",\"fd_1710_01\":\"0\",\"fd_1206\":\"1\",\"fd_1208\":\"1\",\"fd_1305_01\":\"6\",\"fd_1207_01\":\"1\",\"fd_1708_01\":\"1\",\"chargeType\":\"2\",\"fd_1120\":\"35249\",\"fd_1111\":\"10\",\"fd_1110\":\"1702757315\",\"fd_1113\":\"35249\",\"fd_1112\":\"1702757634\",\"fd_1115\":\"840925463532318720\",\"fd_1505_06\":\"0.7752597\",\"fd_1114\":\"840925463532318720\",\"fd_1117\":\"10\",\"fd_1116\":\"1\",\"linkageSubtype\":\"0-6,3-6,4-6,6-6\",\"ft300301\":\"35249\",\"fd_1705_01\":\"1\",\"ft6002021\":\"986828\",\"fd_1210_01\":\"0\",\"consumerId\":\"37529291295\",\"fd_1307_01\":\"6\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1106\":\"2\",\"fd_1105\":\"2\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1108\":\"2\",\"fd_1506\":\"9\",\"fd_1107\":\"2\",\"fd_1503\":\"90567\",\"fd_1504\":\"90567\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"35249\",\"fd_1808_01\":\"3\",\"fd_1508\":\"10\",\"ft300305\":\"2\",\"fd_1106_02\":\"2\",\"ft300113\":\"4\",\"ft300114\":\"1057\",\"ft6002031\":\"1000221790\",\"ft200301\":\"0\",\"ft200302\":\"0\",\"ft200303\":\"0\",\"ft200304\":\"0\",\"ft200305\":\"0\",\"fd_1310_01\":\"1\",\"fd_1310_02\":\"1\",\"fd_1205_01\":\"1\",\"ft500203\":\"10_null\",\"ft500201\":\"90626_null\",\"f8807\":\"1\",\"fd_1805_01\":\"5\",\"ft110014\":\"3\",\"ft6002041\":\"208275318\",\"fd_1808\":\"3\",\"fd_1502_04\":\"0.0\",\"fd_1309_01\":\"1\",\"fd_1005\":\"1,2,14,15,63760,16,17,7,8,10,21,5925\",\"fd_1007\":\"100604,100802,101002,100102,100202,100301,100501,101502,100502\",\"fd_1502_03\":\"0.0\",\"fd_1006\":\"1008,1006,1005,1015,1003,1002,1001,1010\",\"time\":\"20231217041605\",\"fd_1806\":\"4\",\"fd_1807\":\"4\",\"fd_1805\":\"5\"}";
        String str58 = "{\"orderId\":\"taw-12512770907250643\",\"chargeType\":\"2\",\"backTimeConsume\":\"{\\\"0\\\":149.99,\\\"11\\\":150046.65,\\\"15\\\":13820.29,\\\"19\\\":328.4,\\\"9\\\":335157.79}\",\"ft100204\":\"lsa-an00\",\"ft100203\":\"ANDROID12\",\"fd_1011_01\":\"-1\",\"ft100202\":\"4\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.5589674\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.5401168\",\"ft100205\":\"honor\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"ft500101\":\"88903_0\",\"linkageSubtype\":\"0-11\",\"ft300101\":\"95983\",\"ft300301\":\"36076\",\"consumerId\":\"37764184707\",\"fd_1307_01\":\"0\",\"fd_1501\":\"88903\",\"ft300904\":\"3\",\"fd_1502\":\"88903\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1306\":\"3\",\"fd_1506\":\"9\",\"ft300901\":\"5\",\"fd_1305\":\"5\",\"fd_1503\":\"90567\",\"ft300902\":\"46\",\"fd_1308\":\"0\",\"fd_1504\":\"88126\",\"ft300903\":\"4601\",\"fd_1307\":\"0\",\"ft300302\":\"1\",\"ft300104\":\"33\",\"ft300303\":\"1\",\"ft300105\":\"347\",\"fd_1507\":\"10\",\"ft300304\":\"36076\",\"ft300106\":\"987\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"ft300107\":\"671\",\"ft301003\":\"17\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"7\",\"ft300113\":\"4\",\"ft300114\":\"1047\",\"ft301001\":\"4\",\"ft200103\":\"07.23.0008\",\"ft200301\":\"0\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"161015\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1308_01\":\"0\",\"fd_1308_02\":\"0\",\"ft200101\":\"88903\",\"ft200102\":\"47174\",\"ft500203\":\"9_null\",\"ft500201\":\"88903_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft300201\":\"458148\",\"ft300202\":\"3\",\"advertId\":\"88903\",\"abst\":\"[0]\",\"fd_1502_04\":\"1.169E-4\",\"fd_1506_08\":\"8.77E-5\",\"fd_1309_01\":\"0\",\"ft200111\":\"2\",\"fd_1506_07\":\"0.0672957\",\"fd_1502_03\":\"0.0667498\",\"time\":\"20231217041650\",\"fd_1305_01\":\"5\"}";
        String str59 = "{\"orderId\":\"taw-12566283463241000\",\"backTimeConsume\":\"{\\\"0\\\":183.96,\\\"11\\\":208043.82,\\\"15\\\":20062.6,\\\"19\\\":876.04,\\\"9\\\":349431.95}\",\"ft100204\":\"rmx3031\",\"ft100203\":\"ANDROID12\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2021\",\"ft100206\":\"4\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.3935646\",\"ft100205\":\"realme\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"fd_1318\":\"180_1_10_1\",\"fd_1807_01\":\"0\",\"ft500101\":\"88903_0\",\"ft300101\":\"89966\",\"fd_1810_01\":\"0\",\"ft300904\":\"4\",\"fd_1306\":\"6\",\"ft300901\":\"3\",\"ft300109\":\"com.cloudledger.speed\",\"fd_1305\":\"24\",\"ft300902\":\"36\",\"fd_1308\":\"5\",\"ft300903\":\"3602\",\"fd_1307\":\"5\",\"ft300104\":\"27\",\"ft300105\":\"268\",\"fd_1309\":\"10\",\"ft300106\":\"985\",\"ft300107\":\"671\",\"ft301003\":\"18\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"4\",\"fd_1809_01\":\"0\",\"ft301001\":\"12\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"161015\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"5\",\"fd_1308_02\":\"5\",\"ft200101\":\"88903\",\"ft200102\":\"47174\",\"fd_1602_04\":\"3.446E-4\",\"fd_1602_03\":\"0.1436941\",\"ft600201\":\"11065952\",\"ft300201\":\"420877\",\"ft300202\":\"3\",\"advertId\":\"88903\",\"abst\":\"[0]\",\"fd_1506_08\":\"1.45E-5\",\"ft200111\":\"2\",\"fd_1506_07\":\"0.1194468\",\"ft600209\":\"5\",\"fd_1305_01\":\"8\",\"chargeType\":\"2\",\"fd_1505_06\":\"0.3709582\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"33341\",\"ft6002021\":\"3xxrqnm5zuqjsqs\",\"consumerId\":\"37484060648\",\"fd_1307_01\":\"5\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1503\":\"88903\",\"fd_1504\":\"89437\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"33341\",\"fd_1808_01\":\"0\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"ft300111\":\"12\",\"ft300113\":\"4\",\"ft300114\":\"1045\",\"ft6002031\":\"2851952754\",\"ft300110\":\"3\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"ft500203\":\"9_null\",\"ft500201\":\"88903_null\",\"f8807\":\"1\",\"fd_1805_01\":\"1\",\"ft110014\":\"1\",\"ft6002041\":\"33759223494\",\"fd_1808\":\"0\",\"fd_1502_04\":\"2.46E-5\",\"fd_1001\":\"010101\",\"fd_1003\":\"010501\",\"fd_1309_01\":\"1\",\"fd_1002\":\"010202\",\"fd_1005\":\"1,34,2,14,5,17,18,43640,83083,10,21\",\"fd_1007\":\"100604,100802,101002,100102,100202,100301,101302,101502,101305\",\"fd_1502_03\":\"0.1276316\",\"fd_1006\":\"1008,1006,1015,1003,1002,1013,1001,1010\",\"fd_1008\":\"399,521,248,748,681\",\"fd_1601_02\":\"0.279745\",\"time\":\"20240118120043\",\"fd_1806\":\"0\",\"fd_1807\":\"0\",\"fd_1805\":\"1\"}";
        String str60 = "{\"orderId\":\"taw-12566303876830484\",\"chargeType\":\"2\",\"backTimeConsume\":\"{\\\"0\\\":183.96,\\\"11\\\":208043.82,\\\"15\\\":20062.6,\\\"19\\\":876.04,\\\"9\\\":349431.95}\",\"ft100204\":\"jny-al10\",\"ft100203\":\"ANDROID10\",\"fd_1011_01\":\"-1\",\"ft100202\":\"3\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.841247\",\"ft100207\":\"2019\",\"ft100206\":\"4\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.880817\",\"ft100205\":\"huawei\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"ft500101\":\"88903_0\",\"linkageSubtype\":\"0-11\",\"ft300101\":\"95984\",\"ft300301\":\"35940\",\"consumerId\":\"37925531108\",\"fd_1501\":\"88903\",\"ft300904\":\"4\",\"fd_1502\":\"88903\",\"fd_1505\":\"16\",\"ft300306\":\"2\",\"fd_1506\":\"16\",\"ft300901\":\"1\",\"fd_1503\":\"90676\",\"ft300902\":\"14\",\"fd_1504\":\"89437\",\"ft300903\":\"1408\",\"ft300302\":\"1\",\"ft300104\":\"33\",\"ft300303\":\"1\",\"ft300105\":\"346\",\"fd_1507\":\"10\",\"ft300304\":\"35940\",\"ft300106\":\"987\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"ft300107\":\"671\",\"ft301003\":\"18\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"4\",\"ft300113\":\"4\",\"ft300114\":\"1047\",\"ft301001\":\"12\",\"ft200103\":\"07.23.0008\",\"ft200301\":\"0\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"161015\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft200101\":\"88903\",\"ft200102\":\"47174\",\"ft500203\":\"9_null\",\"ft500201\":\"88903_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft300201\":\"458094\",\"ft300202\":\"3\",\"advertId\":\"88903\",\"abst\":\"[0]\",\"fd_1502_04\":\"4.928E-4\",\"fd_1001\":\"010102\",\"fd_1506_08\":\"3.196E-4\",\"fd_1003\":\"010502\",\"fd_1002\":\"01020301\",\"ft200111\":\"2\",\"fd_1506_07\":\"0.0546501\",\"fd_1502_03\":\"0.0540408\",\"time\":\"20240118121344\"}";
        String str61 = "{\"orderId\":\"taw-12566311329710831\",\"fd_1207_01\":\"0\",\"chargeType\":\"2\",\"backTimeConsume\":\"{\\\"0\\\":183.96,\\\"11\\\":208043.82,\\\"15\\\":20062.6,\\\"19\\\":876.04,\\\"9\\\":349431.95}\",\"ft100204\":\"redmi note 8\",\"ft100203\":\"ANDROID9\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"fd_1505_06\":\"0.7926864\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.8156666\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"ft500101\":\"88903_0\",\"linkageSubtype\":\"0-11\",\"ft300101\":\"94664\",\"ft300301\":\"35940\",\"fd_1210_01\":\"0\",\"consumerId\":\"37750345535\",\"fd_1208_01\":\"0\",\"fd_1501\":\"88903\",\"ft300904\":\"4\",\"fd_1502\":\"88903\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"ft300901\":\"6\",\"fd_1503\":\"90910\",\"ft300902\":\"51\",\"fd_1504\":\"89920\",\"ft300903\":\"5119\",\"ft300302\":\"1\",\"ft300104\":\"38\",\"ft300303\":\"1\",\"ft300105\":\"369\",\"fd_1507\":\"26\",\"ft300304\":\"35940\",\"ft300106\":\"985\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"ft300107\":\"671\",\"ft301003\":\"18\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"4\",\"ft300113\":\"4\",\"ft300114\":\"1047\",\"fd_1209_01\":\"0\",\"ft301001\":\"12\",\"ft200103\":\"07.23.0008\",\"ft200301\":\"0\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"161015\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft200101\":\"88903\",\"fd_1205_01\":\"1\",\"ft200102\":\"47174\",\"ft500203\":\"9_null\",\"ft500201\":\"88903_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft300201\":\"456964\",\"ft300202\":\"3\",\"advertId\":\"88903\",\"abst\":\"[0]\",\"fd_1502_04\":\"4.7E-6\",\"fd_1506_08\":\"3.3E-6\",\"ft200111\":\"2\",\"fd_1506_07\":\"0.0670162\",\"fd_1205\":\"1\",\"fd_1502_03\":\"0.0695748\",\"fd_1207\":\"0\",\"fd_1206\":\"3\",\"fd_1208\":\"0\",\"time\":\"20240118121740\"}";
        String str62 = "{\"orderId\":\"taw-12566336877000986\",\"backTimeConsume\":\"{\\\"0\\\":183.96,\\\"11\\\":208043.82,\\\"15\\\":20062.6,\\\"19\\\":876.04,\\\"9\\\":349431.95}\",\"ft100204\":\"v2154a\",\"ft100203\":\"ANDROID13\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"ft100207\":\"2021\",\"ft100206\":\"4\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.5811489\",\"ft100205\":\"vivo\",\"ft500103\":\"9_0\",\"ft100209\":\"MOB\",\"fd_1318\":\"180_1_10_1\",\"fd_1807_01\":\"1\",\"ft500101\":\"88903_0\",\"ft300101\":\"95790\",\"fd_1810_01\":\"0\",\"fd_1208_01\":\"1\",\"fd_1709_01\":\"0\",\"ft300904\":\"3\",\"fd_1306\":\"34\",\"ft300901\":\"4\",\"fd_1305\":\"91\",\"ft300902\":\"42\",\"fd_1308\":\"20\",\"ft300903\":\"4211\",\"fd_1307\":\"24\",\"ft300104\":\"33\",\"fd_1707\":\"0\",\"ft300105\":\"346\",\"fd_1708\":\"0\",\"fd_1309\":\"10\",\"ft300106\":\"987\",\"fd_1705\":\"4\",\"ft300107\":\"671\",\"fd_1706\":\"2\",\"ft301003\":\"18\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"4\",\"fd_1809_01\":\"0\",\"ft600210\":\"0\",\"fd_1209_01\":\"0\",\"ft301001\":\"12\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"161015\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"7\",\"fd_1308_02\":\"10\",\"ft200101\":\"88903\",\"ft200102\":\"47174\",\"ft600201\":\"51485749\",\"ft300201\":\"457699\",\"ft300202\":\"3\",\"fd_1707_01\":\"0\",\"advertId\":\"88903\",\"abst\":\"[0]\",\"fd_1506_08\":\"3.15E-5\",\"ft200111\":\"2\",\"fd_1506_07\":\"0.0784561\",\"fd_1205\":\"19\",\"ft600209\":\"669\",\"fd_1207\":\"1\",\"fd_1710_01\":\"0\",\"fd_1206\":\"4\",\"fd_1208\":\"1\",\"fd_1305_01\":\"10\",\"fd_1207_01\":\"1\",\"fd_1708_01\":\"0\",\"chargeType\":\"2\",\"fd_1505_06\":\"0.538389\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"33758\",\"fd_1705_01\":\"4\",\"fd_1210_01\":\"0\",\"consumerId\":\"37925628890\",\"fd_1307_01\":\"8\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1503\":\"88903\",\"fd_1504\":\"89437\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"33758\",\"fd_1808_01\":\"1\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"ft300113\":\"4\",\"ft300114\":\"1047\",\"ft6002031\":\"9349574816\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"7\",\"ft500203\":\"9_null\",\"ft500201\":\"88903_null\",\"f8807\":\"1\",\"fd_1805_01\":\"7\",\"ft110014\":\"1\",\"ft6002041\":\"727455003854\",\"fd_1808\":\"1\",\"fd_1502_04\":\"3.75E-5\",\"fd_1001\":\"010101\",\"fd_1003\":\"010502\",\"fd_1309_01\":\"6\",\"fd_1002\":\"01020301\",\"fd_1005\":\"11,1,34,14,17,19,8,161805,83083,10,21\",\"fd_1007\":\"100604,100802,101002,100102,100202,100301,101302,101502\",\"fd_1502_03\":\"0.0808255\",\"fd_1006\":\"1008,1006,1015,1003,1002,1013,1001,1010\",\"fd_1008\":\"91,92,391,393,790,927,263\",\"time\":\"20240118123753\",\"fd_1806\":\"4\",\"fd_1807\":\"1\",\"fd_1805\":\"19\"}";
        String str63 = "{\"orderId\":\"taw-12586985932230414\",\"backTimeConsume\":\"{\\\"0\\\":151.44,\\\"11\\\":173089.74,\\\"15\\\":6456.15,\\\"19\\\":281.57,\\\"9\\\":375872.83}\",\"ft100204\":\"phs110\",\"ft100203\":\"ANDROID14\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.7167374\",\"ft100205\":\"unknown\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"fd_1318\":\"180_1_10_1\",\"ft500101\":\"88903_0\",\"ft300101\":\"91669\",\"ft300904\":\"3\",\"fd_1306\":\"2\",\"ft300901\":\"3\",\"fd_1305\":\"4\",\"ft300902\":\"37\",\"fd_1308\":\"2\",\"ft300903\":\"3708\",\"fd_1307\":\"3\",\"ft300104\":\"38\",\"ft300105\":\"365\",\"fd_1309\":\"10\",\"ft300106\":\"987\",\"ft300107\":\"696\",\"ft301003\":\"26\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"5\",\"ft301001\":\"12\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"161015\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"2\",\"fd_1308_02\":\"2\",\"ft200101\":\"88903\",\"ft200102\":\"47174\",\"ft300201\":\"456841\",\"ft300202\":\"3\",\"advertId\":\"88903\",\"abst\":\"[0]\",\"fd_1506_08\":\"6.47E-5\",\"ft200111\":\"2\",\"fd_1506_07\":\"0.0771072\",\"fd_1305_01\":\"4\",\"chargeType\":\"2\",\"fd_1505_06\":\"0.7172709\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"35249\",\"ft6002021\":\"212418\",\"consumerId\":\"37967029662\",\"fd_1307_01\":\"3\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1503\":\"90060\",\"fd_1504\":\"90060\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"35249\",\"fd_1508\":\"10\",\"ft300305\":\"2\",\"ft300113\":\"4\",\"ft300114\":\"1057\",\"ft6002031\":\"1000231871\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"ft500203\":\"9_null\",\"ft500201\":\"88903_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft6002041\":\"208450556\",\"fd_1502_04\":\"1.239E-4\",\"fd_1001\":\"010102\",\"fd_1003\":\"010501\",\"fd_1309_01\":\"1\",\"fd_1002\":\"010202\",\"fd_1005\":\"17,19,151111,21\",\"fd_1007\":\"100604,100202\",\"fd_1502_03\":\"0.08138\",\"fd_1006\":\"1006,1002\",\"fd_1008\":\"192,291,391,393,263,385,441,266,202,378,521,444,137,303,558,927\",\"time\":\"20240126120059\"}";
        String str64 = "{\"orderId\":\"taw-12586991695970618\",\"chargeType\":\"2\",\"fd_1108_01\":\"0\",\"fd_1120\":\"34235\",\"backTimeConsume\":\"{\\\"0\\\":351.78,\\\"11\\\":272789.95,\\\"15\\\":3158.0,\\\"19\\\":429.57,\\\"9\\\":532717.97}\",\"ft100204\":\"lya-al00;\",\"fd_1117_01\":\"0\",\"ft100203\":\"HARMONYOS??\",\"fd_1110\":\"1706241800\",\"fd_1011_01\":\"-1\",\"ft100202\":\"3\",\"ft100201\":\"3\",\"fd_1505_06\":\"0.6890289\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.6731728\",\"fd_1116\":\"0\",\"ft500103\":\"9_0\",\"ft100209\":\"MOB\",\"ft500101\":\"89588_0\",\"fd_1105_01\":\"3\",\"linkageSubtype\":\"0-11\",\"ft300101\":\"96121\",\"ft300301\":\"34235\",\"consumerId\":\"37967051370\",\"fd_1501\":\"88903\",\"ft300904\":\"1\",\"fd_1502\":\"88903\",\"fd_1105\":\"3\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"ft300901\":\"4\",\"fd_1503\":\"90122\",\"ft300902\":\"42\",\"fd_1504\":\"89437\",\"ft300903\":\"4201\",\"ft300302\":\"1\",\"ft300104\":\"39\",\"ft300303\":\"1\",\"ft300105\":\"380\",\"fd_1507\":\"9\",\"ft300304\":\"34235\",\"ft300106\":\"981\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"ft300107\":\"674\",\"ft301003\":\"26\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"5\",\"ft300113\":\"4\",\"ft300114\":\"1044\",\"ft301001\":\"12\",\"ft200103\":\"07.23.0008\",\"ft200301\":\"0\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"159858\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft200101\":\"89588\",\"ft200102\":\"44445\",\"ft500203\":\"9_null\",\"ft500201\":\"89588_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft300201\":\"458672\",\"ft300202\":\"12\",\"fd_1107_01\":\"0\",\"advertId\":\"89588\",\"abst\":\"[0]\",\"fd_1502_04\":\"9.114E-4\",\"fd_1506_08\":\"6.59E-5\",\"fd_1118_01\":\"0\",\"ft200111\":\"2\",\"fd_1506_07\":\"0.1159535\",\"fd_1502_03\":\"0.1239369\",\"time\":\"20240126120329\"}";
        String str65 = "{\"orderId\":\"taw-12562267715870245\",\"backTimeConsume\":\"{\\\"0\\\":154.1,\\\"11\\\":170892.09,\\\"15\\\":1216.0,\\\"19\\\":880.82,\\\"9\\\":338284.23}\",\"ft100204\":\"vivo x20\",\"ft100203\":\"ANDROID8\",\"fd_1011_01\":\"-1\",\"ft100202\":\"2\",\"ft100201\":\"1\",\"fd_1310\":\"16\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.4980764\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"fd_1318\":\"180_1_10_1,180_1_16_2,180_1_9_3,180_2_16_1\",\"fd_1807_01\":\"2\",\"ft500101\":\"88903_0\",\"ft300101\":\"88127\",\"fd_1810_01\":\"0\",\"fd_1208_01\":\"0\",\"fd_1709_01\":\"0\",\"ft300904\":\"3\",\"fd_1306\":\"51\",\"ft300901\":\"4\",\"ft300109\":\"com.appheader.zhxf.pro\",\"fd_1305\":\"68\",\"ft300902\":\"41\",\"fd_1308\":\"33\",\"ft300903\":\"4107\",\"fd_1307\":\"50\",\"ft300104\":\"27\",\"fd_1707\":\"2\",\"ft300105\":\"268\",\"fd_1708\":\"0\",\"fd_1309\":\"10,16,9\",\"ft300106\":\"987\",\"fd_1705\":\"7\",\"ft300107\":\"697\",\"fd_1706\":\"4\",\"ft301003\":\"16\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"2\",\"fd_1809_01\":\"0\",\"fd_1209_01\":\"0\",\"ft301001\":\"7\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"161015\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"8\",\"fd_1308_02\":\"12\",\"fd_1214\":\"49338\",\"ft200101\":\"88903\",\"ft200102\":\"47174\",\"fd_1602_03\":\"0.0\",\"ft600201\":\"10475764\",\"ft300201\":\"441102\",\"ft300202\":\"3\",\"fd_1707_01\":\"2\",\"advertId\":\"88903\",\"abst\":\"[0]\",\"fd_1506_08\":\"1.61E-5\",\"ft200111\":\"2\",\"fd_1506_07\":\"0.0913233\",\"fd_1205\":\"7\",\"ft600209\":\"5\",\"fd_1207\":\"2\",\"fd_1710_01\":\"0\",\"fd_1206\":\"4\",\"fd_1208\":\"0\",\"fd_1305_01\":\"9\",\"fd_1207_01\":\"2\",\"fd_1708_01\":\"0\",\"chargeType\":\"2\",\"fd_1505_06\":\"0.5111999\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"35871\",\"fd_1705_01\":\"6\",\"ft6002021\":\"3x4qdqb8qyyrajm\",\"fd_1210_01\":\"0\",\"consumerId\":\"37915227381\",\"fd_1307_01\":\"9\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1505\":\"16\",\"ft300306\":\"2\",\"fd_1506\":\"16\",\"fd_1503\":\"90059\",\"fd_1504\":\"89437\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"35322\",\"fd_1808_01\":\"0\",\"fd_1508\":\"16\",\"ft300305\":\"1\",\"ft300113\":\"4\",\"ft300114\":\"1045\",\"ft6002031\":\"3022804307\",\"ft200301\":\"0\",\"fd_1310_01\":\"1\",\"fd_1310_02\":\"1\",\"fd_1205_01\":\"6\",\"ft500203\":\"9_null\",\"ft500201\":\"88903_null\",\"f8807\":\"1\",\"fd_1805_01\":\"6\",\"ft110014\":\"1\",\"ft6002041\":\"35157085527\",\"fd_1808\":\"0\",\"fd_1502_04\":\"2.76E-5\",\"fd_1001\":\"010102\",\"fd_1003\":\"010501\",\"fd_1309_01\":\"7\",\"fd_1002\":\"010202\",\"fd_1005\":\"1,49338,17,69767,10,167364,21\",\"fd_1007\":\"100604,101002,100202,101502\",\"fd_1502_03\":\"0.0999844\",\"fd_1006\":\"1006,1015,1002,1010\",\"fd_1008\":\"385,202,378,192\",\"fd_1601_02\":\"0.4064517\",\"time\":\"20240116072514\",\"fd_1806\":\"4\",\"fd_1807\":\"2\",\"fd_1805\":\"8\"}";
        String str66 = "{\"orderId\":\"taw-12558334267390376\",\"backTimeConsume\":\"{\\\"0\\\":173.7,\\\"11\\\":188439.35,\\\"15\\\":19369.5,\\\"19\\\":416.55,\\\"9\\\":339285.85}\",\"ft100204\":\"V2166BA\",\"ft100203\":\"ANDROID13\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.4845874\",\"ft100205\":\"vivo\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"ft500101\":\"88903_0\",\"ft300101\":\"88127\",\"ft300904\":\"4\",\"fd_1306\":\"2\",\"ft300901\":\"1\",\"ft300109\":\"com.anser.cfdt\",\"fd_1305\":\"2\",\"ft300902\":\"14\",\"fd_1308\":\"2\",\"ft300903\":\"1408\",\"fd_1307\":\"2\",\"ft300104\":\"27\",\"ft300105\":\"268\",\"ft300106\":\"987\",\"ft300107\":\"697\",\"ft301003\":\"14\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"7\",\"ft301001\":\"4\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"161015\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"2\",\"fd_1308_02\":\"2\",\"ft200101\":\"88903\",\"ft200102\":\"47174\",\"fd_1602_04\":\"5.275E-4\",\"fd_1602_03\":\"0.0975739\",\"ft600201\":\"10475764\",\"ft300201\":\"441102\",\"ft300202\":\"3\",\"advertId\":\"88903\",\"abst\":\"[0]\",\"fd_1506_08\":\"1.54E-5\",\"ft200111\":\"2\",\"fd_1506_07\":\"0.0898696\",\"ft600209\":\"5\",\"fd_1305_01\":\"2\",\"chargeType\":\"2\",\"fd_1505_06\":\"0.4987389\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"35982\",\"ft6002021\":\"3x6623cqebvwtna\",\"consumerId\":\"37904998776\",\"fd_1307_01\":\"2\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1505\":\"16\",\"ft300306\":\"2\",\"fd_1506\":\"16\",\"fd_1503\":\"90059\",\"fd_1504\":\"89437\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"35982\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"ft300113\":\"4\",\"ft300114\":\"1045\",\"ft6002031\":\"2785029932\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"ft500203\":\"9_null\",\"ft500201\":\"88903_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft6002041\":\"33154033093\",\"fd_1502_04\":\"2.66E-5\",\"fd_1001\":\"010102\",\"fd_1003\":\"010501\",\"fd_1309_01\":\"0\",\"fd_1002\":\"01020301\",\"fd_1005\":\"22,1,34,2,14,5,17,18,8,51191,10,21\",\"fd_1007\":\"100604,100802,101506,101001,101002,100102,100202,100301,101502\",\"fd_1502_03\":\"0.0988919\",\"fd_1006\":\"1008,1006,1015,1003,1002,1001,1010\",\"fd_1008\":\"385,201,378,193,927\",\"fd_1601_02\":\"0.6173914\",\"time\":\"20240114043624\"}";
        String str67 = "{\"orderId\":\"taw-12545959685760069\",\"backTimeConsume\":\"{\\\"0\\\":167.01,\\\"11\\\":190547.45,\\\"15\\\":9408.07,\\\"19\\\":374.83,\\\"9\\\":339778.43}\",\"ft100204\":\"v1932a\",\"ft100203\":\"ANDROID10\",\"fd_1011_01\":\"-1\",\"ft100202\":\"3\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"2019\",\"ft100206\":\"0\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.7585086\",\"ft100205\":\"vivo\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"ft500101\":\"88903_0\",\"ft300101\":\"92104\",\"ft300904\":\"4\",\"fd_1306\":\"0\",\"ft300901\":\"3\",\"ft300109\":\"com.yyxh.qcdh\",\"fd_1305\":\"2\",\"ft300902\":\"37\",\"fd_1308\":\"0\",\"ft300903\":\"3714\",\"fd_1307\":\"0\",\"ft300104\":\"27\",\"ft300105\":\"268\",\"ft300106\":\"985\",\"ft300107\":\"671\",\"ft301003\":\"6\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"6\",\"ft301001\":\"22\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"161015\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"0\",\"fd_1308_02\":\"0\",\"ft200101\":\"88903\",\"ft200102\":\"47174\",\"fd_1602_04\":\"0.00113\",\"fd_1602_03\":\"0.0508475\",\"ft600201\":\"24380268\",\"ft300201\":\"458697\",\"ft300202\":\"3\",\"advertId\":\"88903\",\"abst\":\"[0]\",\"fd_1506_08\":\"2.567E-4\",\"ft200111\":\"2\",\"fd_1506_07\":\"0.0910958\",\"ft600209\":\"5\",\"fd_1305_01\":\"2\",\"chargeType\":\"2\",\"fd_1505_06\":\"0.7180041\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"35206\",\"ft6002021\":\"3x9qn7c3nyuhii6\",\"consumerId\":\"37872767045\",\"fd_1307_01\":\"0\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1503\":\"90059\",\"fd_1504\":\"90840\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"35206\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"ft300113\":\"4\",\"ft300114\":\"1045\",\"ft6002031\":\"3553806314\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"ft500203\":\"9_null\",\"ft500201\":\"88903_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft6002041\":\"40747942883\",\"fd_1502_04\":\"3.992E-4\",\"fd_1309_01\":\"0\",\"fd_1005\":\"34\",\"fd_1007\":\"100102\",\"fd_1502_03\":\"0.0981906\",\"fd_1006\":\"1001\",\"fd_1601_02\":\"0.5450392\",\"time\":\"20240106220926\"}";
        String str68 = "{\"fd_1108_02\":\"1\",\"orderId\":\"taw-12660227369410009\",\"fd_1108_01\":\"1\",\"backTimeConsume\":\"{\\\"0\\\":139.2,\\\"11\\\":184391.91,\\\"15\\\":7530.57,\\\"19\\\":372.67,\\\"9\\\":367940.49}\",\"ft100204\":\"iphone\",\"fd_1117_01\":\"0\",\"ft100203\":\"IOS17\",\"fd_1011_01\":\"1\",\"ft100202\":\"2\",\"ft100201\":\"3\",\"ft100208\":\"ios\",\"ft100207\":\"-1\",\"ft100206\":\"6\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.6358813\",\"ft100205\":\"iphone\",\"ft500103\":\"9_0\",\"ft100209\":\"MOB\",\"ft500101\":\"88903_0\",\"fd_1105_01\":\"2\",\"ft300101\":\"90552\",\"ft300904\":\"2\",\"ft300901\":\"3\",\"ft300902\":\"37\",\"ft300903\":\"3701\",\"ft300104\":\"33\",\"ft300105\":\"352\",\"ft300106\":\"981\",\"ft300107\":\"693\",\"ft301003\":\"26\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"ft301001\":\"12\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"161015\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft200101\":\"88903\",\"ft200102\":\"47174\",\"ft300201\":\"424059\",\"ft300202\":\"11\",\"fd_1107_01\":\"2\",\"advertId\":\"88903\",\"abst\":\"[0]\",\"fd_1506_08\":\"1.93E-5\",\"fd_1118_01\":\"0\",\"ft200111\":\"2\",\"fd_1506_07\":\"0.0811529\",\"chargeType\":\"2\",\"fd_1120\":\"31594,36251\",\"fd_1111\":\"9\",\"fd_1110\":\"1708922094\",\"fd_1113\":\"31594\",\"fd_1112\":\"1708922133\",\"fd_1115\":\"866781184845307904\",\"fd_1505_06\":\"0.6305784\",\"fd_1114\":\"866781267007512576\",\"fd_1116\":\"0\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"36251\",\"consumerId\":\"38172060681\",\"fd_1501\":\"80766\",\"fd_1502\":\"80766\",\"fd_1106\":\"2\",\"fd_1105\":\"2\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1108\":\"1\",\"fd_1506\":\"9\",\"fd_1107\":\"2\",\"fd_1503\":\"80766\",\"fd_1504\":\"91290\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"9\",\"ft300304\":\"36251\",\"fd_1508\":\"16\",\"ft300305\":\"12\",\"fd_1106_02\":\"2\",\"ft300113\":\"5\",\"ft300114\":\"1044\",\"ft200301\":\"0\",\"ft500203\":\"9_null\",\"ft500201\":\"88903_null\",\"f8807\":\"1\",\"ft110014\":\"3\",\"fd_1502_04\":\"6.15E-5\",\"fd_1502_03\":\"0.0831968\",\"time\":\"20240226123548\"}";
        String str69 = "{\"fd_1108_02\":\"6\",\"orderId\":\"taw-12661525904740228\",\"fd_1108_01\":\"6\",\"backTimeConsume\":\"{\\\"0\\\":139.2,\\\"11\\\":184391.91,\\\"15\\\":7530.57,\\\"19\\\":372.67,\\\"9\\\":367940.49}\",\"ft100204\":\"iphone\",\"fd_1117_01\":\"1\",\"ft100203\":\"IOS17\",\"fd_1011_01\":\"0\",\"ft100202\":\"3\",\"ft100201\":\"1\",\"ft100208\":\"ios\",\"ft100207\":\"-1\",\"ft100206\":\"6\",\"ft200201\":\"0\",\"fd_1501_02\":\"0.7995113\",\"ft100205\":\"iphone\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"ft500101\":\"88903_0\",\"fd_1105_01\":\"5\",\"ft300101\":\"90799\",\"ft300904\":\"1\",\"ft300901\":\"6\",\"ft300902\":\"51\",\"ft300903\":\"5101\",\"ft300104\":\"33\",\"ft300105\":\"346\",\"ft300106\":\"986\",\"ft300107\":\"671\",\"ft301003\":\"26\",\"advertBackSubTypes\":\"[0]\",\"ft301002\":\"1\",\"ft301001\":\"22\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"161015\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"1\",\"ft200101\":\"88903\",\"ft200102\":\"47174\",\"ft600201\":\"41986361\",\"ft300201\":\"427221\",\"ft300202\":\"3\",\"fd_1107_01\":\"6\",\"advertId\":\"88903\",\"abst\":\"[0]\",\"fd_1506_08\":\"1.71E-4\",\"fd_1118_01\":\"0\",\"ft200111\":\"2\",\"fd_1506_07\":\"0.0754545\",\"ft600209\":\"719\",\"chargeType\":\"2\",\"fd_1120\":\"34919,35108\",\"fd_1111\":\"16\",\"fd_1110\":\"1708957435\",\"fd_1113\":\"35108\",\"fd_1112\":\"1708957743\",\"fd_1115\":\"866930624570720256\",\"fd_1505_06\":\"0.7690313\",\"fd_1114\":\"866930624570720256\",\"fd_1117\":\"10\",\"fd_1116\":\"1\",\"linkageSubtype\":\"0-11\",\"ft300301\":\"34919\",\"consumerId\":\"38174557412\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1106\":\"8\",\"fd_1105\":\"5\",\"fd_1505\":\"16\",\"ft300306\":\"2\",\"fd_1108\":\"6\",\"fd_1506\":\"16\",\"fd_1107\":\"7\",\"fd_1503\":\"91316\",\"fd_1504\":\"86991\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"34919\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"fd_1106_02\":\"8\",\"ft300113\":\"4\",\"ft300114\":\"1047\",\"ft6002031\":\"8655046652\",\"ft200301\":\"0\",\"ft500203\":\"9_null\",\"ft500201\":\"88903_null\",\"f8807\":\"1\",\"ft110014\":\"8\",\"ft6002041\":\"641983148146\",\"fd_1502_04\":\"3.378E-4\",\"fd_1502_03\":\"0.088934\",\"time\":\"20240226222921\"}";
        String str70 = "{\"orderId\":\"taw-12664843105000811\",\"chargeType\":\"2\",\"backTimeConsume\":\"{\\\"0\\\":62.36,\\\"3\\\":68.66,\\\"19\\\":424.57,\\\"10\\\":5118.4}\",\"ft100204\":\"hry-al00t\",\"ft100203\":\"ANDROID10\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.7031749\",\"ft100207\":\"2019\",\"ft100206\":\"3\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.7008467\",\"ft100205\":\"honor\",\"ft500103\":\"16_3\",\"ft100209\":\"DYN\",\"ft500101\":\"90173_3\",\"linkageSubtype\":\"0-6,0-8,3-23\",\"ft300101\":\"95877\",\"ft300301\":\"33758\",\"consumerId\":\"38182992683\",\"fd_1501\":\"88903\",\"ft300904\":\"4\",\"fd_1502\":\"88903\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"ft300901\":\"6\",\"fd_1503\":\"90187\",\"ft300902\":\"51\",\"fd_1504\":\"89920\",\"ft300903\":\"5118\",\"ft300302\":\"1\",\"ft300104\":\"33\",\"ft300303\":\"1\",\"ft300105\":\"347\",\"fd_1507\":\"10\",\"ft300304\":\"33758\",\"ft300106\":\"985\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"ft300107\":\"671\",\"ft301003\":\"28\",\"advertBackSubTypes\":\"[0,3]\",\"ft301002\":\"3\",\"ft300113\":\"4\",\"ft300114\":\"1047\",\"ft301001\":\"15\",\"ft200103\":\"07.07.0066\",\"ft200301\":\"0\",\"ft200104\":\"16\",\"ft200105\":\"02.19.0003\",\"ft200106\":\"161641\",\"ft200107\":\"05.03.0012,05.02.0001,05.02.0019\",\"ft200109\":\"0\",\"ft200101\":\"90173\",\"ft200102\":\"47451\",\"ft500203\":\"16_null\",\"ft500201\":\"90173_null\",\"f8807\":\"1\",\"ft110014\":\"1\",\"ft300201\":\"457872\",\"ft300202\":\"3\",\"advertId\":\"90173\",\"abst\":\"[0,3]\",\"fd_1502_04\":\"0.0289309\",\"fd_1506_08\":\"0.0086839\",\"fd_1005\":\"1,2,4,17,19,8,10\",\"ft200111\":\"26\",\"fd_1506_07\":\"0.0266848\",\"fd_1007\":\"100802,101002,100202,100301,101502\",\"fd_1502_03\":\"0.0603774\",\"fd_1006\":\"1008,1015,1003,1002,1010\",\"time\":\"20240228154904\"}";
        String str71 = "{\"fd_1108_02\":\"3\",\"orderId\":\"taw-12695131293680579\",\"fd_1108_01\":\"3\",\"backTimeConsume\":\"{\\\"0\\\":55.91,\\\"3\\\":56.12}\",\"ft100204\":\"v2230a\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID13\",\"fd_1011_01\":\"1\",\"ft100202\":\"1\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.7034966\",\"ft100205\":\"vivo\",\"ft500103\":\"16_3\",\"ft100209\":\"GTW\",\"fd_1318\":\"30_1_10_1,180_1_10_1,180_1_1_2,180_1_9_3\",\"fd_1807_01\":\"5\",\"ft500101\":\"90606_3\",\"fd_1105_01\":\"2\",\"ft300101\":\"95933\",\"fd_1810_01\":\"0\",\"fd_1208_01\":\"4\",\"fd_1709_01\":\"0\",\"ft300904\":\"4\",\"fd_1306\":\"76\",\"ft300901\":\"3\",\"fd_1305\":\"95\",\"ft300902\":\"34\",\"fd_1308\":\"33\",\"ft300903\":\"3418\",\"fd_1307\":\"36\",\"ft300104\":\"33\",\"fd_1707\":\"3\",\"ft300105\":\"346\",\"fd_1708\":\"3\",\"fd_1309\":\"10,1,9\",\"ft300106\":\"985\",\"fd_1705\":\"12\",\"ft300107\":\"671\",\"fd_1706\":\"5\",\"ft301003\":\"18\",\"advertBackSubTypes\":\"[0,3]\",\"ft301002\":\"1\",\"fd_1809_01\":\"1\",\"fd_1209_01\":\"0\",\"ft301001\":\"15\",\"ft200103\":\"07.10.0146\",\"ft200104\":\"16\",\"ft200105\":\"02.19.0003\",\"ft200106\":\"162762\",\"ft200107\":\"05.03.0013,05.02.0001,05.02.0019,05.02.0008\",\"ft200109\":\"0\",\"fd_1308_01\":\"8\",\"fd_1308_02\":\"12\",\"fd_1214\":\"175942\",\"ft200101\":\"90606\",\"ft200102\":\"43767\",\"ft300201\":\"457943\",\"ft300202\":\"3\",\"fd_1107_01\":\"3\",\"fd_1707_01\":\"3\",\"advertId\":\"90606\",\"abst\":\"[0,3]\",\"fd_1506_08\":\"0.0135432\",\"fd_1118_01\":\"0\",\"ft200111\":\"YYFfUYimWFSEsEZfxoWB5kaCoFmJLSZ8Tn9gfRS57GDJEZhibjDt4YHputqcPLeGSRxjKEicP43pxh1P6rySdfus9H\",\"fd_1506_07\":\"0.0429173\",\"fd_1205\":\"17\",\"fd_1207\":\"4\",\"fd_1710_01\":\"0\",\"fd_1206\":\"6\",\"fd_1208\":\"4\",\"fd_1305_01\":\"10\",\"fd_1207_01\":\"4\",\"fd_1708_01\":\"3\",\"chargeType\":\"2\",\"fd_1120\":\"35940,33758\",\"fd_1111\":\"16\",\"fd_1110\":\"1710742666\",\"fd_1113\":\"33758\",\"fd_1112\":\"1710745403\",\"fd_1115\":\"874428591452221440\",\"fd_1505_06\":\"0.7348015\",\"fd_1114\":\"874428591452221440\",\"fd_1116\":\"1\",\"linkageSubtype\":\"0-6,0-8,3-23\",\"ft300301\":\"33758\",\"fd_1705_01\":\"7\",\"fd_1210_01\":\"0\",\"consumerId\":\"38282019395\",\"fd_1307_01\":\"8\",\"fd_1501\":\"88162\",\"fd_1502\":\"88162\",\"fd_1106\":\"3\",\"fd_1105\":\"2\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1108\":\"3\",\"fd_1506\":\"9\",\"fd_1107\":\"3\",\"fd_1503\":\"90207\",\"fd_1504\":\"89920\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"33758\",\"fd_1808_01\":\"5\",\"fd_1508\":\"16\",\"ft300305\":\"2\",\"fd_1106_02\":\"3\",\"ft300113\":\"4\",\"ft300114\":\"1047\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"7\",\"ft500203\":\"16_null\",\"ft500201\":\"90606_null\",\"f8807\":\"1\",\"fd_1805_01\":\"8\",\"ft110014\":\"3\",\"fd_1808\":\"5\",\"fd_1809\":\"10\",\"fd_1502_04\":\"0.0198916\",\"fd_1001\":\"010102\",\"fd_1003\":\"010501\",\"fd_1309_01\":\"6\",\"fd_1002\":\"01020301\",\"fd_1005\":\"34,2,175942,17,64103,8,10\",\"fd_1007\":\"100802,101001,101002,100102,100202,101502\",\"fd_1502_03\":\"0.0198916\",\"fd_1006\":\"1008,1015,1002,1001,1010\",\"fd_1008\":\"385,441,266,201,399,378,444,535,193,393,508\",\"time\":\"20240318150505\",\"fd_1806\":\"8\",\"fd_1807\":\"5\",\"fd_1805\":\"23\"}";
        String str74 = "{\"orderId\":\"taw-12695145301940358\",\"fd_1108_01\":\"0\",\"backTimeConsume\":\"{\\\"3\\\":106.32,\\\"10\\\":732.71}\",\"ft100204\":\"elz-an10\",\"fd_1117_01\":\"0\",\"ft100203\":\"ANDROID14\",\"fd_1011_01\":\"-1\",\"ft100202\":\"1\",\"ft100201\":\"3\",\"ft100208\":\"android\",\"ft100207\":\"-1\",\"ft100206\":\"0\",\"ft200201\":\"3\",\"fd_1501_02\":\"0.0\",\"ft100205\":\"honor\",\"ft500103\":\"16_3\",\"ft100209\":\"MOB\",\"fd_1318\":\"30_1_10_1,180_1_10_1\",\"fd_1807_01\":\"6\",\"ft500101\":\"88327_3\",\"fd_1105_01\":\"1\",\"ft300101\":\"96525\",\"fd_1810_01\":\"0\",\"fd_1709\":\"10\",\"fd_1208_01\":\"3\",\"fd_1709_01\":\"2\",\"ft300904\":\"3\",\"fd_1306\":\"93\",\"ft300901\":\"4\",\"fd_1305\":\"379\",\"ft300902\":\"41\",\"fd_1308\":\"39\",\"ft300903\":\"4103\",\"fd_1307\":\"72\",\"ft300104\":\"33\",\"fd_1707\":\"5\",\"ft300105\":\"347\",\"fd_1708\":\"2\",\"fd_1309\":\"10\",\"ft300106\":\"985\",\"fd_1705\":\"4\",\"ft300107\":\"671\",\"fd_1706\":\"5\",\"ft301003\":\"18\",\"advertBackSubTypes\":\"[3]\",\"ft301002\":\"1\",\"fd_1809_01\":\"3\",\"fd_1209_01\":\"3\",\"ft301001\":\"15\",\"ft200103\":\"07.07.0066\",\"ft200104\":\"16\",\"ft200105\":\"02.19.0001\",\"ft200106\":\"161121\",\"ft200107\":\"05.03.0012,05.02.0001,05.02.0019\",\"ft200109\":\"0\",\"fd_1308_01\":\"8\",\"fd_1308_02\":\"12\",\"fd_1214\":\"161435\",\"ft200101\":\"88327\",\"ft200102\":\"46016\",\"ft300201\":\"460637\",\"ft300202\":\"3\",\"fd_1107_01\":\"0\",\"fd_1707_01\":\"5\",\"advertId\":\"88327\",\"abst\":\"[3]\",\"fd_1506_08\":\"0.0070622\",\"fd_1118_01\":\"0\",\"ft200111\":\"okt9ek2hmazXji6v1ms17r1LgVfoYYQehcP43E7AZFCZEzeHT1LbdUAx2iErPpf89qSjxhPe48NsYqrTwwqS9mW2w95Yov\",\"fd_1506_07\":\"0.0197741\",\"fd_1205\":\"15\",\"fd_1207\":\"6\",\"fd_1710_01\":\"0\",\"fd_1206\":\"14\",\"fd_1209\":\"10\",\"fd_1208\":\"3\",\"fd_1305_01\":\"12\",\"fd_1207_01\":\"6\",\"fd_1708_01\":\"2\",\"chargeType\":\"2\",\"fd_1120\":\"36346\",\"fd_1110\":\"1710746009\",\"fd_1505_06\":\"0.7368422\",\"fd_1116\":\"0\",\"linkageSubtype\":\"0-6,0-8,3-23\",\"ft300301\":\"36346\",\"fd_1705_01\":\"4\",\"fd_1210_01\":\"0\",\"consumerId\":\"38282059110\",\"fd_1307_01\":\"9\",\"fd_1501\":\"88903\",\"fd_1502\":\"88903\",\"fd_1105\":\"1\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1503\":\"90059\",\"fd_1504\":\"90059\",\"ft300302\":\"1\",\"ft300303\":\"1\",\"fd_1507\":\"10\",\"ft300304\":\"36346\",\"fd_1808_01\":\"4\",\"fd_1508\":\"10\",\"ft300305\":\"2\",\"ft300113\":\"4\",\"ft300114\":\"1047\",\"ft200301\":\"0\",\"fd_1310_01\":\"0\",\"fd_1310_02\":\"0\",\"fd_1205_01\":\"7\",\"ft500203\":\"16_null\",\"ft500201\":\"88327_null\",\"f8807\":\"1\",\"fd_1805_01\":\"8\",\"ft110014\":\"1\",\"fd_1808\":\"4\",\"fd_1809\":\"10\",\"fd_1502_04\":\"0.0\",\"fd_1001\":\"010102\",\"fd_1003\":\"010501\",\"fd_1309_01\":\"7\",\"fd_1002\":\"01020301\",\"fd_1005\":\"22,12,34,13,17,64687,161435,18,19,163214,163335,1,166064,172726,172665,10,174045,21\",\"fd_1007\":\"100604,100802,100803,100902,101001,101002,100102,100202,101502\",\"fd_1502_03\":\"0.0\",\"fd_1006\":\"1008,1006,1015,1002,1001,1010,1009\",\"fd_1008\":\"385,202,378,193\",\"time\":\"20240318151336\",\"fd_1806\":\"22\",\"fd_1807\":\"8\",\"fd_1805\":\"37\"}";
        String str100 = "{\"ft200202\":\"null\",\"fd_1011_01\":\"-1\",\"ft100202\":\"3\",\"ft100201\":\"1\",\"fd_1505_06\":\"0.4690009\",\"fd_1501_02\":\"0.4430192\",\"ft200201\":\"0\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"ft500101\":\"89588_0\",\"ft300101\":\"96121\",\"ft300301\":\"36852\",\"fd_1501\":\"88903\",\"ft300904\":\"1\",\"fd_1502\":\"88903\",\"fd_1505\":\"9\",\"fd_1506\":\"9\",\"ft300901\":\"3\",\"fd_1503\":\"88903\",\"ft300902\":\"31\",\"fd_1504\":\"90900\",\"ft300903\":\"31\",\"ft300104\":\"39\",\"ft300105\":\"380\",\"fd_1507\":\"9\",\"ft300106\":\"981\",\"fd_1508\":\"16\",\"ft300107\":\"674\",\"ft301003\":\"22\",\"ft301002\":\"3\",\"ft301001\":\"16\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"159857\",\"ft200107\":\"05.02.0020,05.03.0002\",\"ft200109\":\"0\",\"ft200101\":\"89588\",\"ft200102\":\"44445\",\"ft500203\":\"9_null\",\"ft500201\":\"89588_null\",\"ft110014\":\"1\",\"ft300201\":\"458671\",\"ft300202\":\"12\",\"ft200114\":\"3ZL2Wsrhk4MQgB2uN\",\"ft200115\":\"Dc4FC3BLrYQu6PkWbG1rJzj6yX5s1tiEu\",\"ft200116\":\"mVYf\",\"ft200117\":\"mVYf\",\"fd_1502_04\":\"4.54E-5\",\"fd_1506_08\":\"1.43E-5\",\"fd_1506_07\":\"0.1153768\",\"ft200111\":\"M6hMepR43Z4Vr6JgSWqDRtv4JTereb8hbtfU6BnWyETomFDfrURpWqUfaRibyp6LVAi7Z6B\",\"ft200112\":\"ouqa\",\"fd_1502_03\":\"0.1219052\",\"ft200113\"  :\"7NZ\"}";
        String str101 = "{\"ft200202\":\"null\",\"ft100204\":\"iphone\",\"ft100203\":\"IOS16\",\"fd_1011_01\":\"-1\",\"ft100202\":\"3\",\"ft100201\":\"3\",\"ft100208\":\"ios\",\"fd_1505_06\":\"0.1998236\",\"ft100207\":\"-1\",\"ft100206\":\"6\",\"fd_1501_02\":\"0.2449714\",\"ft200201\":\"0\",\"ft100205\":\"iphone\",\"ft500103\":\"9_0\",\"ft100209\":\"MOB\",\"ft500101\":\"88903_0\",\"ft300101\":\"96728\",\"ft300301\":\"37037\",\"fd_1501\":\"89588\",\"ft300904\":\"1\",\"fd_1502\":\"88903\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"ft300901\":\"6\",\"fd_1503\":\"88903\",\"ft300902\":\"51\",\"fd_1504\":\"91594\",\"ft300903\":\"5101\",\"ft300104\":\"61\",\"ft300302\":\"1\",\"ft300105\":\"638\",\"ft300303\":\"1\",\"fd_1507\":\"15\",\"ft300106\":\"981\",\"ft300304\":\"37037\",\"fd_1508\":\"15\",\"ft300107\":\"693\",\"ft300305\":\"2\",\"ft301003\":\"22\",\"ft301002\":\"3\",\"ft300113\":\"5\",\"ft300114\":\"1044\",\"ft301001\":\"16\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"164906\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft200101\":\"88903\",\"ft200102\":\"47174\",\"ft500203\":\"9_null\",\"ft500201\":\"88903_null\",\"ft110014\":\"1\",\"ft300201\":\"461988\",\"ft300202\":\"12\",\"ft200114\":\"2i46dKM8yq4WH\",\"ft200115\":\"9W7JmDiyXijFeGKbh4ywRPPu1748H\",\"ft200116\":\"mVYf\",\"ft200117\":\"B3PpXwBaeQVpcX8jzDXeHy\",\"fd_1502_04\":\"2.1E-4\",\"fd_1506_08\":\"8.54E-5\",\"fd_1506_07\":\"0.0747959\",\"ft200111\":\"FqiVd7f7P62xykj7VNvX8BgpSXGvY8vcLRojqszjwvMNMu9PggrmhnGXTMQRndP9XtrdyGy1BUhnDD7sPf\",\"ft200112\":\"ouqa\",\"fd_1502_03\":\"0.078673\",\"ft200113\":\"V8RC\"}";
        String str102 = "{\"ft200202\":\"null\",\"fd_1108_01\":\"0\",\"fd_1120\":\"36537\",\"fd_1117_01\":\"0\",\"fd_1111\":\"9\",\"ft100204\":\"tas-an00\",\"fd_1110\":\"1716373849\",\"ft100203\":\"ANDROID12\",\"fd_1011_01\":\"1\",\"fd_1113\":\"36537\",\"ft100202\":\"1\",\"fd_1112\":\"1716373854\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.5400801\",\"fd_1114\":\"898036050172211200\",\"ft100207\":\"2019\",\"ft100206\":\"5\",\"fd_1501_02\":\"0.5571203\",\"ft200201\":\"0\",\"fd_1116\":\"0\",\"ft100205\":\"huawei\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"ft500101\":\"88903_0\",\"fd_1105_01\":\"1\",\"ft300101\":\"86650\",\"ft300301\":\"36537\",\"ft600303\":\"0\",\"ft600302\":\"462235\",\"fd_1501\":\"88903\",\"ft300904\":\"1\",\"fd_1502\":\"88903\",\"fd_1106\":\"1\",\"fd_1105\":\"1\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1107\":\"1\",\"ft300901\":\"7\",\"fd_1503\":\"91945\",\"ft300902\":\"61\",\"fd_1504\":\"91945\",\"ft300903\":\"6101\",\"ft600305\":\"5709\",\"ft300104\":\"33\",\"ft300302\":\"1\",\"ft300105\":\"352\",\"ft300303\":\"1\",\"fd_1507\":\"15\",\"ft300106\":\"979\",\"ft300304\":\"36537\",\"fd_1508\":\"15\",\"ft300107\":\"674\",\"ft300305\":\"12\",\"ft301003\":\"22\",\"fd_1106_02\":\"1\",\"ft301002\":\"3\",\"ft300113\":\"7\",\"ft300114\":\"1044\",\"ft301001\":\"18\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"164830\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"1\",\"ft200101\":\"88903\",\"ft200102\":\"47174\",\"ft500203\":\"9_null\",\"ft500201\":\"88903_null\",\"ft110014\":\"2\",\"ft300201\":\"462235\",\"fd_1107_01\":\"1\",\"ft300202\":\"12\",\"ft200114\":\"2i46dKM8yq4WH\",\"ft200115\":\"9W7JmDiyXijFeGKbh4ywRPPu1748H\",\"ft200116\":\"mVYf\",\"ft200117\":\"BJPxdbGM3XjFmYjLGDrj56\",\"fd_1502_04\":\"4.73E-5\",\"fd_1506_08\":\"2.71E-5\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.082323\",\"ft200111\":\"np2rrUUZ9edsz68nvkd6anMosMEVAk1f9EfAaPK39JcRDYW1j1d6FZj7p22kr3SqNw3cXigsWp5oNMP\",\"ft200112\":\"ouqa\",\"fd_1502_03\":\"0.0884397\",\"ft200113\":\"2V\"}";
        String str103 = "{\"ft200202\":\"null\",\"fd_1108_01\":\"0\",\"fd_1120\":\"36537\",\"fd_1117_01\":\"0\",\"fd_1111\":\"9\",\"ft100204\":\"tas-an00\",\"fd_1110\":\"1716373849\",\"ft100203\":\"ANDROID12\",\"fd_1011_01\":\"1\",\"fd_1113\":\"36537\",\"ft100202\":\"1\",\"fd_1112\":\"1716373854\",\"ft100201\":\"1\",\"ft100208\":\"android\",\"fd_1505_06\":\"0.5400801\",\"fd_1114\":\"898036050172211200\",\"ft100207\":\"2019\",\"ft100206\":\"5\",\"fd_1501_02\":\"0.6437623\",\"ft200201\":\"0\",\"fd_1116\":\"0\",\"ft100205\":\"huawei\",\"ft500103\":\"9_0\",\"ft100209\":\"DYN\",\"ft500101\":\"89533_0\",\"fd_1105_01\":\"1\",\"ft300101\":\"86650\",\"ft300301\":\"36537\",\"ft600303\":\"0\",\"ft600302\":\"462235\",\"fd_1501\":\"88903\",\"ft300904\":\"1\",\"fd_1502\":\"88903\",\"fd_1106\":\"1\",\"fd_1105\":\"1\",\"fd_1505\":\"9\",\"ft300306\":\"2\",\"fd_1506\":\"9\",\"fd_1107\":\"1\",\"ft300901\":\"7\",\"fd_1503\":\"91945\",\"ft300902\":\"61\",\"fd_1504\":\"91945\",\"ft300903\":\"6101\",\"ft600305\":\"5709\",\"ft300104\":\"33\",\"ft300302\":\"1\",\"ft300105\":\"352\",\"ft300303\":\"1\",\"fd_1507\":\"15\",\"ft300106\":\"979\",\"ft300304\":\"36537\",\"fd_1508\":\"15\",\"ft300107\":\"674\",\"ft300305\":\"12\",\"ft301003\":\"22\",\"fd_1106_02\":\"1\",\"ft301002\":\"3\",\"ft300113\":\"7\",\"ft300114\":\"1044\",\"ft301001\":\"18\",\"ft200103\":\"07.23.0008\",\"ft200104\":\"9\",\"ft200105\":\"02.06.0004\",\"ft200106\":\"161019\",\"ft200107\":\"05.03.0001,05.02.0008\",\"ft200109\":\"0\",\"ft200101\":\"89533\",\"ft200102\":\"47174\",\"ft500203\":\"9_null\",\"ft500201\":\"89533_null\",\"ft110014\":\"2\",\"ft300201\":\"462235\",\"fd_1107_01\":\"1\",\"ft300202\":\"12\",\"ft200114\":\"2i46dKM8yq4WH\",\"ft200115\":\"9W7JmDiyXijFeGKbh4ywRPPu1748H\",\"ft200116\":\"mVYf\",\"ft200117\":\"BJPxdbGM3XjFmYjLGDrj56\",\"fd_1502_04\":\"8.204E-4\",\"fd_1506_08\":\"2.71E-5\",\"fd_1118_01\":\"0\",\"fd_1506_07\":\"0.082323\",\"ft200111\":\"m8KNoW94S2D9SK8wHVsW8NZ11Y9KcYT2RW1K98Fh5uzJiYQqDgP2dnCMB6J3nmuvw39hqaAgbiGxTDZ\",\"ft200112\":\"ouqa\",\"fd_1502_03\":\"0.0612524\",\"ft200113\":\"2S\"}";
        featureMapDoMap.put(102L, this.getFeatureMapDo(str102));
        featureMapDoMap.put(103L, this.getFeatureMapDo(str103));
        return featureMapDoMap;
    }

    public FeatureMapDo getFeatureMapDo(String str1) {
        JSONObject featureIdxMap1 = JSON.parseObject((String)str1);
        HashMap featureIdxMap2 = new HashMap();
        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap((Map)featureIdxMap1);
        featureMapDo.setDynamicFeatureMap(featureIdxMap2);
        return featureMapDo;
    }

    @Test
    public void test() throws Exception {
        DeepModelV2 coder = this.getCoder("nz_last_model_new_ad_dcvr_deep_v1213");
        String path = "/Users/panhangyi/data/serving-model/mid-ad-dcvr-v240117";
        LocalTFModelV2 tfModel = this.getTfModel(path);
        Map<Long, FeatureMapDo> featureMapDoMap = this.getFeatureMapDo();
        Map<Long, Double> ret = this.predict(coder, tfModel, featureMapDoMap);
        System.out.println(ret);
        for (Map.Entry<Long, FeatureMapDo> entry : featureMapDoMap.entrySet()) {
            Long key = entry.getKey();
            FeatureMapDo value = entry.getValue();
            CodeDo codeDo = coder.getSampleDense(value.getFeatureMap(), null);
            System.out.println(key + "\u5a92\u4f53\u6e20\u9053\u7c7b\u578b\u7279\u5f81\u7f16\u7801\uff1a\u4e0b\u6807\u4e3a28\u7684\u7279\u5f81\u7f16\u7801" + codeDo.singleCode.get(28));
            System.out.println(key + "\u5a92\u4f53\u6e20\u9053\u7c7b\u578b\u7279\u5f81\u7f16\u7801\uff1a\u4e0b\u6807\u4e3a29\u7684\u7279\u5f81\u7f16\u7801" + codeDo.singleCode.get(29));
            System.out.println(key + "\u5a92\u4f53\u6e20\u9053\u7c7b\u578b\u7279\u5f81\u7f16\u7801\uff1a" + codeDo.singleCode.get(45));
            System.out.println(key + "1-----" + DeepModelV2.toString((CodeDo)codeDo));
            System.out.println(key + "2-----" + JSON.toJSONString((Object)value.getCodeDoStr()));
        }
    }
}

