package cn.com.duiba.nezha.alg.example.example.intercept;

import cn.com.duiba.nezha.alg.alg.intercept.ActInterceptRcmdAlg;
import cn.com.duiba.nezha.alg.alg.vo.intercept.ActInterceptRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.intercept.PreSelectActInterceptDo;
import cn.com.duiba.nezha.alg.alg.vo.intercept.PreSelectPlugInterceptDo;
import cn.com.duiba.nezha.alg.example.util.StdCoderModelSaveBo;
import cn.com.duiba.nezha.alg.feature.vo.ActInterceptFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.ActInterceptStatDo;
import cn.com.duiba.nezha.alg.feature.vo.PlugInterceptStatDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSON;
import org.junit.Test;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlugInterceptDQNRcmderTest {

    @Test
    public void rcmd() {


        //1 编码器获取 缓存
        CODER coderModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("act_intercept_coder_dqn_v001", "act");

        System.out.println(coderModel.getFeatureBaseType());
        //2 TF本地模型获取  缓存
        LocalTFModel ltfModel = new LocalTFModel();
        try {
            ltfModel.loadModel("/Users/lwj/Desktop/model3/");


            List<PreSelectPlugInterceptDo> preSelectPlugDoList = new ArrayList<>();

            String pStr1 = "{\"plugId\":326,\"dt\":\"2020-03-23\",\"score\":10,\"rank\":1,\"slotId\":279179}";
            PreSelectPlugInterceptDo p1 = JSON.parseObject(pStr1, PreSelectPlugInterceptDo.class);
            preSelectPlugDoList.add(p1);

            String pStr2 = "{\"plugId\":289,\"dt\":\"2020-03-23\",\"score\":9,\"rank\":2,\"slotId\":279179}";
            PreSelectPlugInterceptDo p2 = JSON.parseObject(pStr2, PreSelectPlugInterceptDo.class);
            preSelectPlugDoList.add(p2);

            String pStr3 = "{\"plugId\":000,\"dt\":\"2020-03-22\",\"score\":10,\"rank\":1,\"slotId\":279179}";
            PreSelectPlugInterceptDo p3 = JSON.parseObject(pStr3, PreSelectPlugInterceptDo.class);
            preSelectPlugDoList.add(p3);


            //4 获取非创意特征（同点击率预估模型）


            //5 获取资源位创意推荐统计对象（算法1，入参）

            Map<Long, PlugInterceptStatDo> plugInterceptStatDoMap = new HashMap<>();
            //6 预估

            String featureStr = "{\"activityPage\":17918,\"appId\":52250,\"areaCode\":3301,\"dsm2A\":1,\"slotId\":279179}";

            ActInterceptFeatureDo actTitleFeatureDo = JSON.parseObject(featureStr, ActInterceptFeatureDo.class);

//            coderModel = null;
//            System.out.println("coder="+JSON.toJSONString(coderModel));

            Map<String, Long> retMap = new HashMap<>();
            System.out.println(LocalDateTime.now());

            List<Long> plugInterceptDoList = new ArrayList<>();
            plugInterceptDoList.add(326L);
            plugInterceptDoList.add(289L);

            for (int i = 0; i < 1; i++) {
                ActInterceptRcmdDo ret1 = ActInterceptRcmdAlg.rcmdPlug(coderModel,
                        ltfModel,
                        plugInterceptDoList,
                        preSelectPlugDoList,
                        plugInterceptStatDoMap,
                        actTitleFeatureDo);


//                System.out.println("ret="+JSON.toJSONString(ret1));
                if (ret1 != null) {
                    retMap.put(ret1.getKey(), retMap.getOrDefault(ret1.getKey(), 0L) + 1);
                } else {
                    retMap.put(null, retMap.getOrDefault(null, 0L) + 1);
                }
            }

            System.out.println("retMap=" + JSON.toJSONString(retMap));
            System.out.println(LocalDateTime.now());

        } catch (Exception e) {
            e.printStackTrace();
            System.out.println(e);

        }
    }
}
