package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.alg.adx.flowfilter.AdxFlowFilterAlg;
import cn.com.duiba.nezha.alg.alg.adx.flowfilter.AdxFlowFiltering;
import cn.com.duiba.nezha.alg.alg.adx.flowfilter.LaunchPvFiltering;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxIdeaFeatureDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFilterInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFlowInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FlowFilterRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FlowFilterResultDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxIdeaRcmdRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxIdeaRcmdResultDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.common.util.StringZIP;
import cn.com.duiba.nezha.alg.example.constant.ProjectConstant;
import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.StdCoderModelSaveBo;
import cn.com.duiba.nezha.alg.example.util.StdModelSave;
import cn.com.duiba.nezha.alg.example.util.conf.JedisConfig;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.FM;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static cn.com.duiba.nezha.alg.alg.adx.algplus.IdeaRcmdAlg.getIdeaRcmd;

public class AdxModelTest {

    public static void main(String[] args) {
        try {

            //testAdx11();
            //testDmp();
            //testAdxWeight();
            testAdxCoder();
            testAdxFilter();

        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public static void testDmp1() throws Exception {
        String key = "mid_ftrl_fm_bcvr_v007";



        FM model = StdModelSave.getModelByKeyFromJedis(key);

        System.out.println(model.getUpdateTime());

        String str = "{\"f608001\":\"0\",\"f104001\":\"58215\",\"f603002\":\"2\",\"f603001\":\"2\",\"f110001\":\"0\",\"f505001\":\"1700-2699\",\"f770102\":\"2\",\"f809001\":\"1\",\"f809002\":\"0\",\"f201001\":\"52999\",\"f660001\":\"\",\"f609001\":\"1\",\"f804004\":\"1\",\"f804003\":\"7\",\"f804002\":\"0\",\"f804001\":\"9\",\"f810001\":\"null\",\"f770001\":\"07.10.0004\",\"f810002\":\"null\",\"f306001\":\"2\",\"chargeType\":\"1\",\"f206001\":\"262\",\"f504001\":\"OPPO R11 Plusk\",\"f601001\":\"2\",\"f601002\":\"2\",\"f607001\":\"0\",\"f206002\":\"260\",\"f811001\":\"104\",\"f403004\":\"0\",\"f805001\":\"9\",\"f805002\":\"0\",\"f805003\":\"7\",\"f805004\":\"1\",\"f770302\":\"0\",\"f770301\":\"0\",\"f9940\":\"2,14,27,37,52,66,73,86,100,113,122,133,145,157,170\",\"f9941\":\"90,11698||4011,5891,2754,2750|8674,7860,4011,7422,8852,1220,1165,5083,1081,90,8604,7856,4582,5891,7751,2187,2515,2754,2753,2774,2773,2750,7607|7589|429|8674,7860,4011,7422,7589,8852,1220,1165,5083,1081,90,10099,8604,3895,7856,4582,5891,3692,7751,2187,1490,2515,3726,5409,3108,2754,2753,2774,2773,2750,429,64,7607|10099,4582,3726,2753,2774,2750||8674,7860,4011,7422,7589,8852,1220,1165,5083,1081,90,10099,8604,3895,7856,4582,5891,3692,7751,2187,2515,3726,5409,3108,2754,2753,2774,2773,2750,429,64,7607|8674,7860,4011,7422,7589,8852,1220,1165,5083,1081,90,10099,8604,3895,7856,4582,5891,3692,7751,2187,1490,2515,3726,5409,3108,2754,2753,2774,2773,2750,429,64,7607|8674,7860,4011,7422,7589,8852,1220,1165,5083,1081,90,10099,8604,3895,7856,4582,5891,3692,7751,2187,2515,3726,5409,2754,2753,2774,2773,2750,429,64,7607|8674,7860,4011,7422,7589,8852,1220,1165,5083,1081,90,10099,8604,3895,7856,4582,5891,7751,2187,2515,3726,5409,2754,2753,2774,2773,2750,11698,7607\",\"f9942\":\"0.522612,0.401063,0.593885,0.429044,0.588687,0.597908,0.607017,0.478813\",\"f9701\":\"01040218,020101,020105,020112,020114,020307,020408,020601,020710,020714,020801,021009,02110101,02110102,021107,021111,021120,021308,021404,021405,02140601,02140603,02140604,02140701,021408,022406,0225,03010105,03010108,05011701,05011804,0503\",\"f9943\":\"3692,8674,5083,7607,90,7856,1220,4582,10099,8852,64,4011,7589,3726,2750,2753,7860,3895,7422,429,5409,1165,1490,7751,2187\",\"f9702\":\"7\",\"f9944\":\"3692,8674,5083,7607,90,7856,1220,4582,10099,8852,64,4011,7589,3726,2750,2753,7860,3895,7422,429,5409,1165,1490,7751,2187\",\"f602001\":\"10\",\"f205002\":\"253\",\"f205001\":\"25\",\"f701001\":\"1043532\",\"f811002\":\"104\",\"f404003\":\"workother\",\"f106001\":\"12918\",\"f112001\":\"05.02.0014,05.02.0018\",\"f101001\":\"43532\",\"f701002\":\"1052999\",\"f9607\":\"null\",\"f9608\":\"null\",\"f9609\":\"null,10540_07.10.0004,15567_07.10.0004,15743_07.10.0004,18505_07.10.0004,9982_07.10.0004\",\"f503001\":\"3401\",\"f770202\":\"4\",\"time\":\"20200403065132\",\"f9601\":\"null\",\"f9602\":\"null,01040218_07.10.0004,020101_07.10.0004,020105_07.10.0004,020112_07.10.0004,020114_07.10.0004,020307_07.10.0004,020408_07.10.0004,020601_07.10.0004,020710_07.10.0004,020714_07.10.0004,020801_07.10.0004,021009_07.10.0004,02110101_07.10.0004,02110102_07.10.0004,021107_07.10.0004,021111_07.10.0004,021120_07.10.0004,021308_07.10.0004,021404_07.10.0004,021405_07.10.0004,02140601_07.10.0004,02140603_07.10.0004,02140604_07.10.0004,02140701_07.10.0004,021408_07.10.0004,022406_07.10.0004,0225_07.10.0004,03010105_07.10.0004,03010108_07.10.0004,05011701_07.10.0004,05011804_07.10.0004,0503_07.10.0004\",\"f602002\":\"9\",\"f9603\":\"null,01040218_43532,020101_43532,020105_43532,020112_43532,020114_43532,020307_43532,020408_43532,020601_43532,020710_43532,020714_43532,020801_43532,021009_43532,02110101_43532,02110102_43532,021107_43532,021111_43532,021120_43532,021308_43532,021404_43532,021405_43532,02140601_43532,02140603_43532,02140604_43532,02140701_43532,021408_43532,022406_43532,0225_43532,03010105_43532,03010108_43532,05011701_43532,05011804_43532,0503_43532\",\"orderId\":\"taw-773336807860705\",\"f113001\":\"04.03.0013,04.01.0008,04.03.0017\",\"f9913\":\"6\",\"f508002\":\"R11Plusk\",\"f806001\":\"9\",\"f508001\":\"OPPO\",\"f9914\":\"\",\"f806002\":\"0\",\"f9915\":\"\",\"f806003\":\"7\",\"f830101\":\"null,60505_43532,61071_43532\",\"f9916\":\"02.24.0001&2,02.01.0003&2,02.01.0008&4,02.06&4\",\"f806004\":\"1\",\"f830102\":\"null,22412_12918,22412_12918\",\"f9917\":\"02.24.0001&1,02.01.0003&1,02.01.0008&1,02.06&1\",\"f830103\":\"null,07.10.0004_07.10.0004,07.10.0004_07.10.0004\",\"f9918\":\"02.24.0001&1,02.01.0003&1,02.01.0008&1,02.06&1\",\"f830104\":\"null\",\"f9919\":\"02.24.0001&8,02.01.0003&8,02.01.0008&6,02.06&6\",\"f502001\":\"6\",\"f502002\":\"5\",\"f611001\":\"2\",\"f9902\":\"3692,3108,8674,5083,7607,90,7856,11698,1220,4582,10099,2515,8852,64,4011,7589,2774,3726,2750,2753,7860,3895,7422,2773,8604,2754,429,5891,5409,1165,1490,1081,7751,2187\",\"f9903\":\"11\",\"f9906\":\"\",\"f9907\":\"\",\"f9908\":\"0\",\"f770501\":\"1\",\"f606002\":\"1\",\"f606001\":\"1\",\"f102001\":\"02.01.0009\",\"f9935\":\"3692,3108,8674,5083,7607,90,7856,11698,1220,4582,10099,2515,8852,64,4011,7589,2774,3726,2750,2753,7860,3895,7422,2773,8604,2754,429,5891,5409,1165,1490,1081,7751,2187\",\"f9936\":\"3692,5083,7607,90,7856,1220,4582,10099,8852,64,4011,7589,3726,2750,2753,7860,3895,7422,429,5409,1165,1490,7751,2187\",\"f830001\":\"60505,61071\",\"f9937\":\"3108,11698,2515,8604,1081\",\"f830002\":\"22412,22412\",\"f830003\":\"07.10.0004,07.10.0004\",\"f830004\":\"\",\"f9930\":\"2\",\"f9931\":\"-1\",\"f301001\":\"12501\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f108001\":\"330817\",\"advertId\":\"43532\",\"f807002\":\"0\",\"f9924\":\"02.01.0008,02.06\",\"f9803\":\"34-2,43-1\",\"f807001\":\"10\",\"f507001\":\"3\",\"f9804\":\"18312,59543,66568,43870,3124,63802\",\"f807004\":\"1\",\"f830111\":\"null\",\"f807003\":\"7\",\"f830112\":\"null\",\"f9927\":\"0\",\"f830113\":\"null\",\"f9928\":\"0\",\"f830114\":\"null\",\"f9929\":\"1\",\"f770401\":\"0\",\"f9921\":\"\",\"f9922\":\"\",\"f9801\":\"10540,15567,15743,18505,9982\",\"f770402\":\"0\",\"f9923\":\"02.01.0003\",\"f9802\":\"5\",\"f604002\":\"6\",\"f604001\":\"6\",\"f501001\":\"Android\",\"f610001\":\"0\",\"f303001\":\"28\",\"consumerId\":\"20389566145\",\"f406001\":\"0\",\"f830011\":\"{0=, 2=, 3=}\",\"f830012\":\"{0=, 2=, 3=}\",\"f830013\":\"{0=, 2=, 3=}\",\"f830014\":\"{0=, 2=, 3=}\",\"f115001\":\"0\",\"f808002\":\"0_0,02.01.0003_0,02.01.0008_0,02.06_0,02.24.0001_0\",\"f506001\":\"1\",\"f121003\":\"null\",\"f8807\":\"1\",\"f808001\":\"0_1,02.01.0003_1,02.01.0008_1,02.06_1,02.24.0001_1\",\"f8803\":\"1\",\"f605001\":\"1\",\"f605002\":\"1\",\"f302001\":\"12501\"}";


        Map<String, String> map = (Map)JSON.parse(str);

        System.out.println(model.predict(map));

    }
    public static void testDmp() throws Exception {
        String key = "mid_ftrl_fm_ctr_v010";
        String key1 = "mid_ftrl_fm_ctr_v711";
        String key2 = "mid_ftrl_fm_ctr_v712";
        String key3 = "mid_ftrl_fm_ctr_v713";

        JedisConfig jcOnline = new JedisConfig();
        jcOnline.setIp("r-bp18da0abeaddc94285.redis.rds.aliyuncs.com");
        jcOnline.setPassWord("hteK73Zxx3ji9LGCy2jBAZDJ6");
        jcOnline.setPort(6379);
        JedisUtil juOnline = new JedisUtil(jcOnline);

        /*
        FM model = StdModelSave.getADXModelByKeyFromJedis(key);
        FM model1 = StdModelSave.getADXModelByKeyFromJedis(key1);
        FM model2 = StdModelSave.getADXModelByKeyFromJedis(key2);
        */

        FM model = StdModelSave.getModelByKeyFromJedis(key, juOnline);
        FM model1 = StdModelSave.getModelByKeyFromJedis(key1, juOnline);
        FM model2 = StdModelSave.getModelByKeyFromJedis(key2, juOnline);
        FM model3 = StdModelSave.getModelByKeyFromJedis(key3, juOnline);


        String str="{\"f608001\":\"0\",\"f104001\":\"89505\",\"f603002\":\"1\",\"f603001\":\"1\",\"f110001\":\"0\",\"f505001\":\"\",\"f770102\":\"1\",\"f809001\":\"1\",\"f809002\":\"0\",\"f201001\":\"69636\",\"f660001\":\"17\",\"f609001\":\"1\",\"f804004\":\"1\",\"f804003\":\"3\",\"f804002\":\"0\",\"f804001\":\"3\",\"f810001\":\"1\",\"f770001\":\"07.14.0051\",\"f810002\":\"0\",\"f306001\":\"2\",\"chargeType\":\"1\",\"f206001\":\"540\",\"f504001\":\"\",\"f601001\":\"1\",\"f601002\":\"1\",\"f607001\":\"0\",\"f206002\":\"538\",\"f811001\":\"102\",\"f403004\":\"0\",\"f805001\":\"3\",\"f805002\":\"0\",\"f805003\":\"3\",\"f805004\":\"1\",\"f9940\":\"2,13,25,37,49,61,73,85,97,109,121,133,145,157,169\",\"f9941\":\"|||5337|||5337|||5337|5337||5337\",\"f9942\":\"0.618099,0.526595,0.465138,0.358335,0.530794,0.503094,0.525437,0.370032\",\"f9943\":\"5337\",\"f9702\":\"0\",\"f9944\":\"5337\",\"f602001\":\"1\",\"f205002\":\"197\",\"f205001\":\"196\",\"f701001\":\"1061178\",\"f811002\":\"102\",\"f404003\":\"workother\",\"f106001\":\"22597\",\"f660201\":\"0\",\"f112001\":\"\",\"f101001\":\"61178\",\"f701002\":\"1069636\",\"f9607\":\"null\",\"f9608\":\"null\",\"f9609\":\"null\",\"f503001\":\"4509\",\"time\":\"20200406160207\",\"f9601\":\"null\",\"f9602\":\"null\",\"f602002\":\"1\",\"f9603\":\"null\",\"orderId\":\"taw-810035721541023\",\"f113001\":\"04.01.0006,04.03.0013,04.03.0017\",\"f806001\":\"3\",\"f806002\":\"0\",\"f806003\":\"3\",\"f830101\":\"null\",\"f9916\":\"02.24.0001&2\",\"f806004\":\"1\",\"f830102\":\"null\",\"f9917\":\"02.24.0001&1\",\"f830103\":\"null\",\"f9918\":\"02.24.0001&1\",\"f830104\":\"null\",\"f9919\":\"02.24.0001&8\",\"adxRid\":\"0011d50b4e90e08a9b8795a588d309ff-k8ls9qnq-28499299_1000000000381\",\"f502001\":\"16\",\"f502002\":\"1\",\"f611001\":\"1\",\"f9902\":\"5337\",\"f9903\":\"1\",\"f770501\":\"0\",\"f606002\":\"10\",\"f606001\":\"99\",\"f102001\":\"02.24.0001\",\"f9930\":\"0\",\"f9931\":\"-1\",\"f301001\":\"999999\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f108001\":\"326766\",\"advertId\":\"61178\",\"f807002\":\"0\",\"f9924\":\"\",\"f807001\":\"3\",\"f507001\":\"3\",\"f807004\":\"1\",\"f830111\":\"null\",\"f807003\":\"3\",\"f830112\":\"null\",\"f9927\":\"0\",\"f830113\":\"null\",\"f9928\":\"0\",\"f830114\":\"null\",\"f9929\":\"0\",\"f770401\":\"0\",\"f9921\":\"\",\"f9922\":\"\",\"f770402\":\"0\",\"f9923\":\"\",\"f9802\":\"0\",\"f604002\":\"1\",\"f604001\":\"1\",\"f501001\":\"unknow\",\"f610001\":\"0\",\"f303001\":\"1\",\"f114001\":\"119\",\"consumerId\":\"1190868170313727\",\"f114002\":\"227\",\"f406001\":\"1\",\"f830011\":\"null\",\"f830012\":\"null\",\"f830013\":\"null\",\"f830014\":\"null\",\"f115001\":\"0\",\"f808002\":\"0_0,02.24.0001_0\",\"f121003\":\"null\",\"f8807\":\"1\",\"f808001\":\"0_1,02.24.0001_1\",\"f8803\":\"1\",\"f605001\":\"99\",\"f605002\":\"10\",\"f302001\":\"-1\"}\n";


        Map<String, String> map = (Map)JSON.parse(str);

        System.out.println("v010:" + model.getUpdateTime() + " ,model_ps= " + model.getModelId() + " ,pre_ctr:" + model.predict(map));
        System.out.println("v711:" + model1.getUpdateTime() + " ,model1_ps= " + model1.getModelId() + " ,pre_ctr:" + model1.predict(map));
        System.out.println("v712:" + model2.getUpdateTime() + " ,model2_ps= " + model2.getModelId() + " ,pre_ctr:" + model2.predict(map));
        System.out.println("v713:" + model3.getUpdateTime() + " ,model3_ps= " + model3.getModelId() + " ,pre_ctr:" + model3.predict(map));

    }

    public static void testAdx11() {

        JedisConfig jcOnline = new JedisConfig();
        jcOnline.setIp("r-bp18da0abeaddc94285.redis.rds.aliyuncs.com");
        jcOnline.setPassWord("hteK73Zxx3ji9LGCy2jBAZDJ6");
        jcOnline.setPort(6379);

        JedisUtil juOnline = new JedisUtil(jcOnline);
        JedisConfig jcOffline = new JedisConfig();

        jcOffline.setIp("47.111.157.152");
        jcOffline.setPassWord("duiba123");
        jcOffline.setPort(6379);
        JedisUtil juOffline = new JedisUtil(jcOffline);


        try {

            /*
            String key = "adx_mid_ftrl_fm_ctr_v002";
            String key2 = "adx_mid_ftrl_fm_ctr_v003";
            FM model = StdModelSave.getADXModelByKeyFromJedis(key, juOffline);
            System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
            System.out.println("model=" + key + ",model.UpdateTime = " + model.getUpdateTime() + ",model_ps = " + model.getModelId());

            StdModelSave.saveADXModelByKeyToJedis(key2, model, juOffline);
            FM modelTest = StdModelSave.getADXModelByKeyFromJedis(key2, juOffline);
            System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
            System.out.println("modelTest=" + key2 + ",model.UpdateTime = " + modelTest.getUpdateTime() + ",model_ps = " + modelTest.getModelId());
            */

            String key = "adx_mid_ftrl_fm_ctr_v005";
            String key2 = "adx_mid_ftrl_fm_ctr_v005";
            FM model = StdModelSave.getADXModelByKeyFromJedis(key, juOnline);
            //FM model = StdModelSave.getModelByKeyFromJedis(key2, juOnline);
            System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
            System.out.println("model=" + key + ",model.UpdateTime = " + model.getUpdateTime() + ",model_ps = " + model.getModelId());

            //StdModelSave.saveModelByKeyToJedis(key2, model, juOffline);
            //FM modelTest = StdModelSave.getModelByKeyFromJedis(key2, juOffline);
            StdModelSave.saveADXModelByKeyToJedis(key2, model, juOffline);
            FM modelTest = StdModelSave.getADXModelByKeyFromJedis(key2, juOffline);
            System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
            System.out.println("modelTest=" + key2 + ",model.UpdateTime = " + modelTest.getUpdateTime() + ",model_ps = " + modelTest.getModelId());


        } catch (Exception e) {
            e.printStackTrace();
        }


    }


    public static void testAdxWeight() throws Exception {

        JedisConfig jcOnline = new JedisConfig();
        jcOnline.setIp("r-bp18da0abeaddc94285.redis.rds.aliyuncs.com");
        jcOnline.setPassWord("hteK73Zxx3ji9LGCy2jBAZDJ6");
        jcOnline.setPort(6379);
        JedisUtil juOnline = new JedisUtil(jcOnline);


        String key = "adx_mid_ftrl_fm_ctr_v006";
        String str="{\"f6050010\":\"0\",\"f4010050\":\"HUAWEI\",\"f3010120\":\"1\",\"f2010030\":\"0\",\"f5020070\":\"22\",\"f6010070\":\"晋中\",\"f7020011\":\"0\",\"f6020050\":\"129&13\",\"f6010100\":\"1\",\"f2010020\":\"0\",\"f5020060\":\"0\",\"f3010010\":\"10972\",\"f5020101\":\"1\",\"f5020103\":\"0\",\"f5020102\":\"1\",\"f5020105\":\"1000\",\"f5020104\":\"1000\",\"f5020106\":\"1000\",\"f4010110\":\"1.2488125E7\",\"f4010070\":\"0\",\"f5020090\":\"0\",\"f2010010\":\"999\",\"f3010060\":\"720\",\"f5020010\":\"22\",\"f6010050\":\"中国\",\"f3010070\":\"1280\",\"f6050020\":\"40016,40026,40027,40029\",\"f6020070\":\"129&山西\",\"f4010060\":\"FIG-AL10\",\"f5020080\":\"0\",\"f1010020\":\"19\",\"f5010050\":\"95b0c59293d965aaaf672a348454ebf0\",\"f4010100\":\"4449421.5\",\"f6020080\":\"129&晋中\",\"f4010010\":\"Dalvik/2.1.0 (Linux; U; Android 9; FIG-AL10 Build/HUAWEIFIG-AL10)\",\"f7030011\":\"0\",\"f4010091\":\"0\",\"f5020030\":\"0\",\"f1010010\":\"129\",\"f7010010\":\"021111,0501101205,05011313,0503\",\"f7010011\":\"1\",\"f5010060\":\"9\",\"f3020000\":\"0\",\"f6020090\":\"129&平遥县\",\"f4010121\":\"12\",\"f5030101\":\"129&1000\",\"f5030102\":\"999&1000\",\"f5030103\":\"10972&1000\",\"f4010080\":\"2\",\"f5020020\":\"0\",\"f6010020\":\"com.hunting.matrix_callershow\",\"f6020010\":\"\",\"f5010070\":\"0\",\"f4010122\":\"1\",\"f4010031\":\"80\",\"f4010030\":\"1401\",\"f4010032\":\"2\",\"f6010010\":\"e3742d6c\",\"f5020050\":\"0\",\"f6010090\":\"10011001110\",\"f6020020\":\"\",\"f5010080\":\"9\",\"f4010020\":\"218.26.54.202\",\"f6020030\":\"0\",\"f5020040\":\"22\",\"f3010030\":\"0\",\"f5010090\":\"0\",\"f5010010\":\"O\"}\n";

        FM model = StdModelSave.getADXModelByKeyFromJedis(key, juOnline);
        Map<String, String> map = (Map)JSON.parse(str);
        Map ret = model.featureParamsTest(map);

        System.out.println("model:" + model.getUpdateTime() + " ,model_ps= " + model.getModelId() + " ,pre_ctr:" + model.predict(map));
        System.out.println("model params:" + JSON.toJSONString(model.getParamsDo()));
        System.out.println("model params:" + JSON.toJSONString(ret));

    }


    public static void testAdxCoder() throws Exception {

        JedisConfig jcOnline = new JedisConfig();
        jcOnline.setIp("r-bp18da0abeaddc94285.redis.rds.aliyuncs.com");
        jcOnline.setPassWord("hteK73Zxx3ji9LGCy2jBAZDJ6");
        jcOnline.setPort(6379);
        JedisUtil juOnline = new JedisUtil(jcOnline);
        JedisConfig jcOffline = new JedisConfig();

        jcOffline.setIp("47.111.157.152");
        jcOffline.setPassWord("duiba123");
        jcOffline.setPort(6379);
        JedisUtil juOffline = new JedisUtil(jcOffline);

        String fmKey = "adx_mid_ftrl_fm_ctr_v005";
        FM fmModel = StdModelSave.getADXModelByKeyFromJedis(fmKey, juOnline);

        String key = "adx_launch_pv_coder_dqn_v001";
        CODER model = StdCoderModelSaveBo.getADXModelCoderByKeyFromJedis(key, juOnline);
        System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
        System.out.println("model:"  + key + ",model.UpdateTime = "+ model.getUpdateTime() + " ,model_ps= " + model.getModelId());

        saveAdxModelCoderByKeyToJedis(key, model, juOffline);
        CODER model2 = StdCoderModelSaveBo.getADXModelCoderByKeyFromJedis(key, juOffline);
        System.out.println("model2:"  + key + ",model2.UpdateTime = "+ model2.getUpdateTime() + " ,model2_ps= " + model2.getModelId());


        //2 TF本地模型获取  缓存
        //LocalTFModel ltfModel = new LocalTFModel();
        //ltfModel.loadModel("C:\\Users\\wjw\\Desktop\\mid-adx-click-value-dqn-v001");

/*
        //3 创意特征对象List
        List<AdxIdeaFeatureDo> ideaFeatureList = new ArrayList<>();
        AdxIdeaFeatureDo i1 = new AdxIdeaFeatureDo();
        i1.setIdeaId(1562L);
        i1.setIdeaPicNum(1);
        ideaFeatureList.add(i1);

        AdxIdeaFeatureDo i2 = new AdxIdeaFeatureDo();
        i2.setIdeaId(12620L);
        i2.setIdeaPicNum(1);
        i2.setIdeaPicW1(60);
        i2.setIdeaPicH1(60);
        ideaFeatureList.add(i2);

        AdxIdeaFeatureDo i3 = new AdxIdeaFeatureDo();
        i3.setIdeaId(12562L);
        ideaFeatureList.add(i3);

        AdxIdeaFeatureDo i4 = new AdxIdeaFeatureDo();
        i4.setIdeaId(3L);
        ideaFeatureList.add(i4);

        AdxIdeaFeatureDo i5 = new AdxIdeaFeatureDo();
        i5.setIdeaId(12563L);
        ideaFeatureList.add(i5);

        AdxIdeaFeatureDo i6 = new AdxIdeaFeatureDo();
        i6.setIdeaId(12561L);
        ideaFeatureList.add(i6);

        AdxIdeaFeatureDo i7 = new AdxIdeaFeatureDo();
        i7.setIdeaId(12L);
        ideaFeatureList.add(i7);

        AdxFeatureDo adxFeatureDo = new AdxFeatureDo();
        adxFeatureDo.setAreaCode(101L);
        adxFeatureDo.setImeiDayBidTimes(null);

        AdxIdeaRcmdRequestDo rcmdRequestDo = new AdxIdeaRcmdRequestDo();
        rcmdRequestDo.setIdeaFeatureList(ideaFeatureList);
        rcmdRequestDo.setAdxFeatureDo(adxFeatureDo);
        rcmdRequestDo.setFmModel(fmModel);
        rcmdRequestDo.setCoderModel(model);
        rcmdRequestDo.setLtfModel(ltfModel);

        AdxIdeaRcmdResultDo ret = getIdeaRcmd(rcmdRequestDo);
        System.out.println("RET:"  + JSON.toJSONString(ret));

*/
    }


    public static void testAdxFilter() throws Exception {

        JedisConfig jcOnline = new JedisConfig();
        jcOnline.setIp("r-bp18da0abeaddc94285.redis.rds.aliyuncs.com");
        jcOnline.setPassWord("hteK73Zxx3ji9LGCy2jBAZDJ6");
        jcOnline.setPort(6379);
        JedisUtil juOnline = new JedisUtil(jcOnline);
        JedisConfig jcOffline = new JedisConfig();

        jcOffline.setIp("47.111.157.152");
        jcOffline.setPassWord("duiba123");
        jcOffline.setPort(6379);
        JedisUtil juOffline = new JedisUtil(jcOffline);

        String fmKey = "adx_mid_ftrl_fm_ctr_v005";
        FM fmModel = StdModelSave.getADXModelByKeyFromJedis(fmKey, juOnline);

        String key = "adx_launch_pv_coder_dqn_v001";
        CODER codeModel = StdCoderModelSaveBo.getADXModelCoderByKeyFromJedis(key, juOnline);
        System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
        System.out.println("codeModel:"  + key + ",codeModel.UpdateTime = "+ codeModel.getUpdateTime() + " ,codeModel_ps= " + codeModel.getModelId());

        saveAdxModelCoderByKeyToJedis(key, codeModel, juOffline);
        CODER codeModel2 = StdCoderModelSaveBo.getADXModelCoderByKeyFromJedis(key, juOffline);
        System.out.println("codeModel2:"  + key + ",codeModel2.UpdateTime = "+ codeModel2.getUpdateTime() + " ,codeModel2_ps= " + codeModel2.getModelId());


        //2 TF本地模型获取  缓存
        LocalTFModel ltfModel = new LocalTFModel();
        ltfModel.loadModel("C:\\Users\\wjw\\Desktop\\mid-adx-launch-pv-dqn-v001");

        //3
        AdxFeatureDo adxFeatureDo = new AdxFeatureDo();
        adxFeatureDo.setGroupId(129L);
        adxFeatureDo.setResourceId(999L);
        adxFeatureDo.setIdeaId(9983L);
        adxFeatureDo.setIdeaPicNum(1);
        adxFeatureDo.setAreaCode(3301L);


        //4.
        String str1 = "{\"currentPreValue\":0.07,\"historyImeiBid\":7,\"historyImeiExp\":0,\"historyImeiClick\":0,\"groupId\":157,\"ideaDayStats\":{\"advertClick\":8000000,\"advertConsume\":60000,\"advertLaunch\":90000000000,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},\"ideaHourStats\":{},\"ideaId\":1953,\"minRoi\":1.1,\"preIntervalDayStats\":{1:{},2:{},3:{},4:{},5:{},6:{}},\"preIntervalHourStats\":{1:{},2:{},3:{},4:{},5:{},6:{}},\"resoPreIntervalDayStats\":{0:{\"advertClick\":8000000,\"advertConsume\":60000,\"advertLaunch\":90000000000,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},1:{\"advertClick\":8000000,\"advertConsume\":60000,\"advertLaunch\":90000000000,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},2:{\"advertClick\":8000000,\"advertConsume\":60000,\"advertLaunch\":90000000000,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},3:{\"advertClick\":8000000,\"advertConsume\":60000,\"advertLaunch\":90000000000,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},4:{\"advertClick\":8000000,\"advertConsume\":60000,\"advertLaunch\":90000000000,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},5:{\"advertClick\":8000000,\"advertConsume\":60000,\"advertLaunch\":90000000000,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},6:{\"advertClick\":8000000,\"advertConsume\":60000,\"advertLaunch\":90000000000,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},7:{},8:{},9:{},10:{},11:{},12:{},13:{},14:{},15:{}},\"resoPreIntervalHourStats\":{0:{\"advertClick\":8000000,\"advertConsume\":60000,\"advertLaunch\":90000000000,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},1:{\"advertClick\":8000000,\"advertConsume\":60000,\"advertLaunch\":90000000000,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},2:{\"advertClick\":8000000,\"advertConsume\":60000,\"advertLaunch\":90000000000,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},3:{\"advertClick\":8000000,\"advertConsume\":60000,\"advertLaunch\":90000000000,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},4:{\"advertClick\":8000000,\"advertConsume\":60000,\"advertLaunch\":90000000000,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},5:{\"advertClick\":8000000,\"advertConsume\":60000,\"advertLaunch\":90000000000,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},6:{\"advertClick\":8000000,\"advertConsume\":60000,\"advertLaunch\":90000000000,\"adxConsume\":400000000000,\"bid\":6000,\"bidSuc\":5434,\"click\":3000,\"exp\":4000,\"preClickValue\":567000.0},7:{},8:{},9:{},10:{},11:{},12:{},13:{},14:{},15:{}},\"resourceId\":917,\"testRate\":{1:14,2:13,3:74}}";
        //AdxFlowInfoDo flowInfoDo1 = new AdxFlowInfoDo();
        AdxFlowInfoDo flowInfoDo1 =  JSONObject.parseObject(str1,AdxFlowInfoDo.class);

        String str2 = "{\"ctrDayInterval\":{},\"ctrHourInterval\":{},\"currentMinRoi\":1.0,\"dayConfident\":false,\"filterMap\":{1:0.0,2:0.9,3:0.9,4:0.9,5:0.0,6:0.0},\"roiDayInterval\":{},\"roiHourInterval\":{}}";
        //AdxFilterInfoDo filterInfoDo1 = new AdxFilterInfoDo();
        AdxFilterInfoDo filterInfoDo1 =  JSONObject.parseObject(str2,AdxFilterInfoDo.class);

        String str3 = "{\"ctrDayInterval\":{0:0.75,1:0.75,2:0.75,3:0.75,4:0.75,5:0.75,6:0.75},\"ctrHourInterval\":{0:0.75,1:0.75,2:0.75,3:0.75,4:0.75,5:0.75,6:0.75},\"currentMinRoi\":1.1,\"dayConfident\":false,\"filterMap\":{0:0.0,1:0.0,2:0.0,3:0.0,4:0.0,5:0.0,6:0.0,7:0.0,8:0.0,9:0.0,10:0.0,11:0.0,12:0.9,13:0.0,14:0.0,15:0.0},\"roiDayInterval\":{0:1.5,1:1.5,2:1.5,3:1.5,4:1.5,5:1.5,6:1.5},\"roiHourInterval\":{0:1.5,1:1.5,2:1.5,3:1.5,4:1.5,5:1.5,6:1.5}}";
        //AdxFilterInfoDo filterInfoDo2 = new AdxFilterInfoDo();
        AdxFilterInfoDo filterInfoDo2 =  JSONObject.parseObject(str3,AdxFilterInfoDo.class);

        FlowFilterRequestDo flowFilterRequestDo = new FlowFilterRequestDo();
        flowFilterRequestDo.setFlowInfo(flowInfoDo1);
        flowFilterRequestDo.setFilterInfo1(filterInfoDo1);
        flowFilterRequestDo.setFilterInfo2(filterInfoDo2);

        flowFilterRequestDo.setCtrFmModel(fmModel);
        flowFilterRequestDo.setLaunchPvCoderModel(codeModel);
        flowFilterRequestDo.setLaunchPvLtfModel(ltfModel);
        flowFilterRequestDo.setAdxFeatureDo(adxFeatureDo);

        flowFilterRequestDo.setLaunchPvLimit(0.8);
        flowFilterRequestDo.setAlgoBidMode(2);

        //FlowFilterResultDo result = AdxFlowFilterAlg.adxFlowFiltering(flowFilterRequestDo);
        FlowFilterResultDo result = LaunchPvFiltering.getLaunchPvFiltering(flowFilterRequestDo);
        System.out.println(JSON.toJSONString(result));


    }



    /**
     * @param modelKey
     * @param CODER
     * @return
     */
    public static void saveAdxModelCoderByKeyToJedis(String modelKey, CODER CODER, JedisUtil redis) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, CODER)) {
            System.out.println("saveModelByKeyToJedis,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = "TAE:ALGBID:MODEL:" + modelKey;
            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(CODER);
            String value2 = StringZIP.zipString(value); //压缩

            redis.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
