package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.vo.ActInterceptFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.ActInterceptStatDo;
import cn.com.duiba.nezha.alg.feature.vo.ActSubTitleNameParseVo;
import cn.com.duiba.nezha.alg.feature.vo.ActTitleFeatureDo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import org.slf4j.LoggerFactory;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by pc on 2019/2/21.
 */
public class ActInterceptFeatureParse {

    public static int F_MAX_SIZE = 64;
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(ActInterceptFeatureParse.class);


    public static Map<String, String> generateFeatureMapStatic(ActInterceptFeatureDo cf) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        try {
            if (cf != null) {

                retMap.put("f201001", DataUtil.Long2String(cf.getAppId()));
                retMap.put("f108002", DataUtil.Long2String(cf.getSlotId()));

                retMap.put("f311001", DataUtil.Long2String(cf.getMainActivityId()));
                retMap.put("f315001", cf.getActivitySkin());

                retMap.put("f4010030", DataUtil.Long2String(cf.getAreaCode()));

                /**
                 * 地域解析
                 */
                Long regionLevel = FeatureBaseParse.getRegionLevel(cf.getAreaCode());
                retMap.put("f4010031", DataUtil.Long2String(regionLevel)); // 地区级别（华北/东北/华东/华中/华南/西南/西北/港澳）
                Long tierCityLevel = FeatureBaseParse.getTierCityLevel(cf.getAreaCode());
                retMap.put("f4010032", DataUtil.Long2String(tierCityLevel)); // 城市级别（一线/二线/三线）


                Integer hour = LocalDateUtil.getHour(LocalDateTime.now());
                retMap.put("f502001", DataUtil.Integer2String(hour)); // 竞价请求创建时间-小时

                Integer weekDay = LocalDateUtil.getDayOfWeek(LocalDateTime.now());
                retMap.put("f502002", DataUtil.Integer2String(weekDay)); // 竞价请求创建时间-星期几


                /**
                 * 主活动参与次数
                 */
                retMap.put("f311002", DataUtil.Long2String(cf.getMainActivityJoinTimes()));

                /**
                 * 用户特征
                 */

                Map<String, String> consumerFeatureMap = new HashMap<>();
                if (cf.getConsumerAdFeature() != null) {
                    consumerFeatureMap = (Map<String, String>) JSON.parse(cf.getConsumerAdFeature());
                }


                retMap.put("f608001", consumerFeatureMap.get("f608001"));// DataUtil.Long2String(lastChargeStatus));

                // 设备型号
                retMap.put("f504001", consumerFeatureMap.get("f504001"));//  cf.getModel());
                // 设备价格区间
                retMap.put("f505001", consumerFeatureMap.get("f505001"));//  cf.getPriceSection());
                // 网络类型（2G，3G，4G）
                retMap.put("f506001", consumerFeatureMap.get("f506001"));//  cf.getConnectionType());
                // 运营商（中国联通，中国移动，中国电信）
                retMap.put("f507001", consumerFeatureMap.get("f507001"));// cf.getOperatorType());
                // 发券次序，该用户当日发券次数
                retMap.put("f611001", consumerFeatureMap.get("f611001"));//  DataUtil.Long2String(cf.getPutIndex()));


                //20180306
                retMap.put("f9916", consumerFeatureMap.get("f9916"));// getLevel("launch_pv", cf.getUIIds(), cf.getUILaunchPV()));
                retMap.put("f9917", consumerFeatureMap.get("f9917"));//  getLevel("click_pv", cf.getUIIds(), cf.getUIClickPv()));
                retMap.put("f9918", consumerFeatureMap.get("f9918"));//  getLevel("effect_pv", cf.getUIIds(), cf.getUIEffectPv()));
                retMap.put("f9919", consumerFeatureMap.get("f9919"));// getLevel("score", cf.getUIIds(), cf.getUIScore()));


                retMap.put("f9927", consumerFeatureMap.get("f9927"));// countFeatures(cf.getUICtr()) + "");
                retMap.put("f9928", consumerFeatureMap.get("f9928"));// countFeatures(cf.getUICvr()) + "");
                retMap.put("f9929", consumerFeatureMap.get("f9929"));// countFeatures(cf.getUUnICtr()) + "");
                retMap.put("f9930", consumerFeatureMap.get("f9930"));// countFeatures(cf.getUUnICvr()) + "");


                // 20180423，用户行为数据
                retMap.put("f601002", consumerFeatureMap.get("f601002"));//  DataUtil.Long2String(bucket(cf.getDayOrderRank(), dayOrderRankBucket)));
                retMap.put("f602002", consumerFeatureMap.get("f602002"));//  DataUtil.Long2String(bucket(cf.getOrderRank(), orderRankBucket)));
                retMap.put("f603002", consumerFeatureMap.get("f603002"));//  DataUtil.Long2String(bucket(cf.getDayActivityOrderRank(), dayActOrderRankBucket)));
                retMap.put("f604002", consumerFeatureMap.get("f604002"));//  DataUtil.Long2String(bucket(cf.getActivityOrderRank(), orderActRankBucket)));


//                System.out.println("ubpMap="+JSON.toJSONString(ubpMap));
                ///全局
                retMap.put("f809001", consumerFeatureMap.get("f809001"));// getUserBehavioralPreference(0, "ctr", ubpMap, null));
                retMap.put("f809002", consumerFeatureMap.get("f809002"));// getUserBehavioralPreference(0, "cvr", ubpMap, null));

                //行业
                retMap.put("f808001", consumerFeatureMap.get("f808001"));// getUserBehavioralPreference(2, "ctr", ubpMap, null));
                retMap.put("f808002", consumerFeatureMap.get("f808002"));//  getUserBehavioralPreference(2, "cvr", ubpMap, null));

                //统计
                retMap.put("f811001", consumerFeatureMap.get("f811101"));// getUserBehavioralPreference(3, "ctr", ubpMap, null));
                retMap.put("f811002", consumerFeatureMap.get("f811002"));// getUserBehavioralPreference(3, "cvr", ubpMap, null));


            }

        } catch (Exception e) {

            logger.error("ActFeatureParse.generateFeatureMapStatic error:" + e);
        }

        return retMap;
    }

    public static Map<String, String> generateFeatureMapPrizeId(Long activitySubTitlePrizeId) {

        Map<String, String> retMap = new HashMap<>(8);
        try {
            if (activitySubTitlePrizeId != null) {
                retMap.put("f322001", DataUtil.Long2String(activitySubTitlePrizeId));
            }
        } catch (Exception e) {
            logger.error("ActFeatureParse.generateFeatureMapPrizeId error:", e);

        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(ActInterceptFeatureDo cf, ActInterceptFeatureDo staticCf, Double rpm) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        try {
            if (cf != null) {
                retMap.put("f301001", DataUtil.Long2String(cf.getActivityId()));

                // 返回拦截活动rpm
                retMap.put("f301002", DataUtil.Long2String(getRpmLevel(rpm)));


            }
        } catch (Exception e) {
            logger.error("ActFeatureParse.generateFeatureMapDynamic error:", e);

        }
        return retMap;
    }


    public static Long getRpmLevel(Double rpm) {
        Long ret = null;
        if (rpm != null) {

            if (rpm < 5) {
                ret = Math.round(rpm * 10);
            } else {
                ret = Math.round(rpm*2)+ 40;
            }
        }

        return ret;
    }


    //测试
    public static void main(String[] args) {

        ActInterceptFeatureDo actFeatureDo1 = new ActInterceptFeatureDo();
        actFeatureDo1.setActivityId(1L);
        actFeatureDo1.setMainActivityId(2L);
        actFeatureDo1.setAppId(3L);
        actFeatureDo1.setSlotId(5L);
        actFeatureDo1.setAreaCode(4L);
        actFeatureDo1.setMainActivityJoinTimes(3L);

        actFeatureDo1.setDsm2A(6L);
        Map<String,String> cFeature= new HashMap<>();
        cFeature.put("f608001","11");
        actFeatureDo1.setConsumerAdFeature(JSON.toJSONString(cFeature));

        Map<String, String> staticFeatureMap = ActInterceptFeatureParse.generateFeatureMapStatic(actFeatureDo1);
        Map<String, String> dynamicFeatureMap = ActInterceptFeatureParse.generateFeatureMapDynamic(actFeatureDo1, actFeatureDo1,0.9);
        dynamicFeatureMap.putAll(staticFeatureMap);

        System.out.println(JSON.toJSONString(dynamicFeatureMap));


    }

}