/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.coder;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.coder.FeatureUtil;
import cn.com.duiba.nezha.alg.feature.vo.Feature;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FeatureCoderBase {
    public static int getVectorSize(List<Long> pLenList) {
        Long tmp;
        int ret = 0;
        if (pLenList != null && pLenList.size() > 0 && (tmp = pLenList.get(pLenList.size() - 1)) != null) {
            ret = tmp.intValue();
        }
        return ret;
    }

    public static Set<Long> getId(int fSize, int fId, List<Long> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        HashSet<Long> ret = new HashSet<Long>();
        int pLen = FeatureCoderBase.getVectorSize(pLenList);
        indices.add(pLen + fId);
        ret.add((long)(pLen + fId) + 0L);
        values.add(1.0);
        pLenList.add(0L + (long)pLen + (long)fSize);
        return ret;
    }

    public static Set<Long> getId(int fId) throws Exception {
        HashSet<Long> ret = new HashSet<Long>();
        ret.add((long)fId + 0L);
        return ret;
    }

    public static Set<Long> getIds(int fSize, int pFNums, int[] sFIds, List<Long> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        HashSet<Long> ret = new HashSet<Long>();
        int pLen = FeatureCoderBase.getVectorSize(pLenList);
        if (sFIds != null && sFIds.length > 0) {
            for (int i = 0; i < sFIds.length; ++i) {
                int fId = sFIds[i];
                indices.add(pLen + fId);
                ret.add((long)(pLen + fId) + 0L);
                values.add(1.0 / (double)sFIds.length);
            }
        }
        pLenList.add(0L + (long)pLen + (long)(pFNums * fSize));
        return ret;
    }

    public static Set<Long> getIds(int[] sFIds) throws Exception {
        HashSet<Long> ret = new HashSet<Long>();
        if (sFIds != null && sFIds.length > 0) {
            for (int i = 0; i < sFIds.length; ++i) {
                int fId = sFIds[i];
                ret.add((long)fId + 0L);
            }
        }
        return ret;
    }

    public static Set<Long> getDenseId(String feature, String fStr, int fSize, List<Long> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        int fId = FeatureUtil.getDenseFId(feature, fStr, fSize);
        return FeatureCoderBase.getId(fSize, fId, pLenList, indices, values);
    }

    public static Set<Long> getSubId(String feature, String fStr, int fSize, List<Long> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        int fId = FeatureUtil.getSubFId(feature, fStr, fSize);
        return FeatureCoderBase.getId(fSize, fId, pLenList, indices, values);
    }

    public static Set<Long> getSubId(String feature, String fStr, int fSize) throws Exception {
        int fId = FeatureUtil.getSubFId(feature, fStr, fSize);
        return FeatureCoderBase.getId(fId);
    }

    public static Set<Long> getDenseId(String feature, String fStr, int fSize) throws Exception {
        int fId = FeatureUtil.getDenseFId(feature, fStr, fSize);
        return FeatureCoderBase.getId(fId);
    }

    public static Set<Long> getSubIds(String feature, String fStr, String seq, int fSize, List<Long> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getSubFIds(feature, fStrs, fSize);
        return FeatureCoderBase.getIds(fSize, 1, sFIds, pLenList, indices, values);
    }

    public static Set<Long> getSubIds(String feature, String fStr, String seq, int fSize) throws Exception {
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getSubFIds(feature, fStrs, fSize);
        return FeatureCoderBase.getIds(sFIds);
    }

    public static Set<Long> getHashSubId(String feature, String fStr, int fSize, int pNums, List<Long> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        HashSet ret = new HashSet();
        int pLen = FeatureCoderBase.getVectorSize(pLenList);
        int[] sFIds = FeatureUtil.getHashSubFId(feature, fStr, fSize, pNums);
        return FeatureCoderBase.getIds(fSize, pNums, sFIds, pLenList, indices, values);
    }

    public static Set<Long> getHashSubId(String feature, String fStr, int fSize, int pNums) throws Exception {
        HashSet ret = new HashSet();
        int[] sFIds = FeatureUtil.getHashSubFId(feature, fStr, fSize, pNums);
        return FeatureCoderBase.getIds(sFIds);
    }

    public static Set<Long> getHashSubIds(String feature, String fStr, String seq, int fSize, int pNums, List<Long> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        HashSet ret = new HashSet();
        int pLen = FeatureCoderBase.getVectorSize(pLenList);
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getHashSubFIds(feature, fStrs, fSize, pNums);
        return FeatureCoderBase.getIds(fSize, pNums, sFIds, pLenList, indices, values);
    }

    public static Set<Long> getHashSubIds(String feature, String fStr, String seq, int fSize, int pNums) throws Exception {
        HashSet ret = new HashSet();
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getHashSubFIds(feature, fStrs, fSize, pNums);
        return FeatureCoderBase.getIds(sFIds);
    }

    public static Set<Long> getDictSubId(String feature, String fStr, int fSize, List<Long> pLenList, List<Integer> indices, List<Double> values, Map<String, Long> fDict) throws Exception {
        int fId = FeatureUtil.getDictSubFId(feature, fStr, fSize, fDict);
        return FeatureCoderBase.getId(fSize, fId, pLenList, indices, values);
    }

    public static Set<Long> getDictSubId(String feature, String fStr, int fSize, Map<String, Long> fDict) throws Exception {
        int fId = FeatureUtil.getDictSubFId(feature, fStr, fSize, fDict);
        return FeatureCoderBase.getId(fId);
    }

    public static Set<Long> getDictSubIds(String feature, String fStr, String seq, int fSize, List<Long> pLenList, List<Integer> indices, List<Double> values, Map<String, Long> fDict) throws Exception {
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getDictSubFIds(feature, fStrs, fSize, fDict);
        return FeatureCoderBase.getIds(fSize, 1, sFIds, pLenList, indices, values);
    }

    public static Set<Long> getDictSubIds(String feature, String fStr, String seq, int fSize, Map<String, Long> fDict) throws Exception {
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getDictSubFIds(feature, fStrs, fSize, fDict);
        return FeatureCoderBase.getIds(sFIds);
    }

    public static Feature toFeature(List<Integer> indices, List<Double> values, List<Long> pLenList, List<String> fields) throws Exception {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{indices, values, pLenList})) {
            throw new Exception("AssertUtil.isAnyEmpty(indices,values,pLenList), input invalid");
        }
        if (values.size() != indices.size()) {
            throw new Exception("values.size()!=pLenList.size(), input invalid");
        }
        int[] indices2 = new int[indices.size()];
        double[] values2 = new double[values.size()];
        String[] fields2 = new String[fields.size()];
        for (int i = 0; i < indices.size(); ++i) {
            indices2[i] = indices.get(i);
            values2[i] = values.get(i);
            fields2[i] = fields.get(i);
        }
        int pLen = FeatureCoderBase.getVectorSize(pLenList);
        return new Feature(pLen, indices2, values2, fields2);
    }

    public static Feature toFeature(List<Integer> indices, List<Double> values, List<String> fields, int size) throws Exception {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{indices, values, fields})) {
            throw new Exception("AssertUtil.isAnyEmpty(indices,values,pLenList), input invalid");
        }
        if (values.size() != indices.size()) {
            throw new Exception("values.size()!=pLenList.size(), input invalid");
        }
        int[] indices2 = new int[indices.size()];
        double[] values2 = new double[values.size()];
        String[] fields2 = new String[fields.size()];
        for (int i = 0; i < indices.size(); ++i) {
            indices2[i] = indices.get(i);
            values2[i] = values.get(i);
            fields2[i] = fields.get(i);
        }
        return new Feature(size, indices2, values2, fields2);
    }
}

