package cn.com.duiba.nezha.alg.feature.coder;


import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.CodeResult;
import cn.com.duiba.nezha.alg.feature.vo.FeatureCodeInfo;
import com.alibaba.fastjson.JSON;

import java.lang.reflect.Array;
import java.util.*;

public class FeatureCoder extends FeatureCoderBase {

    private static int F_MAX_SIZE = 64;

    public static Map<String, List<FeatureBaseType>> cache = new HashMap<>();

    public static CodeResult code(List<FeatureBaseType> list, Map<String, String> featureMap) throws Exception {

        CodeResult codeResult = new CodeResult();

        List<Integer> indices = new ArrayList<>(F_MAX_SIZE);
        List<Double> values = new ArrayList<>(F_MAX_SIZE);
        List<String> fields = new ArrayList<>(F_MAX_SIZE);
        List<Long> pLenList = new ArrayList<>(F_MAX_SIZE);
        List<Set<Long>> ret = new ArrayList<>(F_MAX_SIZE);

        for (FeatureBaseType featureBaseType : list) {

            String value = featureMap.getOrDefault(featureBaseType.getName(), null);
            Set<Long> retSub = featureBaseType.code(value, pLenList, indices, values);

            System.out.println("-----------------------");
            System.out.println(featureBaseType.getName());
            System.out.println(featureBaseType.codeType);
            System.out.println(value);
            System.out.println(JSON.toJSONString(retSub));
            System.out.println(values);
            System.out.println(indices);



            ret.add(retSub);
            for (int i = 0; i < retSub.size(); i++) {
                fields.add(featureBaseType.getName());
            }

        }

        codeResult.setFeature(FeatureCoderBase.toFeature(indices, values, pLenList, fields));
        codeResult.setFeatureSet(ret);
        return codeResult;
    }

    public static CodeResult codeOfEachField(List<FeatureBaseType> list, Map<String, String> featureMap) throws Exception {

        CodeResult codeResult = new CodeResult();

        List<Integer> indices = new ArrayList<>(F_MAX_SIZE);
        List<Double> values = new ArrayList<>(F_MAX_SIZE);
        List<String> fields = new ArrayList<>(F_MAX_SIZE);
        List<Set<Long>> ret = new ArrayList<>(F_MAX_SIZE);

        Map<String, Map<Long, Double>> fieldFeatureMap = new HashMap<>();

        for (FeatureBaseType featureBaseType : list) {

            String value = featureMap.getOrDefault(featureBaseType.getName(), null);
            Set<Long> retSub = featureBaseType.code(value);
            ret.add(retSub);
            List<Long> retSubList = new ArrayList<>(retSub);

            Map<Long, Double> subFiledFeatureMap = new HashMap<>();
            for (int i = 0; i < retSub.size(); i++) {
                indices.add(retSubList.get(i).intValue());
                values.add(1.0 / retSub.size());
                fields.add(featureBaseType.getName());


                Double fValue = 1.0 / retSub.size();

//                if (featureBaseType.codeType == 99) {
//                    fValue = Double.valueOf(value);
//                }

                subFiledFeatureMap.put(retSubList.get(i).intValue() + 0L, fValue);


            }

            fieldFeatureMap.put(featureBaseType.getName(), subFiledFeatureMap);
        }

        codeResult.setFeature(FeatureCoderBase.toFeature(indices, values, fields, 10000 * 1000));
        codeResult.setFeatureSet(ret);
        codeResult.setFieldFeatureMap(fieldFeatureMap);
        return codeResult;
    }


    public static Map<String, Set<String>> getFeatures(List<FeatureBaseType> list, Map<String, String> featureMap) throws Exception {
        Map<String, Set<String>> ret = new HashMap<>();

        for (FeatureBaseType featureBaseType : list) {

            String value = featureMap.get(featureBaseType.getName());

            Set<String> retSub = featureBaseType.parseFeatureValues(value);

            ret.put(featureBaseType.getName(), retSub);
        }
        return ret;
    }

    public static void main(String[] args) {
        Map<String, String> featureMap = new HashMap<>();
        featureMap.put("f101001", "3");
        featureMap.put("f101002", "1,2,");
        featureMap.put("f305001", "8");
        featureMap.put("f501001", "UNKONWN");
        featureMap.put(null, "2");


        FeatureBaseType featureBaseType1 = new FeatureBaseType();
        featureBaseType1.setCodeType(10);
        featureBaseType1.setName("f101001");
        featureBaseType1.setSeq(",");

        FeatureBaseType featureBaseType2 = new FeatureBaseType();
        featureBaseType2.setCodeType(11);
        featureBaseType2.setName("f101002");
        featureBaseType2.setSeq(",");


        List<FeatureBaseType> list = Arrays.asList(featureBaseType1, featureBaseType2);

        System.out.println(JSON.toJSONString(featureMap));
        try {
            String a = null;
            String b = null;
            System.out.println(a + b);


        } catch (Exception e) {

        }


    }

}
