package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.vo.ActSubTitleNameParseVo;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import com.alibaba.fastjson.JSON;
import org.slf4j.LoggerFactory;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by pc on 2019/2/21.
 */
public class FeatureBaseParse {

    public static int F_MAX_SIZE = 64;
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(FeatureBaseParse.class);

    public static Integer[] HUABEI_REGION = {80, 11, 12, 13, 14, 15};
    public static Integer[] DONGBEI_REGION = {81, 21, 22, 23};
    public static Integer[] HUADONG_REGION = {82, 31, 32, 33, 34, 35, 36, 37};
    public static Integer[] HUAZHONG_REGION = {83, 41, 42, 43};
    public static Integer[] HUANAN_REGION = {84, 44, 45, 46};
    public static Integer[] XINAN_REGION = {85, 50, 51, 52, 53, 54};
    public static Integer[] XIBEI_REGION = {86, 61, 62, 63, 64, 65};
    public static Integer[] HMT_REGION = {87, 71, 8100, 8200};

    public static Integer[] FIRST_TIER_CITY = {11, 12, 31, 50, 2101, 3201, 3202, 3205, 3301, 3302, 3702, 4101, 4201, 4301, 4401, 4403, 4419, 5101, 6101};
    public static Integer[] SECOND_TIER_CITY = {1301, 1306, 1401, 2102, 2201, 2301, 3203, 3204, 3206, 3303, 3304, 3306, 3307, 3310, 3401, 3501, 3502, 3505, 3601, 3701, 3706, 3707, 4406, 4413, 4420, 4501, 5201, 5301, 6201, 6501};
    public static Integer[] THIRD_TIER_CITY = {1309, 1303, 1502, 2202, 3207, 3209, 3305, 3412, 3509, 3611, 3708, 3703, 4114, 4110, 4210, 4307, 4306, 4407, 4408, 4601, 5107, 6104, 1304, 1302, 1501, 2306, 3212, 3210, 3403, 3407, 3503, 3607, 3609, 3713, 4103, 4107, 4108, 4206, 4304, 4302, 4452, 4412, 4503, 4602, 5203, 6301, 1310, 1305, 2103, 3208, 3213, 3211, 3411, 3402, 3506, 3604, 3717, 3710, 4113, 4115, 4211, 4205, 4303, 4451, 4405, 4404, 4502, 5106, 5303, 6401};


    public static int[] titleLengthBucket = {2, 4, 6, 8, 10, 100};


    /**
     * 分桶函数1
     * <p>
     * 左开又闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return
     */
    public static Long bucket(Long value, int[] bucketList) {
        long ret = 0;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; i++) {
                int bound = bucketList[i];

                if (value <= bound) {
                    ret = i + 1;
                    break;
                }
            }


        }
        return ret;
    }

    public static ActSubTitleNameParseVo parseActTitleName(String subName) {
        ActSubTitleNameParseVo ret = new ActSubTitleNameParseVo();

        if (subName != null) {
            int size = subName.length();
            Long areaTypeNums = 0L;
            Long festivalTypeNums = 0L;
            Long weekTypeNums = 0L;
            Long typeNums = 0L;

            if (subName.contains("地域")) {
                areaTypeNums = 1L;
                typeNums += 1;
            }

            if (subName.contains("节日")) {
                festivalTypeNums = 1L;
                typeNums += 1;
            }

            if (subName.contains("周几")) {
                weekTypeNums = 1L;
                typeNums += 1;
            }

            Long sizeBucket = bucket(size + 0L, titleLengthBucket);

            ret.setSize(sizeBucket);
            ret.setAreaTypeNums(areaTypeNums);
            ret.setDynamicTypeNums(typeNums);
            ret.setFestivalTypeNums(festivalTypeNums);
            ret.setWeekTypeNums(weekTypeNums);

        }

        return ret;
    }


    public static Integer getTimeStampToHour(Long timeStamp) {
        Integer ret = null;
        if (timeStamp != null) {
            Date date = new Date(timeStamp);

            if (date != null) {
                LocalDateTime localDate = LocalDateUtil.dateToLocal(date);

                if (localDate != null) {
                    ret = LocalDateUtil.getHour(localDate);

                }
            }
        }
        return ret;
    }


    public static Integer getTimeStampToWeekDay(Long timeStamp) {
        Integer ret = null;
        if (timeStamp != null) {
            Date date = new Date(timeStamp);

            if (date != null) {
                LocalDateTime localDate = LocalDateUtil.dateToLocal(date);

                if (localDate != null) {
                    ret = LocalDateUtil.getDayOfWeek(localDate);

                }
            }
        }
        return ret;
    }


    public static Long getStringToTimeStamp() {
        Long ret = null;
        String currentTime = LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());

        if (currentTime != null) {
            ret = LocalDateUtil.getTimeMillis(currentTime, DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());

        }
        return ret;
    }


    public static String getFloat2String(Float src) {
        String ret = null;
        if (src != null) {
            ret = Float.toString(src);
        }
        return ret;

    }


    public static Long getObject2Long(Object src) {
        Long ret = null;
        if (AssertUtil.isNotEmpty(src)) {
            ret = DataUtil.string2Long(String.valueOf(src));
        }
        return ret;

    }


    //该创意+设备号的当天累计曝光次数 f5010040
    public static Long getIdeaExpTime(Long ideaId, Map<Long, Object> expTimeMap) {

        Long ret = null;

        if (AssertUtil.isAllNotEmpty(ideaId, expTimeMap)) {

            Long cnt = getObject2Long(expTimeMap.get(ideaId));
            if (cnt == null || cnt < 1) {
                ret = 0L;
            } else if (cnt <= 7) {
                ret = cnt;
            } else {
                ret = -1L;
            }
        }
        return ret;
    }


    //根据areaCode解析地区级别（华北/东北/华东/华中/华南/西南/西北/港澳） f4010031
    public static Long getRegionLevel(Long areaCode) {

        Long ret = null;

        if (AssertUtil.isNotEmpty(areaCode)) {

            int area = DataUtil.toInt(areaCode);
            if (areaCode >= 1000L && areaCode != 8100L && areaCode != 8200L) {
                area = DataUtil.toInt(Long.valueOf(areaCode / 100));
            }

            if (Arrays.asList(HUABEI_REGION).contains(area)) {
                ret = 80L;
            } else if (Arrays.asList(DONGBEI_REGION).contains(area)) {
                ret = 81L;
            } else if (Arrays.asList(HUADONG_REGION).contains(area)) {
                ret = 82L;
            } else if (Arrays.asList(HUAZHONG_REGION).contains(area)) {
                ret = 83L;
            } else if (Arrays.asList(HUANAN_REGION).contains(area)) {
                ret = 84L;
            } else if (Arrays.asList(XINAN_REGION).contains(area)) {
                ret = 85L;
            } else if (Arrays.asList(XIBEI_REGION).contains(area)) {
                ret = 86L;
            } else if (Arrays.asList(HMT_REGION).contains(area)) {
                ret = 87L;
            }

        }

        return ret;
    }


    //根据areaCode解析城市级别（一线/二线/三线） f4010032
    public static Long getTierCityLevel(Long areaCode) {

        Long ret = null;

        if (AssertUtil.isNotEmpty(areaCode)) {

            int area = DataUtil.toInt(areaCode);

            if (Arrays.asList(FIRST_TIER_CITY).contains(area)) {
                ret = 1L;
            } else if (Arrays.asList(SECOND_TIER_CITY).contains(area)) {
                ret = 2L;
            } else if (Arrays.asList(THIRD_TIER_CITY).contains(area)) {
                ret = 3L;
            }

        }

        return ret;
    }


    // 设备号 当天竞价次数/当天曝光次数
    public static Long getImeiDayTimes(String imei, Long timesLimit, Map<String, Long> timesMap) {

        Long ret = 0L;

        if (AssertUtil.isAllNotEmpty(imei, timesMap)) {

            Long cnt = timesMap.get(imei);

            if (cnt == null || cnt < 1) {
                ret = 0L;
            } else if (cnt <= timesLimit) {
                ret = cnt;
            } else {
                ret = 99L;
            }
        }
        return ret;
    }


    // 资源位id+设备号  当天竞价次数/当天曝光次数
    public static Long getResoDayTimes(Long resoId, String imei, Long timesLimit, Map<String, Long> timesMap) {

        Long ret = 0L;

        if (AssertUtil.isAllNotEmpty(imei, resoId, timesMap)) {

            String statKey = DataUtil.Long2String(resoId) + "_" + imei;
            Long cnt = timesMap.get(statKey);

            if (cnt == null || cnt < 1) {
                ret = 0L;
            } else if (cnt <= timesLimit) {
                ret = cnt;
            } else {
                ret = 99L;
            }
        }
        return ret;
    }


    // 获取列表长度
    public static Integer getLength(String idList) {

        Integer ret = 0;
        if (AssertUtil.isNotEmpty(idList)) {
            String idArr[] = idList.split(",");

            if (AssertUtil.isNotEmpty(idArr)){
                ret = idArr.length;
            }
        }

        return ret;
    }

}