/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.coder;

import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.coder.FeatureCoderBase;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.CodeResult;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FeatureCoder
extends FeatureCoderBase {
    private static int F_MAX_SIZE = 64;
    public static Map tmpMap = new HashMap();

    public static CodeResult code(List<FeatureBaseType> list, Map<String, String> featureMap) throws Exception {
        return FeatureCoder.code(list, featureMap, null);
    }

    public static CodeResult code(List<FeatureBaseType> list, FeatureMapDo featureMap) throws Exception {
        if (featureMap == null) {
            return FeatureCoder.code(list, null, null);
        }
        return FeatureCoder.code(list, featureMap.staticFeatureMap, featureMap.dynamicFeatureMap);
    }

    public static CodeResult code(List<FeatureBaseType> list, Map<String, String> staticFeatureMap, Map<String, String> dynamicFeatureMap) throws Exception {
        CodeResult codeResult = new CodeResult();
        ArrayList<Integer> indices = new ArrayList<Integer>(F_MAX_SIZE);
        ArrayList<Double> values = new ArrayList<Double>(F_MAX_SIZE);
        ArrayList<String> fields = new ArrayList<String>(F_MAX_SIZE);
        ArrayList<Integer> pLenList = new ArrayList<Integer>(F_MAX_SIZE);
        ArrayList<Set<Integer>> ret = new ArrayList<Set<Integer>>(F_MAX_SIZE);
        if (staticFeatureMap == null) {
            staticFeatureMap = tmpMap;
        }
        if (dynamicFeatureMap == null) {
            dynamicFeatureMap = tmpMap;
        }
        for (FeatureBaseType featureBaseType : list) {
            String value = (String)dynamicFeatureMap.get(featureBaseType.getName());
            if (value == null) {
                value = (String)staticFeatureMap.get(featureBaseType.getName());
            }
            Set<Integer> retSub = featureBaseType.code(value, pLenList, indices, values);
            ret.add(retSub);
            for (int i = 0; i < retSub.size(); ++i) {
                fields.add(featureBaseType.getName());
            }
        }
        codeResult.setFeature(FeatureCoderBase.toFeature(indices, values, pLenList, fields));
        codeResult.setFeatureSet(ret);
        return codeResult;
    }

    public static CodeResult codeOfEachField(List<FeatureBaseType> list, Map<String, String> staticFeatureMap, Map<String, String> dynamicFeatureMap) throws Exception {
        CodeResult codeResult = new CodeResult();
        ArrayList<Integer> indices = new ArrayList<Integer>(F_MAX_SIZE);
        ArrayList<Double> values = new ArrayList<Double>(F_MAX_SIZE);
        ArrayList<String> fields = new ArrayList<String>(F_MAX_SIZE);
        ArrayList<Set<Integer>> ret = new ArrayList<Set<Integer>>(F_MAX_SIZE);
        if (staticFeatureMap == null) {
            staticFeatureMap = tmpMap;
        }
        if (dynamicFeatureMap == null) {
            dynamicFeatureMap = tmpMap;
        }
        HashMap<String, Map<Integer, Double>> fieldFeatureMap = new HashMap<String, Map<Integer, Double>>();
        for (FeatureBaseType featureBaseType : list) {
            String value = (String)dynamicFeatureMap.get(featureBaseType.getName());
            if (value == null) {
                value = (String)staticFeatureMap.get(featureBaseType.getName());
            }
            Set<Integer> retSub = featureBaseType.code(value);
            ret.add(retSub);
            ArrayList<Integer> retSubList = new ArrayList<Integer>(retSub);
            HashMap subFieldFeatureMap = new HashMap();
            for (int i = 0; i < retSub.size(); ++i) {
                indices.add((Integer)retSubList.get(i));
                double weight = MathUtil.division((double)1.0, (int)retSub.size(), (int)6);
                values.add(weight);
                fields.add(featureBaseType.getName());
                subFieldFeatureMap.put(retSubList.get(i), weight);
            }
            fieldFeatureMap.put(featureBaseType.getName(), subFieldFeatureMap);
        }
        codeResult.setFeature(FeatureCoderBase.toFeature(indices, values, fields, 10000000));
        codeResult.setFeatureSet(ret);
        codeResult.setFieldFeatureMap(fieldFeatureMap);
        return codeResult;
    }

    public static CodeResult codeOfEachField(List<FeatureBaseType> list, Map<String, String> featureMap) throws Exception {
        return FeatureCoder.codeOfEachField(list, featureMap, null);
    }

    public static CodeResult codeOfEachField(List<FeatureBaseType> list, FeatureMapDo featureMap) throws Exception {
        if (featureMap == null) {
            return FeatureCoder.codeOfEachField(list, null, null);
        }
        return FeatureCoder.codeOfEachField(list, featureMap.staticFeatureMap, featureMap.dynamicFeatureMap);
    }

    public static Map<String, Set<String>> getFeatures(List<FeatureBaseType> list, Map<String, String> featureMap) throws Exception {
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
        for (FeatureBaseType featureBaseType : list) {
            String value = featureMap.get(featureBaseType.getName());
            Set<String> retSub = featureBaseType.parseFeatureValues(value);
            ret.put(featureBaseType.getName(), retSub);
        }
        return ret;
    }

    public static void main(String[] args) {
        HashMap<String, String> featureMap = new HashMap<String, String>();
        featureMap.put("f101001", "16601,18491,23105,24732,7967,300");
        featureMap.put("f101002", "100");
        featureMap.put("f305001", "8");
        featureMap.put("f501001", "UNKONWN");
        featureMap.put(null, "2");
        FeatureBaseType featureBaseType1 = new FeatureBaseType();
        featureBaseType1.setCodeType(11);
        featureBaseType1.setName("f101001");
        featureBaseType1.setDenseLen(10000);
        featureBaseType1.setSubLen(1000000);
        featureBaseType1.setHashNums(1);
        featureBaseType1.setSeq(",");
        FeatureBaseType featureBaseType2 = new FeatureBaseType();
        featureBaseType2.setCodeType(21);
        featureBaseType2.setName("f101002");
        featureBaseType2.setDenseLen(10000);
        featureBaseType2.setSubLen(100000);
        featureBaseType2.setHashNums(1);
        featureBaseType2.setSeq(",");
        List<FeatureBaseType> list = Arrays.asList(featureBaseType1, featureBaseType2);
        System.out.println(JSON.toJSONString(featureMap));
        try {
            Object a = null;
            Object b = null;
            System.out.println(JSON.toJSONString((Object)FeatureCoder.code(list, featureMap)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

