/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.parse.FeatureBaseParse;
import cn.com.duiba.nezha.alg.feature.vo.ActInterceptFeatureDo;
import com.alibaba.fastjson.JSON;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActInterceptFeatureParse {
    public static int F_MAX_SIZE = 64;
    private static final Logger logger = LoggerFactory.getLogger(ActInterceptFeatureParse.class);

    public static Map<String, String> generateFeatureMapStatic(ActInterceptFeatureDo cf) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        try {
            if (cf != null) {
                retMap.put("f201001", DataUtil.Long2String((Long)cf.getAppId()));
                retMap.put("f108002", DataUtil.Long2String((Long)cf.getSlotId()));
                retMap.put("f311001", DataUtil.Long2String((Long)cf.getMainActivityId()));
                retMap.put("f315001", cf.getActivitySkin());
                retMap.put("f4010030", DataUtil.Long2String((Long)cf.getAreaCode()));
                Long regionLevel = FeatureBaseParse.getRegionLevel(cf.getAreaCode());
                retMap.put("f4010031", DataUtil.Long2String((Long)regionLevel));
                Long tierCityLevel = FeatureBaseParse.getTierCityLevel(cf.getAreaCode());
                retMap.put("f4010032", DataUtil.Long2String((Long)tierCityLevel));
                Integer hour = LocalDateUtil.getHour((LocalDateTime)LocalDateTime.now());
                retMap.put("f502001", DataUtil.Integer2String((Integer)hour));
                Integer weekDay = LocalDateUtil.getDayOfWeek((LocalDateTime)LocalDateTime.now());
                retMap.put("f502002", DataUtil.Integer2String((Integer)weekDay));
                retMap.put("f311002", DataUtil.Long2String((Long)cf.getMainActivityJoinTimes()));
                Map consumerFeatureMap = new HashMap();
                if (cf.getConsumerAdFeature() != null) {
                    consumerFeatureMap = (Map)JSON.parse((String)cf.getConsumerAdFeature());
                }
                retMap.put("f608001", (String)consumerFeatureMap.get("f608001"));
                retMap.put("f504001", (String)consumerFeatureMap.get("f504001"));
                retMap.put("f505001", (String)consumerFeatureMap.get("f505001"));
                retMap.put("f506001", (String)consumerFeatureMap.get("f506001"));
                retMap.put("f507001", (String)consumerFeatureMap.get("f507001"));
                retMap.put("f611001", (String)consumerFeatureMap.get("f611001"));
                retMap.put("f9916", (String)consumerFeatureMap.get("f9916"));
                retMap.put("f9917", (String)consumerFeatureMap.get("f9917"));
                retMap.put("f9918", (String)consumerFeatureMap.get("f9918"));
                retMap.put("f9919", (String)consumerFeatureMap.get("f9919"));
                retMap.put("f9927", (String)consumerFeatureMap.get("f9927"));
                retMap.put("f9928", (String)consumerFeatureMap.get("f9928"));
                retMap.put("f9929", (String)consumerFeatureMap.get("f9929"));
                retMap.put("f9930", (String)consumerFeatureMap.get("f9930"));
                retMap.put("f601002", (String)consumerFeatureMap.get("f601002"));
                retMap.put("f602002", (String)consumerFeatureMap.get("f602002"));
                retMap.put("f603002", (String)consumerFeatureMap.get("f603002"));
                retMap.put("f604002", (String)consumerFeatureMap.get("f604002"));
                retMap.put("f809001", (String)consumerFeatureMap.get("f809001"));
                retMap.put("f809002", (String)consumerFeatureMap.get("f809002"));
                retMap.put("f808001", (String)consumerFeatureMap.get("f808001"));
                retMap.put("f808002", (String)consumerFeatureMap.get("f808002"));
                retMap.put("f811001", (String)consumerFeatureMap.get("f811101"));
                retMap.put("f811002", (String)consumerFeatureMap.get("f811002"));
            }
        }
        catch (Exception e) {
            logger.error("ActFeatureParse.generateFeatureMapStatic error:" + e);
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapPrizeId(Long activitySubTitlePrizeId) {
        HashMap<String, String> retMap = new HashMap<String, String>(8);
        try {
            if (activitySubTitlePrizeId != null) {
                retMap.put("f322001", DataUtil.Long2String((Long)activitySubTitlePrizeId));
            }
        }
        catch (Exception e) {
            logger.error("ActFeatureParse.generateFeatureMapPrizeId error:", (Throwable)e);
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(ActInterceptFeatureDo cf, ActInterceptFeatureDo staticCf, Double rpm) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        try {
            if (cf != null) {
                retMap.put("f301001", DataUtil.Long2String((Long)cf.getActivityId()));
                retMap.put("f301002", DataUtil.Long2String((Long)ActInterceptFeatureParse.getRpmLevel(rpm)));
            }
        }
        catch (Exception e) {
            logger.error("ActFeatureParse.generateFeatureMapDynamic error:", (Throwable)e);
        }
        return retMap;
    }

    public static Long getRpmLevel(Double rpm) {
        Long ret = null;
        if (rpm != null) {
            ret = rpm < 5.0 ? Long.valueOf(Math.round(rpm * 10.0)) : Long.valueOf(Math.round(rpm * 2.0) + 40L);
        }
        return ret;
    }

    public static void main(String[] args) {
        ActInterceptFeatureDo actFeatureDo1 = new ActInterceptFeatureDo();
        actFeatureDo1.setActivityId(1L);
        actFeatureDo1.setMainActivityId(2L);
        actFeatureDo1.setAppId(3L);
        actFeatureDo1.setSlotId(5L);
        actFeatureDo1.setAreaCode(4L);
        actFeatureDo1.setMainActivityJoinTimes(3L);
        actFeatureDo1.setDsm2A(6L);
        HashMap<String, String> cFeature = new HashMap<String, String>();
        cFeature.put("f608001", "11");
        actFeatureDo1.setConsumerAdFeature(JSON.toJSONString(cFeature));
        Map<String, String> staticFeatureMap = ActInterceptFeatureParse.generateFeatureMapStatic(actFeatureDo1);
        Map<String, String> dynamicFeatureMap = ActInterceptFeatureParse.generateFeatureMapDynamic(actFeatureDo1, actFeatureDo1, 0.9);
        dynamicFeatureMap.putAll(staticFeatureMap);
        System.out.println(JSON.toJSONString(dynamicFeatureMap));
    }
}

