/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.parse.FeatureBaseParse;
import cn.com.duiba.nezha.alg.feature.vo.DmpFeature;
import cn.com.duiba.nezha.alg.feature.vo.FeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.UserActFeature;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureParse {
    public static int F_MAX_SIZE = 64;
    private static final Logger logger = LoggerFactory.getLogger(FeatureParse.class);
    public static int[] dayOrderRankBucket = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 15, 20, 30, 60, 100};
    public static int[] orderRankBucket = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 15, 20, 25, 30, 35, 50, 70, 100, 200, 500};
    public static int[] dayActOrderRankBucket = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 20};
    public static int[] orderActRankBucket = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 15, 20, 30, 50};
    public static int[] orderGmtIntervelBucket = new int[]{1, 2, 3, 4, 5, 10, 60, 720, 1440, 10080};
    public static int[] orderActGmtIntervelBucket = new int[]{1, 2, 3, 4, 5, 10, 60, 720, 1440, 10080};
    public static double[] userCtrBucket = new double[]{0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    public static double[] userCvrBucket = new double[]{0.01, 0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    public static int[] cntBucket = new int[]{0, 1, 3, 5, 10, 15, 20};
    public static int[] ctrAndCvrLevelBucket = new int[]{1, 4, 8};
    public static int[] priceBucket = new int[]{0, 50, 100, 200, 500, 1000, 2000};
    public static int[] totalPriceBucket = new int[]{0, 100, 500, 1000, 2000, 5000, 10000};
    public static double[] statCtrBucket = new double[]{0.001, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static double[] statCvrBucket = new double[]{0.001, 0.01, 0.02, 0.03, 0.04, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static Map<String, Integer> tradeCodes = new HashMap<String, Integer>(){
        {
            this.put("8", 0);
            this.put("14", 1);
            this.put("15", 2);
            this.put("21", 3);
            this.put("20", 4);
            this.put("3", 5);
            this.put("5", 6);
            this.put("12", 7);
            this.put("2", 8);
            this.put("1", 9);
            this.put("24", 10);
            this.put("6", 11);
            this.put("7", 12);
            this.put("11", 13);
            this.put("13", 14);
            this.put("18", 15);
            this.put("22", 16);
            this.put("4", 17);
            this.put("17", 18);
            this.put("25", 19);
            this.put("10", 20);
            this.put("23", 21);
            this.put("9", 22);
            this.put("19", 23);
            this.put("16", 24);
        }
    };
    public static Map<String, Integer> resourceCodes = new HashMap<String, Integer>(){
        {
            this.put("07.23.0008", 0);
            this.put("07.23.0019", 1);
            this.put("07.23.0010", 2);
            this.put("07.24.0001", 3);
            this.put("07.23.0013", 4);
            this.put("07.23.0018", 5);
            this.put("07.23.0009", 6);
            this.put("07.23.0030", 7);
            this.put("07.23.0012", 8);
            this.put("07.23.0036", 9);
            this.put("07.23.0021", 10);
        }
    };

    public static Map<String, String> generateFeatureMapStatic(FeatureDo cf) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        try {
            if (cf != null) {
                cf.setCurrentGmtCreateTime(LocalDateUtil.getCurrentLocalDateTime((String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
                retMap.put("f108001", DataUtil.Long2String((Long)cf.getSlotId()));
                retMap.put("f109001", DataUtil.Long2String((Long)cf.getSlotType()));
                retMap.put("f201001", DataUtil.Long2String((Long)cf.getAppId()));
                retMap.put("f202001", cf.getAppCategory());
                retMap.put("f301001", DataUtil.Long2String((Long)cf.getOperatingActivityId()));
                retMap.put("f302001", DataUtil.Long2String((Long)cf.getActivityId()));
                retMap.put("f303001", DataUtil.Long2String((Long)cf.getActivityType()));
                retMap.put("f501001", cf.getUa());
                Integer hour = LocalDateUtil.getHour((String)cf.getCurrentGmtCreateTime(), (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                retMap.put("f502001", DataUtil.Integer2String((Integer)hour));
                Integer weekDay = LocalDateUtil.getDayOfWeek((String)cf.getCurrentGmtCreateTime(), (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                retMap.put("f502002", DataUtil.Integer2String((Integer)weekDay));
                retMap.put("f503001", DataUtil.Long2String((Long)cf.getCityId()));
                retMap.put("f601001", DataUtil.Long2String((Long)FeatureParse.getDayRankLevel(cf.getDayOrderRank())));
                retMap.put("f602001", DataUtil.Long2String((Long)FeatureParse.getRankLevel(cf.getOrderRank())));
                retMap.put("f603001", DataUtil.Long2String((Long)FeatureParse.getDayRankLevel(cf.getDayActivityOrderRank())));
                retMap.put("f604001", DataUtil.Long2String((Long)FeatureParse.getRankLevel(cf.getActivityOrderRank())));
                Long orderGmtIntervelLevel = FeatureParse.getOrderGmtIntervelLevel(cf.getCurrentGmtCreateTime(), cf.getLastGmtCreateTime());
                retMap.put("f605001", DataUtil.Long2String((Long)orderGmtIntervelLevel));
                Long activityOrderGmtIntervelLevel = FeatureParse.getOrderGmtIntervelLevel(cf.getCurrentGmtCreateTime(), cf.getActivityLastGmtCreateTime());
                retMap.put("f606001", DataUtil.Long2String((Long)activityOrderGmtIntervelLevel));
                Long activityLastChargeStatus = FeatureParse.getChargeStatus(cf.getActivityLastChargeNums());
                retMap.put("f607001", DataUtil.Long2String((Long)activityLastChargeStatus));
                Long lastChargeStatus = FeatureParse.getChargeStatus(cf.getLastChargeNums());
                retMap.put("f608001", DataUtil.Long2String((Long)lastChargeStatus));
                Long activityChangeStatus = FeatureParse.getActivityChangeStatus(cf.getOperatingActivityId(), cf.getLastOperatingActivityId());
                retMap.put("f609001", DataUtil.Long2String((Long)activityChangeStatus));
                retMap.put("f504001", cf.getModel());
                retMap.put("f505001", cf.getPriceSection());
                retMap.put("f506001", cf.getConnectionType());
                retMap.put("f507001", cf.getOperatorType());
                retMap.put("f611001", DataUtil.Long2String((Long)cf.getPutIndex()));
                retMap.put("f306001", cf.getActivityUseType());
                retMap.put("f403001", cf.getMemberId());
                retMap.put("f403005", cf.getMobile());
                Long iso = FeatureParse.isOld(cf.getUserLastlogbigintime(), cf.getUserRegtime());
                retMap.put("f403004", DataUtil.Long2String((Long)iso));
                retMap.put("f114001", cf.getSlotIndustryTagPid());
                retMap.put("f114002", cf.getSlotIndustryTagId());
                retMap.put("f205001", cf.getAppIndustryTagPid());
                retMap.put("f205002", cf.getAppIndustryTagId());
                retMap.put("f206001", cf.getTrafficTagPid());
                retMap.put("f206002", cf.getTrafficTagId());
                retMap.put("f9902", cf.getAppList2());
                retMap.put("f9906", cf.getCategoryIdList1());
                retMap.put("f9907", cf.getCategoryIdList2());
                retMap.put("f9908", cf.getIsGame());
                retMap.put("f508001", cf.getPhoneBrand());
                retMap.put("f508002", cf.getPhoneModelNum());
                retMap.put("f9914", cf.getImportantApp());
                retMap.put("f9915", cf.getClusterId());
                retMap.put("f9916", FeatureParse.getLevel("launch_pv", cf.getUIIds(), cf.getUILaunchPV()));
                retMap.put("f9917", FeatureParse.getLevel("click_pv", cf.getUIIds(), cf.getUIClickPv()));
                retMap.put("f9918", FeatureParse.getLevel("effect_pv", cf.getUIIds(), cf.getUIEffectPv()));
                retMap.put("f9919", FeatureParse.getLevel("score", cf.getUIIds(), cf.getUIScore()));
                retMap.put("f9921", cf.getUICtr());
                retMap.put("f9922", cf.getUICvr());
                retMap.put("f9923", cf.getUUnICtr());
                retMap.put("f9924", cf.getUUnICvr());
                retMap.put("f9927", FeatureParse.countFeatures(cf.getUICtr()) + "");
                retMap.put("f9928", FeatureParse.countFeatures(cf.getUICvr()) + "");
                retMap.put("f9929", FeatureParse.countFeatures(cf.getUUnICtr()) + "");
                retMap.put("f9930", FeatureParse.countFeatures(cf.getUUnICvr()) + "");
                retMap.put("f404001", cf.getSex());
                retMap.put("f404002", cf.getAge());
                retMap.put("f404003", cf.getWorkStatus());
                retMap.put("f404004", cf.getStudentStatus());
                retMap.put("f404005", cf.getMarriageStatus());
                retMap.put("f404006", cf.getBear());
                retMap.put("f404007", cf.getInterestList());
                retMap.put("f601002", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getDayOrderRank(), dayOrderRankBucket)));
                retMap.put("f602002", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getOrderRank(), orderRankBucket)));
                retMap.put("f603002", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getDayActivityOrderRank(), dayActOrderRankBucket)));
                retMap.put("f604002", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getActivityOrderRank(), orderActRankBucket)));
                Long orderGmtIntervel = FeatureParse.getOrderGmtIntervel(cf.getCurrentGmtCreateTime(), cf.getLastGmtCreateTime());
                retMap.put("f605002", DataUtil.Long2String((Long)FeatureParse.bucket(orderGmtIntervel, orderGmtIntervelBucket)));
                Long activityOrderGmtIntervel = FeatureParse.getOrderGmtIntervel(cf.getCurrentGmtCreateTime(), cf.getActivityLastGmtCreateTime());
                retMap.put("f606002", DataUtil.Long2String((Long)FeatureParse.bucket(activityOrderGmtIntervel, orderActGmtIntervelBucket)));
                retMap.put("f9925", FeatureParse.categoryIdAndCnt(cf.getCategory1idCntList(), 1));
                retMap.put("f9926", FeatureParse.categoryIdAndCnt(cf.getCategory2idCntList(), 2));
                Map<String, Map<String, Long>> ubpMap = FeatureParse.getUserBehavioralPreference(cf.getUIIds(), cf.getUILaunchPV(), cf.getUIClickPv(), cf.getUIEffectPv());
                retMap.put("f809001", FeatureParse.getUserBehavioralPreference(0, "ctr", ubpMap, null));
                retMap.put("f809002", FeatureParse.getUserBehavioralPreference(0, "cvr", ubpMap, null));
                retMap.put("f808001", FeatureParse.getUserBehavioralPreference(2, "ctr", ubpMap, null));
                retMap.put("f808002", FeatureParse.getUserBehavioralPreference(2, "cvr", ubpMap, null));
                retMap.put("f811001", FeatureParse.getUserBehavioralPreference(3, "ctr", ubpMap, null));
                retMap.put("f811002", FeatureParse.getUserBehavioralPreference(3, "cvr", ubpMap, null));
                cf.setUbpMap(ubpMap);
                retMap.put("f406001", FeatureParse.getSlotAreaType(cf.getSlotHeight(), cf.getSlotWidth()));
                retMap.put("f406002", DataUtil.Long2String((Long)cf.getMediaTag1()));
                retMap.put("f406003", DataUtil.Long2String((Long)cf.getMediaTag2()));
                retMap.put("f9934", DataUtil.Long2String((Long)cf.getPerformance()));
                retMap.put("f9931", DataUtil.Long2String((Long)cf.getLaunchInfo()));
                retMap.put("f9932", DataUtil.Long2String((Long)cf.getBasicInfo()));
                retMap.put("f9933", DataUtil.Long2String((Long)cf.getTotalInfo()));
                retMap.put("f9701", cf.getUserBasicTags());
                retMap.put("f9801", cf.getSigList());
                retMap.put("f9903", FeatureBaseParse.getLengthLevel(cf.getAppList2(), 5, 100, 5));
                retMap.put("f9802", FeatureBaseParse.getLengthLevel(cf.getSigList(), 15, 1));
                retMap.put("f9702", FeatureBaseParse.getLengthLevel(cf.getUserBasicTags(), 50, 5));
                retMap.put("f8801", DataUtil.Long2String((Long)cf.getCurrentDayLaunchIndex()));
                retMap.put("f8802", DataUtil.Long2String((Long)cf.getCurrentDayLaunchBatch()));
                retMap.put("f8803", DataUtil.Long2String((Long)cf.getAlgStartPosition()));
                retMap.put("f8804", DataUtil.Long2String((Long)cf.getDayLastLaunchIndexAdLaunchCnt()));
                retMap.put("f8805", DataUtil.Long2String((Long)cf.getDayLaunchIndexAdExportCnt()));
                retMap.put("f8806", DataUtil.Long2String((Long)cf.getDayLaunchIndexAdClickCnt()));
                String appTagInNewTradeCtr = FeatureParse.getStatInNewTrade("ctr", cf.getAppTagInNewTrade());
                retMap.put("f550101", appTagInNewTradeCtr);
                String appTagInNewTradeCvr = FeatureParse.getStatInNewTrade("cvr", cf.getAppTagInNewTrade());
                retMap.put("f550102", appTagInNewTradeCvr);
                String appInNewTradeCtr = FeatureParse.getStatInNewTrade("ctr", cf.getAppInNewTrade());
                retMap.put("f550301", appInNewTradeCtr);
                String appInNewTradeCvr = FeatureParse.getStatInNewTrade("cvr", cf.getAppInNewTrade());
                retMap.put("f550302", appInNewTradeCvr);
                retMap.put("f404100", DataUtil.Integer2String((Integer)cf.getLayerGender()));
                retMap.put("f404101", DataUtil.Integer2String((Integer)cf.getLayerIsStudent()));
                retMap.put("f830001", cf.getClickAdIds());
                retMap.put("f830002", cf.getClickAcIds());
                retMap.put("f830003", cf.getClickReIds());
                retMap.put("f830004", cf.getClickTrIds());
                retMap.put("f830011", cf.getConvAdIds() == null ? "null" : cf.getConvAdIds().toString());
                retMap.put("f830012", cf.getConvAcIds() == null ? "null" : cf.getConvAcIds().toString());
                retMap.put("f830013", cf.getConvReIds() == null ? "null" : cf.getConvReIds().toString());
                retMap.put("f830014", cf.getConvTrIds() == null ? "null" : cf.getConvTrIds().toString());
                DmpFeature dmpFeature = Optional.ofNullable(cf.getDmpFeature()).orElse(new DmpFeature());
                retMap.put("f9935", dmpFeature.getValidAppList());
                retMap.put("f9936", dmpFeature.getTopAppList());
                retMap.put("f9937", dmpFeature.getMidAppList());
                retMap.put("f9938", dmpFeature.getInstallAppList());
                retMap.put("f9939", dmpFeature.getUninstallAppList());
                String appCategoryLevel = FeatureBaseParse.getCategoryLevel(dmpFeature.getAppCategory(), 10, 1);
                retMap.put("f9940", appCategoryLevel);
                retMap.put("f9941", dmpFeature.getTradeAppList());
                String appVectorLevel = FeatureBaseParse.getAppVectorLevel(dmpFeature.getAppVector(), 200);
                retMap.put("f9942", appVectorLevel);
                retMap.put("f9943", dmpFeature.getTopAppList2());
                retMap.put("f9944", dmpFeature.getTopAppList3());
                retMap.put("f9803", dmpFeature.getMsgCategory());
                retMap.put("f9804", dmpFeature.getMsgKeyword());
                String msgVectorLevel = FeatureBaseParse.getAppVectorLevel(dmpFeature.getMsgVector(), 200);
                retMap.put("f9805", msgVectorLevel);
                retMap.put("f701002", FeatureParse.getAdAndSubType(cf.getAppId(), cf.getBankEndType()));
                UserActFeature userActFeature = dmpFeature.getUserActFeature();
                retMap.put("f410001", FeatureParse.bucket(userActFeature.getUserActiveDays(), cntBucket).toString());
                retMap.put("f411001", FeatureParse.bucket(userActFeature.getActivityRequest(), cntBucket).toString());
                retMap.put("f411002", FeatureParse.bucket(userActFeature.getWeekActivityRequest(), cntBucket).toString());
                retMap.put("f411003", FeatureParse.bucket(userActFeature.getDayActivityRequest(), cntBucket).toString());
                retMap.put("f411004", FeatureParse.bucket(userActFeature.getIntervalActivityRequest(), cntBucket).toString());
                retMap.put("f411005", userActFeature.getPeriodActivityRequest());
                retMap.put("f412001", FeatureParse.bucket(userActFeature.getActivityJoin(), cntBucket).toString());
                retMap.put("f412002", FeatureParse.bucket(userActFeature.getWeekActivityJoin(), cntBucket).toString());
                retMap.put("f412003", FeatureParse.bucket(userActFeature.getDayActivityJoin(), cntBucket).toString());
                retMap.put("f412004", FeatureParse.bucket(userActFeature.getIntervalActivityJoin(), cntBucket).toString());
                retMap.put("f412005", userActFeature.getPeriodActivityJoin());
                retMap.put("f412006", FeatureParse.bucket(userActFeature.getActivityPageStay(), cntBucket).toString());
                Map launchTradeActMap = DataUtil.stringToMap((String)userActFeature.getLaunchTrade(), (Object)0);
                retMap.put("f413001", FeatureParse.getUserCategoryActLevelByBucket(launchTradeActMap, tradeCodes, cntBucket));
                Map weekLaunchTradeActMap = DataUtil.stringToMap((String)userActFeature.getWeekLaunchTrade(), (Object)0);
                retMap.put("f413002", FeatureParse.getUserCategoryActLevelByBucket(weekLaunchTradeActMap, tradeCodes, cntBucket));
                retMap.put("f413003", FeatureParse.getUserCategoryActLevelByBucket(userActFeature.getDayLaunchTrade(), tradeCodes, cntBucket));
                retMap.put("f413004", FeatureParse.bucket(userActFeature.getIntervalLaunchTrade(), cntBucket).toString());
                retMap.put("f413005", userActFeature.getPeriodLaunchTrade());
                retMap.put("f413006", FeatureParse.bucket(userActFeature.getAvgLaunchStay(), cntBucket).toString());
                retMap.put("f413007", userActFeature.getLastLaunchTrade());
                retMap.put("f413008", userActFeature.getClickLaunchTrade() == null ? null : userActFeature.getClickLaunchTrade().toString());
                Map clickTraceActMap = DataUtil.stringToMap((String)userActFeature.getClickTrade(), (Object)0);
                retMap.put("f414001", FeatureParse.getUserCategoryActLevelByBucket(clickTraceActMap, tradeCodes, cntBucket));
                Map weekClickTradeActMap = DataUtil.stringToMap((String)userActFeature.getWeekClickTrade(), (Object)0);
                retMap.put("f414002", FeatureParse.getUserCategoryActLevelByBucket(weekClickTradeActMap, tradeCodes, cntBucket));
                retMap.put("f414003", FeatureParse.getUserCategoryActLevelByBucket(userActFeature.getDayClickTrade(), tradeCodes, cntBucket));
                retMap.put("f414004", FeatureParse.bucket(userActFeature.getIntervalClickTrade(), cntBucket).toString());
                retMap.put("f414005", userActFeature.getPeriodClickTrade());
                retMap.put("f414007", userActFeature.getLastClickTrade());
                retMap.put("f414008", userActFeature.getEffectClickTrade() == null ? null : userActFeature.getEffectClickTrade().toString());
                Map effectTradeActMap = DataUtil.stringToMap((String)userActFeature.getEffectTrade(), (Object)0);
                retMap.put("f415001", FeatureParse.getUserCategoryActLevelByBucket(effectTradeActMap, tradeCodes, cntBucket));
                Map weekEffectTradeActMap = DataUtil.stringToMap((String)userActFeature.getWeekEffectTrade(), (Object)0);
                retMap.put("f415002", FeatureParse.getUserCategoryActLevelByBucket(weekEffectTradeActMap, tradeCodes, cntBucket));
                retMap.put("f415003", FeatureParse.getUserCategoryActLevelByBucket(userActFeature.getDayEffectTrade(), tradeCodes, cntBucket));
                retMap.put("f415004", FeatureParse.bucket(userActFeature.getIntervalEffectTrade(), cntBucket).toString());
                retMap.put("f415005", userActFeature.getPeriodEffectTrade());
                retMap.put("f415007", userActFeature.getLastEffectTrade());
                Map launchCateActMap = DataUtil.stringToMap((String)userActFeature.getLaunchCategory(), (Object)0);
                retMap.put("f423001", FeatureParse.getUserCategoryActLevelByBucket(launchCateActMap, resourceCodes, cntBucket));
                Map weekLaunchCateActMap = DataUtil.stringToMap((String)userActFeature.getWeekLaunchCategory(), (Object)0);
                retMap.put("f423002", FeatureParse.getUserCategoryActLevelByBucket(weekLaunchCateActMap, resourceCodes, cntBucket));
                retMap.put("f423003", FeatureParse.getUserCategoryActLevelByBucket(userActFeature.getDayLaunchCategory(), resourceCodes, cntBucket));
                retMap.put("f423004", FeatureParse.bucket(userActFeature.getIntervalLaunchCategory(), cntBucket).toString());
                retMap.put("f423005", userActFeature.getPeriodLaunchCategory());
                retMap.put("f423006", FeatureParse.bucket(userActFeature.getAvgLaunchCategoryStay(), cntBucket).toString());
                retMap.put("f423007", userActFeature.getLastLaunchCategory());
                retMap.put("f423008", userActFeature.getClickLaunchCategory() == null ? null : userActFeature.getClickLaunchCategory().toString());
                retMap.put("f423009", userActFeature.getLastLaunchBrand());
                Map clickCateActMap = DataUtil.stringToMap((String)userActFeature.getClickCategory(), (Object)0);
                retMap.put("f424001", FeatureParse.getUserCategoryActLevelByBucket(clickCateActMap, resourceCodes, cntBucket));
                Map weekClickCateActMap = DataUtil.stringToMap((String)userActFeature.getWeekClickCategory(), (Object)0);
                retMap.put("f424002", FeatureParse.getUserCategoryActLevelByBucket(weekClickCateActMap, resourceCodes, cntBucket));
                retMap.put("f424003", FeatureParse.getUserCategoryActLevelByBucket(userActFeature.getDayClickCategory(), resourceCodes, cntBucket));
                retMap.put("f424004", FeatureParse.bucket(userActFeature.getIntervalClickCategory(), cntBucket).toString());
                retMap.put("f424005", userActFeature.getPeriodClickCategory());
                retMap.put("f424006", FeatureParse.bucket(userActFeature.getAvgLandpageStay(), cntBucket).toString());
                retMap.put("f424007", userActFeature.getLastClickCategory());
                retMap.put("f424008", userActFeature.getEffectClickCategory() == null ? null : userActFeature.getEffectClickCategory().toString());
                retMap.put("f424009", userActFeature.getLastClickBrand());
                retMap.put("f424010", userActFeature.getIssueEffectClickCategory() == null ? null : userActFeature.getIssueEffectClickCategory().toString());
                Map effectCateActMap = DataUtil.stringToMap((String)userActFeature.getEffectCategory(), (Object)0);
                retMap.put("f425001", FeatureParse.getUserCategoryActLevelByBucket(effectCateActMap, resourceCodes, cntBucket));
                Map weekEffectCateActMap = DataUtil.stringToMap((String)userActFeature.getWeekEffectCategory(), (Object)0);
                retMap.put("f425002", FeatureParse.getUserCategoryActLevelByBucket(weekEffectCateActMap, resourceCodes, cntBucket));
                retMap.put("f425003", FeatureParse.getUserCategoryActLevelByBucket(userActFeature.getDayEffectCategory(), resourceCodes, cntBucket));
                retMap.put("f425004", FeatureParse.bucket(userActFeature.getIntervalEffectCategory(), cntBucket).toString());
                retMap.put("f425005", userActFeature.getPeriodEffectCategory());
                retMap.put("f425007", userActFeature.getLastEffectCategory());
                retMap.put("f425009", userActFeature.getLastEffectBrand());
                retMap.put("f425011", FeatureParse.bucket(userActFeature.getAddressCount(), cntBucket).toString());
                retMap.put("f425012", FeatureParse.bucket(userActFeature.getNumberCount(), cntBucket).toString());
                Map issueEffectCateActMap = DataUtil.stringToMap((String)userActFeature.getIssueEffectCategory(), (Object)0);
                retMap.put("f426001", FeatureParse.getUserCategoryActLevelByBucket(issueEffectCateActMap, resourceCodes, cntBucket));
                Map weekIssueEffectCateActMap = DataUtil.stringToMap((String)userActFeature.getWeekIssueEffectCategory(), (Object)0);
                retMap.put("f426002", FeatureParse.getUserCategoryActLevelByBucket(weekIssueEffectCateActMap, resourceCodes, cntBucket));
                retMap.put("f426004", FeatureParse.bucket(userActFeature.getIntervalIssueEffectCategory(), cntBucket).toString());
                retMap.put("f426005", userActFeature.getPeriodIssueEffectCategory());
                retMap.put("f426007", userActFeature.getLastIssueEffectCategory());
                retMap.put("f426009", userActFeature.getLastIssueEffectBrand());
                Map scoreEffectCateMap = DataUtil.stringToMap((String)userActFeature.getScoreEffectCategory(), (Object)0);
                retMap.put("f431001", FeatureParse.getUserCategoryActLevelByBucket(scoreEffectCateMap, resourceCodes, cntBucket));
                Map scoreIssueEffectCateMap = DataUtil.stringToMap((String)userActFeature.getScoreIssueEffectCategory(), (Object)0);
                retMap.put("f431002", FeatureParse.getUserCategoryActLevelByBucket(scoreIssueEffectCateMap, resourceCodes, cntBucket));
                retMap.put("f432001", FeatureParse.bucket(userActFeature.getOrderFee(), totalPriceBucket).toString());
                retMap.put("f432002", FeatureParse.bucket(userActFeature.getWeekOrderFee(), totalPriceBucket).toString());
                retMap.put("f432003", FeatureParse.bucket(userActFeature.getMaxOrderFee(), priceBucket).toString());
                retMap.put("f432004", FeatureParse.bucket(userActFeature.getMinOrderFee(), priceBucket).toString());
                retMap.put("f432005", FeatureParse.bucket(userActFeature.getAvgOrderFee(), priceBucket).toString());
                retMap.put("f432006", FeatureParse.bucket(userActFeature.getLastOrderFee(), priceBucket).toString());
                retMap.put("f433001", FeatureParse.bucket(userActFeature.getZeroLaunch(), cntBucket).toString());
                retMap.put("f433002", FeatureParse.bucket(userActFeature.getNonZeroLaunch(), cntBucket).toString());
                retMap.put("f433003", FeatureParse.bucket(userActFeature.getZeroClick(), cntBucket).toString());
                retMap.put("f433004", FeatureParse.bucket(userActFeature.getNonZeroClick(), cntBucket).toString());
                retMap.put("f433005", FeatureParse.bucket(userActFeature.getZeroEffect(), cntBucket).toString());
                retMap.put("f433006", FeatureParse.bucket(userActFeature.getNonZeroEffect(), cntBucket).toString());
                retMap.put("f433007", FeatureParse.bucket(userActFeature.getZeroIssueEffect(), cntBucket).toString());
                retMap.put("f433008", FeatureParse.bucket(userActFeature.getNonZeroIssueEffect(), cntBucket).toString());
                retMap.put("f434001", FeatureParse.bucket(userActFeature.getVouchFailed(), cntBucket).toString());
                retMap.put("f434002", FeatureParse.bucket(userActFeature.getWeekVouchFailed(), cntBucket).toString());
                retMap.put("f434003", FeatureParse.bucket(userActFeature.getIntervalVouchFailed(), cntBucket).toString());
                retMap.put("f434004", FeatureParse.bucket(userActFeature.getReject(), cntBucket).toString());
                retMap.put("f434005", FeatureParse.bucket(userActFeature.getWeekReject(), cntBucket).toString());
                retMap.put("f434006", FeatureParse.bucket(userActFeature.getIntervalReject(), cntBucket).toString());
                retMap.put("f434007", FeatureParse.bucket(userActFeature.getComplaint(), cntBucket).toString());
                retMap.put("f434008", FeatureParse.bucket(userActFeature.getWeekComplaint(), cntBucket).toString());
                retMap.put("f434009", FeatureParse.bucket(userActFeature.getIntervalComplaint(), cntBucket).toString());
                retMap.put("f434010", FeatureParse.bucket(userActFeature.getAddressException(), cntBucket).toString());
                retMap.put("f434011", FeatureParse.bucket(userActFeature.getWeekAddressException(), cntBucket).toString());
                retMap.put("f434012", FeatureParse.bucket(userActFeature.getIntervalAddressException(), cntBucket).toString());
                retMap.put("f434013", FeatureParse.bucket(userActFeature.getNumberEmpty(), cntBucket).toString());
                retMap.put("f434014", FeatureParse.bucket(userActFeature.getWeekNumberEmpty(), cntBucket).toString());
                retMap.put("f434015", FeatureParse.bucket(userActFeature.getIntervalNumberEmpty(), cntBucket).toString());
                retMap.put("f434016", FeatureParse.bucket(userActFeature.getCheat(), cntBucket).toString());
                retMap.put("f434017", FeatureParse.bucket(userActFeature.getWeekCheat(), cntBucket).toString());
                retMap.put("f434018", FeatureParse.bucket(userActFeature.getIntervalCheat(), cntBucket).toString());
            }
        }
        catch (Exception e) {
            logger.error("FeatureParse.generateFeatureMapStatic error:" + e);
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(FeatureDo cf, FeatureDo staticCf) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        try {
            if (cf != null) {
                retMap.put("f101001", DataUtil.Long2String((Long)cf.getAdvertId()));
                retMap.put("f106001", DataUtil.Long2String((Long)cf.getAccountId()));
                retMap.put("f111001", cf.getPromoteUrl());
                retMap.put("f102001", cf.getMatchTagNums());
                retMap.put("f801001", cf.getGoodsId());
                retMap.put("f802001", cf.getCatId());
                retMap.put("f802002", cf.getBrandId());
                retMap.put("f803001", DataUtil.Long2String((Long)FeatureParse.getCost(cf.getCost(), cf.getPrice())));
                retMap.put("f803002", DataUtil.Long2String((Long)FeatureParse.getLog(cf.getPrice())));
                retMap.put("f803003", DataUtil.Long2String((Long)FeatureParse.getCost(cf.getViewCount(), cf.getBuyCount())));
                retMap.put("f803004", DataUtil.Long2String((Long)FeatureParse.getLog(cf.getBuyCount())));
                retMap.put("f110001", DataUtil.Long2String((Long)cf.getTimes()));
                Long tagChangeStatus = FeatureParse.getLastTagChangeStatus(cf.getMatchTagNums(), cf.getDayLastMatchTagNums());
                retMap.put("f610001", DataUtil.Long2String((Long)tagChangeStatus));
                retMap.put("f104001", cf.getMaterialId());
                retMap.put("f112001", cf.getMaterialTags());
                retMap.put("f113001", cf.getAdvertTags());
                retMap.put("f804001", DataUtil.Long2String((Long)FeatureParse.getCtrIntervelLevel(cf.getAdvertCtr())));
                retMap.put("f804002", DataUtil.Long2String((Long)FeatureParse.getCvrIntervelLevel(cf.getAdvertCvr())));
                retMap.put("f805001", DataUtil.Long2String((Long)FeatureParse.getCtrIntervelLevel(cf.getAdvertAppCtr())));
                retMap.put("f805002", DataUtil.Long2String((Long)FeatureParse.getCvrIntervelLevel(cf.getAdvertAppCvr())));
                retMap.put("f806001", DataUtil.Long2String((Long)FeatureParse.getCtrIntervelLevel(cf.getAdvertSlotCtr())));
                retMap.put("f806002", DataUtil.Long2String((Long)FeatureParse.getCvrIntervelLevel(cf.getAdvertSlotCvr())));
                retMap.put("f807001", DataUtil.Long2String((Long)FeatureParse.getCtrIntervelLevel(cf.getAdvertActivityCtr())));
                retMap.put("f807002", DataUtil.Long2String((Long)FeatureParse.getCvrIntervelLevel(cf.getAdvertActivityCvr())));
                retMap.put("f804003", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getAdvertCtr(), statCtrBucket)));
                retMap.put("f804004", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getAdvertCvr(), statCvrBucket)));
                retMap.put("f805003", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getAdvertAppCtr(), statCtrBucket)));
                retMap.put("f805004", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getAdvertAppCvr(), statCvrBucket)));
                retMap.put("f806003", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getAdvertSlotCtr(), statCtrBucket)));
                retMap.put("f806004", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getAdvertSlotCvr(), statCvrBucket)));
                retMap.put("f807003", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getAdvertActivityCtr(), statCtrBucket)));
                retMap.put("f807004", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getAdvertActivityCvr(), statCvrBucket)));
                retMap.put("f9912", cf.getTradeId());
                retMap.put("f9913", cf.getTradeId2());
                Map<String, Map<String, Long>> ubpMap = staticCf.getUbpMap();
                retMap.put("f810001", FeatureParse.getUserBehavioralPreference(1, "ctr", ubpMap, cf.getMatchTagNums()));
                retMap.put("f810002", FeatureParse.getUserBehavioralPreference(1, "cvr", ubpMap, cf.getMatchTagNums()));
                retMap.put("f115001", cf.getBankEndType());
                retMap.put("f701001", FeatureParse.getAdAndSubType(cf.getAdvertId(), cf.getBankEndType()));
                retMap.put("f121001", cf.getAtmosphere());
                retMap.put("f121002", cf.getBackgroundColour());
                retMap.put("f121003", cf.getIfPrevalent());
                retMap.put("f121004", cf.getDescribeKeywords());
                retMap.put("f121005", cf.getDynamicEffect());
                retMap.put("f121006", cf.getBodyElement());
                retMap.put("f8807", DataUtil.Long2String((Long)cf.getBatchIndex()));
                retMap.put("f770001", cf.getOperatingResource());
                Long dayResourceOrderRankLevel = FeatureParse.getResourceOrderRank(cf.getOperatingResource(), staticCf.getDayResourceOrderRank());
                retMap.put("f770102", DataUtil.Long2String((Long)dayResourceOrderRankLevel));
                Long resourceOrderGmtIntervelLevel = FeatureParse.getResourceOrderGmtIntervelLevel(cf.getOperatingResource(), staticCf.getCurrentGmtCreateTime(), staticCf.getResourceLastGmtCreateTime());
                retMap.put("f770202", DataUtil.Long2String((Long)resourceOrderGmtIntervelLevel));
                Long resourceLastOrderIsClick = FeatureParse.getResourceLastOrderIsClick(cf.getOperatingResource(), staticCf.getResourceLastLaunchOrderId(), staticCf.getResourceLastClickOrderId());
                retMap.put("f770301", DataUtil.Long2String((Long)resourceLastOrderIsClick));
                Long resourceLastOrderIsConvert = FeatureParse.getResourceLastOrderIsConvert(cf.getOperatingResource(), staticCf.getResourceLastLaunchOrderId(), staticCf.getResourceLastConvertOrderId());
                retMap.put("f770302", DataUtil.Long2String((Long)resourceLastOrderIsConvert));
                Long dayResourceChargeCnt = FeatureParse.getResourceChargeCnt(cf.getOperatingResource(), staticCf.getDayResourceChargeCnt());
                retMap.put("f770401", DataUtil.Long2String((Long)dayResourceChargeCnt));
                Long dayResourceConvertCnt = FeatureParse.getResourceConvertCnt(cf.getOperatingResource(), staticCf.getDayResourceConvertCnt());
                retMap.put("f770402", DataUtil.Long2String((Long)dayResourceConvertCnt));
                Long lastResourceEqualStatus = FeatureParse.getLastResourceEqualStatus(cf.getOperatingResource(), staticCf.getLastOperatingResource());
                retMap.put("f770501", DataUtil.Long2String((Long)lastResourceEqualStatus));
                retMap.put("f660001", cf.getOperatingNewTrade());
                Long newTradeDayOrderRankLevel = FeatureParse.getNewTradeOrderRank(cf.getOperatingNewTrade(), cf.getNewTradeDayOrderRank());
                retMap.put("f660102", DataUtil.Long2String((Long)newTradeDayOrderRankLevel));
                Long lastNewTradeEqualStatus = FeatureParse.getLastNewTradeEqualStatus(cf.getOperatingNewTrade(), cf.getLastOperatingNewTrade());
                retMap.put("f660201", DataUtil.Long2String((Long)lastNewTradeEqualStatus));
                Long lastNewTradeGmtIntervelLevel = FeatureParse.getLastNewTradeGmtIntervelLevel(cf.getOperatingNewTrade(), staticCf.getCurrentGmtCreateTime(), cf.getNewTradeLastGmtCreateTime());
                retMap.put("f660302", DataUtil.Long2String((Long)lastNewTradeGmtIntervelLevel));
                String newTradeInAppTagCtr = FeatureParse.getStatInAppTag("ctr", cf.getNewTradeInAppTag());
                retMap.put("f550201", newTradeInAppTagCtr);
                String newTradeInAppTagCvr = FeatureParse.getStatInAppTag("cvr", cf.getNewTradeInAppTag());
                retMap.put("f550202", newTradeInAppTagCvr);
                String advertInAppTagCtr = FeatureParse.getStatInAppTag("ctr", cf.getAdvertInAppTag());
                retMap.put("f550401", advertInAppTagCtr);
                String advertInAppTagCvr = FeatureParse.getStatInAppTag("cvr", cf.getAdvertInAppTag());
                retMap.put("f550402", advertInAppTagCvr);
                retMap.put("f830101", FeatureParse.getCrossFeature(staticCf.getClickAdIds(), DataUtil.Long2String((Long)cf.getAdvertId())));
                retMap.put("f830102", FeatureParse.getCrossFeature(staticCf.getClickAcIds(), DataUtil.Long2String((Long)cf.getAccountId())));
                retMap.put("f830103", FeatureParse.getCrossFeature(staticCf.getClickReIds(), cf.getOperatingResource()));
                retMap.put("f830104", FeatureParse.getCrossFeature(staticCf.getClickTrIds(), cf.getOperatingNewTrade()));
                String backCvrType = cf.getBankEndType();
                String convAdIds = staticCf.getConvAdIds() == null ? null : (String)staticCf.getConvAdIds().getOrDefault(backCvrType, null);
                String convAcIds = staticCf.getConvAcIds() == null ? null : (String)staticCf.getConvAcIds().getOrDefault(backCvrType, null);
                String convReIds = staticCf.getConvReIds() == null ? null : (String)staticCf.getConvReIds().getOrDefault(backCvrType, null);
                String convTrIds = staticCf.getConvTrIds() == null ? null : (String)staticCf.getConvTrIds().getOrDefault(backCvrType, null);
                retMap.put("f830111", FeatureParse.getCrossFeature(convAdIds, DataUtil.Long2String((Long)cf.getAdvertId())));
                retMap.put("f830112", FeatureParse.getCrossFeature(convAcIds, DataUtil.Long2String((Long)cf.getAccountId())));
                retMap.put("f830113", FeatureParse.getCrossFeature(convReIds, cf.getOperatingResource()));
                retMap.put("f830114", FeatureParse.getCrossFeature(convTrIds, cf.getOperatingNewTrade()));
                DmpFeature dmpFeature = Optional.ofNullable(staticCf.getDmpFeature()).orElse(new DmpFeature());
                retMap.put("f9601", FeatureParse.getCrossFeature(staticCf.getUserBasicTags(), cf.getOperatingNewTrade()));
                retMap.put("f9602", FeatureParse.getCrossFeature(staticCf.getUserBasicTags(), cf.getOperatingResource()));
                retMap.put("f9603", FeatureParse.getCrossFeature(staticCf.getUserBasicTags(), DataUtil.Long2String((Long)cf.getAdvertId())));
                retMap.put("f9607", FeatureParse.getCrossFeature(dmpFeature.getValidAppList(), cf.getOperatingNewTrade()));
                retMap.put("f9608", FeatureParse.getCrossFeature(staticCf.getSigList(), cf.getOperatingNewTrade()));
                retMap.put("f9609", FeatureParse.getCrossFeature(staticCf.getSigList(), cf.getOperatingResource()));
            }
        }
        catch (Exception e) {
            logger.error("FeatureParse.generateFeatureMapDynamic error:", (Throwable)e);
        }
        return retMap;
    }

    public static String getAdAndSubType(Long advertId, String subType) {
        String ret = null;
        if (advertId != null) {
            Long retTmp = advertId + (FeatureParse.getSubType(subType) + 1L) * 1000000L;
            ret = retTmp + "";
        }
        return ret;
    }

    public static Long getSubType(String subType) {
        Long ret = 0L;
        if (subType != null) {
            ret = Long.valueOf(subType);
        }
        return ret;
    }

    public static Long getCtrIntervelLevel(Double ctr) {
        Long ret = null;
        ret = ctr == null ? Long.valueOf(-1L) : (ctr <= 0.999 ? Long.valueOf(Math.round(ctr * 100.0 / 3.0)) : Long.valueOf(-1L));
        return ret;
    }

    public static Long getCvrIntervelLevel(Double cvr) {
        Long ret = null;
        ret = cvr == null ? Long.valueOf(-1L) : (cvr <= 0.04 ? Long.valueOf(Math.round(cvr * 1000.0 / 4.0)) : (cvr <= 0.999 ? Long.valueOf(11L + Math.round((cvr - 0.04) * 100.0 / 3.0)) : Long.valueOf(-1L)));
        return ret;
    }

    public static Long getOrderGmtIntervel(String date, String otherDate) {
        return LocalDateUtil.getIntervalMinutes((String)date, (String)otherDate, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
    }

    public static Long getOrderGmtIntervelLevel(String date, String otherDate) {
        Long ret = null;
        Long minutes = LocalDateUtil.getIntervalMinutes((String)date, (String)otherDate, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
        ret = minutes == null ? Long.valueOf(-1L) : (minutes <= 5L ? Long.valueOf(1L) : (minutes <= 10L ? Long.valueOf(2L) : (minutes <= 30L ? Long.valueOf(3L) : (minutes <= 60L ? Long.valueOf(4L) : Long.valueOf(99L)))));
        return ret;
    }

    public static Long getDayRankLevel(Long rank) {
        Long ret = null;
        ret = rank == null ? null : (rank <= 7L ? rank : Long.valueOf(-1L));
        return ret;
    }

    public static Long getRankLevel(Long rank) {
        Long ret = null;
        ret = rank == null ? null : (rank <= 15L ? rank : Long.valueOf(-1L));
        return ret;
    }

    public static Long getChargeStatus(Long chargeNums) {
        Long ret = null;
        ret = chargeNums == null || chargeNums < 1L ? Long.valueOf(0L) : Long.valueOf(1L);
        return ret;
    }

    public static Long getActivityChangeStatus(Long operatingActivityId, Long lastOperatingActivityId) {
        Long ret = null;
        ret = operatingActivityId == null || lastOperatingActivityId == null ? Long.valueOf(0L) : (operatingActivityId.equals(lastOperatingActivityId) ? Long.valueOf(1L) : Long.valueOf(0L));
        return ret;
    }

    public static Long getLastTagChangeStatus(String matchTagNums, String lastMatchTagNums) {
        Long ret = null;
        ret = matchTagNums == null || lastMatchTagNums == null ? Long.valueOf(0L) : (matchTagNums.equals(lastMatchTagNums) ? Long.valueOf(1L) : Long.valueOf(0L));
        return ret;
    }

    public static Long isOld(Date userLastlogbigintime, Date userRegtime) {
        Long dayIntervals;
        Long ret = 0L;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{userLastlogbigintime, userRegtime}) && (dayIntervals = LocalDateUtil.getIntervalDays((Date)userLastlogbigintime, (Date)userRegtime)) != null) {
            ret = dayIntervals > 1L ? 1L : 0L;
        }
        return ret;
    }

    public static Long getCost(Long cost, Long price) {
        Long ret = null;
        if (cost != null && price != null && cost > 0L) {
            ret = new Double(Math.ceil(((double)price.longValue() + 1.0E-6) / (double)cost.longValue())).intValue();
        }
        return ret;
    }

    public static Long getLog(Long lvalue) {
        Long ret = null;
        if (lvalue != null && lvalue > 0L) {
            ret = new Double(Math.ceil(FeatureParse.log(lvalue.doubleValue(), 2 / 0))).intValue();
        }
        return ret;
    }

    public static String getLevel(String key, String idlist, String valueList) {
        String[] valueArr;
        String s = "";
        if (idlist == null || valueList == null || idlist.isEmpty() || valueList.isEmpty()) {
            return null;
        }
        String[] idArr = idlist.split(",");
        if (idArr.length != (valueArr = valueList.split(",")).length) {
            return null;
        }
        for (int i = 0; i < idArr.length; ++i) {
            double value = 0.0;
            try {
                value = Double.parseDouble(valueArr[i]);
            }
            catch (NumberFormatException e) {
                continue;
            }
            catch (NullPointerException e) {
                continue;
            }
            s = s + idArr[i] + "&" + String.valueOf(FeatureParse.discretization(key, value)) + ",";
        }
        if (!s.isEmpty()) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static int discretization(String key, double value) {
        int class_id = 0;
        switch (key) {
            case "launch_pv": {
                if (value > -1.0E8 & value <= 0.0) {
                    class_id = 1;
                    break;
                }
                if (value > 0.0 & value <= 1.0) {
                    class_id = 2;
                    break;
                }
                if (value > 1.0 & value <= 2.0) {
                    class_id = 3;
                    break;
                }
                if (value > 2.0 & value <= 3.0) {
                    class_id = 4;
                    break;
                }
                if (value > 3.0 & value <= 4.0) {
                    class_id = 5;
                    break;
                }
                if (value > 4.0 & value <= 5.0) {
                    class_id = 6;
                    break;
                }
                if (value > 5.0 & value <= 6.0) {
                    class_id = 7;
                    break;
                }
                if (value > 6.0 & value <= 7.0) {
                    class_id = 8;
                    break;
                }
                if (value > 7.0 & value <= 18.0) {
                    class_id = 9;
                    break;
                }
                if (value > 18.0 & value <= 50.0) {
                    class_id = 10;
                    break;
                }
                if (value > 50.0 & value <= 150.0) {
                    class_id = 11;
                    break;
                }
                if (value > 150.0 & value <= 300.0) {
                    class_id = 12;
                    break;
                }
                class_id = 13;
                break;
            }
            case "click_pv": {
                if (value > -1.0E8 & value <= 0.0) {
                    class_id = 1;
                    break;
                }
                if (value > 0.0 & value <= 1.0) {
                    class_id = 2;
                    break;
                }
                if (value > 2.0 & value <= 3.0) {
                    class_id = 3;
                    break;
                }
                if (value > 3.0 & value <= 4.0) {
                    class_id = 4;
                    break;
                }
                if (value > 4.0 & value <= 5.0) {
                    class_id = 5;
                    break;
                }
                if (value > 5.0 & value <= 6.0) {
                    class_id = 6;
                    break;
                }
                if (value > 6.0 & value <= 8.0) {
                    class_id = 7;
                    break;
                }
                if (value > 8.0 & value <= 15.0) {
                    class_id = 8;
                    break;
                }
                if (value > 15.0 & value <= 80.0) {
                    class_id = 9;
                    break;
                }
                if (value > 80.0 & value <= 225.0) {
                    class_id = 10;
                    break;
                }
                class_id = 11;
                break;
            }
            case "effect_pv": {
                if (value > -1.0E8 & value <= 0.0) {
                    class_id = 1;
                    break;
                }
                if (value > 0.0 & value <= 1.0) {
                    class_id = 2;
                    break;
                }
                if (value > 1.0 & value <= 2.0) {
                    class_id = 3;
                    break;
                }
                if (value > 2.0 & value <= 3.0) {
                    class_id = 4;
                    break;
                }
                if (value > 4.0 & value <= 15.0) {
                    class_id = 5;
                    break;
                }
                if (value > 15.0 & value <= 25.0) {
                    class_id = 6;
                    break;
                }
                if (value > 25.0 & value <= 70.0) {
                    class_id = 7;
                    break;
                }
                if (value > 70.0 & value <= 150.0) {
                    class_id = 8;
                    break;
                }
                if (value > 150.0 & value <= 225.0) {
                    class_id = 9;
                    break;
                }
                class_id = 10;
                break;
            }
            case "score": {
                class_id = value > -1.0E8 & value <= -471.0 ? 1 : (value > -471.0 & value <= -331.0 ? 2 : (value > -331.0 & value <= -168.0 ? 3 : (value > -168.0 & value <= -52.0 ? 4 : (value > -52.0 & value <= -19.0 ? 5 : (value > -19.0 & value <= -8.0 ? 6 : (value > -8.0 & value <= -4.0 ? 7 : (value > -4.0 & value <= 1.0 ? 8 : (value > 1.0 & value <= 2.0 ? 9 : (value > 2.0 & value <= 17.0 ? 10 : (value > 17.0 & value <= 42.0 ? 11 : (value > 42.0 & value <= 73.0 ? 12 : (value > 73.0 & value <= 126.0 ? 13 : (value > 126.0 & value <= 284.0 ? 14 : 15)))))))))))));
            }
        }
        return class_id;
    }

    public static String getUserBehavioralPreference(int dimType, String statType, Map<String, Map<String, Long>> ubpMap, String tags) {
        String ret = null;
        try {
            Object tag;
            if (dimType == 0 && ubpMap != null) {
                ret = DataUtil.Long2String((Long)ubpMap.get(statType).get("0"));
            }
            if (dimType == 1 && ubpMap != null && (tag = FeatureParse.getTag(tags)) != null) {
                ret = ubpMap.get(statType).get(tag) + "";
                if (((String)tag).length() == 10 && ret == null) {
                    String string = ((String)tag).substring(0, 5);
                    ret = DataUtil.Long2String((Long)ubpMap.get(statType).get(string));
                }
            }
            if (dimType == 2 && AssertUtil.isNotEmpty(ubpMap.get(statType))) {
                ret = "";
                for (Map.Entry entry : ubpMap.get(statType).entrySet()) {
                    String string = (String)entry.getKey() + "_" + entry.getValue() + ",";
                    ret = ret + string;
                }
                if (ret.endsWith(",")) {
                    ret = ret.substring(0, ret.length() - 1);
                }
            }
            if (dimType == 3 && AssertUtil.isNotEmpty(ubpMap.get(statType))) {
                ret = "";
                HashMap<Long, Long> levelCntMap = new HashMap<Long, Long>();
                for (Map.Entry<String, Long> entry : ubpMap.get(statType).entrySet()) {
                    String tag2 = entry.getKey();
                    Long ctrLevel = FeatureParse.bucket(entry.getValue(), ctrAndCvrLevelBucket);
                    if (ctrLevel == null || tag2 == "0") continue;
                    if (!levelCntMap.containsKey(ctrLevel)) {
                        levelCntMap.put(ctrLevel, 0L);
                    }
                    levelCntMap.put(ctrLevel, (Long)levelCntMap.get(ctrLevel) + 1L);
                }
                for (Map.Entry entry : levelCntMap.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    Long cntLevel = FeatureParse.bucket((Long)entry.getValue(), cntBucket);
                    String v = (Long)entry.getKey() * 100L + cntLevel + ",";
                    ret = ret + v;
                }
                if (ret.endsWith(",")) {
                    ret = ret.substring(0, ret.length() - 1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String getTag(String tags) {
        Object[] tagArr;
        String ret = null;
        if (AssertUtil.isNotEmpty((String)tags) && AssertUtil.isNotEmpty((Object[])(tagArr = tags.split(",")))) {
            for (int i = 0; i < tagArr.length; ++i) {
                String tmp = FeatureParse.validTag((String)tagArr[i]);
                if (tmp == null) continue;
                ret = FeatureParse.validTag((String)tagArr[i]);
            }
        }
        return ret;
    }

    public static String validTag(String tag) {
        String ret = null;
        if (AssertUtil.isNotEmpty((String)tag) && tag.contains(".")) {
            ret = tag;
        }
        return ret;
    }

    public static Map<String, Map<String, Long>> getUserBehavioralPreference(String uIIds, String uILaunchPv, String uIClickPv, String uIEffectPv) {
        HashMap<String, Map<String, Long>> ret = new HashMap<String, Map<String, Long>>();
        ret.put("ctr", new HashMap());
        ret.put("cvr", new HashMap());
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{uIIds, uILaunchPv, uIClickPv, uIEffectPv})) {
            String[] uIIdsArr = uIIds.split(",");
            String[] uILaunchPvArr = uILaunchPv.split(",");
            String[] uIClickPvArr = uIClickPv.split(",");
            String[] uIEffectPvArr = uIEffectPv.split(",");
            if (uIIdsArr.length > 0 && uIIdsArr.length == uILaunchPvArr.length && uIIdsArr.length == uIClickPvArr.length && uIIdsArr.length == uIEffectPvArr.length) {
                Long launchAccPv = 0L;
                Long clickAccPv = 0L;
                Long effectAccPv = 0L;
                for (int i = 0; i < uIIdsArr.length; ++i) {
                    String id = uIIdsArr[i];
                    Long launchPv = DataUtil.str2Long((String)uILaunchPvArr[i], (Long)0L);
                    Long clickPv = DataUtil.str2Long((String)uIClickPvArr[i], (Long)0L);
                    Long effectPv = DataUtil.str2Long((String)uIEffectPvArr[i], (Long)0L);
                    Double ctr = FeatureParse.getCtrOrCvr(launchPv, clickPv);
                    Double cvr = FeatureParse.getCtrOrCvr(clickPv, effectPv);
                    Long ctrBucketLevel = FeatureParse.bucket(ctr, userCtrBucket);
                    Long cvrBucketLevel = FeatureParse.bucket(cvr, userCvrBucket);
                    ((Map)ret.get("ctr")).put(id, ctrBucketLevel);
                    ((Map)ret.get("cvr")).put(id, cvrBucketLevel);
                    launchAccPv = launchAccPv + launchPv;
                    clickAccPv = clickAccPv + clickPv;
                    effectAccPv = effectAccPv + effectPv;
                }
                Double ctr = FeatureParse.getCtrOrCvr(launchAccPv, clickAccPv);
                Double cvr = FeatureParse.getCtrOrCvr(clickAccPv, effectAccPv);
                Long ctrBucketLevel = FeatureParse.bucket(ctr, userCtrBucket);
                Long cvrBucketLevel = FeatureParse.bucket(cvr, userCvrBucket);
                ((Map)ret.get("ctr")).put("0", ctrBucketLevel);
                ((Map)ret.get("cvr")).put("0", cvrBucketLevel);
            }
        }
        return ret;
    }

    public static Double getCtrOrCvr(Long firstPv, Long secondPv) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{firstPv, secondPv}) && firstPv > 0L) {
            ret = DataUtil.division((Long)secondPv, (Long)firstPv);
        }
        return ret;
    }

    public static Long bucket(Long value, int[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                int bound = bucketList[i];
                if (value > (long)bound) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static Long bucket(Double value, double[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i];
                if (!(value <= bound)) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static Long bucket(Integer value, int[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                int bound = bucketList[i];
                if (value > bound) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static double log(double value, double base) {
        return Math.log(value) / Math.log(base);
    }

    public static String getSlotAreaType(Integer slotLength, Integer slotWidth) {
        int ret1 = 12;
        if (slotLength == null || slotWidth == null) {
            return String.valueOf(ret1);
        }
        try {
            Integer area = slotLength * slotWidth;
            if (area >= 0 && area <= 500000) {
                ret1 = area / 50000;
            }
            if (area > 500000 && area != null) {
                ret1 = 11;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return String.valueOf(ret1);
    }

    public static String categoryIdAndCnt(Map<String, Long> categoryCount, Integer categoryType) {
        String ret1 = null;
        if (categoryCount == null) {
            return ret1;
        }
        if (categoryType == 1) {
            for (Map.Entry<String, Long> entry : categoryCount.entrySet()) {
                String key = entry.getKey();
                try {
                    Long value = entry.getValue();
                    String valueRet = null;
                    valueRet = value >= 1L && value <= 3L ? "g1" : (value >= 4L && value <= 10L ? "g2" : (value >= 11L && value <= 20L ? "g3" : "g4"));
                    String ret = key + "&" + valueRet;
                    ret1 = ret1 + "," + ret;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            for (Map.Entry<String, Long> entry : categoryCount.entrySet()) {
                String key = entry.getKey();
                try {
                    Long value = entry.getValue();
                    String valueRet = null;
                    valueRet = value == 1L ? "g1" : (value == 2L || value == 3L ? "g2" : (value >= 4L && value <= 8L ? "g3" : "g4"));
                    String ret = key + "&" + valueRet;
                    ret1 = ret1 + "," + ret;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return ret1;
    }

    public static Long getResourceOrderRank(String operatingResource, Map<String, Long> dayResourceOrderRank) {
        Long rank;
        Long ret = null;
        ret = operatingResource == null || dayResourceOrderRank == null ? null : ((rank = dayResourceOrderRank.get(operatingResource + "-770101")) == null || rank < 1L ? Long.valueOf(1L) : (rank <= 7L ? Long.valueOf(rank + 1L) : Long.valueOf(-1L)));
        return ret;
    }

    public static Long getResourceOrderGmtIntervelLevel(String operatingResource, String currentGmtCreateTime, Map<String, String> resourceLastGmtCreateTime) {
        Long ret = null;
        if (operatingResource == null || currentGmtCreateTime == null || resourceLastGmtCreateTime == null) {
            ret = null;
        } else {
            String lastGmtCreateTime = resourceLastGmtCreateTime.get(operatingResource + "-770201");
            if (lastGmtCreateTime == null) {
                ret = null;
            } else {
                Long timeStamp = LocalDateUtil.getTimeMillis((String)currentGmtCreateTime, (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                Long otherTimeStamp = Long.valueOf(lastGmtCreateTime);
                if (timeStamp == null || otherTimeStamp == null) {
                    return ret;
                }
                Long seconds = Math.abs((timeStamp - otherTimeStamp) / 1000L);
                ret = seconds == null ? Long.valueOf(-1L) : (seconds <= 5L ? Long.valueOf(1L) : (seconds <= 10L ? Long.valueOf(2L) : (seconds <= 30L ? Long.valueOf(3L) : (seconds <= 60L ? Long.valueOf(4L) : (seconds <= 300L ? Long.valueOf(5L) : (seconds <= 600L ? Long.valueOf(6L) : (seconds <= 1800L ? Long.valueOf(7L) : (seconds <= 3600L ? Long.valueOf(8L) : (seconds <= 18000L ? Long.valueOf(9L) : (seconds <= 36000L ? Long.valueOf(10L) : (seconds <= 54000L ? Long.valueOf(11L) : (seconds <= 72000L ? Long.valueOf(12L) : (seconds <= 86400L ? Long.valueOf(13L) : (seconds <= 129600L ? Long.valueOf(14L) : (seconds <= 172800L ? Long.valueOf(15L) : Long.valueOf(99L))))))))))))))));
            }
        }
        return ret;
    }

    public static Long getResourceLastOrderIsClick(String operatingResource, Map<String, String> resourceLastLaunchOrderId, Map<String, String> resourceLastClickOrderId) {
        Long ret = null;
        if (operatingResource == null || resourceLastLaunchOrderId == null || resourceLastClickOrderId == null) {
            ret = null;
        } else {
            String lastLaunchOrderId = resourceLastLaunchOrderId.get(operatingResource + "-770301_1");
            String lastClickOrderId = resourceLastClickOrderId.get(operatingResource + "-770301_2");
            ret = lastLaunchOrderId == null ? null : (lastClickOrderId == null ? Long.valueOf(0L) : (lastLaunchOrderId.equals(lastClickOrderId) ? Long.valueOf(1L) : Long.valueOf(0L)));
        }
        return ret;
    }

    public static Long getResourceLastOrderIsConvert(String operatingResource, Map<String, String> resourceLastLaunchOrderId, Map<String, String> resourceLastConvertOrderId) {
        Long ret = null;
        if (operatingResource == null || resourceLastLaunchOrderId == null || resourceLastConvertOrderId == null) {
            ret = null;
        } else {
            String lastLaunchOrderId = resourceLastLaunchOrderId.get(operatingResource + "-770301_1");
            String lastConvertOrderId = resourceLastConvertOrderId.get(operatingResource + "-770301_3");
            ret = lastLaunchOrderId == null ? null : (lastConvertOrderId == null ? Long.valueOf(0L) : (lastLaunchOrderId.equals(lastConvertOrderId) ? Long.valueOf(1L) : Long.valueOf(0L)));
        }
        return ret;
    }

    public static Long getResourceChargeCnt(String operatingResource, Map<String, Long> dayResourceChargeCnt) {
        Long cnt;
        Long ret = null;
        ret = operatingResource == null || dayResourceChargeCnt == null ? null : ((cnt = dayResourceChargeCnt.get(operatingResource + "-770401")) == null || cnt < 1L ? Long.valueOf(0L) : (cnt <= 7L ? cnt : Long.valueOf(-1L)));
        return ret;
    }

    public static Long getResourceConvertCnt(String operatingResource, Map<String, Long> dayResourceConvertCnt) {
        Long cnt;
        Long ret = null;
        ret = operatingResource == null || dayResourceConvertCnt == null ? null : ((cnt = dayResourceConvertCnt.get(operatingResource + "-770402")) == null || cnt < 1L ? Long.valueOf(0L) : (cnt <= 7L ? cnt : Long.valueOf(-1L)));
        return ret;
    }

    public static Long getLastResourceEqualStatus(String operatingResource, String lastOperatingResource) {
        Long ret = null;
        ret = operatingResource == null && lastOperatingResource == null ? null : (operatingResource != null && lastOperatingResource != null ? (operatingResource.equals(lastOperatingResource) ? Long.valueOf(1L) : Long.valueOf(0L)) : Long.valueOf(0L));
        return ret;
    }

    public static Long getNewTradeOrderRank(String operatingNewTrade, Map<String, Long> newTradeDayOrderRank) {
        Long ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{operatingNewTrade, newTradeDayOrderRank})) {
            Long rank = newTradeDayOrderRank.get(operatingNewTrade + "-660101");
            ret = rank == null || rank < 1L ? Long.valueOf(1L) : (rank <= 7L ? Long.valueOf(rank + 1L) : Long.valueOf(99L));
        }
        return ret;
    }

    public static Long getLastNewTradeEqualStatus(String operatingNewTrade, String lastOperatingNewTrade) {
        Long ret = 0L;
        if (AssertUtil.isAllEmpty((Object[])new Object[]{operatingNewTrade, lastOperatingNewTrade})) {
            ret = null;
        } else if (AssertUtil.isAllNotEmpty((Object[])new Object[]{operatingNewTrade, lastOperatingNewTrade})) {
            ret = operatingNewTrade.equals(lastOperatingNewTrade) ? Long.valueOf(1L) : Long.valueOf(0L);
        }
        return ret;
    }

    public static Long getLastNewTradeGmtIntervelLevel(String operatingNewTrade, String currentGmtCreateTime, Map<String, String> newTradeLastGmtCreateTime) {
        Long ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{operatingNewTrade, currentGmtCreateTime, newTradeLastGmtCreateTime})) {
            String lastGmtCreateTime = newTradeLastGmtCreateTime.get(operatingNewTrade + "-660301");
            if (lastGmtCreateTime == null) {
                ret = null;
            } else {
                Long otherTimeStamp;
                Long timeStamp = LocalDateUtil.getTimeMillis((String)currentGmtCreateTime, (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                if (AssertUtil.isAnyEmpty((Object[])new Object[]{timeStamp, otherTimeStamp = Long.valueOf(lastGmtCreateTime)})) {
                    return ret;
                }
                Long seconds = Math.abs((timeStamp - otherTimeStamp) / 1000L);
                ret = seconds == null ? Long.valueOf(-1L) : (seconds <= 5L ? Long.valueOf(1L) : (seconds <= 10L ? Long.valueOf(2L) : (seconds <= 30L ? Long.valueOf(3L) : (seconds <= 60L ? Long.valueOf(4L) : (seconds <= 300L ? Long.valueOf(5L) : (seconds <= 600L ? Long.valueOf(6L) : (seconds <= 1800L ? Long.valueOf(7L) : (seconds <= 3600L ? Long.valueOf(8L) : (seconds <= 18000L ? Long.valueOf(9L) : (seconds <= 36000L ? Long.valueOf(10L) : (seconds <= 54000L ? Long.valueOf(11L) : (seconds <= 72000L ? Long.valueOf(12L) : (seconds <= 86400L ? Long.valueOf(13L) : Long.valueOf(99L))))))))))))));
            }
        }
        return ret;
    }

    public static String getCtrOrCvrInKey(Map<String, Long> firstMap, Map<String, Long> secondMap, double[] statCtrOrCvrBucket) {
        String ret = null;
        try {
            if (AssertUtil.isNotEmpty(firstMap)) {
                for (Map.Entry<String, Long> entry : firstMap.entrySet()) {
                    String key = entry.getKey();
                    if (key == null) continue;
                    Long firstPv = entry.getValue();
                    if (firstPv == null) {
                        firstPv = 0L;
                    }
                    Long secondPv = 0L;
                    if (AssertUtil.isNotEmpty(secondMap)) {
                        secondPv = secondMap.getOrDefault(key, 0L);
                    }
                    Double value = FeatureParse.getCtrOrCvr(firstPv, secondPv);
                    Long valueLevel = FeatureParse.bucket(value, statCtrOrCvrBucket);
                    String tmpRet = key + "&" + DataUtil.Long2String((Long)valueLevel);
                    ret = ret + "," + tmpRet;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String getStatInNewTrade(String statType, Map<String, Map<String, Long>> newTradeMap) {
        String ret = null;
        try {
            if (AssertUtil.isNotEmpty(newTradeMap)) {
                Map<String, Long> launchMap = newTradeMap.get("launch");
                Map<String, Long> clickMap = newTradeMap.get("click");
                Map<String, Long> effectMap = newTradeMap.get("effect");
                if (statType == "ctr") {
                    if (AssertUtil.isNotEmpty(launchMap)) {
                        ret = FeatureParse.getCtrOrCvrInKey(launchMap, clickMap, statCtrBucket);
                    }
                } else if (statType == "cvr" && AssertUtil.isNotEmpty(clickMap)) {
                    ret = FeatureParse.getCtrOrCvrInKey(clickMap, effectMap, statCvrBucket);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String getStatInAppTag(String statType, Map<String, Map<String, Long>> appTagMap) {
        String ret = null;
        try {
            if (AssertUtil.isNotEmpty(appTagMap)) {
                Map<String, Long> launchMap = appTagMap.get("launch");
                Map<String, Long> clickMap = appTagMap.get("click");
                Map<String, Long> effectMap = appTagMap.get("effect");
                if (statType == "ctr") {
                    if (AssertUtil.isNotEmpty(launchMap)) {
                        ret = FeatureParse.getCtrOrCvrInKey(launchMap, clickMap, statCtrBucket);
                    }
                } else if (statType == "cvr" && AssertUtil.isNotEmpty(clickMap)) {
                    ret = FeatureParse.getCtrOrCvrInKey(clickMap, effectMap, statCvrBucket);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String getCrossFeature(String ids, String id0) {
        String ret = null;
        if (ids == null || "".equals(ids) || " ".equals(ids) || ",".equals(ids) || id0 == null || "".equals(id0) || " ".equals(id0)) {
            ret = "null";
        } else {
            ArrayList<String> crossFeature = new ArrayList<String>();
            try {
                for (String id : ids.split(",")) {
                    if (id == "" || id == " ") continue;
                    crossFeature.add(id + "_" + id0);
                }
                if (crossFeature.size() > 0) {
                    ret = Joiner.on((String)",").skipNulls().join(crossFeature);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (ret == null || ret == "" || ret == " " || ret == ",") {
            ret = "null";
        }
        if (!ret.equalsIgnoreCase("null")) {
            ret = "null," + ret;
        }
        return ret;
    }

    public static String getUserCategoryActLevelByBucket(Map<String, Integer> actMap, Map<String, Integer> category, int[] buckets) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{actMap, category, buckets})) {
            return null;
        }
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;
        Object[] retArr = new Long[actMap.size()];
        int index = 0;
        for (Map.Entry<String, Integer> entry : actMap.entrySet()) {
            String cateKey = entry.getKey();
            Integer cateValue = entry.getValue();
            if (!category.containsKey(cateKey)) continue;
            Integer i = category.get(cateKey);
            long value = (long)(i * limit) + FeatureParse.bucket(cateValue, buckets);
            retArr[index] = value;
            ++index;
        }
        return StringUtils.join((Object[])retArr, (String)",");
    }

    public static void main(String[] args) {
        Map ua = DataUtil.stringToMap((String)"{\"f_d\":3}", (Object)"");
        Map ar = DataUtil.stringToMap((String)"{\"w_a_r\":3,\"a_r\":12,\"i_a_r\":7,\"p_a_r\":0}", (Object)"");
        Map aj = DataUtil.stringToMap((String)"{\"w_a_j\":1,\"a_j\":3,\"i_a_j\":7,\"p_a_j\":0}", (Object)"");
        Map lt = DataUtil.stringToMap((String)"{\"w_l_t\":{\"21\":2},\"l_t\":{\"21\":5,\"9\":2},\"l_l_t\":21,\"c_l_t\":0,\"i_l_t\":7,\"p_l_t\":0}", (Object)"");
        Map ct = DataUtil.stringToMap((String)"{\"c_t\":{\"9\":2},\"l_c_t\":9,\"e_c_t\":0,\"i_c_t\":9,\"p_c_t\":0}", (Object)"");
        Map et = DataUtil.stringToMap((String)"{\"w_e_t\":{\"9\":1},\"e_t\":{\"9\":1},\"l_e_t\":9,\"i_e_t\":9,\"p_e_t\":0}", (Object)"");
        Map lc = DataUtil.stringToMap((String)"{\"l_c\":{\"07.23.0008\":2},\"l_l_c\":\"07.23.0008\",\"c_l_c\":1,\"i_l_c\":9,\"p_l_c\":0}", (Object)"");
        Map cc = DataUtil.stringToMap((String)"{\"c_c\":{\"07.23.0008\":2},\"l_c_c\":\"07.23.0008\",\"e_c_c\":0,\"ie_c_c\":0,\"i_c_c\":9,\"p_c_c\":0}", (Object)"");
        Map ec = DataUtil.stringToMap((String)"{\"w_e_c\":{\"07.23.0008\":1},\"e_c\":{\"07.23.0008\":1},\"l_e_c\":\"07.23.0008\",\"l_e_b\":0,\"i_e_c\":9,\"p_e_c\":0,\"add_c\":0,\"num_c\":1}", (Object)"");
        Map iec = DataUtil.stringToMap((String)"{\"ie_c\":{\"07.23.0008\":1},\"l_ie_c\":\"07.23.0008\",\"l_ie_b\":0,\"i_ie_c\":9,\"p_ie_c\":0}", (Object)"");
        Map c_lvl = DataUtil.stringToMap((String)"{\"o_f\":5900,\"max_o_f\":5900,\"min_o_f\":5900,\"avg_o_f\":5900,\"l_o_f\":5900}", (Object)"");
        Map c_m = DataUtil.stringToMap((String)"{\"non_0_c\":1,\"non_0_e\":1}", (Object)"");
        Map r = DataUtil.stringToMap((String)"{\"v_f\":2,\"w_v_f\":2,\"i_v_f\":2}", (Object)"");
        FeatureDo featureDo = new FeatureDo();
        DmpFeature dmpFeature = new DmpFeature();
        UserActFeature userActFeature = new UserActFeature();
        String f_d = ua.get("f_d").toString();
        Integer userActiveDays = ua.containsKey("f_d") ? Integer.valueOf(Integer.parseInt(f_d)) : null;
        userActFeature.setUserActiveDays(userActiveDays);
        userActFeature.setActivityRequest(ar.containsKey("a_r") ? Integer.valueOf(Integer.parseInt(ar.get("a_r").toString())) : null);
        userActFeature.setWeekActivityRequest(ar.containsKey("w_a_r") ? Integer.valueOf(Integer.parseInt(ar.get("w_a_r").toString())) : null);
        userActFeature.setDayActivityRequest(ar.containsKey("d_a_r") ? Integer.valueOf(Integer.parseInt(ar.get("d_a_r").toString())) : null);
        userActFeature.setIntervalActivityRequest(ar.containsKey("i_a_r") ? Integer.valueOf(Integer.parseInt(ar.get("i_a_r").toString())) : null);
        userActFeature.setPeriodActivityRequest(ar.containsKey("p_a_r") ? ar.get("p_a_r").toString() : null);
        userActFeature.setActivityJoin(aj.containsKey("a_j") ? Integer.valueOf(Integer.parseInt(aj.get("a_j").toString())) : null);
        userActFeature.setWeekActivityJoin(aj.containsKey("w_a_j") ? Integer.valueOf(Integer.parseInt(aj.get("w_a_j").toString())) : null);
        userActFeature.setDayActivityJoin(aj.containsKey("d_a_j") ? Integer.valueOf(Integer.parseInt(aj.get("d_a_j").toString())) : null);
        userActFeature.setIntervalActivityJoin(aj.containsKey("i_a_j") ? Integer.valueOf(Integer.parseInt(aj.get("i_a_j").toString())) : null);
        userActFeature.setPeriodActivityJoin(aj.containsKey("p_a_j") ? aj.get("p_a_j").toString() : null);
        userActFeature.setActivityPageStay(aj.containsKey("a_s") ? Integer.valueOf(Integer.parseInt(aj.get("a_s").toString())) : null);
        userActFeature.setLaunchTrade(lt.containsKey("l_t") ? lt.get("l_t").toString() : null);
        userActFeature.setWeekLaunchTrade(lt.containsKey("w_l_t") ? lt.get("w_l_t").toString() : null);
        userActFeature.setDayLaunchTrade(lt.containsKey("d_l_t") ? DataUtil.stringToMap((String)lt.get("d_l_t").toString(), (Object)0) : null);
        userActFeature.setIntervalLaunchTrade(lt.containsKey("i_l_t") ? Integer.valueOf(Integer.parseInt(lt.get("i_l_t").toString())) : null);
        userActFeature.setPeriodLaunchTrade(lt.containsKey("p_l_t") ? lt.get("p_l_t").toString() : null);
        userActFeature.setAvgLaunchStay(lt.containsKey("avg_l_s") ? Integer.valueOf(Integer.parseInt(lt.get("avg_l_s").toString())) : null);
        userActFeature.setLastLaunchTrade(lt.containsKey("l_l_t") ? lt.get("l_l_t").toString() : null);
        userActFeature.setClickLaunchTrade(lt.containsKey("c_l_t") ? Integer.valueOf(Integer.parseInt(lt.get("c_l_t").toString())) : null);
        userActFeature.setClickTrade(ct.containsKey("c_t") ? ct.get("c_t").toString() : null);
        userActFeature.setWeekClickTrade(ct.containsKey("w_c_t") ? ct.get("w_c_t").toString() : null);
        userActFeature.setIntervalClickTrade(ct.containsKey("i_c_t") ? Integer.valueOf(Integer.parseInt(ct.get("i_c_t").toString())) : null);
        userActFeature.setPeriodClickTrade(ct.containsKey("p_c_t") ? ct.get("p_c_t").toString() : null);
        userActFeature.setLastClickTrade(ct.containsKey("l_c_t") ? ct.get("l_c_t").toString() : null);
        userActFeature.setEffectClickTrade(ct.containsKey("e_c_t") ? Integer.valueOf(Integer.parseInt(ct.get("e_c_t").toString())) : null);
        userActFeature.setEffectTrade(et.containsKey("e_t") ? et.get("e_t").toString() : null);
        userActFeature.setWeekEffectTrade(et.containsKey("w_e_t") ? et.get("w_e_t").toString() : null);
        userActFeature.setIntervalEffectTrade(et.containsKey("i_e_t") ? Integer.valueOf(Integer.parseInt(et.get("i_e_t").toString())) : null);
        userActFeature.setPeriodEffectTrade(et.containsKey("p_e_t") ? et.get("p_e_t").toString() : null);
        userActFeature.setLastEffectTrade(et.containsKey("l_e_t") ? et.get("l_e_t").toString() : null);
        userActFeature.setLaunchCategory(lc.containsKey("l_c") ? lc.get("l_c").toString() : null);
        userActFeature.setWeekLaunchCategory(lc.containsKey("w_l_c") ? lc.get("w_l_c").toString() : null);
        userActFeature.setIntervalLaunchCategory(lc.containsKey("i_l_c") ? Integer.valueOf(Integer.parseInt(lc.get("i_l_c").toString())) : null);
        userActFeature.setPeriodLaunchCategory(lc.containsKey("p_l_c") ? lc.get("p_l_c").toString() : null);
        userActFeature.setAvgLaunchCategoryStay(lc.containsKey("avg_l_c_s") ? Integer.valueOf(Integer.parseInt(lc.get("avg_l_c_s").toString())) : null);
        userActFeature.setLastLaunchCategory(lc.containsKey("l_l_c") ? lc.get("l_l_c").toString() : null);
        userActFeature.setClickLaunchCategory(lc.containsKey("c_l_c") ? Integer.valueOf(Integer.parseInt(lc.get("c_l_c").toString())) : null);
        userActFeature.setLastLaunchBrand(lc.containsKey("l_l_b") ? lc.get("l_l_b").toString() : null);
        userActFeature.setClickCategory(cc.containsKey("c_c") ? cc.get("c_c").toString() : null);
        userActFeature.setWeekClickCategory(cc.containsKey("w_c_c") ? cc.get("w_c_c").toString() : null);
        userActFeature.setIntervalClickCategory(cc.containsKey("i_c_c") ? Integer.valueOf(Integer.parseInt(cc.get("i_c_c").toString())) : null);
        userActFeature.setPeriodClickCategory(cc.containsKey("p_c_c") ? cc.get("p_c_c").toString() : null);
        userActFeature.setAvgLandpageStay(cc.containsKey("avg_lp_s") ? Integer.valueOf(Integer.parseInt(cc.get("avg_lp_s").toString())) : null);
        userActFeature.setLastClickCategory(cc.containsKey("l_c_c") ? cc.get("l_c_c").toString() : null);
        userActFeature.setEffectClickCategory(cc.containsKey("e_c_c") ? Integer.valueOf(Integer.parseInt(cc.get("e_c_c").toString())) : null);
        userActFeature.setLastClickBrand(cc.containsKey("l_c_b") ? cc.get("l_c_b").toString() : null);
        userActFeature.setIssueEffectClickCategory(cc.containsKey("ie_c_c") ? Integer.valueOf(Integer.parseInt(cc.get("ie_c_c").toString())) : null);
        userActFeature.setEffectCategory(ec.containsKey("e_c") ? ec.get("e_c").toString() : null);
        userActFeature.setWeekEffectCategory(ec.containsKey("w_e_c") ? ec.get("w_e_c").toString() : null);
        userActFeature.setIntervalEffectCategory(ec.containsKey("i_e_c") ? Integer.valueOf(Integer.parseInt(ec.get("i_e_c").toString())) : null);
        userActFeature.setPeriodEffectCategory(ec.containsKey("p_e_c") ? ec.get("p_e_c").toString() : null);
        userActFeature.setLastEffectCategory(ec.containsKey("l_e_c") ? ec.get("l_e_c").toString() : null);
        userActFeature.setLastEffectBrand(ec.containsKey("l_e_b") ? ec.get("l_e_b").toString() : null);
        userActFeature.setAddressCount(ec.containsKey("add_c") ? Integer.valueOf(Integer.parseInt(ec.get("add_c").toString())) : null);
        userActFeature.setNumberCount(ec.containsKey("num_c") ? Integer.valueOf(Integer.parseInt(ec.get("num_c").toString())) : null);
        userActFeature.setIssueEffectCategory(iec.containsKey("ie_c") ? iec.get("ie_c").toString() : null);
        userActFeature.setWeekIssueEffectCategory(iec.containsKey("w_ie_c") ? iec.get("w_ie_c").toString() : null);
        userActFeature.setIntervalIssueEffectCategory(iec.containsKey("i_ie_c") ? Integer.valueOf(Integer.parseInt(iec.get("i_ie_c").toString())) : null);
        userActFeature.setPeriodIssueEffectCategory(iec.containsKey("p_ie_c") ? iec.get("p_ie_c").toString() : null);
        userActFeature.setLastIssueEffectCategory(iec.containsKey("l_ie_c") ? iec.get("l_ie_c").toString() : null);
        userActFeature.setLastIssueEffectBrand(iec.containsKey("l_ie_b") ? iec.get("l_ie_b").toString() : null);
        userActFeature.setOrderFee(c_lvl.containsKey("o_f") ? Integer.valueOf(Integer.parseInt(c_lvl.get("o_f").toString())) : null);
        userActFeature.setWeekOrderFee(c_lvl.containsKey("w_o_f") ? Integer.valueOf(Integer.parseInt(c_lvl.get("w_o_f").toString())) : null);
        userActFeature.setMaxOrderFee(c_lvl.containsKey("max_o_f") ? Integer.valueOf(Integer.parseInt(c_lvl.get("max_o_f").toString())) : null);
        userActFeature.setMinOrderFee(c_lvl.containsKey("min_o_f") ? Integer.valueOf(Integer.parseInt(c_lvl.get("min_o_f").toString())) : null);
        userActFeature.setAvgOrderFee(c_lvl.containsKey("avg_o_f") ? Integer.valueOf(Integer.parseInt(c_lvl.get("avg_o_f").toString())) : null);
        userActFeature.setLastOrderFee(c_lvl.containsKey("l_o_f") ? Integer.valueOf(Integer.parseInt(c_lvl.get("l_o_f").toString())) : null);
        userActFeature.setZeroLaunch(c_m.containsKey("0_l") ? Integer.valueOf(Integer.parseInt(c_m.get("0_l").toString())) : null);
        userActFeature.setNonZeroLaunch(c_m.containsKey("non_0_l") ? Integer.valueOf(Integer.parseInt(c_m.get("non_0_l").toString())) : null);
        userActFeature.setZeroClick(c_m.containsKey("0_c") ? Integer.valueOf(Integer.parseInt(c_m.get("0_c").toString())) : null);
        userActFeature.setNonZeroClick(c_m.containsKey("non_0_c") ? Integer.valueOf(Integer.parseInt(c_m.get("non_0_c").toString())) : null);
        userActFeature.setZeroEffect(c_m.containsKey("0_e") ? Integer.valueOf(Integer.parseInt(c_m.get("0_e").toString())) : null);
        userActFeature.setNonZeroEffect(c_m.containsKey("non_0_e") ? Integer.valueOf(Integer.parseInt(c_m.get("non_0_e").toString())) : null);
        userActFeature.setZeroIssueEffect(c_m.containsKey("0_ie") ? Integer.valueOf(Integer.parseInt(c_m.get("0_ie").toString())) : null);
        userActFeature.setNonZeroIssueEffect(c_m.containsKey("non_0_ie") ? Integer.valueOf(Integer.parseInt(c_m.get("non_0_ie").toString())) : null);
        userActFeature.setVouchFailed(r.containsKey("v_f") ? Integer.valueOf(Integer.parseInt(r.get("v_f").toString())) : null);
        userActFeature.setWeekVouchFailed(r.containsKey("w_v_f") ? Integer.valueOf(Integer.parseInt(r.get("w_v_f").toString())) : null);
        userActFeature.setIntervalVouchFailed(r.containsKey("i_v_f") ? Integer.valueOf(Integer.parseInt(r.get("i_v_f").toString())) : null);
        userActFeature.setReject(r.containsKey("r") ? Integer.valueOf(Integer.parseInt(r.get("r").toString())) : null);
        userActFeature.setWeekReject(r.containsKey("w_r") ? Integer.valueOf(Integer.parseInt(r.get("w_r").toString())) : null);
        userActFeature.setIntervalReject(r.containsKey("i_r") ? Integer.valueOf(Integer.parseInt(r.get("i_r").toString())) : null);
        userActFeature.setComplaint(r.containsKey("cp") ? Integer.valueOf(Integer.parseInt(r.get("cp").toString())) : null);
        userActFeature.setWeekComplaint(r.containsKey("w_cp") ? Integer.valueOf(Integer.parseInt(r.get("w_cp").toString())) : null);
        userActFeature.setIntervalComplaint(r.containsKey("i_cp") ? Integer.valueOf(Integer.parseInt(r.get("i_cp").toString())) : null);
        userActFeature.setAddressException(r.containsKey("add_ex") ? Integer.valueOf(Integer.parseInt(r.get("add_ex").toString())) : null);
        userActFeature.setWeekAddressException(r.containsKey("w_add_ex") ? Integer.valueOf(Integer.parseInt(r.get("w_add_ex").toString())) : null);
        userActFeature.setIntervalAddressException(r.containsKey("i_add_ex") ? Integer.valueOf(Integer.parseInt(r.get("i_add_ex").toString())) : null);
        userActFeature.setNumberEmpty(r.containsKey("num_emp") ? Integer.valueOf(Integer.parseInt(r.get("num_emp").toString())) : null);
        userActFeature.setWeekNumberEmpty(r.containsKey("w_num_emp") ? Integer.valueOf(Integer.parseInt(r.get("w_num_emp").toString())) : null);
        userActFeature.setIntervalNumberEmpty(r.containsKey("i_num_emp") ? Integer.valueOf(Integer.parseInt(r.get("i_num_emp").toString())) : null);
        userActFeature.setCheat(r.containsKey("ct") ? Integer.valueOf(Integer.parseInt(r.get("ct").toString())) : null);
        userActFeature.setWeekCheat(r.containsKey("w_ct") ? Integer.valueOf(Integer.parseInt(r.get("w_ct").toString())) : null);
        userActFeature.setIntervalCheat(r.containsKey("i_ct") ? Integer.valueOf(Integer.parseInt(r.get("i_ct").toString())) : null);
        dmpFeature.setUserActFeature(userActFeature);
        featureDo.setDmpFeature(dmpFeature);
        Map<String, String> res = FeatureParse.generateFeatureMapStatic(featureDo);
        System.out.println();
    }

    public static int countFeatures(String valueList) {
        if (valueList == null) {
            return -1;
        }
        if (valueList.isEmpty()) {
            return 0;
        }
        String[] idArr = valueList.split(",");
        if (idArr == null) {
            return -1;
        }
        return idArr.length;
    }
}

