package cn.com.duiba.nezha.alg.feature.vo;

import java.io.Serializable;
import java.util.Map;

public class UserActFeature implements Serializable {

    private static final long serialVersionUID = -2203632123858487448L;

    // 用户属性
    private Integer userActiveDays;  // f410001 用户生命周期（天）

    // 用户行为
    // 活动访问
    private Integer activityRequest;   //f411001 历史活动访问次数
    private Integer weekActivityRequest;   //f411002  一周内活动访问次数
    private Integer dayActivityRequest;    //f411003 当日活动访问次数
    private Integer intervalActivityRequest;   //f411004	 历史距离上一次活动访问时间间隔（天）
    private String periodActivityRequest;   //f411005 历史活动访问频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）

    // 活动参与
    private Integer activityJoin;  //f412001 历史活动参与次数
    private Integer weekActivityJoin;  //f412002 一周内活动参与次数
    private Integer dayActivityJoin;   //f412003 当日活动参与次数
    private Integer intervalActivityJoin;  //f412004 历史距离上一次活动参与时间间隔（天）
    private String periodActivityJoin;  //f412005 历史活动参与频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private Integer activityPageStay;  //f412006 历史活动页平均停留时长（秒）

    // 发券
    private String launchTrade; //f413001 历史不同行业上发券数量
    private String weekLaunchTrade; //f413002 一周内不同行业发券数量
    private Map<String, Integer> dayLaunchTrade;  //f413003 当日不同行业发券数量
    private Integer intervalLaunchTrade;   //f413004 历史距离上一次发券时间间隔（天）
    private String periodLaunchTrade;   //f413005 历史发券频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private Integer avgLaunchStay; //f413006 历史券展示平均时长（秒）
    private String lastLaunchTrade; //f413007 上一次发券行业
    private Integer clickLaunchTrade;   //f413008 上一次发券是否点击

    // 券点击
    private String clickTrade;  //f414001 历史不同行业上券点击数量
    private String weekClickTrade;  //f414002 一周内不同行业上券点击数量
    private Map<String, Integer> dayClickTrade;   //f414003 当日不同行业上券点击数量
    private Integer intervalClickTrade;    //f414004 历史距离上一次券点击时间间隔（天）
    private String periodClickTrade;    //f414005 历史券点击频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private String lastClickTrade;  //f414007 上一次券点击行业
    private Integer effectClickTrade;   //f414008 上一次券点击是否转化

    // 转化
    private String effectTrade; //f415001 历史不同行业上转化数量
    private String weekEffectTrade; //f415002 一周内不同行业上转化数量
    private Map<String, Integer> dayEffectTrade;  //f415003 当日不同行业上转化数量
    private Integer intervalEffectTrade;   //f415004 历史距离上一次转化时间间隔（天）
    private String periodEffectTrade;   //f415005 历史转化频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private String lastEffectTrade; //f415007 上一次转化行业

    // 二类电商行为
    // 发券
    private String launchCategory;  //f423001 历史二类电商不同品类发券数量
    private String weekLaunchCategory;  //f423002 一周内二类电商不同品类发券数量
    private Map<String, Integer> dayLaunchCategory;   //f423003 当日二类电商不同品类发券数量
    private Integer intervalLaunchCategory;    //f423004 历史距离上一次二类电商发券时间间隔（天）
    private String periodLaunchCategory;    //f423005 历史二类电商发券频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private Integer avgLaunchCategoryStay; //f423006 历史二类电商券展示平均时长（秒）
    private String lastLaunchCategory;  //f423007 上一次二类电商发券品类
    private Integer clickLaunchCategory;    //f423008 上一次二类电商发券是否点击
    private String lastLaunchBrand;  //f423009 上一次二类电商发券品牌

    // 券点击
    private String clickCategory;   //f424001 历史二类电商不同品类券点击数量
    private String weekClickCategory;   //f424002 一周内二类电商不同品类券点击数量
    private Map<String, Integer> dayClickCategory;    //f424003 当日二类电商不同品类券点击数量
    private Integer intervalClickCategory; //f424004 历史距离上一次二类电商券点击时间间隔（天）
    private String periodClickCategory; //f424005 历史二类电商券点击频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private Integer avgLandpageStay;   //f424006 历史二类电商落地页展示平均时长（秒）
    private String lastClickCategory;   //f424007 上一次二类电商券点击品类
    private Integer effectClickCategory;    //f424008 上一次二类电商券点击是否转化
    private String lastClickBrand;  //f424009 上一次二类电商券点击品牌
    private Integer issueEffectClickCategory;   //f424010 上一次二类电商券点击是否出单转化

    // 前端转化
    private String effectCategory;  //f425001 历史二类电商不同品类转化数量
    private String weekEffectCategory;  //f425002 一周内二类电商不同品类转化数量
    private Map<String, Integer> dayEffectCategory;   //f425003 当日二类电商不同品类转化数量
    private Integer intervalEffectCategory;    //f425004 历史距离上一次二类电商转化时间间隔（天）
    private String periodEffectCategory;    //f425005 历史二类电商转化频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private String lastEffectCategory;  //f425007 上一次二类电商转化品类
    private String lastEffectBrand; //f425009 上一次二类电商转化品牌
    private Integer addressCount;   //f425011 历史使用地址数量
    private Integer numberCount;    //f425012 历史手机号使用数量

    // 出单转化
    private String issueEffectCategory; //f426001 历史二类电商不同品类转化数量
    private String weekIssueEffectCategory; //f426002 一周内二类电商不同品类转化数量
    private Integer intervalIssueEffectCategory;   //f426004 历史距离上一次二类电商转化时间间隔（天）
    private String periodIssueEffectCategory;   //f426005 历史二类电商转化频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private String lastIssueEffectCategory; //f426007 上一次二类电商转化品类
    private String lastIssueEffectBrand;    //f426009 上一次二类电商转化品牌

    // 品类兴趣偏好
    private String scoreEffectCategory; //f431001 历史签收数
    private String scoreIssueEffectCategory;    //f431002 历史核单数

    // 消费水平
    private Integer orderFee;    //f432001 历史累计下单实际金额（签收成功）
    private Integer weekOrderFee;    //f432002 一周内累计下单实际金额（签收成功）
    private Integer maxOrderFee; //f432003 历史最大下单实际金额（签收成功）
    private Integer minOrderFee; //f432004 历史最小下单实际金额（签收成功）
    private Integer avgOrderFee; //f432005 平均下单实际金额（签收成功）
    private Integer lastOrderFee;    //f432006 上次下单实际金额（签收成功）

    // 消费心理
    private Integer zeroLaunch;    //f433001 历史展示金额为0的商品发券次数
    private Integer nonZeroLaunch; //f433002 历史展示金额不为0的商品发券次数
    private Integer zeroClick; //f433003 历史展示金额为0的商品券点击次数
    private Integer nonZeroClick;  //f433004 历史展示金额不为0的商品券点击次数
    private Integer zeroEffect;    //f433005 历史展示金额为0的商品前端转化次数
    private Integer nonZeroEffect; //f433006 历史展示金额不为0的商品前端转化次数
    private Integer zeroIssueEffect;   //f433007 历史展示金额为0的商品出单转化次数
    private Integer nonZeroIssueEffect;    //f433008 历史展示金额不为0的商品出单转化次数

    // 风控行为
    private Integer vouchFailed;   //f434001 历史累计核单失败次数
    private Integer weekVouchFailed;   //f434002 一周内累计核单失败次数
    private Integer intervalVouchFailed;   //f434003 距离上一次核单失败时间间隔（天）
    private Integer reject;    //f434004 历史拒付费次数
    private Integer weekReject;    //f434005 一周内拒付费次数
    private Integer intervalReject;    //f434006 距离上一次拒付款时间间隔（天）
    private Integer complaint; //f434007历史投诉次数
    private Integer weekComplaint; //f434008 一周内累计投诉次数
    private Integer intervalComplaint; //f434009 距离上一次投诉时间间隔（天）
    private Integer addressException;  //f434010 历史地址异常次数
    private Integer weekAddressException;  //f434011 一周内地址异常次数
    private Integer intervalAddressException;  //f434012 距离上一次地址异常时间间隔（天）
    private Integer numberEmpty;   //f434013 历史空号/错号次数
    private Integer weekNumberEmpty;   //f434014 一周内空号/错号次数
    private Integer intervalNumberEmpty;   //f434015 距离上一次空号/错号时间间隔（天）
    private Integer cheat; //f434016 历史作弊次数
    private Integer weekCheat; //f434017 一周内作弊次数
    private Integer intervalCheat; //f434018 距离上一次作弊时间间隔（天）


    public Integer getUserActiveDays() {
        return userActiveDays;
    }

    public void setUserActiveDays(Integer userActiveDays) {
        this.userActiveDays = userActiveDays;
    }

    public Integer getActivityRequest() {
        return activityRequest;
    }

    public void setActivityRequest(Integer activityRequest) {
        this.activityRequest = activityRequest;
    }

    public Integer getWeekActivityRequest() {
        return weekActivityRequest;
    }

    public void setWeekActivityRequest(Integer weekActivityRequest) {
        this.weekActivityRequest = weekActivityRequest;
    }

    public Integer getDayActivityRequest() {
        return dayActivityRequest;
    }

    public void setDayActivityRequest(Integer dayActivityRequest) {
        this.dayActivityRequest = dayActivityRequest;
    }

    public Integer getIntervalActivityRequest() {
        return intervalActivityRequest;
    }

    public void setIntervalActivityRequest(Integer intervalActivityRequest) {
        this.intervalActivityRequest = intervalActivityRequest;
    }

    public String getPeriodActivityRequest() {
        return periodActivityRequest;
    }

    public void setPeriodActivityRequest(String periodActivityRequest) {
        this.periodActivityRequest = periodActivityRequest;
    }

    public Integer getActivityJoin() {
        return activityJoin;
    }

    public void setActivityJoin(Integer activityJoin) {
        this.activityJoin = activityJoin;
    }

    public Integer getWeekActivityJoin() {
        return weekActivityJoin;
    }

    public void setWeekActivityJoin(Integer weekActivityJoin) {
        this.weekActivityJoin = weekActivityJoin;
    }

    public Integer getDayActivityJoin() {
        return dayActivityJoin;
    }

    public void setDayActivityJoin(Integer dayActivityJoin) {
        this.dayActivityJoin = dayActivityJoin;
    }

    public Integer getIntervalActivityJoin() {
        return intervalActivityJoin;
    }

    public void setIntervalActivityJoin(Integer intervalActivityJoin) {
        this.intervalActivityJoin = intervalActivityJoin;
    }

    public String getPeriodActivityJoin() {
        return periodActivityJoin;
    }

    public void setPeriodActivityJoin(String periodActivityJoin) {
        this.periodActivityJoin = periodActivityJoin;
    }

    public Integer getActivityPageStay() {
        return activityPageStay;
    }

    public void setActivityPageStay(Integer activityPageStay) {
        this.activityPageStay = activityPageStay;
    }

    public String getLaunchTrade() {
        return launchTrade;
    }

    public void setLaunchTrade(String launchTrade) {
        this.launchTrade = launchTrade;
    }

    public String getWeekLaunchTrade() {
        return weekLaunchTrade;
    }

    public void setWeekLaunchTrade(String weekLaunchTrade) {
        this.weekLaunchTrade = weekLaunchTrade;
    }

    public Map<String, Integer> getDayLaunchTrade() {
        return dayLaunchTrade;
    }

    public void setDayLaunchTrade(Map<String, Integer> dayLaunchTrade) {
        this.dayLaunchTrade = dayLaunchTrade;
    }

    public Integer getIntervalLaunchTrade() {
        return intervalLaunchTrade;
    }

    public void setIntervalLaunchTrade(Integer intervalLaunchTrade) {
        this.intervalLaunchTrade = intervalLaunchTrade;
    }

    public String getPeriodLaunchTrade() {
        return periodLaunchTrade;
    }

    public void setPeriodLaunchTrade(String periodLaunchTrade) {
        this.periodLaunchTrade = periodLaunchTrade;
    }

    public Integer getAvgLaunchStay() {
        return avgLaunchStay;
    }

    public void setAvgLaunchStay(Integer avgLaunchStay) {
        this.avgLaunchStay = avgLaunchStay;
    }

    public String getLastLaunchTrade() {
        return lastLaunchTrade;
    }

    public void setLastLaunchTrade(String lastLaunchTrade) {
        this.lastLaunchTrade = lastLaunchTrade;
    }

    public Integer getClickLaunchTrade() {
        return clickLaunchTrade;
    }

    public void setClickLaunchTrade(Integer clickLaunchTrade) {
        this.clickLaunchTrade = clickLaunchTrade;
    }

    public String getClickTrade() {
        return clickTrade;
    }

    public void setClickTrade(String clickTrade) {
        this.clickTrade = clickTrade;
    }

    public String getWeekClickTrade() {
        return weekClickTrade;
    }

    public void setWeekClickTrade(String weekClickTrade) {
        this.weekClickTrade = weekClickTrade;
    }

    public Map<String, Integer> getDayClickTrade() {
        return dayClickTrade;
    }

    public void setDayClickTrade(Map<String, Integer> dayClickTrade) {
        this.dayClickTrade = dayClickTrade;
    }

    public Integer getIntervalClickTrade() {
        return intervalClickTrade;
    }

    public void setIntervalClickTrade(Integer intervalClickTrade) {
        this.intervalClickTrade = intervalClickTrade;
    }

    public String getPeriodClickTrade() {
        return periodClickTrade;
    }

    public void setPeriodClickTrade(String periodClickTrade) {
        this.periodClickTrade = periodClickTrade;
    }

    public String getLastClickTrade() {
        return lastClickTrade;
    }

    public void setLastClickTrade(String lastClickTrade) {
        this.lastClickTrade = lastClickTrade;
    }

    public Integer getEffectClickTrade() {
        return effectClickTrade;
    }

    public void setEffectClickTrade(Integer effectClickTrade) {
        this.effectClickTrade = effectClickTrade;
    }

    public String getEffectTrade() {
        return effectTrade;
    }

    public void setEffectTrade(String effectTrade) {
        this.effectTrade = effectTrade;
    }

    public String getWeekEffectTrade() {
        return weekEffectTrade;
    }

    public void setWeekEffectTrade(String weekEffectTrade) {
        this.weekEffectTrade = weekEffectTrade;
    }

    public Map<String, Integer> getDayEffectTrade() {
        return dayEffectTrade;
    }

    public void setDayEffectTrade(Map<String, Integer> dayEffectTrade) {
        this.dayEffectTrade = dayEffectTrade;
    }

    public Integer getIntervalEffectTrade() {
        return intervalEffectTrade;
    }

    public void setIntervalEffectTrade(Integer intervalEffectTrade) {
        this.intervalEffectTrade = intervalEffectTrade;
    }

    public String getPeriodEffectTrade() {
        return periodEffectTrade;
    }

    public void setPeriodEffectTrade(String periodEffectTrade) {
        this.periodEffectTrade = periodEffectTrade;
    }

    public String getLastEffectTrade() {
        return lastEffectTrade;
    }

    public void setLastEffectTrade(String lastEffectTrade) {
        this.lastEffectTrade = lastEffectTrade;
    }

    public String getLaunchCategory() {
        return launchCategory;
    }

    public void setLaunchCategory(String launchCategory) {
        this.launchCategory = launchCategory;
    }

    public String getWeekLaunchCategory() {
        return weekLaunchCategory;
    }

    public void setWeekLaunchCategory(String weekLaunchCategory) {
        this.weekLaunchCategory = weekLaunchCategory;
    }

    public Map<String, Integer> getDayLaunchCategory() {
        return dayLaunchCategory;
    }

    public void setDayLaunchCategory(Map<String, Integer> dayLaunchCategory) {
        this.dayLaunchCategory = dayLaunchCategory;
    }

    public Integer getIntervalLaunchCategory() {
        return intervalLaunchCategory;
    }

    public void setIntervalLaunchCategory(Integer intervalLaunchCategory) {
        this.intervalLaunchCategory = intervalLaunchCategory;
    }

    public String getPeriodLaunchCategory() {
        return periodLaunchCategory;
    }

    public void setPeriodLaunchCategory(String periodLaunchCategory) {
        this.periodLaunchCategory = periodLaunchCategory;
    }

    public Integer getAvgLaunchCategoryStay() {
        return avgLaunchCategoryStay;
    }

    public void setAvgLaunchCategoryStay(Integer avgLaunchCategoryStay) {
        this.avgLaunchCategoryStay = avgLaunchCategoryStay;
    }

    public String getLastLaunchCategory() {
        return lastLaunchCategory;
    }

    public void setLastLaunchCategory(String lastLaunchCategory) {
        this.lastLaunchCategory = lastLaunchCategory;
    }

    public Integer getClickLaunchCategory() {
        return clickLaunchCategory;
    }

    public void setClickLaunchCategory(Integer clickLaunchCategory) {
        this.clickLaunchCategory = clickLaunchCategory;
    }

    public String getLastLaunchBrand() {
        return lastLaunchBrand;
    }

    public void setLastLaunchBrand(String lastLaunchBrand) {
        this.lastLaunchBrand = lastLaunchBrand;
    }

    public String getClickCategory() {
        return clickCategory;
    }

    public void setClickCategory(String clickCategory) {
        this.clickCategory = clickCategory;
    }

    public String getWeekClickCategory() {
        return weekClickCategory;
    }

    public void setWeekClickCategory(String weekClickCategory) {
        this.weekClickCategory = weekClickCategory;
    }

    public Map<String, Integer> getDayClickCategory() {
        return dayClickCategory;
    }

    public void setDayClickCategory(Map<String, Integer> dayClickCategory) {
        this.dayClickCategory = dayClickCategory;
    }

    public Integer getIntervalClickCategory() {
        return intervalClickCategory;
    }

    public void setIntervalClickCategory(Integer intervalClickCategory) {
        this.intervalClickCategory = intervalClickCategory;
    }

    public String getPeriodClickCategory() {
        return periodClickCategory;
    }

    public void setPeriodClickCategory(String periodClickCategory) {
        this.periodClickCategory = periodClickCategory;
    }

    public Integer getAvgLandpageStay() {
        return avgLandpageStay;
    }

    public void setAvgLandpageStay(Integer avgLandpageStay) {
        this.avgLandpageStay = avgLandpageStay;
    }

    public String getLastClickCategory() {
        return lastClickCategory;
    }

    public void setLastClickCategory(String lastClickCategory) {
        this.lastClickCategory = lastClickCategory;
    }

    public Integer getEffectClickCategory() {
        return effectClickCategory;
    }

    public void setEffectClickCategory(Integer effectClickCategory) {
        this.effectClickCategory = effectClickCategory;
    }

    public String getLastClickBrand() {
        return lastClickBrand;
    }

    public void setLastClickBrand(String lastClickBrand) {
        this.lastClickBrand = lastClickBrand;
    }

    public Integer getIssueEffectClickCategory() {
        return issueEffectClickCategory;
    }

    public void setIssueEffectClickCategory(Integer issueEffectClickCategory) {
        this.issueEffectClickCategory = issueEffectClickCategory;
    }

    public String getEffectCategory() {
        return effectCategory;
    }

    public void setEffectCategory(String effectCategory) {
        this.effectCategory = effectCategory;
    }

    public String getWeekEffectCategory() {
        return weekEffectCategory;
    }

    public void setWeekEffectCategory(String weekEffectCategory) {
        this.weekEffectCategory = weekEffectCategory;
    }

    public Map<String, Integer> getDayEffectCategory() {
        return dayEffectCategory;
    }

    public void setDayEffectCategory(Map<String, Integer> dayEffectCategory) {
        this.dayEffectCategory = dayEffectCategory;
    }

    public Integer getIntervalEffectCategory() {
        return intervalEffectCategory;
    }

    public void setIntervalEffectCategory(Integer intervalEffectCategory) {
        this.intervalEffectCategory = intervalEffectCategory;
    }

    public String getPeriodEffectCategory() {
        return periodEffectCategory;
    }

    public void setPeriodEffectCategory(String periodEffectCategory) {
        this.periodEffectCategory = periodEffectCategory;
    }

    public String getLastEffectCategory() {
        return lastEffectCategory;
    }

    public void setLastEffectCategory(String lastEffectCategory) {
        this.lastEffectCategory = lastEffectCategory;
    }

    public String getLastEffectBrand() {
        return lastEffectBrand;
    }

    public void setLastEffectBrand(String lastEffectBrand) {
        this.lastEffectBrand = lastEffectBrand;
    }

    public Integer getAddressCount() {
        return addressCount;
    }

    public void setAddressCount(Integer addressCount) {
        this.addressCount = addressCount;
    }

    public Integer getNumberCount() {
        return numberCount;
    }

    public void setNumberCount(Integer numberCount) {
        this.numberCount = numberCount;
    }

    public String getIssueEffectCategory() {
        return issueEffectCategory;
    }

    public void setIssueEffectCategory(String issueEffectCategory) {
        this.issueEffectCategory = issueEffectCategory;
    }

    public String getWeekIssueEffectCategory() {
        return weekIssueEffectCategory;
    }

    public void setWeekIssueEffectCategory(String weekIssueEffectCategory) {
        this.weekIssueEffectCategory = weekIssueEffectCategory;
    }

    public Integer getIntervalIssueEffectCategory() {
        return intervalIssueEffectCategory;
    }

    public void setIntervalIssueEffectCategory(Integer intervalIssueEffectCategory) {
        this.intervalIssueEffectCategory = intervalIssueEffectCategory;
    }

    public String getPeriodIssueEffectCategory() {
        return periodIssueEffectCategory;
    }

    public void setPeriodIssueEffectCategory(String periodIssueEffectCategory) {
        this.periodIssueEffectCategory = periodIssueEffectCategory;
    }

    public String getLastIssueEffectCategory() {
        return lastIssueEffectCategory;
    }

    public void setLastIssueEffectCategory(String lastIssueEffectCategory) {
        this.lastIssueEffectCategory = lastIssueEffectCategory;
    }

    public String getLastIssueEffectBrand() {
        return lastIssueEffectBrand;
    }

    public void setLastIssueEffectBrand(String lastIssueEffectBrand) {
        this.lastIssueEffectBrand = lastIssueEffectBrand;
    }

    public String getScoreEffectCategory() {
        return scoreEffectCategory;
    }

    public void setScoreEffectCategory(String scoreEffectCategory) {
        this.scoreEffectCategory = scoreEffectCategory;
    }

    public String getScoreIssueEffectCategory() {
        return scoreIssueEffectCategory;
    }

    public void setScoreIssueEffectCategory(String scoreIssueEffectCategory) {
        this.scoreIssueEffectCategory = scoreIssueEffectCategory;
    }

    public Integer getOrderFee() {
        return orderFee;
    }

    public void setOrderFee(Integer orderFee) {
        this.orderFee = orderFee;
    }

    public Integer getWeekOrderFee() {
        return weekOrderFee;
    }

    public void setWeekOrderFee(Integer weekOrderFee) {
        this.weekOrderFee = weekOrderFee;
    }

    public Integer getMaxOrderFee() {
        return maxOrderFee;
    }

    public void setMaxOrderFee(Integer maxOrderFee) {
        this.maxOrderFee = maxOrderFee;
    }

    public Integer getMinOrderFee() {
        return minOrderFee;
    }

    public void setMinOrderFee(Integer minOrderFee) {
        this.minOrderFee = minOrderFee;
    }

    public Integer getAvgOrderFee() {
        return avgOrderFee;
    }

    public void setAvgOrderFee(Integer avgOrderFee) {
        this.avgOrderFee = avgOrderFee;
    }

    public Integer getLastOrderFee() {
        return lastOrderFee;
    }

    public void setLastOrderFee(Integer lastOrderFee) {
        this.lastOrderFee = lastOrderFee;
    }

    public Integer getZeroLaunch() {
        return zeroLaunch;
    }

    public void setZeroLaunch(Integer zeroLaunch) {
        this.zeroLaunch = zeroLaunch;
    }

    public Integer getNonZeroLaunch() {
        return nonZeroLaunch;
    }

    public void setNonZeroLaunch(Integer nonZeroLaunch) {
        this.nonZeroLaunch = nonZeroLaunch;
    }

    public Integer getZeroClick() {
        return zeroClick;
    }

    public void setZeroClick(Integer zeroClick) {
        this.zeroClick = zeroClick;
    }

    public Integer getNonZeroClick() {
        return nonZeroClick;
    }

    public void setNonZeroClick(Integer nonZeroClick) {
        this.nonZeroClick = nonZeroClick;
    }

    public Integer getZeroEffect() {
        return zeroEffect;
    }

    public void setZeroEffect(Integer zeroEffect) {
        this.zeroEffect = zeroEffect;
    }

    public Integer getNonZeroEffect() {
        return nonZeroEffect;
    }

    public void setNonZeroEffect(Integer nonZeroEffect) {
        this.nonZeroEffect = nonZeroEffect;
    }

    public Integer getZeroIssueEffect() {
        return zeroIssueEffect;
    }

    public void setZeroIssueEffect(Integer zeroIssueEffect) {
        this.zeroIssueEffect = zeroIssueEffect;
    }

    public Integer getNonZeroIssueEffect() {
        return nonZeroIssueEffect;
    }

    public void setNonZeroIssueEffect(Integer nonZeroIssueEffect) {
        this.nonZeroIssueEffect = nonZeroIssueEffect;
    }

    public Integer getVouchFailed() {
        return vouchFailed;
    }

    public void setVouchFailed(Integer vouchFailed) {
        this.vouchFailed = vouchFailed;
    }

    public Integer getWeekVouchFailed() {
        return weekVouchFailed;
    }

    public void setWeekVouchFailed(Integer weekVouchFailed) {
        this.weekVouchFailed = weekVouchFailed;
    }

    public Integer getIntervalVouchFailed() {
        return intervalVouchFailed;
    }

    public void setIntervalVouchFailed(Integer intervalVouchFailed) {
        this.intervalVouchFailed = intervalVouchFailed;
    }

    public Integer getReject() {
        return reject;
    }

    public void setReject(Integer reject) {
        this.reject = reject;
    }

    public Integer getWeekReject() {
        return weekReject;
    }

    public void setWeekReject(Integer weekReject) {
        this.weekReject = weekReject;
    }

    public Integer getIntervalReject() {
        return intervalReject;
    }

    public void setIntervalReject(Integer intervalReject) {
        this.intervalReject = intervalReject;
    }

    public Integer getComplaint() {
        return complaint;
    }

    public void setComplaint(Integer complaint) {
        this.complaint = complaint;
    }

    public Integer getWeekComplaint() {
        return weekComplaint;
    }

    public void setWeekComplaint(Integer weekComplaint) {
        this.weekComplaint = weekComplaint;
    }

    public Integer getIntervalComplaint() {
        return intervalComplaint;
    }

    public void setIntervalComplaint(Integer intervalComplaint) {
        this.intervalComplaint = intervalComplaint;
    }

    public Integer getAddressException() {
        return addressException;
    }

    public void setAddressException(Integer addressException) {
        this.addressException = addressException;
    }

    public Integer getWeekAddressException() {
        return weekAddressException;
    }

    public void setWeekAddressException(Integer weekAddressException) {
        this.weekAddressException = weekAddressException;
    }

    public Integer getIntervalAddressException() {
        return intervalAddressException;
    }

    public void setIntervalAddressException(Integer intervalAddressException) {
        this.intervalAddressException = intervalAddressException;
    }

    public Integer getNumberEmpty() {
        return numberEmpty;
    }

    public void setNumberEmpty(Integer numberEmpty) {
        this.numberEmpty = numberEmpty;
    }

    public Integer getWeekNumberEmpty() {
        return weekNumberEmpty;
    }

    public void setWeekNumberEmpty(Integer weekNumberEmpty) {
        this.weekNumberEmpty = weekNumberEmpty;
    }

    public Integer getIntervalNumberEmpty() {
        return intervalNumberEmpty;
    }

    public void setIntervalNumberEmpty(Integer intervalNumberEmpty) {
        this.intervalNumberEmpty = intervalNumberEmpty;
    }

    public Integer getCheat() {
        return cheat;
    }

    public void setCheat(Integer cheat) {
        this.cheat = cheat;
    }

    public Integer getWeekCheat() {
        return weekCheat;
    }

    public void setWeekCheat(Integer weekCheat) {
        this.weekCheat = weekCheat;
    }

    public Integer getIntervalCheat() {
        return intervalCheat;
    }

    public void setIntervalCheat(Integer intervalCheat) {
        this.intervalCheat = intervalCheat;
    }
}
