/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.vo.DPAActFeatureDo;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DPAActFeatureParse {
    public static int F_MAX_SIZE = 64;
    private static final Logger logger = LoggerFactory.getLogger(DPAActFeatureParse.class);
    public static Integer[] HUABEI_REGION = new Integer[]{80, 11, 12, 13, 14, 15};
    public static Integer[] DONGBEI_REGION = new Integer[]{81, 21, 22, 23};
    public static Integer[] HUADONG_REGION = new Integer[]{82, 31, 32, 33, 34, 35, 36, 37};
    public static Integer[] HUAZHONG_REGION = new Integer[]{83, 41, 42, 43};
    public static Integer[] HUANAN_REGION = new Integer[]{84, 44, 45, 46};
    public static Integer[] XINAN_REGION = new Integer[]{85, 50, 51, 52, 53, 54};
    public static Integer[] XIBEI_REGION = new Integer[]{86, 61, 62, 63, 64, 65};
    public static Integer[] HMT_REGION = new Integer[]{87, 71, 8100, 8200};
    public static Integer[] FIRST_TIER_CITY = new Integer[]{11, 12, 31, 50, 2101, 3201, 3202, 3205, 3301, 3302, 3702, 4101, 4201, 4301, 4401, 4403, 4419, 5101, 6101};
    public static Integer[] SECOND_TIER_CITY = new Integer[]{1301, 1306, 1401, 2102, 2201, 2301, 3203, 3204, 3206, 3303, 3304, 3306, 3307, 3310, 3401, 3501, 3502, 3505, 3601, 3701, 3706, 3707, 4406, 4413, 4420, 4501, 5201, 5301, 6201, 6501};
    public static Integer[] THIRD_TIER_CITY = new Integer[]{1309, 1303, 1502, 2202, 3207, 3209, 3305, 3412, 3509, 3611, 3708, 3703, 4114, 4110, 4210, 4307, 4306, 4407, 4408, 4601, 5107, 6104, 1304, 1302, 1501, 2306, 3212, 3210, 3403, 3407, 3503, 3607, 3609, 3713, 4103, 4107, 4108, 4206, 4304, 4302, 4452, 4412, 4503, 4602, 5203, 6301, 1310, 1305, 2103, 3208, 3213, 3211, 3411, 3402, 3506, 3604, 3717, 3710, 4113, 4115, 4211, 4205, 4303, 4451, 4405, 4404, 4502, 5106, 5303, 6401};

    public static Map<String, String> generateFeatureMapStatic(DPAActFeatureDo dpa) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        try {
            if (dpa != null) {
                retMap.put("f201001", DataUtil.Long2String((Long)dpa.getAppId()));
                retMap.put("f108002", DataUtil.Long2String((Long)dpa.getSlotId()));
                retMap.put("f501001", dpa.getUa());
                retMap.put("f505001", dpa.getPriceSection());
                retMap.put("f4010030", DataUtil.Long2String((Long)dpa.getAreaCode()));
                Long regionLevel = DPAActFeatureParse.getRegionLevel(dpa.getAreaCode());
                retMap.put("f4010031", DataUtil.Long2String((Long)regionLevel));
                Long tierCityLevel = DPAActFeatureParse.getTierCityLevel(dpa.getAreaCode());
                retMap.put("f4010032", DataUtil.Long2String((Long)tierCityLevel));
                Integer hour = LocalDateUtil.getHour((LocalDateTime)LocalDateTime.now());
                retMap.put("f502001", DataUtil.Integer2String((Integer)hour));
                Integer weekDay = LocalDateUtil.getDayOfWeek((LocalDateTime)LocalDateTime.now());
                retMap.put("f502002", DataUtil.Integer2String((Integer)weekDay));
            }
        }
        catch (Exception e) {
            logger.error("DPAActFeatureParse.generateFeatureMapStatic error:" + e);
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamicTitle(DPAActFeatureDo dpa) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        try {
            if (dpa != null) {
                retMap.put("f301001", DataUtil.Long2String((Long)dpa.getActivityId()));
                retMap.put("f320001", DataUtil.Long2String((Long)dpa.getPrizeTag()));
                retMap.put("f320002", DataUtil.Long2String((Long)dpa.getFestivalTag()));
                retMap.put("f320003", DataUtil.Long2String((Long)dpa.getActivityType()));
                retMap.put("f320004", DataUtil.Long2String((Long)dpa.getDesignStype()));
                retMap.put("f320005", DataUtil.Long2String((Long)dpa.getSkinType()));
            }
        }
        catch (Exception e) {
            logger.error("DPAActFeatureParse generateFeatureMapDynamicTitle error:", (Throwable)e);
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamicPrize(DPAActFeatureDo dpa) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        try {
            if (dpa != null) {
                retMap.put("f330001", DataUtil.Long2String((Long)dpa.getToolId()));
                retMap.put("f330002", DataUtil.Long2String((Long)dpa.getTitleId()));
                retMap.put("f330003", DataUtil.Long2String((Long)dpa.getSubTitleId()));
                retMap.put("f330004", DataUtil.Long2String((Long)dpa.getPrizeId()));
                retMap.put("f330005", dpa.getToolTag());
                retMap.put("f330006", dpa.getTitleTag());
                retMap.put("f330007", dpa.getSubTitleTag());
                retMap.put("f330008", dpa.getPrizeUnitTag());
            }
        }
        catch (Exception e) {
            logger.error("DPAActFeatureParse generateFeatureMapDynamicPrize error:", (Throwable)e);
        }
        return retMap;
    }

    public static Long getRegionLevel(Long areaCode) {
        Long ret = null;
        if (AssertUtil.isNotEmpty((Object)areaCode)) {
            int area = DataUtil.toInt((Long)areaCode);
            if (areaCode >= 1000L && areaCode != 8100L && areaCode != 8200L) {
                area = DataUtil.toInt((Long)(areaCode / 100L));
            }
            if (Arrays.asList(HUABEI_REGION).contains(area)) {
                ret = 80L;
            } else if (Arrays.asList(DONGBEI_REGION).contains(area)) {
                ret = 81L;
            } else if (Arrays.asList(HUADONG_REGION).contains(area)) {
                ret = 82L;
            } else if (Arrays.asList(HUAZHONG_REGION).contains(area)) {
                ret = 83L;
            } else if (Arrays.asList(HUANAN_REGION).contains(area)) {
                ret = 84L;
            } else if (Arrays.asList(XINAN_REGION).contains(area)) {
                ret = 85L;
            } else if (Arrays.asList(XIBEI_REGION).contains(area)) {
                ret = 86L;
            } else if (Arrays.asList(HMT_REGION).contains(area)) {
                ret = 87L;
            }
        }
        return ret;
    }

    public static Long getTierCityLevel(Long areaCode) {
        Long ret = null;
        if (AssertUtil.isNotEmpty((Object)areaCode)) {
            int area = DataUtil.toInt((Long)areaCode);
            if (Arrays.asList(FIRST_TIER_CITY).contains(area)) {
                ret = 1L;
            } else if (Arrays.asList(SECOND_TIER_CITY).contains(area)) {
                ret = 2L;
            } else if (Arrays.asList(THIRD_TIER_CITY).contains(area)) {
                ret = 3L;
            }
        }
        return ret;
    }
}

