package cn.com.duiba.nezha.alg.feature.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;

@Data
public class UserActFeature implements Serializable {

    private static final long serialVersionUID = -2203632123858487448L;

    // 用户属性
    private Integer userActiveDays;  // f410001 用户生命周期（天）

    // 用户行为
    // 活动访问
    private Integer activityRequest;   //f411001 历史活动访问次数
    private Integer weekActivityRequest;   //f411002  一周内活动访问次数
    private Integer dayActivityRequest;    //f411003 当日活动访问次数
    private Integer intervalActivityRequest;   //f411004	 历史距离上一次活动访问时间间隔（天）
    private String periodActivityRequest;   //f411005 历史活动访问频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）

    // 活动参与
    private Integer activityJoin;  //f412001 历史活动参与次数
    private Integer weekActivityJoin;  //f412002 一周内活动参与次数
    private Integer dayActivityJoin;   //f412003 当日活动参与次数
    private Integer intervalActivityJoin;  //f412004 历史距离上一次活动参与时间间隔（天）
    private String periodActivityJoin;  //f412005 历史活动参与频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private Integer activityPageStay;  //f412006 历史活动页平均停留时长（秒）

    // 发券
    private String launchTrade; //f413001 历史不同行业上发券数量
    private String weekLaunchTrade; //f413002 一周内不同行业发券数量
    private Map<String, Integer> dayLaunchTrade;  //f413003 当日不同行业发券数量
    private Integer intervalLaunchTrade;   //f413004 历史距离上一次发券时间间隔（天）
    private String periodLaunchTrade;   //f413005 历史发券频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private Integer avgLaunchStay; //f413006 历史券展示平均时长（秒）
    private String lastLaunchTrade; //f413007 上一次发券行业
    private Integer clickLaunchTrade;   //f413008 上一次发券是否点击

    // 券点击
    private String clickTrade;  //f414001 历史不同行业上券点击数量
    private String weekClickTrade;  //f414002 一周内不同行业上券点击数量
    private Map<String, Integer> dayClickTrade;   //f414003 当日不同行业上券点击数量
    private Integer intervalClickTrade;    //f414004 历史距离上一次券点击时间间隔（天）
    private String periodClickTrade;    //f414005 历史券点击频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private String lastClickTrade;  //f414007 上一次券点击行业
    private Integer effectClickTrade;   //f414008 上一次券点击是否转化

    // 转化
    private String effectTrade; //f415001 历史不同行业上转化数量
    private String weekEffectTrade; //f415002 一周内不同行业上转化数量
    private Map<String, Integer> dayEffectTrade;  //f415003 当日不同行业上转化数量
    private Integer intervalEffectTrade;   //f415004 历史距离上一次转化时间间隔（天）
    private String periodEffectTrade;   //f415005 历史转化频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private String lastEffectTrade; //f415007 上一次转化行业

    // 二类电商行为
    // 发券
    private String launchCategory;  //f423001 历史二类电商不同品类发券数量
    private String weekLaunchCategory;  //f423002 一周内二类电商不同品类发券数量
    private Map<String, Integer> dayLaunchCategory;   //f423003 当日二类电商不同品类发券数量
    private Integer intervalLaunchCategory;    //f423004 历史距离上一次二类电商发券时间间隔（天）
    private String periodLaunchCategory;    //f423005 历史二类电商发券频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private Integer avgLaunchCategoryStay; //f423006 历史二类电商券展示平均时长（秒）
    private String lastLaunchCategory;  //f423007 上一次二类电商发券品类
    private Integer clickLaunchCategory;    //f423008 上一次二类电商发券是否点击
    private String lastLaunchBrand;  //f423009 上一次二类电商发券品牌

    // 券点击
    private String clickCategory;   //f424001 历史二类电商不同品类券点击数量
    private String weekClickCategory;   //f424002 一周内二类电商不同品类券点击数量
    private Map<String, Integer> dayClickCategory;    //f424003 当日二类电商不同品类券点击数量
    private Integer intervalClickCategory; //f424004 历史距离上一次二类电商券点击时间间隔（天）
    private String periodClickCategory; //f424005 历史二类电商券点击频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private Integer avgLandpageStay;   //f424006 历史二类电商落地页展示平均时长（秒）
    private String lastClickCategory;   //f424007 上一次二类电商券点击品类
    private Integer effectClickCategory;    //f424008 上一次二类电商券点击是否转化
    private String lastClickBrand;  //f424009 上一次二类电商券点击品牌
    private Integer issueEffectClickCategory;   //f424010 上一次二类电商券点击是否出单转化

    // 前端转化
    private String effectCategory;  //f425001 历史二类电商不同品类转化数量
    private String weekEffectCategory;  //f425002 一周内二类电商不同品类转化数量
    private Map<String, Integer> dayEffectCategory;   //f425003 当日二类电商不同品类转化数量
    private Integer intervalEffectCategory;    //f425004 历史距离上一次二类电商转化时间间隔（天）
    private String periodEffectCategory;    //f425005 历史二类电商转化频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private String lastEffectCategory;  //f425007 上一次二类电商转化品类
    private String lastEffectBrand; //f425009 上一次二类电商转化品牌
    private Integer addressCount;   //f425011 历史使用地址数量
    private Integer numberCount;    //f425012 历史手机号使用数量

    // 出单转化
    private String issueEffectCategory; //f426001 历史二类电商不同品类转化数量
    private String weekIssueEffectCategory; //f426002 一周内二类电商不同品类转化数量
    private Integer intervalIssueEffectCategory;   //f426004 历史距离上一次二类电商转化时间间隔（天）
    private String periodIssueEffectCategory;   //f426005 历史二类电商转化频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private String lastIssueEffectCategory; //f426007 上一次二类电商转化品类
    private String lastIssueEffectBrand;    //f426009 上一次二类电商转化品牌

    // 品类兴趣偏好
    private String scoreEffectCategory; //f431001 历史签收数
    private String scoreIssueEffectCategory;    //f431002 历史核单数

    // 消费水平
    private Integer orderFee;    //f432001 历史累计下单实际金额（签收成功）
    private Integer weekOrderFee;    //f432002 一周内累计下单实际金额（签收成功）
    private Integer maxOrderFee; //f432003 历史最大下单实际金额（签收成功）
    private Integer minOrderFee; //f432004 历史最小下单实际金额（签收成功）
    private Integer avgOrderFee; //f432005 平均下单实际金额（签收成功）
    private Integer lastOrderFee;    //f432006 上次下单实际金额（签收成功）

    // 消费心理
    private Integer zeroLaunch;    //f433001 历史展示金额为0的商品发券次数
    private Integer nonZeroLaunch; //f433002 历史展示金额不为0的商品发券次数
    private Integer zeroClick; //f433003 历史展示金额为0的商品券点击次数
    private Integer nonZeroClick;  //f433004 历史展示金额不为0的商品券点击次数
    private Integer zeroEffect;    //f433005 历史展示金额为0的商品前端转化次数
    private Integer nonZeroEffect; //f433006 历史展示金额不为0的商品前端转化次数
    private Integer zeroIssueEffect;   //f433007 历史展示金额为0的商品出单转化次数
    private Integer nonZeroIssueEffect;    //f433008 历史展示金额不为0的商品出单转化次数

    // 风控行为
    private Integer vouchFailed;   //f434001 历史累计核单失败次数
    private Integer weekVouchFailed;   //f434002 一周内累计核单失败次数
    private Integer intervalVouchFailed;   //f434003 距离上一次核单失败时间间隔（天）
    private Integer reject;    //f434004 历史拒付费次数
    private Integer weekReject;    //f434005 一周内拒付费次数
    private Integer intervalReject;    //f434006 距离上一次拒付款时间间隔（天）
    private Integer complaint; //f434007历史投诉次数
    private Integer weekComplaint; //f434008 一周内累计投诉次数
    private Integer intervalComplaint; //f434009 距离上一次投诉时间间隔（天）
    private Integer addressException;  //f434010 历史地址异常次数
    private Integer weekAddressException;  //f434011 一周内地址异常次数
    private Integer intervalAddressException;  //f434012 距离上一次地址异常时间间隔（天）
    private Integer numberEmpty;   //f434013 历史空号/错号次数
    private Integer weekNumberEmpty;   //f434014 一周内空号/错号次数
    private Integer intervalNumberEmpty;   //f434015 距离上一次空号/错号时间间隔（天）
    private Integer cheat; //f434016 历史作弊次数
    private Integer weekCheat; //f434017 一周内作弊次数
    private Integer intervalCheat; //f434018 距离上一次作弊时间间隔（天）

    // ADX外部行为数据（二期）
    private String lastApp;   // f462001  上一次访问应用名称
    private Long lastVideoTime; // f462002 上一次观看视频时长（秒）
    private String lastVideoChannel; // f462003  上一次观看视频频道
    private String lastVideoInfo;    // f462004  上一次观看视频剧目信息
    private String lastVideoCategory;    // f462005  上一次观看视频二级分类id
    private String lastVideoArea;    // f462006  上一次观看视频所属地区名称
    private String lastVideoYears;   // f462007  上一次观看视频出品年代

    // 用户活动统计特征
    private String activityTypeCtr; //f440001	历史不同活动类型上的点击率
    private String weekActivityTypeCtr; //f440002	一周内不同活动类型上的点击率
    private String activityDesignCtr;  //f440003	历史不同活动设计风格上的点击率
    private String weekActivityDesignCtr;  //f440004	一周内不同活动设计风格上的点击率
    private String activitySceneCtr;  //f440005	历史不同活动场景标签上的点击率
    private String weekActivitySceneCtr;  //f440006	一周内不同活动场景标签上的点击率
    private String activityFestivalCtr;  //f440007	历史不同活动节日标签上的点击率
    private String weekActivityFestivalCtr;  //f440008	一周内不同活动节日标签上的点击率
    private String activitySkinCtr;  //f440009	历史不同活动皮肤类型上的点击率
    private String weekActivitySkinCtr;  //f440010	一周内不同活动皮肤类型上的点击率

    private String activityTypeCvr;  //f441001	历史不同活动类型上的转化率
    private String weekActivityTypeCvr;  //f441002	一周内不同活动类型上的转化率
    private String activityDesignCvr;  //f441003	历史不同活动设计风格上的转化率
    private String weekActivityDesignCvr;  //f441004	一周内不同活动设计风格上的转化率
    private String activitySceneCvr;  //f441005	历史不同活动场景标签上的转化率
    private String weekActivitySceneCvr;  //f441006	一周内不同活动场景标签上的转化率
    private String activityFestivalCvr;  //f441007	历史不同活动节日标签上的转化率
    private String weekActivityFestivalCvr;  //f441008	一周内不同活动节日标签上的转化率
    private String activitySkinCvr;  //f441009	历史不同活动皮肤类型上的转化率
    private String weekActivitySkinCvr;  //f441010	一周内不同活动皮肤类型上的转化率
}
