/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.vo.DPAActFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.DPAFeature;
import cn.com.duiba.nezha.alg.feature.vo.FeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.PrizeDo;
import cn.com.duiba.nezha.alg.feature.vo.SlotActFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserActFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserProfileFeature;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DPAActFeatureParse {
    private static final Logger logger = LoggerFactory.getLogger(DPAActFeatureParse.class);
    public static int F_MAX_SIZE = 64;
    public static int[] cntBucket = new int[]{0, 1, 3, 5, 10, 15, 20};
    public static int[] ctrAndCvrLevelBucket = new int[]{1, 4, 8};
    public static double[] userCtrBucket = new double[]{0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    public static double[] userCvrBucket = new double[]{0.01, 0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    public static int[] videoDurationBucket = new int[]{0, 15, 30, 60, 300, 600, 900, 1800, 2700, 3600, 5400, 7200};
    public static double[] cntRatioBucket = new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9};
    public static double[] statCtrBucket = new double[]{0.001, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static double[] statCvrBucket = new double[]{0.001, 0.01, 0.02, 0.03, 0.04, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static int[] cateScoreBucket = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
    public static Integer[] HUABEI_REGION = new Integer[]{80, 11, 12, 13, 14, 15};
    public static Integer[] DONGBEI_REGION = new Integer[]{81, 21, 22, 23};
    public static Integer[] HUADONG_REGION = new Integer[]{82, 31, 32, 33, 34, 35, 36, 37};
    public static Integer[] HUAZHONG_REGION = new Integer[]{83, 41, 42, 43};
    public static Integer[] HUANAN_REGION = new Integer[]{84, 44, 45, 46};
    public static Integer[] XINAN_REGION = new Integer[]{85, 50, 51, 52, 53, 54};
    public static Integer[] XIBEI_REGION = new Integer[]{86, 61, 62, 63, 64, 65};
    public static Integer[] HMT_REGION = new Integer[]{87, 71, 8100, 8200};
    public static Integer[] FIRST_TIER_CITY = new Integer[]{11, 12, 31, 50, 2101, 3201, 3202, 3205, 3301, 3302, 3702, 4101, 4201, 4301, 4401, 4403, 4419, 5101, 6101};
    public static Integer[] SECOND_TIER_CITY = new Integer[]{1301, 1306, 1401, 2102, 2201, 2301, 3203, 3204, 3206, 3303, 3304, 3306, 3307, 3310, 3401, 3501, 3502, 3505, 3601, 3701, 3706, 3707, 4406, 4413, 4420, 4501, 5201, 5301, 6201, 6501};
    public static Integer[] THIRD_TIER_CITY = new Integer[]{1309, 1303, 1502, 2202, 3207, 3209, 3305, 3412, 3509, 3611, 3708, 3703, 4114, 4110, 4210, 4307, 4306, 4407, 4408, 4601, 5107, 6104, 1304, 1302, 1501, 2306, 3212, 3210, 3403, 3407, 3503, 3607, 3609, 3713, 4103, 4107, 4108, 4206, 4304, 4302, 4452, 4412, 4503, 4602, 5203, 6301, 1310, 1305, 2103, 3208, 3213, 3211, 3411, 3402, 3506, 3604, 3717, 3710, 4113, 4115, 4211, 4205, 4303, 4451, 4405, 4404, 4502, 5106, 5303, 6401};
    public static Map<String, Integer> tradeCodes = new HashMap<String, Integer>(){
        {
            this.put("8", 0);
            this.put("14", 1);
            this.put("15", 2);
            this.put("21", 3);
            this.put("20", 4);
            this.put("3", 5);
            this.put("5", 6);
            this.put("12", 7);
            this.put("2", 8);
            this.put("1", 9);
            this.put("24", 10);
            this.put("6", 11);
            this.put("7", 12);
            this.put("11", 13);
            this.put("13", 14);
            this.put("18", 15);
            this.put("22", 16);
            this.put("4", 17);
            this.put("17", 18);
            this.put("25", 19);
            this.put("10", 20);
            this.put("23", 21);
            this.put("9", 22);
            this.put("19", 23);
            this.put("16", 24);
        }
    };
    public static Map<String, Integer> accountCodes = new HashMap<String, Integer>(){
        {
            this.put("18125", 0);
            this.put("18943", 1);
            this.put("22005", 2);
            this.put("21563", 3);
            this.put("17196", 4);
            this.put("29815", 5);
            this.put("27419", 6);
            this.put("25874", 7);
            this.put("30539", 8);
            this.put("27295", 9);
            this.put("30037", 10);
            this.put("24035", 11);
            this.put("23882", 12);
            this.put("29932", 13);
            this.put("19317", 14);
            this.put("10971", 15);
            this.put("27486", 16);
            this.put("12311", 17);
            this.put("22597", 18);
            this.put("21330", 19);
            this.put("26598", 20);
            this.put("30371", 21);
            this.put("19941", 22);
            this.put("27605", 23);
            this.put("17270", 24);
            this.put("12234", 25);
            this.put("17878", 26);
            this.put("28257", 27);
            this.put("30632", 28);
            this.put("25991", 29);
            this.put("30701", 30);
            this.put("30336", 31);
            this.put("12796", 32);
            this.put("29379", 33);
            this.put("30495", 34);
            this.put("29758", 35);
            this.put("19316", 36);
            this.put("14355", 37);
            this.put("29001", 38);
            this.put("30126", 39);
            this.put("30892", 40);
            this.put("26320", 41);
            this.put("18489", 42);
            this.put("14164", 43);
            this.put("24696", 44);
            this.put("28941", 45);
            this.put("30511", 46);
            this.put("5713", 47);
            this.put("30928", 48);
            this.put("19761", 49);
            this.put("30592", 50);
            this.put("30081", 51);
            this.put("28769", 52);
            this.put("29788", 53);
            this.put("21133", 54);
            this.put("30679", 55);
            this.put("30393", 56);
            this.put("26323", 57);
            this.put("29336", 58);
            this.put("29935", 59);
            this.put("29030", 60);
            this.put("26550", 61);
            this.put("30394", 62);
            this.put("30823", 63);
            this.put("28466", 64);
            this.put("8340", 65);
            this.put("30460", 66);
            this.put("30739", 67);
            this.put("26048", 68);
            this.put("30765", 69);
            this.put("30596", 70);
            this.put("25809", 71);
            this.put("30808", 72);
            this.put("30605", 73);
            this.put("27165", 74);
            this.put("30868", 75);
            this.put("30518", 76);
            this.put("29408", 77);
            this.put("30601", 78);
            this.put("30900", 79);
            this.put("25984", 80);
            this.put("27568", 81);
            this.put("23937", 82);
            this.put("15334", 83);
            this.put("30345", 84);
            this.put("26595", 85);
            this.put("8154", 86);
            this.put("28264", 87);
            this.put("30848", 88);
            this.put("13566", 89);
            this.put("26726", 90);
            this.put("8302", 91);
            this.put("29406", 92);
            this.put("16315", 93);
            this.put("30625", 94);
            this.put("20619", 95);
            this.put("28528", 96);
            this.put("30253", 97);
            this.put("29808", 98);
            this.put("30809", 99);
            this.put("6286", 100);
            this.put("22757", 101);
            this.put("9876", 102);
            this.put("24779", 103);
            this.put("25806", 104);
            this.put("30929", 105);
            this.put("30956", 106);
            this.put("30691", 107);
            this.put("29706", 108);
            this.put("29651", 109);
            this.put("30438", 110);
            this.put("27911", 111);
            this.put("30493", 112);
            this.put("29519", 113);
            this.put("30220", 114);
            this.put("30812", 115);
            this.put("27684", 116);
            this.put("30636", 117);
            this.put("17638", 118);
            this.put("28594", 119);
            this.put("29558", 120);
            this.put("27463", 121);
            this.put("28925", 122);
            this.put("28420", 123);
            this.put("30099", 124);
            this.put("28523", 125);
            this.put("30688", 126);
            this.put("28432", 127);
            this.put("18028", 128);
            this.put("6209", 129);
            this.put("30783", 130);
            this.put("22412", 131);
            this.put("30684", 132);
            this.put("30621", 133);
            this.put("30734", 134);
            this.put("30807", 135);
            this.put("30794", 136);
            this.put("28180", 137);
            this.put("28544", 138);
            this.put("30186", 139);
            this.put("24090", 140);
            this.put("30111", 141);
            this.put("8657", 142);
            this.put("23977", 143);
            this.put("29491", 144);
            this.put("30327", 145);
            this.put("30249", 146);
            this.put("23461", 147);
            this.put("28597", 148);
            this.put("30498", 149);
            this.put("30109", 150);
            this.put("30279", 151);
            this.put("30100", 152);
            this.put("30732", 153);
            this.put("23031", 154);
            this.put("30497", 155);
            this.put("25886", 156);
            this.put("27453", 157);
            this.put("29845", 158);
            this.put("30378", 159);
            this.put("30257", 160);
            this.put("28881", 161);
            this.put("27241", 162);
            this.put("30219", 163);
            this.put("22006", 164);
            this.put("30217", 165);
            this.put("25215", 166);
            this.put("19217", 167);
            this.put("28515", 168);
            this.put("30185", 169);
            this.put("29858", 170);
            this.put("27452", 171);
            this.put("18089", 172);
            this.put("30411", 173);
            this.put("26151", 174);
            this.put("29699", 175);
            this.put("29889", 176);
            this.put("30573", 177);
            this.put("30017", 178);
            this.put("2292", 179);
            this.put("29427", 180);
            this.put("30560", 181);
            this.put("30626", 182);
            this.put("28628", 183);
            this.put("29534", 184);
            this.put("30515", 185);
            this.put("30023", 186);
            this.put("30374", 187);
            this.put("21271", 188);
            this.put("27321", 189);
            this.put("30290", 190);
            this.put("28643", 191);
            this.put("14356", 192);
            this.put("23880", 193);
            this.put("30836", 194);
            this.put("30569", 195);
            this.put("29900", 196);
            this.put("29879", 197);
            this.put("30499", 198);
            this.put("29894", 199);
            this.put("28970", 200);
            this.put("21944", 201);
            this.put("30705", 202);
            this.put("30187", 203);
            this.put("28503", 204);
            this.put("29028", 205);
            this.put("30128", 206);
            this.put("30182", 207);
            this.put("30237", 208);
            this.put("29448", 209);
            this.put("30825", 210);
            this.put("27884", 211);
            this.put("27932", 212);
            this.put("30704", 213);
            this.put("30695", 214);
            this.put("30461", 215);
            this.put("30218", 216);
            this.put("29862", 217);
            this.put("25509", 218);
            this.put("30329", 219);
            this.put("26077", 220);
            this.put("25495", 221);
            this.put("30115", 222);
            this.put("27002", 223);
            this.put("30935", 224);
            this.put("23469", 225);
            this.put("30331", 226);
            this.put("30188", 227);
            this.put("24296", 228);
            this.put("22042", 229);
            this.put("7962", 230);
            this.put("323", 231);
            this.put("30272", 232);
            this.put("18071", 233);
            this.put("18072", 234);
            this.put("8220", 235);
            this.put("8331", 236);
            this.put("23680", 237);
            this.put("6419", 238);
        }
    };
    public static Map<String, Integer> appCodes = new HashMap<String, Integer>(){
        {
            this.put("0", 0);
            this.put("1", 1);
            this.put("2", 2);
            this.put("3", 3);
            this.put("4", 4);
            this.put("5", 5);
            this.put("6", 6);
            this.put("7", 7);
            this.put("8", 8);
            this.put("9", 9);
            this.put("10", 10);
            this.put("11", 11);
            this.put("12", 12);
            this.put("13", 13);
            this.put("14", 14);
        }
    };
    public static Map<String, Integer> msgSigCodes = new HashMap<String, Integer>(){
        {
            this.put("0", 0);
            this.put("1", 1);
            this.put("2", 2);
            this.put("3", 3);
            this.put("4", 4);
            this.put("5", 5);
            this.put("6", 6);
            this.put("7", 7);
            this.put("8", 8);
            this.put("9", 9);
            this.put("10", 10);
            this.put("11", 11);
            this.put("12", 12);
            this.put("13", 13);
            this.put("14", 14);
            this.put("15", 15);
            this.put("16", 16);
            this.put("17", 17);
            this.put("18", 18);
            this.put("19", 19);
            this.put("20", 20);
            this.put("21", 21);
            this.put("22", 22);
            this.put("23", 23);
            this.put("24", 24);
            this.put("25", 25);
            this.put("26", 26);
            this.put("27", 27);
            this.put("28", 28);
            this.put("29", 29);
            this.put("30", 30);
            this.put("31", 31);
            this.put("32", 32);
            this.put("33", 33);
            this.put("34", 34);
            this.put("35", 35);
            this.put("36", 36);
            this.put("37", 37);
            this.put("38", 38);
            this.put("39", 39);
            this.put("40", 40);
            this.put("41", 41);
            this.put("42", 42);
            this.put("43", 43);
        }
    };
    public static Map<String, Integer> keywordCodes = new HashMap<String, Integer>(){
        {
            this.put("0", 0);
            this.put("1", 1);
            this.put("2", 2);
            this.put("3", 3);
            this.put("4", 4);
            this.put("5", 5);
            this.put("6", 6);
            this.put("7", 7);
            this.put("8", 8);
            this.put("9", 9);
            this.put("10", 10);
            this.put("11", 11);
            this.put("12", 12);
            this.put("13", 13);
            this.put("14", 14);
            this.put("15", 15);
            this.put("16", 16);
            this.put("17", 17);
            this.put("18", 18);
            this.put("19", 19);
            this.put("20", 20);
            this.put("21", 21);
            this.put("22", 22);
            this.put("23", 23);
            this.put("24", 24);
            this.put("25", 25);
            this.put("26", 26);
            this.put("27", 27);
            this.put("28", 28);
            this.put("29", 29);
            this.put("30", 30);
        }
    };
    public static Map<String, Integer> videoCateCodes = new HashMap<String, Integer>(){
        {
            this.put("1273152", 0);
            this.put("1273153", 1);
            this.put("1273154", 2);
            this.put("1273155", 3);
            this.put("1273158", 4);
            this.put("1273163", 5);
            this.put("1273166", 6);
            this.put("1273190", 7);
            this.put("1273380", 8);
            this.put("1273399", 9);
            this.put("1275055", 10);
            this.put("1275060", 11);
            this.put("1275378", 12);
            this.put("1275381", 13);
            this.put("1275605", 14);
            this.put("1275609", 15);
            this.put("1275699", 16);
            this.put("1275850", 17);
            this.put("1276159", 18);
            this.put("1276427", 19);
            this.put("1277341", 20);
            this.put("1277350", 21);
            this.put("1277354", 22);
            this.put("1277360", 23);
            this.put("1277373", 24);
            this.put("1278212", 25);
            this.put("1279265", 26);
            this.put("1279863", 27);
            this.put("1281970", 28);
            this.put("1281978", 29);
            this.put("1282468", 30);
            this.put("1282983", 31);
            this.put("1283091", 32);
            this.put("1283242", 33);
            this.put("1284864", 34);
            this.put("1284891", 35);
            this.put("1284979", 36);
            this.put("1288586", 37);
            this.put("1289618", 38);
            this.put("1289633", 39);
            this.put("1289641", 40);
            this.put("1289642", 41);
            this.put("1291079", 42);
            this.put("1307098", 43);
            this.put("1307103", 44);
            this.put("1308055", 45);
            this.put("1310272", 46);
            this.put("1310276", 47);
            this.put("1311366", 48);
            this.put("1316217", 49);
            this.put("1323164", 50);
            this.put("1333414", 51);
            this.put("1343852", 52);
            this.put("1345203", 53);
            this.put("1345206", 54);
            this.put("1345801", 55);
            this.put("1347029", 56);
            this.put("1348464", 57);
            this.put("1348469", 58);
            this.put("1348589", 59);
            this.put("1348767", 60);
            this.put("1351397", 61);
            this.put("1362094", 62);
            this.put("1392855", 63);
            this.put("1399467", 64);
            this.put("1457705", 65);
            this.put("1506926", 66);
            this.put("1509530", 67);
            this.put("1652670", 68);
            this.put("1657117", 69);
            this.put("1657120", 70);
            this.put("1786669", 71);
            this.put("1791134", 72);
            this.put("1887279", 73);
            this.put("2289121", 74);
            this.put("2289182", 75);
            this.put("2289191", 76);
            this.put("2289194", 77);
            this.put("2289198", 78);
            this.put("2400701", 79);
            this.put("2422552", 80);
            this.put("2423962", 81);
            this.put("2425625", 82);
            this.put("2454957", 83);
            this.put("2456790", 84);
            this.put("2456802", 85);
            this.put("2456895", 86);
            this.put("2466968", 87);
            this.put("2469508", 88);
            this.put("2485369", 89);
            this.put("2577550", 90);
            this.put("2818641", 91);
            this.put("2820598", 92);
            this.put("2821045", 93);
            this.put("2821232", 94);
            this.put("2821234", 95);
            this.put("2823069", 96);
            this.put("2824674", 97);
            this.put("2825127", 98);
            this.put("2825132", 99);
            this.put("2825152", 100);
            this.put("2825153", 101);
            this.put("2825156", 102);
            this.put("2825165", 103);
            this.put("2825674", 104);
            this.put("2828097", 105);
            this.put("2829161", 106);
            this.put("2829647", 107);
            this.put("2830002", 108);
            this.put("2830311", 109);
            this.put("2830346", 110);
            this.put("2830613", 111);
            this.put("2830805", 112);
            this.put("2831234", 113);
            this.put("2831373", 114);
            this.put("2831480", 115);
            this.put("2832492", 116);
            this.put("2833635", 117);
            this.put("2834198", 118);
            this.put("2834248", 119);
            this.put("2834252", 120);
            this.put("2834254", 121);
            this.put("2834359", 122);
            this.put("2834697", 123);
            this.put("2834810", 124);
            this.put("2834931", 125);
            this.put("2835040", 126);
            this.put("2835116", 127);
            this.put("2835117", 128);
            this.put("2835164", 129);
            this.put("2835165", 130);
            this.put("2835495", 131);
            this.put("2835521", 132);
            this.put("2835645", 133);
            this.put("2835728", 134);
            this.put("2835738", 135);
            this.put("2835744", 136);
            this.put("2836094", 137);
            this.put("2836607", 138);
            this.put("2836677", 139);
            this.put("2837050", 140);
            this.put("2837679", 141);
            this.put("2837825", 142);
            this.put("2838438", 143);
            this.put("2838626", 144);
            this.put("2838627", 145);
            this.put("2838628", 146);
            this.put("2838680", 147);
            this.put("2839215", 148);
            this.put("2839217", 149);
            this.put("2839264", 150);
            this.put("2839388", 151);
            this.put("2840307", 152);
            this.put("2840460", 153);
            this.put("2840461", 154);
            this.put("2840492", 155);
            this.put("2840499", 156);
            this.put("2840500", 157);
            this.put("2840501", 158);
            this.put("2840502", 159);
            this.put("2840504", 160);
            this.put("2840944", 161);
            this.put("2841365", 162);
            this.put("2841425", 163);
            this.put("2841426", 164);
            this.put("2844458", 165);
            this.put("2844459", 166);
            this.put("2844461", 167);
            this.put("2844477", 168);
            this.put("2844488", 169);
            this.put("2844489", 170);
            this.put("2845047", 171);
            this.put("2847235", 172);
            this.put("2847874", 173);
            this.put("2847916", 174);
            this.put("2848190", 175);
            this.put("2848215", 176);
            this.put("2848229", 177);
            this.put("2848330", 178);
            this.put("2849576", 179);
            this.put("2850987", 180);
            this.put("2859501", 181);
            this.put("2859502", 182);
            this.put("2859503", 183);
            this.put("2859504", 184);
            this.put("2859505", 185);
            this.put("2859506", 186);
            this.put("2859507", 187);
            this.put("2859508", 188);
            this.put("2859509", 189);
            this.put("2859510", 190);
            this.put("2859511", 191);
            this.put("2859512", 192);
            this.put("2859513", 193);
            this.put("2859588", 194);
            this.put("2859785", 195);
            this.put("2860991", 196);
            this.put("2860992", 197);
            this.put("2923465", 198);
            this.put("2923466", 199);
            this.put("2924524", 200);
            this.put("2924526", 201);
            this.put("2924527", 202);
            this.put("2924539", 203);
            this.put("2924541", 204);
            this.put("2924542", 205);
            this.put("2924543", 206);
            this.put("2924965", 207);
            this.put("2924966", 208);
            this.put("2924967", 209);
            this.put("2924968", 210);
            this.put("2924969", 211);
            this.put("2924970", 212);
        }
    };
    public static Map<String, Integer> videoChannelCodes = new HashMap<String, Integer>(){
        {
            this.put("aiqiyi--1", 0);
            this.put("aiqiyi-0", 1);
            this.put("aiqiyi-1", 2);
            this.put("aiqiyi-10", 3);
            this.put("aiqiyi-11", 4);
            this.put("aiqiyi-12", 5);
            this.put("aiqiyi-13", 6);
            this.put("aiqiyi-14", 7);
            this.put("aiqiyi-15", 8);
            this.put("aiqiyi-16", 9);
            this.put("aiqiyi-17", 10);
            this.put("aiqiyi-18", 11);
            this.put("aiqiyi-19", 12);
            this.put("aiqiyi-2", 13);
            this.put("aiqiyi-20", 14);
            this.put("aiqiyi-21", 15);
            this.put("aiqiyi-22", 16);
            this.put("aiqiyi-23", 17);
            this.put("aiqiyi-24", 18);
            this.put("aiqiyi-25", 19);
            this.put("aiqiyi-26", 20);
            this.put("aiqiyi-27", 21);
            this.put("aiqiyi-28", 22);
            this.put("aiqiyi-29", 23);
            this.put("aiqiyi-3", 24);
            this.put("aiqiyi-30", 25);
            this.put("aiqiyi-30003", 26);
            this.put("aiqiyi-30005", 27);
            this.put("aiqiyi-30008", 28);
            this.put("aiqiyi-30010", 29);
            this.put("aiqiyi-31", 30);
            this.put("aiqiyi-32", 31);
            this.put("aiqiyi-33", 32);
            this.put("aiqiyi-34", 33);
            this.put("aiqiyi-4", 34);
            this.put("aiqiyi-40004", 35);
            this.put("aiqiyi-49999", 36);
            this.put("aiqiyi-5", 37);
            this.put("aiqiyi-6", 38);
            this.put("aiqiyi-7", 39);
            this.put("aiqiyi-8", 40);
            this.put("aiqiyi-9", 41);
            this.put("aiqiyi-97", 42);
            this.put("aiqiyi-99", 43);
            this.put("mango-0", 44);
            this.put("mango-1", 45);
            this.put("mango-105", 46);
            this.put("mango-111", 47);
            this.put("mango-116", 48);
            this.put("mango-117", 49);
            this.put("mango-120", 50);
            this.put("mango-2", 51);
            this.put("mango-20", 52);
            this.put("mango-3", 53);
            this.put("mango-50", 54);
        }
    };
    public static Map<String, Integer> resourceCodes = new HashMap<String, Integer>(){
        {
            this.put("07.23.0008", 0);
            this.put("07.23.0019", 1);
            this.put("07.23.0010", 2);
            this.put("07.24.0001", 3);
            this.put("07.23.0013", 4);
            this.put("07.23.0018", 5);
            this.put("07.23.0009", 6);
            this.put("07.23.0030", 7);
            this.put("07.23.0012", 8);
            this.put("07.23.0036", 9);
            this.put("07.23.0021", 10);
        }
    };

    public static Map<String, String> generateFeatureMapStatic(DPAActFeatureDo dpa) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        if (dpa != null) {
            retMap.put("f201001", DataUtil.Long2String((Long)dpa.getAppId()));
            retMap.put("f108001", DataUtil.Long2String((Long)dpa.getSlotId()));
            retMap.put("f501001", dpa.getUa());
            retMap.put("f505001", dpa.getPriceSection());
            retMap.put("f503001", DataUtil.Long2String((Long)dpa.getAreaCode()));
            retMap.put("390000", dpa.getMaterialId());
            Long regionLevel = DPAActFeatureParse.getRegionLevel(dpa.getAreaCode());
            retMap.put("f4010031", DataUtil.Long2String((Long)regionLevel));
            Long tierCityLevel = DPAActFeatureParse.getTierCityLevel(dpa.getAreaCode());
            retMap.put("f4010032", DataUtil.Long2String((Long)tierCityLevel));
            Integer hour = LocalDateUtil.getHour((LocalDateTime)LocalDateTime.now());
            retMap.put("f502001", DataUtil.Integer2String((Integer)hour));
            Integer weekDay = LocalDateUtil.getDayOfWeek((LocalDateTime)LocalDateTime.now());
            retMap.put("f502002", DataUtil.Integer2String((Integer)weekDay));
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapSlotAct(SlotActFeature slotActFeature) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        if (slotActFeature != null) {
            JSONObject clickCntRatioTradeMap = DataUtil.stringToJson((String)slotActFeature.getClickCntRatioTrade());
            retMap.put("f211001", DPAActFeatureParse.getUserCategoryActLevelByBucket(clickCntRatioTradeMap, tradeCodes, cntRatioBucket));
            JSONObject clickCntRatioAccountMap = DataUtil.stringToJson((String)slotActFeature.getClickCntRatioAccount());
            retMap.put("f211002", DPAActFeatureParse.getUserCategoryActLevelByBucket(clickCntRatioAccountMap, accountCodes, cntRatioBucket));
            JSONObject weekClickCntRatioTradeMap = DataUtil.stringToJson((String)slotActFeature.getWeekClickCntRatioTrade());
            retMap.put("f211003", DPAActFeatureParse.getUserCategoryActLevelByBucket(weekClickCntRatioTradeMap, tradeCodes, cntRatioBucket));
            JSONObject weekClickCntRatioAccountMap = DataUtil.stringToJson((String)slotActFeature.getWeekClickCntRatioAccount());
            retMap.put("f211004", DPAActFeatureParse.getUserCategoryActLevelByBucket(weekClickCntRatioAccountMap, accountCodes, cntRatioBucket));
            JSONObject ctrTradeMap = DataUtil.stringToJson((String)slotActFeature.getCtrTrade());
            retMap.put("f212001", DPAActFeatureParse.getUserCategoryActLevelByBucket(ctrTradeMap, tradeCodes, statCtrBucket));
            JSONObject ctrAccountMap = DataUtil.stringToJson((String)slotActFeature.getCtrAccount());
            retMap.put("f212002", DPAActFeatureParse.getUserCategoryActLevelByBucket(ctrAccountMap, accountCodes, statCtrBucket));
            JSONObject weekCtrTradeMap = DataUtil.stringToJson((String)slotActFeature.getWeekCtrTrade());
            retMap.put("f212003", DPAActFeatureParse.getUserCategoryActLevelByBucket(weekCtrTradeMap, tradeCodes, statCtrBucket));
            JSONObject weekCtrAccountMap = DataUtil.stringToJson((String)slotActFeature.getWeekCtrAccount());
            retMap.put("f212004", DPAActFeatureParse.getUserCategoryActLevelByBucket(weekCtrAccountMap, accountCodes, statCtrBucket));
            JSONObject convertCntRatioTradeMap = DataUtil.stringToJson((String)slotActFeature.getConvertCntRatioTrade());
            retMap.put("f213001", DPAActFeatureParse.getUserCategoryActLevelByBucket(convertCntRatioTradeMap, tradeCodes, cntRatioBucket));
            JSONObject convertCntRatioAccountMap = DataUtil.stringToJson((String)slotActFeature.getConvertCntRatioAccount());
            retMap.put("f213002", DPAActFeatureParse.getUserCategoryActLevelByBucket(convertCntRatioAccountMap, accountCodes, cntRatioBucket));
            JSONObject weekConvertCntRatioTradeMap = DataUtil.stringToJson((String)slotActFeature.getWeekConvertCntRatioTrade());
            retMap.put("f213003", DPAActFeatureParse.getUserCategoryActLevelByBucket(weekConvertCntRatioTradeMap, tradeCodes, cntRatioBucket));
            JSONObject weekConvertCntRatioAccountMap = DataUtil.stringToJson((String)slotActFeature.getWeekConvertCntRatioAccount());
            retMap.put("f213004", DPAActFeatureParse.getUserCategoryActLevelByBucket(weekConvertCntRatioAccountMap, accountCodes, cntRatioBucket));
            JSONObject cvrTradeMap = DataUtil.stringToJson((String)slotActFeature.getCvrTrade());
            retMap.put("f214001", DPAActFeatureParse.getUserCategoryActLevelByBucket(cvrTradeMap, tradeCodes, statCvrBucket));
            JSONObject cvrAccountMap = DataUtil.stringToJson((String)slotActFeature.getCvrAccount());
            retMap.put("f214002", DPAActFeatureParse.getUserCategoryActLevelByBucket(cvrAccountMap, accountCodes, statCvrBucket));
            JSONObject weekCvrTradeMap = DataUtil.stringToJson((String)slotActFeature.getWeekCvrTrade());
            retMap.put("f214003", DPAActFeatureParse.getUserCategoryActLevelByBucket(weekCvrTradeMap, tradeCodes, statCvrBucket));
            JSONObject weekCvrAccountMap = DataUtil.stringToJson((String)slotActFeature.getWeekCvrAccount());
            retMap.put("f214004", DPAActFeatureParse.getUserCategoryActLevelByBucket(weekCvrAccountMap, accountCodes, statCvrBucket));
            JSONObject appSlotActsCateHistClick = DataUtil.stringToJson((String)slotActFeature.getAppSlotActsCateHistClick());
            retMap.put("f230001", DPAActFeatureParse.getCategoryJsonByBucket(appSlotActsCateHistClick, userCtrBucket));
            JSONObject appSlotActsCateWeekClick = DataUtil.stringToJson((String)slotActFeature.getAppSlotActsCateWeekClick());
            retMap.put("f230002", DPAActFeatureParse.getCategoryJsonByBucket(appSlotActsCateWeekClick, userCtrBucket));
            retMap.put("f230003", DPAActFeatureParse.getCategoryMapByBucket(slotActFeature.getAppSlotActsCateDayClick(), userCtrBucket));
            JSONObject appSlotMainTitlesHistClick = DataUtil.stringToJson((String)slotActFeature.getAppSlotMainTitlesHistClick());
            retMap.put("f230004", DPAActFeatureParse.getCategoryJsonByBucket(appSlotMainTitlesHistClick, userCtrBucket));
            JSONObject appSlotMainTitlesWeekClick = DataUtil.stringToJson((String)slotActFeature.getAppSlotMainTitlesWeekClick());
            retMap.put("f230005", DPAActFeatureParse.getCategoryJsonByBucket(appSlotMainTitlesWeekClick, userCtrBucket));
            retMap.put("f230006", DPAActFeatureParse.getCategoryMapByBucket(slotActFeature.getAppSlotMainTitlesDayClick(), userCtrBucket));
            JSONObject appSlotSubTitlesHistClick = DataUtil.stringToJson((String)slotActFeature.getAppSlotSubTitlesHistClick());
            retMap.put("f230007", DPAActFeatureParse.getCategoryJsonByBucket(appSlotSubTitlesHistClick, userCtrBucket));
            JSONObject appSlotSubTitlesWeekClick = DataUtil.stringToJson((String)slotActFeature.getAppSlotSubTitlesWeekClick());
            retMap.put("f230008", DPAActFeatureParse.getCategoryJsonByBucket(appSlotSubTitlesWeekClick, userCtrBucket));
            retMap.put("f230009", DPAActFeatureParse.getCategoryMapByBucket(slotActFeature.getAppSlotSubTitlesDayClick(), userCtrBucket));
            JSONObject appSlotPrizeHistClick = DataUtil.stringToJson((String)slotActFeature.getAppSlotPrizeHistClick());
            retMap.put("f230010", DPAActFeatureParse.getCategoryJsonByBucket(appSlotPrizeHistClick, userCtrBucket));
            JSONObject appSlotPrizeWeekClick = DataUtil.stringToJson((String)slotActFeature.getAppSlotPrizeWeekClick());
            retMap.put("f230011", DPAActFeatureParse.getCategoryJsonByBucket(appSlotPrizeWeekClick, userCtrBucket));
            retMap.put("f230012", DPAActFeatureParse.getCategoryMapByBucket(slotActFeature.getAppSlotPrizeDayClick(), userCtrBucket));
            JSONObject appSlotSkinCateHistClick = DataUtil.stringToJson((String)slotActFeature.getAppSlotSkinCateHistClick());
            retMap.put("f230013", DPAActFeatureParse.getCategoryJsonByBucket(appSlotSkinCateHistClick, userCtrBucket));
            JSONObject appSlotSkinCateWeekClick = DataUtil.stringToJson((String)slotActFeature.getAppSlotSkinCateWeekClick());
            retMap.put("f230014", DPAActFeatureParse.getCategoryJsonByBucket(appSlotSkinCateWeekClick, userCtrBucket));
            retMap.put("f230015", DPAActFeatureParse.getCategoryMapByBucket(slotActFeature.getAppSlotSkinCateDayClick(), userCtrBucket));
            JSONObject appSlotMediaCateHistClick = DataUtil.stringToJson((String)slotActFeature.getAppSlotMediaCateHistClick());
            retMap.put("f230016", DPAActFeatureParse.getCategoryJsonByBucket(appSlotMediaCateHistClick, userCtrBucket));
            JSONObject appSlotMediaCateWeekClick = DataUtil.stringToJson((String)slotActFeature.getAppSlotMediaCateWeekClick());
            retMap.put("f230017", DPAActFeatureParse.getCategoryJsonByBucket(appSlotMediaCateWeekClick, userCtrBucket));
            retMap.put("f230018", DPAActFeatureParse.getCategoryMapByBucket(slotActFeature.getAppSlotMediaCateDayClick(), userCtrBucket));
            JSONObject appSlotActsCateHistOrder = DataUtil.stringToJson((String)slotActFeature.getAppSlotActsCateHistOrder());
            retMap.put("f231001", DPAActFeatureParse.getCategoryJsonByBucket(appSlotActsCateHistOrder, userCtrBucket));
            JSONObject appSlotActsCateWeekOrder = DataUtil.stringToJson((String)slotActFeature.getAppSlotActsCateWeekOrder());
            retMap.put("f231002", DPAActFeatureParse.getCategoryJsonByBucket(appSlotActsCateWeekOrder, userCtrBucket));
            retMap.put("f231003", DPAActFeatureParse.getCategoryMapByBucket(slotActFeature.getAppSlotActsCateDayOrder(), userCtrBucket));
            JSONObject appSlotMainTitlesHistOrder = DataUtil.stringToJson((String)slotActFeature.getAppSlotMainTitlesHistOrder());
            retMap.put("f231004", DPAActFeatureParse.getCategoryJsonByBucket(appSlotMainTitlesHistOrder, userCtrBucket));
            JSONObject appSlotMainTitlesWeekOrder = DataUtil.stringToJson((String)slotActFeature.getAppSlotMainTitlesWeekOrder());
            retMap.put("f231005", DPAActFeatureParse.getCategoryJsonByBucket(appSlotMainTitlesWeekOrder, userCtrBucket));
            retMap.put("f231006", DPAActFeatureParse.getCategoryMapByBucket(slotActFeature.getAppSlotMainTitlesDayOrder(), userCtrBucket));
            JSONObject appSlotSubTitlesHistOrder = DataUtil.stringToJson((String)slotActFeature.getAppSlotSubTitlesHistOrder());
            retMap.put("f231007", DPAActFeatureParse.getCategoryJsonByBucket(appSlotSubTitlesHistOrder, userCtrBucket));
            JSONObject appSlotSubTitlesWeekOrder = DataUtil.stringToJson((String)slotActFeature.getAppSlotSubTitlesWeekOrder());
            retMap.put("f231008", DPAActFeatureParse.getCategoryJsonByBucket(appSlotSubTitlesWeekOrder, userCtrBucket));
            retMap.put("f231009", DPAActFeatureParse.getCategoryMapByBucket(slotActFeature.getAppSlotSubTitlesDayOrder(), userCtrBucket));
            JSONObject appSlotPrizeHistOrder = DataUtil.stringToJson((String)slotActFeature.getAppSlotPrizeHistOrder());
            retMap.put("f231010", DPAActFeatureParse.getCategoryJsonByBucket(appSlotPrizeHistOrder, userCtrBucket));
            JSONObject appSlotPrizeWeekOrder = DataUtil.stringToJson((String)slotActFeature.getAppSlotPrizeWeekOrder());
            retMap.put("f231011", DPAActFeatureParse.getCategoryJsonByBucket(appSlotPrizeWeekOrder, userCtrBucket));
            retMap.put("f231012", DPAActFeatureParse.getCategoryMapByBucket(slotActFeature.getAppSlotPrizeDayOrder(), userCtrBucket));
            JSONObject appSlotSkinCateHistOrder = DataUtil.stringToJson((String)slotActFeature.getAppSlotSkinCateHistOrder());
            retMap.put("f231013", DPAActFeatureParse.getCategoryJsonByBucket(appSlotSkinCateHistOrder, userCtrBucket));
            JSONObject appSlotSkinCateWeekOrder = DataUtil.stringToJson((String)slotActFeature.getAppSlotSkinCateWeekOrder());
            retMap.put("f231014", DPAActFeatureParse.getCategoryJsonByBucket(appSlotSkinCateWeekOrder, userCtrBucket));
            retMap.put("f231015", DPAActFeatureParse.getCategoryMapByBucket(slotActFeature.getAppSlotSkinCateDayOrder(), userCtrBucket));
            JSONObject appSlotMediaCateHistOrder = DataUtil.stringToJson((String)slotActFeature.getAppSlotMediaCateHistOrder());
            retMap.put("f231016", DPAActFeatureParse.getCategoryJsonByBucket(appSlotMediaCateHistOrder, userCtrBucket));
            JSONObject appSlotMediaCateWeekOrder = DataUtil.stringToJson((String)slotActFeature.getAppSlotMediaCateWeekOrder());
            retMap.put("f231017", DPAActFeatureParse.getCategoryJsonByBucket(appSlotMediaCateWeekOrder, userCtrBucket));
            retMap.put("f231018", DPAActFeatureParse.getCategoryMapByBucket(slotActFeature.getAppSlotMediaCateDayOrder(), userCtrBucket));
            JSONObject appSlotActsCateHistConsumer = DataUtil.stringToJson((String)slotActFeature.getAppSlotActsCateHistConsumer());
            retMap.put("f232001", DPAActFeatureParse.getCategoryJsonByBucket(appSlotActsCateHistConsumer, userCtrBucket));
            JSONObject appSlotActsCateWeekConsumer = DataUtil.stringToJson((String)slotActFeature.getAppSlotActsCateWeekConsumer());
            retMap.put("f232002", DPAActFeatureParse.getCategoryJsonByBucket(appSlotActsCateWeekConsumer, userCtrBucket));
            retMap.put("f211005", DPAActFeatureParse.getCategoryMapByBucket(slotActFeature.getDayTradeClickPart(), userCtrBucket));
            retMap.put("f211006", DPAActFeatureParse.getCategoryMapByBucket(slotActFeature.getDayAccountClickPart(), userCtrBucket));
            retMap.put("f212005", DPAActFeatureParse.getCategoryMapByBucket(slotActFeature.getDayTradeClickPart(), userCtrBucket));
            retMap.put("f212006", DPAActFeatureParse.getCategoryMapByBucket(slotActFeature.getDayAccountClickPart(), userCtrBucket));
            retMap.put("f213005", DPAActFeatureParse.getCategoryMapByBucket(slotActFeature.getDayTradeOrderPart(), userCtrBucket));
            retMap.put("f213006", DPAActFeatureParse.getCategoryMapByBucket(slotActFeature.getDayAccountOrderPart(), userCtrBucket));
            retMap.put("f214005", DPAActFeatureParse.getCategoryMapByBucket(slotActFeature.getDayTradeOrderRate(), userCtrBucket));
            retMap.put("f214006", DPAActFeatureParse.getCategoryMapByBucket(slotActFeature.getDayAccountOrderRate(), userCtrBucket));
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapUserProfile(UserProfileFeature userProfileFeature) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        if (userProfileFeature != null) {
            retMap.put("f451001", userProfileFeature.getSex());
            retMap.put("f451002", userProfileFeature.getAge());
            retMap.put("f451003", userProfileFeature.getMarry());
            retMap.put("f451004", userProfileFeature.getConsumeLevel());
            Map appCatePrefMap = DataUtil.stringToMap((String)userProfileFeature.getAppCatePref(), (Object)0);
            retMap.put("f461001", DPAActFeatureParse.getUserCategoryActLevelByBucket(appCatePrefMap, appCodes, cntBucket));
            Map recentAppCatePrefMap = DataUtil.stringToMap((String)userProfileFeature.getRecentAppCatePref(), (Object)0);
            retMap.put("f461002", DPAActFeatureParse.getUserCategoryActLevelByBucket(recentAppCatePrefMap, appCodes, cntBucket));
            Map recentTextCatePrefMap = DataUtil.stringToMap((String)userProfileFeature.getRecentTextCatePref(), (Object)0);
            retMap.put("f461004", DPAActFeatureParse.getUserCategoryActLevelByBucket(recentTextCatePrefMap, msgSigCodes, cntBucket));
            Map keywordCatePrefMap = DataUtil.stringToMap((String)userProfileFeature.getKeywordCatePref(), (Object)0);
            retMap.put("f461005", DPAActFeatureParse.getUserCategoryActLevelByBucket(keywordCatePrefMap, keywordCodes, cntBucket));
            retMap.put("f461011", userProfileFeature.getRecentVideoKeywordPref());
            Map scoreCateInterestMap = DataUtil.stringToMap((String)userProfileFeature.getScoreCateInterest(), (Object)0);
            retMap.put("f471003", DPAActFeatureParse.getUserCategoryActLevelByBucket(scoreCateInterestMap, resourceCodes, cateScoreBucket));
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapBase(FeatureDo fd) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        if (fd != null) {
            retMap.put("f9921", fd.getUICtr());
            retMap.put("f9922", fd.getUICvr());
            retMap.put("f9923", fd.getUUnICtr());
            retMap.put("f9924", fd.getUUnICvr());
            Map<String, Map<String, Long>> ubpMap = DPAActFeatureParse.getUserBehavioralPreference(fd.getUIIds(), fd.getUILaunchPV(), fd.getUIClickPv(), fd.getUIEffectPv());
            retMap.put("f808001", DPAActFeatureParse.getUserBehavioralPreference(2, "ctr", ubpMap, null));
            retMap.put("f809001", DPAActFeatureParse.getUserBehavioralPreference(0, "ctr", ubpMap, null));
            retMap.put("f811001", DPAActFeatureParse.getUserBehavioralPreference(3, "ctr", ubpMap, null));
            retMap.put("f808002", DPAActFeatureParse.getUserBehavioralPreference(2, "cvr", ubpMap, null));
            retMap.put("f809002", DPAActFeatureParse.getUserBehavioralPreference(0, "cvr", ubpMap, null));
            retMap.put("f811002", DPAActFeatureParse.getUserBehavioralPreference(3, "cvr", ubpMap, null));
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapUserAct(UserActFeature userActFeature) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        if (userActFeature != null) {
            retMap.put("f410001", DPAActFeatureParse.bucket(userActFeature.getUserActiveDays(), cntBucket).toString());
            retMap.put("f411001", DPAActFeatureParse.bucket(userActFeature.getActivityRequest(), cntBucket).toString());
            retMap.put("f411002", DPAActFeatureParse.bucket(userActFeature.getWeekActivityRequest(), cntBucket).toString());
            retMap.put("f411003", DPAActFeatureParse.bucket(userActFeature.getDayActivityRequest(), cntBucket).toString());
            retMap.put("f411004", DPAActFeatureParse.bucket(userActFeature.getIntervalActivityRequest(), cntBucket).toString());
            retMap.put("f411005", userActFeature.getPeriodActivityRequest());
            retMap.put("f412001", DPAActFeatureParse.bucket(userActFeature.getActivityJoin(), cntBucket).toString());
            retMap.put("f412002", DPAActFeatureParse.bucket(userActFeature.getWeekActivityJoin(), cntBucket).toString());
            retMap.put("f412003", DPAActFeatureParse.bucket(userActFeature.getDayActivityJoin(), cntBucket).toString());
            retMap.put("f412004", DPAActFeatureParse.bucket(userActFeature.getIntervalActivityJoin(), cntBucket).toString());
            retMap.put("f412005", userActFeature.getPeriodActivityJoin());
            Map clickTraceActMap = DataUtil.stringToMap((String)userActFeature.getClickTrade(), (Object)0);
            retMap.put("f414001", DPAActFeatureParse.getUserCategoryActLevelByBucket(clickTraceActMap, tradeCodes, cntBucket));
            Map weekClickTradeActMap = DataUtil.stringToMap((String)userActFeature.getWeekClickTrade(), (Object)0);
            retMap.put("f414002", DPAActFeatureParse.getUserCategoryActLevelByBucket(weekClickTradeActMap, tradeCodes, cntBucket));
            retMap.put("f414003", DPAActFeatureParse.getUserCategoryActLevelByBucket(userActFeature.getDayClickTrade(), tradeCodes, cntBucket));
            retMap.put("f414004", DPAActFeatureParse.bucket(userActFeature.getIntervalClickTrade(), cntBucket).toString());
            retMap.put("f414005", userActFeature.getPeriodClickTrade());
            retMap.put("f414007", userActFeature.getLastClickTrade());
            retMap.put("f414008", userActFeature.getEffectClickTrade() == null ? null : userActFeature.getEffectClickTrade().toString());
            Map effectTradeActMap = DataUtil.stringToMap((String)userActFeature.getEffectTrade(), (Object)0);
            retMap.put("f415001", DPAActFeatureParse.getUserCategoryActLevelByBucket(effectTradeActMap, tradeCodes, cntBucket));
            Map weekEffectTradeActMap = DataUtil.stringToMap((String)userActFeature.getWeekEffectTrade(), (Object)0);
            retMap.put("f415002", DPAActFeatureParse.getUserCategoryActLevelByBucket(weekEffectTradeActMap, tradeCodes, cntBucket));
            retMap.put("f415003", DPAActFeatureParse.getUserCategoryActLevelByBucket(userActFeature.getDayEffectTrade(), tradeCodes, cntBucket));
            retMap.put("f415004", DPAActFeatureParse.bucket(userActFeature.getIntervalEffectTrade(), cntBucket).toString());
            retMap.put("f415005", userActFeature.getPeriodEffectTrade());
            retMap.put("f415007", userActFeature.getLastEffectTrade());
            retMap.put("f462002", DPAActFeatureParse.bucket(userActFeature.getLastVideoTime(), videoDurationBucket).toString());
            retMap.put("f462003", userActFeature.getLastVideoChannel());
            retMap.put("f462004", userActFeature.getLastVideoInfo());
            JSONObject histEntrancesExposeTime = DataUtil.stringToJson((String)userActFeature.getHistEntrancesExposeTime());
            retMap.put("f481001", DPAActFeatureParse.getCategoryJsonByBucket(histEntrancesExposeTime, cntBucket));
            JSONObject weekEntrancesExposeTime = DataUtil.stringToJson((String)userActFeature.getWeekEntrancesExposeTime());
            retMap.put("f481002", DPAActFeatureParse.getCategoryJsonByBucket(weekEntrancesExposeTime, cntBucket));
            retMap.put("f481003", DPAActFeatureParse.getCategoryMapByBucket(userActFeature.getDayEntrancesExposeTime(), cntBucket));
            JSONObject materialExposeInterval = DataUtil.stringToJson((String)userActFeature.getMaterialExposeInterval());
            retMap.put("f481004", DPAActFeatureParse.getCategoryJsonByBucket(materialExposeInterval, cntBucket));
            JSONObject materialExposePeriod = DataUtil.stringToJson((String)userActFeature.getMaterialExposePeriod());
            retMap.put("f481005", DPAActFeatureParse.getStringsToBuckets(materialExposePeriod, 7));
            JSONObject histEntrancesClickTime = DataUtil.stringToJson((String)userActFeature.getHistEntrancesClickTime());
            retMap.put("f482001", DPAActFeatureParse.getCategoryJsonByBucket(histEntrancesClickTime, cntBucket));
            JSONObject weekEntrancesClickTime = DataUtil.stringToJson((String)userActFeature.getWeekEntrancesClickTime());
            retMap.put("f482002", DPAActFeatureParse.getCategoryJsonByBucket(weekEntrancesClickTime, cntBucket));
            retMap.put("f482003", DPAActFeatureParse.getCategoryMapByBucket(userActFeature.getDayEntrancesClickTime(), cntBucket));
            JSONObject materialClickInterval = DataUtil.stringToJson((String)userActFeature.getMaterialClickInterval());
            retMap.put("f482004", DPAActFeatureParse.getCategoryJsonByBucket(materialClickInterval, cntBucket));
            JSONObject materialClickPeriod = DataUtil.stringToJson((String)userActFeature.getMaterialClickPeriod());
            retMap.put("f482005", DPAActFeatureParse.getStringsToBuckets(materialClickPeriod, 7));
            JSONObject histMainTitlesExposeTime = DataUtil.stringToJson((String)userActFeature.getHistMainTitlesExposeTime());
            retMap.put("f483001", DPAActFeatureParse.getCategoryJsonByBucket(histMainTitlesExposeTime, cntBucket));
            JSONObject weekMainTitlesExposeTime = DataUtil.stringToJson((String)userActFeature.getWeekMainTitlesExposeTime());
            retMap.put("f483001", DPAActFeatureParse.getCategoryJsonByBucket(weekMainTitlesExposeTime, cntBucket));
            retMap.put("f483003", DPAActFeatureParse.getCategoryMapByBucket(userActFeature.getDayMainTitlesExposeTime(), cntBucket));
            JSONObject histSubTitlesExposeTime = DataUtil.stringToJson((String)userActFeature.getHistSubTitlesExposeTime());
            retMap.put("f483004", DPAActFeatureParse.getCategoryJsonByBucket(histSubTitlesExposeTime, cntBucket));
            JSONObject weekSubTitlesExposeTime = DataUtil.stringToJson((String)userActFeature.getWeekSubTitlesExposeTime());
            retMap.put("f483005", DPAActFeatureParse.getCategoryJsonByBucket(weekSubTitlesExposeTime, cntBucket));
            retMap.put("f483006", DPAActFeatureParse.getCategoryMapByBucket(userActFeature.getDaySubTitlesExposeTime(), cntBucket));
            JSONObject histPrizesExposeTime = DataUtil.stringToJson((String)userActFeature.getHistPrizesExposeTime());
            retMap.put("f483007", DPAActFeatureParse.getCategoryJsonByBucket(histPrizesExposeTime, cntBucket));
            JSONObject weekPrizesExposeTime = DataUtil.stringToJson((String)userActFeature.getWeekPrizesExposeTime());
            retMap.put("f483008", DPAActFeatureParse.getCategoryJsonByBucket(weekPrizesExposeTime, cntBucket));
            retMap.put("f483009", DPAActFeatureParse.getCategoryMapByBucket(userActFeature.getDayPrizesExposeTime(), cntBucket));
            JSONObject histSkinsExposeTime = DataUtil.stringToJson((String)userActFeature.getHistSkinsExposeTime());
            retMap.put("f483010", DPAActFeatureParse.getCategoryJsonByBucket(histSkinsExposeTime, cntBucket));
            JSONObject weekSkinsExposeTime = DataUtil.stringToJson((String)userActFeature.getWeekSkinsExposeTime());
            retMap.put("f483011", DPAActFeatureParse.getCategoryJsonByBucket(weekSkinsExposeTime, cntBucket));
            retMap.put("f483012", DPAActFeatureParse.getCategoryMapByBucket(userActFeature.getDaySkinsExposeTime(), cntBucket));
            JSONObject histMainTitlesClickTime = DataUtil.stringToJson((String)userActFeature.getHistMainTitlesClickTime());
            retMap.put("f484001", DPAActFeatureParse.getCategoryJsonByBucket(histMainTitlesClickTime, cntBucket));
            JSONObject weekMainTitlesClickTime = DataUtil.stringToJson((String)userActFeature.getWeekMainTitlesClickTime());
            retMap.put("f484001", DPAActFeatureParse.getCategoryJsonByBucket(weekMainTitlesClickTime, cntBucket));
            retMap.put("f484003", DPAActFeatureParse.getCategoryMapByBucket(userActFeature.getDayMainTitlesClickTime(), cntBucket));
            JSONObject histSubTitlesClickTime = DataUtil.stringToJson((String)userActFeature.getHistSubTitlesClickTime());
            retMap.put("f484004", DPAActFeatureParse.getCategoryJsonByBucket(histSubTitlesClickTime, cntBucket));
            JSONObject weekSubTitlesClickTime = DataUtil.stringToJson((String)userActFeature.getWeekSubTitlesClickTime());
            retMap.put("f484005", DPAActFeatureParse.getCategoryJsonByBucket(weekSubTitlesClickTime, cntBucket));
            retMap.put("f484006", DPAActFeatureParse.getCategoryMapByBucket(userActFeature.getDaySubTitlesClickTime(), cntBucket));
            JSONObject histPrizesClickTime = DataUtil.stringToJson((String)userActFeature.getHistPrizesClickTime());
            retMap.put("f484007", DPAActFeatureParse.getCategoryJsonByBucket(histPrizesClickTime, cntBucket));
            JSONObject weekPrizesClickTime = DataUtil.stringToJson((String)userActFeature.getWeekPrizesClickTime());
            retMap.put("f484008", DPAActFeatureParse.getCategoryJsonByBucket(weekPrizesClickTime, cntBucket));
            retMap.put("f484009", DPAActFeatureParse.getCategoryMapByBucket(userActFeature.getDayPrizesClickTime(), cntBucket));
            JSONObject histSkinsClickTime = DataUtil.stringToJson((String)userActFeature.getHistSkinsClickTime());
            retMap.put("f484010", DPAActFeatureParse.getCategoryJsonByBucket(histSkinsClickTime, cntBucket));
            JSONObject weekSkinsClickTime = DataUtil.stringToJson((String)userActFeature.getWeekSkinsClickTime());
            retMap.put("f484011", DPAActFeatureParse.getCategoryJsonByBucket(weekSkinsClickTime, cntBucket));
            retMap.put("f484012", DPAActFeatureParse.getCategoryMapByBucket(userActFeature.getDaySkinsClickTime(), cntBucket));
            JSONObject histMainTitlesOrderTime = DataUtil.stringToJson((String)userActFeature.getHistMainTitlesOrderTime());
            retMap.put("f485001", DPAActFeatureParse.getCategoryJsonByBucket(histMainTitlesOrderTime, cntBucket));
            JSONObject weekMainTitlesOrderTime = DataUtil.stringToJson((String)userActFeature.getWeekMainTitlesOrderTime());
            retMap.put("f485002", DPAActFeatureParse.getCategoryJsonByBucket(weekMainTitlesOrderTime, cntBucket));
            retMap.put("f485003", DPAActFeatureParse.getCategoryMapByBucket(userActFeature.getDayMainTitlesOrderTime(), cntBucket));
            JSONObject histSubTitlesOrderTime = DataUtil.stringToJson((String)userActFeature.getHistSubTitlesOrderTime());
            retMap.put("f485004", DPAActFeatureParse.getCategoryJsonByBucket(histSubTitlesOrderTime, cntBucket));
            JSONObject weekSubTitlesOrderTime = DataUtil.stringToJson((String)userActFeature.getWeekSubTitlesOrderTime());
            retMap.put("f485005", DPAActFeatureParse.getCategoryJsonByBucket(weekSubTitlesOrderTime, cntBucket));
            retMap.put("f485006", DPAActFeatureParse.getCategoryMapByBucket(userActFeature.getDaySubTitlesOrderTime(), cntBucket));
            JSONObject histPrizesOrderTime = DataUtil.stringToJson((String)userActFeature.getHistPrizesOrderTime());
            retMap.put("f485007", DPAActFeatureParse.getCategoryJsonByBucket(histPrizesOrderTime, cntBucket));
            JSONObject weekPrizesOrderTime = DataUtil.stringToJson((String)userActFeature.getWeekPrizesOrderTime());
            retMap.put("f485008", DPAActFeatureParse.getCategoryJsonByBucket(weekPrizesOrderTime, cntBucket));
            retMap.put("f485009", DPAActFeatureParse.getCategoryMapByBucket(userActFeature.getDayPrizesOrderTime(), cntBucket));
            JSONObject histSkinsOrderTime = DataUtil.stringToJson((String)userActFeature.getHistSkinsOrderTime());
            retMap.put("f485010", DPAActFeatureParse.getCategoryJsonByBucket(histSkinsOrderTime, cntBucket));
            JSONObject weekSkinsOrderTime = DataUtil.stringToJson((String)userActFeature.getWeekSkinsOrderTime());
            retMap.put("f485011", DPAActFeatureParse.getCategoryJsonByBucket(weekSkinsOrderTime, cntBucket));
            retMap.put("f485012", DPAActFeatureParse.getCategoryMapByBucket(userActFeature.getDaySkinsOrderTime(), cntBucket));
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(DPAActFeatureDo dpa) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        if (dpa.getCandidateActivityDo() != null) {
            retMap.put("f301001", DataUtil.Long2String((Long)dpa.getCandidateActivityDo().getActivityId()));
            retMap.put("f331001", DataUtil.Long2String((Long)dpa.getCandidateActivityDo().getSkinId()));
            retMap.put("f331002", DataUtil.Long2String((Long)dpa.getCandidateActivityDo().getTitleId()));
            retMap.put("f331003", DataUtil.Long2String((Long)dpa.getCandidateActivityDo().getSubTitleId()));
            retMap.put("f331005", dpa.getCandidateActivityDo().getTitleTagId());
            retMap.put("f331006", dpa.getCandidateActivityDo().getSubTitleTagId());
            retMap.put("f341002", DPAActFeatureParse.bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActHistClick(), userCtrBucket).toString());
            retMap.put("f341003", DPAActFeatureParse.bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActWeekClick(), userCtrBucket).toString());
            retMap.put("f341004", DPAActFeatureParse.bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActHistOrder(), userCtrBucket).toString());
            retMap.put("f341005", DPAActFeatureParse.bucket(dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActWeekOrder(), userCtrBucket).toString());
            JSONObject routineActTradeVisitTime = DataUtil.stringToJson((String)dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActTradeVisitTime());
            retMap.put("f341006", DPAActFeatureParse.getCategoryJsonByBucket(routineActTradeVisitTime, cntBucket));
            JSONObject routineActTradeClickTime = DataUtil.stringToJson((String)dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActTradeClickTime());
            retMap.put("f341007", DPAActFeatureParse.getCategoryJsonByBucket(routineActTradeClickTime, cntBucket));
            retMap.put("f341008", dpa.getCandidateActivityDo().getRoutineActFeature().getRoutineActActType());
            JSONObject componentMainTitleCategory = DataUtil.stringToJson((String)dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleCategory());
            retMap.put("f351001", DPAActFeatureParse.getStringsToBuckets(componentMainTitleCategory, 1000));
            retMap.put("f351002", DPAActFeatureParse.bucket(dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleHistClick(), userCtrBucket).toString());
            retMap.put("f351003", DPAActFeatureParse.bucket(dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleWeekClick(), userCtrBucket).toString());
            retMap.put("f351004", DPAActFeatureParse.bucket(dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleDayClick(), userCtrBucket).toString());
            retMap.put("f351005", DPAActFeatureParse.bucket(dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleHistOrder(), userCtrBucket).toString());
            retMap.put("f351006", DPAActFeatureParse.bucket(dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleWeekOrder(), userCtrBucket).toString());
            retMap.put("f351007", DPAActFeatureParse.bucket(dpa.getCandidateActivityDo().getMainTitleFeature().getComponentTitleDayOrder(), userCtrBucket).toString());
            JSONObject componentSubTitleCategory = DataUtil.stringToJson((String)dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleCategory());
            retMap.put("f352001", DPAActFeatureParse.getStringsToBuckets(componentSubTitleCategory, 1000));
            retMap.put("f352002", DPAActFeatureParse.bucket(dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleHistClick(), userCtrBucket).toString());
            retMap.put("f352003", DPAActFeatureParse.bucket(dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleWeekClick(), userCtrBucket).toString());
            retMap.put("f352004", DPAActFeatureParse.bucket(dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleDayClick(), userCtrBucket).toString());
            retMap.put("f352005", DPAActFeatureParse.bucket(dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleHistOrder(), userCtrBucket).toString());
            retMap.put("f352006", DPAActFeatureParse.bucket(dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleWeekOrder(), userCtrBucket).toString());
            retMap.put("f352007", DPAActFeatureParse.bucket(dpa.getCandidateActivityDo().getSubTitleFeature().getComponentTitleDayOrder(), userCtrBucket).toString());
            List<PrizeDo> prizeDos = dpa.getCandidateActivityDo().getPrizeGroup();
            if (prizeDos != null) {
                for (int i = 0; i < prizeDos.size() && i < 6; ++i) {
                    retMap.put(String.format("f3320%s1", i + 1), DataUtil.Long2String((Long)prizeDos.get(i).getId()));
                    retMap.put(String.format("f3320%s2", i + 1), DataUtil.Long2String((Long)(prizeDos.get(i).isAd() ? 1L : 2L)));
                    retMap.put(String.format("f3320%s3", i + 1), prizeDos.get(i).getAdTagId());
                    retMap.put(String.format("f3530%s0", i + 1), DPAActFeatureParse.bucket(prizeDos.get(i).getPrizeFeature().getComponentOrdPrizeHistClick(), userCtrBucket).toString());
                    retMap.put(String.format("f3530%s1", i + 1), DPAActFeatureParse.bucket(prizeDos.get(i).getPrizeFeature().getComponentOrdPrizeWeekClick(), userCtrBucket).toString());
                    retMap.put(String.format("f3530%s2", i + 1), DPAActFeatureParse.bucket(prizeDos.get(i).getPrizeFeature().getComponentOrdPrizeDayClick(), userCtrBucket).toString());
                    retMap.put(String.format("f3530%s3", i + 1), DPAActFeatureParse.bucket(prizeDos.get(i).getPrizeFeature().getComponentOrdPrizeHistOrder(), userCtrBucket).toString());
                    retMap.put(String.format("f3530%s4", i + 1), DPAActFeatureParse.bucket(prizeDos.get(i).getPrizeFeature().getComponentOrdPrizeWeekOrder(), userCtrBucket).toString());
                    retMap.put(String.format("f3530%s5", i + 1), DPAActFeatureParse.bucket(prizeDos.get(i).getPrizeFeature().getComponentOrdPrizeDayOrder(), userCtrBucket).toString());
                    JSONObject componentPrizeTradeCategory = DataUtil.stringToJson((String)prizeDos.get(i).getPrizeFeature().getComponentPrizeTradeCategory());
                    retMap.put(String.format("f3530%s6", i + 1), DPAActFeatureParse.getStringsToBuckets(componentPrizeTradeCategory, 100));
                }
            }
            retMap.put("f354001", dpa.getCandidateActivityDo().getSkinFeature().getComponentSkinCategory());
            retMap.put("f354004", DPAActFeatureParse.bucket(dpa.getCandidateActivityDo().getSkinFeature().getComponentSkinHistClick(), userCtrBucket).toString());
            retMap.put("f354005", DPAActFeatureParse.bucket(dpa.getCandidateActivityDo().getSkinFeature().getComponentSkinWeekClick(), userCtrBucket).toString());
            retMap.put("f354006", DPAActFeatureParse.bucket(dpa.getCandidateActivityDo().getSkinFeature().getComponentSkinDayClick(), userCtrBucket).toString());
            retMap.put("f354007", DPAActFeatureParse.bucket(dpa.getCandidateActivityDo().getSkinFeature().getComponentSkinHistOrder(), userCtrBucket).toString());
            retMap.put("f354008", DPAActFeatureParse.bucket(dpa.getCandidateActivityDo().getSkinFeature().getComponentSkinWeekOrder(), userCtrBucket).toString());
            retMap.put("f354009", DPAActFeatureParse.bucket(dpa.getCandidateActivityDo().getSkinFeature().getComponentSkinDayOrder(), userCtrBucket).toString());
        }
        return retMap;
    }

    public static Long getRegionLevel(Long areaCode) {
        Long ret = null;
        if (AssertUtil.isNotEmpty((Object)areaCode)) {
            int area = DataUtil.toInt((Long)areaCode);
            if (areaCode >= 1000L && areaCode != 8100L && areaCode != 8200L) {
                area = DataUtil.toInt((Long)(areaCode / 100L));
            }
            if (Arrays.asList(HUABEI_REGION).contains(area)) {
                ret = 80L;
            } else if (Arrays.asList(DONGBEI_REGION).contains(area)) {
                ret = 81L;
            } else if (Arrays.asList(HUADONG_REGION).contains(area)) {
                ret = 82L;
            } else if (Arrays.asList(HUAZHONG_REGION).contains(area)) {
                ret = 83L;
            } else if (Arrays.asList(HUANAN_REGION).contains(area)) {
                ret = 84L;
            } else if (Arrays.asList(XINAN_REGION).contains(area)) {
                ret = 85L;
            } else if (Arrays.asList(XIBEI_REGION).contains(area)) {
                ret = 86L;
            } else if (Arrays.asList(HMT_REGION).contains(area)) {
                ret = 87L;
            }
        }
        return ret;
    }

    public static Long getTierCityLevel(Long areaCode) {
        Long ret = null;
        if (AssertUtil.isNotEmpty((Object)areaCode)) {
            int area = DataUtil.toInt((Long)areaCode);
            if (Arrays.asList(FIRST_TIER_CITY).contains(area)) {
                ret = 1L;
            } else if (Arrays.asList(SECOND_TIER_CITY).contains(area)) {
                ret = 2L;
            } else if (Arrays.asList(THIRD_TIER_CITY).contains(area)) {
                ret = 3L;
            }
        }
        return ret;
    }

    public static Long bucket(Long value, int[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                int bound = bucketList[i];
                if (value > (long)bound) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static Long bucket(Double value, double[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i];
                if (!(value <= bound)) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static Long bucket(Integer value, int[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                int bound = bucketList[i];
                if (value > bound) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static String getCategoryMapByBucket(Map<String, Integer> actMap, int[] buckets) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{actMap})) {
            return null;
        }
        ArrayList<Long> tmp = new ArrayList<Long>();
        try {
            for (Map.Entry<String, Integer> entry : actMap.entrySet()) {
                Integer cateKey = Integer.parseInt(entry.getKey());
                Integer cateValue = entry.getValue();
                long value = (long)(cateKey * buckets.length) + DPAActFeatureParse.bucket(cateValue, buckets);
                tmp.add(value);
            }
        }
        catch (Exception e) {
            return null;
        }
        return StringUtils.join(tmp, (String)",");
    }

    public static String getStringsToBuckets(JSONObject actMap, Integer limit) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{actMap})) {
            return null;
        }
        ArrayList<Long> tmp = new ArrayList<Long>();
        try {
            for (String cKey : actMap.keySet()) {
                Integer cateKey = Integer.parseInt(cKey);
                Integer cateValue = actMap.getInteger(cKey);
                long value = cateKey * limit + cateValue;
                tmp.add(value);
            }
        }
        catch (Exception e) {
            return null;
        }
        return StringUtils.join(tmp, (String)",");
    }

    public static String getCategoryMapByBucket(Map<String, Double> actMap, double[] buckets) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{actMap})) {
            return null;
        }
        ArrayList<Long> tmp = new ArrayList<Long>();
        try {
            for (Map.Entry<String, Double> entry : actMap.entrySet()) {
                Integer cateKey = Integer.parseInt(entry.getKey());
                Double cateValue = entry.getValue();
                long value = (long)(cateKey * buckets.length) + DPAActFeatureParse.bucket(cateValue, buckets);
                tmp.add(value);
            }
        }
        catch (Exception e) {
            return null;
        }
        return StringUtils.join(tmp, (String)",");
    }

    public static String getCategoryJsonByBucket(JSONObject actMap, int[] buckets) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{actMap})) {
            return null;
        }
        ArrayList<Long> tmp = new ArrayList<Long>();
        try {
            for (String cKey : actMap.keySet()) {
                Integer cateKey = Integer.parseInt(cKey);
                Integer cateValue = actMap.getInteger(cKey);
                long value = (long)(cateKey * buckets.length) + DPAActFeatureParse.bucket(cateValue, buckets);
                tmp.add(value);
            }
        }
        catch (Exception e) {
            return null;
        }
        return StringUtils.join(tmp, (String)",");
    }

    public static String getCategoryJsonByBucket(JSONObject actMap, double[] buckets) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{actMap})) {
            return null;
        }
        ArrayList<Long> tmp = new ArrayList<Long>();
        try {
            for (String cKey : actMap.keySet()) {
                Integer cateKey = Integer.parseInt(cKey);
                Double cateValue = actMap.getDouble(cKey);
                long value = (long)(cateKey * buckets.length) + DPAActFeatureParse.bucket(cateValue, buckets);
                tmp.add(value);
            }
        }
        catch (Exception e) {
            return null;
        }
        return StringUtils.join(tmp, (String)",");
    }

    public static String getUserCategoryActLevelByBucket(Map<String, Integer> actMap, Map<String, Integer> category, int[] buckets) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{actMap, category, buckets})) {
            return null;
        }
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;
        ArrayList<Long> tmp = new ArrayList<Long>();
        try {
            for (Map.Entry<String, Integer> entry : actMap.entrySet()) {
                String cateKey = entry.getKey();
                Integer cateValue = entry.getValue();
                if (!category.containsKey(cateKey)) continue;
                Integer i = category.get(cateKey);
                long value = (long)(i * limit) + DPAActFeatureParse.bucket(cateValue, buckets);
                tmp.add(value);
            }
        }
        catch (Exception e) {
            return null;
        }
        return StringUtils.join(tmp, (String)",");
    }

    public static String getUserCategoryActLevelByBucket(JSONObject actMap, Map<String, Integer> category, double[] buckets) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{actMap, category, buckets})) {
            return null;
        }
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;
        ArrayList<Long> tmp = new ArrayList<Long>();
        try {
            for (String cateKey : actMap.keySet()) {
                Double cateValue = actMap.getDouble(cateKey);
                if (!category.containsKey(cateKey)) continue;
                Integer i = category.get(cateKey);
                long value = (long)(i * limit) + DPAActFeatureParse.bucket(cateValue, buckets);
                tmp.add(value);
            }
        }
        catch (Exception e) {
            return null;
        }
        return StringUtils.join(tmp, (String)",");
    }

    public static String getUserBehavioralPreference(int dimType, String statType, Map<String, Map<String, Long>> ubpMap, String tags) {
        String ret = null;
        try {
            Object tag;
            if (dimType == 0 && ubpMap != null) {
                ret = DataUtil.Long2String((Long)ubpMap.get(statType).get("0"));
            }
            if (dimType == 1 && ubpMap != null && (tag = DPAActFeatureParse.getTag(tags)) != null) {
                ret = ubpMap.get(statType).get(tag) + "";
                if (((String)tag).length() == 10 && ret == null) {
                    String string = ((String)tag).substring(0, 5);
                    ret = DataUtil.Long2String((Long)ubpMap.get(statType).get(string));
                }
            }
            if (dimType == 2 && AssertUtil.isNotEmpty(ubpMap.get(statType))) {
                ret = "";
                for (Map.Entry entry : ubpMap.get(statType).entrySet()) {
                    String string = (String)entry.getKey() + "_" + entry.getValue() + ",";
                    ret = ret + string;
                }
                if (ret.endsWith(",")) {
                    ret = ret.substring(0, ret.length() - 1);
                }
            }
            if (dimType == 3 && AssertUtil.isNotEmpty(ubpMap.get(statType))) {
                ret = "";
                HashMap<Long, Long> levelCntMap = new HashMap<Long, Long>();
                for (Map.Entry<String, Long> entry : ubpMap.get(statType).entrySet()) {
                    String tag2 = entry.getKey();
                    Long ctrLevel = DPAActFeatureParse.bucket(entry.getValue(), ctrAndCvrLevelBucket);
                    if (ctrLevel == null || tag2 == "0") continue;
                    if (!levelCntMap.containsKey(ctrLevel)) {
                        levelCntMap.put(ctrLevel, 0L);
                    }
                    levelCntMap.put(ctrLevel, (Long)levelCntMap.get(ctrLevel) + 1L);
                }
                for (Map.Entry entry : levelCntMap.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    Long cntLevel = DPAActFeatureParse.bucket((Long)entry.getValue(), cntBucket);
                    String v = (Long)entry.getKey() * 100L + cntLevel + ",";
                    ret = ret + v;
                }
                if (ret.endsWith(",")) {
                    ret = ret.substring(0, ret.length() - 1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String getTag(String tags) {
        Object[] tagArr;
        String ret = null;
        if (AssertUtil.isNotEmpty((String)tags) && AssertUtil.isNotEmpty((Object[])(tagArr = tags.split(",")))) {
            for (int i = 0; i < tagArr.length; ++i) {
                String tmp = DPAActFeatureParse.validTag((String)tagArr[i]);
                if (tmp == null) continue;
                ret = DPAActFeatureParse.validTag((String)tagArr[i]);
            }
        }
        return ret;
    }

    public static String validTag(String tag) {
        String ret = null;
        if (AssertUtil.isNotEmpty((String)tag) && tag.contains(".")) {
            ret = tag;
        }
        return ret;
    }

    public static Map<String, Map<String, Long>> getUserBehavioralPreference(String uIIds, String uILaunchPv, String uIClickPv, String uIEffectPv) {
        HashMap<String, Map<String, Long>> ret = new HashMap<String, Map<String, Long>>();
        ret.put("ctr", new HashMap());
        ret.put("cvr", new HashMap());
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{uIIds, uILaunchPv, uIClickPv, uIEffectPv})) {
            String[] uIIdsArr = uIIds.split(",");
            String[] uILaunchPvArr = uILaunchPv.split(",");
            String[] uIClickPvArr = uIClickPv.split(",");
            String[] uIEffectPvArr = uIEffectPv.split(",");
            if (uIIdsArr.length > 0 && uIIdsArr.length == uILaunchPvArr.length && uIIdsArr.length == uIClickPvArr.length && uIIdsArr.length == uIEffectPvArr.length) {
                Long launchAccPv = 0L;
                Long clickAccPv = 0L;
                Long effectAccPv = 0L;
                for (int i = 0; i < uIIdsArr.length; ++i) {
                    String id = uIIdsArr[i];
                    Long launchPv = DataUtil.str2Long((String)uILaunchPvArr[i], (Long)0L);
                    Long clickPv = DataUtil.str2Long((String)uIClickPvArr[i], (Long)0L);
                    Long effectPv = DataUtil.str2Long((String)uIEffectPvArr[i], (Long)0L);
                    Double ctr = DPAActFeatureParse.getCtrOrCvr(launchPv, clickPv);
                    Double cvr = DPAActFeatureParse.getCtrOrCvr(clickPv, effectPv);
                    Long ctrBucketLevel = DPAActFeatureParse.bucket(ctr, userCtrBucket);
                    Long cvrBucketLevel = DPAActFeatureParse.bucket(cvr, userCvrBucket);
                    ((Map)ret.get("ctr")).put(id, ctrBucketLevel);
                    ((Map)ret.get("cvr")).put(id, cvrBucketLevel);
                    launchAccPv = launchAccPv + launchPv;
                    clickAccPv = clickAccPv + clickPv;
                    effectAccPv = effectAccPv + effectPv;
                }
                Double ctr = DPAActFeatureParse.getCtrOrCvr(launchAccPv, clickAccPv);
                Double cvr = DPAActFeatureParse.getCtrOrCvr(clickAccPv, effectAccPv);
                Long ctrBucketLevel = DPAActFeatureParse.bucket(ctr, userCtrBucket);
                Long cvrBucketLevel = DPAActFeatureParse.bucket(cvr, userCvrBucket);
                ((Map)ret.get("ctr")).put("0", ctrBucketLevel);
                ((Map)ret.get("cvr")).put("0", cvrBucketLevel);
            }
        }
        return ret;
    }

    public static Double getCtrOrCvr(Long firstPv, Long secondPv) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{firstPv, secondPv}) && firstPv > 0L) {
            ret = DataUtil.division((Long)secondPv, (Long)firstPv);
        }
        return ret;
    }

    public static void main(String[] args) {
        DPAFeature dpa = new DPAFeature();
    }
}

