/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.DateUtil;
import cn.com.duiba.nezha.alg.feature.vo.FeatureDo;
import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class FeatureParse {
    public static int[] dayOrderRankBucket = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 15, 20, 30, 60, 100};
    public static int[] orderRankBucket = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 15, 20, 25, 30, 35, 50, 70, 100, 200, 500};
    public static int[] dayActOrderRankBucket = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 20};
    public static int[] orderActRankBucket = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 15, 20, 30, 50};
    public static int[] orderGmtIntervelBucket = new int[]{1, 2, 3, 4, 5, 10, 60, 720, 1440, 10080};
    public static int[] orderActGmtIntervelBucket = new int[]{1, 2, 3, 4, 5, 10, 60, 720, 1440, 10080};
    public static double[] userCtrBucket = new double[]{0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    public static double[] userCvrBucket = new double[]{0.01, 0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    public static int[] cntBucket = new int[]{0, 1, 3, 5, 10, 15, 20};
    public static int[] ctrAndCvrLevelBucket = new int[]{1, 4, 8};
    public static double[] statCtrBucket = new double[]{0.001, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static double[] statCvrBucket = new double[]{0.001, 0.01, 0.02, 0.03, 0.04, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};

    public static Map<String, String> generateFeatureMapStatic(FeatureDo cf) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        try {
            if (cf != null) {
                cf.setCurrentGmtCreateTime(DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS));
                retMap.put("f108001", DataUtil.Long2String((Long)cf.getSlotId()));
                retMap.put("f109001", DataUtil.Long2String((Long)cf.getSlotType()));
                retMap.put("f201001", DataUtil.Long2String((Long)cf.getAppId()));
                retMap.put("f202001", cf.getAppCategory());
                retMap.put("f301001", DataUtil.Long2String((Long)cf.getOperatingActivityId()));
                retMap.put("f302001", DataUtil.Long2String((Long)cf.getActivityId()));
                retMap.put("f303001", DataUtil.Long2String((Long)cf.getActivityType()));
                retMap.put("f501001", cf.getUa());
                Integer hour = DateUtil.getHour((String)cf.getCurrentGmtCreateTime(), (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
                retMap.put("f502001", DataUtil.Integer2String((Integer)hour));
                Integer weekDay = DateUtil.getWeekNumber((String)cf.getCurrentGmtCreateTime(), (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
                retMap.put("f502002", DataUtil.Integer2String((Integer)weekDay));
                retMap.put("f503001", DataUtil.Long2String((Long)cf.getCityId()));
                retMap.put("f601001", DataUtil.Long2String((Long)FeatureParse.getDayRankLevel(cf.getDayOrderRank())));
                retMap.put("f602001", DataUtil.Long2String((Long)FeatureParse.getRankLevel(cf.getOrderRank())));
                retMap.put("f603001", DataUtil.Long2String((Long)FeatureParse.getDayRankLevel(cf.getDayActivityOrderRank())));
                retMap.put("f604001", DataUtil.Long2String((Long)FeatureParse.getRankLevel(cf.getActivityOrderRank())));
                Long orderGmtIntervelLevel = FeatureParse.getOrderGmtIntervelLevel(cf.getCurrentGmtCreateTime(), cf.getLastGmtCreateTime());
                retMap.put("f605001", DataUtil.Long2String((Long)orderGmtIntervelLevel));
                Long activityOrderGmtIntervelLevel = FeatureParse.getOrderGmtIntervelLevel(cf.getCurrentGmtCreateTime(), cf.getActivityLastGmtCreateTime());
                retMap.put("f606001", DataUtil.Long2String((Long)activityOrderGmtIntervelLevel));
                Long activityLastChargeStatus = FeatureParse.getChargeStatus(cf.getActivityLastChargeNums());
                retMap.put("f607001", DataUtil.Long2String((Long)activityLastChargeStatus));
                Long lastChargeStatus = FeatureParse.getChargeStatus(cf.getLastChargeNums());
                retMap.put("f608001", DataUtil.Long2String((Long)lastChargeStatus));
                Long activityChangeStatus = FeatureParse.getActivityChangeStatus(cf.getOperatingActivityId(), cf.getLastOperatingActivityId());
                retMap.put("f609001", DataUtil.Long2String((Long)activityChangeStatus));
                retMap.put("f504001", cf.getModel());
                retMap.put("f505001", cf.getPriceSection());
                retMap.put("f506001", cf.getConnectionType());
                retMap.put("f507001", cf.getOperatorType());
                retMap.put("f611001", DataUtil.Long2String((Long)cf.getPutIndex()));
                retMap.put("f306001", cf.getActivityUseType());
                retMap.put("f403001", cf.getMemberId());
                retMap.put("f403005", cf.getMobile());
                Long iso = FeatureParse.isOld(cf.getUserLastlogbigintime(), cf.getUserRegtime());
                retMap.put("f403004", DataUtil.Long2String((Long)iso));
                retMap.put("f114001", cf.getSlotIndustryTagPid());
                retMap.put("f114002", cf.getSlotIndustryTagId());
                retMap.put("f205001", cf.getAppIndustryTagPid());
                retMap.put("f205002", cf.getAppIndustryTagId());
                retMap.put("f206001", cf.getTrafficTagPid());
                retMap.put("f206002", cf.getTrafficTagId());
                retMap.put("f9902", cf.getAppList2());
                retMap.put("f9906", cf.getCategoryIdList1());
                retMap.put("f9907", cf.getCategoryIdList2());
                retMap.put("f9908", cf.getIsGame());
                retMap.put("f508001", cf.getPhoneBrand());
                retMap.put("f508002", cf.getPhoneModelNum());
                retMap.put("f9914", cf.getImportantApp());
                retMap.put("f9915", cf.getClusterId());
                retMap.put("f9916", FeatureParse.getLevel("launch_pv", cf.getUIIds(), cf.getUILaunchPV()));
                retMap.put("f9917", FeatureParse.getLevel("click_pv", cf.getUIIds(), cf.getUIClickPv()));
                retMap.put("f9918", FeatureParse.getLevel("effect_pv", cf.getUIIds(), cf.getUIEffectPv()));
                retMap.put("f9919", FeatureParse.getLevel("score", cf.getUIIds(), cf.getUIScore()));
                retMap.put("f9921", cf.getUICtr());
                retMap.put("f9922", cf.getUICvr());
                retMap.put("f9923", cf.getUUnICtr());
                retMap.put("f9924", cf.getUUnICvr());
                retMap.put("f9927", FeatureParse.countFeatures(cf.getUICtr()) + "");
                retMap.put("f9928", FeatureParse.countFeatures(cf.getUICvr()) + "");
                retMap.put("f9929", FeatureParse.countFeatures(cf.getUUnICtr()) + "");
                retMap.put("f9930", FeatureParse.countFeatures(cf.getUUnICvr()) + "");
                retMap.put("f404001", cf.getSex());
                retMap.put("f404002", cf.getAge());
                retMap.put("f404003", cf.getWorkStatus());
                retMap.put("f404004", cf.getStudentStatus());
                retMap.put("f404005", cf.getMarriageStatus());
                retMap.put("f404006", cf.getBear());
                retMap.put("f404007", cf.getInterestList());
                retMap.put("f601002", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getDayOrderRank(), dayOrderRankBucket)));
                retMap.put("f602002", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getOrderRank(), orderRankBucket)));
                retMap.put("f603002", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getDayActivityOrderRank(), dayActOrderRankBucket)));
                retMap.put("f604002", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getActivityOrderRank(), orderActRankBucket)));
                Long orderGmtIntervel = FeatureParse.getOrderGmtIntervel(cf.getCurrentGmtCreateTime(), cf.getLastGmtCreateTime());
                retMap.put("f605002", DataUtil.Long2String((Long)FeatureParse.bucket(orderGmtIntervel, orderGmtIntervelBucket)));
                Long activityOrderGmtIntervel = FeatureParse.getOrderGmtIntervel(cf.getCurrentGmtCreateTime(), cf.getActivityLastGmtCreateTime());
                retMap.put("f606002", DataUtil.Long2String((Long)FeatureParse.bucket(activityOrderGmtIntervel, orderActGmtIntervelBucket)));
                retMap.put("f9925", FeatureParse.categoryIdAndCnt(cf.getCategory1idCntList(), 1));
                retMap.put("f9926", FeatureParse.categoryIdAndCnt(cf.getCategory2idCntList(), 2));
                Map<String, Map<String, Long>> ubpMap = FeatureParse.getUserBehavioralPreference(cf.getUIIds(), cf.getUILaunchPV(), cf.getUIClickPv(), cf.getUIEffectPv());
                retMap.put("f809001", FeatureParse.getUserBehavioralPreference(0, "ctr", ubpMap, null));
                retMap.put("f809002", FeatureParse.getUserBehavioralPreference(0, "cvr", ubpMap, null));
                retMap.put("f808001", FeatureParse.getUserBehavioralPreference(2, "ctr", ubpMap, null));
                retMap.put("f808002", FeatureParse.getUserBehavioralPreference(2, "cvr", ubpMap, null));
                retMap.put("f811001", FeatureParse.getUserBehavioralPreference(3, "ctr", ubpMap, null));
                retMap.put("f811002", FeatureParse.getUserBehavioralPreference(3, "cvr", ubpMap, null));
                cf.setUbpMap(ubpMap);
                retMap.put("f406001", FeatureParse.getSlotAreaType(cf.getSlotHeight(), cf.getSlotWidth()));
                retMap.put("f406002", DataUtil.Long2String((Long)cf.getMediaTag1()));
                retMap.put("f406003", DataUtil.Long2String((Long)cf.getMediaTag2()));
                retMap.put("f9934", DataUtil.Long2String((Long)cf.getPerformance()));
                retMap.put("f9931", DataUtil.Long2String((Long)cf.getLaunchInfo()));
                retMap.put("f9932", DataUtil.Long2String((Long)cf.getBasicInfo()));
                retMap.put("f9933", DataUtil.Long2String((Long)cf.getTotalInfo()));
                retMap.put("f8801", DataUtil.Long2String((Long)cf.getCurrentDayLaunchIndex()));
                retMap.put("f8802", DataUtil.Long2String((Long)cf.getCurrentDayLaunchBatch()));
                retMap.put("f8803", DataUtil.Long2String((Long)cf.getAlgStartPosition()));
                retMap.put("f8804", DataUtil.Long2String((Long)cf.getDayLastLaunchIndexAdLaunchCnt()));
                retMap.put("f8805", DataUtil.Long2String((Long)cf.getDayLaunchIndexAdExportCnt()));
                retMap.put("f8806", DataUtil.Long2String((Long)cf.getDayLaunchIndexAdClickCnt()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(FeatureDo cf, FeatureDo staticCf) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        try {
            if (cf != null) {
                retMap.put("f101001", DataUtil.Long2String((Long)cf.getAdvertId()));
                retMap.put("f106001", DataUtil.Long2String((Long)cf.getAccountId()));
                retMap.put("f111001", cf.getPromoteUrl());
                retMap.put("f102001", cf.getMatchTagNums());
                retMap.put("f801001", cf.getGoodsId());
                retMap.put("f802001", cf.getCatId());
                retMap.put("f802002", cf.getBrandId());
                retMap.put("f803001", DataUtil.Long2String((Long)FeatureParse.getCost(cf.getCost(), cf.getPrice())));
                retMap.put("f803002", DataUtil.Long2String((Long)FeatureParse.getLog(cf.getPrice())));
                retMap.put("f803003", DataUtil.Long2String((Long)FeatureParse.getCost(cf.getViewCount(), cf.getBuyCount())));
                retMap.put("f803004", DataUtil.Long2String((Long)FeatureParse.getLog(cf.getBuyCount())));
                retMap.put("f110001", DataUtil.Long2String((Long)cf.getTimes()));
                Long tagChangeStatus = FeatureParse.getLastTagChangeStatus(cf.getMatchTagNums(), cf.getDayLastMatchTagNums());
                retMap.put("f610001", DataUtil.Long2String((Long)tagChangeStatus));
                retMap.put("f104001", cf.getMaterialId());
                retMap.put("f112001", cf.getMaterialTags());
                retMap.put("f113001", cf.getAdvertTags());
                retMap.put("f804001", DataUtil.Long2String((Long)FeatureParse.getCtrIntervelLevel(cf.getAdvertCtr())));
                retMap.put("f804002", DataUtil.Long2String((Long)FeatureParse.getCvrIntervelLevel(cf.getAdvertCvr())));
                retMap.put("f805001", DataUtil.Long2String((Long)FeatureParse.getCtrIntervelLevel(cf.getAdvertAppCtr())));
                retMap.put("f805002", DataUtil.Long2String((Long)FeatureParse.getCvrIntervelLevel(cf.getAdvertAppCvr())));
                retMap.put("f806001", DataUtil.Long2String((Long)FeatureParse.getCtrIntervelLevel(cf.getAdvertSlotCtr())));
                retMap.put("f806002", DataUtil.Long2String((Long)FeatureParse.getCvrIntervelLevel(cf.getAdvertSlotCvr())));
                retMap.put("f807001", DataUtil.Long2String((Long)FeatureParse.getCtrIntervelLevel(cf.getAdvertActivityCtr())));
                retMap.put("f807002", DataUtil.Long2String((Long)FeatureParse.getCvrIntervelLevel(cf.getAdvertActivityCvr())));
                retMap.put("f804003", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getAdvertCtr(), statCtrBucket)));
                retMap.put("f804004", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getAdvertCvr(), statCvrBucket)));
                retMap.put("f805003", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getAdvertAppCtr(), statCtrBucket)));
                retMap.put("f805004", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getAdvertAppCvr(), statCvrBucket)));
                retMap.put("f806003", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getAdvertSlotCtr(), statCtrBucket)));
                retMap.put("f806004", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getAdvertSlotCvr(), statCvrBucket)));
                retMap.put("f807003", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getAdvertActivityCtr(), statCtrBucket)));
                retMap.put("f807004", DataUtil.Long2String((Long)FeatureParse.bucket(cf.getAdvertActivityCvr(), statCvrBucket)));
                retMap.put("f9912", cf.getTradeId());
                retMap.put("f9913", cf.getTradeId2());
                Map<String, Map<String, Long>> ubpMap = staticCf.getUbpMap();
                retMap.put("f810001", FeatureParse.getUserBehavioralPreference(1, "ctr", ubpMap, cf.getMatchTagNums()));
                retMap.put("f810002", FeatureParse.getUserBehavioralPreference(1, "cvr", ubpMap, cf.getMatchTagNums()));
                retMap.put("f115001", cf.getBankEndType());
                retMap.put("f121001", cf.getAtmosphere());
                retMap.put("f121002", cf.getBackgroundColour());
                retMap.put("f121003", cf.getIfPrevalent());
                retMap.put("f121004", cf.getDescribeKeywords());
                retMap.put("f121005", cf.getDynamicEffect());
                retMap.put("f121006", cf.getBodyElement());
                retMap.put("f8807", DataUtil.Long2String((Long)cf.getBatchIndex()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retMap;
    }

    public static Long getCtrIntervelLevel(Double ctr) {
        Long ret = null;
        ret = ctr == null ? Long.valueOf(-1L) : (ctr <= 0.999 ? Long.valueOf(Math.round(ctr * 100.0 / 3.0)) : Long.valueOf(-1L));
        return ret;
    }

    public static Long getCvrIntervelLevel(Double cvr) {
        Long ret = null;
        ret = cvr == null ? Long.valueOf(-1L) : (cvr <= 0.04 ? Long.valueOf(Math.round(cvr * 1000.0 / 4.0)) : (cvr <= 0.999 ? Long.valueOf(11L + Math.round((cvr - 0.04) * 100.0 / 3.0)) : Long.valueOf(-1L)));
        return ret;
    }

    public static Long getOrderGmtIntervel(String date, String otherDate) {
        Long ret = null;
        Integer minutes = DateUtil.getIntervalMinutes((String)date, (String)otherDate, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
        if (minutes != null) {
            ret = (long)minutes.intValue() + 0L;
        }
        return ret;
    }

    public static Long getOrderGmtIntervelLevel(String date, String otherDate) {
        Long ret = null;
        Integer minutes = DateUtil.getIntervalMinutes((String)date, (String)otherDate, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS, (DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
        ret = minutes == null ? Long.valueOf(-1L) : (minutes <= 5 ? Long.valueOf(1L) : (minutes <= 10 ? Long.valueOf(2L) : (minutes <= 30 ? Long.valueOf(3L) : (minutes <= 60 ? Long.valueOf(4L) : Long.valueOf(99L)))));
        return ret;
    }

    public static Long getDayRankLevel(Long rank) {
        Long ret = null;
        ret = rank == null ? null : (rank <= 7L ? rank : Long.valueOf(-1L));
        return ret;
    }

    public static Long getRankLevel(Long rank) {
        Long ret = null;
        ret = rank == null ? null : (rank <= 15L ? rank : Long.valueOf(-1L));
        return ret;
    }

    public static Long getChargeStatus(Long chargeNums) {
        Long ret = null;
        ret = chargeNums == null || chargeNums < 1L ? Long.valueOf(0L) : Long.valueOf(1L);
        return ret;
    }

    public static Long getActivityChangeStatus(Long operatingActivityId, Long lastOperatingActivityId) {
        Long ret = null;
        ret = operatingActivityId == null || lastOperatingActivityId == null ? Long.valueOf(0L) : (operatingActivityId.equals(lastOperatingActivityId) ? Long.valueOf(1L) : Long.valueOf(0L));
        return ret;
    }

    public static Long getLastTagChangeStatus(String matchTagNums, String lastMatchTagNums) {
        Long ret = null;
        ret = matchTagNums == null || lastMatchTagNums == null ? Long.valueOf(0L) : (matchTagNums.equals(lastMatchTagNums) ? Long.valueOf(1L) : Long.valueOf(0L));
        return ret;
    }

    public static Long isOld(Date userLastlogbigintime, Date userRegtime) {
        Long ret = 0L;
        Integer dayIntervals = DateUtil.getIntervalDays((Date)userLastlogbigintime, (Date)userRegtime);
        if (dayIntervals != null) {
            ret = dayIntervals > 1 ? 1L : 0L;
        }
        return ret;
    }

    public static Long getCost(Long cost, Long price) {
        Long ret = null;
        if (cost != null && price != null && cost > 0L) {
            ret = new Double(Math.ceil(((double)price.longValue() + 1.0E-6) / (double)cost.longValue())).intValue();
        }
        return ret;
    }

    public static Long getLog(Long lvalue) {
        Long ret = null;
        if (lvalue != null && lvalue > 0L) {
            ret = new Double(Math.ceil(FeatureParse.log(lvalue.doubleValue(), 2 / 0))).intValue();
        }
        return ret;
    }

    public static String getLevel(String key, String idlist, String valueList) {
        String[] valueArr;
        String s = "";
        if (idlist == null || valueList == null || idlist.isEmpty() || valueList.isEmpty()) {
            return null;
        }
        String[] idArr = idlist.split(",");
        if (idArr.length != (valueArr = valueList.split(",")).length) {
            return null;
        }
        for (int i = 0; i < idArr.length; ++i) {
            double value = 0.0;
            try {
                value = Double.parseDouble(valueArr[i]);
            }
            catch (NumberFormatException e) {
                continue;
            }
            catch (NullPointerException e) {
                continue;
            }
            s = s + idArr[i] + "&" + String.valueOf(FeatureParse.discretization(key, value)) + ",";
        }
        if (!s.isEmpty()) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static int discretization(String key, double value) {
        int class_id = 0;
        switch (key) {
            case "launch_pv": {
                if (value > -1.0E8 & value <= 0.0) {
                    class_id = 1;
                    break;
                }
                if (value > 0.0 & value <= 1.0) {
                    class_id = 2;
                    break;
                }
                if (value > 1.0 & value <= 2.0) {
                    class_id = 3;
                    break;
                }
                if (value > 2.0 & value <= 3.0) {
                    class_id = 4;
                    break;
                }
                if (value > 3.0 & value <= 4.0) {
                    class_id = 5;
                    break;
                }
                if (value > 4.0 & value <= 5.0) {
                    class_id = 6;
                    break;
                }
                if (value > 5.0 & value <= 6.0) {
                    class_id = 7;
                    break;
                }
                if (value > 6.0 & value <= 7.0) {
                    class_id = 8;
                    break;
                }
                if (value > 7.0 & value <= 18.0) {
                    class_id = 9;
                    break;
                }
                if (value > 18.0 & value <= 50.0) {
                    class_id = 10;
                    break;
                }
                if (value > 50.0 & value <= 150.0) {
                    class_id = 11;
                    break;
                }
                if (value > 150.0 & value <= 300.0) {
                    class_id = 12;
                    break;
                }
                class_id = 13;
                break;
            }
            case "click_pv": {
                if (value > -1.0E8 & value <= 0.0) {
                    class_id = 1;
                    break;
                }
                if (value > 0.0 & value <= 1.0) {
                    class_id = 2;
                    break;
                }
                if (value > 2.0 & value <= 3.0) {
                    class_id = 3;
                    break;
                }
                if (value > 3.0 & value <= 4.0) {
                    class_id = 4;
                    break;
                }
                if (value > 4.0 & value <= 5.0) {
                    class_id = 5;
                    break;
                }
                if (value > 5.0 & value <= 6.0) {
                    class_id = 6;
                    break;
                }
                if (value > 6.0 & value <= 8.0) {
                    class_id = 7;
                    break;
                }
                if (value > 8.0 & value <= 15.0) {
                    class_id = 8;
                    break;
                }
                if (value > 15.0 & value <= 80.0) {
                    class_id = 9;
                    break;
                }
                if (value > 80.0 & value <= 225.0) {
                    class_id = 10;
                    break;
                }
                class_id = 11;
                break;
            }
            case "effect_pv": {
                if (value > -1.0E8 & value <= 0.0) {
                    class_id = 1;
                    break;
                }
                if (value > 0.0 & value <= 1.0) {
                    class_id = 2;
                    break;
                }
                if (value > 1.0 & value <= 2.0) {
                    class_id = 3;
                    break;
                }
                if (value > 2.0 & value <= 3.0) {
                    class_id = 4;
                    break;
                }
                if (value > 4.0 & value <= 15.0) {
                    class_id = 5;
                    break;
                }
                if (value > 15.0 & value <= 25.0) {
                    class_id = 6;
                    break;
                }
                if (value > 25.0 & value <= 70.0) {
                    class_id = 7;
                    break;
                }
                if (value > 70.0 & value <= 150.0) {
                    class_id = 8;
                    break;
                }
                if (value > 150.0 & value <= 225.0) {
                    class_id = 9;
                    break;
                }
                class_id = 10;
                break;
            }
            case "score": {
                class_id = value > -1.0E8 & value <= -471.0 ? 1 : (value > -471.0 & value <= -331.0 ? 2 : (value > -331.0 & value <= -168.0 ? 3 : (value > -168.0 & value <= -52.0 ? 4 : (value > -52.0 & value <= -19.0 ? 5 : (value > -19.0 & value <= -8.0 ? 6 : (value > -8.0 & value <= -4.0 ? 7 : (value > -4.0 & value <= 1.0 ? 8 : (value > 1.0 & value <= 2.0 ? 9 : (value > 2.0 & value <= 17.0 ? 10 : (value > 17.0 & value <= 42.0 ? 11 : (value > 42.0 & value <= 73.0 ? 12 : (value > 73.0 & value <= 126.0 ? 13 : (value > 126.0 & value <= 284.0 ? 14 : 15)))))))))))));
            }
        }
        return class_id;
    }

    public static String getUserBehavioralPreference(int dimType, String statType, Map<String, Map<String, Long>> ubpMap, String tags) {
        String ret = null;
        try {
            Object tag;
            if (dimType == 0 && ubpMap != null) {
                ret = DataUtil.Long2String((Long)ubpMap.get(statType).get("0"));
            }
            if (dimType == 1 && ubpMap != null && (tag = FeatureParse.getTag(tags)) != null) {
                ret = ubpMap.get(statType).get(tag) + "";
                if (((String)tag).length() == 10 && ret == null) {
                    String string = ((String)tag).substring(0, 5);
                    ret = DataUtil.Long2String((Long)ubpMap.get(statType).get(string));
                }
            }
            if (dimType == 2 && AssertUtil.isNotEmpty(ubpMap.get(statType))) {
                ret = "";
                for (Map.Entry entry : ubpMap.get(statType).entrySet()) {
                    String string = (String)entry.getKey() + "_" + entry.getValue() + ",";
                    ret = ret + string;
                }
                if (ret.endsWith(",")) {
                    ret = ret.substring(0, ret.length() - 1);
                }
            }
            if (dimType == 3 && AssertUtil.isNotEmpty(ubpMap.get(statType))) {
                ret = "";
                HashMap<Long, Long> levelCntMap = new HashMap<Long, Long>();
                for (Map.Entry<String, Long> entry : ubpMap.get(statType).entrySet()) {
                    String tag2 = entry.getKey();
                    Long ctrLevel = FeatureParse.bucket(entry.getValue(), ctrAndCvrLevelBucket);
                    if (ctrLevel == null || tag2 == "0") continue;
                    if (!levelCntMap.containsKey(ctrLevel)) {
                        levelCntMap.put(ctrLevel, 0L);
                    }
                    levelCntMap.put(ctrLevel, (Long)levelCntMap.get(ctrLevel) + 1L);
                }
                for (Map.Entry entry : levelCntMap.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    Long cntLevel = FeatureParse.bucket((Long)entry.getValue(), cntBucket);
                    String v = (Long)entry.getKey() * 100L + cntLevel + ",";
                    ret = ret + v;
                }
                if (ret.endsWith(",")) {
                    ret = ret.substring(0, ret.length() - 1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String getTag(String tags) {
        Object[] tagArr;
        String ret = null;
        if (AssertUtil.isNotEmpty((String)tags) && AssertUtil.isNotEmpty((Object[])(tagArr = tags.split(",")))) {
            for (int i = 0; i < tagArr.length; ++i) {
                String tmp = FeatureParse.validTag((String)tagArr[i]);
                if (tmp == null) continue;
                ret = FeatureParse.validTag((String)tagArr[i]);
            }
        }
        return ret;
    }

    public static String validTag(String tag) {
        String ret = null;
        if (AssertUtil.isNotEmpty((String)tag) && tag.contains(".")) {
            ret = tag;
        }
        return ret;
    }

    public static Map<String, Map<String, Long>> getUserBehavioralPreference(String uIIds, String uILaunchPv, String uIClickPv, String uIEffectPv) {
        HashMap<String, Map<String, Long>> ret = new HashMap<String, Map<String, Long>>();
        ret.put("ctr", new HashMap());
        ret.put("cvr", new HashMap());
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{uIIds, uILaunchPv, uIClickPv, uIEffectPv})) {
            String[] uIIdsArr = uIIds.split(",");
            String[] uILaunchPvArr = uILaunchPv.split(",");
            String[] uIClickPvArr = uIClickPv.split(",");
            String[] uIEffectPvArr = uIEffectPv.split(",");
            if (uIIdsArr.length > 0 && uIIdsArr.length == uILaunchPvArr.length && uIIdsArr.length == uIClickPvArr.length && uIIdsArr.length == uIEffectPvArr.length) {
                Long launchAccPv = 0L;
                Long clickAccPv = 0L;
                Long effectAccPv = 0L;
                for (int i = 0; i < uIIdsArr.length; ++i) {
                    String id = uIIdsArr[i];
                    Long launchPv = DataUtil.str2Long((String)uILaunchPvArr[i], (Long)0L);
                    Long clickPv = DataUtil.str2Long((String)uIClickPvArr[i], (Long)0L);
                    Long effectPv = DataUtil.str2Long((String)uIEffectPvArr[i], (Long)0L);
                    Double ctr = FeatureParse.getCtrOrCvr(launchPv, clickPv);
                    Double cvr = FeatureParse.getCtrOrCvr(clickPv, effectPv);
                    Long ctrBucketLevel = FeatureParse.bucket(ctr, userCtrBucket);
                    Long cvrBucketLevel = FeatureParse.bucket(cvr, userCvrBucket);
                    ((Map)ret.get("ctr")).put(id, ctrBucketLevel);
                    ((Map)ret.get("cvr")).put(id, cvrBucketLevel);
                    launchAccPv = launchAccPv + launchPv;
                    clickAccPv = clickAccPv + clickPv;
                    effectAccPv = effectAccPv + effectPv;
                }
                Double ctr = FeatureParse.getCtrOrCvr(launchAccPv, clickAccPv);
                Double cvr = FeatureParse.getCtrOrCvr(clickAccPv, effectAccPv);
                Long ctrBucketLevel = FeatureParse.bucket(ctr, userCtrBucket);
                Long cvrBucketLevel = FeatureParse.bucket(cvr, userCvrBucket);
                ((Map)ret.get("ctr")).put("0", ctrBucketLevel);
                ((Map)ret.get("cvr")).put("0", cvrBucketLevel);
            }
        }
        return ret;
    }

    public static Double getCtrOrCvr(Long firstPv, Long secondPv) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{firstPv, secondPv}) && firstPv > 0L) {
            ret = DataUtil.division((Long)secondPv, (Long)firstPv);
        }
        return ret;
    }

    public static Long bucket(Long value, int[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                int bound = bucketList[i];
                if (value > (long)bound) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static Long bucket(Double value, double[] bucketList) {
        long ret = 0L;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i];
                if (!(value <= bound)) continue;
                ret = i + 1;
                break;
            }
        }
        return ret;
    }

    public static double log(double value, double base) {
        return Math.log(value) / Math.log(base);
    }

    public static String getSlotAreaType(Integer slotLength, Integer slotWidth) {
        int ret1 = 12;
        if (slotLength == null || slotWidth == null) {
            return String.valueOf(ret1);
        }
        try {
            Integer area = slotLength * slotWidth;
            if (area >= 0 && area <= 500000) {
                ret1 = area / 50000;
            }
            if (area > 500000 && area != null) {
                ret1 = 11;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return String.valueOf(ret1);
    }

    public static String categoryIdAndCnt(Map<String, Long> categoryCount, Integer categoryType) {
        String ret1 = null;
        if (categoryCount == null) {
            return ret1;
        }
        if (categoryType == 1) {
            for (Map.Entry<String, Long> entry : categoryCount.entrySet()) {
                String key = entry.getKey();
                try {
                    Long value = entry.getValue();
                    String valueRet = null;
                    valueRet = value >= 1L && value <= 3L ? "g1" : (value >= 4L && value <= 10L ? "g2" : (value >= 11L && value <= 20L ? "g3" : "g4"));
                    String ret = key + "&" + valueRet;
                    ret1 = ret1 + "," + ret;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            for (Map.Entry<String, Long> entry : categoryCount.entrySet()) {
                String key = entry.getKey();
                try {
                    Long value = entry.getValue();
                    String valueRet = null;
                    valueRet = value == 1L ? "g1" : (value == 2L || value == 3L ? "g2" : (value >= 4L && value <= 8L ? "g3" : "g4"));
                    String ret = key + "&" + valueRet;
                    ret1 = ret1 + "," + ret;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return ret1;
    }

    public static void main(String[] args) {
        FeatureDo featureDo = new FeatureDo();
        featureDo.setUIIds("02.01.0001,02.01.0002,02.01.0003,02.23.0001");
        featureDo.setUILaunchPV("10,9,9,3,");
        featureDo.setUIClickPv("1,1,1,1,");
        featureDo.setUIEffectPv("0,0,0,0,");
        FeatureDo featureDo2 = new FeatureDo();
        featureDo2.setMatchTagNums("05.01.0005,02.01.0001");
        featureDo.setActivityLastGmtCreateTime("2018-05-18 16:12:24");
        Map<Object, Object> staticMap = new HashMap();
        staticMap = FeatureParse.generateFeatureMapStatic(featureDo);
        System.out.println("staticMap=" + JSON.toJSONString(staticMap));
        Map<Object, Object> dynamicMap = new HashMap();
        dynamicMap = FeatureParse.generateFeatureMapDynamic(featureDo2, featureDo);
        dynamicMap.putAll(staticMap);
        System.out.println("dynamicMap=" + JSON.toJSONString(dynamicMap));
    }

    public static int countFeatures(String valueList) {
        if (valueList == null) {
            return -1;
        }
        if (valueList.isEmpty()) {
            return 0;
        }
        String[] idArr = valueList.split(",");
        if (idArr == null) {
            return -1;
        }
        return idArr.length;
    }
}

