/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.coder;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.coder.FeatureCoderBase;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.CodeResult;
import cn.com.duiba.nezha.alg.feature.vo.CoderFeature;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureNewCoder
extends FeatureCoderBase {
    private static final Logger logger = LoggerFactory.getLogger(FeatureNewCoder.class);
    private static int F_MAX_SIZE = 128;
    public static Map tmpMap = new HashMap();

    public static <T> Map<T, CodeResult> code(List<FeatureBaseType> list, Map<T, FeatureMapDo> sampleMap) throws Exception {
        HashMap<T, CodeResult> ret = new HashMap<T, CodeResult>();
        HashMap<String, Map<String, CoderFeature>> tmpCoderCache = new HashMap<String, Map<String, CoderFeature>>();
        if (AssertUtil.isNotEmpty(sampleMap)) {
            for (Map.Entry<T, FeatureMapDo> entry : sampleMap.entrySet()) {
                CodeResult subRet;
                T key = entry.getKey();
                FeatureMapDo featureMapDo = entry.getValue();
                if (featureMapDo == null || (subRet = FeatureNewCoder.code(list, featureMapDo.getStaticFeatureMap(), featureMapDo.getDynamicFeatureMap(), tmpCoderCache)) == null) continue;
                ret.put(key, subRet);
            }
        }
        return ret;
    }

    public static <T> Map<T, CodeResult> codeOfEachField(List<FeatureBaseType> list, Map<T, FeatureMapDo> sampleMap) throws Exception {
        HashMap<T, CodeResult> ret = new HashMap<T, CodeResult>();
        HashMap<String, Map<String, Set<Integer>>> tmpCoderCache = new HashMap<String, Map<String, Set<Integer>>>();
        if (AssertUtil.isNotEmpty(sampleMap)) {
            for (Map.Entry<T, FeatureMapDo> entry : sampleMap.entrySet()) {
                CodeResult subRet;
                T key = entry.getKey();
                FeatureMapDo featureMapDo = entry.getValue();
                if (featureMapDo == null || (subRet = FeatureNewCoder.codeOfEachField(list, featureMapDo.getStaticFeatureMap(), featureMapDo.getDynamicFeatureMap(), tmpCoderCache)) == null) continue;
                ret.put(key, subRet);
            }
        }
        return ret;
    }

    public static CodeResult code(List<FeatureBaseType> list, Map<String, String> staticFeatureMap, Map<String, String> dynamicFeatureMap, Map<String, Map<String, CoderFeature>> tmpCoderCache) throws Exception {
        CodeResult codeResult = new CodeResult();
        if (staticFeatureMap == null) {
            staticFeatureMap = tmpMap;
        }
        if (dynamicFeatureMap == null) {
            dynamicFeatureMap = tmpMap;
        }
        ArrayList<Integer> indices = new ArrayList<Integer>(F_MAX_SIZE);
        ArrayList<Double> values = new ArrayList<Double>(F_MAX_SIZE);
        ArrayList<String> fields = new ArrayList<String>(F_MAX_SIZE);
        ArrayList<Set<Integer>> ret = new ArrayList<Set<Integer>>(F_MAX_SIZE);
        int startIndex = 0;
        for (int i = 0; i < list.size(); ++i) {
            String fieldValue;
            FeatureBaseType featureBaseType = list.get(i);
            String fieldName = featureBaseType.getName();
            String string = fieldValue = dynamicFeatureMap.get(fieldName) == null ? (String)staticFeatureMap.get(fieldName) : (String)dynamicFeatureMap.get(fieldName);
            if (tmpCoderCache.get(fieldName) == null) {
                tmpCoderCache.put(fieldName, new HashMap());
            }
            if (tmpCoderCache.get(fieldName).get(fieldValue) == null) {
                CoderFeature retTmp = featureBaseType.codeNew(fieldValue, startIndex);
                tmpCoderCache.get(fieldName).put(fieldValue, retTmp);
            }
            CoderFeature retSub = tmpCoderCache.get(fieldName).get(fieldValue);
            indices.addAll(retSub.indices);
            values.addAll(retSub.values);
            fields.addAll(retSub.fields);
            ret.add(retSub.fieldsSet);
            startIndex = retSub.getEndIndex();
        }
        codeResult.setFeature(FeatureCoderBase.toFeatureNew(startIndex, indices, values, fields));
        codeResult.setFeatureSet(ret);
        return codeResult;
    }

    public static CodeResult codeOfEachField(List<FeatureBaseType> list, Map<String, String> staticFeatureMap, Map<String, String> dynamicFeatureMap, Map<String, Map<String, Set<Integer>>> tmpCoderCache) throws Exception {
        CodeResult codeResult = new CodeResult();
        ArrayList<Integer> indices = new ArrayList<Integer>(F_MAX_SIZE);
        ArrayList<Double> values = new ArrayList<Double>(F_MAX_SIZE);
        ArrayList<String> fields = new ArrayList<String>(F_MAX_SIZE);
        ArrayList<Set<Integer>> ret = new ArrayList<Set<Integer>>(F_MAX_SIZE);
        if (staticFeatureMap == null) {
            staticFeatureMap = tmpMap;
        }
        if (dynamicFeatureMap == null) {
            dynamicFeatureMap = tmpMap;
        }
        HashMap<String, Map<Integer, Double>> fieldFeatureMap = new HashMap<String, Map<Integer, Double>>();
        for (FeatureBaseType featureBaseType : list) {
            String value;
            String fieldName = featureBaseType.getName();
            String string = value = dynamicFeatureMap.get(fieldName) == null ? (String)staticFeatureMap.get(fieldName) : (String)dynamicFeatureMap.get(fieldName);
            if (tmpCoderCache.get(fieldName) == null) {
                tmpCoderCache.put(fieldName, new HashMap());
            }
            if (tmpCoderCache.get(fieldName).get(value) == null) {
                Set<Integer> retTmp = featureBaseType.code(value);
                tmpCoderCache.get(fieldName).put(value, retTmp);
            }
            Set<Integer> retSub = tmpCoderCache.get(fieldName).get(value);
            ret.add(retSub);
            ArrayList<Integer> retSubList = new ArrayList<Integer>(retSub);
            HashMap subFieldFeatureMap = new HashMap();
            double weight = MathUtil.reciprocalOfN((Integer)retSub.size());
            for (int i = 0; i < retSub.size(); ++i) {
                indices.add((Integer)retSubList.get(i));
                values.add(weight);
                fields.add(featureBaseType.getName());
                subFieldFeatureMap.put(retSubList.get(i), weight);
            }
            fieldFeatureMap.put(featureBaseType.getName(), subFieldFeatureMap);
        }
        codeResult.setFeature(FeatureCoderBase.toFeature(indices, values, fields, 10000000));
        codeResult.setFeatureSet(ret);
        codeResult.setFieldFeatureMap(fieldFeatureMap);
        return codeResult;
    }

    public static Map<String, Set<String>> getFeatures(List<FeatureBaseType> list, Map<String, String> featureMap) throws Exception {
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
        for (FeatureBaseType featureBaseType : list) {
            String value = featureMap.get(featureBaseType.getName());
            Set<String> retSub = featureBaseType.parseFeatureValues(value);
            ret.put(featureBaseType.getName(), retSub);
        }
        return ret;
    }

    public static void main(String[] args) {
        HashMap<String, String> featureMap = new HashMap<String, String>();
        featureMap.put("f101001", "16601,18491,23105,24732,7967,300");
        featureMap.put("f101002", "100");
        featureMap.put("f305001", "8");
        featureMap.put("f501001", "UNKONWN");
        featureMap.put(null, "2");
        FeatureBaseType featureBaseType1 = new FeatureBaseType();
        featureBaseType1.setCodeType(11);
        featureBaseType1.setName("f101001");
        featureBaseType1.setDenseLen(10000);
        featureBaseType1.setSubLen(1000000);
        featureBaseType1.setHashNums(1);
        featureBaseType1.setSeq(",");
        FeatureBaseType featureBaseType2 = new FeatureBaseType();
        featureBaseType2.setCodeType(21);
        featureBaseType2.setName("f101002");
        featureBaseType2.setDenseLen(10000);
        featureBaseType2.setSubLen(100000);
        featureBaseType2.setHashNums(1);
        featureBaseType2.setSeq(",");
        List<FeatureBaseType> list = Arrays.asList(featureBaseType1, featureBaseType2);
        System.out.println(JSON.toJSONString(featureMap));
        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(featureMap);
        HashMap<String, FeatureMapDo> featureMapDoMap = new HashMap<String, FeatureMapDo>();
        featureMapDoMap.put("000", featureMapDo);
        try {
            System.out.println(JSON.toJSONString(FeatureNewCoder.codeOfEachField(list, featureMapDoMap)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

