package cn.com.duiba.nezha.alg.feature.vo;

import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;

import java.io.Serializable;

public class FeatureCode implements Serializable {

    public String featureStr;//字符串值

    public int size; //特征数量

    public int[] indices; // 编码ID


    public double[] values; //编码ID对应权重，默认0.0


    public FeatureCode(String featureStr, int size, int[] indices, double[] values) throws Exception {

        if (size <= 0) {
            throw new Exception("size<=0,input invalid");
        }
        if (indices == null || values == null) {
            throw new Exception("indices or values  or fields is null,input invalid");
        }

        if (indices.length != values.length) {
            throw new Exception("indices.length != values.length,input invalid");
        }
        this.featureStr = featureStr;
        this.size = size;
        this.indices = indices;
        this.values = values;

    }

    public FeatureCode(String featureStr, int[] indices) throws Exception {

        if (indices == null) {
            throw new Exception("indices or values  or fields is null,input invalid");
        }

        this.featureStr = featureStr;
        this.size = indices.length;
        this.indices = indices;
        double[] values = new double[indices.length];

        this.values = values;

    }

    public FeatureCode(String featureStr, double[] values) throws Exception {

        this.featureStr = featureStr;
        this.size = values.length;

        this.values = values;

        int[] indices = new int[values.length];

        for (int i = 0; i < size; i++) {
            indices[i] = i;
        }

        this.indices = indices;

    }


    public FeatureCode(String featureStr, int id) throws Exception {

        int[] indices = new int[1];
        double[] values = new double[1];
        indices[0] = id;
        values[0] = 1.0;

        this.featureStr = featureStr;
        this.size = 1;
        this.indices = indices;
        this.values = values;

    }


}
