package cn.com.duiba.nezha.alg.feature.type;

import cn.com.duiba.nezha.alg.feature.coder.FeatureCoderBase;

import java.util.List;
import java.util.Map;
import java.util.Set;

public class FeatureIdType extends FeatureBaseType {


    public FeatureIdType(String name, int subLen, String seq) {
        setName(name);
        setSubLen(subLen);
        setSeq(seq);
    }

    @Override
    public Set<Integer> code(String featureValue, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        Set<Integer> ret = null;

        if (this.seq == null) {
            ret = FeatureCoderBase.getSubId(this.name, featureValue, this.subLen, pLenList, indices, values);
        } else {
            ret = FeatureCoderBase.getSubIds(this.name, featureValue, this.seq, this.subLen, pLenList, indices, values);
        }
        return ret;
    }


}
