/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.vo.RtaFeatureDo;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtaFeatureParse {
    public static final int F_MAX_SIZE = 64;
    private static final Logger logger = LoggerFactory.getLogger(RtaFeatureParse.class);

    public static Map<String, String> generateFeatureMapStatic(RtaFeatureDo cf) {
        HashMap<String, String> retMap = new HashMap<String, String>(64);
        try {
            if (cf != null) {
                retMap.put("f00001", cf.getGender());
                retMap.put("f00002", cf.getAge());
                retMap.put("f00003", cf.getMarital());
                retMap.put("f00004", cf.getIsp());
                retMap.put("f00005", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserExpPv())));
                retMap.put("f00006", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserActReqPv())));
                retMap.put("f00007", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserAdvLaunchPv())));
                retMap.put("f00008", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserAdvClkPv())));
                retMap.put("f00009", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserReqPv1d())));
                retMap.put("f00010", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserExpPv1d())));
                retMap.put("f00011", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserActReqPv1d())));
                retMap.put("f00012", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserAdvLaunchPv1d())));
                retMap.put("f00013", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserAdvClkPv1d())));
                retMap.put("f00014", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserReqPv7d())));
                retMap.put("f00015", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserExpPv7d())));
                retMap.put("f00016", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserActReqPv7d())));
                retMap.put("f00017", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserAdvLaunchPv7d())));
                retMap.put("f00018", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserAdvClkPv7d())));
                retMap.put("f00019", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserReqPv14d())));
                retMap.put("f00020", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserExpPv14d())));
                retMap.put("f00021", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserActReqPv14d())));
                retMap.put("f00022", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserAdvLaunchPv14d())));
                retMap.put("f00023", DataUtil.Long2String((Long)MathUtil.log1p((Long)cf.getUserAdvClkPv14d())));
                retMap.put("f00024", DataUtil.listToString(cf.getUser_exp_list()));
                retMap.put("f00025", DataUtil.listToString(cf.getUser_clk_list()));
                retMap.put("f00026", DataUtil.listToString(cf.getUser_act_req_list()));
                retMap.put("f00027", DataUtil.listToString(cf.getUser_act_join_list()));
                retMap.put("f00028", DataUtil.listToString(cf.getUser_adv_launch_list()));
                retMap.put("f00029", DataUtil.listToString(cf.getUser_adv_clk_list()));
                retMap.put("f00030", DataUtil.listToString(cf.getUser_adv_launch_trade_list()));
                retMap.put("f00031", DataUtil.listToString(cf.getUser_adv_clk_trade_list()));
            }
        }
        catch (Exception e) {
            logger.error("RtaFeatureParse.generateFeatureMapStatic error:", (Throwable)e);
        }
        return retMap;
    }
}

