package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.vo.RtaFeatureDo;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by pzx on 2022/1/13.
 */
public class RtaFeatureParse {
    public static final int F_MAX_SIZE = 64;
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(RtaFeatureParse.class);

    public static Map<String, String> generateFeatureMapStatic(RtaFeatureDo cf) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        try {
            if (cf != null) {

                // 上下文特征
                String currentTimeMillis = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                Integer hour = LocalDateUtil.getHour(currentTimeMillis, DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                Integer weekDay = LocalDateUtil.getDayOfWeek(currentTimeMillis, DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                Integer dayOfMonth = LocalDateUtil.getDayOfMonthSafely(currentTimeMillis, DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                retMap.put("f0001", DataUtil.Integer2String(hour));            // 请求时间 hour（时段）
                retMap.put("f0002", DataUtil.Integer2String(weekDay));         // 请求时间 weekday（周几）
                retMap.put("f0003", DataUtil.Integer2String(dayOfMonth));      // 请求时间 day（几号）

                // DMP特征
                retMap.put("f0101", cf.getGender()); // 性别
                retMap.put("f0102", cf.getAge()); // 年龄
                retMap.put("f0103", cf.getMarital()); // 婚育情况
                retMap.put("f0104", cf.getIsp()); // 运营商（联通/移动/电信等）

                // 实时用户统计特征
                retMap.put("f0201", DataUtil.Long2String(MathUtil.log1p(cf.getUserExpPv()))); // 用户当天入口曝光次数
                retMap.put("f0202", DataUtil.Long2String(MathUtil.log1p(cf.getUserActReqPv()))); // 用户当天活动访问次数
                retMap.put("f0203", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvLaunchPv()))); // 用户当天发券次数
                retMap.put("f0204", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvClkPv()))); // 用户当天券计费点击次数

                // 用户历史统计特征
                retMap.put("f0301", DataUtil.Long2String(MathUtil.log1p(cf.getUserReqPv1d())));        // 用户历史1天请求次数
                retMap.put("f0302", DataUtil.Long2String(MathUtil.log1p(cf.getUserExpPv1d())));        // 用户历史1天入口曝光次数
                retMap.put("f0303", DataUtil.Long2String(MathUtil.log1p(cf.getUserActReqPv1d())));     // 用户历史1天活动访问次数
                retMap.put("f0304", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvLaunchPv1d())));  // 用户历史1天发券次数
                retMap.put("f0305", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvClkPv1d())));     // 用户历史1天券计费点击次数
                retMap.put("f0306", DataUtil.Long2String(MathUtil.log1p(cf.getUserReqPv7d())));        // 用户历史7天请求次数
                retMap.put("f0307", DataUtil.Long2String(MathUtil.log1p(cf.getUserExpPv7d())));        // 用户历史7天入口曝光次数
                retMap.put("f0308", DataUtil.Long2String(MathUtil.log1p(cf.getUserActReqPv7d())));     // 用户历史7天活动访问次数
                retMap.put("f0309", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvLaunchPv7d())));  // 用户历史7天发券次数
                retMap.put("f0310", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvClkPv7d())));     // 用户历史7天券计费点击次数
                retMap.put("f0311", DataUtil.Long2String(MathUtil.log1p(cf.getUserReqPv14d())));       // 用户历史14天请求次数
                retMap.put("f0312", DataUtil.Long2String(MathUtil.log1p(cf.getUserExpPv14d())));       // 用户历史14天入口曝光次数
                retMap.put("f0313", DataUtil.Long2String(MathUtil.log1p(cf.getUserActReqPv14d())));    // 用户历史14天活动访问次数
                retMap.put("f0314", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvLaunchPv14d()))); // 用户历史14天发券次数
                retMap.put("f0315", DataUtil.Long2String(MathUtil.log1p(cf.getUserAdvClkPv14d())));    // 用户历史14天券计费点击次数

                // 用户历史序列特征(截断到20个）
                retMap.put("f0401", DataUtil.listToString(cf.getUser_exp_list()));              // 用户历史创意id曝光列表
                retMap.put("f0402", DataUtil.listToString(cf.getUser_clk_list()));              // 用户历史创意id点击列表
                retMap.put("f0403", DataUtil.listToString(cf.getUser_act_req_list()));          // 用户历史活动id访问列表
                retMap.put("f0404", DataUtil.listToString(cf.getUser_act_join_list()));         // 用户历史活动id参与列表
                retMap.put("f0405", DataUtil.listToString(cf.getUser_adv_launch_list()));       // 用户历史券id曝光列表
                retMap.put("f0406", DataUtil.listToString(cf.getUser_adv_clk_list()));          // 用户历史券id计费点击列表
                retMap.put("f0407", DataUtil.listToString(cf.getUser_adv_launch_trade_list())); // 用户历史券行业id曝光列表
                retMap.put("f0408", DataUtil.listToString(cf.getUser_adv_clk_trade_list()));    // 用户历史券行业id计费点击列表


            }
        } catch (Exception e) {
            logger.error("RtaFeatureParse.generateFeatureMapStatic error:", e);

        }
        return retMap;
    }
}