package cn.com.duiba.nezha.alg.feature.vo.featurev2;
import cn.com.duiba.nezha.alg.feature.vo.UserProfileFeature;

import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import lombok.Data;
@Data


public class Device {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(Device.class);

    private String connectionType;
    private String operatorType;
    private String osVersion;
    private String phoneModelCode;
    private String brandNameEn;
    private String phonePriceLevel;
    private Integer firstShowTime;
    private String phoneOs;
    private Long cityId;




    public String getOsVersion() {
        if (StringUtils.isBlank(this.osVersion)) {
            return null;
        }
        return this.osVersion.split("\\.")[0].toUpperCase();
    }

    public String getPhoneModelCode() {
        if (StringUtils.isBlank(this.phoneModelCode)) {
            return null;
        }
        // 字符过长截断
        return this.phoneModelCode.substring(0, Math.min(this.phoneModelCode.length(), 100));
    }

    public String getBrandNameEn() {
        return brandNameEn != null ? brandNameEn.toLowerCase() : null;
    }

    public String getPhonePriceLevel() {
        return phonePriceLevel;
    }

    public String getFirstShowTime(){
        if (this.firstShowTime == null) {
            return null;
        }
        // 判断firstShowTime合法性
        if (this.firstShowTime<2000 || this.firstShowTime>2030) {
            return "-1";
        }
        return this.firstShowTime.toString();
    }

    public String getPhoneOs() {
        if (StringUtils.isBlank(phoneOs)) {
            return null;
        }
        if (phoneOs.equalsIgnoreCase("android")) {
            return "android";
        }
        if (phoneOs.equalsIgnoreCase("ios")) {
            return "ios";
        }
        logger.warn("UserProfileFeature formatPhoneOs warn: " + phoneOs);
        return null;
    }







}
