package cn.com.duiba.nezha.alg.feature.vo.featurev2;

import java.util.Map;
import java.util.Set;
import lombok.Data;
@Data

public class UserBehavior {
    private Integer userActiveDays;
    private Integer weekActivityRequest;
    private Integer dayActivityRequest;

    private Long putIndex;

    private Map<Integer, Long> historyAdvertLaunch; // 用户历史广告发券次数
    private Map<Integer, Long> historyAdvertClick;  // 用户历史广告点击次数
    private Map<Integer, Long> historyAdvertEffect; // 用户历史广告转化次数

    private Map<Integer, Long> todayAdvertLaunch;   // 用户当日广告发券次数
    private Map<Integer, Long> todayAdvertClick;    // 用户当日广告点击次数
    private Map<Integer, Long> todayAdvertEffect;   // 用户当日广告转化次数

    private Integer history30LaunchCount;   //历史=30，曝光PV
    private Integer history30ClickCount;    //历史=30，点击PV
    private Integer history30EffectCount;   //历史=30，转化PV
    private Integer todayLaunchCount;   //当日，曝光PV
    private Integer todayClickCount;   //当日，点击PV
    private Integer todayEffectCount;   //当日，转化PV

    // 广告行业维度 行为明细
    private String oUIIds;
    private String oUILaunchPV;
    private String oUIClickPv;
    private String oUIEffectPv;

    private Map<String, Long> historyTradeLaunch;// 用户历史广告行业发券次数
    private Map<String, Long> historyTradeClick;// 用户历史广告行业点击次数
    private Map<String, Long> historyTradeEffect;// 用户历史广告行业转化次数
    private Map<String, Map<String, Long>> historyTradeCtrCvr;

    private Set<Integer> advertExposureSet;  // 曝光广告集合
    private Set<Integer> advertClickSet;    // 点击广告集合
    private Set<Integer> accountClickSet;   // 点击广告主集合
    private Set<String> resourceClickSet;   // 点击资源集合
    private Set<Integer> tradeClickSet;     // 点击行业集合

    private Set<Integer> advertEffectSet;   // 转化广告集合
    private Set<Integer> accountEffectSet;  // 转化广告主集合
    private Set<String> resourceEffectSet;  // 转化资源集合
    private Set<Integer> tradeEffectSet;    // 转化行业集合

    private Long times;
    private String lastActivity;
    private String lastLaunchTrade;
    private String lastResource;
    private String lastLaunchAccount;
    private String lastLaunchPlan;
    private String lastActivityLaunchOrder;
    private String lastActivityClickOrder;
    private Integer lastLaunchIsClick;
    private Integer lastClickIsEffect;



}
