/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.coder;

import cn.com.duiba.nezha.alg.feature.coder.FeatureUtil;
import cn.com.duiba.nezha.alg.feature.vo.FeatureCode;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureCoderBase2 {
    private static final Logger logger = LoggerFactory.getLogger(FeatureCoderBase2.class);

    public static int getVectorSize(List<Integer> pLenList) {
        Integer tmp;
        int ret = 0;
        if (pLenList != null && pLenList.size() > 0 && (tmp = pLenList.get(pLenList.size() - 1)) != null) {
            ret = tmp;
        }
        return ret;
    }

    public static FeatureCode getIdWithSeq(String feature, int fId) throws Exception {
        FeatureCode ret = new FeatureCode(feature, fId);
        return ret;
    }

    public static FeatureCode getIdsWithSeq(String feature, int[] sFIds) throws Exception {
        FeatureCode ret = new FeatureCode(feature, sFIds);
        return ret;
    }

    public static FeatureCode getValuesWithSeq(String feature, double[] sFIds) throws Exception {
        FeatureCode ret = new FeatureCode(feature, sFIds);
        return ret;
    }

    public static FeatureCode getSubIdWithSeq(String feature, String fStr, int fSize) throws Exception {
        int fId = FeatureUtil.getSubFId(feature, fStr, fSize);
        return FeatureCoderBase2.getIdWithSeq(fStr, fId);
    }

    public static FeatureCode getSubIdsWithSeq(String feature, String fStr, String seq, int fSize) throws Exception {
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getSubFIdsWithSeq(feature, fStrs, fSize);
        return FeatureCoderBase2.getIdsWithSeq(fStr, sFIds);
    }

    public static FeatureCode getHashSubIdWithSeq(String feature, String fStr, int fSize) throws Exception {
        int[] sFIds = FeatureUtil.getHashSubFIdNotSort(feature, fStr, fSize, 1);
        return FeatureCoderBase2.getIdsWithSeq(fStr, sFIds);
    }

    public static FeatureCode getHashSubIdsWithSeq(String feature, String fStr, String seq, int fSize) throws Exception {
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getHashSubFIdsWithSeq(feature, fStrs, fSize, 1);
        return FeatureCoderBase2.getIdsWithSeq(fStr, sFIds);
    }

    public static FeatureCode getDictSubIdWithSeq(String feature, String fStr, int fSize, Map<String, Integer> fDict) throws Exception {
        int fId = FeatureUtil.getDictSubFId(feature, fStr, fSize, fDict);
        return FeatureCoderBase2.getIdWithSeq(fStr, fId);
    }

    public static FeatureCode getDictSubIdsWithSeq(String feature, String fStr, String seq, int fSize, Map<String, Integer> fDict) throws Exception {
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getDictSubFIdsWithSeq(feature, fStrs, fSize, fDict);
        return FeatureCoderBase2.getIdsWithSeq(fStr, sFIds);
    }

    public static FeatureCode getEmbeddingSubIds(String feature, String fStr, String seq, int fSize) throws Exception {
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        double[] sFIds = FeatureUtil.getEmbeddingValuesWithSeq(fStrs, fSize);
        return FeatureCoderBase2.getValuesWithSeq(fStr, sFIds);
    }
}

