package cn.com.duiba.nezha.alg.feature.vo;

import java.io.Serializable;
import lombok.Data;


@Data
public class UserProfileFeature implements Serializable {
    private static final long serialVersionUID = 6653753667287162448L;

    // 基本属性
    private String sex; // f451001 性别
    private String age; // f451002  年龄
    private String marry;  // f451003  婚恋
    private String consumeLevel;   // f451004  消费水平
    private String permanentProvince; // f451005  常住地（省份）
    private String permanentCity; // f451006  常住地（城市）

    // 应用兴趣标签

    // 行为标签
    private String priceTag;  // f453001  价格标签
    private String effectPrefTag;  // f453002  转化偏好标签（下单、核单、签收）
    private String riskTag;   // f453003  风控标签

    // 外部数据行为
    private String appCatePref;    // f461001  app类目偏好（applist类目数量分布）
    private String recentAppCatePref;    // f461002  短期app类目偏好
    private String textCatePref;  // f461003  文本类目偏好（签名类目数量分布）
    private String recentTextCatePref;    // f461004 短期文本类目偏好
    private String keywordCatePref;   // f461005  关键词主题偏好（关键词聚类）
    private String recentKeywordCatePref;    // f461006  短期关键词主题偏好
    private String videoCatePref; // f461007  视频二级类目偏好（视频类目数量分布）
    private String recentVideoCatePref;  // f461008  短期视频二级类目偏好
    private String videoChannelPref;  // f461009  视频频道偏好（视频频道数量分布）
    private String recentVideoChannelPref;   // f461010  短期视频频道偏好
    private String recentVideoKeywordPref;   // f461011  短期视频关键词/标签偏好

    // 电商兴趣
    private String historyCateInterest;  // f471001  长期品类兴趣
    private String recentCateInterest;   // f471002  短期品类兴趣
    private String scoreCateInterest;  // f471003  品类兴趣分（长期）
    private String trendCateInterest;  // f471004    品类兴趣趋势（短期）
    private String seasonConsumPref;   // f471005 季节性消费偏好（周期过长）
    private String holidayConsumPref; // f471006  节日性消费偏好（周期过长）
    private String promotionSalesPref; // f471007  促销偏好
    private String promotionSalesLevelPref;   // f471008  促销力度偏好

    // 心理特征
    private String discountSensitivity;   //  f472001 折扣敏感度
    private String giftSensitivity;   // f472002  赠送敏感度

}
