package cn.com.duiba.nezha.alg.feature.coder;


import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.vo.CoderFeature;
import cn.com.duiba.nezha.alg.feature.vo.Feature;
import com.alibaba.fastjson.JSON;
import org.slf4j.LoggerFactory;

import java.util.*;

public class FeatureCoderBase {

    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(FeatureCoderBase.class);


    public static int getVectorSize(List<Integer> pLenList) {
        int ret = 0;
        if (pLenList != null && pLenList.size() > 0) {
            Integer tmp = pLenList.get(pLenList.size() - 1);
            if (tmp != null) {
                ret = tmp;
            }
        }
        return ret;
    }

    public static Set<Integer> getId(int fSize, int fId, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        Set<Integer> ret = new HashSet<>();
        int pLen = getVectorSize(pLenList);
        indices.add(pLen + fId);
        ret.add(pLen + fId);
        values.add(1.0);
        pLenList.add(pLen + fSize);

        return ret;

    }


    public static List<Integer> getIdWithSeq(int fSize, int fId, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        List<Integer> ret = new ArrayList<>();
        int pLen = getVectorSize(pLenList);
        indices.add(pLen + fId);
        ret.add(pLen + fId);
        values.add(1.0);
        pLenList.add(pLen + fSize);

        return ret;

    }

//    public static Set<Integer> getNewId(int fSize, Integer fId, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
//        Set<Integer> ret = new HashSet<>();
//        int pLen = getVectorSize(pLenList);
//        indices.add(pLen + fId);
//        ret.add(pLen + fId);
//        values.add(1.0);
//        pLenList.add(pLen + fSize);
//
//        return ret;
//    }

    public static Set<Integer> getId(int fId) throws Exception {
        Set<Integer> ret = new HashSet<>();
        ret.add(fId);
        return ret;

    }

    public static List<Integer> getIdWithSeq(int fId) throws Exception {
        List<Integer> ret = new ArrayList<>();
        ret.add(fId);
        return ret;

    }


    public static Set<Integer> getIds(int fSize, int pFNums, int[] sFIds, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        Set<Integer> ret = new HashSet<>();
        int pLen = getVectorSize(pLenList);
        if (sFIds != null && sFIds.length > 0) {
            double weight = MathUtil.reciprocalOfN(sFIds.length);
            for (int i = 0; i < sFIds.length; i++) {
                Integer newId = pLen + sFIds[i];
                indices.add(newId);
                ret.add(newId);
                values.add(weight);
            }
        }
        pLenList.add(pLen + pFNums * fSize);
        return ret;
    }


    public static List<Integer> getIdsWithSeq(int fSize, int pFNums, int[] sFIds, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        List<Integer> ret = new ArrayList<>();
        int pLen = getVectorSize(pLenList);
        if (sFIds != null && sFIds.length > 0) {
            double weight = MathUtil.reciprocalOfN(sFIds.length);
            for (int i = 0; i < sFIds.length; i++) {
                Integer newId = pLen + sFIds[i];
                indices.add(newId);
                ret.add(newId);
                values.add(weight);
            }
        }
        pLenList.add(pLen + pFNums * fSize);
        return ret;
    }


    public static Set<Integer> getIds(int[] sFIds) throws Exception {
        Set<Integer> ret = new HashSet<>();
        if (sFIds != null && sFIds.length > 0) {
            for (int i = 0; i < sFIds.length; i++) {
                int fId = sFIds[i];
                ret.add(fId);
            }
        }
        return ret;
    }

    public static List<Integer> getIdsWithSeq(int[] sFIds) throws Exception {
        List<Integer> ret = new ArrayList<>();
        if (sFIds != null && sFIds.length > 0) {
            for (int i = 0; i < sFIds.length; i++) {
                int fId = sFIds[i];
                ret.add(fId);
            }
        }
        return ret;
    }

    public static Set<Integer> getDenseId(String feature, String fStr, int fSize, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {


        int fId = FeatureUtil.getDenseFId(feature, fStr, fSize);

        return getId(fSize, fId, pLenList, indices, values);

    }


    public static List<Integer> getDenseIdWithSeq(String feature, String fStr, int fSize, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {


        int fId = FeatureUtil.getDenseFId(feature, fStr, fSize);

        return getIdWithSeq(fSize, fId, pLenList, indices, values);

    }


    public static Set<Integer> getSubId(String feature, String fStr, int fSize, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {


        int fId = FeatureUtil.getSubFId(feature, fStr, fSize);

        return getId(fSize, fId, pLenList, indices, values);

    }

    public static List<Integer> getSubIdWithSeq(String feature, String fStr, int fSize, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {


        int fId = FeatureUtil.getSubFId(feature, fStr, fSize);

        return getIdWithSeq(fSize, fId, pLenList, indices, values);

    }

//    public static Set<Integer> getNewSubId(String feature, String fStr, int fSize, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
//
//
//        Integer fId = FeatureUtil.getNewSubFId(feature, fStr, fSize);
//
//        return getNewId(fSize, fId, pLenList, indices, values);
//
//    }

    public static Set<Integer> getSubId(String feature, String fStr, int fSize) throws Exception {


        int fId = FeatureUtil.getSubFId(feature, fStr, fSize);

        return getId(fId);

    }

    public static List<Integer> getSubIdWithSeq(String feature, String fStr, int fSize) throws Exception {


        int fId = FeatureUtil.getSubFId(feature, fStr, fSize);

        return getIdWithSeq(fId);

    }


    public static Set<Integer> getDenseId(String feature, String fStr, int fSize) throws Exception {

        int fId = FeatureUtil.getDenseFId(feature, fStr, fSize);

        return getId(fId);

    }

    public static List<Integer> getDenseIdWithSeq(String feature, String fStr, int fSize) throws Exception {

        int fId = FeatureUtil.getDenseFId(feature, fStr, fSize);

        return getIdWithSeq(fId);

    }


    public static Set<Integer> getSubIds(String feature, String fStr, String seq, int fSize, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {

        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getSubFIds(feature, fStrs, fSize);

        return getIds(fSize, 1, sFIds, pLenList, indices, values);
    }

    public static List<Integer> getSubIdsWithSeq(String feature, String fStr, String seq, int fSize, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {

        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getSubFIdsWithSeq(feature, fStrs, fSize);

        return getIdsWithSeq(fSize, 1, sFIds, pLenList, indices, values);
    }


    public static Set<Integer> getSubIds(String feature, String fStr, String seq, int fSize) throws Exception {

        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getSubFIds(feature, fStrs, fSize);
        return getIds(sFIds);
    }

    public static List<Integer> getSubIdsWithSeq(String feature, String fStr, String seq, int fSize) throws Exception {

        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getSubFIdsWithSeq(feature, fStrs, fSize);

        return getIdsWithSeq(sFIds);
    }

    public static Set<Integer> getHashSubId(String feature, String fStr, int fSize, int pNums, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
//        Set<Integer> ret = new HashSet<>();
//        int pLen = getVectorSize(pLenList);
        int[] sFIds = FeatureUtil.getHashSubFId(feature, fStr, fSize, pNums);
        return getIds(fSize, pNums, sFIds, pLenList, indices, values);
    }

    public static List<Integer> getHashSubIdWithSeq(String feature, String fStr, int fSize, int pNums, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
//        Set<Integer> ret = new HashSet<>();
//        int pLen = getVectorSize(pLenList);
        int[] sFIds = FeatureUtil.getHashSubFIdNotSort(feature, fStr, fSize, pNums);
        return getIdsWithSeq(fSize, pNums, sFIds, pLenList, indices, values);
    }

    public static Set<Integer> getHashSubId(String feature, String fStr, int fSize, int pNums) throws Exception {
//        Set<Long> ret = new HashSet<>();
        int[] sFIds = FeatureUtil.getHashSubFId(feature, fStr, fSize, pNums);
        return getIds(sFIds);
    }

    public static List<Integer> getHashSubIdWithSeq(String feature, String fStr, int fSize, int pNums) throws Exception {
//        Set<Long> ret = new HashSet<>();
        int[] sFIds = FeatureUtil.getHashSubFIdNotSort(feature, fStr, fSize, pNums);
        return getIdsWithSeq(sFIds);
    }


    public static Set<Integer> getHashSubIds(String feature, String fStr, String seq, int fSize, int pNums, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        Set<Integer> ret = new HashSet<>();
//        int pLen = getVectorSize(pLenList);
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
//        System.out.println("featureId="+feature+",str="+ JSON.toJSONString(fStr)+",fStrs="+JSON.toJSONString(fStrs));
        int[] sFIds = FeatureUtil.getHashSubFIds(feature, fStrs, fSize, pNums);
//         System.out.println("pFNums="+pFNums+"，sFIds="+JSON.toJSONString(sFIds));
        return getIds(fSize, pNums, sFIds, pLenList, indices, values);
    }

    public static Set<Integer> getHashSubIds(String feature, String fStr, String seq, int fSize, int pNums) throws Exception {
//        Set<Integer> ret = new HashSet<>();
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
//        System.out.println("featureId="+feature+",str="+ JSON.toJSONString(fStr)+",fStrs="+JSON.toJSONString(fStrs));
        int[] sFIds = FeatureUtil.getHashSubFIds(feature, fStrs, fSize, pNums);
//         System.out.println("pFNums="+pFNums+"，sFIds="+JSON.toJSONString(sFIds));
        return getIds(sFIds);
    }


    public static List<Integer> getHashSubIdsWithSeq(String feature, String fStr, String seq, int fSize, int pNums, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        Set<Integer> ret = new HashSet<>();
//        int pLen = getVectorSize(pLenList);
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
//        System.out.println("featureId="+feature+",str="+ JSON.toJSONString(fStr)+",fStrs="+JSON.toJSONString(fStrs));
        int[] sFIds = FeatureUtil.getHashSubFIdsWithSeq(feature, fStrs, fSize, pNums);
//         System.out.println("pFNums="+pFNums+"，sFIds="+JSON.toJSONString(sFIds));
        return getIdsWithSeq(fSize, pNums, sFIds, pLenList, indices, values);
    }

    public static List<Integer> getHashSubIdsWithSeq(String feature, String fStr, String seq, int fSize, int pNums) throws Exception {
//        Set<Integer> ret = new HashSet<>();
        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
//        System.out.println("featureId="+feature+",str="+ JSON.toJSONString(fStr)+",fStrs="+JSON.toJSONString(fStrs));
        int[] sFIds = FeatureUtil.getHashSubFIdsWithSeq(feature, fStrs, fSize, pNums);
//         System.out.println("pFNums="+pFNums+"，sFIds="+JSON.toJSONString(sFIds));
        return getIdsWithSeq(sFIds);
    }


    public static Set<Integer> getDictSubId(String feature, String fStr, int fSize, List<Integer> pLenList, List<Integer> indices, List<Double> values, Map<String, Integer> fDict) throws Exception {

        int fId = FeatureUtil.getDictSubFId(feature, fStr, fSize, fDict);

        return getId(fSize, fId, pLenList, indices, values);
    }

    public static Set<Integer> getDictSubId(String feature, String fStr, int fSize, Map<String, Integer> fDict) throws Exception {

        int fId = FeatureUtil.getDictSubFId(feature, fStr, fSize, fDict);

        return getId(fId);
    }

    public static List<Integer> getDictSubIdWithSeq(String feature, String fStr, int fSize, List<Integer> pLenList, List<Integer> indices, List<Double> values, Map<String, Integer> fDict) throws Exception {

        int fId = FeatureUtil.getDictSubFId(feature, fStr, fSize, fDict);

        return getIdWithSeq(fSize, fId, pLenList, indices, values);
    }

    public static List<Integer> getDictSubIdWithSeq(String feature, String fStr, int fSize, Map<String, Integer> fDict) throws Exception {

        int fId = FeatureUtil.getDictSubFId(feature, fStr, fSize, fDict);

        return getIdWithSeq(fId);
    }


    public static Set<Integer> getDictSubIds(String feature, String fStr, String seq, int fSize, List<Integer> pLenList, List<Integer> indices, List<Double> values, Map<String, Integer> fDict) throws Exception {

        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);

        int[] sFIds = FeatureUtil.getDictSubFIds(feature, fStrs, fSize, fDict);

        return getIds(fSize, 1, sFIds, pLenList, indices, values);
    }

    public static Set<Integer> getDictSubIds(String feature, String fStr, String seq, int fSize, Map<String, Integer> fDict) throws Exception {

        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);

        int[] sFIds = FeatureUtil.getDictSubFIds(feature, fStrs, fSize, fDict);

        return getIds(sFIds);
    }

    public static List<Integer> getDictSubIdsWithSeq(String feature, String fStr, String seq, int fSize, List<Integer> pLenList, List<Integer> indices, List<Double> values, Map<String, Integer> fDict) throws Exception {

        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);

        int[] sFIds = FeatureUtil.getDictSubFIdsWithSeq(feature, fStrs, fSize, fDict);

        return getIdsWithSeq(fSize, 1, sFIds, pLenList, indices, values);
    }

    public static List<Integer> getDictSubIdsWithSeq(String feature, String fStr, String seq, int fSize, Map<String, Integer> fDict) throws Exception {

        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);

        int[] sFIds = FeatureUtil.getDictSubFIdsWithSeq(feature, fStrs, fSize, fDict);

        return getIdsWithSeq(sFIds);
    }

    public static Feature toFeature(List<Integer> indices, List<Double> values, List<Integer> pLenList, List<String> fields) throws Exception {

        if (AssertUtil.isAnyEmpty(indices, values, pLenList)) {
            throw new Exception("AssertUtil.isAnyEmpty(indices,values,pLenList), input invalid");
        }

        if (values.size() != indices.size()) {
            throw new Exception("values.size()!=pLenList.size(), input invalid");
        }


//        int[] indices2 = new int[indices.size()];
        double[] values2 = new double[values.size()];
        String[] fields2 = new String[fields.size()];

        for (int i = 0; i < indices.size(); i++) {
//            indices2[i] = indices.get(i);
            values2[i] = values.get(i);
            fields2[i] = fields.get(i);
        }


        int pLen = getVectorSize(pLenList);

        return new Feature(pLen, indices, values2, fields);


    }

    public static Feature toFeature(List<Integer> indices, List<Double> values, List<String> fields, int size) throws Exception {

        if (AssertUtil.isAnyEmpty(indices, values, fields)) {
            throw new Exception("AssertUtil.isAnyEmpty(indices,values,pLenList), input invalid");
        }

        if (values.size() != indices.size()) {
            throw new Exception("values.size()!=pLenList.size(), input invalid");
        }


//        int[] indices2 = new int[indices.size()];
        double[] values2 = new double[values.size()];
        String[] fields2 = new String[fields.size()];

        for (int i = 0; i < indices.size(); i++) {
//            indices2[i] = indices.get(i);
            values2[i] = values.get(i);
            fields2[i] = fields.get(i);
        }


        return new Feature(size, indices, values2, fields);


    }


    //新增 编码方式
    public static CoderFeature getId(int fSize, String field, int fId, int startIndex) throws Exception {

        List<Integer> indices = new ArrayList<>();
        List<Double> values = new ArrayList<>();
        List<String> fields = new ArrayList<>();
        Set<Integer> fieldsSet = new HashSet<>();


        Integer newId = startIndex + fId;
        indices.add(newId);
        values.add(1.0);
        fields.add(field);
        fieldsSet.add(newId);
        return new CoderFeature(fSize, startIndex + fSize, indices, values, fields, fieldsSet);


    }

    public static CoderFeature getIds(int fSize, String field, int pFNums, int[] sFIds, int startIndex) throws Exception {

        List<Integer> indices = new ArrayList<>();
        List<Double> values = new ArrayList<>();
        List<String> fields = new ArrayList<>();
        Set<Integer> fieldsSet = new HashSet<>();

        if (sFIds != null && sFIds.length > 0) {
            double weight = MathUtil.reciprocalOfN(sFIds.length);
            for (int i = 0; i < sFIds.length; i++) {
                Integer newId = startIndex + sFIds[i];
                indices.add(newId);
                values.add(weight);
                fields.add(field);
                fieldsSet.add(newId);
            }
        }
        return new CoderFeature(fSize, startIndex + pFNums * fSize, indices, values, fields, fieldsSet);
    }


    public static CoderFeature getDenseId(String field, String fStr, int fSize, int startIndex) throws Exception {


        int fId = FeatureUtil.getDenseFId(field, fStr, fSize);

        return getId(fSize, field, fId, startIndex);

    }

    public static CoderFeature getSubId(String field, String fStr, int fSize, int startIndex) throws Exception {


        int fId = FeatureUtil.getSubFId(field, fStr, fSize);

        return getId(fSize, field, fId, startIndex);

    }


    public static CoderFeature getSubIds(String field, String fStr, String seq, int fSize, int startIndex) throws Exception {

        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getSubFIds(field, fStrs, fSize);

        return getIds(fSize, field, 1, sFIds, startIndex);
    }


    public static CoderFeature getHashSubId(String field, String fStr, int fSize, int pNums, int startIndex) throws Exception {

        int[] sFIds = FeatureUtil.getHashSubFId(field, fStr, fSize, pNums);
        return getIds(fSize, field, pNums, sFIds, startIndex);
    }


    public static CoderFeature getHashSubIds(String field, String fStr, String seq, int fSize, int pNums, int startIndex) throws Exception {

        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getHashSubFIds(field, fStrs, fSize, pNums);
        return getIds(fSize, field, pNums, sFIds, startIndex);
    }


    public static CoderFeature getDictSubId(String field, String fStr, int fSize, int startIndex, Map<String, Integer> fDict) throws Exception {

        int fId = FeatureUtil.getDictSubFId(field, fStr, fSize, fDict);

        return getId(fSize, field, fId, startIndex);
    }


    public static CoderFeature getDictSubIds(String field, String fStr, String seq, int fSize, int startIndex, Map<String, Integer> fDict) throws Exception {

        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getDictSubFIds(field, fStrs, fSize, fDict);
        return getIds(fSize, field, 1, sFIds, startIndex);
    }


    public static Feature toFeatureNew(int size, List<Integer> indices, List<Double> values, List<String> fields) throws Exception {

        if (AssertUtil.isAnyEmpty(indices, values)) {
            throw new Exception("AssertUtil.isAnyEmpty(indices,values,pLenList), input invalid");
        }

        if (values.size() != indices.size()) {
            throw new Exception("values.size()!=pLenList.size(), input invalid");
        }

        double[] values2 = new double[values.size()];
        String[] fields2 = new String[fields.size()];

        for (int i = 0; i < indices.size(); i++) {
            values2[i] = values.get(i);
            fields2[i] = fields.get(i);
        }
        return new Feature(size, indices, values2, fields);

    }

}