/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.coder;

import cn.com.duiba.nezha.alg.feature.util.HashUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureUtil {
    private static final Logger logger = LoggerFactory.getLogger(FeatureUtil.class);
    public static int[] seed = new int[]{3, 7, 11, 17, 19, 31, 41};

    public static int[] getHashSubFId(String feature, String str, int size, int nums) throws Exception {
        if (nums > seed.length) {
            logger.warn("nums is larger than seed size,invalid");
            return null;
        }
        str = FeatureUtil.std(str);
        int[] ret = new int[nums];
        for (int i = 0; i < nums; ++i) {
            ret[i] = i * size + HashUtil.hash(str, size, seed[i]);
        }
        Arrays.sort(ret);
        return ret;
    }

    public static int[] getHashSubFIdNotSort(String feature, String str, int size, int nums) throws Exception {
        if (nums > seed.length) {
            logger.warn("nums is larger than seed size,invalid");
            return null;
        }
        str = FeatureUtil.std(str);
        int[] ret = new int[nums];
        for (int i = 0; i < nums; ++i) {
            ret[i] = i * size + HashUtil.hash(str, size, seed[i]);
        }
        return ret;
    }

    public static int[] getHashSubFIds(String feature, String[] str, int size, int nums) throws Exception {
        if (nums > seed.length) {
            logger.warn("hash nums is larger than seed size,invalid");
            return null;
        }
        if (str == null || str.length == 0) {
            str = new String[]{null};
        }
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i = 0; i < str.length; ++i) {
            int[] tmp = FeatureUtil.getHashSubFIdNotSort(feature, str[i], size, nums);
            for (int j = 0; j < tmp.length; ++j) {
                set.add(tmp[j]);
            }
        }
        Integer[] retI = set.toArray(new Integer[set.size()]);
        int[] ret = new int[retI.length];
        for (int i = 0; i < retI.length; ++i) {
            ret[i] = retI[i];
        }
        Arrays.sort(ret);
        return ret;
    }

    public static int[] getEmbeddingSubFIds(String feature, String[] str, int size, int nums) throws Exception {
        if (nums > seed.length) {
            logger.warn("hash nums is larger than seed size,invalid");
            return null;
        }
        if (str == null || str.length == 0) {
            str = new String[]{null};
        }
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i = 0; i < str.length; ++i) {
            int[] tmp = FeatureUtil.getHashSubFIdNotSort(feature, str[i], size, nums);
            for (int j = 0; j < tmp.length; ++j) {
                set.add(tmp[j]);
            }
        }
        Integer[] retI = set.toArray(new Integer[set.size()]);
        int[] ret = new int[retI.length];
        for (int i = 0; i < retI.length; ++i) {
            ret[i] = retI[i];
        }
        Arrays.sort(ret);
        return ret;
    }

    public static int[] getHashSubFIdsWithSeq(String feature, String[] str, int size, int nums) throws Exception {
        if (nums > seed.length) {
            logger.warn("hash nums is larger than seed size,invalid");
            return null;
        }
        if (str == null || str.length == 0) {
            str = new String[]{null};
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < str.length; ++i) {
            int[] tmp = FeatureUtil.getHashSubFIdNotSort(feature, str[i], size, nums);
            for (int j = 0; j < tmp.length; ++j) {
                list.add(tmp[j]);
            }
        }
        int[] ret = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = (Integer)list.get(i);
        }
        return ret;
    }

    public static int getDictSubFId(String feature, String str, int size, Map<String, Integer> dict) throws Exception {
        int ret = 0;
        str = FeatureUtil.stdDictKey(str);
        if (dict != null && str != null) {
            Integer tmp = dict.getOrDefault(str, 0);
            ret = tmp;
        }
        return ret;
    }

    public static int[] getDictSubFIds(String feature, String[] str, int size, Map<String, Integer> dict) throws Exception {
        if (str == null) {
            str = new String[]{null};
        }
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i = 0; i < str.length; ++i) {
            int tmp = FeatureUtil.getDictSubFId(feature, str[i], size, dict);
            set.add(tmp);
        }
        Integer[] retI = set.toArray(new Integer[set.size()]);
        int[] ret = new int[retI.length];
        for (int i = 0; i < retI.length; ++i) {
            ret[i] = retI[i];
        }
        Arrays.sort(ret);
        return ret;
    }

    public static int[] getDictSubFIdsWithSeq(String feature, String[] str, int size, Map<String, Integer> dict) throws Exception {
        if (str == null) {
            str = new String[]{null};
        }
        HashSet<Integer> set = new HashSet<Integer>();
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < str.length; ++i) {
            int tmp = FeatureUtil.getDictSubFId(feature, str[i], size, dict);
            if (set.contains(tmp)) continue;
            set.add(tmp);
            list.add(tmp);
        }
        int[] ret = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = (Integer)list.get(i);
        }
        return ret;
    }

    public static int[] getSubFIds(String feature, String[] str, int size) throws Exception {
        if (str == null) {
            str = new String[]{null};
        }
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i = 0; i < str.length; ++i) {
            int tmp = FeatureUtil.getSubFId(feature, str[i], size);
            set.add(tmp);
        }
        Integer[] retI = set.toArray(new Integer[set.size()]);
        int[] ret = new int[retI.length];
        for (int i = 0; i < retI.length; ++i) {
            ret[i] = retI[i];
        }
        Arrays.sort(ret);
        return ret;
    }

    public static int[] getSubFIdsWithSeq(String feature, String[] str, int size) throws Exception {
        if (str == null) {
            str = new String[]{null};
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < str.length; ++i) {
            int tmp = FeatureUtil.getSubFId(feature, str[i], size);
            list.add(tmp);
        }
        int[] ret = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = (Integer)list.get(i);
        }
        return ret;
    }

    public static int getSubFId(String feature, String str, int size) {
        int ret = 0;
        str = FeatureUtil.std(str);
        try {
            Integer tmp;
            if (str != null && (tmp = Integer.valueOf(str)) != null && tmp >= 0) {
                ret = (size - 1 + tmp) % (size - 1);
                ++ret;
            }
        }
        catch (Exception e) {
            logger.warn("getSubFId() Integer.valueOf(str) happend error ,feature=" + feature + ",str=" + str, (Throwable)e);
        }
        return ret;
    }

    public static int getDenseFId(String feature, String str, int size) throws Exception {
        int ret = 0;
        if ((str = FeatureUtil.std(str)) != null) {
            ret = 1;
        }
        return ret;
    }

    public static String std(String oStr) {
        if (oStr == null) {
            return null;
        }
        String lowStr = oStr.toLowerCase();
        if (lowStr.length() == 0 || lowStr.equals("\\n") || lowStr.equals("\n") || lowStr.equals("null") || lowStr.equals("none")) {
            return null;
        }
        return lowStr;
    }

    public static String stdDictKey(String oStr) {
        if (oStr == null) {
            return null;
        }
        String lowStr = FeatureUtil.std(oStr);
        if (lowStr != null && lowStr.length() > 0) {
            return lowStr.replace(".", "#");
        }
        return lowStr;
    }

    public static String[] toFeatures(String str, String seq) throws Exception {
        String[] ret = null;
        if (FeatureUtil.std(str) != null) {
            ret = str.split(seq, 0);
        }
        return ret;
    }

    public static double[] getEmbeddingValuesWithSeq(String[] fStrs, int size) throws Exception {
        double[] ret = new double[size];
        if (fStrs != null) {
            for (int i = 0; i < size; ++i) {
                String f = fStrs[i];
                ret[i] = f == null ? 0.0 : Double.valueOf(f);
            }
        }
        return ret;
    }
}

