package cn.com.duiba.nezha.alg.feature.vo;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import lombok.Data;
import org.slf4j.LoggerFactory;

import java.util.Map;
import java.util.Random;

@Data
public class CvrStatDo {
    /**
     * 计费点击PV（过去3天）
     */
    private Long click3Day;

    /**
     * 后端类型转化PV Map（过去3天）
     */
    private Map<String, Long> convertMap3Day;

    /**
     * 计费点击PV（昨天+当天）
     */
    private Long click1Day;

    /**
     * 后端类型转化PV Map（昨天+当天）
     */
    private Map<String, Long> convertMap1Day;

    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(CvrStatDo.class);

    private static Double calWilsonScore(Long baseCnt, Long targetCnt, double faithLevel) {
        if (baseCnt == null || targetCnt == null) return null;

        if (baseCnt <= 0 || targetCnt <= 0) return null;

        double ratio = targetCnt * 1.0 / baseCnt;
        double faithSquare = faithLevel * faithLevel;

        return (ratio + (faithSquare / (2 * baseCnt)) - faithLevel * Math.sqrt(4 * baseCnt * ratio * (1 - ratio) + faithSquare) / (2 * baseCnt)) / (1 + faithSquare / baseCnt);
    }

    public static void main(String[] args) {
        Double cvr = calWilsonScore(null, null, 2);
        System.out.println(DataUtil.formatDouble(cvr, 6));
        System.out.println(cvr);
    }


    public Double getCvr1DayBySubType(String subtype) {
        Long convertPv = convertMap1Day == null ? null : convertMap1Day.get(subtype);

        // 95% 置信区间下界
        Double cvr = calWilsonScore(click1Day, convertPv, 2);

        if (cvr != null && (Double.isInfinite(cvr) || Double.isNaN(cvr))) {
            if (new Random().nextDouble() < 0.00001) {
                logger.info("invalid cvr value. convert: " + convertPv + ", click: " + click1Day);
            }
            return null;
        }

        return DataUtil.formatDouble(cvr, 6);
    }

    public Double getCvr3DayBySubType(String subtype) {
        Long convertPv = convertMap3Day == null ? null : convertMap3Day.get(subtype);

        // 95% 置信区间下界
        Double cvr = calWilsonScore(click3Day, convertPv, 2);

        if (cvr != null && (Double.isInfinite(cvr) || Double.isNaN(cvr))) {
            if (new Random().nextDouble() < 0.0001) {
                logger.info("invalid cvr value. convert: " + convertPv + ", click: " + click3Day);
            }
            return null;
        }


        return DataUtil.formatDouble(cvr, 6);
    }

}
