package cn.com.duiba.nezha.alg.feature.vo;

import lombok.Data;

import java.io.Serializable;


@Data
public class ItemProfileFeature implements Serializable {
    private static final long serialVersionUID = 4585858864365590406L;

    // 基本信息
    private Long advertId;  // f101001 广告id
    private String name;    //  f141001 商品名称
    private String categoryTag;   // f141002    商品品类（资源标签）
    private String brand;  //  f141003  商品品牌
    private String shop;   //  f141004  商品所属商家
    private String account;    // f141005   关联广告主
    private String picture;    //  f141006  商品图片
    private String materialPicture;   //  f141007   商品券素材图片
    private String layerPicture;  //  f141008   商品弹层预览图
    private String desc;   //  f141009  商品描述文字
    private String topCategory;   //  f141010   商品所属一级类目（百奇类目）
    private String secondCategory;    //  f141011   商品所属二级类目（百奇类目）
    private String tags;   //  f141012  商品标签
    private Double originalPrice; //  f141013   商品原价
    private Double dealPrice; //  f141014   商品成交价格
    private String number; //  f141015 商品规格
    private Integer deliveryDays;  //  f141016   商品发货天数
    private String dateOnSale;   //  f141017    商品上架日期
    private Long daysOnSale;   //  f141018  上架时间距今（天）

    // 标签信息
    private String dynamicType;   //  f142001   商品券动态类型（静态、动态）
    private String interestPoint; //  f142002   商品利益点（促销方式
    private String materialPictureRGB;   //  f142003    商品券颜色
    private String layerPictureRGB;  //  f142004    商品弹层颜色
    private String pictureRGB;    //  f142005	商品图颜色
    private String priceTag;  //  f142006	商品价格标签
    private String regionTag; //  f142007   商品地域标签
    private String historySeasonTag; //  f142008    商品季节标签（周期过长）
    private String holidaySeasonTag; //  f142009    商品节日标签（周期过长）
    private String crowdTag;  //  f142010   商品受众（聚类算法）
    private String promotionStrength; //  f142011   商品促销力度
    private String keyword;    //  f142012  商品关键词（关键词算法）

    // 热度信息
    private Long clickCnt;  //  f143001  商品历史点击次数
    private Long weekClickCnt; //  f143002   商品近一周点击次数
    private Long dayClickCnt;  //  f143003   商品当日点击次数
    private Long effectCnt; //  f143004  商品历史转化次数
    private Long weekEffectCnt;    //  f143005   商品近一周转化次数
    private Long dayEffectCnt; //  f143006	商品当日转化次数
    private Long issueEffectCnt;   //  f143007   商品历史出单次数
    private Long weekIssueEffectCnt;  //  f143008    商品近一周出单次数
    private Long signEffectCnt;    //  f143009	商品历史签收次数
    private Long weekSignEffectCnt;   //  f143010    商品近一周签收次数

    // 衍生信息
    private Double ctr;    //  f144001  商品历史点击率
    private Double weekCtr;   //  f144002   商品近一周点击率
    private Double dayCtr;    //  f144003   商品当日点击率
    private Double cvr;    //  f144004  商品历史转化率
    private Double weekCvr;   //  f144005   商品近一周转化率
    private Double dayCvr;    //  f144006	商品当日转化率
    private Double iecvr;  //  f144007  商品历史出单率
    private Double weekIecvr; //  f144008   商品近一周出单率
    private Double secvr;  //  f144009	商品历史签收率
    private Double weekSecvr; //  f144010   商品近一周签收率
}


