package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.vo.*;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import org.slf4j.LoggerFactory;

import java.util.*;

/**
 * Created by pc on 2017/2/17.
 */
public class FeatureParse {

    public static int F_MAX_SIZE = 64;
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(FeatureParse.class);


    public static int[] dayOrderRankBucket = {1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 15, 20, 30, 60, 100};
    public static int[] orderRankBucket = {1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 15, 20, 25, 30, 35, 50, 70, 100, 200, 500};

    public static int[] dayActOrderRankBucket = {1, 2, 3, 4, 5, 6, 7, 8, 9, 20};
    public static int[] orderActRankBucket = {1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 15, 20, 30, 50};

    public static int[] orderGmtIntervelBucket = {1, 2, 3, 4, 5, 10, 60, 60 * 12, 60 * 24, 60 * 24 * 7};

    public static int[] orderActGmtIntervelBucket = {1, 2, 3, 4, 5, 10, 60, 60 * 12, 60 * 24, 60 * 24 * 7};

    public static double[] userCtrBucket = {0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};

    public static double[] userCvrBucket = {0.01, 0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};

    public static double[] userSignRatioBucket = {0.001, 0.005, 0.01, 0.015, 0.02, 0.025, 0.03, 0.035, 0.04, 0.045, 0.05, 0.075, 0.1, 0.125, 0.15, 0.175, 0.20, 0.225, 0.25, 0.275, 0.30, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};  // 签收率

    public static int[] cntBucket = {0, 1, 3, 5, 10, 15, 20};
    public static int[] bigCntBucket = {0, 500, 1000, 2000, 5000, 10000, 20000, 50000, 100000, 500000, 1000000};
    public static int[] ctrAndCvrLevelBucket = {1, 4, 8};
    public static int[] videoDurationBucket = {0, 15, 30, 60, 5 * 60, 10 * 60, 15 * 60, 30 * 60, 45 * 60, 60 * 60, 90 * 60, 120 * 60};
    public static int[] colorRBGBucket = {0, 25, 50, 75, 100, 125, 150, 175, 200, 225};

    public static int[] priceBucket = {0, 5000, 10000, 20000, 50000, 100000, 200000};
    public static int[] totalPriceBucket = {0, 10000, 50000, 100000, 200000, 500000, 1000000};

    public static int[] cateScoreBucket = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};

    public static double[] statCtrBucket = {0.001, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.40, 0.45, 0.50, 0.6, 0.7, 0.8, 0.9, 0.99};

    public static double[] statCvrBucket = {0.001, 0.01, 0.02, 0.03, 0.04, 0.05, 0.1, 0.15, 0.20, 0.25, 0.30, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};

    public static double[] statBCvrBucket = {
            0.001, 0.002, 0.003, 0.004, 0.005, 0.006, 0.007, 0.008, 0.009,
            0.01 , 0.011, 0.012, 0.013, 0.014, 0.015, 0.016, 0.017, 0.018, 0.019,
            0.02 , 0.021, 0.022, 0.023, 0.024, 0.025, 0.026, 0.027, 0.028, 0.029,
            0.03 , 0.031, 0.032, 0.033, 0.034, 0.035, 0.036, 0.037, 0.038, 0.039,
            0.04 , 0.041, 0.042, 0.043, 0.044, 0.045, 0.046, 0.047, 0.048, 0.049,
            0.05 , 0.06, 0.07, 0.08, 0.09,
            0.1, 0.12, 0.14, 0.16, 0.18,
            0.2, 0.22, 0.24, 0.26, 0.28,
            0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};

    public static double[] cntRatioBucket = {0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9};

    public static int[] cntMeituanBucket = {-1, 1, 2, 3, 4, 5, 10, 20, 30};

    public static int[] convertCntBucket = {0, 5, 10, 50, 100, 200, 500, 1000};

    // 行业标签编码
    public static Map<String, Integer> tradeCodes = new HashMap<String, Integer>() {
        {
            put("8", 0);
            put("14", 1);
            put("15", 2);
            put("21", 3);
            put("20", 4);
            put("3", 5);
            put("5", 6);
            put("12", 7);
            put("2", 8);
            put("1", 9);
            put("24", 10);
            put("6", 11);
            put("7", 12);
            put("11", 13);
            put("13", 14);
            put("18", 15);
            put("22", 16);
            put("4", 17);
            put("17", 18);
            put("25", 19);
            put("10", 20);
            put("23", 21);
            put("9", 22);
            put("19", 23);
            put("16", 24);
        }
    };

    // 落地页标签编码
    public static Map<String, Integer> loadingPageCodes = new HashMap<String, Integer>() {
        {
            put("04.01.0001", 0);
            put("04.01.0002", 1);
            put("04.01.0003", 2);
            put("04.01.0004", 3);
            put("04.01.0005", 4);
            put("04.01.0006", 5);
            put("04.01.0007", 6);
            put("04.01.0008", 7);
            put("04.01.0009", 8);
            put("04.01.0010", 9);
            put("04.02.0001", 10);
            put("04.03.0001", 11);
            put("04.03.0002", 12);
            put("04.03.0003", 13);
            put("04.03.0004", 14);
            put("04.03.0005", 15);
            put("04.03.0007", 16);
            put("04.03.0008", 17);
            put("04.03.0009", 18);
            put("04.03.0010", 19);
            put("04.03.0011", 20);
            put("04.03.0012", 21);
            put("04.03.0013", 22);
            put("04.03.0014", 23);
            put("04.03.0015", 24);
            put("04.03.0017", 25);
            put("04.03.0018", 26);
            put("04.03.0019", 27);
            put("04.03.0020", 28);
            put("04.03.0021", 29);
        }
    };


    // 资源标签编码
    public static Map<String, Integer> resourceCodes = new HashMap<String, Integer>() {
        {
            put("07.23.0008", 0);
            put("07.23.0019", 1);
            put("07.23.0010", 2);
            put("07.24.0001", 3);
            put("07.23.0013", 4);
            put("07.23.0018", 5);
            put("07.23.0009", 6);
            put("07.23.0030", 7);
            put("07.23.0012", 8);
            put("07.23.0036", 9);
            put("07.23.0021", 10);
        }
    };
    // App类目编码
    public static Map<String, Integer> appCodes = new HashMap<String, Integer>() {
        {
            put("0", 0);
            put("1", 1);
            put("2", 2);
            put("3", 3);
            put("4", 4);
            put("5", 5);
            put("6", 6);
            put("7", 7);
            put("8", 8);
            put("9", 9);
            put("10", 10);
            put("11", 11);
            put("12", 12);
            put("13", 13);
            put("14", 14);
        }
    };
    // 签名类目编码
    public static Map<String, Integer> msgSigCodes = new HashMap<String, Integer>() {
        {
            put("0", 0);
            put("1", 1);
            put("2", 2);
            put("3", 3);
            put("4", 4);
            put("5", 5);
            put("6", 6);
            put("7", 7);
            put("8", 8);
            put("9", 9);
            put("10", 10);
            put("11", 11);
            put("12", 12);
            put("13", 13);
            put("14", 14);
            put("15", 15);
            put("16", 16);
            put("17", 17);
            put("18", 18);
            put("19", 19);
            put("20", 20);
            put("21", 21);
            put("22", 22);
            put("23", 23);
            put("24", 24);
            put("25", 25);
            put("26", 26);
            put("27", 27);
            put("28", 28);
            put("29", 29);
            put("30", 30);
            put("31", 31);
            put("32", 32);
            put("33", 33);
            put("34", 34);
            put("35", 35);
            put("36", 36);
            put("37", 37);
            put("38", 38);
            put("39", 39);
            put("40", 40);
            put("41", 41);
            put("42", 42);
            put("43", 43);
        }
    };
    // 关键词类目编码
    public static Map<String, Integer> keywordCodes = new HashMap<String, Integer>() {
        {
            put("0", 0);
            put("1", 1);
            put("2", 2);
            put("3", 3);
            put("4", 4);
            put("5", 5);
            put("6", 6);
            put("7", 7);
            put("8", 8);
            put("9", 9);
            put("10", 10);
            put("11", 11);
            put("12", 12);
            put("13", 13);
            put("14", 14);
            put("15", 15);
            put("16", 16);
            put("17", 17);
            put("18", 18);
            put("19", 19);
            put("20", 20);
            put("21", 21);
            put("22", 22);
            put("23", 23);
            put("24", 24);
            put("25", 25);
            put("26", 26);
            put("27", 27);
            put("28", 28);
            put("29", 29);
            put("30", 30);
        }
    };
    // 视频类目编码 videoCate
    public static Map<String, Integer> videoCateCodes = new HashMap<String, Integer>() {
        {
            put("1273152", 0);
            put("1273153", 1);
            put("1273154", 2);
            put("1273155", 3);
            put("1273158", 4);
            put("1273163", 5);
            put("1273166", 6);
            put("1273190", 7);
            put("1273380", 8);
            put("1273399", 9);
            put("1275055", 10);
            put("1275060", 11);
            put("1275378", 12);
            put("1275381", 13);
            put("1275605", 14);
            put("1275609", 15);
            put("1275699", 16);
            put("1275850", 17);
            put("1276159", 18);
            put("1276427", 19);
            put("1277341", 20);
            put("1277350", 21);
            put("1277354", 22);
            put("1277360", 23);
            put("1277373", 24);
            put("1278212", 25);
            put("1279265", 26);
            put("1279863", 27);
            put("1281970", 28);
            put("1281978", 29);
            put("1282468", 30);
            put("1282983", 31);
            put("1283091", 32);
            put("1283242", 33);
            put("1284864", 34);
            put("1284891", 35);
            put("1284979", 36);
            put("1288586", 37);
            put("1289618", 38);
            put("1289633", 39);
            put("1289641", 40);
            put("1289642", 41);
            put("1291079", 42);
            put("1307098", 43);
            put("1307103", 44);
            put("1308055", 45);
            put("1310272", 46);
            put("1310276", 47);
            put("1311366", 48);
            put("1316217", 49);
            put("1323164", 50);
            put("1333414", 51);
            put("1343852", 52);
            put("1345203", 53);
            put("1345206", 54);
            put("1345801", 55);
            put("1347029", 56);
            put("1348464", 57);
            put("1348469", 58);
            put("1348589", 59);
            put("1348767", 60);
            put("1351397", 61);
            put("1362094", 62);
            put("1392855", 63);
            put("1399467", 64);
            put("1457705", 65);
            put("1506926", 66);
            put("1509530", 67);
            put("1652670", 68);
            put("1657117", 69);
            put("1657120", 70);
            put("1786669", 71);
            put("1791134", 72);
            put("1887279", 73);
            put("2289121", 74);
            put("2289182", 75);
            put("2289191", 76);
            put("2289194", 77);
            put("2289198", 78);
            put("2400701", 79);
            put("2422552", 80);
            put("2423962", 81);
            put("2425625", 82);
            put("2454957", 83);
            put("2456790", 84);
            put("2456802", 85);
            put("2456895", 86);
            put("2466968", 87);
            put("2469508", 88);
            put("2485369", 89);
            put("2577550", 90);
            put("2818641", 91);
            put("2820598", 92);
            put("2821045", 93);
            put("2821232", 94);
            put("2821234", 95);
            put("2823069", 96);
            put("2824674", 97);
            put("2825127", 98);
            put("2825132", 99);
            put("2825152", 100);
            put("2825153", 101);
            put("2825156", 102);
            put("2825165", 103);
            put("2825674", 104);
            put("2828097", 105);
            put("2829161", 106);
            put("2829647", 107);
            put("2830002", 108);
            put("2830311", 109);
            put("2830346", 110);
            put("2830613", 111);
            put("2830805", 112);
            put("2831234", 113);
            put("2831373", 114);
            put("2831480", 115);
            put("2832492", 116);
            put("2833635", 117);
            put("2834198", 118);
            put("2834248", 119);
            put("2834252", 120);
            put("2834254", 121);
            put("2834359", 122);
            put("2834697", 123);
            put("2834810", 124);
            put("2834931", 125);
            put("2835040", 126);
            put("2835116", 127);
            put("2835117", 128);
            put("2835164", 129);
            put("2835165", 130);
            put("2835495", 131);
            put("2835521", 132);
            put("2835645", 133);
            put("2835728", 134);
            put("2835738", 135);
            put("2835744", 136);
            put("2836094", 137);
            put("2836607", 138);
            put("2836677", 139);
            put("2837050", 140);
            put("2837679", 141);
            put("2837825", 142);
            put("2838438", 143);
            put("2838626", 144);
            put("2838627", 145);
            put("2838628", 146);
            put("2838680", 147);
            put("2839215", 148);
            put("2839217", 149);
            put("2839264", 150);
            put("2839388", 151);
            put("2840307", 152);
            put("2840460", 153);
            put("2840461", 154);
            put("2840492", 155);
            put("2840499", 156);
            put("2840500", 157);
            put("2840501", 158);
            put("2840502", 159);
            put("2840504", 160);
            put("2840944", 161);
            put("2841365", 162);
            put("2841425", 163);
            put("2841426", 164);
            put("2844458", 165);
            put("2844459", 166);
            put("2844461", 167);
            put("2844477", 168);
            put("2844488", 169);
            put("2844489", 170);
            put("2845047", 171);
            put("2847235", 172);
            put("2847874", 173);
            put("2847916", 174);
            put("2848190", 175);
            put("2848215", 176);
            put("2848229", 177);
            put("2848330", 178);
            put("2849576", 179);
            put("2850987", 180);
            put("2859501", 181);
            put("2859502", 182);
            put("2859503", 183);
            put("2859504", 184);
            put("2859505", 185);
            put("2859506", 186);
            put("2859507", 187);
            put("2859508", 188);
            put("2859509", 189);
            put("2859510", 190);
            put("2859511", 191);
            put("2859512", 192);
            put("2859513", 193);
            put("2859588", 194);
            put("2859785", 195);
            put("2860991", 196);
            put("2860992", 197);
            put("2923465", 198);
            put("2923466", 199);
            put("2924524", 200);
            put("2924526", 201);
            put("2924527", 202);
            put("2924539", 203);
            put("2924541", 204);
            put("2924542", 205);
            put("2924543", 206);
            put("2924965", 207);
            put("2924966", 208);
            put("2924967", 209);
            put("2924968", 210);
            put("2924969", 211);
            put("2924970", 212);
        }
    };
    // 视频频道编码 videoChannel
    public static Map<String, Integer> videoChannelCodes = new HashMap<String, Integer>() {
        {
            put("aiqiyi--1", 0);
            put("aiqiyi-0", 1);
            put("aiqiyi-1", 2);
            put("aiqiyi-10", 3);
            put("aiqiyi-11", 4);
            put("aiqiyi-12", 5);
            put("aiqiyi-13", 6);
            put("aiqiyi-14", 7);
            put("aiqiyi-15", 8);
            put("aiqiyi-16", 9);
            put("aiqiyi-17", 10);
            put("aiqiyi-18", 11);
            put("aiqiyi-19", 12);
            put("aiqiyi-2", 13);
            put("aiqiyi-20", 14);
            put("aiqiyi-21", 15);
            put("aiqiyi-22", 16);
            put("aiqiyi-23", 17);
            put("aiqiyi-24", 18);
            put("aiqiyi-25", 19);
            put("aiqiyi-26", 20);
            put("aiqiyi-27", 21);
            put("aiqiyi-28", 22);
            put("aiqiyi-29", 23);
            put("aiqiyi-3", 24);
            put("aiqiyi-30", 25);
            put("aiqiyi-30003", 26);
            put("aiqiyi-30005", 27);
            put("aiqiyi-30008", 28);
            put("aiqiyi-30010", 29);
            put("aiqiyi-31", 30);
            put("aiqiyi-32", 31);
            put("aiqiyi-33", 32);
            put("aiqiyi-34", 33);
            put("aiqiyi-4", 34);
            put("aiqiyi-40004", 35);
            put("aiqiyi-49999", 36);
            put("aiqiyi-5", 37);
            put("aiqiyi-6", 38);
            put("aiqiyi-7", 39);
            put("aiqiyi-8", 40);
            put("aiqiyi-9", 41);
            put("aiqiyi-97", 42);
            put("aiqiyi-99", 43);
            put("mango-0", 44);
            put("mango-1", 45);
            put("mango-105", 46);
            put("mango-111", 47);
            put("mango-116", 48);
            put("mango-117", 49);
            put("mango-120", 50);
            put("mango-2", 51);
            put("mango-20", 52);
            put("mango-3", 53);
            put("mango-50", 54);
        }
    };
    // 颜色编码
    public static Map<String, Integer> colorCodes = new HashMap<String, Integer>() {
        {
            put("color0_r", 0);
            put("color0_g", 1);
            put("color0_b", 2);
            put("color1_r", 3);
            put("color1_g", 4);
            put("color1_b", 5);
            put("color2_r", 6);
            put("color2_g", 7);
            put("color2_b", 8);
        }
    };
    // 广告主编码
    public static Map<String, Integer> accountCodes = new HashMap<String, Integer>() {
        {
            put("18125", 0);
            put("18943", 1);
            put("22005", 2);
            put("21563", 3);
            put("17196", 4);
            put("29815", 5);
            put("27419", 6);
            put("25874", 7);
            put("30539", 8);
            put("27295", 9);
            put("30037", 10);
            put("24035", 11);
            put("23882", 12);
            put("29932", 13);
            put("19317", 14);
            put("10971", 15);
            put("27486", 16);
            put("12311", 17);
            put("22597", 18);
            put("21330", 19);
            put("26598", 20);
            put("30371", 21);
            put("19941", 22);
            put("27605", 23);
            put("17270", 24);
            put("12234", 25);
            put("17878", 26);
            put("28257", 27);
            put("30632", 28);
            put("25991", 29);
            put("30701", 30);
            put("30336", 31);
            put("12796", 32);
            put("29379", 33);
            put("30495", 34);
            put("29758", 35);
            put("19316", 36);
            put("14355", 37);
            put("29001", 38);
            put("30126", 39);
            put("30892", 40);
            put("26320", 41);
            put("18489", 42);
            put("14164", 43);
            put("24696", 44);
            put("28941", 45);
            put("30511", 46);
            put("5713", 47);
            put("30928", 48);
            put("19761", 49);
            put("30592", 50);
            put("30081", 51);
            put("28769", 52);
            put("29788", 53);
            put("21133", 54);
            put("30679", 55);
            put("30393", 56);
            put("26323", 57);
            put("29336", 58);
            put("29935", 59);
            put("29030", 60);
            put("26550", 61);
            put("30394", 62);
            put("30823", 63);
            put("28466", 64);
            put("8340", 65);
            put("30460", 66);
            put("30739", 67);
            put("26048", 68);
            put("30765", 69);
            put("30596", 70);
            put("25809", 71);
            put("30808", 72);
            put("30605", 73);
            put("27165", 74);
            put("30868", 75);
            put("30518", 76);
            put("29408", 77);
            put("30601", 78);
            put("30900", 79);
            put("25984", 80);
            put("27568", 81);
            put("23937", 82);
            put("15334", 83);
            put("30345", 84);
            put("26595", 85);
            put("8154", 86);
            put("28264", 87);
            put("30848", 88);
            put("13566", 89);
            put("26726", 90);
            put("8302", 91);
            put("29406", 92);
            put("16315", 93);
            put("30625", 94);
            put("20619", 95);
            put("28528", 96);
            put("30253", 97);
            put("29808", 98);
            put("30809", 99);
            put("6286", 100);
            put("22757", 101);
            put("9876", 102);
            put("24779", 103);
            put("25806", 104);
            put("30929", 105);
            put("30956", 106);
            put("30691", 107);
            put("29706", 108);
            put("29651", 109);
            put("30438", 110);
            put("27911", 111);
            put("30493", 112);
            put("29519", 113);
            put("30220", 114);
            put("30812", 115);
            put("27684", 116);
            put("30636", 117);
            put("17638", 118);
            put("28594", 119);
            put("29558", 120);
            put("27463", 121);
            put("28925", 122);
            put("28420", 123);
            put("30099", 124);
            put("28523", 125);
            put("30688", 126);
            put("28432", 127);
            put("18028", 128);
            put("6209", 129);
            put("30783", 130);
            put("22412", 131);
            put("30684", 132);
            put("30621", 133);
            put("30734", 134);
            put("30807", 135);
            put("30794", 136);
            put("28180", 137);
            put("28544", 138);
            put("30186", 139);
            put("24090", 140);
            put("30111", 141);
            put("8657", 142);
            put("23977", 143);
            put("29491", 144);
            put("30327", 145);
            put("30249", 146);
            put("23461", 147);
            put("28597", 148);
            put("30498", 149);
            put("30109", 150);
            put("30279", 151);
            put("30100", 152);
            put("30732", 153);
            put("23031", 154);
            put("30497", 155);
            put("25886", 156);
            put("27453", 157);
            put("29845", 158);
            put("30378", 159);
            put("30257", 160);
            put("28881", 161);
            put("27241", 162);
            put("30219", 163);
            put("22006", 164);
            put("30217", 165);
            put("25215", 166);
            put("19217", 167);
            put("28515", 168);
            put("30185", 169);
            put("29858", 170);
            put("27452", 171);
            put("18089", 172);
            put("30411", 173);
            put("26151", 174);
            put("29699", 175);
            put("29889", 176);
            put("30573", 177);
            put("30017", 178);
            put("2292", 179);
            put("29427", 180);
            put("30560", 181);
            put("30626", 182);
            put("28628", 183);
            put("29534", 184);
            put("30515", 185);
            put("30023", 186);
            put("30374", 187);
            put("21271", 188);
            put("27321", 189);
            put("30290", 190);
            put("28643", 191);
            put("14356", 192);
            put("23880", 193);
            put("30836", 194);
            put("30569", 195);
            put("29900", 196);
            put("29879", 197);
            put("30499", 198);
            put("29894", 199);
            put("28970", 200);
            put("21944", 201);
            put("30705", 202);
            put("30187", 203);
            put("28503", 204);
            put("29028", 205);
            put("30128", 206);
            put("30182", 207);
            put("30237", 208);
            put("29448", 209);
            put("30825", 210);
            put("27884", 211);
            put("27932", 212);
            put("30704", 213);
            put("30695", 214);
            put("30461", 215);
            put("30218", 216);
            put("29862", 217);
            put("25509", 218);
            put("30329", 219);
            put("26077", 220);
            put("25495", 221);
            put("30115", 222);
            put("27002", 223);
            put("30935", 224);
            put("23469", 225);
            put("30331", 226);
            put("30188", 227);
            put("24296", 228);
            put("22042", 229);
            put("7962", 230);
            put("323", 231);
            put("30272", 232);
            put("18071", 233);
            put("18072", 234);
            put("8220", 235);
            put("8331", 236);
            put("23680", 237);
            put("6419", 238);
        }
    };
    // 价格区间编码
    public static Map<String, Integer> priceCodes = new HashMap<String, Integer>() {
        {
            put("0", 0);
            put("1", 1);
            put("2", 2);
            put("3", 3);
            put("4", 4);
            put("5", 5);
            put("6", 6);
            put("7", 7);
        }
    };

    public static Map<String, String> generateFeatureMapStatic(FeatureDo cf) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        try {
            if (cf != null) {


                cf.setCurrentGmtCreateTime(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));

//                retMap.put("f101001", MyStringUtil2.Long2String(cf.getAdvertId()));

//                retMap.put("f106001", MyStringUtil2.Long2String(cf.getAccountId()));
                retMap.put("f108001", DataUtil.Long2String(cf.getSlotId()));
//                retMap.put("f108002", DataUtil.Long2String(cf.getSlotId()));
                retMap.put("f108003", DataUtil.Long2String(cf.getSlotId()));
                retMap.put("f109001", DataUtil.Integer2String(cf.getSlotType()));

                retMap.put("f201001", DataUtil.Long2String(cf.getAppId()));
                retMap.put("f202001", cf.getAppCategory());

                // 广告场景
                retMap.put("f122003", DataUtil.Integer2String(cf.getSceneType()));

                // 联盟流量中的媒体ID
                String appId = DataUtil.Long2String(cf.getAppId());
                String unionAppId = cf.getUnionAppId();
                retMap.put("f2010012", unionAppId == null || unionAppId.trim().equals("") ? appId : appId + "_" + unionAppId);

                retMap.put("f301001", DataUtil.Long2String(cf.getOperatingActivityId()));
                retMap.put("f302001", DataUtil.Long2String(cf.getActivityId()));
                retMap.put("f306001", DataUtil.Long2String(cf.getActivityType()));


                retMap.put("f360001", cf.getEntrancePrizeID1());
                retMap.put("f360002", cf.getEntrancePrizeID2());
                retMap.put("f360003", cf.getEntrancePrizeID3());
                retMap.put("f360004", cf.getEntrancePrizeID4());
                retMap.put("f360005", cf.getActivitySourceType());
                retMap.put("f360006", cf.getLaunchSourceType());

                retMap.put("f390000", cf.getMaterailID());

                retMap.put("f501001", cf.getUa());

                Integer hour = LocalDateUtil.getHour(cf.getCurrentGmtCreateTime(), DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());

                retMap.put("f502001", DataUtil.Integer2String(hour));
                Integer minute = LocalDateUtil.getMinute(cf.getCurrentGmtCreateTime(), DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());

                retMap.put("f502004", DataUtil.Integer2String(minute));

//                Integer weekDay = DateUtil.getWeekNumber(cf.getCurrentGmtCreateTime(), DateStyle.YYYY_MM_DD_HH_MM_SS);
                Integer weekDay = LocalDateUtil.getDayOfWeek(cf.getCurrentGmtCreateTime(), DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());

                retMap.put("f502002", DataUtil.Integer2String(weekDay));
                retMap.put("f503001", DataUtil.Long2String(cf.getCityId()));

                // 用户行为数据
                UserActFeature userActFeature = Optional.ofNullable(cf.getUserActFeature()).orElse(new UserActFeature());

                // rank 转level
                retMap.put("f601001", DataUtil.Long2String(getDayRankLevel(cf.getDayOrderRank())));
                retMap.put("f602001", DataUtil.Long2String(getRankLevel(cf.getOrderRank())));
                retMap.put("f603001", DataUtil.Long2String(getDayRankLevel(cf.getDayActivityOrderRank())));
                retMap.put("f604001", DataUtil.Long2String(getRankLevel(cf.getActivityOrderRank())));


                // 计算时间差
                Long orderGmtIntervelLevel =
                        getOrderGmtIntervelLevel(cf.getCurrentGmtCreateTime(), cf.getLastGmtCreateTime());
                retMap.put("f605001", DataUtil.Long2String(orderGmtIntervelLevel));

                // 计算活动时间差
                Long activityOrderGmtIntervelLevel =
                        getOrderGmtIntervelLevel(cf.getCurrentGmtCreateTime(), cf.getActivityLastGmtCreateTime());
                retMap.put("f606001", DataUtil.Long2String(activityOrderGmtIntervelLevel));

                // 计算活动上次计费情况
                Long activityLastChargeStatus = getChargeStatus(cf.getActivityLastChargeNums());
                retMap.put("f607001", DataUtil.Long2String(activityLastChargeStatus));

                // 计算上次计费情况
                Long lastChargeStatus = getChargeStatus(cf.getLastChargeNums());
                retMap.put("f608001", DataUtil.Long2String(lastChargeStatus));

                //计算上次与当期活动是否相同
                Long activityChangeStatus = getActivityChangeStatus(cf.getOperatingActivityId(), cf.getLastOperatingActivityId());
                retMap.put("f609001", DataUtil.Long2String(activityChangeStatus));


                //
//                String crossAppAndAdvertID = "" + cf.getAdvertId() + cf.getAppId();
//                retMap.put("cf101201", crossAppAndAdvertID);
                //
//                String crossActivityAndAdvertID = "" + cf.getAdvertId() + cf.getOperatingActivityId();
//                retMap.put("cf101301", crossActivityAndAdvertID);


                // 20170602
                // 设备型号
                retMap.put("f504001", cf.getModel());
                // 设备价格区间
                retMap.put("f505001", cf.getPriceSection());
                // 网络类型（2G，3G，4G）
                retMap.put("f506001", cf.getConnectionType());
                // 运营商（中国联通，中国移动，中国电信）
                retMap.put("f507001", cf.getOperatorType());


                // 设备信息新增，20200721
                retMap.put("f508003", cf.getPhoneBrand());
                retMap.put("f508004", cf.getPhoneModelNum());

                retMap.put("f508005", cf.getBrandName());
                retMap.put("f508006", cf.getDeviceTrademark());

                retMap.put("f507003", cf.getOsVersion());

                // 设备信息新增，20210727
                retMap.put("f509001", cf.getPhoneModelCode());
                retMap.put("f509002", cf.getBrandNameEn());
                retMap.put("f509003", cf.getPhonePriceLevel());
                retMap.put("f509004", DataUtil.Integer2String(cf.getFirstShowTime()));
                retMap.put("f509005", DataUtil.Integer2String(cf.getDmplspCustom()));
                retMap.put("f509006", cf.getPhoneOs());


                // 发券次序，该用户当日发券次数
                retMap.put("f611001", DataUtil.Long2String(cf.getPutIndex()));
                // 活动来源
                retMap.put("f303001", cf.getActivityUseType());
                // 	会员id  cvr
                retMap.put("f403001", cf.getMemberId());
                // 手机号  cvr
                retMap.put("f403005", cf.getMobile());


                // 是否老用户  注册距离最近登录时间大于1天  cvr
                Long iso = isOld(cf.getUserLastlogbigintime(), cf.getUserRegtime());
                retMap.put("f403004", DataUtil.Long2String(iso));


                // 广告位标签
                retMap.put("f114001", cf.getSlotIndustryTagPid());
                retMap.put("f114002", cf.getSlotIndustryTagId());
                // 媒体标签
                retMap.put("f205001", cf.getAppIndustryTagPid());
                retMap.put("f205002", cf.getAppIndustryTagId());

                // 流量标签
                retMap.put("f206001", cf.getTrafficTagPid());
                retMap.put("f206002", cf.getTrafficTagId());

                // 流量类型
                retMap.put("f206003", cf.getSlotAccessType());
                retMap.put("f206004", cf.getMmoTag());

                //
                retMap.put("f9902", cf.getAppList2());
                retMap.put("f9906", cf.getCategoryIdList1());
                retMap.put("f9907", cf.getCategoryIdList2());
                retMap.put("f9908", cf.getIsGame());

                // 20180123
                retMap.put("f508001", cf.getPhoneBrand());
                retMap.put("f508002", cf.getPhoneModelNum());


                // 20180223
                retMap.put("f9914", cf.getImportantApp());
                retMap.put("f9915", cf.getClusterId());


                //20180306
                retMap.put("f9916", getLevel("launch_pv", cf.getUIIds(), cf.getUILaunchPV()));
                retMap.put("f9917", getLevel("click_pv", cf.getUIIds(), cf.getUIClickPv()));
                retMap.put("f9918", getLevel("effect_pv", cf.getUIIds(), cf.getUIEffectPv()));
                retMap.put("f9919", getLevel("score", cf.getUIIds(), cf.getUIScore()));

                // 20210511 OneId用户行为
                retMap.put("f99161", getLevel("launch_pv", userActFeature.getOUIIds(), userActFeature.getOUILaunchPV()));
                retMap.put("f99171", getLevel("click_pv", userActFeature.getOUIIds(), userActFeature.getOUIClickPv()));
                retMap.put("f99181", getLevel("effect_pv", userActFeature.getOUIIds(), userActFeature.getOUIEffectPv()));


                retMap.put("f9921", cf.getUICtr());
                retMap.put("f9922", cf.getUICvr());
                retMap.put("f9923", cf.getUUnICtr());
                retMap.put("f9924", cf.getUUnICvr());

                retMap.put("f9927", countFeatures(cf.getUICtr()) + "");
                retMap.put("f9928", countFeatures(cf.getUICvr()) + "");
                retMap.put("f9929", countFeatures(cf.getUUnICtr()) + "");
                retMap.put("f9930", countFeatures(cf.getUUnICvr()) + "");


                // 20180314
                retMap.put("f404001", cf.getSex());
                retMap.put("f404002", cf.getAge());
                retMap.put("f404003", cf.getWorkStatus());
                retMap.put("f404004", cf.getStudentStatus());
                retMap.put("f404005", cf.getMarriageStatus());
                retMap.put("f404006", cf.getBear());
                retMap.put("f404007", cf.getInterestList());


                // 20180423，用户行为数据
                retMap.put("f601002", DataUtil.Long2String(bucket(cf.getDayOrderRank(), dayOrderRankBucket)));
                retMap.put("f602002", DataUtil.Long2String(bucket(cf.getOrderRank(), orderRankBucket)));
                retMap.put("f603002", DataUtil.Long2String(bucket(cf.getDayActivityOrderRank(), dayActOrderRankBucket)));
                retMap.put("f604002", DataUtil.Long2String(bucket(cf.getActivityOrderRank(), orderActRankBucket)));

                Long orderGmtIntervel =
                        getOrderGmtIntervel(cf.getCurrentGmtCreateTime(), cf.getLastGmtCreateTime());
                retMap.put("f605002", DataUtil.Long2String(bucket(orderGmtIntervel, orderGmtIntervelBucket)));

                // 计算活动时间差
                Long activityOrderGmtIntervel =
                        getOrderGmtIntervel(cf.getCurrentGmtCreateTime(), cf.getActivityLastGmtCreateTime());
                retMap.put("f606002", DataUtil.Long2String(bucket(activityOrderGmtIntervel, orderActGmtIntervelBucket)));


                // 20210623 OneID用户行为数据
                retMap.put("f6010021", DataUtil.Long2String(bucket(userActFeature.getTodayLaunch(), dayOrderRankBucket)));
                retMap.put("f6020021", DataUtil.Long2String(bucket(userActFeature.getHistoryLaunch(), orderRankBucket)));
                retMap.put("f6030021", DataUtil.Long2String(bucket(userActFeature.getTodayActivityLaunch(), dayActOrderRankBucket)));
                retMap.put("f6040021", DataUtil.Long2String(bucket(userActFeature.getHistoryActivityLaunch(), orderActRankBucket)));
                Long orderGmtIntervelOneId =
                        getOrderGmtIntervel(cf.getCurrentGmtCreateTime(), userActFeature.getLastLaunchTime());
                retMap.put("f6050021", DataUtil.Long2String(bucket(orderGmtIntervelOneId, orderGmtIntervelBucket)));
                Long activityOrderGmtIntervelOneId =
                        getOrderGmtIntervel(cf.getCurrentGmtCreateTime(), userActFeature.getLastActivityLaunchTime());
                retMap.put("f6060021", DataUtil.Long2String(bucket(activityOrderGmtIntervelOneId, orderActGmtIntervelBucket)));

                Long activityLastChargeStatusOneID = getMatchStatus(userActFeature.getLastActivityLaunchOrder(), userActFeature.getLastActivityClickOrder());
                retMap.put("f6070011", DataUtil.Long2String(activityLastChargeStatusOneID));
                Long lastChargeStatusOneID = getMatchStatus(userActFeature.getLastLaunchOrder(), userActFeature.getLastClickOrder());
                retMap.put("f6080011", DataUtil.Long2String(lastChargeStatusOneID));

                Long activityChangeStatusOneID = getMatchStatus(DataUtil.Long2String(cf.getOperatingActivityId()), userActFeature.getLastActivity());
                retMap.put("f6090011", DataUtil.Long2String(activityChangeStatusOneID));

                Long tagChangeStatusOneID = getLastTagChangeStatus(cf.getMatchTagNums(), userActFeature.getLastAdvertMatchTag());
                retMap.put("f6100011", DataUtil.Long2String(tagChangeStatusOneID));




                // 20180424  添加安装列表类别及数目特征
                retMap.put("f9925", categoryIdAndCnt(cf.getCategory1idCntList(), 1));
                retMap.put("f9926", categoryIdAndCnt(cf.getCategory2idCntList(), 2));

                // 20180423
                Map<String, Map<String, Long>> ubpMap = getUserBehavioralPreference(
                        cf.getUIIds(), cf.getUILaunchPV(), cf.getUIClickPv(), cf.getUIEffectPv());

//                System.out.println("ubpMap="+JSON.toJSONString(ubpMap));
                ///全局
                retMap.put("f809001", getUserBehavioralPreference(0, "ctr", ubpMap, null));
                retMap.put("f809002", getUserBehavioralPreference(0, "cvr", ubpMap, null));

                //行业
                retMap.put("f808001", getUserBehavioralPreference(2, "ctr", ubpMap, null));
                retMap.put("f808002", getUserBehavioralPreference(2, "cvr", ubpMap, null));

                //统计
                retMap.put("f811001", getUserBehavioralPreference(3, "ctr", ubpMap, null));
                retMap.put("f811002", getUserBehavioralPreference(3, "cvr", ubpMap, null));

                cf.setUbpMap(ubpMap);

                // 20210511 OneId用户行为
                Map<String, Map<String, Long>> oUbpMap = getUserBehavioralPreference(
                        userActFeature.getOUIIds(), userActFeature.getOUILaunchPV(), userActFeature.getOUIClickPv(), userActFeature.getOUIEffectPv());
                ///全局
                retMap.put("f8090011", getUserBehavioralPreference(0, "ctr", oUbpMap, null));
                retMap.put("f8090021", getUserBehavioralPreference(0, "cvr", oUbpMap, null));

                //行业
                retMap.put("f8080011", getUserBehavioralPreference(2, "ctr", oUbpMap, null));
                retMap.put("f8080021", getUserBehavioralPreference(2, "cvr", oUbpMap, null));

                //统计
                retMap.put("f8110011", getUserBehavioralPreference(3, "ctr", oUbpMap, null));
                retMap.put("f8110021", getUserBehavioralPreference(3, "cvr", oUbpMap, null));

                cf.setOUbpMap(oUbpMap);
                cf.setOTradeLaunchMap(getMap(userActFeature.getOUIIds(), userActFeature.getOUILaunchPV()));
                cf.setOTradeClickMap(getMap(userActFeature.getOUIIds(), userActFeature.getOUIClickPv()));
                cf.setOTradeConvertMap(getMap(userActFeature.getOUIIds(), userActFeature.getOUIEffectPv()));

                //20180815 媒体行业标签,广告位尺寸标签
                retMap.put("f406001", getSlotAreaType(cf.getSlotHeight(), cf.getSlotWidth()));
                retMap.put("f406002", DataUtil.Long2String(cf.getMediaTag1())); //媒体行业标签1
                retMap.put("f406003", DataUtil.Long2String(cf.getMediaTag2())); //媒体行业标签2


                //20180902活动聚类特征
                retMap.put("f9934", DataUtil.Long2String(cf.getPerformance()));
                retMap.put("f9931", DataUtil.Long2String(cf.getLaunchInfo())); //活动聚类特征1
                retMap.put("f9932", DataUtil.Long2String(cf.getBasicInfo())); //活动聚类特征2
                retMap.put("f9933", DataUtil.Long2String(cf.getTotalInfo())); //活动聚类特征2

                //20200114 用户基础标签
                retMap.put("f9701", cf.getUserBasicTags());

                //20200211 短信签名列表
                retMap.put("f9801", cf.getSigList());

                //20200227
                retMap.put("f9903", FeatureBaseParse.getLengthLevel(cf.getAppList2(), 5, 100, 5)); // app安装列表长度
                retMap.put("f9802", FeatureBaseParse.getLengthLevel(cf.getSigList(), 15, 1)); // 短信签名列表长度
                retMap.put("f9702", FeatureBaseParse.getLengthLevel(cf.getUserBasicTags(), 50, 5)); // 用户基础标签长度


                //展示广告特征
                retMap.put("f8801", DataUtil.Long2String(cf.getCurrentDayLaunchIndex()));
                retMap.put("f8802", DataUtil.Long2String(cf.getCurrentDayLaunchBatch()));
                retMap.put("f8803", DataUtil.Long2String(cf.getAlgStartPosition()));
                retMap.put("f8804", DataUtil.Long2String(cf.getDayLastLaunchIndexAdLaunchCnt()));
                retMap.put("f8805", DataUtil.Long2String(cf.getDayLaunchIndexAdExportCnt()));
                retMap.put("f8806", DataUtil.Long2String(cf.getDayLaunchIndexAdClickCnt()));


                //20190507广告&媒体偏好画像特征
                //媒体行业在不同广告行业上的ctr,cvr(分桶)
                String appTagInNewTradeCtr = getStatInNewTrade("ctr", cf.getAppTagInNewTrade());
                retMap.put("f550101", appTagInNewTradeCtr);
                String appTagInNewTradeCvr = getStatInNewTrade("cvr", cf.getAppTagInNewTrade());
                retMap.put("f550102", appTagInNewTradeCvr);

                //媒体在不同广告行业上的ctr,cvr(分桶)
                String appInNewTradeCtr = getStatInNewTrade("ctr", cf.getAppInNewTrade());
                retMap.put("f550301", appInNewTradeCtr);
                String appInNewTradeCvr = getStatInNewTrade("cvr", cf.getAppInNewTrade());
                retMap.put("f550302", appInNewTradeCvr);


                //20190906活动用户标签(蒙层）
                retMap.put("f404100", DataUtil.Integer2String(cf.getLayerGender()));
                retMap.put("f404101", DataUtil.Integer2String(cf.getLayerIsStudent()));

                //20191023用户行为序 点击
                retMap.put("f830001", cf.getClickAdIds());
                retMap.put("f830002", cf.getClickAcIds());
                retMap.put("f830003", cf.getClickReIds());
                retMap.put("f830004", cf.getClickTrIds());
                retMap.put("f830011", cf.getConvAdIds() == null ? "null" : cf.getConvAdIds().toString());
                retMap.put("f830012", cf.getConvAcIds() == null ? "null" : cf.getConvAcIds().toString());
                retMap.put("f830013", cf.getConvReIds() == null ? "null" : cf.getConvReIds().toString());
                retMap.put("f830014", cf.getConvTrIds() == null ? "null" : cf.getConvTrIds().toString());

                // 用户曝光序列
                retMap.put("f833002", cf.getExposeAdIds());

                // 用户行为序 deviceId 转化
                retMap.put("f831001", cf.getConvertAdverts());
                retMap.put("f831002", cf.getConvertAccounts());
                retMap.put("f831003", cf.getConvertResources());
                retMap.put("f831004", cf.getConvertTrades());

                // 后端
                retMap.put("f832001", cf.getBConvertAdverts());
                retMap.put("f832002", cf.getBConvertAccounts());
                retMap.put("f832003", cf.getBConvertResources());
                retMap.put("f832004", cf.getBConvertTrades());


                if (cf.getExposeAdIds() != null) {
                    // 用户曝光未点击行为
                    Set<String> clickAdIds = new HashSet<>();
                    if (cf.getClickAcIds() != null) {
                        if (cf.getClickAdIds() != null) {
                            Collections.addAll(clickAdIds, cf.getClickAdIds().split(","));
                        }
                        List<String> exposeNotClickList = new ArrayList<>();
                        for (String adIds : cf.getExposeAdIds().split(",")) {
                            if (!clickAdIds.contains(adIds)) {
                                exposeNotClickList.add(adIds);
                            }
                        }
                        retMap.put("f833001", String.join(",", exposeNotClickList));
                    }
                }

                // 20210623 OneID用户行为集合数据
                retMap.put("f8330011", setJoin(getSetSubtract(userActFeature.getAdvertExposureSet(), userActFeature.getAdvertClickSet()), ","));
                retMap.put("f8330021", setJoin(userActFeature.getAdvertExposureSet(), ","));

                retMap.put("f8300011", setJoin(userActFeature.getAdvertClickSet(), ","));
                retMap.put("f8300021", setJoin(userActFeature.getAccountClickSet(), ","));
                retMap.put("f8300031", setJoin(userActFeature.getResourceClickSet(), ","));
                retMap.put("f8300041", setJoin(userActFeature.getTradeClickSet(), ","));

                retMap.put("f8310011", setJoin(userActFeature.getAdvertEffectSet(), ","));
                retMap.put("f8310021", setJoin(userActFeature.getAccountEffectSet(), ","));
                retMap.put("f8310031", setJoin(userActFeature.getResourceEffectSet(), ","));
                retMap.put("f8310041", setJoin(userActFeature.getTradeEffectSet(), ","));

                //20200303dmp特征加工
                DmpFeature dmpFeature = Optional.ofNullable(cf.getDmpFeature()).orElse(new DmpFeature());

                retMap.put("f9935", dmpFeature.getValidAppList());
                retMap.put("f9936", dmpFeature.getTopAppList());
                retMap.put("f9937", dmpFeature.getMidAppList());
                retMap.put("f9938", dmpFeature.getInstallAppList());
                retMap.put("f9939", dmpFeature.getUninstallAppList());

                String appCategoryLevel = FeatureBaseParse.getCategoryLevel(dmpFeature.getAppCategory(), 10, 1);
                retMap.put("f9940", appCategoryLevel);

                retMap.put("f9941", dmpFeature.getTradeAppList());//
//                retMap.put("f9942", dmpFeature.getAppVector());

                String appVectorLevel = FeatureBaseParse.getAppVectorLevel(dmpFeature.getAppVector(), 200);
                retMap.put("f9942", appVectorLevel);


                retMap.put("f9943", dmpFeature.getTopAppList2());
                retMap.put("f9944", dmpFeature.getTopAppList3());

//                String msgCategoryLevel = FeatureBaseParse.getCategoryLevel(dmpFeature.getMsgCategory(),10,1);
//                retMap.put("f9803", msgCategoryLevel);
                retMap.put("f9803", dmpFeature.getMsgCategory());
                retMap.put("f9804", dmpFeature.getMsgKeyword());
//                retMap.put("f9805", dmpFeature.getMsgVector());
                String msgVectorLevel = FeatureBaseParse.getAppVectorLevel(dmpFeature.getMsgVector(), 200);
                retMap.put("f9805", msgVectorLevel);


                // 20201030 爱奇艺RTA标签
                retMap.put("f451011", cf.getAqyGender());
                retMap.put("f451012", cf.getAqyAge());

                // 20210801 百度兴趣标签
                retMap.put("f452001", cf.getBdGender());
                retMap.put("f452002", cf.getBdAge());
                retMap.put("f452011", cf.getBdFirstTag());
                retMap.put("f452012", cf.getBdSecondTag());
                retMap.put("f452013", cf.getBdThirdTag());
                retMap.put("f452014", cf.getBdFourthTag());

                // 7.31
                // 8.26 缩减分桶数量 200 -> 20
                String msgListEmbed8Level = FeatureBaseParse.getAppVectorLevel2(dmpFeature.getmsgListEmbed8(), 20);
                retMap.put("f9806", msgListEmbed8Level);
                retMap.put("f9816", dmpFeature.getmsgListEmbed8());


                String appListEmbed32Level = FeatureBaseParse.getAppVectorLevel2(dmpFeature.getAppListEmbed32(), 20);
                retMap.put("f9807", appListEmbed32Level);
                retMap.put("f9817", dmpFeature.getAppListEmbed32());

//                retMap.put("f9703", dmpFeature.getTagCategory());

                //20200821 用户文本标签
                retMap.put("f9704", dmpFeature.getUserContentTags());

                // 20210301 ADX频道信息
                retMap.put("f9501", dmpFeature.getWeekChannelIds());
                retMap.put("f9502", dmpFeature.getHalfMonthChannelIds());
                retMap.put("f9503", dmpFeature.getHistoryChannelIds());
//
                //20200306媒体和后端类型交叉
                retMap.put("f701002", getAdAndSubType(cf.getAppId(), cf.getBankEndType()));


                // 生命周期
                retMap.put("f410001", bucket(userActFeature.getUserActiveDays(), cntBucket).toString());

                // 活动访问
                retMap.put("f411001", bucket(userActFeature.getActivityRequest(), cntBucket).toString());
                retMap.put("f411002", bucket(userActFeature.getWeekActivityRequest(), cntBucket).toString());
                retMap.put("f411003", bucket(userActFeature.getDayActivityRequest(), cntBucket).toString());
                retMap.put("f411004", bucket(userActFeature.getIntervalActivityRequest(), cntBucket).toString());
                retMap.put("f411005", userActFeature.getPeriodActivityRequest());

                // 活动参与412005
                retMap.put("f412001", bucket(userActFeature.getActivityJoin(), cntBucket).toString());
                retMap.put("f412002", bucket(userActFeature.getWeekActivityJoin(), cntBucket).toString());
                retMap.put("f412003", bucket(userActFeature.getDayActivityJoin(), cntBucket).toString());
                retMap.put("f412004", bucket(userActFeature.getIntervalActivityJoin(), cntBucket).toString());
                retMap.put("f412005", userActFeature.getPeriodActivityJoin());
                retMap.put("f412006", bucket(userActFeature.getActivityPageStay(), cntBucket).toString());

                // 发券
                JSONObject launchTradeActMap = DataUtil.stringToJson(userActFeature.getLaunchTrade());
                retMap.put("f413001", getUserCategoryActLevelByBucket(launchTradeActMap, tradeCodes, cntBucket));
                JSONObject weekLaunchTradeActMap = DataUtil.stringToJson(userActFeature.getWeekLaunchTrade());
                retMap.put("f413002", getUserCategoryActLevelByBucket(weekLaunchTradeActMap, tradeCodes, cntBucket));
                retMap.put("f413003", getUserCategoryActLevelByBucket(userActFeature.getDayLaunchTrade(), tradeCodes, cntBucket));
                retMap.put("f413004", bucket(userActFeature.getIntervalLaunchTrade(), cntBucket).toString());
                retMap.put("f413005", userActFeature.getPeriodLaunchTrade());
                retMap.put("f413006", bucket(userActFeature.getAvgLaunchStay(), cntBucket).toString());
                retMap.put("f413007", userActFeature.getLastLaunchTrade());
                retMap.put("f413008", userActFeature.getClickLaunchTrade() == null ? null : userActFeature.getClickLaunchTrade().toString());

                // 点击
                JSONObject clickTraceActMap = DataUtil.stringToJson(userActFeature.getClickTrade());
                retMap.put("f414001", getUserCategoryActLevelByBucket(clickTraceActMap, tradeCodes, cntBucket));
                JSONObject weekClickTradeActMap = DataUtil.stringToJson(userActFeature.getWeekClickTrade());
                retMap.put("f414002", getUserCategoryActLevelByBucket(weekClickTradeActMap, tradeCodes, cntBucket));
                retMap.put("f414003", getUserCategoryActLevelByBucket(userActFeature.getDayClickTrade(), tradeCodes, cntBucket));
                retMap.put("f414004", bucket(userActFeature.getIntervalClickTrade(), cntBucket).toString());
                retMap.put("f414005", userActFeature.getPeriodClickTrade());
                retMap.put("f414007", userActFeature.getLastClickTrade());
                retMap.put("f414008", userActFeature.getEffectClickTrade() == null ? null : userActFeature.getEffectClickTrade().toString());

                // 转化
                JSONObject effectTradeActMap = DataUtil.stringToJson(userActFeature.getEffectTrade());
                retMap.put("f415001", getUserCategoryActLevelByBucket(effectTradeActMap, tradeCodes, cntBucket));
                JSONObject weekEffectTradeActMap = DataUtil.stringToJson(userActFeature.getWeekEffectTrade());
                retMap.put("f415002", getUserCategoryActLevelByBucket(weekEffectTradeActMap, tradeCodes, cntBucket));
                retMap.put("f415003", getUserCategoryActLevelByBucket(userActFeature.getDayEffectTrade(), tradeCodes, cntBucket));
                retMap.put("f415004", bucket(userActFeature.getIntervalEffectTrade(), cntBucket).toString());
                retMap.put("f415005", userActFeature.getPeriodEffectTrade());
                retMap.put("f415007", userActFeature.getLastEffectTrade());

                // 用户画像特征解析
                UserProfileFeature userProfileFeature = Optional.ofNullable(cf.getUserProfileFeature()).orElse(new UserProfileFeature());

                // 基本属性
                retMap.put("f451001", userProfileFeature.getSex());
                retMap.put("f451002", userProfileFeature.getAge());
                retMap.put("f451003", userProfileFeature.getMarry());
                retMap.put("f451004", userProfileFeature.getConsumeLevel());
                retMap.put("f451005", userProfileFeature.getPermanentProvince());
                retMap.put("f451006", userProfileFeature.getPermanentCity());


                // 广告位维度流量特征
                SlotActFeature slotActFeature = Optional.ofNullable(cf.getSlotActFeature()).orElse(new SlotActFeature());
                // 发券
                JSONObject launchCntRatioTradeMap = DataUtil.stringToJson(slotActFeature.getLaunchCntRatioTrade());
                retMap.put("f210001", getUserCategoryActLevelByBucket(launchCntRatioTradeMap, tradeCodes, cntRatioBucket));
                JSONObject launchCntRatioAccountMap = DataUtil.stringToJson(slotActFeature.getLaunchCntRatioAccount());
                retMap.put("f210002", getUserCategoryActLevelByBucket(launchCntRatioAccountMap, accountCodes, cntRatioBucket));
                JSONObject weekLaunchCntRatioTradeMap = DataUtil.stringToJson(slotActFeature.getWeekLaunchCntRatioTrade());
                retMap.put("f210003", getUserCategoryActLevelByBucket(weekLaunchCntRatioTradeMap, tradeCodes, cntRatioBucket));
                JSONObject weekLaunchCntRatioAccountMap = DataUtil.stringToJson(slotActFeature.getWeekLaunchCntRatioAccount());
                retMap.put("f210004", getUserCategoryActLevelByBucket(weekLaunchCntRatioAccountMap, accountCodes, cntRatioBucket));

//                JSONObject weekExposeTradeCnt = DataUtil.stringToJson(slotActFeature.getWeekExposeTradeCnt());
//                retMap.put("f250001", getUserCategoryActLevelByBucket(weekExposeTradeCnt, tradeCodes, ));
//                JSONObject weekExposeAccountCnt = DataUtil.stringToJson(slotActFeature.getWeekExposeAccountCnt());
//                retMap.put("f250002", getUserCategoryActLevelByBucket(weekExposeAccountCnt, accountCodes, ));
//                JSONObject weekExposeAdvertCnt = DataUtil.stringToJson(slotActFeature.getWeekExposeAdvertCnt());
//                retMap.put("f250003", getUserCategoryActLevelByBucket(weekExposeAdvertCnt, , ));
//
//
//                JSONObject weekClickTradeCnt = DataUtil.stringToJson(slotActFeature.getWeekExposeTradeCnt());
//                retMap.put("f250101", getUserCategoryActLevelByBucket(weekClickTradeCnt, tradeCodes, ));
//                JSONObject weekClickAccountCnt = DataUtil.stringToJson(slotActFeature.getWeekExposeAccountCnt());
//                retMap.put("f250102", getUserCategoryActLevelByBucket(weekClickAccountCnt, accountCodes, ));
//                JSONObject weekClickAdvertCnt = DataUtil.stringToJson(slotActFeature.getWeekExposeAdvertCnt());
//                retMap.put("f250103", getUserCategoryActLevelByBucket(weekClickAdvertCnt, , ));
//
//
//                JSONObject weekConversionTradeCnt = DataUtil.stringToJson(slotActFeature.getWeekExposeTradeCnt());
//                retMap.put("f250201", getUserCategoryActLevelByBucket(weekConversionTradeCnt, tradeCodes, ));
//                JSONObject weekConversionAccountCnt = DataUtil.stringToJson(slotActFeature.getWeekExposeAccountCnt());
//                retMap.put("f250202", getUserCategoryActLevelByBucket(weekConversionAccountCnt, accountCodes, ));
//                JSONObject weekConversionAdvertCnt = DataUtil.stringToJson(slotActFeature.getWeekExposeAdvertCnt());
//                retMap.put("f250203", getUserCategoryActLevelByBucket(weekConversionAdvertCnt, , ));

                JSONObject weekClickTradeCnt = DataUtil.stringToJson(slotActFeature.getWeekClickTradeCnt());
                JSONObject weekConversionTradeCnt = DataUtil.stringToJson(slotActFeature.getWeekConversionTradeCnt());
                retMap.put("f250301", getCategoryLevelByCalcBucket(weekClickTradeCnt, weekConversionTradeCnt, tradeCodes, statCvrBucket));
                JSONObject weekClickAccountCnt = DataUtil.stringToJson(slotActFeature.getWeekClickAccountCnt());
                JSONObject weekConversionAccountCnt = DataUtil.stringToJson(slotActFeature.getWeekConversionAccountCnt());
                retMap.put("f250302", getCategoryLevelByCalcBucket(weekClickAccountCnt, weekConversionAccountCnt, accountCodes, statCvrBucket));


                // 点击
                JSONObject clickCntRatioTradeMap = DataUtil.stringToJson(slotActFeature.getClickCntRatioTrade());
                retMap.put("f211001", getUserCategoryActLevelByBucket(clickCntRatioTradeMap, tradeCodes, cntRatioBucket));
                JSONObject clickCntRatioAccountMap = DataUtil.stringToJson(slotActFeature.getClickCntRatioAccount());
                retMap.put("f211002", getUserCategoryActLevelByBucket(clickCntRatioAccountMap, accountCodes, cntRatioBucket));
                JSONObject weekClickCntRatioTradeMap = DataUtil.stringToJson(slotActFeature.getWeekClickCntRatioTrade());
                retMap.put("f211003", getUserCategoryActLevelByBucket(weekClickCntRatioTradeMap, tradeCodes, cntRatioBucket));
                JSONObject weekClickCntRatioAccountMap = DataUtil.stringToJson(slotActFeature.getWeekClickCntRatioAccount());
                retMap.put("f211004", getUserCategoryActLevelByBucket(weekClickCntRatioAccountMap, accountCodes, cntRatioBucket));

                JSONObject ctrTradeMap = DataUtil.stringToJson(slotActFeature.getCtrTrade());
                retMap.put("f212001", getUserCategoryActLevelByBucket(ctrTradeMap, tradeCodes, statCtrBucket));
                JSONObject ctrAccountMap = DataUtil.stringToJson(slotActFeature.getCtrAccount());
                retMap.put("f212002", getUserCategoryActLevelByBucket(ctrAccountMap, accountCodes, statCtrBucket));
                JSONObject weekCtrTradeMap = DataUtil.stringToJson(slotActFeature.getWeekCtrTrade());
                retMap.put("f212003", getUserCategoryActLevelByBucket(weekCtrTradeMap, tradeCodes, statCtrBucket));
                JSONObject weekCtrAccountMap = DataUtil.stringToJson(slotActFeature.getWeekCtrAccount());
                retMap.put("f212004", getUserCategoryActLevelByBucket(weekCtrAccountMap, accountCodes, statCtrBucket));

                // 前端转化
                JSONObject convertCntRatioTradeMap = DataUtil.stringToJson(slotActFeature.getConvertCntRatioTrade());
                retMap.put("f213001", getUserCategoryActLevelByBucket(convertCntRatioTradeMap, tradeCodes, cntRatioBucket));
                JSONObject convertCntRatioAccountMap = DataUtil.stringToJson(slotActFeature.getConvertCntRatioAccount());
                retMap.put("f213002", getUserCategoryActLevelByBucket(convertCntRatioAccountMap, accountCodes, cntRatioBucket));
                JSONObject weekConvertCntRatioTradeMap = DataUtil.stringToJson(slotActFeature.getWeekConvertCntRatioTrade());
                retMap.put("f213003", getUserCategoryActLevelByBucket(weekConvertCntRatioTradeMap, tradeCodes, cntRatioBucket));
                JSONObject weekConvertCntRatioAccountMap = DataUtil.stringToJson(slotActFeature.getWeekConvertCntRatioAccount());
                retMap.put("f213004", getUserCategoryActLevelByBucket(weekConvertCntRatioAccountMap, accountCodes, cntRatioBucket));

                JSONObject cvrTradeMap = DataUtil.stringToJson(slotActFeature.getCvrTrade());
                retMap.put("f214001", getUserCategoryActLevelByBucket(cvrTradeMap, tradeCodes, statCvrBucket));
                JSONObject cvrAccountMap = DataUtil.stringToJson(slotActFeature.getCvrAccount());
                retMap.put("f214002", getUserCategoryActLevelByBucket(cvrAccountMap, accountCodes, statCvrBucket));
                JSONObject weekCvrTradeMap = DataUtil.stringToJson(slotActFeature.getWeekCvrTrade());
                retMap.put("f214003", getUserCategoryActLevelByBucket(weekCvrTradeMap, tradeCodes, statCvrBucket));
                JSONObject weekCvrAccountMap = DataUtil.stringToJson(slotActFeature.getWeekCvrAccount());
                retMap.put("f214004", getUserCategoryActLevelByBucket(weekCvrAccountMap, accountCodes, statCvrBucket));

                // 二类电商行为
                // 发券
                JSONObject launchCntRatioCateMap = DataUtil.stringToJson(slotActFeature.getLaunchCntRatioCate());
                retMap.put("f220001", getUserCategoryActLevelByBucket(launchCntRatioCateMap, resourceCodes, cntRatioBucket));
                JSONObject weekLaunchCntRatioCateMap = DataUtil.stringToJson(slotActFeature.getWeekLaunchCntRatioCate());
                retMap.put("f220002", getUserCategoryActLevelByBucket(weekLaunchCntRatioCateMap, resourceCodes, cntRatioBucket));

                // 点击
                JSONObject clickCntRatioCateMap = DataUtil.stringToJson(slotActFeature.getClickCntRatioCate());
                retMap.put("f221001", getUserCategoryActLevelByBucket(clickCntRatioCateMap, resourceCodes, cntRatioBucket));
                JSONObject weekClickCntRatioCateMap = DataUtil.stringToJson(slotActFeature.getWeekClickCntRatioCate());
                retMap.put("f221002", getUserCategoryActLevelByBucket(weekClickCntRatioCateMap, resourceCodes, cntRatioBucket));

                JSONObject ctrCateMap = DataUtil.stringToJson(slotActFeature.getCtrCate());
                retMap.put("f221003", getUserCategoryActLevelByBucket(ctrCateMap, resourceCodes, statCtrBucket));
                JSONObject weekCtrCateMap = DataUtil.stringToJson(slotActFeature.getWeekCtrCate());
                retMap.put("f221004", getUserCategoryActLevelByBucket(weekCtrCateMap, resourceCodes, statCtrBucket));

                // 转化
                JSONObject convertCntRatioCateMap = DataUtil.stringToJson(slotActFeature.getConvertCntRatioCate());
                retMap.put("f222001", getUserCategoryActLevelByBucket(convertCntRatioCateMap, resourceCodes, cntRatioBucket));
                JSONObject weekConvertCntRatioCateMap = DataUtil.stringToJson(slotActFeature.getWeekConvertCntRatioCate());
                retMap.put("f222002", getUserCategoryActLevelByBucket(weekConvertCntRatioCateMap, resourceCodes, cntRatioBucket));

                JSONObject cvrCateMap = DataUtil.stringToJson(slotActFeature.getCvrCate());
                retMap.put("f222003", getUserCategoryActLevelByBucket(cvrCateMap, resourceCodes, statCvrBucket));
                JSONObject weekCvrCateMap = DataUtil.stringToJson(slotActFeature.getWeekCvrCate());
                retMap.put("f222004", getUserCategoryActLevelByBucket(weekCvrCateMap, resourceCodes, statCvrBucket));
                retMap.put("f222005", slotActFeature.getConvertAdSet());

                // 核单
                JSONObject issueCntRatioCateMap = DataUtil.stringToJson(slotActFeature.getIssueCntRatioCate());
                retMap.put("f223001", getUserCategoryActLevelByBucket(issueCntRatioCateMap, resourceCodes, cntRatioBucket));
                JSONObject issueCntRatioAccountMap = DataUtil.stringToJson(slotActFeature.getIssueCntRatioAccount());
                retMap.put("f223002", getUserCategoryActLevelByBucket(issueCntRatioAccountMap, accountCodes, cntRatioBucket));
                JSONObject weekIssueCntRatioCateMap = DataUtil.stringToJson(slotActFeature.getWeekIssueCntRatioCate());
                retMap.put("f223003", getUserCategoryActLevelByBucket(weekIssueCntRatioCateMap, resourceCodes, cntRatioBucket));
                JSONObject weekIssueCntRatioAccountMap = DataUtil.stringToJson(slotActFeature.getWeekIssueCntRatioAccount());
                retMap.put("f223004", getUserCategoryActLevelByBucket(weekIssueCntRatioAccountMap, accountCodes, cntRatioBucket));

                JSONObject issueRatioCateMap = DataUtil.stringToJson(slotActFeature.getIssueRatioCate());
                retMap.put("f223005", getUserCategoryActLevelByBucket(issueRatioCateMap, resourceCodes, userSignRatioBucket));
                JSONObject issueRatioAccountMap = DataUtil.stringToJson(slotActFeature.getIssueRatioAccount());
                retMap.put("f223006", getUserCategoryActLevelByBucket(issueRatioAccountMap, accountCodes, userSignRatioBucket));
                JSONObject weekIssueRatioCateMap = DataUtil.stringToJson(slotActFeature.getWeekIssueRatioCate());
                retMap.put("f223007", getUserCategoryActLevelByBucket(weekIssueRatioCateMap, resourceCodes, userSignRatioBucket));
                JSONObject weekIssueRatioAccountMap = DataUtil.stringToJson(slotActFeature.getWeekIssueRatioAccount());
                retMap.put("f223008", getUserCategoryActLevelByBucket(weekIssueRatioAccountMap, accountCodes, userSignRatioBucket));
                retMap.put("f223009", slotActFeature.getIssueAdSet());

                // 签收
                JSONObject signCntRatioCateMap = DataUtil.stringToJson(slotActFeature.getSignCntRatioCate());
                retMap.put("f224001", getUserCategoryActLevelByBucket(signCntRatioCateMap, resourceCodes, cntRatioBucket));
                JSONObject signCntRatioAccountMap = DataUtil.stringToJson(slotActFeature.getSignCntRatioAccount());
                retMap.put("f224002", getUserCategoryActLevelByBucket(signCntRatioAccountMap, accountCodes, cntRatioBucket));

                JSONObject signRatioCateMap = DataUtil.stringToJson(slotActFeature.getSignRatioCate());
                retMap.put("f224003", getUserCategoryActLevelByBucket(signRatioCateMap, resourceCodes, userSignRatioBucket));
                JSONObject signRatioAccountMap = DataUtil.stringToJson(slotActFeature.getSignRatioAccount());
                retMap.put("f224004", getUserCategoryActLevelByBucket(signRatioAccountMap, accountCodes, userSignRatioBucket));
                retMap.put("f224005", slotActFeature.getSignAdSet());

                // 消费
                JSONObject priceRegionCntRatioMap = DataUtil.stringToJson(slotActFeature.getPriceRegionCntRatio());
                retMap.put("f225001", getUserCategoryActLevelByBucket(priceRegionCntRatioMap, priceCodes, cntRatioBucket));
                retMap.put("f225002", slotActFeature.getAvgPrice() == null ? null : bucket(slotActFeature.getAvgPrice().longValue(), priceBucket).toString());

                retMap.put("f225003", bucket(slotActFeature.getZeroClickCntRatio(), cntRatioBucket).toString());
                retMap.put("f225004", bucket(slotActFeature.getZeroConvertCntRatio(), cntRatioBucket).toString());
                retMap.put("f225005", bucket(slotActFeature.getZeroIssueCntRatio(), cntRatioBucket).toString());
                retMap.put("f225006", bucket(slotActFeature.getZeroSignCntRatio(), cntRatioBucket).toString());

                // 风控
                retMap.put("f226001", bucket(slotActFeature.getVouchFailedCntRatio(), cntRatioBucket).toString());
                retMap.put("f226002", bucket(slotActFeature.getWeekVouchFailedCntRatio(), cntRatioBucket).toString());
                retMap.put("f226003", bucket(slotActFeature.getRejectCntRatio(), cntRatioBucket).toString());
                retMap.put("f226004", bucket(slotActFeature.getWeekRejectCntRatio(), cntRatioBucket).toString());
                retMap.put("f226005", bucket(slotActFeature.getAddressExpCntRatio(), cntRatioBucket).toString());
                retMap.put("f226006", bucket(slotActFeature.getWeekAddressExpCntRatio(), cntRatioBucket).toString());
                retMap.put("f226007", bucket(slotActFeature.getNumberEmptyCntRatio(), cntRatioBucket).toString());
                retMap.put("f226008", bucket(slotActFeature.getWeekNumberEmptyCntRatio(), cntRatioBucket).toString());

                // 活动侧 新增

                retMap.put("f312001", DataUtil.Long2String(cf.getDsm2A()));// 活动访问类型
                retMap.put("f311001", DataUtil.Long2String(cf.getActivityPage()));
                retMap.put("f331001", cf.getActivitySkinType());// 活动皮肤ID
                retMap.put("f331002", cf.getTitleId());//主标题
                retMap.put("f331003", cf.getSubTitleId());//副标题


                // 安装列表 embedding编码

                //美团imei维度竞价次序特征
                retMap.put("f680001", bucket(cf.getRequestCnt(), cntMeituanBucket).toString());
                retMap.put("f680002", bucket(cf.getExposureCnt(), cntMeituanBucket).toString());
                retMap.put("f680003", bucket(cf.getClickCnt(), cntMeituanBucket).toString());


            }

        } catch (Exception e) {

            logger.error("FeatureParse.generateFeatureMapStatic error", e);
        }

        return retMap;
    }


//    public static Map<String, String> generateFeatureMapDynamic(FeatureDo cf, Map<String, String> retMap) {
//
//        boolean ret = false;
//        try {
//            if (cf != null) {
//                generateFeatureMapDynamic(cf, cf);
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//
//        return retMap;
//    }


    public static Map<String, String> generateFeatureMapDynamic(FeatureDo cf, FeatureDo staticCf) {
        Map<String, String> retMap = new HashMap<>(F_MAX_SIZE);
        try {
            if (cf != null) {

                // 用户行为数据
                UserActFeature userActFeature = Optional.ofNullable(staticCf.getUserActFeature()).orElse(new UserActFeature());

                // 广告ID
                retMap.put("f101001", DataUtil.Long2String(cf.getAdvertId()));


                // 20170602
                // 广告主账号
                retMap.put("f106001", DataUtil.Long2String(cf.getAccountId
                        ()));

                // 广告主&媒体交叉
                String appId = DataUtil.Long2String(staticCf.getAppId());
                String accId = cf.getAccountId() == null ? "acc" : DataUtil.Long2String(cf.getAccountId());
                retMap.put("f2010011", accId + "_" + appId);

                // 推广网址
                retMap.put("f111001", cf.getPromoteUrl());
                // 广告特征标签列表 以英文逗号分割
                retMap.put("f102001", cf.getMatchTagNums());
                // 商品id  cvr
                retMap.put("f801001", cf.getGoodsId());
                // 商品类目  cvr
                retMap.put("f802001", cf.getCatId());
                // 商品品牌 cvr
                retMap.put("f802002", cf.getBrandId());
                // 成本价 cvr
                retMap.put("f803001", DataUtil.Long2String(getCost(cf.getCost(), cf.getPrice())));
                // 售卖价 cvr
                retMap.put("f803002", DataUtil.Long2String(getLog(cf.getPrice())));
                // 浏览售卖比 cvr
                retMap.put("f803003", DataUtil.Long2String(getCost(cf.getViewCount(), cf.getBuyCount())));
                //售卖量 cvr
                retMap.put("f803004", DataUtil.Long2String(getLog(cf.getBuyCount())));


                //广告投放次数
                retMap.put("f110001", DataUtil.Long2String(cf.getTimes()));
                //前后两单广告标签是否一致
                Long tagChangeStatus = getLastTagChangeStatus(cf.getMatchTagNums(), cf.getDayLastMatchTagNums());
                retMap.put("f610001", DataUtil.Long2String(tagChangeStatus));

                // 20170728
                // 广告素材ID
                retMap.put("f104001", cf.getMaterialId());
                // 广告素材标签
                retMap.put("f112001", cf.getMaterialTags());

                // 广告描述标签
                retMap.put("f113001", cf.getAdvertTags());

                // 落地页维度特征
                LoadingPageFeature loadingPageFeature = Optional.ofNullable(cf.getLoadingPageFeature()).orElse(new LoadingPageFeature());
                retMap.put("f670001", loadingPageFeature.getLoadingPageID());
                retMap.put("f670002", DataUtil.Long2String(bucket(loadingPageFeature.getLoadingPageHistCvr(), statCvrBucket)));
                JSONObject loadingPageTagsHistCvr = DataUtil.stringToJson(loadingPageFeature.getLoadingPageTagsHistCvr());
                retMap.put("f670003", getUserCategoryActLevelByBucket(loadingPageTagsHistCvr, loadingPageCodes, statCvrBucket));

                // 保险行业SKU属性特征
                InsuranceSkuDo insuranceSkuDo = Optional.ofNullable(cf.getInsuranceSkuDo()).orElse(new InsuranceSkuDo());
                retMap.put("f131101", insuranceSkuDo.getBrand());
                retMap.put("f131102", insuranceSkuDo.getInsType());
                retMap.put("f131103", insuranceSkuDo.getTotalCharge());
                retMap.put("f131104", insuranceSkuDo.getRecordInfo());
//                retMap.put("f131105", insuranceSkuDo.getMessageCheck());
                retMap.put("f131106", insuranceSkuDo.getGiveaway());
                retMap.put("f131107", insuranceSkuDo.getGiveawayName());
                retMap.put("f131108", insuranceSkuDo.getGiveawayType());
                retMap.put("f131109", insuranceSkuDo.getGiveawayValue());
                retMap.put("f131110", insuranceSkuDo.getGiveawayThreshold());
                retMap.put("f131111", insuranceSkuDo.getClearExp());
                retMap.put("f131112", insuranceSkuDo.getLoadingPageInsType());

                // 会籍卡行业SKU属性特征
                MemberSkuDo memberSkuDo = Optional.ofNullable(cf.getMemberSkuDo()).orElse(new MemberSkuDo());
                retMap.put("f131001", memberSkuDo.getProductName());
                retMap.put("f131002", memberSkuDo.getProductType());
                retMap.put("f131003", memberSkuDo.getRecordInfo());
                retMap.put("f131004", memberSkuDo.getRevenueExpose());
                retMap.put("f131005", memberSkuDo.getPrice());
                retMap.put("f131006", memberSkuDo.getMainRevenue());
                retMap.put("f131007", memberSkuDo.getObtainType());


                // 20171121
                retMap.put("f804001", DataUtil.Long2String(getCtrIntervelLevel(cf.getAdvertCtr())));
                retMap.put("f804002", DataUtil.Long2String(getCvrIntervelLevel(cf.getAdvertCvr())));

                retMap.put("f805001", DataUtil.Long2String(getCtrIntervelLevel(cf.getAdvertAppCtr())));
                retMap.put("f805002", DataUtil.Long2String(getCvrIntervelLevel(cf.getAdvertAppCvr())));

                retMap.put("f806001", DataUtil.Long2String(getCtrIntervelLevel(cf.getAdvertSlotCtr())));
                retMap.put("f806002", DataUtil.Long2String(getCvrIntervelLevel(cf.getAdvertSlotCvr())));

                retMap.put("f807001", DataUtil.Long2String(getCtrIntervelLevel(cf.getAdvertActivityCtr())));
                retMap.put("f807002", DataUtil.Long2String(getCvrIntervelLevel(cf.getAdvertActivityCvr())));

                // 20180507
                retMap.put("f804003", DataUtil.Long2String(bucket(cf.getAdvertCtr(), statCtrBucket)));
                retMap.put("f804004", DataUtil.Long2String(bucket(cf.getAdvertCvr(), statCvrBucket)));

                retMap.put("f805003", DataUtil.Long2String(bucket(cf.getAdvertAppCtr(), statCtrBucket)));
                retMap.put("f805004", DataUtil.Long2String(bucket(cf.getAdvertAppCvr(), statCvrBucket)));

                retMap.put("f806003", DataUtil.Long2String(bucket(cf.getAdvertSlotCtr(), statCtrBucket)));
                retMap.put("f806004", DataUtil.Long2String(bucket(cf.getAdvertSlotCvr(), statCvrBucket)));

                retMap.put("f807003", DataUtil.Long2String(bucket(cf.getAdvertActivityCtr(), statCtrBucket)));
                retMap.put("f807004", DataUtil.Long2String(bucket(cf.getAdvertActivityCvr(), statCvrBucket)));

                // 2021-04-02 后端类型 各维度统计cvr
                String convertSubType = cf.getBankEndType();
                String convertDeepType = cf.getDeepConvertTypes();

                CvrStatDo adCsd = Optional.ofNullable(cf.getAdCsd()).orElse(new CvrStatDo());
                retMap.put("f840101", DataUtil.Long2String(bucketBSearch(adCsd.getMergeCvrBySubType(convertSubType, 20L, 0.7, 0.3), statBCvrBucket)));
//                retMap.put("f8401011", JSON.toJSONString(mapBucket(adCsd.getMergeCvrMap(20L, 0.7, 0.3), statBCvrBucket)));
                retMap.put("f840211", DataUtil.double2String(adCsd.getDcvrSafely(convertDeepType,1)));
                retMap.put("f840213", DataUtil.double2String(adCsd.getDcvrSafely(convertDeepType,3)));
                retMap.put("f840216",DataUtil.Long2String(bucket(adCsd.getConvertCntSafely(convertDeepType,1),
                        convertCntBucket)));
                retMap.put("f840218",DataUtil.Long2String(bucket(adCsd.getConvertCntSafely(convertDeepType,3),
                        convertCntBucket)));

                CvrStatDo adAppCsd = Optional.ofNullable(cf.getAdAppCsd()).orElse(new CvrStatDo());
                retMap.put("f840102", DataUtil.Long2String(bucketBSearch(adAppCsd.getMergeCvrBySubType(convertSubType, 20L, 0.7, 0.3), statBCvrBucket)));
//                retMap.put("f8401021", JSON.toJSONString(mapBucket(adAppCsd.getMergeCvrMap(20L, 0.7, 0.3), statBCvrBucket)));
                retMap.put("f840221", DataUtil.double2String(adAppCsd.getDcvrSafely(convertDeepType,1)));
                retMap.put("f840223", DataUtil.double2String(adAppCsd.getDcvrSafely(convertDeepType,3)));
                retMap.put("f840226",DataUtil.Long2String(bucket(adAppCsd.getConvertCntSafely(convertDeepType,1),
                        convertCntBucket)));
                retMap.put("f840228",DataUtil.Long2String(bucket(adAppCsd.getConvertCntSafely(convertDeepType,3),
                        convertCntBucket)));

                CvrStatDo adSlotCsd = Optional.ofNullable(cf.getAdSlotCsd()).orElse(new CvrStatDo());
                retMap.put("f840103", DataUtil.Long2String(bucketBSearch(adSlotCsd.getMergeCvrBySubType(convertSubType, 20L, 0.7, 0.3), statBCvrBucket)));
//                retMap.put("f8401031", JSON.toJSONString(mapBucket(adSlotCsd.getMergeCvrMap(20L, 0.7, 0.3), statBCvrBucket)));
                retMap.put("f840231", DataUtil.double2String(adSlotCsd.getDcvrSafely(convertDeepType,1)));
                retMap.put("f840233", DataUtil.double2String(adSlotCsd.getDcvrSafely(convertDeepType,3)));
                retMap.put("f840236",DataUtil.Long2String(bucket(adSlotCsd.getConvertCntSafely(convertDeepType,1),
                        convertCntBucket)));
                retMap.put("f840238",DataUtil.Long2String(bucket(adSlotCsd.getConvertCntSafely(convertDeepType,3),
                        convertCntBucket)));

                CvrStatDo adActivityCsd = Optional.ofNullable(cf.getAdActivityCsd()).orElse(new CvrStatDo());
                retMap.put("f840104", DataUtil.Long2String(bucketBSearch(adActivityCsd.getMergeCvrBySubType(convertSubType, 20L, 0.7, 0.3), statBCvrBucket)));
//                retMap.put("f8401041", JSON.toJSONString(mapBucket(adActivityCsd.getMergeCvrMap(20L, 0.7, 0.3), statBCvrBucket)));

                CvrStatDo accCsd = Optional.ofNullable(cf.getAccCsd()).orElse(new CvrStatDo());
                retMap.put("f840105", DataUtil.Long2String(bucketBSearch(accCsd.getMergeCvrBySubType(convertSubType, 20L, 0.7, 0.3), statBCvrBucket)));
//                retMap.put("f8401051", JSON.toJSONString(mapBucket(accCsd.getMergeCvrMap(20L, 0.7, 0.3), statBCvrBucket)));
                retMap.put("f840251", DataUtil.double2String(accCsd.getDcvrSafely(convertDeepType, 1)));
                retMap.put("f840253", DataUtil.double2String(accCsd.getDcvrSafely(convertDeepType, 3)));
                retMap.put("f840256",DataUtil.Long2String(bucket(accCsd.getConvertCntSafely(convertDeepType,1),
                        convertCntBucket)));
                retMap.put("f840258",DataUtil.Long2String(bucket(accCsd.getConvertCntSafely(convertDeepType,3),
                        convertCntBucket)));

                CvrStatDo accAppCsd = Optional.ofNullable(cf.getAccAppCsd()).orElse(new CvrStatDo());
                retMap.put("f840106", DataUtil.Long2String(bucketBSearch(accAppCsd.getMergeCvrBySubType(convertSubType, 20L, 0.7, 0.3), statBCvrBucket)));
//                retMap.put("f8401061", JSON.toJSONString(mapBucket(accAppCsd.getMergeCvrMap(20L, 0.7, 0.3), statBCvrBucket)));
                retMap.put("f840261", DataUtil.double2String(accAppCsd.getDcvrSafely(convertDeepType, 1)));
                retMap.put("f840263", DataUtil.double2String(accAppCsd.getDcvrSafely(convertDeepType, 3)));
                retMap.put("f840266",DataUtil.Long2String(bucket(accAppCsd.getConvertCntSafely(convertDeepType,1),
                        convertCntBucket)));
                retMap.put("f840268",DataUtil.Long2String(bucket(accAppCsd.getConvertCntSafely(convertDeepType,3),
                        convertCntBucket)));

                CvrStatDo accSlotCsd = Optional.ofNullable(cf.getAccSlotCsd()).orElse(new CvrStatDo());
                retMap.put("f840107", DataUtil.Long2String(bucketBSearch(accSlotCsd.getMergeCvrBySubType(convertSubType, 20L, 0.7, 0.3), statBCvrBucket)));
//                retMap.put("f8401071", JSON.toJSONString(mapBucket(accSlotCsd.getMergeCvrMap(20L, 0.7, 0.3), statBCvrBucket)));
                retMap.put("f840271", DataUtil.double2String(accSlotCsd.getDcvrSafely(convertDeepType, 1)));
                retMap.put("f840273", DataUtil.double2String(accSlotCsd.getDcvrSafely(convertDeepType, 3)));
                retMap.put("f840276",DataUtil.Long2String(bucket(accSlotCsd.getConvertCntSafely(convertDeepType,1),
                        convertCntBucket)));
                retMap.put("f840278",DataUtil.Long2String(bucket(accSlotCsd.getConvertCntSafely(convertDeepType,3),
                        convertCntBucket)));

                CvrStatDo accActivityCsd = Optional.ofNullable(cf.getAccActivityCsd()).orElse(new CvrStatDo());
                retMap.put("f840108", DataUtil.Long2String(bucketBSearch(accActivityCsd.getMergeCvrBySubType(convertSubType, 20L, 0.7, 0.3), statBCvrBucket)));
//                retMap.put("f8401081", JSON.toJSONString(mapBucket(accActivityCsd.getMergeCvrMap(20L, 0.7, 0.3), statBCvrBucket)));

                CvrStatDo tradeCsd = Optional.ofNullable(cf.getTradeCsd()).orElse(new CvrStatDo());
                retMap.put("f840109", DataUtil.Long2String(bucketBSearch(tradeCsd.getMergeCvrBySubType(convertSubType, 20L, 0.7, 0.3), statBCvrBucket)));
//                retMap.put("f8401091", JSON.toJSONString(mapBucket(tradeCsd.getMergeCvrMap(20L, 0.7, 0.3), statBCvrBucket)));

                CvrStatDo tradeAppCsd = Optional.ofNullable(cf.getTradeAppCsd()).orElse(new CvrStatDo());
                retMap.put("f840110", DataUtil.Long2String(bucketBSearch(tradeAppCsd.getMergeCvrBySubType(convertSubType, 20L, 0.7, 0.3), statBCvrBucket)));
//                retMap.put("f8401101", JSON.toJSONString(mapBucket(tradeAppCsd.getMergeCvrMap(20L, 0.7, 0.3), statBCvrBucket)));

                CvrStatDo tradeSlotCsd = Optional.ofNullable(cf.getTradeSlotCsd()).orElse(new CvrStatDo());
                retMap.put("f840111", DataUtil.Long2String(bucketBSearch(tradeSlotCsd.getMergeCvrBySubType(convertSubType, 20L, 0.7, 0.3), statBCvrBucket)));
//                retMap.put("f8401111", JSON.toJSONString(mapBucket(tradeSlotCsd.getMergeCvrMap(20L, 0.7, 0.3), statBCvrBucket)));

                CvrStatDo tradeActivityCsd = Optional.ofNullable(cf.getTradeActivityCsd()).orElse(new CvrStatDo());
                retMap.put("f840112", DataUtil.Long2String(bucketBSearch(tradeActivityCsd.getMergeCvrBySubType(convertSubType, 20L, 0.7, 0.3), statBCvrBucket)));
//                retMap.put("f8401121", JSON.toJSONString(mapBucket(tradeActivityCsd.getMergeCvrMap(20L, 0.7, 0.3), statBCvrBucket)));

                CvrStatDo appCsd = Optional.ofNullable(staticCf.getAppCsd()).orElse(new CvrStatDo());
                retMap.put("f840113", DataUtil.Long2String(bucketBSearch(appCsd.getMergeCvrBySubType(convertSubType, 20L, 0.7, 0.3), statBCvrBucket)));
//                retMap.put("f8401131", JSON.toJSONString(mapBucket(appCsd.getMergeCvrMap(20L, 0.7, 0.3), statBCvrBucket)));
                CvrStatDo slotCsd = Optional.ofNullable(staticCf.getSlotCsd()).orElse(new CvrStatDo());
                retMap.put("f840114", DataUtil.Long2String(bucketBSearch(slotCsd.getMergeCvrBySubType(convertSubType, 20L, 0.7, 0.3), statBCvrBucket)));
//                retMap.put("f8401141", JSON.toJSONString(mapBucket(slotCsd.getMergeCvrMap(20L, 0.7, 0.3), statBCvrBucket)));
                CvrStatDo activityCsd = Optional.ofNullable(staticCf.getActivityCsd()).orElse(new CvrStatDo());
                retMap.put("f840115", DataUtil.Long2String(bucketBSearch(activityCsd.getMergeCvrBySubType(convertSubType, 20L, 0.7, 0.3), statBCvrBucket)));
//                retMap.put("f8401151", JSON.toJSONString(mapBucket(activityCsd.getMergeCvrMap(20L, 0.7, 0.3), statBCvrBucket)));

                // 2021-04-21 ADX细分媒体 后端类型 各维度统计cvr
                CvrStatDo adxAppCsd = Optional.ofNullable(staticCf.getAdxAppCsd()).orElse(new CvrStatDo());
                retMap.put("f850113", DataUtil.Long2String(bucketBSearch(adxAppCsd.getMergeCvrBySubType(convertSubType, 20L, 0.7, 0.3), statBCvrBucket)));
//                retMap.put("f8501131", JSON.toJSONString(mapBucket(adxAppCsd.getMergeCvrMap(20L, 0.7, 0.3), statBCvrBucket)));

                CvrStatDo adAdxAppCsd = Optional.ofNullable(cf.getAdAdxAppCsd()).orElse(new CvrStatDo());
                retMap.put("f850102", DataUtil.Long2String(bucketBSearch(adAdxAppCsd.getMergeCvrBySubType(convertSubType, 20L, 0.7, 0.3), statBCvrBucket)));
//                retMap.put("f8501021", JSON.toJSONString(mapBucket(adAdxAppCsd.getMergeCvrMap(20L, 0.7, 0.3), statBCvrBucket)));

                CvrStatDo accAdxAppCsd = Optional.ofNullable(cf.getAccAdxAppCsd()).orElse(new CvrStatDo());
                retMap.put("f850106", DataUtil.Long2String(bucketBSearch(accAdxAppCsd.getMergeCvrBySubType(convertSubType, 20L, 0.7, 0.3), statBCvrBucket)));
//                retMap.put("f8501061", JSON.toJSONString(mapBucket(accAdxAppCsd.getMergeCvrMap(20L, 0.7, 0.3), statBCvrBucket)));

                CvrStatDo tradeAdxAppCsd = Optional.ofNullable(cf.getTradeAdxAppCsd()).orElse(new CvrStatDo());
                retMap.put("f850110", DataUtil.Long2String(bucketBSearch(tradeAdxAppCsd.getMergeCvrBySubType(convertSubType, 20L, 0.7, 0.3), statBCvrBucket)));
//                retMap.put("f8501101", JSON.toJSONString(mapBucket(tradeAdxAppCsd.getMergeCvrMap(20L, 0.7, 0.3), statBCvrBucket)));


                retMap.put("f812001", DataUtil.Long2String(bucket(cf.getAppTradeWeekCvr(), statCvrBucket)));
                retMap.put("f812002", DataUtil.Long2String(bucket(cf.getAppTradeDayCvr(), statCvrBucket)));
                retMap.put("f812003", DataUtil.Long2String(bucket(cf.getAppTagpidTradeWeekCvr(), statCvrBucket)));
                retMap.put("f812004", DataUtil.Long2String(bucket(cf.getAppTagpidTradeDayCvr(), statCvrBucket)));
                retMap.put("f812005", DataUtil.Long2String(bucket(cf.getAppTagidTradeWeekCvr(), statCvrBucket)));
                retMap.put("f812006", DataUtil.Long2String(bucket(cf.getAppTagidTradeDayCvr(), statCvrBucket)));
                retMap.put("f812007", DataUtil.Long2String(bucket(cf.getMaterialTradeWeekCvr(), statCvrBucket)));
                retMap.put("f812008", DataUtil.Long2String(bucket(cf.getMaterialTradeDayCvr(), statCvrBucket)));
                retMap.put("f812009", DataUtil.Long2String(bucket(cf.getAcctivityTradeWeekCvr(), statCvrBucket)));
                retMap.put("f812010", DataUtil.Long2String(bucket(cf.getAcctivityTradeDayCvr(), statCvrBucket)));

                // 20180112
                retMap.put("f9912", cf.getTradeId());
                retMap.put("f9913", cf.getTradeId2());


                // 20180423
                Map<String, Map<String, Long>> ubpMap = staticCf.getUbpMap();

                retMap.put("f810001", getUserBehavioralPreference(1, "ctr", ubpMap, cf.getMatchTagNums()));
                retMap.put("f810002", getUserBehavioralPreference(1, "cvr", ubpMap, cf.getMatchTagNums()));

                // 20210511 OneId用户行为
                Map<String, Map<String, Long>> oUbpMap = staticCf.getOUbpMap();
                retMap.put("f8100011", getUserBehavioralPreference(1, "ctr", oUbpMap, cf.getMatchTagNums()));
                retMap.put("f8100021", getUserBehavioralPreference(1, "cvr", oUbpMap, cf.getMatchTagNums()));

                retMap.put("f115001", cf.getBankEndType());
                String tradeId = cf.getOperatingNewTrade() == null ? "un" : cf.getOperatingNewTrade();
                // 行业与后端类型交叉
                retMap.put("f1150011", tradeId + "_" + cf.getBankEndType());
                // 广告主与后端类型交叉
                String accountId = cf.getAccountId() == null ? "acc" : DataUtil.Long2String(cf.getAccountId());
                retMap.put("f1150012", accountId + "_" + cf.getBankEndType());
                // 广告与后端类型交叉
                String advertId = cf.getAdvertId() == null ? "ad" : DataUtil.Long2String(cf.getAdvertId());
                retMap.put("f1150013", advertId + "_" + cf.getBankEndType());

                retMap.put("f115002", cf.getConversionTypes());

                retMap.put("f115003", cf.getBankEndType());
                retMap.put("f115004", cf.getDeepConvertTypes());

                //广告和后端类型交叉
                retMap.put("f701001", getAdAndSubType(cf.getAdvertId(), cf.getBankEndType()));


                //20180815 素材相关新增标签
                retMap.put("f121001", cf.getAtmosphere());  //氛围
                retMap.put("f121002", cf.getBackgroundColour()); //背景颜色
                retMap.put("f121003", cf.getIfPrevalent());  //是否含有流行元素
                retMap.put("f121004", cf.getDescribeKeywords()); //文案关键词
                retMap.put("f121005", cf.getDynamicEffect()); // 动效类型
                retMap.put("f121006", cf.getBodyElement()); //主体元素

                // ADX直投素材相关特征
                retMap.put("f122001", DataUtil.Long2String(cf.getAdxStyleId()));
                retMap.put("f122002", DataUtil.Integer2String(cf.getDpaMaterial()));


                //展示广告特征

                retMap.put("f8807", DataUtil.Long2String(cf.getBatchIndex()));


                //20190123资源重复发券-用户行为衍生特征
                // 用户当前订单资源ID resource_id f770001
                retMap.put("f770001", cf.getOperatingResource());

                // 用户当日该资源第几个订单序列（分桶）f770102
                String operationResource = cf.getOperatingResource() == null ? null : cf.getOperatingResource() + "-770101";
                Long dayResourceOrderRankLevel = getResourceOrderRank(operationResource, staticCf.getDayResourceOrderRank());
                retMap.put("f770102", DataUtil.Long2String(dayResourceOrderRankLevel));

                // 计算用户该资源当前单与前一单时间差（分桶）f770202
                operationResource = cf.getOperatingResource() == null ? null : cf.getOperatingResource() + "-770201";
                Long resourceOrderGmtIntervelLevel =
                        getResourceOrderGmtIntervelLevel(operationResource, staticCf.getCurrentGmtCreateTime(), staticCf.getResourceLastGmtCreateTime());
                retMap.put("f770202", DataUtil.Long2String(resourceOrderGmtIntervelLevel));

                // 用户该资源前一单是否计费 f770301
                Long resourceLastOrderIsClick =
                        getResourceLastOrderIsClick(cf.getOperatingResource(), staticCf.getResourceLastLaunchOrderId(), staticCf.getResourceLastClickOrderId());
                retMap.put("f770301", DataUtil.Long2String(resourceLastOrderIsClick));

                // 用户该资源前一单是否转化 f770302
                Long resourceLastOrderIsConvert =
                        getResourceLastOrderIsConvert(cf.getOperatingResource(), staticCf.getResourceLastLaunchOrderId(), staticCf.getResourceLastConvertOrderId());
                retMap.put("f770302", DataUtil.Long2String(resourceLastOrderIsConvert));

                // 当日用户该资源累计点击数 f770401
                operationResource = cf.getOperatingResource() == null ? null : cf.getOperatingResource() + "-770401";
                Long dayResourceChargeCnt = getResourceChargeCnt(operationResource, staticCf.getDayResourceChargeCnt());
                retMap.put("f770401", DataUtil.Long2String(dayResourceChargeCnt));

                // 当日用户该资源累计转化数 f770402
                operationResource = cf.getOperatingResource() == null ? null : cf.getOperatingResource()+ "-770402";
                Long dayResourceConvertCnt = getResourceConvertCnt(operationResource, staticCf.getDayResourceConvertCnt());
                retMap.put("f770402", DataUtil.Long2String(dayResourceConvertCnt));

                //计算用户当前单与前一单资源是否相同f770501
                Long lastResourceEqualStatus = getLastResourceEqualStatus(cf.getOperatingResource(), staticCf.getLastOperatingResource());
                retMap.put("f770501", DataUtil.Long2String(lastResourceEqualStatus));


                // 20210623 OneID用户行为特征
                Long dayResourceOrderRankLevelOneID = getResourceOrderRank(cf.getOperatingResource(), userActFeature.getTodayResourceLaunch());
                retMap.put("f7701021", DataUtil.Long2String(dayResourceOrderRankLevelOneID));
                Long resourceOrderGmtIntervelLevelOneID =
                        getResourceOrderGmtIntervelLevelOneId(cf.getOperatingResource(), staticCf.getCurrentGmtCreateTime(), userActFeature.getLastResourceLaunchTime());
                retMap.put("f7702021", DataUtil.Long2String(resourceOrderGmtIntervelLevelOneID));
                String lastResourceLaunchOrder = getValueSafety(cf.getOperatingResource(), userActFeature.getLastResourceLaunchOrder());
                String lastResourceClickOrder = getValueSafety(cf.getOperatingResource(), userActFeature.getLastResourceClickOrder());
                retMap.put("f7703011", DataUtil.Long2String(getMatchStatus(lastResourceLaunchOrder, lastResourceClickOrder)));
                String lastResourceEffectOrder = getValueSafety(cf.getOperatingResource(), userActFeature.getLastResourceEffectOrder());
                retMap.put("f7703021", DataUtil.Long2String(getMatchStatus(lastResourceClickOrder, lastResourceEffectOrder)));
                Long dayResourceChargeCntOneID = getResourceChargeCnt(cf.getOperatingResource(), userActFeature.getTodayResourceClickAdvertCount());
                retMap.put("f7704011", DataUtil.Long2String(dayResourceChargeCntOneID));
                Long dayResourceConvertCntOneID = getResourceConvertCnt(cf.getOperatingResource(), userActFeature.getTodayResourceEffectAdvertCount());
                retMap.put("f7704021", DataUtil.Long2String(dayResourceConvertCntOneID));
                retMap.put("f7705011", DataUtil.Long2String(getLastResourceEqualStatus(cf.getOperatingResource(), userActFeature.getLastResource())));


                // 20190507行业重复发券-用户行为衍生特征
                // 当前订单所属综合行业 f660001
                retMap.put("f660001", cf.getOperatingNewTrade());
                retMap.put("f660002", cf.getNewTrade());
                retMap.put("f660003", DataUtil.Long2String(bucket(cf.getNewTradeHistCtr(), statCtrBucket)));
                retMap.put("f660004", DataUtil.Long2String(bucket(cf.getNewTradeHistCvr(), statCvrBucket)));


                // 用户当日该综合行业下发券次序（分桶）f660102
                Long newTradeDayOrderRankLevel = getNewTradeOrderRank(cf.getOperatingNewTrade(), cf.getNewTradeDayOrderRank());
                retMap.put("f660102", DataUtil.Long2String(newTradeDayOrderRankLevel));

                // 用户当前单与前一单的综合行业是否相同 f660201
                Long lastNewTradeEqualStatus = getLastNewTradeEqualStatus(cf.getOperatingNewTrade(), cf.getLastOperatingNewTrade());
                retMap.put("f660201", DataUtil.Long2String(lastNewTradeEqualStatus));

                // 计算用户当日该综合行业前后单时间差（分桶）f660302
                Long lastNewTradeGmtIntervelLevel = getLastNewTradeGmtIntervelLevel(cf.getOperatingNewTrade(), staticCf.getCurrentGmtCreateTime(), cf.getNewTradeLastGmtCreateTime());
                retMap.put("f660302", DataUtil.Long2String(lastNewTradeGmtIntervelLevel));

                // 20210623 OneID用户行为特征
                Integer advertIdInteger = cf.getAdvertId() == null ? null : cf.getAdvertId().intValue();

                retMap.put("f6700011", DataUtil.Long2String(bucket(getValueSafety(advertIdInteger, userActFeature.getTodayAdvertLaunch()), dayOrderRankBucket)));
                retMap.put("f6700021", DataUtil.Long2String(bucket(getValueSafety(advertIdInteger, userActFeature.getTodayAdvertClick()), dayOrderRankBucket)));
                retMap.put("f6700031", DataUtil.Long2String(bucket(getValueSafety(advertIdInteger, userActFeature.getTodayAdvertEffect()), dayOrderRankBucket)));

                retMap.put("f6710011", DataUtil.Long2String(bucket(getValueSafety(advertIdInteger, userActFeature.getHistoryAdvertLaunch()), orderRankBucket)));
                retMap.put("f6710021", DataUtil.Long2String(bucket(getValueSafety(advertIdInteger, userActFeature.getHistoryAdvertClick()), orderRankBucket)));
                retMap.put("f6710031", DataUtil.Long2String(bucket(getValueSafety(advertIdInteger, userActFeature.getHistoryAdvertEffect()), orderRankBucket)));

                retMap.put("f6720011", DataUtil.Long2String(bucket(getValueSafety(cf.getMatchTagNums(), staticCf.getOTradeLaunchMap()), orderRankBucket)));
                retMap.put("f6720021", DataUtil.Long2String(bucket(getValueSafety(cf.getMatchTagNums(), staticCf.getOTradeClickMap()), orderRankBucket)));
                retMap.put("f6720031", DataUtil.Long2String(bucket(getValueSafety(cf.getMatchTagNums(), staticCf.getOTradeConvertMap()), orderRankBucket)));


                //20190507广告&媒体偏好画像特征
                //广告行业在不同媒体行业上的ctr,cvr(分桶)
                String newTradeInAppTagCtr = getStatInAppTag("ctr", cf.getNewTradeInAppTag());
                retMap.put("f550201", newTradeInAppTagCtr);
                String newTradeInAppTagCvr = getStatInAppTag("cvr", cf.getNewTradeInAppTag());
                retMap.put("f550202", newTradeInAppTagCvr);

                //广告在不同媒体行业上的ctr,cvr(分桶)
                String advertInAppTagCtr = getStatInAppTag("ctr", cf.getAdvertInAppTag());
                retMap.put("f550401", advertInAppTagCtr);
                String advertInAppTagCvr = getStatInAppTag("cvr", cf.getAdvertInAppTag());
                retMap.put("f550402", advertInAppTagCvr);


                //20191023用户行为序交叉待预估广告
                retMap.put("f830101", getCrossFeature(staticCf.getClickAdIds(), DataUtil.Long2String(cf.getAdvertId())));
                retMap.put("f830102", getCrossFeature(staticCf.getClickAcIds(), DataUtil.Long2String(cf.getAccountId())));
                retMap.put("f830103", getCrossFeature(staticCf.getClickReIds(), cf.getOperatingResource()));
                retMap.put("f830104", getCrossFeature(staticCf.getClickTrIds(), cf.getOperatingNewTrade()));

                String exposeTop250 = (cf.getIsExposeTop250() != null && cf.getIsExposeTop250() > 0)
                        ? DataUtil.Long2String(cf.getAdvertId()) : "";

                // 用户转化序列 拼接 预估广告id
                Set<String> convertAdvertSet = new HashSet<>();
                if (exposeTop250.length() > 0 && staticCf.getConvAdIds() != null) {
                    String convertStr = staticCf.getConvAdIds().toString();
                    convertAdvertSet = getConvertAdvertSet(convertStr, staticCf.getTopAdvertSet());
                    if (convertAdvertSet.size() > 0) {
                        List<String> convertList = new ArrayList<>();
                        for (String advert : convertAdvertSet) {
                            if (advert != null && advert.trim().length() > 0) {
                                convertList.add(advert + "_" + exposeTop250);
                            }
                        }
                        retMap.put("f911004", String.join(",", convertList));
                    }
                }

                // OneID 用户行为序列 拼接 预估广告id
                String convertBehaviourCross = userBehaviourCross(exposeTop250, getSetIntersection(userActFeature.getAdvertEffectSet(), staticCf.getTopAdvertSet()));
                retMap.put("f9110041", convertBehaviourCross);

                String clickBehaviourCross = userBehaviourCross(exposeTop250, getSetIntersection(userActFeature.getAdvertClickSet(), staticCf.getTopAdvertSet()));
                retMap.put("f9110021", clickBehaviourCross);

                String exposureNoClickCross = userBehaviourCross(exposeTop250, getSetSubtract(userActFeature.getAdvertExposureSet(), userActFeature.getAdvertClickSet()));
                retMap.put("f9110011", exposureNoClickCross);

                String clickNoEffectCross = userBehaviourCross(exposeTop250, getSetSubtract(userActFeature.getAdvertClickSet(), userActFeature.getAdvertEffectSet()));
                retMap.put("f9110031", clickNoEffectCross);

                // OneID 用户行为序列 拼接 预估广告行业
                String convertTradeCross = userBehaviourCross(cf.getOperatingNewTrade(), userActFeature.getTradeEffectSet());
                retMap.put("f9120041", convertTradeCross);

                String clickTradeCross = userBehaviourCross(cf.getOperatingNewTrade(), userActFeature.getTradeClickSet());
                retMap.put("f9120021", clickTradeCross);

                String clickNoEffectTradeCross = userBehaviourCross(cf.getOperatingNewTrade(), getSetSubtract(userActFeature.getTradeClickSet(), userActFeature.getTradeEffectSet()));
                retMap.put("f9120031", clickNoEffectTradeCross);

                // 用户历史+当天 曝光未点击广告 + 预估广告 交叉
                // 用户点击未转化 广告 + 预估广告 交叉
                if (exposeTop250.length() > 0 && staticCf.getExposeAdIds() != null) {
                    List<String> exposeNotClickList = new ArrayList<>();
                    Set<String> clickAdIds = new HashSet<>();
                    if (staticCf.getClickAdIds() != null) {
                        // f830001
                        Collections.addAll(clickAdIds, staticCf.getClickAdIds().split(","));
                    }

                    // 用户历史+当天 曝光未点击广告
                    for (String adIds : staticCf.getExposeAdIds().split(",")) {
                        if (!clickAdIds.contains(adIds) && adIds != null && adIds.trim().length() > 0) {
                            exposeNotClickList.add(adIds + "_" + exposeTop250);
                        }
                    }
                    if (exposeNotClickList.size() > 0) {
                        retMap.put("f911001", String.join(",", exposeNotClickList));
                    }

                    // 用户点击未转化 广告 + 预估广告
                    if (clickAdIds.size() > 0) {
                        List<String> clickNotConvertList = new ArrayList<>();
                        for (String ad : clickAdIds) {
                            if (!convertAdvertSet.contains(ad) && ad != null && ad.trim().length()>0) {
                                clickNotConvertList.add(ad + "_" + exposeTop250);
                            }
                        }
                        if (clickNotConvertList.size() > 0) {
                            retMap.put("f911003", String.join(",", clickNotConvertList));
                        }
                    }
                }

                String backCvrType = cf.getBankEndType();
                String convAdIds = staticCf.getConvAdIds() == null ? null : staticCf.getConvAdIds().getOrDefault(backCvrType, null);
                String convAcIds = staticCf.getConvAcIds() == null ? null : staticCf.getConvAcIds().getOrDefault(backCvrType, null);
                String convReIds = staticCf.getConvReIds() == null ? null : staticCf.getConvReIds().getOrDefault(backCvrType, null);
                String convTrIds = staticCf.getConvTrIds() == null ? null : staticCf.getConvTrIds().getOrDefault(backCvrType, null);

                retMap.put("f830111", getCrossFeature(convAdIds, DataUtil.Long2String(cf.getAdvertId())));
                retMap.put("f830112", getCrossFeature(convAcIds, DataUtil.Long2String(cf.getAccountId())));
                retMap.put("f830113", getCrossFeature(convReIds, cf.getOperatingResource()));
                retMap.put("f830114", getCrossFeature(convTrIds, cf.getOperatingNewTrade()));

                //广告和用户标签类型交叉
                DmpFeature dmpFeature = Optional.ofNullable(staticCf.getDmpFeature()).orElse(new DmpFeature());
                retMap.put("f9601", getCrossFeature(staticCf.getUserBasicTags(), cf.getOperatingNewTrade()));
                retMap.put("f9602", getCrossFeature(staticCf.getUserBasicTags(), cf.getOperatingResource()));
                retMap.put("f9603", getCrossFeature(staticCf.getUserBasicTags(), DataUtil.Long2String(cf.getAdvertId())));
                retMap.put("f9607", getCrossFeature(dmpFeature.getValidAppList(), cf.getOperatingNewTrade()));
                retMap.put("f9608", getCrossFeature(staticCf.getSigList(), cf.getOperatingNewTrade()));
                retMap.put("f9609", getCrossFeature(staticCf.getSigList(), cf.getOperatingResource()));


                // 商品画像特征解析
                ItemProfileFeature itemProfileFeature = Optional.ofNullable(cf.getItemProfileFeature()).orElse(new ItemProfileFeature());
                // 基本信息
                retMap.put("f141001", itemProfileFeature.getName());
                retMap.put("f141002", itemProfileFeature.getCategoryTag());
                retMap.put("f141003", itemProfileFeature.getBrand());
                retMap.put("f141004", itemProfileFeature.getShop());
//                retMap.put("f141005", itemProfileFeature.getAccount());
//                retMap.put("f141006", itemProfileFeature.getPicture());
//                retMap.put("f141007", itemProfileFeature.getMaterialPicture());
//                retMap.put("f141008", itemProfileFeature.getLayerPicture());
//                retMap.put("f141009", itemProfileFeature.getDesc());
                retMap.put("f141010", itemProfileFeature.getTopCategory());
                retMap.put("f141011", itemProfileFeature.getSecondCategory());
                retMap.put("f141012", itemProfileFeature.getTags());
                retMap.put("f141013", itemProfileFeature.getOriginalPrice() == null ? null : bucket(itemProfileFeature.getOriginalPrice().longValue(), priceBucket).toString());
                retMap.put("f141014", itemProfileFeature.getDealPrice() == null ? null : bucket(itemProfileFeature.getDealPrice().longValue(), priceBucket).toString());
                retMap.put("f141015", itemProfileFeature.getNumber() == null ? null : itemProfileFeature.getNumber().toString());
                retMap.put("f141016", bucket(itemProfileFeature.getDeliveryDays(), cntBucket).toString());
//                retMap.put("f141017", itemProfileFeature.getDateOnSale());
                retMap.put("f141018", bucket(itemProfileFeature.getDaysOnSale(), cntBucket).toString());

                // 标签信息
                retMap.put("f142001", itemProfileFeature.getDynamicType());
                retMap.put("f142002", itemProfileFeature.getInterestPoint());
                JSONObject materialRGBMap = DataUtil.stringToJson(itemProfileFeature.getMaterialPictureRGB());
                retMap.put("f142003", getUserCategoryActLevelByBucket(materialRGBMap, colorCodes, colorRBGBucket));
                JSONObject layerRGBMap = DataUtil.stringToJson(itemProfileFeature.getLayerPictureRGB());
                retMap.put("f142004", getUserCategoryActLevelByBucket(layerRGBMap, colorCodes, colorRBGBucket));
                JSONObject pictureRGBMap = DataUtil.stringToJson(itemProfileFeature.getPictureRGB());
                retMap.put("f142005", getUserCategoryActLevelByBucket(pictureRGBMap, colorCodes, colorRBGBucket));
                retMap.put("f142006", itemProfileFeature.getPriceTag());
                retMap.put("f142007", itemProfileFeature.getRegionTag());
                retMap.put("f142008", itemProfileFeature.getHistorySeasonTag());
                retMap.put("f142009", itemProfileFeature.getHolidaySeasonTag());
                retMap.put("f142010", itemProfileFeature.getCrowdTag());
                retMap.put("f142011", itemProfileFeature.getPromotionStrength());
                retMap.put("f142012", itemProfileFeature.getKeyword());

                // 热度信息
                retMap.put("f143001", bucket(itemProfileFeature.getClickCnt(), bigCntBucket).toString());
                retMap.put("f143002", bucket(itemProfileFeature.getWeekClickCnt(), bigCntBucket).toString());
                retMap.put("f143003", bucket(itemProfileFeature.getDayClickCnt(), bigCntBucket).toString());
                retMap.put("f143004", bucket(itemProfileFeature.getEffectCnt(), bigCntBucket).toString());
                retMap.put("f143005", bucket(itemProfileFeature.getWeekEffectCnt(), bigCntBucket).toString());
                retMap.put("f143006", bucket(itemProfileFeature.getDayEffectCnt(), bigCntBucket).toString());
                retMap.put("f143007", bucket(itemProfileFeature.getIssueEffectCnt(), bigCntBucket).toString());
                retMap.put("f143008", bucket(itemProfileFeature.getWeekIssueEffectCnt(), bigCntBucket).toString());
                retMap.put("f143009", bucket(itemProfileFeature.getSignEffectCnt(), bigCntBucket).toString());
                retMap.put("f143010", bucket(itemProfileFeature.getWeekSignEffectCnt(), bigCntBucket).toString());

                // 衍生信息
                retMap.put("f144001", bucket(itemProfileFeature.getCtr(), statCtrBucket).toString());
                retMap.put("f144002", bucket(itemProfileFeature.getWeekCtr(), statCtrBucket).toString());
                retMap.put("f144003", bucket(itemProfileFeature.getDayCtr(), statCtrBucket).toString());
                retMap.put("f144004", bucket(itemProfileFeature.getCvr(), statCvrBucket).toString());
                retMap.put("f144005", bucket(itemProfileFeature.getWeekCvr(), statCvrBucket).toString());
                retMap.put("f144006", bucket(itemProfileFeature.getDayCvr(), statCvrBucket).toString());
                retMap.put("f144007", bucket(itemProfileFeature.getIecvr(), statCvrBucket).toString());
                retMap.put("f144008", bucket(itemProfileFeature.getWeekIecvr(), statCvrBucket).toString());
                retMap.put("f144009", bucket(itemProfileFeature.getSecvr(), statCvrBucket).toString());
                retMap.put("f144010", bucket(itemProfileFeature.getWeekSecvr(), statCvrBucket).toString());
                retMap.put("f999999", getFeatureCross(cf.getOperatingNewTrade(), staticCf.getAqyGender()));

                JSONObject weekLaunchTradeActMap = DataUtil.stringToJson(userActFeature.getWeekLaunchTrade());
                retMap.put("f413009", getUserCategoryLaunchTrade(weekLaunchTradeActMap, cf.getOperatingNewTrade()));

                // 性别交叉特征
                String aqyGender = staticCf.getAqyGender() == null || staticCf.getAqyGender().trim().equals("") ? "un" : staticCf.getAqyGender();
                retMap.put("f4510111", tradeId + "_" + aqyGender);
                retMap.put("f4510112", accountId + "_" + aqyGender);
                retMap.put("f4510113", advertId + "_" + aqyGender);

                // 年龄交叉特征
                UserProfileFeature upf = Optional.ofNullable(staticCf.getUserProfileFeature()).orElse(new UserProfileFeature());
                String age = upf.getAge() == null || upf.getAge().trim().equals("") ? "un" : upf.getAge();
                retMap.put("f4510021", tradeId + "_" + age);
                retMap.put("f4510022", accountId + "_" + age);
                retMap.put("f4510023", advertId + "_" + age);

                // 性别+年龄
                retMap.put("f4510024", aqyGender + "_" + age);

                // 广告标签特征 20210201
                AdvertTagFeature atf = Optional.ofNullable(cf.getAdvertTagFeature()).orElse(new AdvertTagFeature());
                // 通用/整合
                retMap.put("f151001", atf.getBrand());  // 品牌
                retMap.put("f151002", advertTagConcat(",", atf.getCardType(), atf.getCategory(), atf.getSubject(), atf.getRegion()));  // 卡形式+品类+学科+地域
                retMap.put("f151003", atf.getGood());  // 商品
                retMap.put("f151004", atf.getPriceRange());  // 价格区间
//                retMap.put("f151005", atf.getPrice());  // 价格
                retMap.put("f151006", advertTagConcat(",", atf.getPathType(), atf.getPayment(), atf.getTeachingType()));  // 链路类型+支付方式+教学形式
                retMap.put("f151007", atf.getBenefit());  // 附加利益点
                retMap.put("f151008", atf.getFrontPageActivity());  // 前置页活动
                // 保险
                retMap.put("f151101", atf.getShortTermType());  // 保险-短险险种
                retMap.put("f151102", atf.getShortTermAmount());  // 保险-短险保额
                retMap.put("f151103", atf.getPresentType());  // 保险-赠险险种
                retMap.put("f151104", atf.getPresentAmount());  // 保险-赠险保额
                retMap.put("f151105", atf.getPathType());
                // 教育
                retMap.put("f151201", atf.getAgeGroup());// 教育-适用年龄段
                retMap.put("f151202", atf.getSubject());
                retMap.put("f151203", atf.getTeachingType());
                // 运营商
                retMap.put("f151301", advertTagConcat(",", atf.getPhoneCard(), atf.getPhoneCharge(), atf.getPhoneFlow(), atf.getMember()));   // 运营商-商品-二级标签：手机卡+话费+流量+会员
                retMap.put("f151302", atf.getRegion());
                retMap.put("f151303", atf.getPhoneCard());
                retMap.put("f151304", atf.getPhoneCharge());
                retMap.put("f151305", atf.getPhoneFlow());
                retMap.put("f151306", atf.getMember());
                // 会籍卡
                retMap.put("f151401", atf.getCardType());
                // 货到付款
                retMap.put("f151501", atf.getCategory());
                retMap.put("f151502", atf.getPayment());

                // 广告与运营商标签交叉
                String operatorType = staticCf.getOperatorType() == null ? "op" : staticCf.getOperatorType();
                retMap.put("f5070011", advertId + "_" + operatorType);

                String operatorName = getOperatorName(staticCf.getOperatorType());
                // f660001 getOperatingNewTrade
                String brandStr = atf.getBrand() == null ? "unk_bd" : atf.getBrand();
                String goodStr = atf.getGood() == null ? "unk_gd" : atf.getGood();

                retMap.put("f5070012", getOperatorBrandMatch(operatorName, atf.getBrand(), cf.getOperatingNewTrade()));
                retMap.put("f5070013", brandStr + "_" + operatorName);
                retMap.put("f5070014", goodStr + "_" + operatorName);
                retMap.put("f5070015", accountId + "_" + operatorName);
                retMap.put("f5070016", tradeId + "_" + operatorName);
                retMap.put("f5070017", appId + "_" + operatorName);

                // 设备信息与广告信息交叉
                String phoneModel = staticCf.getPhoneModelCode() == null ? "" : staticCf.getPhoneModelCode();
                String phoneBrand = staticCf.getBrandNameEn() == null ? "" : staticCf.getBrandNameEn();
                retMap.put("f5090011", advertId + "_" + phoneModel);
                retMap.put("f5090012", tradeId + "_" + phoneModel);
                retMap.put("f5090021", advertId + "_" + phoneBrand);
                retMap.put("f5090022", tradeId + "_" + phoneBrand);
            }


        } catch (Exception e) {
            logger.error("FeatureParse.generateFeatureMapDynamic error", e);

        }
        return retMap;
    }


//    public static Map<String, String> getFeatureMap(FeatureDo cf) {
//
//        Map<String, String> retMap = new HashMap<>();
//        try {
//            generateFeatureMapStatic(cf);
//            generateFeatureMapDynamic(cf, retMap);
//
//        } catch (Exception e) {
//
//            e.printStackTrace();
//        }
//
//        return retMap;
//    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<>();
        map.put("a", "b");
        System.out.println(getValueSafety("a", map));

        HashMap<String, String> m = null;
        System.out.println(getValueSafety(null, map));
    }

    public static <T> String setJoin(Set<T> set, String sep) {
        if (AssertUtil.isAnyEmpty(set, sep)) {
            return null;
        }

        StringBuilder res = new StringBuilder();
        for (T s : set) {
            res.append(s).append(sep);
        }

        if (res.length() > 0) {
            return res.substring(0, res.length() - 1);
        }

        return res.toString();
    }


    public static <T> String userBehaviourCross(String exposeTopTarget, Set<T> behaviour) {

        String res = null;

        if (exposeTopTarget != null && exposeTopTarget.length() > 0 && behaviour != null && behaviour.size() > 0) {
            StringBuilder sb = new StringBuilder();

            for (T advert : behaviour) {
                if (advert != null && advert.toString().trim().length() > 0) {
                    sb.append(advert).append("_").append(exposeTopTarget).append(",");
                }
            }

            if (sb.length() > 0) {
                res = sb.substring(0, sb.length() - 1);
            }
        }

        return res;
    }

    public static String getOperatorBrandMatch(String operator, String brand, String trade) {
        // 仅在运营商行业下判断
        if (trade != null && trade.equals("16")) {
            if (operator == null || brand == null) {
                return "0";
            } else if (operator.equals(brand)) {
                return "1";
            } else {
                return "2";
            }
        } else {
            return "4";
        }
    }

    public static String getOperatorName(String op) {
        if (op == null) {
            return "未知";
        } else if (op.equals("1")) {
            return "移动";
        } else if (op.equals("2")) {
            return "联通";
        } else if (op.equals("3")) {
            return "电信";
        } else {
            return "未知";
        }
    }

    public static String advertTagConcat(String sep, String ... tags) {
        StringBuilder res = new StringBuilder();

        for (String tag : tags) {
            if (tag != null && tag.trim().length() > 0 && !tag.trim().equals("null")) {
                res.append(tag).append(sep);
            }
        }

        if (res.length() > 0) {
            return res.substring(0, res.length() - 1);
        }

        return res.toString();
    }


    public static String getAdAndSubType(Long advertId, String subType) {
        String ret = null;

        if (advertId != null) {
            Long retTmp = advertId + (getSubType(subType) + 1) * 1000000;
            ret = retTmp + "";
        }
        return ret;
    }

    public static Long getSubType(String subType) {
        Long ret = 0L;
        if (subType != null) {
            ret = Long.valueOf(subType);
        }

        return ret;
    }

    public static Long getCtrIntervelLevel(Double ctr) {

        Long ret = null;

        if (ctr == null) {
            ret = -1L;
        } else if (ctr <= 0.999) {
            ret = Math.round((ctr * 100) / 3);
        } else {
            ret = -1L;
        }
        return ret;
    }

    public static Long getCvrIntervelLevel(Double cvr) {

        Long ret = null;


        if (cvr == null) {
            ret = -1L;
        } else if (cvr <= 0.04) {
            ret = Math.round((cvr * 1000) / 4);
        } else if (cvr <= 0.999) {
            ret = 11 + Math.round(((cvr - 0.04) * 100) / 3);
        } else {
            ret = -1L;
        }
        return ret;
    }


    /**
     * @param date      新时间 大
     * @param otherDate 旧时间 小
     * @return
     */
    public static Long getOrderGmtIntervel(String date, String otherDate) {

        return LocalDateUtil.getIntervalMinutes(date, otherDate, DateStyle.YYYY_MM_DD_HH_MM_SS, DateStyle.YYYY_MM_DD_HH_MM_SS);


    }


    public static Long getOrderGmtIntervelLevel(String date, String otherDate) {

        Long ret = null;
        Long minutes = LocalDateUtil.getIntervalMinutes(date, otherDate, DateStyle.YYYY_MM_DD_HH_MM_SS, DateStyle.YYYY_MM_DD_HH_MM_SS);

        if (minutes == null) {
            ret = -1L;
        } else if (minutes <= 5) {
            ret = 1L;
        } else if (minutes <= 10) {
            ret = 2L;
        } else if (minutes <= 30) {
            ret = 3L;
        } else if (minutes <= 60) {
            ret = 4L;
        } else {
            ret = 99L;
        }
        return ret;

    }

    public static Long getDayRankLevel(Long rank) {

        Long ret = null;
        if (rank == null) {
            ret = null;
        } else if (rank <= 7) {
            ret = rank;
        } else {
            ret = -1L;
        }
        return ret;
    }


    public static Long getRankLevel(Long rank) {

        Long ret = null;
        if (rank == null) {
            ret = null;
        } else if (rank <= 15) {
            ret = rank;
        } else {
            ret = -1L;
        }
        return ret;
    }

    public static Long getChargeStatus(Long chargeNums) {

        Long ret = null;
        if (chargeNums == null || chargeNums < 1) {
            ret = 0L;
        } else {
            ret = 1L;
        }
        return ret;
    }

    public static Long getMatchStatus(String s1, String s2) {
        if (s1 == null) {
            return 0L;
        } else if (!s1.equals(s2)) {
            return 1L;
        } else {
            return 2L;
        }
    }

    public static Long getActivityChangeStatus(Long operatingActivityId, Long lastOperatingActivityId) {

        Long ret = null;
        if (operatingActivityId == null || lastOperatingActivityId == null) {
            ret = 0L;
        } else if (operatingActivityId.equals(lastOperatingActivityId)) {
            ret = 1L;
        } else {
            ret = 0L;
        }
        return ret;
    }


    public static Long getLastTagChangeStatus(String matchTagNums, String lastMatchTagNums) {

        Long ret = null;
        if (matchTagNums == null || lastMatchTagNums == null) {
            ret = 0L;
        } else if (matchTagNums.equals(lastMatchTagNums)) {
            ret = 1L;
        } else {
            ret = 0L;
        }
        return ret;
    }

    /**
     * 是否大于1天
     *
     * @param userLastlogbigintime
     * @param userRegtime
     * @return
     */
    public static Long isOld(Date userLastlogbigintime, Date userRegtime) {
        Long ret = (long) 0;

        if (AssertUtil.isAllNotEmpty(userLastlogbigintime, userRegtime)) {
            Long dayIntervals = LocalDateUtil.getIntervalDays(userLastlogbigintime, userRegtime);
            if (dayIntervals != null) {
                ret = dayIntervals > 1 ? (long) 1 : (long) 0;
            }
        }

        return ret;

    }


    public static Long getCost(Long cost, Long price) {
        Long ret = null;
        if (cost != null && price != null && cost > 0) {
            ret = (long) (new Double(Math.ceil((price + 0.000001) / (cost))).intValue());
        }
        return ret;

    }

    public static Long getLog(Long lvalue) {
        Long ret = null;
        if (lvalue != null && lvalue > 0) {
            ret = (long) (new Double(Math.ceil(log(lvalue.doubleValue(), 2 / 0))).intValue());
        }
        return ret;

    }

    public static <K, V> V getValueSafety(K key, Map<K, V> map) {
        if (AssertUtil.isAnyEmpty(key, map)) {
            return null;
        }

        return map.get(key);
    }

    public static Map<String, Long> getMap(String keyList, String valueList) {
        HashMap<String, Long> resMap = new HashMap<>();

        if (AssertUtil.isAnyEmpty(keyList, valueList)) {
            return resMap;
        }

        String[] keys = keyList.split(",");
        String[] values = valueList.split(",");

        if (keys.length != values.length) {
            return resMap;
        }

        for (int i = 0; i < keys.length; i ++) {
            Long value = null;
            try {
                value = Long.parseLong(values[i]);
            } catch (NumberFormatException e) {
                continue;
            }
            resMap.put(keys[i], value);
        }

        return resMap;
    }


    public static String getLevel(String key, String idlist, String valueList) {
        String s = "";

        if ((idlist == null || valueList == null) || (idlist.isEmpty() || valueList.isEmpty())) {
            return null;
        }
        String idArr[] = idlist.split(",");
        String valueArr[] = valueList.split(",");
        if (idArr.length != valueArr.length) {
            return null;
        }

        for (int i = 0; i < idArr.length; ++i) {

            double value = 0;
            try {
                value = Double.parseDouble(valueArr[i]);
            } catch (NumberFormatException e) {
                continue;
            } catch (NullPointerException e) {
                continue;
            }
            s += idArr[i] + "&" + String.valueOf(discretization(key, value)) + ",";


        }
        if (!s.isEmpty()) {
            s = s.substring(0, s.length() - 1);
        }
        return s;

    }

    public static int discretization(String key, double value) {
        int class_id = 0;
        switch (key) {
            case "launch_pv":
                if (value > -100000000 & value <= 0) class_id = 1;
                else if (value > 0 & value <= 1) class_id = 2;
                else if (value > 1 & value <= 2) class_id = 3;
                else if (value > 2 & value <= 3) class_id = 4;
                else if (value > 3 & value <= 4) class_id = 5;
                else if (value > 4 & value <= 5) class_id = 6;
                else if (value > 5 & value <= 6) class_id = 7;
                else if (value > 6 & value <= 7) class_id = 8;
                else if (value > 7 & value <= 18) class_id = 9;
                else if (value > 18 & value <= 50) class_id = 10;
                else if (value > 50 & value <= 150) class_id = 11;
                else if (value > 150 & value <= 300) class_id = 12;
                else class_id = 13;
                break;
            case "click_pv":
                if (value > -100000000 & value <= 0) class_id = 1;
                else if (value > 0 & value <= 1) class_id = 2;
                else if (value > 2 & value <= 3) class_id = 3;
                else if (value > 3 & value <= 4) class_id = 4;
                else if (value > 4 & value <= 5) class_id = 5;
                else if (value > 5 & value <= 6) class_id = 6;
                else if (value > 6 & value <= 8) class_id = 7;
                else if (value > 8 & value <= 15) class_id = 8;
                else if (value > 15 & value <= 80) class_id = 9;
                else if (value > 80 & value <= 225) class_id = 10;
                else class_id = 11;
                break;
            case "effect_pv":
                if (value > -100000000 & value <= 0) class_id = 1;
                else if (value > 0 & value <= 1) class_id = 2;
                else if (value > 1 & value <= 2) class_id = 3;
                else if (value > 2 & value <= 3) class_id = 4;
                else if (value > 4 & value <= 15.0) class_id = 5;
                else if (value > 15.0 & value <= 25) class_id = 6;
                else if (value > 25.0 & value <= 70) class_id = 7;
                else if (value > 70 & value <= 150) class_id = 8;
                else if (value > 150 & value <= 225) class_id = 9;
                else class_id = 10;
                break;
            case "score":
                if (value > -100000000 & value <= -471) class_id = 1;
                else if (value > -471 & value <= -331) class_id = 2;
                else if (value > -331 & value <= -168) class_id = 3;
                else if (value > -168 & value <= -52) class_id = 4;
                else if (value > -52 & value <= -19) class_id = 5;
                else if (value > -19 & value <= -8) class_id = 6;
                else if (value > -8 & value <= -4) class_id = 7;
                else if (value > -4 & value <= 1) class_id = 8;
                else if (value > 1 & value <= 2) class_id = 9;
                else if (value > 2 & value <= 17) class_id = 10;
                else if (value > 17 & value <= 42) class_id = 11;
                else if (value > 42 & value <= 73) class_id = 12;
                else if (value > 73 & value <= 126) class_id = 13;
                else if (value > 126 & value <= 284) class_id = 14;
                else class_id = 15;
                break;

        }
        return class_id;
    }


    /**
     * 用户行为数据解析
     *
     * @return
     */
    public static String getUserBehavioralPreference(int dimType, String statType, Map<String, Map<String, Long>> ubpMap, String tags) {

        String ret = null;
        try {
            // 全局
            if (dimType == 0 && ubpMap != null) {
                ret = DataUtil.Long2String(ubpMap.get(statType).get("0"));


            }
            // 当前广告
            if (dimType == 1 && ubpMap != null) {
                String tag = getTag(tags);

                if (tag != null) {
                    ret = ubpMap.get(statType).get(tag) + "";

                    if (tag.length() == 10 && ret == null) {
                        String sTag = tag.substring(0, 5);
                        ret = DataUtil.Long2String(ubpMap.get(statType).get(sTag));
                    }


                }
            }

            // 其他行业
            if (dimType == 2 && AssertUtil.isNotEmpty(ubpMap.get(statType))) {
                ret = "";
                for (Map.Entry<String, Long> entry : ubpMap.get(statType).entrySet()) {
                    String v = entry.getKey() + "_" + entry.getValue() + ",";
                    ret += v;
                }

                if (ret.endsWith(",")) {
                    ret = ret.substring(0, ret.length() - 1);
                }

            }


            //统计计数
            if (dimType == 3 && AssertUtil.isNotEmpty(ubpMap.get(statType))) {

                ret = "";
                Map<Long, Long> levelCntMap = new HashMap<>();

//                System.out.println("statType=" + statType);

//                for (long i = 0; i < ctrAndCvrLevelBucket.length + 2; i++) {
//                    levelCntMap.put(i, 0L);
//                }


                for (Map.Entry<String, Long> entry : ubpMap.get(statType).entrySet()) {
                    String tag = entry.getKey();
                    Long ctrLevel = bucket(entry.getValue(), ctrAndCvrLevelBucket);
                    if (ctrLevel != null && tag != "0") {
                        if (!levelCntMap.containsKey(ctrLevel)) {
                            levelCntMap.put(ctrLevel, 0L);
                        }
                        levelCntMap.put(ctrLevel, levelCntMap.get(ctrLevel) + 1);
//                        System.out.println("entry.getValue()=" + entry.getValue() + ",ctrLevel=" + ctrLevel + ",+1");
                    }
                }

                for (Map.Entry<Long, Long> entry : levelCntMap.entrySet()) {
                    if (entry.getKey() != null && entry.getValue() != null) {

                        Long cntLevel = bucket(entry.getValue(), cntBucket);
//                        System.out.println("entry.getKey()=" + entry.getKey() + "entry.getValue()=" + entry.getValue() + ",cntLevel=" + cntLevel + "+1");
                        String v = entry.getKey() * 100 + cntLevel + ",";
                        ret += v;
                    }

                }


                if (ret.endsWith(",")) {
                    ret = ret.substring(0, ret.length() - 1);
                }

            }


        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

    public static String getTag(String tags) {
        String ret = null;
        if (AssertUtil.isNotEmpty(tags)) {
            String[] tagArr = tags.split(",");
            if (AssertUtil.isNotEmpty(tagArr)) {
                for (int i = 0; i < tagArr.length; i++) {
                    String tmp = validTag(tagArr[i]);
                    if (tmp != null) {
                        ret = validTag(tagArr[i]);
                    }

                }
            }
        }

        return ret;
    }

    public static String validTag(String tag) {
        String ret = null;
        if (AssertUtil.isNotEmpty(tag)) {
            if (tag.contains(".")) {
                ret = tag;
            }
        }
        return ret;
    }


    /**
     * 用户行为数据解析
     *
     * @param uIIds
     * @param uILaunchPv
     * @param uIClickPv
     * @param uIEffectPv
     * @return
     */
    public static Map<String, Map<String, Long>> getUserBehavioralPreference(String uIIds,
                                                                             String uILaunchPv,
                                                                             String uIClickPv,
                                                                             String uIEffectPv) {
        Map<String, Map<String, Long>> ret = new HashMap<>();
        ret.put("ctr", new HashMap<String, Long>());
        ret.put("cvr", new HashMap<String, Long>());
        if (AssertUtil.isAllNotEmpty(uIIds, uILaunchPv, uIClickPv, uIEffectPv)) {
            String[] uIIdsArr = uIIds.split(",");
            String[] uILaunchPvArr = uILaunchPv.split(",");
            String[] uIClickPvArr = uIClickPv.split(",");
            String[] uIEffectPvArr = uIEffectPv.split(",");

            if (uIIdsArr.length > 0 &&
                    uIIdsArr.length == uILaunchPvArr.length &&
                    uIIdsArr.length == uIClickPvArr.length &&
                    uIIdsArr.length == uIEffectPvArr.length) {

                Long launchAccPv = 0L;
                Long clickAccPv = 0L;
                Long effectAccPv = 0L;


                for (int i = 0; i < uIIdsArr.length; i++) {
                    String id = uIIdsArr[i];
//                    System.out.println("uIIdsArr[i]=" + uIIdsArr[i]);
//                    System.out.println("uILaunchPvArr[i]=" + uILaunchPvArr[i]);
//                    System.out.println("uIClickPvArr[i]=" + uIClickPvArr[i]);
//                    System.out.println("uIEffectPvArr[i]=" + uIEffectPvArr[i]);

                    Long launchPv = DataUtil.str2Long(uILaunchPvArr[i], 0L);
                    Long clickPv = DataUtil.str2Long(uIClickPvArr[i], 0L);
                    Long effectPv = DataUtil.str2Long(uIEffectPvArr[i], 0L);

//                    System.out.println("launchPv=" + launchPv);
//                    System.out.println("clickPv=" + clickPv);
//                    System.out.println("effectPv=" + effectPv);

                    Double ctr = getCtrOrCvr(launchPv, clickPv);
                    Double cvr = getCtrOrCvr(clickPv, effectPv);

                    Long ctrBucketLevel = bucket(ctr, userCtrBucket);
                    Long cvrBucketLevel = bucket(cvr, userCvrBucket);

                    ret.get("ctr").put(id, ctrBucketLevel);
                    ret.get("cvr").put(id, cvrBucketLevel);

                    launchAccPv += launchPv;
                    clickAccPv += clickPv;
                    effectAccPv += effectPv;

                }
                Double ctr = getCtrOrCvr(launchAccPv, clickAccPv);
                Double cvr = getCtrOrCvr(clickAccPv, effectAccPv);

                Long ctrBucketLevel = bucket(ctr, userCtrBucket);
                Long cvrBucketLevel = bucket(cvr, userCvrBucket);

                ret.get("ctr").put("0", ctrBucketLevel);
                ret.get("cvr").put("0", cvrBucketLevel);

            }


        }

        return ret;
    }


    /**
     * @param firstPv  分母 非空
     * @param secondPv 分子 非空
     * @return
     */
    public static Double getCtrOrCvr(Long firstPv, Long secondPv) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty(firstPv, secondPv) && firstPv > 0)
            ret = DataUtil.division(secondPv, firstPv);

        return ret;
    }

    /**
     * 分桶函数1
     * <p>
     * 左开又闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return
     */
    public static Long bucket(Long value, int[] bucketList) {
        long ret = 0;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; i++) {
                int bound = bucketList[i];

                if (value <= bound) {
                    ret = i + 1;
                    break;
                }
            }


        }
        return ret;
    }

    /**
     * 分桶函数2
     * <p>
     * 左开又闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return
     */
    public static Long bucket(Double value, double[] bucketList) {
        long ret = 0;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; i++) {
                double bound = bucketList[i];

                if (value <= bound) {
                    ret = i + 1;
                    break;
                }
            }


        }
        return ret;
    }

    public static Long bucketBSearch(Double value, double[] arr) {
        if (value == null || arr == null || arr.length == 0) {
            return 0L;
        }

        int low = 0;
        int high = arr.length - 1;

        if (value > arr[arr.length - 1]) {
            return (long) arr.length + 1;
        }

        while (low <= high) {
            int mid = low + ((high - low) >> 1);

            if (arr[mid] >=  value) {
                if (mid == 0 || arr[mid - 1] < value) {
                    return (long) mid + 1;
                } else {
                    high = mid - 1;
                }
            } else {
                low = mid + 1;
            }
        }

        return 0L;
    }

    public static <T> Map<T, Long> mapBucket(Map<T, Double> map, double[] bucketList) {
        if (AssertUtil.isAnyEmpty(map, bucketList)) {
            return null;
        }

        HashMap<T, Long> resMap = new HashMap<>();

        for (Map.Entry<T, Double> entry : map.entrySet()) {
            resMap.put(entry.getKey(), bucketBSearch(entry.getValue(), bucketList));
        }

        return resMap;
    }

    /**
     * 分桶函数3
     * <p>
     * 左开又闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return
     */
    public static Long bucket(Integer value, int[] bucketList) {
        long ret = 0;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; i++) {
                int bound = bucketList[i];

                if (value <= bound) {
                    ret = i + 1;
                    break;
                }
            }


        }
        return ret;
    }


    public static double log(double value, double base) {
        return Math.log(value) / Math.log(base);
    }


    // 20180815 广告位尺寸类型
    public static String getSlotAreaType(Integer slotLength, Integer slotWidth) {
        int ret1 = 12;
        if (slotLength == null || slotWidth == null) {
            return String.valueOf(ret1);
        }
        try {
            Integer area = slotLength * slotWidth;

            if (area >= 0 && area <= 500000) {
                ret1 = (int) (area / 50000);
            }
            if (area > 500000 && area != null) {
                ret1 = 11;
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

        return String.valueOf(ret1);

    }


    /**
     * @param categoryCount
     * @param categoryType
     * @return
     */
    public static String categoryIdAndCnt(Map<String, Long> categoryCount, Integer categoryType) {
        String ret1 = null;
        if (categoryCount == null) {
            return ret1;
        }

        if (categoryType == 1) {
            for (Map.Entry<String, Long> entry : categoryCount.entrySet()) {
                String key = entry.getKey();
                try {
                    Long value = entry.getValue();
                    String valueRet = null;
                    if (value >= 1 && value <= 3) {
                        valueRet = "g1";
                    } else if (value >= 4 && value <= 10) {
                        valueRet = "g2";
                    } else if (value >= 11 && value <= 20) {
                        valueRet = "g3";
                    } else {
                        valueRet = "g4";
                    }
                    String ret = key + "&" + valueRet;
                    ret1 = ret1 + "," + ret;
                } catch (Exception e) {
                    e.printStackTrace();
                }

            }
        } else {

            for (Map.Entry<String, Long> entry : categoryCount.entrySet()) {
                String key = entry.getKey();
                try {
                    Long value = entry.getValue();
                    String valueRet = null;
                    if (value == 1) {
                        valueRet = "g1";
                    } else if (value == 2 || value == 3) {
                        valueRet = "g2";
                    } else if (value >= 4 && value <= 8) {
                        valueRet = "g3";
                    } else {
                        valueRet = "g4";
                    }
                    String ret = key + "&" + valueRet;
                    ret1 = ret1 + "," + ret;

                } catch (Exception e) {
                    e.printStackTrace();
                }

            }
        }
        return ret1;
    }


    //20190123
    //计算用户当日该资源下发券次序(分桶)f770102
    public static Long getResourceOrderRank(String operatingResource, Map<String, Long> dayResourceOrderRank) {
        Long ret = null;
        if (operatingResource == null || dayResourceOrderRank == null) {
            ret = null;
        } else {
            Long rank = dayResourceOrderRank.get(operatingResource);
            if (rank == null || rank < 1) {
                ret = 1L;
            } else if (rank <= 7) {
                ret = rank + 1;
            } else {
                ret = -1L;
            }
        }
        return ret;
    }

    // 计算用户该资源当前单与前一单时间差（分桶）f770202
    public static Long getResourceOrderGmtIntervelLevel(String operatingResource, String currentGmtCreateTime, Map<String, String> resourceLastGmtCreateTime) {
        Long ret = null;
        if (operatingResource == null || currentGmtCreateTime == null || resourceLastGmtCreateTime == null) {
            ret = null;
        } else {
            String lastGmtCreateTime = resourceLastGmtCreateTime.get(operatingResource);
            if (lastGmtCreateTime == null) {
                ret = null;
            } else {
//                Date date = DateUtil.StringToDate(currentGmtCreateTime, DateStyle.YYYY_MM_DD_HH_MM_SS);
//                if (date == null) {
//                    return null;
//                }
//                Long timeStamp = date.getTime();

                Long timeStamp = LocalDateUtil.getTimeMillis(currentGmtCreateTime, DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());

                Long otherTimeStamp = Long.valueOf(lastGmtCreateTime);
                if (timeStamp == null || otherTimeStamp == null) {
                    return ret;
                }
                Long seconds = (long) (Math.abs((timeStamp - otherTimeStamp) / 1000));

                if (seconds == null) {
                    ret = -1L;
                } else if (seconds <= 5) {
                    ret = 1L;
                } else if (seconds <= 10) {
                    ret = 2L;
                } else if (seconds <= 30) {
                    ret = 3L;
                } else if (seconds <= 60) {
                    ret = 4L;
                } else if (seconds <= 5 * 60) {
                    ret = 5L;
                } else if (seconds <= 10 * 60) {
                    ret = 6L;
                } else if (seconds <= 30 * 60) {
                    ret = 7L;
                } else if (seconds <= 60 * 60) {
                    ret = 8L;
                } else if (seconds <= 5 * 60 * 60) {
                    ret = 9L;
                } else if (seconds <= 10 * 60 * 60) {
                    ret = 10L;
                } else if (seconds <= 15 * 60 * 60) {
                    ret = 11L;
                } else if (seconds <= 20 * 60 * 60) {
                    ret = 12L;
                } else if (seconds <= 24 * 60 * 60) {
                    ret = 13L;
                } else if (seconds <= 36 * 60 * 60) {
                    ret = 14L;
                } else if (seconds <= 48 * 60 * 60) {
                    ret = 15L;
                } else {
                    ret = 99L;
                }
            }
        }
        return ret;
    }

    public static Long getResourceOrderGmtIntervelLevelOneId(String operatingResource, String currentGmtCreateTime, Map<String, String> resourceLastGmtCreateTime) {
        Long ret = null;
        if (operatingResource == null || currentGmtCreateTime == null || resourceLastGmtCreateTime == null) {
            ret = null;
        } else {
            String lastGmtCreateTime = resourceLastGmtCreateTime.get(operatingResource);
            if (lastGmtCreateTime == null) {
                ret = null;
            } else {
//                Date date = DateUtil.StringToDate(currentGmtCreateTime, DateStyle.YYYY_MM_DD_HH_MM_SS);
//                if (date == null) {
//                    return null;
//                }
//                Long timeStamp = date.getTime();

                Long timeStamp = LocalDateUtil.getTimeMillis(currentGmtCreateTime, DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());

                Long otherTimeStamp = LocalDateUtil.getTimeMillis(lastGmtCreateTime, DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                if (timeStamp == null || otherTimeStamp == null) {
                    return ret;
                }
                Long seconds = (long) (Math.abs((timeStamp - otherTimeStamp) / 1000));

                if (seconds == null) {
                    ret = -1L;
                } else if (seconds <= 5) {
                    ret = 1L;
                } else if (seconds <= 10) {
                    ret = 2L;
                } else if (seconds <= 30) {
                    ret = 3L;
                } else if (seconds <= 60) {
                    ret = 4L;
                } else if (seconds <= 5 * 60) {
                    ret = 5L;
                } else if (seconds <= 10 * 60) {
                    ret = 6L;
                } else if (seconds <= 30 * 60) {
                    ret = 7L;
                } else if (seconds <= 60 * 60) {
                    ret = 8L;
                } else if (seconds <= 5 * 60 * 60) {
                    ret = 9L;
                } else if (seconds <= 10 * 60 * 60) {
                    ret = 10L;
                } else if (seconds <= 15 * 60 * 60) {
                    ret = 11L;
                } else if (seconds <= 20 * 60 * 60) {
                    ret = 12L;
                } else if (seconds <= 24 * 60 * 60) {
                    ret = 13L;
                } else if (seconds <= 36 * 60 * 60) {
                    ret = 14L;
                } else if (seconds <= 48 * 60 * 60) {
                    ret = 15L;
                } else {
                    ret = 99L;
                }
            }
        }
        return ret;
    }

    // 用户该资源前一单是否计费 f770301
    public static Long getResourceLastOrderIsClick(String operatingResource, Map<String, String> resourceLastLaunchOrderId, Map<String, String> resourceLastClickOrderId) {
        Long ret = null;
        if (operatingResource == null || resourceLastLaunchOrderId == null || resourceLastClickOrderId == null) {
            ret = null;
        } else {
            String lastLaunchOrderId = resourceLastLaunchOrderId.get(operatingResource + "-770301_1");
            String lastClickOrderId = resourceLastClickOrderId.get(operatingResource + "-770301_2");

            if (lastLaunchOrderId == null) {
                ret = null;
            } else {
                if (lastClickOrderId == null) {
                    ret = 0L;
                } else {
                    if (lastLaunchOrderId.equals(lastClickOrderId)) {
                        ret = 1L;
                    } else {
                        ret = 0L;
                    }
                }
            }
        }
        return ret;
    }

    // 用户该资源前一单是否转化 f770302
    public static Long getResourceLastOrderIsConvert(String operatingResource, Map<String, String> resourceLastLaunchOrderId, Map<String, String> resourceLastConvertOrderId) {
        Long ret = null;
        if (operatingResource == null || resourceLastLaunchOrderId == null || resourceLastConvertOrderId == null) {
            ret = null;
        } else {
            String lastLaunchOrderId = resourceLastLaunchOrderId.get(operatingResource + "-770301_1");
            String lastConvertOrderId = resourceLastConvertOrderId.get(operatingResource + "-770301_3");

            if (lastLaunchOrderId == null) {
                ret = null;
            } else {
                if (lastConvertOrderId == null) {
                    ret = 0L;
                } else {
                    if (lastLaunchOrderId.equals(lastConvertOrderId)) {
                        ret = 1L;
                    } else {
                        ret = 0L;
                    }
                }
            }
        }
        return ret;
    }

    //当日用户该资源累计点击数 f770401
    public static Long getResourceChargeCnt(String operatingResource, Map<String, Long> dayResourceChargeCnt) {
        Long ret = null;
        if (operatingResource == null || dayResourceChargeCnt == null) {
            ret = null;
        } else {
            Long cnt = dayResourceChargeCnt.get(operatingResource);
            if (cnt == null || cnt < 1) {
                ret = 0L;
            } else if (cnt <= 7) {
                ret = cnt;
            } else {
                ret = -1L;
            }
        }
        return ret;
    }

    //当日用户该资源累计转化数 f770402
    public static Long getResourceConvertCnt(String operatingResource, Map<String, Long> dayResourceConvertCnt) {
        Long ret = null;
        if (operatingResource == null || dayResourceConvertCnt == null) {
            ret = null;
        } else {
            Long cnt = dayResourceConvertCnt.get(operatingResource);
            if (cnt == null || cnt < 1) {
                ret = 0L;
            } else if (cnt <= 7) {
                ret = cnt;
            } else {
                ret = -1L;
            }
        }
        return ret;
    }

    //计算用户当前单与前一单资源是否相同f770501
    public static Long getLastResourceEqualStatus(String operatingResource, String lastOperatingResource) {
        Long ret = null;
        if (operatingResource == null && lastOperatingResource == null) {
            ret = null;

        } else if (operatingResource != null && lastOperatingResource != null) {
            if (operatingResource.equals(lastOperatingResource)) {
                ret = 1L;
            } else {
                ret = 0L;
            }

        } else {
            ret = 0L;
        }
        return ret;
    }


    //20190507
    //计算用户当日该综合行业下发券次序(分桶) f660102
    public static Long getNewTradeOrderRank(String operatingNewTrade, Map<String, Long> newTradeDayOrderRank) {
        Long ret = null;
        if (AssertUtil.isAllNotEmpty(operatingNewTrade, newTradeDayOrderRank)) {
            Long rank = newTradeDayOrderRank.get(operatingNewTrade + "-660101");
            if (rank == null || rank < 1) {
                ret = 1L;
            } else if (rank <= 7) {
                ret = rank + 1;
            } else {
                ret = 99L;
            }
        }
        return ret;
    }

    //计算用户当前单与前一单的综合行业是否相同 f660201
    public static Long getLastNewTradeEqualStatus(String operatingNewTrade, String lastOperatingNewTrade) {
        Long ret = 0L;
        if (AssertUtil.isAllEmpty(operatingNewTrade, lastOperatingNewTrade)) {
            ret = null;
        } else if (AssertUtil.isAllNotEmpty(operatingNewTrade, lastOperatingNewTrade)) {
            if (operatingNewTrade.equals(lastOperatingNewTrade)) {
                ret = 1L;
            } else {
                ret = 0L;
            }
        }
        return ret;
    }

    //计算用户当日该综合行业前后单时间差（分桶）f660302
    public static Long getLastNewTradeGmtIntervelLevel(String operatingNewTrade, String currentGmtCreateTime, Map<String, String> newTradeLastGmtCreateTime) {
        Long ret = null;
        if (AssertUtil.isAllNotEmpty(operatingNewTrade, currentGmtCreateTime, newTradeLastGmtCreateTime)) {
            String lastGmtCreateTime = newTradeLastGmtCreateTime.get(operatingNewTrade + "-660301");
            if (lastGmtCreateTime == null) {
                ret = null;
            } else {
                Long timeStamp = LocalDateUtil.getTimeMillis(currentGmtCreateTime, DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                Long otherTimeStamp = Long.valueOf(lastGmtCreateTime);

                if (AssertUtil.isAnyEmpty(timeStamp, otherTimeStamp)) {
                    return ret;
                }
                Long seconds = (long) (Math.abs((timeStamp - otherTimeStamp) / 1000));

                if (seconds == null) {
                    ret = -1L;
                } else if (seconds <= 5) {
                    ret = 1L;
                } else if (seconds <= 10) {
                    ret = 2L;
                } else if (seconds <= 30) {
                    ret = 3L;
                } else if (seconds <= 60) {
                    ret = 4L;
                } else if (seconds <= 5 * 60) {
                    ret = 5L;
                } else if (seconds <= 10 * 60) {
                    ret = 6L;
                } else if (seconds <= 30 * 60) {
                    ret = 7L;
                } else if (seconds <= 60 * 60) {
                    ret = 8L;
                } else if (seconds <= 5 * 60 * 60) {
                    ret = 9L;
                } else if (seconds <= 10 * 60 * 60) {
                    ret = 10L;
                } else if (seconds <= 15 * 60 * 60) {
                    ret = 11L;
                } else if (seconds <= 20 * 60 * 60) {
                    ret = 12L;
                } else if (seconds <= 24 * 60 * 60) {
                    ret = 13L;
                } else {
                    ret = 99L;
                }
            }
        }
        return ret;
    }


    /**
     * @param firstMap           分母
     * @param secondMap          分子
     * @param statCtrOrCvrBucket 分桶
     * @return
     */
    public static String getCtrOrCvrInKey(Map<String, Long> firstMap,
                                          Map<String, Long> secondMap,
                                          double[] statCtrOrCvrBucket) {
        String ret = null;
        try {

            if (AssertUtil.isNotEmpty(firstMap)) {

                for (Map.Entry<String, Long> entry : firstMap.entrySet()) {
                    String key = entry.getKey();

                    if (key != null) {
                        Long firstPv = entry.getValue();
                        if (firstPv == null) {
                            firstPv = 0L;
                        }

                        Long secondPv = 0L;
                        if (AssertUtil.isNotEmpty(secondMap)) {
                            secondPv = secondMap.getOrDefault(key, 0L);
                        }

                        Double value = getCtrOrCvr(firstPv, secondPv);
                        Long valueLevel = bucket(value, statCtrOrCvrBucket);

                        String tmpRet = key + "&" + DataUtil.Long2String(valueLevel);
                        ret = ret + "," + tmpRet;
                    }
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }


    //计算媒体/媒体行业在不同广告行业上的ctr,cvr(分桶)
    public static String getStatInNewTrade(String statType,
                                           Map<String, Map<String, Long>> newTradeMap) {

        String ret = null;
        try {

            if (AssertUtil.isNotEmpty(newTradeMap)) {
                Map<String, Long> launchMap = newTradeMap.get("launch");
                Map<String, Long> clickMap = newTradeMap.get("click");
                Map<String, Long> effectMap = newTradeMap.get("effect");

                if (statType == "ctr") {
                    if (AssertUtil.isNotEmpty(launchMap)) {
                        ret = getCtrOrCvrInKey(launchMap, clickMap, statCtrBucket);
                    }

                } else if (statType == "cvr") {
                    if (AssertUtil.isNotEmpty(clickMap)) {
                        ret = getCtrOrCvrInKey(clickMap, effectMap, statCvrBucket);
                    }
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }


    //计算广告/广告行业在不同媒体行业上的ctr,cvr(分桶)
    public static String getStatInAppTag(String statType,
                                         Map<String, Map<String, Long>> appTagMap) {

        String ret = null;
        try {

            if (AssertUtil.isNotEmpty(appTagMap)) {
                Map<String, Long> launchMap = appTagMap.get("launch");
                Map<String, Long> clickMap = appTagMap.get("click");
                Map<String, Long> effectMap = appTagMap.get("effect");

                if (statType == "ctr") {
                    if (AssertUtil.isNotEmpty(launchMap)) {
                        ret = getCtrOrCvrInKey(launchMap, clickMap, statCtrBucket);
                    }

                } else if (statType == "cvr") {
                    if (AssertUtil.isNotEmpty(clickMap)) {
                        ret = getCtrOrCvrInKey(clickMap, effectMap, statCvrBucket);
                    }
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

    // 20191023特征交叉
    public static String getCrossFeature(String ids, String id0) {
        String ret = null;

        if (ids == null || "".equals(ids) || " ".equals(ids) || ",".equals(ids) || id0 == null || "".equals(id0) || " ".equals(id0)) {
            ret = "null";
        } else {
            List<String> crossFeature = new ArrayList<String>();
            try {
                for (String id : ids.split(",")) {
                    if (id == "" || id == " ") {
                        continue;
//                        return "null";
                    } else {
                        crossFeature.add(id + "_" + id0);
                    }
                }
                if (crossFeature.size() > 0) {
                    ret = Joiner.on(",").skipNulls().join(crossFeature);
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        if (ret == null || ret == "" || ret == " " || ret == ",") {
            ret = "null";
        }

        if (!ret.equalsIgnoreCase("null")) {
            ret = "null," + ret;
        }
        return ret;

    }

    // 用户分行业统计数据解析
    public static String getUserCategoryActLevelByBucket(JSONObject actMap, Map<String, Integer> category, int[] buckets) {

        if (AssertUtil.isAnyEmpty(actMap, category, buckets)) return null;

        // 预留2个位置
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;

        StringBuilder stringBuilder = new StringBuilder();

        try {
            for (String cateKey : actMap.keySet()) {
                Integer cateValue = actMap.getIntValue(cateKey);

                if (category.containsKey(cateKey)) {
                    Integer i = category.get(cateKey);
                    long value = i * limit + bucket(cateValue, buckets);

                    stringBuilder.append(value);
                    stringBuilder.append(",");
                }
            }
        } catch (Exception e) {
            return null;
        }

        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        } else {
            return "";
        }

    }


    // 根据行业发券数量，区分新老用户
    public static String getUserCategoryLaunchTrade(JSONObject actMap, String category) {

        if (AssertUtil.isAnyEmpty(actMap, category)) {
            return "-1";
        }
        // 曝光次数小于等于1，则为新用户，标记为"0"
        if (actMap.getIntValue(category) <= 1) {
            return "0";
        } else {
            return "1";
        }
    }


    // 用户分行业统计数据解析
    public static String getUserCategoryActLevelByBucket(Map<String, Integer> actMap, Map<String, Integer> category, int[] buckets) {

        if (AssertUtil.isAnyEmpty(actMap, category, buckets)) return null;

        // 预留2个位置
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;

        StringBuilder stringBuilder = new StringBuilder();

        try {
            for (Map.Entry<String, Integer> entry : actMap.entrySet()) {
                String cateKey = entry.getKey();
                Integer cateValue = entry.getValue();

                if (category.containsKey(cateKey)) {
                    Integer i = category.get(cateKey);
                    long value = i * limit + bucket(cateValue, buckets);

                    stringBuilder.append(value);
                    stringBuilder.append(",");
                }
            }
        } catch (Exception e) {
            return null;
        }

        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        } else {
            return "";
        }
    }

    // 用户分行业统计数据解析
    public static String getCategoryLevelByCalcBucket(JSONObject actMap1, JSONObject actMap2, Map<String, Integer> category, double[] buckets) {

        if (AssertUtil.isAnyEmpty(actMap1, actMap2, category, buckets)) return null;

        // 预留2个位置
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;

        StringBuilder stringBuilder = new StringBuilder();

        try {
            for (String cateKey : actMap1.keySet()) {
                double cateValue1 = Long.parseLong(actMap1.getOrDefault(cateKey, 0).toString());
                if (cateValue1 == 0) {
                    continue;
                }
                double cateValue2 = Long.parseLong(actMap2.getOrDefault(cateKey, 0).toString());
                // 过滤不置信转化，个数小于5个
                if (category.containsKey(cateKey) && cateValue2 > 5.0) {
                    Integer i = category.get(cateKey);
                    long value = i * limit + bucket(cateValue2 / cateValue1, buckets);

                    stringBuilder.append(value);
                    stringBuilder.append(",");
                }
            }
        } catch (Exception e) {
            logger.warn("getCategoryLevelByCalcBucket failed=" + actMap2);
            return null;
        }

        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        } else {
            return "";
        }
    }

    // 用户分行业统计数据解析
    public static String getUserCategoryActLevelByBucket(JSONObject actMap, Map<String, Integer> category, double[] buckets) {

        if (AssertUtil.isAnyEmpty(actMap, category, buckets)) return null;

        // 预留2个位置
        int limit = buckets.length + 2 <= 10 ? 10 : buckets.length + 3;

        StringBuilder stringBuilder = new StringBuilder();

        try {
            for (String cateKey : actMap.keySet()) {
                Double cateValue = actMap.getDouble(cateKey);

                if (category.containsKey(cateKey)) {
                    Integer i = category.get(cateKey);
                    long value = i * limit + bucket(cateValue, buckets);

                    stringBuilder.append(value);
                    stringBuilder.append(",");
                }
            }
        } catch (Exception e) {
            return null;
        }

        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        } else {
            return "";
        }
    }

    // 用户签收率分桶计算
    public static Long getUserSignRatioBucket(Long signEffect, Long issueEffect, double[] bucket) {
        long ret = 0;

        if (signEffect == null || issueEffect == null || bucket == null || issueEffect == 0) {
            return ret;
        } else {
            return bucket(signEffect.doubleValue() / issueEffect, bucket);
        }
    }



    public static int countFeatures(String valueList) {
        if (valueList == null) {
            return -1;
        }
        if (valueList.isEmpty()) {
            return 0;
        }
        String idArr[] = valueList.split(",");
        if (idArr == null) {
            return -1;
        }
        return idArr.length;
    }

    private static <T> Set<String> getSetIntersection(Set<T> base, Set<String> rawSet) {
        HashSet<String> advertSet = new HashSet<>();

        if (base != null && base.size() > 0 && rawSet != null && rawSet.size() > 0) {
            for (T b : base) {
                if (rawSet.contains(b.toString())) {
                    advertSet.add(b.toString());
                }
            }
        }

        return advertSet;
    }

    private static <T> Set<T> getSetSubtract(Set<T> base, Set<T> exclude) {
        Set<T> res = null;

        if (AssertUtil.isAllNotEmpty(base, exclude)) {
            res = new HashSet<T>();

            for (T b : base) {
                if (!exclude.contains(b)) {
                    res.add(b);
                }
            }
        } else {
            res = base;
        }

        return res;
    }

    private static Set<String> getConvertAdvertSet(String convertStr, Set<String> rawSet) {
        Set<String> advertSet = new HashSet<>();
        if (convertStr.length() > 0) {
            String tmp = convertStr.replaceAll("[{}]", "");
            String[] tmpArray = tmp.split(",");
            for (String arr : tmpArray) {
                if (!arr.contains("=") && rawSet.contains(arr)) {
                    advertSet.add(arr);
                }
                if (arr.contains("=")) {
                    String[] tmpArray2 = arr.split("=");
                    if (tmpArray2.length >= 2) {
                        if (rawSet.contains(tmpArray2[1])) {
                            advertSet.add(tmpArray2[1]);
                        }
                    }
                }
            }
        }
        return advertSet;
    }

    // 20210115 两两特征交叉
    public static String getFeatureCross(String str0, String str1) {
        String ret;
        String tmp_str0 = str0 == null ? "nu" : str0;
        String tmp_str1 = str1 == null ? "nu" : str1;
        ret = tmp_str0 + "_" + tmp_str1;
        return ret;
    }


}