/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.vo;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserProfileFeature
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(UserProfileFeature.class);
    private static final long serialVersionUID = 6653753667287162448L;
    private String sex;
    private String marry;
    private String consumeLevel;
    private String permanentProvince;
    private String permanentCity;
    private String gender;
    private String age;
    private String marital;
    private String interestPreference;

    public String getMarital() {
        if (StringUtils.isBlank((String)this.marital)) {
            return null;
        }
        return this.marital.substring(0, Math.min(this.marital.length(), 6));
    }

    public String getConsumeLevel() {
        if (StringUtils.isBlank((String)this.consumeLevel)) {
            return null;
        }
        return this.consumeLevel.substring(0, Math.min(this.consumeLevel.length(), 6));
    }

    public static String formatOsVersion(String osVersion) {
        if (StringUtils.isBlank((String)osVersion)) {
            return null;
        }
        return osVersion.split("\\.")[0].toUpperCase();
    }

    public static String formatFirstShowTime(Integer firstShowTime) {
        if (firstShowTime == null) {
            return null;
        }
        if (firstShowTime < 2000 || firstShowTime > 2030) {
            return "-1";
        }
        return firstShowTime.toString();
    }

    public static String formatPhoneOs(String phoneOs) {
        if (StringUtils.isBlank((String)phoneOs)) {
            return null;
        }
        if (phoneOs.equalsIgnoreCase("android")) {
            return "android";
        }
        if (phoneOs.equalsIgnoreCase("ios")) {
            return "ios";
        }
        logger.warn("UserProfileFeature formatPhoneOs warn: " + phoneOs);
        return null;
    }

    public static String formatPhoneModelCode(String phoneModel) {
        if (StringUtils.isBlank((String)phoneModel)) {
            return null;
        }
        return phoneModel.substring(0, Math.min(phoneModel.length(), 100));
    }

    public String getSex() {
        return this.sex;
    }

    public String getMarry() {
        return this.marry;
    }

    public String getPermanentProvince() {
        return this.permanentProvince;
    }

    public String getPermanentCity() {
        return this.permanentCity;
    }

    public String getGender() {
        return this.gender;
    }

    public String getAge() {
        return this.age;
    }

    public String getInterestPreference() {
        return this.interestPreference;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public void setMarry(String marry) {
        this.marry = marry;
    }

    public void setConsumeLevel(String consumeLevel) {
        this.consumeLevel = consumeLevel;
    }

    public void setPermanentProvince(String permanentProvince) {
        this.permanentProvince = permanentProvince;
    }

    public void setPermanentCity(String permanentCity) {
        this.permanentCity = permanentCity;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public void setAge(String age) {
        this.age = age;
    }

    public void setMarital(String marital) {
        this.marital = marital;
    }

    public void setInterestPreference(String interestPreference) {
        this.interestPreference = interestPreference;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserProfileFeature)) {
            return false;
        }
        UserProfileFeature other = (UserProfileFeature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sex = this.getSex();
        String other$sex = other.getSex();
        if (this$sex == null ? other$sex != null : !this$sex.equals(other$sex)) {
            return false;
        }
        String this$marry = this.getMarry();
        String other$marry = other.getMarry();
        if (this$marry == null ? other$marry != null : !this$marry.equals(other$marry)) {
            return false;
        }
        String this$consumeLevel = this.getConsumeLevel();
        String other$consumeLevel = other.getConsumeLevel();
        if (this$consumeLevel == null ? other$consumeLevel != null : !this$consumeLevel.equals(other$consumeLevel)) {
            return false;
        }
        String this$permanentProvince = this.getPermanentProvince();
        String other$permanentProvince = other.getPermanentProvince();
        if (this$permanentProvince == null ? other$permanentProvince != null : !this$permanentProvince.equals(other$permanentProvince)) {
            return false;
        }
        String this$permanentCity = this.getPermanentCity();
        String other$permanentCity = other.getPermanentCity();
        if (this$permanentCity == null ? other$permanentCity != null : !this$permanentCity.equals(other$permanentCity)) {
            return false;
        }
        String this$gender = this.getGender();
        String other$gender = other.getGender();
        if (this$gender == null ? other$gender != null : !this$gender.equals(other$gender)) {
            return false;
        }
        String this$age = this.getAge();
        String other$age = other.getAge();
        if (this$age == null ? other$age != null : !this$age.equals(other$age)) {
            return false;
        }
        String this$marital = this.getMarital();
        String other$marital = other.getMarital();
        if (this$marital == null ? other$marital != null : !this$marital.equals(other$marital)) {
            return false;
        }
        String this$interestPreference = this.getInterestPreference();
        String other$interestPreference = other.getInterestPreference();
        return !(this$interestPreference == null ? other$interestPreference != null : !this$interestPreference.equals(other$interestPreference));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserProfileFeature;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sex = this.getSex();
        result = result * 59 + ($sex == null ? 43 : $sex.hashCode());
        String $marry = this.getMarry();
        result = result * 59 + ($marry == null ? 43 : $marry.hashCode());
        String $consumeLevel = this.getConsumeLevel();
        result = result * 59 + ($consumeLevel == null ? 43 : $consumeLevel.hashCode());
        String $permanentProvince = this.getPermanentProvince();
        result = result * 59 + ($permanentProvince == null ? 43 : $permanentProvince.hashCode());
        String $permanentCity = this.getPermanentCity();
        result = result * 59 + ($permanentCity == null ? 43 : $permanentCity.hashCode());
        String $gender = this.getGender();
        result = result * 59 + ($gender == null ? 43 : $gender.hashCode());
        String $age = this.getAge();
        result = result * 59 + ($age == null ? 43 : $age.hashCode());
        String $marital = this.getMarital();
        result = result * 59 + ($marital == null ? 43 : $marital.hashCode());
        String $interestPreference = this.getInterestPreference();
        result = result * 59 + ($interestPreference == null ? 43 : $interestPreference.hashCode());
        return result;
    }

    public String toString() {
        return "UserProfileFeature(sex=" + this.getSex() + ", marry=" + this.getMarry() + ", consumeLevel=" + this.getConsumeLevel() + ", permanentProvince=" + this.getPermanentProvince() + ", permanentCity=" + this.getPermanentCity() + ", gender=" + this.getGender() + ", age=" + this.getAge() + ", marital=" + this.getMarital() + ", interestPreference=" + this.getInterestPreference() + ")";
    }
}

