/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.parse.FeatureBaseParse;
import cn.com.duiba.nezha.alg.feature.vo.ActSubTitleNameParseVo;
import cn.com.duiba.nezha.alg.feature.vo.ActTitleFeatureDo;
import com.alibaba.fastjson.JSON;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActTitleFeatureParse {
    public static int F_MAX_SIZE = 64;
    private static final Logger logger = LoggerFactory.getLogger(ActTitleFeatureParse.class);

    public static Map<String, String> generateFeatureMapStatic(ActTitleFeatureDo cf) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        try {
            if (cf != null) {
                retMap.put("f201001", DataUtil.Long2String((Long)cf.getAppId()));
                retMap.put("f108002", DataUtil.Long2String((Long)cf.getSlotId()));
                retMap.put("f301001", DataUtil.Long2String((Long)cf.getActivityId()));
                retMap.put("f311001", DataUtil.Long2String((Long)cf.getActivityPage()));
                retMap.put("f312001", DataUtil.Long2String((Long)cf.getDsm2A()));
                retMap.put("f315001", cf.getActivitySkin());
                retMap.put("f4010030", DataUtil.Long2String((Long)cf.getAreaCode()));
                Long regionLevel = FeatureBaseParse.getRegionLevel(cf.getAreaCode());
                retMap.put("f4010031", DataUtil.Long2String((Long)regionLevel));
                Long tierCityLevel = FeatureBaseParse.getTierCityLevel(cf.getAreaCode());
                retMap.put("f4010032", DataUtil.Long2String((Long)tierCityLevel));
                Integer hour = LocalDateUtil.getHour((LocalDateTime)LocalDateTime.now());
                retMap.put("f502001", DataUtil.Integer2String((Integer)hour));
                Integer weekDay = LocalDateUtil.getDayOfWeek((LocalDateTime)LocalDateTime.now());
                retMap.put("f502002", DataUtil.Integer2String((Integer)weekDay));
            }
        }
        catch (Exception e) {
            logger.error("ActFeatureParse.generateFeatureMapStatic error:" + e);
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapPrizeId(Long activitySubTitlePrizeId) {
        HashMap<String, String> retMap = new HashMap<String, String>(8);
        try {
            if (activitySubTitlePrizeId != null) {
                retMap.put("f322001", DataUtil.Long2String((Long)activitySubTitlePrizeId));
            }
        }
        catch (Exception e) {
            logger.error("ActFeatureParse.generateFeatureMapPrizeId error:", (Throwable)e);
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(ActTitleFeatureDo cf, ActTitleFeatureDo staticCf) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        try {
            if (cf != null) {
                retMap.put("f316001", DataUtil.Long2String((Long)cf.getActivityTitleId()));
                retMap.put("f317001", DataUtil.Long2String((Long)cf.getActivitySubTitleId()));
                retMap.put("f318001", DataUtil.Long2String((Long)cf.getActivityTitleTagId()));
                retMap.put("f319001", DataUtil.Long2String((Long)cf.getActivitySubTitleTagId()));
                retMap.put("f320001", cf.getActivityTitleName());
                retMap.put("f321001", cf.getActivitySubTitleName());
                retMap.put("f322001", DataUtil.Long2String((Long)cf.getActivitySubTitlePrizeId()));
                ActSubTitleNameParseVo actSubTitleNameParseVo = FeatureBaseParse.parseActTitleName(cf.getActivitySubTitleName());
                retMap.put("f321002", DataUtil.Long2String((Long)actSubTitleNameParseVo.getWeekTypeNums()));
                retMap.put("f321003", DataUtil.Long2String((Long)actSubTitleNameParseVo.getFestivalTypeNums()));
                retMap.put("f321004", DataUtil.Long2String((Long)actSubTitleNameParseVo.getAreaTypeNums()));
                retMap.put("f321005", DataUtil.Long2String((Long)actSubTitleNameParseVo.getDynamicTypeNums()));
                retMap.put("f321006", DataUtil.Long2String((Long)actSubTitleNameParseVo.getSize()));
                ActSubTitleNameParseVo actTitleNameParseVo = FeatureBaseParse.parseActTitleName(cf.getActivityTitleName());
                retMap.put("f321007", DataUtil.Long2String((Long)actTitleNameParseVo.getSize()));
                retMap.put("f321008", DataUtil.Long2String((Long)actSubTitleNameParseVo.getPrizeTypeNums()));
            }
        }
        catch (Exception e) {
            logger.error("ActFeatureParse.generateFeatureMapDynamic error:", (Throwable)e);
        }
        return retMap;
    }

    public static void main(String[] args) {
        ActTitleFeatureDo actFeatureDo1 = new ActTitleFeatureDo();
        actFeatureDo1.setActivityId(1L);
        actFeatureDo1.setActivityPage(2L);
        actFeatureDo1.setAppId(3L);
        actFeatureDo1.setSlotId(5L);
        actFeatureDo1.setAreaCode(4L);
        actFeatureDo1.setActivityTitleId(100L);
        actFeatureDo1.setActivitySubTitleId(101L);
        actFeatureDo1.setActivityTitleTagId(201L);
        actFeatureDo1.setActivitySubTitleTagId(201L);
        actFeatureDo1.setActivityTitleName("\u4e3b\u6807\u9898");
        actFeatureDo1.setActivitySubTitleName("\u526f\u6807\u9898");
        actFeatureDo1.setDsm2A(6L);
        Map<String, String> staticFeatureMap = ActTitleFeatureParse.generateFeatureMapStatic(actFeatureDo1);
        Map<String, String> dynamicFeatureMap = ActTitleFeatureParse.generateFeatureMapDynamic(actFeatureDo1, actFeatureDo1);
        dynamicFeatureMap.putAll(staticFeatureMap);
        System.out.println(JSON.toJSONString(dynamicFeatureMap));
    }
}

