/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.type;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;

public class FeatureBaseType2
implements Serializable {
    private static final long serialVersionUID = -8781145506799969883L;
    public Integer id;
    public String featureId;
    public String featureName;
    public Integer codeType;
    public String splitChar;
    public String featureDesc;
    public Integer multiValue;
    public Integer denseLen;
    public Integer isDeleted;
    public Integer encodeType;
    public Integer featureScene;
    public int subLen = 1;

    public String[] splitFeature(Map<String, String> featureValueMap) throws Exception {
        return this.splitFeature(featureValueMap.get(this.featureId));
    }

    public String[] splitFeature(String featureValue) throws Exception {
        String[] ret = new String[this.subLen];
        if (this.codeType == 1) {
            ret[0] = FeatureBaseType2.std(featureValue);
        } else if (this.codeType == 2) {
            String[] features = FeatureBaseType2.split(featureValue, this.splitChar);
            if (features != null) {
                ret = Arrays.copyOfRange(features, 0, this.subLen);
            } else {
                ret[0] = null;
            }
        } else {
            ret[0] = null;
        }
        return ret;
    }

    public String[] split(String str) throws Exception {
        String[] ret = null;
        if (FeatureBaseType2.std(str) != null) {
            ret = str.split(this.splitChar, 0);
        }
        return ret;
    }

    public static String[] split(String str, String seq) throws Exception {
        String[] ret = null;
        if (FeatureBaseType2.std(str) != null) {
            ret = str.split(seq, 0);
        }
        return ret;
    }

    public static String std(String oStr) {
        if (oStr == null) {
            return null;
        }
        String lowStr = oStr.toLowerCase().trim();
        if (lowStr.length() == 0 || lowStr.equals("\\n") || lowStr.equals("\n") || lowStr.equals("null") || lowStr.equals("none")) {
            return null;
        }
        return lowStr;
    }

    public static void main(String[] args) {
        try {
            FeatureBaseType2 do1 = new FeatureBaseType2();
            do1.setSubLen(10);
            do1.setDenseLen(1000);
            do1.setFeatureId("f1001");
            System.out.println(Arrays.asList(do1.splitFeature("1")));
            System.out.println(Arrays.asList(do1.splitFeature("1,")));
            System.out.println(Arrays.asList(do1.splitFeature(",1")));
            System.out.println(Arrays.asList(do1.splitFeature("1,2")));
            System.out.println(Arrays.asList(do1.splitFeature("1,3,4,5")));
            System.out.println(Arrays.asList(do1.splitFeature("2,3,,4,5")));
            System.out.println(Arrays.asList(do1.splitFeature("")));
            System.out.println(Arrays.asList(do1.splitFeature("  ")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Integer getId() {
        return this.id;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public Integer getCodeType() {
        return this.codeType;
    }

    public String getSplitChar() {
        return this.splitChar;
    }

    public String getFeatureDesc() {
        return this.featureDesc;
    }

    public Integer getMultiValue() {
        return this.multiValue;
    }

    public Integer getDenseLen() {
        return this.denseLen;
    }

    public Integer getIsDeleted() {
        return this.isDeleted;
    }

    public Integer getEncodeType() {
        return this.encodeType;
    }

    public Integer getFeatureScene() {
        return this.featureScene;
    }

    public int getSubLen() {
        return this.subLen;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setFeatureId(String featureId) {
        this.featureId = featureId;
    }

    public void setFeatureName(String featureName) {
        this.featureName = featureName;
    }

    public void setCodeType(Integer codeType) {
        this.codeType = codeType;
    }

    public void setSplitChar(String splitChar) {
        this.splitChar = splitChar;
    }

    public void setFeatureDesc(String featureDesc) {
        this.featureDesc = featureDesc;
    }

    public void setMultiValue(Integer multiValue) {
        this.multiValue = multiValue;
    }

    public void setDenseLen(Integer denseLen) {
        this.denseLen = denseLen;
    }

    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    public void setEncodeType(Integer encodeType) {
        this.encodeType = encodeType;
    }

    public void setFeatureScene(Integer featureScene) {
        this.featureScene = featureScene;
    }

    public void setSubLen(int subLen) {
        this.subLen = subLen;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeatureBaseType2)) {
            return false;
        }
        FeatureBaseType2 other = (FeatureBaseType2)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$featureId = this.getFeatureId();
        String other$featureId = other.getFeatureId();
        if (this$featureId == null ? other$featureId != null : !this$featureId.equals(other$featureId)) {
            return false;
        }
        String this$featureName = this.getFeatureName();
        String other$featureName = other.getFeatureName();
        if (this$featureName == null ? other$featureName != null : !this$featureName.equals(other$featureName)) {
            return false;
        }
        Integer this$codeType = this.getCodeType();
        Integer other$codeType = other.getCodeType();
        if (this$codeType == null ? other$codeType != null : !((Object)this$codeType).equals(other$codeType)) {
            return false;
        }
        String this$splitChar = this.getSplitChar();
        String other$splitChar = other.getSplitChar();
        if (this$splitChar == null ? other$splitChar != null : !this$splitChar.equals(other$splitChar)) {
            return false;
        }
        String this$featureDesc = this.getFeatureDesc();
        String other$featureDesc = other.getFeatureDesc();
        if (this$featureDesc == null ? other$featureDesc != null : !this$featureDesc.equals(other$featureDesc)) {
            return false;
        }
        Integer this$multiValue = this.getMultiValue();
        Integer other$multiValue = other.getMultiValue();
        if (this$multiValue == null ? other$multiValue != null : !((Object)this$multiValue).equals(other$multiValue)) {
            return false;
        }
        Integer this$denseLen = this.getDenseLen();
        Integer other$denseLen = other.getDenseLen();
        if (this$denseLen == null ? other$denseLen != null : !((Object)this$denseLen).equals(other$denseLen)) {
            return false;
        }
        Integer this$isDeleted = this.getIsDeleted();
        Integer other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        Integer this$encodeType = this.getEncodeType();
        Integer other$encodeType = other.getEncodeType();
        if (this$encodeType == null ? other$encodeType != null : !((Object)this$encodeType).equals(other$encodeType)) {
            return false;
        }
        Integer this$featureScene = this.getFeatureScene();
        Integer other$featureScene = other.getFeatureScene();
        if (this$featureScene == null ? other$featureScene != null : !((Object)this$featureScene).equals(other$featureScene)) {
            return false;
        }
        return this.getSubLen() == other.getSubLen();
    }

    protected boolean canEqual(Object other) {
        return other instanceof FeatureBaseType2;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $featureId = this.getFeatureId();
        result = result * 59 + ($featureId == null ? 43 : $featureId.hashCode());
        String $featureName = this.getFeatureName();
        result = result * 59 + ($featureName == null ? 43 : $featureName.hashCode());
        Integer $codeType = this.getCodeType();
        result = result * 59 + ($codeType == null ? 43 : ((Object)$codeType).hashCode());
        String $splitChar = this.getSplitChar();
        result = result * 59 + ($splitChar == null ? 43 : $splitChar.hashCode());
        String $featureDesc = this.getFeatureDesc();
        result = result * 59 + ($featureDesc == null ? 43 : $featureDesc.hashCode());
        Integer $multiValue = this.getMultiValue();
        result = result * 59 + ($multiValue == null ? 43 : ((Object)$multiValue).hashCode());
        Integer $denseLen = this.getDenseLen();
        result = result * 59 + ($denseLen == null ? 43 : ((Object)$denseLen).hashCode());
        Integer $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        Integer $encodeType = this.getEncodeType();
        result = result * 59 + ($encodeType == null ? 43 : ((Object)$encodeType).hashCode());
        Integer $featureScene = this.getFeatureScene();
        result = result * 59 + ($featureScene == null ? 43 : ((Object)$featureScene).hashCode());
        result = result * 59 + this.getSubLen();
        return result;
    }

    public String toString() {
        return "FeatureBaseType2(id=" + this.getId() + ", featureId=" + this.getFeatureId() + ", featureName=" + this.getFeatureName() + ", codeType=" + this.getCodeType() + ", splitChar=" + this.getSplitChar() + ", featureDesc=" + this.getFeatureDesc() + ", multiValue=" + this.getMultiValue() + ", denseLen=" + this.getDenseLen() + ", isDeleted=" + this.getIsDeleted() + ", encodeType=" + this.getEncodeType() + ", featureScene=" + this.getFeatureScene() + ", subLen=" + this.getSubLen() + ")";
    }
}

