/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.feature.parse;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.util.DataConverter;
import cn.com.duiba.nezha.alg.feature.util.RegionConf;
import cn.com.duiba.nezha.alg.feature.vo.AdvertTagFeature;
import cn.com.duiba.nezha.alg.feature.vo.FeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.LoadingPageFeature;
import cn.com.duiba.nezha.alg.feature.vo.SlotActFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserActFeature;
import cn.com.duiba.nezha.alg.feature.vo.UserProfileFeature;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureParse2 {
    private static final Logger logger = LoggerFactory.getLogger(FeatureParse2.class);
    public static int F_MAX_SIZE = 64;
    public static Integer[] orderGmtIntervelBucket = new Integer[]{0, 2, 5, 10, 60, 720, 1440, 2880, 5760, 10080, 43200};
    public static Integer[] orderActGmtIntervelBucket = new Integer[]{1, 2, 3, 4, 5, 10, 60, 720, 1440, 10080};
    public static Number[] cntBucket = new Number[]{0, 1, 3, 5, 10, 15, 20};
    public static Number[] launchRankBucket = new Number[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 20, 30, 50, 100, 200};
    public static Number[] clickRankBucket = new Number[]{0, 1, 2, 3, 4, 5, 6, 8, 10, 15, 20, 30, 50};
    public static Number[] effectRankBucket = new Number[]{0, 1, 2, 3, 4, 5, 10};
    public static Number[] dayLaunchRankBucket = new Number[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 15, 30};
    public static Number[] dayClickRankBucket = new Number[]{0, 1, 2, 3, 4, 5, 10, 20};
    public static Number[] dayEffectRankBucket = new Number[]{0, 1, 2, 3, 4, 5};
    public static Number[] statCtrBucket = new Number[]{0.01, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.55, 0.6, 0.63, 0.66, 0.7, 0.75, 0.8, 0.9};
    public static Number[] statCvrBucket = new Number[]{5.0E-4, 0.001, 0.005, 0.01, 0.015, 0.02, 0.025, 0.03, 0.035, 0.04, 0.045, 0.05, 0.07, 0.1, 0.15, 0.2, 0.25, 0.3, 0.5};
    public static Number[] statCtrBucketAct = new Number[]{0.001, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static Number[] statCvrBucketAct = new Number[]{0.001, 0.01, 0.02, 0.03, 0.04, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99};
    public static final Number[] cntMeituanBucket30d = new Number[]{0, 1, 2, 3, 5, 10, 20, 50};
    public static final Number[] cntMeituanBucket = new Number[]{-1, 1, 2, 3, 4, 5, 10, 20, 30};

    public static Map<String, String> generateFeatureMapStatic(FeatureDo cf) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        try {
            if (cf != null) {
                cf.setCurrentGmtCreateTime(LocalDateUtil.getCurrentLocalDateTime((String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
                retMap.put("ft100201", cf.getConnectionType());
                retMap.put("ft100202", cf.getOperatorType());
                retMap.put("ft100203", UserProfileFeature.formatOsVersion(cf.getOsVersion()));
                retMap.put("ft100204", UserProfileFeature.formatPhoneModelCode(cf.getPhoneModelCode()));
                retMap.put("ft100205", cf.getBrandNameEn());
                retMap.put("ft100206", cf.getPhonePriceLevel());
                retMap.put("ft100207", UserProfileFeature.formatFirstShowTime(cf.getFirstShowTime()));
                retMap.put("ft100208", UserProfileFeature.formatPhoneOs(cf.getPhoneOs()));
                retMap.put("ft100209", cf.getIpUsageType());
                UserProfileFeature userProfileFeature = Optional.ofNullable(cf.getUserProfileFeature()).orElse(new UserProfileFeature());
                retMap.put("ft100001", cf.getOneId());
                retMap.put("ft100103", userProfileFeature.getMarital());
                retMap.put("ft100105", userProfileFeature.getInterestPreference());
                retMap.put("ft100106", userProfileFeature.getAge());
                retMap.put("ft100107", userProfileFeature.getGender());
                retMap.put("ft100501", cf.getBdFirstTag());
                retMap.put("ft100502", cf.getBdSecondTag());
                retMap.put("ft100503", cf.getBdThirdTag());
                retMap.put("ft100504", cf.getBdFourthTag());
                retMap.put("ft100505", DataConverter.mapKey2Str(cf.getAppInstallFirstTag()));
                retMap.put("ft100506", DataConverter.mapKey2Str(cf.getAppInstallSecondTag()));
                retMap.put("ft100601", DataConverter.map2Bucket2Str(cf.getAppInstallFirstTag(), cntBucket));
                retMap.put("ft100602", DataConverter.map2Bucket2Str(cf.getAppInstallSecondTag(), cntBucket));
                UserActFeature userActFeature = Optional.ofNullable(cf.getUserActFeature()).orElse(new UserActFeature());
                retMap.put("ft110000", DataConverter.bucket((Number)userActFeature.getUserActiveDays(), (Number[])cntBucket));
                retMap.put("ft111021", DataConverter.bucket((Number)userActFeature.getWeekActivityRequest(), (Number[])cntBucket));
                retMap.put("ft111011", DataConverter.bucket((Number)userActFeature.getDayActivityRequest(), (Number[])cntBucket));
                retMap.put("ft110001", DataConverter.bucket((Number)userActFeature.getHistory30LaunchCount(), (Number[])launchRankBucket));
                retMap.put("ft110002", DataConverter.bucket((Number)userActFeature.getHistory30ClickCount(), (Number[])clickRankBucket));
                retMap.put("ft110003", DataConverter.bucket((Number)userActFeature.getHistory30EffectCount(), (Number[])effectRankBucket));
                retMap.put("ft110011", DataConverter.bucket((Number)userActFeature.getTodayLaunchCount(), (Number[])dayLaunchRankBucket));
                retMap.put("ft110012", DataConverter.bucket((Number)userActFeature.getTodayClickCount(), (Number[])dayClickRankBucket));
                retMap.put("ft110013", DataConverter.bucket((Number)userActFeature.getTodayEffectCount(), (Number[])dayEffectRankBucket));
                retMap.put("ft110014", DataConverter.bucket((Number)cf.getPutIndex(), (Number[])dayLaunchRankBucket));
                retMap.put("ft110301", DataConverter.map2Bucket2Str(userActFeature.getHistoryTradeLaunch(), launchRankBucket));
                retMap.put("ft110302", DataConverter.map2Bucket2Str(userActFeature.getHistoryTradeClick(), clickRankBucket));
                retMap.put("ft110303", DataConverter.map2Bucket2Str(userActFeature.getHistoryTradeEffect(), effectRankBucket));
                retMap.put("ft110501", DataConverter.map2Bucket2Str(userActFeature.getHistoryAdvertLaunch(), dayLaunchRankBucket));
                retMap.put("ft110502", DataConverter.map2Bucket2Str(userActFeature.getHistoryAdvertClick(), dayClickRankBucket));
                retMap.put("ft110503", DataConverter.map2Bucket2Str(userActFeature.getHistoryAdvertEffect(), dayEffectRankBucket));
                Set<Integer> advertExposureSet = userActFeature.getAdvertExposureSet();
                Set<Integer> advertClickSet = userActFeature.getAdvertClickSet();
                retMap.put("ft110601", DataConverter.set2Str(advertExposureSet));
                retMap.put("ft110602", DataConverter.set2Str(advertClickSet));
                retMap.put("ft110603", DataConverter.set2Str(DataConverter.setDiff(advertExposureSet, advertClickSet)));
                retMap.put("ft110604", DataConverter.set2Str(userActFeature.getAccountClickSet()));
                retMap.put("ft110605", DataConverter.set2Str(userActFeature.getResourceClickSet()));
                retMap.put("ft110606", DataConverter.set2Str(userActFeature.getTradeClickSet()));
                retMap.put("ft110607", DataConverter.set2Str(userActFeature.getAdvertEffectSet()));
                retMap.put("ft110608", DataConverter.set2Str(userActFeature.getAccountEffectSet()));
                retMap.put("ft110609", DataConverter.set2Str(userActFeature.getResourceEffectSet()));
                retMap.put("ft110610", DataConverter.set2Str(userActFeature.getTradeEffectSet()));
                Map<String, Map<String, Long>> historyTradeCtrCvr = userActFeature.getHistoryTradeCtrCvr();
                retMap.put("ft110701", DataUtil.Long2String((Long)historyTradeCtrCvr.get("ctr").get("0")));
                retMap.put("ft110702", DataUtil.Long2String((Long)historyTradeCtrCvr.get("cvr").get("0")));
                retMap.put("ft110703", DataConverter.map2Str(historyTradeCtrCvr.get("ctr")));
                retMap.put("ft110704", DataConverter.map2Str(historyTradeCtrCvr.get("cvr")));
                String activityId = DataUtil.Long2String((Long)cf.getOperatingActivityId());
                String sceneType = Objects.equals(activityId, "999999") ? "2" : "1";
                String appId = DataUtil.Long2String((Long)cf.getAppId());
                String unionAppId = cf.getUnionAppId();
                retMap.put("ft300101", appId);
                retMap.put("ft300102", sceneType);
                retMap.put("ft300103", unionAppId == null || unionAppId.trim().equals("") ? appId : appId + "_" + unionAppId);
                retMap.put("ft300104", cf.getAppIndustryTagPid());
                retMap.put("ft300105", cf.getAppIndustryTagId());
                retMap.put("ft300106", cf.getAppTradeTypeTagId());
                retMap.put("ft300107", cf.getAppCarrierFlowTagId());
                retMap.put("ft300108", cf.getMmoTag());
                retMap.put("ft300201", DataUtil.Long2String((Long)cf.getSlotId()));
                retMap.put("ft300202", cf.getSlotSceneType());
                retMap.put("ft300203", cf.getMaterailID());
                retMap.put("ft300301", activityId);
                retMap.put("ft300302", cf.getActivitySourceType());
                retMap.put("ft300303", DataUtil.Long2String((Long)cf.getDsm2A()));
                retMap.put("ft300304", DataUtil.Long2String((Long)cf.getActivityPage()));
                retMap.put("ft300305", cf.getActivitySkinType());
                retMap.put("ft300306", DataUtil.Long2String((Long)cf.getActivityType()));
                String cityId = DataUtil.Long2String((Long)cf.getCityId());
                String provinceId = RegionConf.getProvince(cityId);
                String regionId = RegionConf.getRegion(provinceId);
                String CityTier = RegionConf.getCityTier(cityId);
                retMap.put("ft300901", regionId);
                retMap.put("ft300902", provinceId);
                retMap.put("ft300903", cityId);
                retMap.put("ft300904", CityTier);
                Integer hour = LocalDateUtil.getHour((String)cf.getCurrentGmtCreateTime(), (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                Integer weekDay = LocalDateUtil.getDayOfWeek((String)cf.getCurrentGmtCreateTime(), (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                Integer dayOfMonth = LocalDateUtil.getDayOfMonthSafely((String)cf.getCurrentGmtCreateTime(), (String)DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
                retMap.put("ft301001", DataUtil.Integer2String((Integer)hour));
                retMap.put("ft301002", DataUtil.Integer2String((Integer)weekDay));
                retMap.put("ft301003", DataUtil.Integer2String((Integer)dayOfMonth));
                SlotActFeature slotActFeature = Optional.ofNullable(cf.getSlotActFeature()).orElse(new SlotActFeature());
                JSONObject ctrTradeMap = DataUtil.stringToJson((String)slotActFeature.getCtrTrade());
                retMap.put("ft400101", DataConverter.json2Bucket2Str(ctrTradeMap, statCtrBucket));
                JSONObject cvrTradeMap = DataUtil.stringToJson((String)slotActFeature.getCvrTrade());
                retMap.put("ft400102", DataConverter.json2Bucket2Str(cvrTradeMap, statCvrBucket));
                retMap.put("ft600101", DataConverter.bucket((Number)cf.getRequestCnt30d(), (Number[])cntMeituanBucket30d));
                retMap.put("ft600102", DataConverter.bucket((Number)cf.getExposureCnt30d(), (Number[])cntMeituanBucket30d));
                retMap.put("ft600103", DataConverter.bucket((Number)cf.getClickCnt30d(), (Number[])cntMeituanBucket30d));
                retMap.put("ft600104", DataConverter.bucket((Number)cf.getRequestCnt(), (Number[])cntMeituanBucket).toString());
                retMap.put("ft600105", DataConverter.bucket((Number)cf.getExposureCnt(), (Number[])cntMeituanBucket).toString());
                retMap.put("ft600106", DataConverter.bucket((Number)cf.getClickCnt(), (Number[])cntMeituanBucket).toString());
                retMap.put("ft600201", cf.getOpenAccountId());
                retMap.put("ft600202", cf.getExtUnionSlotId());
                retMap.put("ft600203", cf.getExtAdvertGroupId());
                retMap.put("ft600204", cf.getExtIdeaId());
                String extAppTrade = cf.getExtAppTrade();
                retMap.put("ft600301", extAppTrade);
                String externalAdBlockId = cf.getExternalAdBlockId();
                retMap.put("ft600302", externalAdBlockId);
                String externalAdBlockTypeId = cf.getExternalAdBlockTypeId();
                retMap.put("ft600303", externalAdBlockTypeId);
                String groupId = DataUtil.Long2String((Long)cf.getGroupId());
                retMap.put("ft600304", groupId);
                String resourceId = DataUtil.Long2String((Long)cf.getResourceId());
                retMap.put("ft600305", resourceId);
                retMap.put("f306001", retMap.getOrDefault("ft300306", ""));
                retMap.put("f8090011", retMap.getOrDefault("ft110701", ""));
                retMap.put("f8090021", retMap.getOrDefault("ft110702", ""));
                retMap.put("f8080011", retMap.getOrDefault("ft110703", ""));
                retMap.put("f8080021", retMap.getOrDefault("ft110704", ""));
            }
        }
        catch (Exception e) {
            logger.error("FeatureParse2.generateFeatureMapStatic error", (Throwable)e);
        }
        return retMap;
    }

    public static Map<String, String> generateFeatureMapDynamic(FeatureDo cf, FeatureDo staticCf) {
        HashMap<String, String> retMap = new HashMap<String, String>(F_MAX_SIZE);
        try {
            if (cf != null) {
                String advertId = DataUtil.Long2String((Long)cf.getAdvertId());
                String accountId = DataUtil.Long2String((Long)cf.getAccountId());
                String OperatingResource = cf.getOperatingResource();
                String adNewTrade = cf.getOperatingNewTrade();
                LoadingPageFeature loadingPageFeature = Optional.ofNullable(cf.getLoadingPageFeature()).orElse(new LoadingPageFeature());
                String adTradeTag = cf.getMatchTagNums();
                retMap.put("ft200101", advertId);
                retMap.put("ft200102", accountId);
                retMap.put("ft200103", OperatingResource);
                retMap.put("ft200104", adNewTrade);
                retMap.put("ft200105", adTradeTag);
                retMap.put("ft200106", cf.getMaterialId());
                retMap.put("ft200107", cf.getMaterialTags());
                retMap.put("ft200108", loadingPageFeature.getLoadingPageID());
                retMap.put("ft200109", DataUtil.Long2String((Long)cf.getTimes()));
                String frontCvrType = cf.getBankEndType();
                String backCvrType = cf.getDeepConvertTypes();
                retMap.put("ft200201", frontCvrType);
                retMap.put("ft200202", backCvrType);
                UserActFeature userActFeature = Optional.ofNullable(staticCf.getUserActFeature()).orElse(new UserActFeature());
                String lastActivity = userActFeature.getLastActivity();
                String lastLaunchTrade = userActFeature.getLastLaunchTrade();
                String lastResource = userActFeature.getLastResource();
                String lastAccount = userActFeature.getLastLaunchAccount();
                String lastAdvert = userActFeature.getLastLaunchPlan();
                String lastActivityLaunchOrder = userActFeature.getLastActivityLaunchOrder();
                String lastActivityClickOrder = userActFeature.getLastActivityClickOrder();
                retMap.put("ft110901", lastActivity);
                retMap.put("ft110902", lastLaunchTrade);
                retMap.put("ft110903", lastResource);
                retMap.put("ft110904", lastAccount);
                retMap.put("ft110905", lastAdvert);
                retMap.put("ft110906", userActFeature.getClickLaunchTrade() == null ? null : userActFeature.getClickLaunchTrade().toString());
                retMap.put("ft110907", userActFeature.getEffectClickTrade() == null ? null : userActFeature.getEffectClickTrade().toString());
                retMap.put("ft110908", DataConverter.getMatchStatus(lastLaunchTrade, adNewTrade));
                retMap.put("ft110909", DataConverter.getMatchStatus(lastAdvert, advertId));
                String activityId = DataUtil.Long2String((Long)staticCf.getOperatingActivityId());
                retMap.put("ft110910", DataConverter.getMatchStatus(lastActivity, activityId));
                String curOrderTime = staticCf.getCurrentGmtCreateTime();
                String lastLaunchTime = userActFeature.getLastLaunchTime();
                String lastActivityTime = userActFeature.getLastActivityLaunchTime();
                retMap.put("ft110911", DataConverter.bucket((Number)DataConverter.getTimeInterval(lastLaunchTime, curOrderTime, "m"), (Number[])orderGmtIntervelBucket));
                retMap.put("ft110912", DataConverter.bucketRight((Number)DataConverter.getTimeInterval(lastActivityTime, curOrderTime, "m"), (Number[])orderActGmtIntervelBucket));
                retMap.put("ft110913", DataConverter.bucketRight((Number)DataConverter.getTimeInterval(lastLaunchTime, curOrderTime, "m"), (Number[])orderActGmtIntervelBucket));
                retMap.put("ft110914", DataConverter.getMatchStatus2(lastActivityLaunchOrder, lastActivityClickOrder));
                SlotActFeature slotActFeature = Optional.ofNullable(staticCf.getSlotActFeature()).orElse(new SlotActFeature());
                JSONObject ctrTradeMap = DataUtil.stringToJson((String)slotActFeature.getCtrTrade());
                JSONObject cvrTradeMap = DataUtil.stringToJson((String)slotActFeature.getCvrTrade());
                retMap.put("ft400201", DataConverter.getCurTradeLevel(ctrTradeMap, adNewTrade, statCtrBucket));
                retMap.put("ft400202", DataConverter.getCurTradeLevel(cvrTradeMap, adNewTrade, statCvrBucket));
                retMap.put("ft400301", DataConverter.bucket((Number)cf.getAdvertSlotCtr(), (Number[])statCtrBucket));
                retMap.put("ft400302", DataConverter.bucket((Number)cf.getAdvertSlotCvr(), (Number[])statCvrBucket));
                retMap.put("ft400303", DataConverter.bucket((Number)cf.getAdvertSlotBCvr(), (Number[])statCvrBucket));
                retMap.put("ft400601", DataConverter.bucket((Number)cf.getAdvertAppCtr(), (Number[])statCtrBucket));
                retMap.put("ft400602", DataConverter.bucket((Number)cf.getAdvertAppCvr(), (Number[])statCvrBucket));
                retMap.put("ft400603", DataConverter.bucket((Number)cf.getAdvertAppBCvr(), (Number[])statCvrBucket));
                retMap.put("ft400701", DataConverter.bucket((Number)cf.getAdvertCtr(), (Number[])statCtrBucket));
                retMap.put("ft400702", DataConverter.bucket((Number)cf.getAdvertCvr(), (Number[])statCvrBucket));
                retMap.put("ft400703", DataConverter.bucket((Number)cf.getAdvertBCvr(), (Number[])statCvrBucket));
                retMap.put("ft400801", DataConverter.bucketRight((Number)cf.getAdvertActivityCtr(), (Number[])statCtrBucketAct));
                retMap.put("ft400802", DataConverter.bucketRight((Number)cf.getAdvertActivityCvr(), (Number[])statCvrBucketAct));
                retMap.put("ft400803", DataConverter.bucketRight((Number)cf.getAdvertActivityBCvr(), (Number[])statCvrBucketAct));
                retMap.put("ft110101", DataConverter.bucket((Number)userActFeature.getHistoryTradeLaunch().getOrDefault(adTradeTag, 0L), (Number[])launchRankBucket));
                retMap.put("ft110102", DataConverter.bucket((Number)userActFeature.getHistoryTradeClick().getOrDefault(adTradeTag, 0L), (Number[])clickRankBucket));
                retMap.put("ft110103", DataConverter.bucket((Number)userActFeature.getHistoryTradeEffect().getOrDefault(adTradeTag, 0L), (Number[])effectRankBucket));
                Map<String, Map<String, Long>> historyTradeCtrCvr = userActFeature.getHistoryTradeCtrCvr();
                retMap.put("ft110705", historyTradeCtrCvr.get("ctr").getOrDefault(adTradeTag, 0L).toString());
                retMap.put("ft110706", historyTradeCtrCvr.get("cvr").getOrDefault(adTradeTag, 0L).toString());
                String advertIdString = advertId == null ? "ad" : advertId;
                retMap.put("ft500101", advertIdString + "_" + frontCvrType);
                retMap.put("ft500201", advertIdString + "_" + backCvrType);
                String accountIdString = accountId == null ? "acc" : accountId;
                retMap.put("ft500102", accountIdString + "_" + frontCvrType);
                retMap.put("ft500202", accountIdString + "_" + backCvrType);
                String tradeIdString = adNewTrade == null ? "un" : adNewTrade;
                retMap.put("ft500103", tradeIdString + "_" + frontCvrType);
                retMap.put("ft500203", tradeIdString + "_" + backCvrType);
                String appIndustryTagPidString = staticCf.getAppIndustryTagPid() == null ? "un" : staticCf.getAppIndustryTagPid();
                retMap.put("ft500104", appIndustryTagPidString + "_" + frontCvrType);
                retMap.put("ft500204", appIndustryTagPidString + "_" + backCvrType);
                AdvertTagFeature atf = Optional.ofNullable(cf.getAdvertTagFeature()).orElse(new AdvertTagFeature());
                String adInExposeTop250 = cf.getIsExposeTop250() != null && cf.getIsExposeTop250() > 0 ? DataUtil.Long2String((Long)cf.getAdvertId()) : "";
                String clickNoEffectCross = DataConverter.jointStrSet(adInExposeTop250, DataConverter.setDiff(userActFeature.getAdvertClickSet(), userActFeature.getAdvertEffectSet()));
                retMap.put("ft900001", clickNoEffectCross);
                Set<Integer> advertEffectSet = userActFeature.getAdvertEffectSet();
                HashSet advertEffectSet2 = advertEffectSet != null ? advertEffectSet.stream().map(Object::toString).collect(Collectors.toSet()) : new HashSet();
                String convertBehaviourCross = DataConverter.jointStrSet(adInExposeTop250, DataConverter.setInter(advertEffectSet2, staticCf.getTopAdvertSet()));
                retMap.put("ft900002", convertBehaviourCross);
                String operatorType = staticCf.getOperatorType() == null ? "op" : staticCf.getOperatorType();
                String operatorName = FeatureParse2.getOperatorName(operatorType);
                String tradeId = cf.getOperatingNewTrade() == null ? "un" : cf.getOperatingNewTrade();
                String phoneModel = staticCf.getPhoneModelCode() == null ? "" : staticCf.getPhoneModelCode();
                String phoneBrand = staticCf.getBrandNameEn() == null ? "" : staticCf.getBrandNameEn();
                retMap.put("ft900003", advertId + "_" + operatorType);
                retMap.put("ft900004", FeatureParse2.getOperatorBrandMatch(operatorName, atf.getBrand(), adNewTrade));
                retMap.put("ft900005", accountId + "_" + operatorName);
                retMap.put("ft900006", tradeId + "_" + operatorName);
                retMap.put("ft900007", tradeId + "_" + phoneModel);
                retMap.put("ft900008", tradeId + "_" + phoneBrand);
                retMap.put("f8100011", retMap.getOrDefault("ft110705", ""));
                retMap.put("f8100021", retMap.getOrDefault("ft110706", ""));
                retMap.put("f110001", retMap.getOrDefault("ft200109", ""));
                retMap.put("f9110041", retMap.getOrDefault("ft900002", ""));
                retMap.put("f9110031", retMap.getOrDefault("ft900001", ""));
                retMap.put("f5070011", retMap.getOrDefault("ft900003", ""));
                retMap.put("f5070012", retMap.getOrDefault("ft900004", ""));
                retMap.put("f5070015", retMap.getOrDefault("ft900005", ""));
                retMap.put("f5070016", retMap.getOrDefault("ft900006", ""));
                retMap.put("f5090012", retMap.getOrDefault("ft900007", ""));
                retMap.put("f5090022", retMap.getOrDefault("ft900008", ""));
            }
        }
        catch (Exception e) {
            logger.error("FeatureParse2.generateFeatureMapDynamic error", (Throwable)e);
        }
        return retMap;
    }

    public static String getOperatorBrandMatch(String operator, String brand, String trade) {
        if (trade != null && trade.equals("16")) {
            if (operator == null || brand == null) {
                return "0";
            }
            if (operator.equals(brand)) {
                return "1";
            }
            return "2";
        }
        return "4";
    }

    public static String getOperatorName(String op) {
        if (op == null) {
            return "\u672a\u77e5";
        }
        if (op.equals("1")) {
            return "\u79fb\u52a8";
        }
        if (op.equals("2")) {
            return "\u8054\u901a";
        }
        if (op.equals("3")) {
            return "\u7535\u4fe1";
        }
        return "\u672a\u77e5";
    }

    public static void main(String[] args) {
    }
}

